; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint,+f -o - %s \
; RUN:   -verify-machineinstrs | FileCheck --check-prefix=QCI-F %s

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+experimental-xqciint,+d -o - %s \
; RUN:   -verify-machineinstrs | FileCheck --check-prefix=QCI-D %s

;; This tests "interrupt"="qci-nest" and "interrupt"="qci-nonest" frame lowering
;; including CFI information, and floating point registers. These tests should
;; all lack `nounwind`.
;;
;; When `+save-restore` is enabled, the codegen should be identical as these
;; calls are incompatible with the interrupt attribute because the restore is
;; tail-called.

declare void @use_i32(i32)

define void @test_nest_asm() "interrupt"="qci-nest" {
; QCI-F-LABEL: test_nest_asm:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter.nest
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -80
; QCI-F-NEXT:    .cfi_def_cfa_offset 176
; QCI-F-NEXT:    fsw ft0, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft1, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft2, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft3, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft4, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft5, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft6, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft7, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa0, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa1, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa2, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa3, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa4, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa5, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa6, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa7, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset ft0, -100
; QCI-F-NEXT:    .cfi_offset ft1, -104
; QCI-F-NEXT:    .cfi_offset ft2, -108
; QCI-F-NEXT:    .cfi_offset ft3, -112
; QCI-F-NEXT:    .cfi_offset ft4, -116
; QCI-F-NEXT:    .cfi_offset ft5, -120
; QCI-F-NEXT:    .cfi_offset ft6, -124
; QCI-F-NEXT:    .cfi_offset ft7, -128
; QCI-F-NEXT:    .cfi_offset fa0, -132
; QCI-F-NEXT:    .cfi_offset fa1, -136
; QCI-F-NEXT:    .cfi_offset fa2, -140
; QCI-F-NEXT:    .cfi_offset fa3, -144
; QCI-F-NEXT:    .cfi_offset fa4, -148
; QCI-F-NEXT:    .cfi_offset fa5, -152
; QCI-F-NEXT:    .cfi_offset fa6, -156
; QCI-F-NEXT:    .cfi_offset fa7, -160
; QCI-F-NEXT:    .cfi_offset ft8, -164
; QCI-F-NEXT:    .cfi_offset ft9, -168
; QCI-F-NEXT:    .cfi_offset ft10, -172
; QCI-F-NEXT:    .cfi_offset ft11, -176
; QCI-F-NEXT:    li a0, 1
; QCI-F-NEXT:    #APP
; QCI-F-NEXT:    # a0 <- a0
; QCI-F-NEXT:    #NO_APP
; QCI-F-NEXT:    call use_i32
; QCI-F-NEXT:    flw ft0, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft1, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft2, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft3, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft4, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft5, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft6, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft7, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa0, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa1, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa2, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa3, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa4, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa5, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa6, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa7, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore ft0
; QCI-F-NEXT:    .cfi_restore ft1
; QCI-F-NEXT:    .cfi_restore ft2
; QCI-F-NEXT:    .cfi_restore ft3
; QCI-F-NEXT:    .cfi_restore ft4
; QCI-F-NEXT:    .cfi_restore ft5
; QCI-F-NEXT:    .cfi_restore ft6
; QCI-F-NEXT:    .cfi_restore ft7
; QCI-F-NEXT:    .cfi_restore fa0
; QCI-F-NEXT:    .cfi_restore fa1
; QCI-F-NEXT:    .cfi_restore fa2
; QCI-F-NEXT:    .cfi_restore fa3
; QCI-F-NEXT:    .cfi_restore fa4
; QCI-F-NEXT:    .cfi_restore fa5
; QCI-F-NEXT:    .cfi_restore fa6
; QCI-F-NEXT:    .cfi_restore fa7
; QCI-F-NEXT:    .cfi_restore ft8
; QCI-F-NEXT:    .cfi_restore ft9
; QCI-F-NEXT:    .cfi_restore ft10
; QCI-F-NEXT:    .cfi_restore ft11
; QCI-F-NEXT:    addi sp, sp, 80
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_nest_asm:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter.nest
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -160
; QCI-D-NEXT:    .cfi_def_cfa_offset 256
; QCI-D-NEXT:    fsd ft0, 152(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft1, 144(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft2, 136(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft3, 128(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft4, 120(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft5, 112(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft6, 104(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft7, 96(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa0, 88(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa1, 80(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa2, 72(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa3, 64(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa4, 56(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa5, 48(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa6, 40(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa7, 32(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset ft0, -104
; QCI-D-NEXT:    .cfi_offset ft1, -112
; QCI-D-NEXT:    .cfi_offset ft2, -120
; QCI-D-NEXT:    .cfi_offset ft3, -128
; QCI-D-NEXT:    .cfi_offset ft4, -136
; QCI-D-NEXT:    .cfi_offset ft5, -144
; QCI-D-NEXT:    .cfi_offset ft6, -152
; QCI-D-NEXT:    .cfi_offset ft7, -160
; QCI-D-NEXT:    .cfi_offset fa0, -168
; QCI-D-NEXT:    .cfi_offset fa1, -176
; QCI-D-NEXT:    .cfi_offset fa2, -184
; QCI-D-NEXT:    .cfi_offset fa3, -192
; QCI-D-NEXT:    .cfi_offset fa4, -200
; QCI-D-NEXT:    .cfi_offset fa5, -208
; QCI-D-NEXT:    .cfi_offset fa6, -216
; QCI-D-NEXT:    .cfi_offset fa7, -224
; QCI-D-NEXT:    .cfi_offset ft8, -232
; QCI-D-NEXT:    .cfi_offset ft9, -240
; QCI-D-NEXT:    .cfi_offset ft10, -248
; QCI-D-NEXT:    .cfi_offset ft11, -256
; QCI-D-NEXT:    li a0, 1
; QCI-D-NEXT:    #APP
; QCI-D-NEXT:    # a0 <- a0
; QCI-D-NEXT:    #NO_APP
; QCI-D-NEXT:    call use_i32
; QCI-D-NEXT:    fld ft0, 152(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft1, 144(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft2, 136(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft3, 128(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft4, 120(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft5, 112(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft6, 104(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft7, 96(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa0, 88(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa1, 80(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa2, 72(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa3, 64(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa4, 56(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa5, 48(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa6, 40(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa7, 32(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore ft0
; QCI-D-NEXT:    .cfi_restore ft1
; QCI-D-NEXT:    .cfi_restore ft2
; QCI-D-NEXT:    .cfi_restore ft3
; QCI-D-NEXT:    .cfi_restore ft4
; QCI-D-NEXT:    .cfi_restore ft5
; QCI-D-NEXT:    .cfi_restore ft6
; QCI-D-NEXT:    .cfi_restore ft7
; QCI-D-NEXT:    .cfi_restore fa0
; QCI-D-NEXT:    .cfi_restore fa1
; QCI-D-NEXT:    .cfi_restore fa2
; QCI-D-NEXT:    .cfi_restore fa3
; QCI-D-NEXT:    .cfi_restore fa4
; QCI-D-NEXT:    .cfi_restore fa5
; QCI-D-NEXT:    .cfi_restore fa6
; QCI-D-NEXT:    .cfi_restore fa7
; QCI-D-NEXT:    .cfi_restore ft8
; QCI-D-NEXT:    .cfi_restore ft9
; QCI-D-NEXT:    .cfi_restore ft10
; QCI-D-NEXT:    .cfi_restore ft11
; QCI-D-NEXT:    addi sp, sp, 160
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = call i32 asm sideeffect "/* $0 <- $1 */", "=r,r"(i32 1)
  call void @use_i32(i32 %1)
  ret void
}

define void @test_nonest_asm() "interrupt"="qci-nonest" {
; QCI-F-LABEL: test_nonest_asm:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -80
; QCI-F-NEXT:    .cfi_def_cfa_offset 176
; QCI-F-NEXT:    fsw ft0, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft1, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft2, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft3, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft4, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft5, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft6, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft7, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa0, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa1, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa2, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa3, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa4, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa5, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa6, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa7, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset ft0, -100
; QCI-F-NEXT:    .cfi_offset ft1, -104
; QCI-F-NEXT:    .cfi_offset ft2, -108
; QCI-F-NEXT:    .cfi_offset ft3, -112
; QCI-F-NEXT:    .cfi_offset ft4, -116
; QCI-F-NEXT:    .cfi_offset ft5, -120
; QCI-F-NEXT:    .cfi_offset ft6, -124
; QCI-F-NEXT:    .cfi_offset ft7, -128
; QCI-F-NEXT:    .cfi_offset fa0, -132
; QCI-F-NEXT:    .cfi_offset fa1, -136
; QCI-F-NEXT:    .cfi_offset fa2, -140
; QCI-F-NEXT:    .cfi_offset fa3, -144
; QCI-F-NEXT:    .cfi_offset fa4, -148
; QCI-F-NEXT:    .cfi_offset fa5, -152
; QCI-F-NEXT:    .cfi_offset fa6, -156
; QCI-F-NEXT:    .cfi_offset fa7, -160
; QCI-F-NEXT:    .cfi_offset ft8, -164
; QCI-F-NEXT:    .cfi_offset ft9, -168
; QCI-F-NEXT:    .cfi_offset ft10, -172
; QCI-F-NEXT:    .cfi_offset ft11, -176
; QCI-F-NEXT:    li a0, 1
; QCI-F-NEXT:    #APP
; QCI-F-NEXT:    # a0 <- a0
; QCI-F-NEXT:    #NO_APP
; QCI-F-NEXT:    call use_i32
; QCI-F-NEXT:    flw ft0, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft1, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft2, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft3, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft4, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft5, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft6, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft7, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa0, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa1, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa2, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa3, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa4, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa5, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa6, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa7, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore ft0
; QCI-F-NEXT:    .cfi_restore ft1
; QCI-F-NEXT:    .cfi_restore ft2
; QCI-F-NEXT:    .cfi_restore ft3
; QCI-F-NEXT:    .cfi_restore ft4
; QCI-F-NEXT:    .cfi_restore ft5
; QCI-F-NEXT:    .cfi_restore ft6
; QCI-F-NEXT:    .cfi_restore ft7
; QCI-F-NEXT:    .cfi_restore fa0
; QCI-F-NEXT:    .cfi_restore fa1
; QCI-F-NEXT:    .cfi_restore fa2
; QCI-F-NEXT:    .cfi_restore fa3
; QCI-F-NEXT:    .cfi_restore fa4
; QCI-F-NEXT:    .cfi_restore fa5
; QCI-F-NEXT:    .cfi_restore fa6
; QCI-F-NEXT:    .cfi_restore fa7
; QCI-F-NEXT:    .cfi_restore ft8
; QCI-F-NEXT:    .cfi_restore ft9
; QCI-F-NEXT:    .cfi_restore ft10
; QCI-F-NEXT:    .cfi_restore ft11
; QCI-F-NEXT:    addi sp, sp, 80
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_nonest_asm:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -160
; QCI-D-NEXT:    .cfi_def_cfa_offset 256
; QCI-D-NEXT:    fsd ft0, 152(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft1, 144(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft2, 136(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft3, 128(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft4, 120(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft5, 112(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft6, 104(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft7, 96(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa0, 88(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa1, 80(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa2, 72(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa3, 64(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa4, 56(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa5, 48(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa6, 40(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa7, 32(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset ft0, -104
; QCI-D-NEXT:    .cfi_offset ft1, -112
; QCI-D-NEXT:    .cfi_offset ft2, -120
; QCI-D-NEXT:    .cfi_offset ft3, -128
; QCI-D-NEXT:    .cfi_offset ft4, -136
; QCI-D-NEXT:    .cfi_offset ft5, -144
; QCI-D-NEXT:    .cfi_offset ft6, -152
; QCI-D-NEXT:    .cfi_offset ft7, -160
; QCI-D-NEXT:    .cfi_offset fa0, -168
; QCI-D-NEXT:    .cfi_offset fa1, -176
; QCI-D-NEXT:    .cfi_offset fa2, -184
; QCI-D-NEXT:    .cfi_offset fa3, -192
; QCI-D-NEXT:    .cfi_offset fa4, -200
; QCI-D-NEXT:    .cfi_offset fa5, -208
; QCI-D-NEXT:    .cfi_offset fa6, -216
; QCI-D-NEXT:    .cfi_offset fa7, -224
; QCI-D-NEXT:    .cfi_offset ft8, -232
; QCI-D-NEXT:    .cfi_offset ft9, -240
; QCI-D-NEXT:    .cfi_offset ft10, -248
; QCI-D-NEXT:    .cfi_offset ft11, -256
; QCI-D-NEXT:    li a0, 1
; QCI-D-NEXT:    #APP
; QCI-D-NEXT:    # a0 <- a0
; QCI-D-NEXT:    #NO_APP
; QCI-D-NEXT:    call use_i32
; QCI-D-NEXT:    fld ft0, 152(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft1, 144(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft2, 136(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft3, 128(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft4, 120(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft5, 112(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft6, 104(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft7, 96(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa0, 88(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa1, 80(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa2, 72(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa3, 64(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa4, 56(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa5, 48(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa6, 40(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa7, 32(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore ft0
; QCI-D-NEXT:    .cfi_restore ft1
; QCI-D-NEXT:    .cfi_restore ft2
; QCI-D-NEXT:    .cfi_restore ft3
; QCI-D-NEXT:    .cfi_restore ft4
; QCI-D-NEXT:    .cfi_restore ft5
; QCI-D-NEXT:    .cfi_restore ft6
; QCI-D-NEXT:    .cfi_restore ft7
; QCI-D-NEXT:    .cfi_restore fa0
; QCI-D-NEXT:    .cfi_restore fa1
; QCI-D-NEXT:    .cfi_restore fa2
; QCI-D-NEXT:    .cfi_restore fa3
; QCI-D-NEXT:    .cfi_restore fa4
; QCI-D-NEXT:    .cfi_restore fa5
; QCI-D-NEXT:    .cfi_restore fa6
; QCI-D-NEXT:    .cfi_restore fa7
; QCI-D-NEXT:    .cfi_restore ft8
; QCI-D-NEXT:    .cfi_restore ft9
; QCI-D-NEXT:    .cfi_restore ft10
; QCI-D-NEXT:    .cfi_restore ft11
; QCI-D-NEXT:    addi sp, sp, 160
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = call i32 asm sideeffect "/* $0 <- $1 */", "=r,r"(i32 1)
  call void @use_i32(i32 %1)
  ret void
}

declare float @function_with_one_stack_arg(i64, i64, i64, i64, float, float, float, float, float, float, float, float, i32, float)
declare void @use_float(float)

define void @test_nest_call() "interrupt"="qci-nest" {
; QCI-F-LABEL: test_nest_call:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter.nest
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -96
; QCI-F-NEXT:    .cfi_def_cfa_offset 192
; QCI-F-NEXT:    fsw ft0, 92(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft1, 88(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft2, 84(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft3, 80(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft4, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft5, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft6, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft7, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa0, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa1, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa2, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa3, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa4, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa5, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa6, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa7, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft8, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft9, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft10, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft11, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset ft0, -100
; QCI-F-NEXT:    .cfi_offset ft1, -104
; QCI-F-NEXT:    .cfi_offset ft2, -108
; QCI-F-NEXT:    .cfi_offset ft3, -112
; QCI-F-NEXT:    .cfi_offset ft4, -116
; QCI-F-NEXT:    .cfi_offset ft5, -120
; QCI-F-NEXT:    .cfi_offset ft6, -124
; QCI-F-NEXT:    .cfi_offset ft7, -128
; QCI-F-NEXT:    .cfi_offset fa0, -132
; QCI-F-NEXT:    .cfi_offset fa1, -136
; QCI-F-NEXT:    .cfi_offset fa2, -140
; QCI-F-NEXT:    .cfi_offset fa3, -144
; QCI-F-NEXT:    .cfi_offset fa4, -148
; QCI-F-NEXT:    .cfi_offset fa5, -152
; QCI-F-NEXT:    .cfi_offset fa6, -156
; QCI-F-NEXT:    .cfi_offset fa7, -160
; QCI-F-NEXT:    .cfi_offset ft8, -164
; QCI-F-NEXT:    .cfi_offset ft9, -168
; QCI-F-NEXT:    .cfi_offset ft10, -172
; QCI-F-NEXT:    .cfi_offset ft11, -176
; QCI-F-NEXT:    lui a7, 266496
; QCI-F-NEXT:    li t0, 5
; QCI-F-NEXT:    lui a0, 260096
; QCI-F-NEXT:    lui a2, 262144
; QCI-F-NEXT:    lui a4, 263168
; QCI-F-NEXT:    lui a5, 264192
; QCI-F-NEXT:    lui a1, 264704
; QCI-F-NEXT:    lui a6, 265216
; QCI-F-NEXT:    fmv.w.x fa0, a0
; QCI-F-NEXT:    lui t1, 265728
; QCI-F-NEXT:    fmv.w.x fa1, a2
; QCI-F-NEXT:    lui a3, 266240
; QCI-F-NEXT:    fmv.w.x fa2, a4
; QCI-F-NEXT:    li a0, 1
; QCI-F-NEXT:    fmv.w.x fa3, a5
; QCI-F-NEXT:    li a2, 2
; QCI-F-NEXT:    fmv.w.x fa4, a1
; QCI-F-NEXT:    li a4, 3
; QCI-F-NEXT:    fmv.w.x fa5, a6
; QCI-F-NEXT:    li a6, 4
; QCI-F-NEXT:    fmv.w.x fa6, t1
; QCI-F-NEXT:    fmv.w.x fa7, a3
; QCI-F-NEXT:    sw t0, 0(sp)
; QCI-F-NEXT:    sw a7, 4(sp)
; QCI-F-NEXT:    li a1, 0
; QCI-F-NEXT:    li a3, 0
; QCI-F-NEXT:    li a5, 0
; QCI-F-NEXT:    li a7, 0
; QCI-F-NEXT:    call function_with_one_stack_arg
; QCI-F-NEXT:    call use_float
; QCI-F-NEXT:    flw ft0, 92(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft1, 88(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft2, 84(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft3, 80(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft4, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft5, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft6, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft7, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa0, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa1, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa2, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa3, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa4, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa5, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa6, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa7, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft8, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft9, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft10, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft11, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore ft0
; QCI-F-NEXT:    .cfi_restore ft1
; QCI-F-NEXT:    .cfi_restore ft2
; QCI-F-NEXT:    .cfi_restore ft3
; QCI-F-NEXT:    .cfi_restore ft4
; QCI-F-NEXT:    .cfi_restore ft5
; QCI-F-NEXT:    .cfi_restore ft6
; QCI-F-NEXT:    .cfi_restore ft7
; QCI-F-NEXT:    .cfi_restore fa0
; QCI-F-NEXT:    .cfi_restore fa1
; QCI-F-NEXT:    .cfi_restore fa2
; QCI-F-NEXT:    .cfi_restore fa3
; QCI-F-NEXT:    .cfi_restore fa4
; QCI-F-NEXT:    .cfi_restore fa5
; QCI-F-NEXT:    .cfi_restore fa6
; QCI-F-NEXT:    .cfi_restore fa7
; QCI-F-NEXT:    .cfi_restore ft8
; QCI-F-NEXT:    .cfi_restore ft9
; QCI-F-NEXT:    .cfi_restore ft10
; QCI-F-NEXT:    .cfi_restore ft11
; QCI-F-NEXT:    addi sp, sp, 96
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_nest_call:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter.nest
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -176
; QCI-D-NEXT:    .cfi_def_cfa_offset 272
; QCI-D-NEXT:    fsd ft0, 168(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft1, 160(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft2, 152(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft3, 144(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft4, 136(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft5, 128(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft6, 120(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft7, 112(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa0, 104(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa1, 96(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa2, 88(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa3, 80(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa4, 72(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa5, 64(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa6, 56(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa7, 48(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft8, 40(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft9, 32(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft10, 24(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft11, 16(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset ft0, -104
; QCI-D-NEXT:    .cfi_offset ft1, -112
; QCI-D-NEXT:    .cfi_offset ft2, -120
; QCI-D-NEXT:    .cfi_offset ft3, -128
; QCI-D-NEXT:    .cfi_offset ft4, -136
; QCI-D-NEXT:    .cfi_offset ft5, -144
; QCI-D-NEXT:    .cfi_offset ft6, -152
; QCI-D-NEXT:    .cfi_offset ft7, -160
; QCI-D-NEXT:    .cfi_offset fa0, -168
; QCI-D-NEXT:    .cfi_offset fa1, -176
; QCI-D-NEXT:    .cfi_offset fa2, -184
; QCI-D-NEXT:    .cfi_offset fa3, -192
; QCI-D-NEXT:    .cfi_offset fa4, -200
; QCI-D-NEXT:    .cfi_offset fa5, -208
; QCI-D-NEXT:    .cfi_offset fa6, -216
; QCI-D-NEXT:    .cfi_offset fa7, -224
; QCI-D-NEXT:    .cfi_offset ft8, -232
; QCI-D-NEXT:    .cfi_offset ft9, -240
; QCI-D-NEXT:    .cfi_offset ft10, -248
; QCI-D-NEXT:    .cfi_offset ft11, -256
; QCI-D-NEXT:    lui a7, 266496
; QCI-D-NEXT:    li t0, 5
; QCI-D-NEXT:    lui a0, 260096
; QCI-D-NEXT:    lui a2, 262144
; QCI-D-NEXT:    lui a4, 263168
; QCI-D-NEXT:    lui a5, 264192
; QCI-D-NEXT:    lui a1, 264704
; QCI-D-NEXT:    lui a6, 265216
; QCI-D-NEXT:    fmv.w.x fa0, a0
; QCI-D-NEXT:    lui t1, 265728
; QCI-D-NEXT:    fmv.w.x fa1, a2
; QCI-D-NEXT:    lui a3, 266240
; QCI-D-NEXT:    fmv.w.x fa2, a4
; QCI-D-NEXT:    li a0, 1
; QCI-D-NEXT:    fmv.w.x fa3, a5
; QCI-D-NEXT:    li a2, 2
; QCI-D-NEXT:    fmv.w.x fa4, a1
; QCI-D-NEXT:    li a4, 3
; QCI-D-NEXT:    fmv.w.x fa5, a6
; QCI-D-NEXT:    li a6, 4
; QCI-D-NEXT:    fmv.w.x fa6, t1
; QCI-D-NEXT:    fmv.w.x fa7, a3
; QCI-D-NEXT:    sw t0, 0(sp)
; QCI-D-NEXT:    sw a7, 4(sp)
; QCI-D-NEXT:    li a1, 0
; QCI-D-NEXT:    li a3, 0
; QCI-D-NEXT:    li a5, 0
; QCI-D-NEXT:    li a7, 0
; QCI-D-NEXT:    call function_with_one_stack_arg
; QCI-D-NEXT:    call use_float
; QCI-D-NEXT:    fld ft0, 168(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft1, 160(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft2, 152(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft3, 144(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft4, 136(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft5, 128(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft6, 120(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft7, 112(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa0, 104(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa1, 96(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa2, 88(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa3, 80(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa4, 72(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa5, 64(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa6, 56(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa7, 48(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft8, 40(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft9, 32(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft10, 24(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft11, 16(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore ft0
; QCI-D-NEXT:    .cfi_restore ft1
; QCI-D-NEXT:    .cfi_restore ft2
; QCI-D-NEXT:    .cfi_restore ft3
; QCI-D-NEXT:    .cfi_restore ft4
; QCI-D-NEXT:    .cfi_restore ft5
; QCI-D-NEXT:    .cfi_restore ft6
; QCI-D-NEXT:    .cfi_restore ft7
; QCI-D-NEXT:    .cfi_restore fa0
; QCI-D-NEXT:    .cfi_restore fa1
; QCI-D-NEXT:    .cfi_restore fa2
; QCI-D-NEXT:    .cfi_restore fa3
; QCI-D-NEXT:    .cfi_restore fa4
; QCI-D-NEXT:    .cfi_restore fa5
; QCI-D-NEXT:    .cfi_restore fa6
; QCI-D-NEXT:    .cfi_restore fa7
; QCI-D-NEXT:    .cfi_restore ft8
; QCI-D-NEXT:    .cfi_restore ft9
; QCI-D-NEXT:    .cfi_restore ft10
; QCI-D-NEXT:    .cfi_restore ft11
; QCI-D-NEXT:    addi sp, sp, 176
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = call float @function_with_one_stack_arg(i64 1, i64 2, i64 3, i64 4, float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0, i32 5, float 9.0)
  call void @use_float(float %1)
  ret void
}

define void @test_nonest_call() "interrupt"="qci-nonest" {
; QCI-F-LABEL: test_nonest_call:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -96
; QCI-F-NEXT:    .cfi_def_cfa_offset 192
; QCI-F-NEXT:    fsw ft0, 92(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft1, 88(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft2, 84(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft3, 80(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft4, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft5, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft6, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft7, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa0, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa1, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa2, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa3, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa4, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa5, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa6, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa7, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft8, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft9, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft10, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft11, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset ft0, -100
; QCI-F-NEXT:    .cfi_offset ft1, -104
; QCI-F-NEXT:    .cfi_offset ft2, -108
; QCI-F-NEXT:    .cfi_offset ft3, -112
; QCI-F-NEXT:    .cfi_offset ft4, -116
; QCI-F-NEXT:    .cfi_offset ft5, -120
; QCI-F-NEXT:    .cfi_offset ft6, -124
; QCI-F-NEXT:    .cfi_offset ft7, -128
; QCI-F-NEXT:    .cfi_offset fa0, -132
; QCI-F-NEXT:    .cfi_offset fa1, -136
; QCI-F-NEXT:    .cfi_offset fa2, -140
; QCI-F-NEXT:    .cfi_offset fa3, -144
; QCI-F-NEXT:    .cfi_offset fa4, -148
; QCI-F-NEXT:    .cfi_offset fa5, -152
; QCI-F-NEXT:    .cfi_offset fa6, -156
; QCI-F-NEXT:    .cfi_offset fa7, -160
; QCI-F-NEXT:    .cfi_offset ft8, -164
; QCI-F-NEXT:    .cfi_offset ft9, -168
; QCI-F-NEXT:    .cfi_offset ft10, -172
; QCI-F-NEXT:    .cfi_offset ft11, -176
; QCI-F-NEXT:    lui a7, 266496
; QCI-F-NEXT:    li t0, 5
; QCI-F-NEXT:    lui a0, 260096
; QCI-F-NEXT:    lui a2, 262144
; QCI-F-NEXT:    lui a4, 263168
; QCI-F-NEXT:    lui a5, 264192
; QCI-F-NEXT:    lui a1, 264704
; QCI-F-NEXT:    lui a6, 265216
; QCI-F-NEXT:    fmv.w.x fa0, a0
; QCI-F-NEXT:    lui t1, 265728
; QCI-F-NEXT:    fmv.w.x fa1, a2
; QCI-F-NEXT:    lui a3, 266240
; QCI-F-NEXT:    fmv.w.x fa2, a4
; QCI-F-NEXT:    li a0, 1
; QCI-F-NEXT:    fmv.w.x fa3, a5
; QCI-F-NEXT:    li a2, 2
; QCI-F-NEXT:    fmv.w.x fa4, a1
; QCI-F-NEXT:    li a4, 3
; QCI-F-NEXT:    fmv.w.x fa5, a6
; QCI-F-NEXT:    li a6, 4
; QCI-F-NEXT:    fmv.w.x fa6, t1
; QCI-F-NEXT:    fmv.w.x fa7, a3
; QCI-F-NEXT:    sw t0, 0(sp)
; QCI-F-NEXT:    sw a7, 4(sp)
; QCI-F-NEXT:    li a1, 0
; QCI-F-NEXT:    li a3, 0
; QCI-F-NEXT:    li a5, 0
; QCI-F-NEXT:    li a7, 0
; QCI-F-NEXT:    call function_with_one_stack_arg
; QCI-F-NEXT:    call use_float
; QCI-F-NEXT:    flw ft0, 92(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft1, 88(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft2, 84(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft3, 80(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft4, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft5, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft6, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft7, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa0, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa1, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa2, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa3, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa4, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa5, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa6, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa7, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft8, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft9, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft10, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft11, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore ft0
; QCI-F-NEXT:    .cfi_restore ft1
; QCI-F-NEXT:    .cfi_restore ft2
; QCI-F-NEXT:    .cfi_restore ft3
; QCI-F-NEXT:    .cfi_restore ft4
; QCI-F-NEXT:    .cfi_restore ft5
; QCI-F-NEXT:    .cfi_restore ft6
; QCI-F-NEXT:    .cfi_restore ft7
; QCI-F-NEXT:    .cfi_restore fa0
; QCI-F-NEXT:    .cfi_restore fa1
; QCI-F-NEXT:    .cfi_restore fa2
; QCI-F-NEXT:    .cfi_restore fa3
; QCI-F-NEXT:    .cfi_restore fa4
; QCI-F-NEXT:    .cfi_restore fa5
; QCI-F-NEXT:    .cfi_restore fa6
; QCI-F-NEXT:    .cfi_restore fa7
; QCI-F-NEXT:    .cfi_restore ft8
; QCI-F-NEXT:    .cfi_restore ft9
; QCI-F-NEXT:    .cfi_restore ft10
; QCI-F-NEXT:    .cfi_restore ft11
; QCI-F-NEXT:    addi sp, sp, 96
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_nonest_call:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -176
; QCI-D-NEXT:    .cfi_def_cfa_offset 272
; QCI-D-NEXT:    fsd ft0, 168(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft1, 160(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft2, 152(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft3, 144(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft4, 136(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft5, 128(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft6, 120(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft7, 112(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa0, 104(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa1, 96(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa2, 88(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa3, 80(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa4, 72(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa5, 64(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa6, 56(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa7, 48(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft8, 40(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft9, 32(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft10, 24(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft11, 16(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset ft0, -104
; QCI-D-NEXT:    .cfi_offset ft1, -112
; QCI-D-NEXT:    .cfi_offset ft2, -120
; QCI-D-NEXT:    .cfi_offset ft3, -128
; QCI-D-NEXT:    .cfi_offset ft4, -136
; QCI-D-NEXT:    .cfi_offset ft5, -144
; QCI-D-NEXT:    .cfi_offset ft6, -152
; QCI-D-NEXT:    .cfi_offset ft7, -160
; QCI-D-NEXT:    .cfi_offset fa0, -168
; QCI-D-NEXT:    .cfi_offset fa1, -176
; QCI-D-NEXT:    .cfi_offset fa2, -184
; QCI-D-NEXT:    .cfi_offset fa3, -192
; QCI-D-NEXT:    .cfi_offset fa4, -200
; QCI-D-NEXT:    .cfi_offset fa5, -208
; QCI-D-NEXT:    .cfi_offset fa6, -216
; QCI-D-NEXT:    .cfi_offset fa7, -224
; QCI-D-NEXT:    .cfi_offset ft8, -232
; QCI-D-NEXT:    .cfi_offset ft9, -240
; QCI-D-NEXT:    .cfi_offset ft10, -248
; QCI-D-NEXT:    .cfi_offset ft11, -256
; QCI-D-NEXT:    lui a7, 266496
; QCI-D-NEXT:    li t0, 5
; QCI-D-NEXT:    lui a0, 260096
; QCI-D-NEXT:    lui a2, 262144
; QCI-D-NEXT:    lui a4, 263168
; QCI-D-NEXT:    lui a5, 264192
; QCI-D-NEXT:    lui a1, 264704
; QCI-D-NEXT:    lui a6, 265216
; QCI-D-NEXT:    fmv.w.x fa0, a0
; QCI-D-NEXT:    lui t1, 265728
; QCI-D-NEXT:    fmv.w.x fa1, a2
; QCI-D-NEXT:    lui a3, 266240
; QCI-D-NEXT:    fmv.w.x fa2, a4
; QCI-D-NEXT:    li a0, 1
; QCI-D-NEXT:    fmv.w.x fa3, a5
; QCI-D-NEXT:    li a2, 2
; QCI-D-NEXT:    fmv.w.x fa4, a1
; QCI-D-NEXT:    li a4, 3
; QCI-D-NEXT:    fmv.w.x fa5, a6
; QCI-D-NEXT:    li a6, 4
; QCI-D-NEXT:    fmv.w.x fa6, t1
; QCI-D-NEXT:    fmv.w.x fa7, a3
; QCI-D-NEXT:    sw t0, 0(sp)
; QCI-D-NEXT:    sw a7, 4(sp)
; QCI-D-NEXT:    li a1, 0
; QCI-D-NEXT:    li a3, 0
; QCI-D-NEXT:    li a5, 0
; QCI-D-NEXT:    li a7, 0
; QCI-D-NEXT:    call function_with_one_stack_arg
; QCI-D-NEXT:    call use_float
; QCI-D-NEXT:    fld ft0, 168(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft1, 160(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft2, 152(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft3, 144(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft4, 136(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft5, 128(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft6, 120(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft7, 112(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa0, 104(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa1, 96(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa2, 88(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa3, 80(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa4, 72(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa5, 64(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa6, 56(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa7, 48(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft8, 40(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft9, 32(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft10, 24(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft11, 16(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore ft0
; QCI-D-NEXT:    .cfi_restore ft1
; QCI-D-NEXT:    .cfi_restore ft2
; QCI-D-NEXT:    .cfi_restore ft3
; QCI-D-NEXT:    .cfi_restore ft4
; QCI-D-NEXT:    .cfi_restore ft5
; QCI-D-NEXT:    .cfi_restore ft6
; QCI-D-NEXT:    .cfi_restore ft7
; QCI-D-NEXT:    .cfi_restore fa0
; QCI-D-NEXT:    .cfi_restore fa1
; QCI-D-NEXT:    .cfi_restore fa2
; QCI-D-NEXT:    .cfi_restore fa3
; QCI-D-NEXT:    .cfi_restore fa4
; QCI-D-NEXT:    .cfi_restore fa5
; QCI-D-NEXT:    .cfi_restore fa6
; QCI-D-NEXT:    .cfi_restore fa7
; QCI-D-NEXT:    .cfi_restore ft8
; QCI-D-NEXT:    .cfi_restore ft9
; QCI-D-NEXT:    .cfi_restore ft10
; QCI-D-NEXT:    .cfi_restore ft11
; QCI-D-NEXT:    addi sp, sp, 176
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = call float @function_with_one_stack_arg(i64 1, i64 2, i64 3, i64 4, float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0, i32 5, float 9.0)
  call void @use_float(float %1)
  ret void
}

@var = global [32 x i32] zeroinitializer

define void @test_spill_nest() "interrupt"="qci-nest" {
; QCI-F-LABEL: test_spill_nest:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter.nest
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -80
; QCI-F-NEXT:    .cfi_def_cfa_offset 176
; QCI-F-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset s1, -100
; QCI-F-NEXT:    .cfi_offset s2, -104
; QCI-F-NEXT:    .cfi_offset s3, -108
; QCI-F-NEXT:    .cfi_offset s4, -112
; QCI-F-NEXT:    .cfi_offset s5, -116
; QCI-F-NEXT:    .cfi_offset s6, -120
; QCI-F-NEXT:    .cfi_offset s7, -124
; QCI-F-NEXT:    .cfi_offset s8, -128
; QCI-F-NEXT:    .cfi_offset s9, -132
; QCI-F-NEXT:    .cfi_offset s10, -136
; QCI-F-NEXT:    .cfi_offset s11, -140
; QCI-F-NEXT:    lui t0, %hi(var)
; QCI-F-NEXT:    lw a0, %lo(var)(t0)
; QCI-F-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-F-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-F-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-F-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    addi a5, t0, %lo(var)
; QCI-F-NEXT:    lw a0, 16(a5)
; QCI-F-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 20(a5)
; QCI-F-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw t4, 24(a5)
; QCI-F-NEXT:    lw t5, 28(a5)
; QCI-F-NEXT:    lw t6, 32(a5)
; QCI-F-NEXT:    lw s2, 36(a5)
; QCI-F-NEXT:    lw s3, 40(a5)
; QCI-F-NEXT:    lw s4, 44(a5)
; QCI-F-NEXT:    lw s5, 48(a5)
; QCI-F-NEXT:    lw s6, 52(a5)
; QCI-F-NEXT:    lw s7, 56(a5)
; QCI-F-NEXT:    lw s8, 60(a5)
; QCI-F-NEXT:    lw s9, 64(a5)
; QCI-F-NEXT:    lw s10, 68(a5)
; QCI-F-NEXT:    lw s11, 72(a5)
; QCI-F-NEXT:    lw ra, 76(a5)
; QCI-F-NEXT:    lw s1, 80(a5)
; QCI-F-NEXT:    lw t3, 84(a5)
; QCI-F-NEXT:    lw t2, 88(a5)
; QCI-F-NEXT:    lw t1, 92(a5)
; QCI-F-NEXT:    lw a7, 112(a5)
; QCI-F-NEXT:    lw s0, 116(a5)
; QCI-F-NEXT:    lw a3, 120(a5)
; QCI-F-NEXT:    lw a0, 124(a5)
; QCI-F-NEXT:    lw a6, 96(a5)
; QCI-F-NEXT:    lw a4, 100(a5)
; QCI-F-NEXT:    lw a2, 104(a5)
; QCI-F-NEXT:    lw a1, 108(a5)
; QCI-F-NEXT:    sw a0, 124(a5)
; QCI-F-NEXT:    sw a3, 120(a5)
; QCI-F-NEXT:    sw s0, 116(a5)
; QCI-F-NEXT:    sw a7, 112(a5)
; QCI-F-NEXT:    sw a1, 108(a5)
; QCI-F-NEXT:    sw a2, 104(a5)
; QCI-F-NEXT:    sw a4, 100(a5)
; QCI-F-NEXT:    sw a6, 96(a5)
; QCI-F-NEXT:    sw t1, 92(a5)
; QCI-F-NEXT:    sw t2, 88(a5)
; QCI-F-NEXT:    sw t3, 84(a5)
; QCI-F-NEXT:    sw s1, 80(a5)
; QCI-F-NEXT:    sw ra, 76(a5)
; QCI-F-NEXT:    sw s11, 72(a5)
; QCI-F-NEXT:    sw s10, 68(a5)
; QCI-F-NEXT:    sw s9, 64(a5)
; QCI-F-NEXT:    sw s8, 60(a5)
; QCI-F-NEXT:    sw s7, 56(a5)
; QCI-F-NEXT:    sw s6, 52(a5)
; QCI-F-NEXT:    sw s5, 48(a5)
; QCI-F-NEXT:    sw s4, 44(a5)
; QCI-F-NEXT:    sw s3, 40(a5)
; QCI-F-NEXT:    sw s2, 36(a5)
; QCI-F-NEXT:    sw t6, 32(a5)
; QCI-F-NEXT:    sw t5, 28(a5)
; QCI-F-NEXT:    sw t4, 24(a5)
; QCI-F-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 20(a5)
; QCI-F-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 16(a5)
; QCI-F-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-F-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-F-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-F-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var)(t0)
; QCI-F-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore s1
; QCI-F-NEXT:    .cfi_restore s2
; QCI-F-NEXT:    .cfi_restore s3
; QCI-F-NEXT:    .cfi_restore s4
; QCI-F-NEXT:    .cfi_restore s5
; QCI-F-NEXT:    .cfi_restore s6
; QCI-F-NEXT:    .cfi_restore s7
; QCI-F-NEXT:    .cfi_restore s8
; QCI-F-NEXT:    .cfi_restore s9
; QCI-F-NEXT:    .cfi_restore s10
; QCI-F-NEXT:    .cfi_restore s11
; QCI-F-NEXT:    addi sp, sp, 80
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_spill_nest:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter.nest
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -80
; QCI-D-NEXT:    .cfi_def_cfa_offset 176
; QCI-D-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset s1, -100
; QCI-D-NEXT:    .cfi_offset s2, -104
; QCI-D-NEXT:    .cfi_offset s3, -108
; QCI-D-NEXT:    .cfi_offset s4, -112
; QCI-D-NEXT:    .cfi_offset s5, -116
; QCI-D-NEXT:    .cfi_offset s6, -120
; QCI-D-NEXT:    .cfi_offset s7, -124
; QCI-D-NEXT:    .cfi_offset s8, -128
; QCI-D-NEXT:    .cfi_offset s9, -132
; QCI-D-NEXT:    .cfi_offset s10, -136
; QCI-D-NEXT:    .cfi_offset s11, -140
; QCI-D-NEXT:    lui t0, %hi(var)
; QCI-D-NEXT:    lw a0, %lo(var)(t0)
; QCI-D-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-D-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-D-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-D-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    addi a5, t0, %lo(var)
; QCI-D-NEXT:    lw a0, 16(a5)
; QCI-D-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 20(a5)
; QCI-D-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw t4, 24(a5)
; QCI-D-NEXT:    lw t5, 28(a5)
; QCI-D-NEXT:    lw t6, 32(a5)
; QCI-D-NEXT:    lw s2, 36(a5)
; QCI-D-NEXT:    lw s3, 40(a5)
; QCI-D-NEXT:    lw s4, 44(a5)
; QCI-D-NEXT:    lw s5, 48(a5)
; QCI-D-NEXT:    lw s6, 52(a5)
; QCI-D-NEXT:    lw s7, 56(a5)
; QCI-D-NEXT:    lw s8, 60(a5)
; QCI-D-NEXT:    lw s9, 64(a5)
; QCI-D-NEXT:    lw s10, 68(a5)
; QCI-D-NEXT:    lw s11, 72(a5)
; QCI-D-NEXT:    lw ra, 76(a5)
; QCI-D-NEXT:    lw s1, 80(a5)
; QCI-D-NEXT:    lw t3, 84(a5)
; QCI-D-NEXT:    lw t2, 88(a5)
; QCI-D-NEXT:    lw t1, 92(a5)
; QCI-D-NEXT:    lw a7, 112(a5)
; QCI-D-NEXT:    lw s0, 116(a5)
; QCI-D-NEXT:    lw a3, 120(a5)
; QCI-D-NEXT:    lw a0, 124(a5)
; QCI-D-NEXT:    lw a6, 96(a5)
; QCI-D-NEXT:    lw a4, 100(a5)
; QCI-D-NEXT:    lw a2, 104(a5)
; QCI-D-NEXT:    lw a1, 108(a5)
; QCI-D-NEXT:    sw a0, 124(a5)
; QCI-D-NEXT:    sw a3, 120(a5)
; QCI-D-NEXT:    sw s0, 116(a5)
; QCI-D-NEXT:    sw a7, 112(a5)
; QCI-D-NEXT:    sw a1, 108(a5)
; QCI-D-NEXT:    sw a2, 104(a5)
; QCI-D-NEXT:    sw a4, 100(a5)
; QCI-D-NEXT:    sw a6, 96(a5)
; QCI-D-NEXT:    sw t1, 92(a5)
; QCI-D-NEXT:    sw t2, 88(a5)
; QCI-D-NEXT:    sw t3, 84(a5)
; QCI-D-NEXT:    sw s1, 80(a5)
; QCI-D-NEXT:    sw ra, 76(a5)
; QCI-D-NEXT:    sw s11, 72(a5)
; QCI-D-NEXT:    sw s10, 68(a5)
; QCI-D-NEXT:    sw s9, 64(a5)
; QCI-D-NEXT:    sw s8, 60(a5)
; QCI-D-NEXT:    sw s7, 56(a5)
; QCI-D-NEXT:    sw s6, 52(a5)
; QCI-D-NEXT:    sw s5, 48(a5)
; QCI-D-NEXT:    sw s4, 44(a5)
; QCI-D-NEXT:    sw s3, 40(a5)
; QCI-D-NEXT:    sw s2, 36(a5)
; QCI-D-NEXT:    sw t6, 32(a5)
; QCI-D-NEXT:    sw t5, 28(a5)
; QCI-D-NEXT:    sw t4, 24(a5)
; QCI-D-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 20(a5)
; QCI-D-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 16(a5)
; QCI-D-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-D-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-D-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-D-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var)(t0)
; QCI-D-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore s1
; QCI-D-NEXT:    .cfi_restore s2
; QCI-D-NEXT:    .cfi_restore s3
; QCI-D-NEXT:    .cfi_restore s4
; QCI-D-NEXT:    .cfi_restore s5
; QCI-D-NEXT:    .cfi_restore s6
; QCI-D-NEXT:    .cfi_restore s7
; QCI-D-NEXT:    .cfi_restore s8
; QCI-D-NEXT:    .cfi_restore s9
; QCI-D-NEXT:    .cfi_restore s10
; QCI-D-NEXT:    .cfi_restore s11
; QCI-D-NEXT:    addi sp, sp, 80
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  store volatile [32 x i32] %1, ptr @var
  ret void
}

define void @test_spill_nonest() "interrupt"="qci-nonest" {
; QCI-F-LABEL: test_spill_nonest:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -80
; QCI-F-NEXT:    .cfi_def_cfa_offset 176
; QCI-F-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset s1, -100
; QCI-F-NEXT:    .cfi_offset s2, -104
; QCI-F-NEXT:    .cfi_offset s3, -108
; QCI-F-NEXT:    .cfi_offset s4, -112
; QCI-F-NEXT:    .cfi_offset s5, -116
; QCI-F-NEXT:    .cfi_offset s6, -120
; QCI-F-NEXT:    .cfi_offset s7, -124
; QCI-F-NEXT:    .cfi_offset s8, -128
; QCI-F-NEXT:    .cfi_offset s9, -132
; QCI-F-NEXT:    .cfi_offset s10, -136
; QCI-F-NEXT:    .cfi_offset s11, -140
; QCI-F-NEXT:    lui t0, %hi(var)
; QCI-F-NEXT:    lw a0, %lo(var)(t0)
; QCI-F-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-F-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-F-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-F-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    addi a5, t0, %lo(var)
; QCI-F-NEXT:    lw a0, 16(a5)
; QCI-F-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 20(a5)
; QCI-F-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw t4, 24(a5)
; QCI-F-NEXT:    lw t5, 28(a5)
; QCI-F-NEXT:    lw t6, 32(a5)
; QCI-F-NEXT:    lw s2, 36(a5)
; QCI-F-NEXT:    lw s3, 40(a5)
; QCI-F-NEXT:    lw s4, 44(a5)
; QCI-F-NEXT:    lw s5, 48(a5)
; QCI-F-NEXT:    lw s6, 52(a5)
; QCI-F-NEXT:    lw s7, 56(a5)
; QCI-F-NEXT:    lw s8, 60(a5)
; QCI-F-NEXT:    lw s9, 64(a5)
; QCI-F-NEXT:    lw s10, 68(a5)
; QCI-F-NEXT:    lw s11, 72(a5)
; QCI-F-NEXT:    lw ra, 76(a5)
; QCI-F-NEXT:    lw s1, 80(a5)
; QCI-F-NEXT:    lw t3, 84(a5)
; QCI-F-NEXT:    lw t2, 88(a5)
; QCI-F-NEXT:    lw t1, 92(a5)
; QCI-F-NEXT:    lw a7, 112(a5)
; QCI-F-NEXT:    lw s0, 116(a5)
; QCI-F-NEXT:    lw a3, 120(a5)
; QCI-F-NEXT:    lw a0, 124(a5)
; QCI-F-NEXT:    lw a6, 96(a5)
; QCI-F-NEXT:    lw a4, 100(a5)
; QCI-F-NEXT:    lw a2, 104(a5)
; QCI-F-NEXT:    lw a1, 108(a5)
; QCI-F-NEXT:    sw a0, 124(a5)
; QCI-F-NEXT:    sw a3, 120(a5)
; QCI-F-NEXT:    sw s0, 116(a5)
; QCI-F-NEXT:    sw a7, 112(a5)
; QCI-F-NEXT:    sw a1, 108(a5)
; QCI-F-NEXT:    sw a2, 104(a5)
; QCI-F-NEXT:    sw a4, 100(a5)
; QCI-F-NEXT:    sw a6, 96(a5)
; QCI-F-NEXT:    sw t1, 92(a5)
; QCI-F-NEXT:    sw t2, 88(a5)
; QCI-F-NEXT:    sw t3, 84(a5)
; QCI-F-NEXT:    sw s1, 80(a5)
; QCI-F-NEXT:    sw ra, 76(a5)
; QCI-F-NEXT:    sw s11, 72(a5)
; QCI-F-NEXT:    sw s10, 68(a5)
; QCI-F-NEXT:    sw s9, 64(a5)
; QCI-F-NEXT:    sw s8, 60(a5)
; QCI-F-NEXT:    sw s7, 56(a5)
; QCI-F-NEXT:    sw s6, 52(a5)
; QCI-F-NEXT:    sw s5, 48(a5)
; QCI-F-NEXT:    sw s4, 44(a5)
; QCI-F-NEXT:    sw s3, 40(a5)
; QCI-F-NEXT:    sw s2, 36(a5)
; QCI-F-NEXT:    sw t6, 32(a5)
; QCI-F-NEXT:    sw t5, 28(a5)
; QCI-F-NEXT:    sw t4, 24(a5)
; QCI-F-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 20(a5)
; QCI-F-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 16(a5)
; QCI-F-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-F-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-F-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-F-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var)(t0)
; QCI-F-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore s1
; QCI-F-NEXT:    .cfi_restore s2
; QCI-F-NEXT:    .cfi_restore s3
; QCI-F-NEXT:    .cfi_restore s4
; QCI-F-NEXT:    .cfi_restore s5
; QCI-F-NEXT:    .cfi_restore s6
; QCI-F-NEXT:    .cfi_restore s7
; QCI-F-NEXT:    .cfi_restore s8
; QCI-F-NEXT:    .cfi_restore s9
; QCI-F-NEXT:    .cfi_restore s10
; QCI-F-NEXT:    .cfi_restore s11
; QCI-F-NEXT:    addi sp, sp, 80
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_spill_nonest:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -80
; QCI-D-NEXT:    .cfi_def_cfa_offset 176
; QCI-D-NEXT:    sw s1, 76(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s2, 72(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s3, 68(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s4, 64(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s5, 60(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s6, 56(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s7, 52(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s8, 48(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s9, 44(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s10, 40(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s11, 36(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset s1, -100
; QCI-D-NEXT:    .cfi_offset s2, -104
; QCI-D-NEXT:    .cfi_offset s3, -108
; QCI-D-NEXT:    .cfi_offset s4, -112
; QCI-D-NEXT:    .cfi_offset s5, -116
; QCI-D-NEXT:    .cfi_offset s6, -120
; QCI-D-NEXT:    .cfi_offset s7, -124
; QCI-D-NEXT:    .cfi_offset s8, -128
; QCI-D-NEXT:    .cfi_offset s9, -132
; QCI-D-NEXT:    .cfi_offset s10, -136
; QCI-D-NEXT:    .cfi_offset s11, -140
; QCI-D-NEXT:    lui t0, %hi(var)
; QCI-D-NEXT:    lw a0, %lo(var)(t0)
; QCI-D-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+4)(t0)
; QCI-D-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+8)(t0)
; QCI-D-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+12)(t0)
; QCI-D-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    addi a5, t0, %lo(var)
; QCI-D-NEXT:    lw a0, 16(a5)
; QCI-D-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 20(a5)
; QCI-D-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw t4, 24(a5)
; QCI-D-NEXT:    lw t5, 28(a5)
; QCI-D-NEXT:    lw t6, 32(a5)
; QCI-D-NEXT:    lw s2, 36(a5)
; QCI-D-NEXT:    lw s3, 40(a5)
; QCI-D-NEXT:    lw s4, 44(a5)
; QCI-D-NEXT:    lw s5, 48(a5)
; QCI-D-NEXT:    lw s6, 52(a5)
; QCI-D-NEXT:    lw s7, 56(a5)
; QCI-D-NEXT:    lw s8, 60(a5)
; QCI-D-NEXT:    lw s9, 64(a5)
; QCI-D-NEXT:    lw s10, 68(a5)
; QCI-D-NEXT:    lw s11, 72(a5)
; QCI-D-NEXT:    lw ra, 76(a5)
; QCI-D-NEXT:    lw s1, 80(a5)
; QCI-D-NEXT:    lw t3, 84(a5)
; QCI-D-NEXT:    lw t2, 88(a5)
; QCI-D-NEXT:    lw t1, 92(a5)
; QCI-D-NEXT:    lw a7, 112(a5)
; QCI-D-NEXT:    lw s0, 116(a5)
; QCI-D-NEXT:    lw a3, 120(a5)
; QCI-D-NEXT:    lw a0, 124(a5)
; QCI-D-NEXT:    lw a6, 96(a5)
; QCI-D-NEXT:    lw a4, 100(a5)
; QCI-D-NEXT:    lw a2, 104(a5)
; QCI-D-NEXT:    lw a1, 108(a5)
; QCI-D-NEXT:    sw a0, 124(a5)
; QCI-D-NEXT:    sw a3, 120(a5)
; QCI-D-NEXT:    sw s0, 116(a5)
; QCI-D-NEXT:    sw a7, 112(a5)
; QCI-D-NEXT:    sw a1, 108(a5)
; QCI-D-NEXT:    sw a2, 104(a5)
; QCI-D-NEXT:    sw a4, 100(a5)
; QCI-D-NEXT:    sw a6, 96(a5)
; QCI-D-NEXT:    sw t1, 92(a5)
; QCI-D-NEXT:    sw t2, 88(a5)
; QCI-D-NEXT:    sw t3, 84(a5)
; QCI-D-NEXT:    sw s1, 80(a5)
; QCI-D-NEXT:    sw ra, 76(a5)
; QCI-D-NEXT:    sw s11, 72(a5)
; QCI-D-NEXT:    sw s10, 68(a5)
; QCI-D-NEXT:    sw s9, 64(a5)
; QCI-D-NEXT:    sw s8, 60(a5)
; QCI-D-NEXT:    sw s7, 56(a5)
; QCI-D-NEXT:    sw s6, 52(a5)
; QCI-D-NEXT:    sw s5, 48(a5)
; QCI-D-NEXT:    sw s4, 44(a5)
; QCI-D-NEXT:    sw s3, 40(a5)
; QCI-D-NEXT:    sw s2, 36(a5)
; QCI-D-NEXT:    sw t6, 32(a5)
; QCI-D-NEXT:    sw t5, 28(a5)
; QCI-D-NEXT:    sw t4, 24(a5)
; QCI-D-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 20(a5)
; QCI-D-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 16(a5)
; QCI-D-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+12)(t0)
; QCI-D-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+8)(t0)
; QCI-D-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+4)(t0)
; QCI-D-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var)(t0)
; QCI-D-NEXT:    lw s1, 76(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s2, 72(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s3, 68(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s4, 64(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s5, 60(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s6, 56(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s7, 52(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s8, 48(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s9, 44(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s10, 40(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s11, 36(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore s1
; QCI-D-NEXT:    .cfi_restore s2
; QCI-D-NEXT:    .cfi_restore s3
; QCI-D-NEXT:    .cfi_restore s4
; QCI-D-NEXT:    .cfi_restore s5
; QCI-D-NEXT:    .cfi_restore s6
; QCI-D-NEXT:    .cfi_restore s7
; QCI-D-NEXT:    .cfi_restore s8
; QCI-D-NEXT:    .cfi_restore s9
; QCI-D-NEXT:    .cfi_restore s10
; QCI-D-NEXT:    .cfi_restore s11
; QCI-D-NEXT:    addi sp, sp, 80
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  store volatile [32 x i32] %1, ptr @var
  ret void
}

define void @test_spill_call_nest() "interrupt"="qci-nest" {
; QCI-F-LABEL: test_spill_call_nest:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter.nest
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -224
; QCI-F-NEXT:    .cfi_def_cfa_offset 320
; QCI-F-NEXT:    sw s1, 220(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s2, 216(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s3, 212(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s4, 208(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s5, 204(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s6, 200(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s7, 196(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s8, 192(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s9, 188(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s10, 184(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s11, 180(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft0, 176(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft1, 172(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft2, 168(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft3, 164(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft4, 160(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft5, 156(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft6, 152(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft7, 148(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa0, 144(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa1, 140(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa2, 136(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa3, 132(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa4, 128(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa5, 124(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa6, 120(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa7, 116(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft8, 112(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft9, 108(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft10, 104(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft11, 100(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset s1, -100
; QCI-F-NEXT:    .cfi_offset s2, -104
; QCI-F-NEXT:    .cfi_offset s3, -108
; QCI-F-NEXT:    .cfi_offset s4, -112
; QCI-F-NEXT:    .cfi_offset s5, -116
; QCI-F-NEXT:    .cfi_offset s6, -120
; QCI-F-NEXT:    .cfi_offset s7, -124
; QCI-F-NEXT:    .cfi_offset s8, -128
; QCI-F-NEXT:    .cfi_offset s9, -132
; QCI-F-NEXT:    .cfi_offset s10, -136
; QCI-F-NEXT:    .cfi_offset s11, -140
; QCI-F-NEXT:    .cfi_offset ft0, -144
; QCI-F-NEXT:    .cfi_offset ft1, -148
; QCI-F-NEXT:    .cfi_offset ft2, -152
; QCI-F-NEXT:    .cfi_offset ft3, -156
; QCI-F-NEXT:    .cfi_offset ft4, -160
; QCI-F-NEXT:    .cfi_offset ft5, -164
; QCI-F-NEXT:    .cfi_offset ft6, -168
; QCI-F-NEXT:    .cfi_offset ft7, -172
; QCI-F-NEXT:    .cfi_offset fa0, -176
; QCI-F-NEXT:    .cfi_offset fa1, -180
; QCI-F-NEXT:    .cfi_offset fa2, -184
; QCI-F-NEXT:    .cfi_offset fa3, -188
; QCI-F-NEXT:    .cfi_offset fa4, -192
; QCI-F-NEXT:    .cfi_offset fa5, -196
; QCI-F-NEXT:    .cfi_offset fa6, -200
; QCI-F-NEXT:    .cfi_offset fa7, -204
; QCI-F-NEXT:    .cfi_offset ft8, -208
; QCI-F-NEXT:    .cfi_offset ft9, -212
; QCI-F-NEXT:    .cfi_offset ft10, -216
; QCI-F-NEXT:    .cfi_offset ft11, -220
; QCI-F-NEXT:    lui s0, %hi(var)
; QCI-F-NEXT:    lw a0, %lo(var)(s0)
; QCI-F-NEXT:    sw a0, 96(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-F-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-F-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-F-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    addi s1, s0, %lo(var)
; QCI-F-NEXT:    lw a0, 16(s1)
; QCI-F-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 20(s1)
; QCI-F-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 24(s1)
; QCI-F-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 28(s1)
; QCI-F-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 32(s1)
; QCI-F-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 36(s1)
; QCI-F-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 40(s1)
; QCI-F-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 44(s1)
; QCI-F-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 48(s1)
; QCI-F-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 52(s1)
; QCI-F-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 56(s1)
; QCI-F-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 60(s1)
; QCI-F-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 64(s1)
; QCI-F-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 68(s1)
; QCI-F-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 72(s1)
; QCI-F-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 76(s1)
; QCI-F-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 80(s1)
; QCI-F-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 84(s1)
; QCI-F-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw s4, 88(s1)
; QCI-F-NEXT:    lw s5, 92(s1)
; QCI-F-NEXT:    lw s6, 96(s1)
; QCI-F-NEXT:    lw s7, 100(s1)
; QCI-F-NEXT:    lw s8, 104(s1)
; QCI-F-NEXT:    lw s9, 108(s1)
; QCI-F-NEXT:    lw s10, 112(s1)
; QCI-F-NEXT:    lw s11, 116(s1)
; QCI-F-NEXT:    lw s2, 120(s1)
; QCI-F-NEXT:    lw s3, 124(s1)
; QCI-F-NEXT:    lui a7, 266496
; QCI-F-NEXT:    li t0, 5
; QCI-F-NEXT:    lui a0, 260096
; QCI-F-NEXT:    lui a2, 262144
; QCI-F-NEXT:    lui a4, 263168
; QCI-F-NEXT:    lui a5, 264192
; QCI-F-NEXT:    lui a1, 264704
; QCI-F-NEXT:    lui a6, 265216
; QCI-F-NEXT:    fmv.w.x fa0, a0
; QCI-F-NEXT:    lui t1, 265728
; QCI-F-NEXT:    fmv.w.x fa1, a2
; QCI-F-NEXT:    lui a3, 266240
; QCI-F-NEXT:    fmv.w.x fa2, a4
; QCI-F-NEXT:    li a0, 1
; QCI-F-NEXT:    fmv.w.x fa3, a5
; QCI-F-NEXT:    li a2, 2
; QCI-F-NEXT:    fmv.w.x fa4, a1
; QCI-F-NEXT:    li a4, 3
; QCI-F-NEXT:    fmv.w.x fa5, a6
; QCI-F-NEXT:    li a6, 4
; QCI-F-NEXT:    fmv.w.x fa6, t1
; QCI-F-NEXT:    fmv.w.x fa7, a3
; QCI-F-NEXT:    sw t0, 0(sp)
; QCI-F-NEXT:    sw a7, 4(sp)
; QCI-F-NEXT:    li a1, 0
; QCI-F-NEXT:    li a3, 0
; QCI-F-NEXT:    li a5, 0
; QCI-F-NEXT:    li a7, 0
; QCI-F-NEXT:    call function_with_one_stack_arg
; QCI-F-NEXT:    call use_float
; QCI-F-NEXT:    sw s3, 124(s1)
; QCI-F-NEXT:    sw s2, 120(s1)
; QCI-F-NEXT:    sw s11, 116(s1)
; QCI-F-NEXT:    sw s10, 112(s1)
; QCI-F-NEXT:    sw s9, 108(s1)
; QCI-F-NEXT:    sw s8, 104(s1)
; QCI-F-NEXT:    sw s7, 100(s1)
; QCI-F-NEXT:    sw s6, 96(s1)
; QCI-F-NEXT:    sw s5, 92(s1)
; QCI-F-NEXT:    sw s4, 88(s1)
; QCI-F-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 84(s1)
; QCI-F-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 80(s1)
; QCI-F-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 76(s1)
; QCI-F-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 72(s1)
; QCI-F-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 68(s1)
; QCI-F-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 64(s1)
; QCI-F-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 60(s1)
; QCI-F-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 56(s1)
; QCI-F-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 52(s1)
; QCI-F-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 48(s1)
; QCI-F-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 44(s1)
; QCI-F-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 40(s1)
; QCI-F-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 36(s1)
; QCI-F-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 32(s1)
; QCI-F-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 28(s1)
; QCI-F-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 24(s1)
; QCI-F-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 20(s1)
; QCI-F-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 16(s1)
; QCI-F-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-F-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-F-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-F-NEXT:    lw a0, 96(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var)(s0)
; QCI-F-NEXT:    lw s1, 220(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s2, 216(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s3, 212(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s4, 208(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s5, 204(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s6, 200(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s7, 196(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s8, 192(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s9, 188(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s10, 184(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s11, 180(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft0, 176(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft1, 172(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft2, 168(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft3, 164(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft4, 160(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft5, 156(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft6, 152(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft7, 148(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa0, 144(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa1, 140(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa2, 136(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa3, 132(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa4, 128(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa5, 124(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa6, 120(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa7, 116(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft8, 112(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft9, 108(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft10, 104(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft11, 100(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore s1
; QCI-F-NEXT:    .cfi_restore s2
; QCI-F-NEXT:    .cfi_restore s3
; QCI-F-NEXT:    .cfi_restore s4
; QCI-F-NEXT:    .cfi_restore s5
; QCI-F-NEXT:    .cfi_restore s6
; QCI-F-NEXT:    .cfi_restore s7
; QCI-F-NEXT:    .cfi_restore s8
; QCI-F-NEXT:    .cfi_restore s9
; QCI-F-NEXT:    .cfi_restore s10
; QCI-F-NEXT:    .cfi_restore s11
; QCI-F-NEXT:    .cfi_restore ft0
; QCI-F-NEXT:    .cfi_restore ft1
; QCI-F-NEXT:    .cfi_restore ft2
; QCI-F-NEXT:    .cfi_restore ft3
; QCI-F-NEXT:    .cfi_restore ft4
; QCI-F-NEXT:    .cfi_restore ft5
; QCI-F-NEXT:    .cfi_restore ft6
; QCI-F-NEXT:    .cfi_restore ft7
; QCI-F-NEXT:    .cfi_restore fa0
; QCI-F-NEXT:    .cfi_restore fa1
; QCI-F-NEXT:    .cfi_restore fa2
; QCI-F-NEXT:    .cfi_restore fa3
; QCI-F-NEXT:    .cfi_restore fa4
; QCI-F-NEXT:    .cfi_restore fa5
; QCI-F-NEXT:    .cfi_restore fa6
; QCI-F-NEXT:    .cfi_restore fa7
; QCI-F-NEXT:    .cfi_restore ft8
; QCI-F-NEXT:    .cfi_restore ft9
; QCI-F-NEXT:    .cfi_restore ft10
; QCI-F-NEXT:    .cfi_restore ft11
; QCI-F-NEXT:    addi sp, sp, 224
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_spill_call_nest:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter.nest
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -304
; QCI-D-NEXT:    .cfi_def_cfa_offset 400
; QCI-D-NEXT:    sw s1, 300(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s2, 296(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s3, 292(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s4, 288(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s5, 284(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s6, 280(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s7, 276(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s8, 272(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s9, 268(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s10, 264(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s11, 260(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa0, 184(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa1, 176(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa2, 168(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa3, 160(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa4, 152(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa5, 144(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa6, 136(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa7, 128(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft8, 120(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft9, 112(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft10, 104(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft11, 96(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset s1, -100
; QCI-D-NEXT:    .cfi_offset s2, -104
; QCI-D-NEXT:    .cfi_offset s3, -108
; QCI-D-NEXT:    .cfi_offset s4, -112
; QCI-D-NEXT:    .cfi_offset s5, -116
; QCI-D-NEXT:    .cfi_offset s6, -120
; QCI-D-NEXT:    .cfi_offset s7, -124
; QCI-D-NEXT:    .cfi_offset s8, -128
; QCI-D-NEXT:    .cfi_offset s9, -132
; QCI-D-NEXT:    .cfi_offset s10, -136
; QCI-D-NEXT:    .cfi_offset s11, -140
; QCI-D-NEXT:    .cfi_offset ft0, -152
; QCI-D-NEXT:    .cfi_offset ft1, -160
; QCI-D-NEXT:    .cfi_offset ft2, -168
; QCI-D-NEXT:    .cfi_offset ft3, -176
; QCI-D-NEXT:    .cfi_offset ft4, -184
; QCI-D-NEXT:    .cfi_offset ft5, -192
; QCI-D-NEXT:    .cfi_offset ft6, -200
; QCI-D-NEXT:    .cfi_offset ft7, -208
; QCI-D-NEXT:    .cfi_offset fa0, -216
; QCI-D-NEXT:    .cfi_offset fa1, -224
; QCI-D-NEXT:    .cfi_offset fa2, -232
; QCI-D-NEXT:    .cfi_offset fa3, -240
; QCI-D-NEXT:    .cfi_offset fa4, -248
; QCI-D-NEXT:    .cfi_offset fa5, -256
; QCI-D-NEXT:    .cfi_offset fa6, -264
; QCI-D-NEXT:    .cfi_offset fa7, -272
; QCI-D-NEXT:    .cfi_offset ft8, -280
; QCI-D-NEXT:    .cfi_offset ft9, -288
; QCI-D-NEXT:    .cfi_offset ft10, -296
; QCI-D-NEXT:    .cfi_offset ft11, -304
; QCI-D-NEXT:    lui s0, %hi(var)
; QCI-D-NEXT:    lw a0, %lo(var)(s0)
; QCI-D-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-D-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-D-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-D-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    addi s1, s0, %lo(var)
; QCI-D-NEXT:    lw a0, 16(s1)
; QCI-D-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 20(s1)
; QCI-D-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 24(s1)
; QCI-D-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 28(s1)
; QCI-D-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 32(s1)
; QCI-D-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 36(s1)
; QCI-D-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 40(s1)
; QCI-D-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 44(s1)
; QCI-D-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 48(s1)
; QCI-D-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 52(s1)
; QCI-D-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 56(s1)
; QCI-D-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 60(s1)
; QCI-D-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 64(s1)
; QCI-D-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 68(s1)
; QCI-D-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 72(s1)
; QCI-D-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 76(s1)
; QCI-D-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 80(s1)
; QCI-D-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 84(s1)
; QCI-D-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw s4, 88(s1)
; QCI-D-NEXT:    lw s5, 92(s1)
; QCI-D-NEXT:    lw s6, 96(s1)
; QCI-D-NEXT:    lw s7, 100(s1)
; QCI-D-NEXT:    lw s8, 104(s1)
; QCI-D-NEXT:    lw s9, 108(s1)
; QCI-D-NEXT:    lw s10, 112(s1)
; QCI-D-NEXT:    lw s11, 116(s1)
; QCI-D-NEXT:    lw s2, 120(s1)
; QCI-D-NEXT:    lw s3, 124(s1)
; QCI-D-NEXT:    lui a7, 266496
; QCI-D-NEXT:    li t0, 5
; QCI-D-NEXT:    lui a0, 260096
; QCI-D-NEXT:    lui a2, 262144
; QCI-D-NEXT:    lui a4, 263168
; QCI-D-NEXT:    lui a5, 264192
; QCI-D-NEXT:    lui a1, 264704
; QCI-D-NEXT:    lui a6, 265216
; QCI-D-NEXT:    fmv.w.x fa0, a0
; QCI-D-NEXT:    lui t1, 265728
; QCI-D-NEXT:    fmv.w.x fa1, a2
; QCI-D-NEXT:    lui a3, 266240
; QCI-D-NEXT:    fmv.w.x fa2, a4
; QCI-D-NEXT:    li a0, 1
; QCI-D-NEXT:    fmv.w.x fa3, a5
; QCI-D-NEXT:    li a2, 2
; QCI-D-NEXT:    fmv.w.x fa4, a1
; QCI-D-NEXT:    li a4, 3
; QCI-D-NEXT:    fmv.w.x fa5, a6
; QCI-D-NEXT:    li a6, 4
; QCI-D-NEXT:    fmv.w.x fa6, t1
; QCI-D-NEXT:    fmv.w.x fa7, a3
; QCI-D-NEXT:    sw t0, 0(sp)
; QCI-D-NEXT:    sw a7, 4(sp)
; QCI-D-NEXT:    li a1, 0
; QCI-D-NEXT:    li a3, 0
; QCI-D-NEXT:    li a5, 0
; QCI-D-NEXT:    li a7, 0
; QCI-D-NEXT:    call function_with_one_stack_arg
; QCI-D-NEXT:    call use_float
; QCI-D-NEXT:    sw s3, 124(s1)
; QCI-D-NEXT:    sw s2, 120(s1)
; QCI-D-NEXT:    sw s11, 116(s1)
; QCI-D-NEXT:    sw s10, 112(s1)
; QCI-D-NEXT:    sw s9, 108(s1)
; QCI-D-NEXT:    sw s8, 104(s1)
; QCI-D-NEXT:    sw s7, 100(s1)
; QCI-D-NEXT:    sw s6, 96(s1)
; QCI-D-NEXT:    sw s5, 92(s1)
; QCI-D-NEXT:    sw s4, 88(s1)
; QCI-D-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 84(s1)
; QCI-D-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 80(s1)
; QCI-D-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 76(s1)
; QCI-D-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 72(s1)
; QCI-D-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 68(s1)
; QCI-D-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 64(s1)
; QCI-D-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 60(s1)
; QCI-D-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 56(s1)
; QCI-D-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 52(s1)
; QCI-D-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 48(s1)
; QCI-D-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 44(s1)
; QCI-D-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 40(s1)
; QCI-D-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 36(s1)
; QCI-D-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 32(s1)
; QCI-D-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 28(s1)
; QCI-D-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 24(s1)
; QCI-D-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 20(s1)
; QCI-D-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 16(s1)
; QCI-D-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-D-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-D-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-D-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var)(s0)
; QCI-D-NEXT:    lw s1, 300(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s2, 296(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s3, 292(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s4, 288(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s5, 284(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s6, 280(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s7, 276(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s8, 272(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s9, 268(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s10, 264(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s11, 260(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa0, 184(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa1, 176(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa2, 168(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa3, 160(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa4, 152(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa5, 144(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa6, 136(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa7, 128(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft8, 120(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft9, 112(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft10, 104(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft11, 96(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore s1
; QCI-D-NEXT:    .cfi_restore s2
; QCI-D-NEXT:    .cfi_restore s3
; QCI-D-NEXT:    .cfi_restore s4
; QCI-D-NEXT:    .cfi_restore s5
; QCI-D-NEXT:    .cfi_restore s6
; QCI-D-NEXT:    .cfi_restore s7
; QCI-D-NEXT:    .cfi_restore s8
; QCI-D-NEXT:    .cfi_restore s9
; QCI-D-NEXT:    .cfi_restore s10
; QCI-D-NEXT:    .cfi_restore s11
; QCI-D-NEXT:    .cfi_restore ft0
; QCI-D-NEXT:    .cfi_restore ft1
; QCI-D-NEXT:    .cfi_restore ft2
; QCI-D-NEXT:    .cfi_restore ft3
; QCI-D-NEXT:    .cfi_restore ft4
; QCI-D-NEXT:    .cfi_restore ft5
; QCI-D-NEXT:    .cfi_restore ft6
; QCI-D-NEXT:    .cfi_restore ft7
; QCI-D-NEXT:    .cfi_restore fa0
; QCI-D-NEXT:    .cfi_restore fa1
; QCI-D-NEXT:    .cfi_restore fa2
; QCI-D-NEXT:    .cfi_restore fa3
; QCI-D-NEXT:    .cfi_restore fa4
; QCI-D-NEXT:    .cfi_restore fa5
; QCI-D-NEXT:    .cfi_restore fa6
; QCI-D-NEXT:    .cfi_restore fa7
; QCI-D-NEXT:    .cfi_restore ft8
; QCI-D-NEXT:    .cfi_restore ft9
; QCI-D-NEXT:    .cfi_restore ft10
; QCI-D-NEXT:    .cfi_restore ft11
; QCI-D-NEXT:    addi sp, sp, 304
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  %2 = call float @function_with_one_stack_arg(i64 1, i64 2, i64 3, i64 4, float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0, i32 5, float 9.0)
  call void @use_float(float %2)
  store volatile [32 x i32] %1, ptr @var
  ret void
}

define void @test_spill_call_nonest() "interrupt"="qci-nonest" {
; QCI-F-LABEL: test_spill_call_nonest:
; QCI-F:       # %bb.0:
; QCI-F-NEXT:    qc.c.mienter
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    .cfi_offset ra, -16
; QCI-F-NEXT:    .cfi_offset t0, -24
; QCI-F-NEXT:    .cfi_offset t1, -28
; QCI-F-NEXT:    .cfi_offset t2, -32
; QCI-F-NEXT:    .cfi_offset s0, -8
; QCI-F-NEXT:    .cfi_offset a0, -36
; QCI-F-NEXT:    .cfi_offset a1, -40
; QCI-F-NEXT:    .cfi_offset a2, -44
; QCI-F-NEXT:    .cfi_offset a3, -48
; QCI-F-NEXT:    .cfi_offset a4, -52
; QCI-F-NEXT:    .cfi_offset a5, -56
; QCI-F-NEXT:    .cfi_offset a6, -60
; QCI-F-NEXT:    .cfi_offset a7, -64
; QCI-F-NEXT:    .cfi_offset t3, -68
; QCI-F-NEXT:    .cfi_offset t4, -72
; QCI-F-NEXT:    .cfi_offset t5, -76
; QCI-F-NEXT:    .cfi_offset t6, -80
; QCI-F-NEXT:    addi sp, sp, -224
; QCI-F-NEXT:    .cfi_def_cfa_offset 320
; QCI-F-NEXT:    sw s1, 220(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s2, 216(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s3, 212(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s4, 208(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s5, 204(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s6, 200(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s7, 196(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s8, 192(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s9, 188(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s10, 184(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    sw s11, 180(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft0, 176(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft1, 172(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft2, 168(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft3, 164(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft4, 160(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft5, 156(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft6, 152(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft7, 148(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa0, 144(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa1, 140(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa2, 136(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa3, 132(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa4, 128(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa5, 124(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa6, 120(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw fa7, 116(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft8, 112(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft9, 108(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft10, 104(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    fsw ft11, 100(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    .cfi_offset s1, -100
; QCI-F-NEXT:    .cfi_offset s2, -104
; QCI-F-NEXT:    .cfi_offset s3, -108
; QCI-F-NEXT:    .cfi_offset s4, -112
; QCI-F-NEXT:    .cfi_offset s5, -116
; QCI-F-NEXT:    .cfi_offset s6, -120
; QCI-F-NEXT:    .cfi_offset s7, -124
; QCI-F-NEXT:    .cfi_offset s8, -128
; QCI-F-NEXT:    .cfi_offset s9, -132
; QCI-F-NEXT:    .cfi_offset s10, -136
; QCI-F-NEXT:    .cfi_offset s11, -140
; QCI-F-NEXT:    .cfi_offset ft0, -144
; QCI-F-NEXT:    .cfi_offset ft1, -148
; QCI-F-NEXT:    .cfi_offset ft2, -152
; QCI-F-NEXT:    .cfi_offset ft3, -156
; QCI-F-NEXT:    .cfi_offset ft4, -160
; QCI-F-NEXT:    .cfi_offset ft5, -164
; QCI-F-NEXT:    .cfi_offset ft6, -168
; QCI-F-NEXT:    .cfi_offset ft7, -172
; QCI-F-NEXT:    .cfi_offset fa0, -176
; QCI-F-NEXT:    .cfi_offset fa1, -180
; QCI-F-NEXT:    .cfi_offset fa2, -184
; QCI-F-NEXT:    .cfi_offset fa3, -188
; QCI-F-NEXT:    .cfi_offset fa4, -192
; QCI-F-NEXT:    .cfi_offset fa5, -196
; QCI-F-NEXT:    .cfi_offset fa6, -200
; QCI-F-NEXT:    .cfi_offset fa7, -204
; QCI-F-NEXT:    .cfi_offset ft8, -208
; QCI-F-NEXT:    .cfi_offset ft9, -212
; QCI-F-NEXT:    .cfi_offset ft10, -216
; QCI-F-NEXT:    .cfi_offset ft11, -220
; QCI-F-NEXT:    lui s0, %hi(var)
; QCI-F-NEXT:    lw a0, %lo(var)(s0)
; QCI-F-NEXT:    sw a0, 96(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-F-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-F-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-F-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    addi s1, s0, %lo(var)
; QCI-F-NEXT:    lw a0, 16(s1)
; QCI-F-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 20(s1)
; QCI-F-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 24(s1)
; QCI-F-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 28(s1)
; QCI-F-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 32(s1)
; QCI-F-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 36(s1)
; QCI-F-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 40(s1)
; QCI-F-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 44(s1)
; QCI-F-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 48(s1)
; QCI-F-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 52(s1)
; QCI-F-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 56(s1)
; QCI-F-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 60(s1)
; QCI-F-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 64(s1)
; QCI-F-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 68(s1)
; QCI-F-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 72(s1)
; QCI-F-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 76(s1)
; QCI-F-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 80(s1)
; QCI-F-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw a0, 84(s1)
; QCI-F-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-F-NEXT:    lw s4, 88(s1)
; QCI-F-NEXT:    lw s5, 92(s1)
; QCI-F-NEXT:    lw s6, 96(s1)
; QCI-F-NEXT:    lw s7, 100(s1)
; QCI-F-NEXT:    lw s8, 104(s1)
; QCI-F-NEXT:    lw s9, 108(s1)
; QCI-F-NEXT:    lw s10, 112(s1)
; QCI-F-NEXT:    lw s11, 116(s1)
; QCI-F-NEXT:    lw s2, 120(s1)
; QCI-F-NEXT:    lw s3, 124(s1)
; QCI-F-NEXT:    lui a7, 266496
; QCI-F-NEXT:    li t0, 5
; QCI-F-NEXT:    lui a0, 260096
; QCI-F-NEXT:    lui a2, 262144
; QCI-F-NEXT:    lui a4, 263168
; QCI-F-NEXT:    lui a5, 264192
; QCI-F-NEXT:    lui a1, 264704
; QCI-F-NEXT:    lui a6, 265216
; QCI-F-NEXT:    fmv.w.x fa0, a0
; QCI-F-NEXT:    lui t1, 265728
; QCI-F-NEXT:    fmv.w.x fa1, a2
; QCI-F-NEXT:    lui a3, 266240
; QCI-F-NEXT:    fmv.w.x fa2, a4
; QCI-F-NEXT:    li a0, 1
; QCI-F-NEXT:    fmv.w.x fa3, a5
; QCI-F-NEXT:    li a2, 2
; QCI-F-NEXT:    fmv.w.x fa4, a1
; QCI-F-NEXT:    li a4, 3
; QCI-F-NEXT:    fmv.w.x fa5, a6
; QCI-F-NEXT:    li a6, 4
; QCI-F-NEXT:    fmv.w.x fa6, t1
; QCI-F-NEXT:    fmv.w.x fa7, a3
; QCI-F-NEXT:    sw t0, 0(sp)
; QCI-F-NEXT:    sw a7, 4(sp)
; QCI-F-NEXT:    li a1, 0
; QCI-F-NEXT:    li a3, 0
; QCI-F-NEXT:    li a5, 0
; QCI-F-NEXT:    li a7, 0
; QCI-F-NEXT:    call function_with_one_stack_arg
; QCI-F-NEXT:    call use_float
; QCI-F-NEXT:    sw s3, 124(s1)
; QCI-F-NEXT:    sw s2, 120(s1)
; QCI-F-NEXT:    sw s11, 116(s1)
; QCI-F-NEXT:    sw s10, 112(s1)
; QCI-F-NEXT:    sw s9, 108(s1)
; QCI-F-NEXT:    sw s8, 104(s1)
; QCI-F-NEXT:    sw s7, 100(s1)
; QCI-F-NEXT:    sw s6, 96(s1)
; QCI-F-NEXT:    sw s5, 92(s1)
; QCI-F-NEXT:    sw s4, 88(s1)
; QCI-F-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 84(s1)
; QCI-F-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 80(s1)
; QCI-F-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 76(s1)
; QCI-F-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 72(s1)
; QCI-F-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 68(s1)
; QCI-F-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 64(s1)
; QCI-F-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 60(s1)
; QCI-F-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 56(s1)
; QCI-F-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 52(s1)
; QCI-F-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 48(s1)
; QCI-F-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 44(s1)
; QCI-F-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 40(s1)
; QCI-F-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 36(s1)
; QCI-F-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 32(s1)
; QCI-F-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 28(s1)
; QCI-F-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 24(s1)
; QCI-F-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 20(s1)
; QCI-F-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, 16(s1)
; QCI-F-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-F-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-F-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-F-NEXT:    lw a0, 96(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    sw a0, %lo(var)(s0)
; QCI-F-NEXT:    lw s1, 220(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s2, 216(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s3, 212(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s4, 208(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s5, 204(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s6, 200(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s7, 196(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s8, 192(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s9, 188(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s10, 184(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    lw s11, 180(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft0, 176(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft1, 172(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft2, 168(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft3, 164(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft4, 160(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft5, 156(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft6, 152(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft7, 148(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa0, 144(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa1, 140(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa2, 136(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa3, 132(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa4, 128(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa5, 124(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa6, 120(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw fa7, 116(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft8, 112(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft9, 108(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft10, 104(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    flw ft11, 100(sp) # 4-byte Folded Reload
; QCI-F-NEXT:    .cfi_restore s1
; QCI-F-NEXT:    .cfi_restore s2
; QCI-F-NEXT:    .cfi_restore s3
; QCI-F-NEXT:    .cfi_restore s4
; QCI-F-NEXT:    .cfi_restore s5
; QCI-F-NEXT:    .cfi_restore s6
; QCI-F-NEXT:    .cfi_restore s7
; QCI-F-NEXT:    .cfi_restore s8
; QCI-F-NEXT:    .cfi_restore s9
; QCI-F-NEXT:    .cfi_restore s10
; QCI-F-NEXT:    .cfi_restore s11
; QCI-F-NEXT:    .cfi_restore ft0
; QCI-F-NEXT:    .cfi_restore ft1
; QCI-F-NEXT:    .cfi_restore ft2
; QCI-F-NEXT:    .cfi_restore ft3
; QCI-F-NEXT:    .cfi_restore ft4
; QCI-F-NEXT:    .cfi_restore ft5
; QCI-F-NEXT:    .cfi_restore ft6
; QCI-F-NEXT:    .cfi_restore ft7
; QCI-F-NEXT:    .cfi_restore fa0
; QCI-F-NEXT:    .cfi_restore fa1
; QCI-F-NEXT:    .cfi_restore fa2
; QCI-F-NEXT:    .cfi_restore fa3
; QCI-F-NEXT:    .cfi_restore fa4
; QCI-F-NEXT:    .cfi_restore fa5
; QCI-F-NEXT:    .cfi_restore fa6
; QCI-F-NEXT:    .cfi_restore fa7
; QCI-F-NEXT:    .cfi_restore ft8
; QCI-F-NEXT:    .cfi_restore ft9
; QCI-F-NEXT:    .cfi_restore ft10
; QCI-F-NEXT:    .cfi_restore ft11
; QCI-F-NEXT:    addi sp, sp, 224
; QCI-F-NEXT:    .cfi_def_cfa_offset 96
; QCI-F-NEXT:    qc.c.mileaveret
;
; QCI-D-LABEL: test_spill_call_nonest:
; QCI-D:       # %bb.0:
; QCI-D-NEXT:    qc.c.mienter
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    .cfi_offset ra, -16
; QCI-D-NEXT:    .cfi_offset t0, -24
; QCI-D-NEXT:    .cfi_offset t1, -28
; QCI-D-NEXT:    .cfi_offset t2, -32
; QCI-D-NEXT:    .cfi_offset s0, -8
; QCI-D-NEXT:    .cfi_offset a0, -36
; QCI-D-NEXT:    .cfi_offset a1, -40
; QCI-D-NEXT:    .cfi_offset a2, -44
; QCI-D-NEXT:    .cfi_offset a3, -48
; QCI-D-NEXT:    .cfi_offset a4, -52
; QCI-D-NEXT:    .cfi_offset a5, -56
; QCI-D-NEXT:    .cfi_offset a6, -60
; QCI-D-NEXT:    .cfi_offset a7, -64
; QCI-D-NEXT:    .cfi_offset t3, -68
; QCI-D-NEXT:    .cfi_offset t4, -72
; QCI-D-NEXT:    .cfi_offset t5, -76
; QCI-D-NEXT:    .cfi_offset t6, -80
; QCI-D-NEXT:    addi sp, sp, -304
; QCI-D-NEXT:    .cfi_def_cfa_offset 400
; QCI-D-NEXT:    sw s1, 300(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s2, 296(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s3, 292(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s4, 288(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s5, 284(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s6, 280(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s7, 276(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s8, 272(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s9, 268(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s10, 264(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    sw s11, 260(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa0, 184(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa1, 176(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa2, 168(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa3, 160(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa4, 152(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa5, 144(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa6, 136(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd fa7, 128(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft8, 120(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft9, 112(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft10, 104(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    fsd ft11, 96(sp) # 8-byte Folded Spill
; QCI-D-NEXT:    .cfi_offset s1, -100
; QCI-D-NEXT:    .cfi_offset s2, -104
; QCI-D-NEXT:    .cfi_offset s3, -108
; QCI-D-NEXT:    .cfi_offset s4, -112
; QCI-D-NEXT:    .cfi_offset s5, -116
; QCI-D-NEXT:    .cfi_offset s6, -120
; QCI-D-NEXT:    .cfi_offset s7, -124
; QCI-D-NEXT:    .cfi_offset s8, -128
; QCI-D-NEXT:    .cfi_offset s9, -132
; QCI-D-NEXT:    .cfi_offset s10, -136
; QCI-D-NEXT:    .cfi_offset s11, -140
; QCI-D-NEXT:    .cfi_offset ft0, -152
; QCI-D-NEXT:    .cfi_offset ft1, -160
; QCI-D-NEXT:    .cfi_offset ft2, -168
; QCI-D-NEXT:    .cfi_offset ft3, -176
; QCI-D-NEXT:    .cfi_offset ft4, -184
; QCI-D-NEXT:    .cfi_offset ft5, -192
; QCI-D-NEXT:    .cfi_offset ft6, -200
; QCI-D-NEXT:    .cfi_offset ft7, -208
; QCI-D-NEXT:    .cfi_offset fa0, -216
; QCI-D-NEXT:    .cfi_offset fa1, -224
; QCI-D-NEXT:    .cfi_offset fa2, -232
; QCI-D-NEXT:    .cfi_offset fa3, -240
; QCI-D-NEXT:    .cfi_offset fa4, -248
; QCI-D-NEXT:    .cfi_offset fa5, -256
; QCI-D-NEXT:    .cfi_offset fa6, -264
; QCI-D-NEXT:    .cfi_offset fa7, -272
; QCI-D-NEXT:    .cfi_offset ft8, -280
; QCI-D-NEXT:    .cfi_offset ft9, -288
; QCI-D-NEXT:    .cfi_offset ft10, -296
; QCI-D-NEXT:    .cfi_offset ft11, -304
; QCI-D-NEXT:    lui s0, %hi(var)
; QCI-D-NEXT:    lw a0, %lo(var)(s0)
; QCI-D-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+4)(s0)
; QCI-D-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+8)(s0)
; QCI-D-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, %lo(var+12)(s0)
; QCI-D-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    addi s1, s0, %lo(var)
; QCI-D-NEXT:    lw a0, 16(s1)
; QCI-D-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 20(s1)
; QCI-D-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 24(s1)
; QCI-D-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 28(s1)
; QCI-D-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 32(s1)
; QCI-D-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 36(s1)
; QCI-D-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 40(s1)
; QCI-D-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 44(s1)
; QCI-D-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 48(s1)
; QCI-D-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 52(s1)
; QCI-D-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 56(s1)
; QCI-D-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 60(s1)
; QCI-D-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 64(s1)
; QCI-D-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 68(s1)
; QCI-D-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 72(s1)
; QCI-D-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 76(s1)
; QCI-D-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 80(s1)
; QCI-D-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw a0, 84(s1)
; QCI-D-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; QCI-D-NEXT:    lw s4, 88(s1)
; QCI-D-NEXT:    lw s5, 92(s1)
; QCI-D-NEXT:    lw s6, 96(s1)
; QCI-D-NEXT:    lw s7, 100(s1)
; QCI-D-NEXT:    lw s8, 104(s1)
; QCI-D-NEXT:    lw s9, 108(s1)
; QCI-D-NEXT:    lw s10, 112(s1)
; QCI-D-NEXT:    lw s11, 116(s1)
; QCI-D-NEXT:    lw s2, 120(s1)
; QCI-D-NEXT:    lw s3, 124(s1)
; QCI-D-NEXT:    lui a7, 266496
; QCI-D-NEXT:    li t0, 5
; QCI-D-NEXT:    lui a0, 260096
; QCI-D-NEXT:    lui a2, 262144
; QCI-D-NEXT:    lui a4, 263168
; QCI-D-NEXT:    lui a5, 264192
; QCI-D-NEXT:    lui a1, 264704
; QCI-D-NEXT:    lui a6, 265216
; QCI-D-NEXT:    fmv.w.x fa0, a0
; QCI-D-NEXT:    lui t1, 265728
; QCI-D-NEXT:    fmv.w.x fa1, a2
; QCI-D-NEXT:    lui a3, 266240
; QCI-D-NEXT:    fmv.w.x fa2, a4
; QCI-D-NEXT:    li a0, 1
; QCI-D-NEXT:    fmv.w.x fa3, a5
; QCI-D-NEXT:    li a2, 2
; QCI-D-NEXT:    fmv.w.x fa4, a1
; QCI-D-NEXT:    li a4, 3
; QCI-D-NEXT:    fmv.w.x fa5, a6
; QCI-D-NEXT:    li a6, 4
; QCI-D-NEXT:    fmv.w.x fa6, t1
; QCI-D-NEXT:    fmv.w.x fa7, a3
; QCI-D-NEXT:    sw t0, 0(sp)
; QCI-D-NEXT:    sw a7, 4(sp)
; QCI-D-NEXT:    li a1, 0
; QCI-D-NEXT:    li a3, 0
; QCI-D-NEXT:    li a5, 0
; QCI-D-NEXT:    li a7, 0
; QCI-D-NEXT:    call function_with_one_stack_arg
; QCI-D-NEXT:    call use_float
; QCI-D-NEXT:    sw s3, 124(s1)
; QCI-D-NEXT:    sw s2, 120(s1)
; QCI-D-NEXT:    sw s11, 116(s1)
; QCI-D-NEXT:    sw s10, 112(s1)
; QCI-D-NEXT:    sw s9, 108(s1)
; QCI-D-NEXT:    sw s8, 104(s1)
; QCI-D-NEXT:    sw s7, 100(s1)
; QCI-D-NEXT:    sw s6, 96(s1)
; QCI-D-NEXT:    sw s5, 92(s1)
; QCI-D-NEXT:    sw s4, 88(s1)
; QCI-D-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 84(s1)
; QCI-D-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 80(s1)
; QCI-D-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 76(s1)
; QCI-D-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 72(s1)
; QCI-D-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 68(s1)
; QCI-D-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 64(s1)
; QCI-D-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 60(s1)
; QCI-D-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 56(s1)
; QCI-D-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 52(s1)
; QCI-D-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 48(s1)
; QCI-D-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 44(s1)
; QCI-D-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 40(s1)
; QCI-D-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 36(s1)
; QCI-D-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 32(s1)
; QCI-D-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 28(s1)
; QCI-D-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 24(s1)
; QCI-D-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 20(s1)
; QCI-D-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, 16(s1)
; QCI-D-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+12)(s0)
; QCI-D-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+8)(s0)
; QCI-D-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var+4)(s0)
; QCI-D-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    sw a0, %lo(var)(s0)
; QCI-D-NEXT:    lw s1, 300(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s2, 296(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s3, 292(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s4, 288(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s5, 284(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s6, 280(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s7, 276(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s8, 272(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s9, 268(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s10, 264(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    lw s11, 260(sp) # 4-byte Folded Reload
; QCI-D-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa0, 184(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa1, 176(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa2, 168(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa3, 160(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa4, 152(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa5, 144(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa6, 136(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld fa7, 128(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft8, 120(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft9, 112(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft10, 104(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    fld ft11, 96(sp) # 8-byte Folded Reload
; QCI-D-NEXT:    .cfi_restore s1
; QCI-D-NEXT:    .cfi_restore s2
; QCI-D-NEXT:    .cfi_restore s3
; QCI-D-NEXT:    .cfi_restore s4
; QCI-D-NEXT:    .cfi_restore s5
; QCI-D-NEXT:    .cfi_restore s6
; QCI-D-NEXT:    .cfi_restore s7
; QCI-D-NEXT:    .cfi_restore s8
; QCI-D-NEXT:    .cfi_restore s9
; QCI-D-NEXT:    .cfi_restore s10
; QCI-D-NEXT:    .cfi_restore s11
; QCI-D-NEXT:    .cfi_restore ft0
; QCI-D-NEXT:    .cfi_restore ft1
; QCI-D-NEXT:    .cfi_restore ft2
; QCI-D-NEXT:    .cfi_restore ft3
; QCI-D-NEXT:    .cfi_restore ft4
; QCI-D-NEXT:    .cfi_restore ft5
; QCI-D-NEXT:    .cfi_restore ft6
; QCI-D-NEXT:    .cfi_restore ft7
; QCI-D-NEXT:    .cfi_restore fa0
; QCI-D-NEXT:    .cfi_restore fa1
; QCI-D-NEXT:    .cfi_restore fa2
; QCI-D-NEXT:    .cfi_restore fa3
; QCI-D-NEXT:    .cfi_restore fa4
; QCI-D-NEXT:    .cfi_restore fa5
; QCI-D-NEXT:    .cfi_restore fa6
; QCI-D-NEXT:    .cfi_restore fa7
; QCI-D-NEXT:    .cfi_restore ft8
; QCI-D-NEXT:    .cfi_restore ft9
; QCI-D-NEXT:    .cfi_restore ft10
; QCI-D-NEXT:    .cfi_restore ft11
; QCI-D-NEXT:    addi sp, sp, 304
; QCI-D-NEXT:    .cfi_def_cfa_offset 96
; QCI-D-NEXT:    qc.c.mileaveret
  %1 = load [32 x i32], ptr @var
  %2 = call float @function_with_one_stack_arg(i64 1, i64 2, i64 3, i64 4, float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0, i32 5, float 9.0)
  call void @use_float(float %2)
  store volatile [32 x i32] %1, ptr @var
  ret void
}
