/* do not edit automatically generated by mc from symbolKey.  */
/* symbolKey.def provides binary tree operations for storing symbols.

Copyright (C) 2015-2023 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius@glam.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_symbolKey_H)
#   define _symbolKey_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#   include "GSYSTEM.h"
#   include "GnameKey.h"

#   if defined (_symbolKey_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#   define symbolKey_NulKey NULL
#if !defined (symbolKey_symbolTree_D)
#  define symbolKey_symbolTree_D
   typedef void *symbolKey_symbolTree;
#endif

typedef struct symbolKey_isSymbol_p symbolKey_isSymbol;

typedef struct symbolKey_performOperation_p symbolKey_performOperation;

typedef bool (*symbolKey_isSymbol_t) (void *);
struct symbolKey_isSymbol_p { symbolKey_isSymbol_t proc; };

typedef void (*symbolKey_performOperation_t) (void *);
struct symbolKey_performOperation_p { symbolKey_performOperation_t proc; };


/*
   initTree - initializes a symbolTree pointed to by t.
*/

EXTERN symbolKey_symbolTree symbolKey_initTree (void);

/*
   killTree - destroys the symbolTree pointed to by t.
*/

EXTERN void symbolKey_killTree (symbolKey_symbolTree *t);

/*
   getSymKey - searches the symbolTree t for an entry name. If
               found then the key is returned otherwise NulKey
               is returned.
*/

EXTERN void * symbolKey_getSymKey (symbolKey_symbolTree t, nameKey_Name name);

/*
   putSymKey - puts an symbol entry, name, in the symbolTree t.
               SymKey is the value stored with name.
*/

EXTERN void symbolKey_putSymKey (symbolKey_symbolTree t, nameKey_Name name, void * key);

/*
   delSymKey - deletes a symbol entry name in the symbolTree, t.
*/

EXTERN void symbolKey_delSymKey (symbolKey_symbolTree t, nameKey_Name name);

/*
   isEmptyTree - returns true if symbolTree, t, is empty.
*/

EXTERN bool symbolKey_isEmptyTree (symbolKey_symbolTree t);

/*
   doesTreeContainAny - returns true if symbolTree, t, contains any
                        symbols which in turn return true when procedure,
                        p, is called with a symbol as its parameter.
*/

EXTERN bool symbolKey_doesTreeContainAny (symbolKey_symbolTree t, symbolKey_isSymbol p);

/*
   foreachNodeDo - for each node in symbolTree, t, a procedure, p,
                   is called with the node symbol as its parameter.
                   It traverse the tree in order.
*/

EXTERN void symbolKey_foreachNodeDo (symbolKey_symbolTree t, symbolKey_performOperation p);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
