; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s

define void @abs_v16i8(ptr %x) {
; CHECK-LABEL: abs_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, ptr %x
  %b = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %a, i1 false)
  store <16 x i8> %b, ptr %x
  ret void
}
declare <16 x i8> @llvm.abs.v16i8(<16 x i8>, i1)

define void @abs_v8i16(ptr %x) {
; CHECK-LABEL: abs_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %b = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %a, i1 false)
  store <8 x i16> %b, ptr %x
  ret void
}
declare <8 x i16> @llvm.abs.v8i16(<8 x i16>, i1)

define void @abs_v6i16(ptr %x) {
; CHECK-LABEL: abs_v6i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 6, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <6 x i16>, ptr %x
  %b = call <6 x i16> @llvm.abs.v6i16(<6 x i16> %a, i1 false)
  store <6 x i16> %b, ptr %x
  ret void
}
declare <6 x i16> @llvm.abs.v6i16(<6 x i16>, i1)

define void @abs_v4i32(ptr %x) {
; CHECK-LABEL: abs_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, ptr %x
  %b = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a, i1 false)
  store <4 x i32> %b, ptr %x
  ret void
}
declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)

define void @abs_v2i64(ptr %x) {
; CHECK-LABEL: abs_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %b = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %a, i1 false)
  store <2 x i64> %b, ptr %x
  ret void
}
declare <2 x i64> @llvm.abs.v2i64(<2 x i64>, i1)

define void @abs_v32i8(ptr %x) {
; CHECK-LABEL: abs_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v10, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v10
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <32 x i8>, ptr %x
  %b = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %a, i1 false)
  store <32 x i8> %b, ptr %x
  ret void
}
declare <32 x i8> @llvm.abs.v32i8(<32 x i8>, i1)

define void @abs_v16i16(ptr %x) {
; CHECK-LABEL: abs_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v10, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v10
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i16>, ptr %x
  %b = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %a, i1 false)
  store <16 x i16> %b, ptr %x
  ret void
}
declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1)

define void @abs_v8i32(ptr %x) {
; CHECK-LABEL: abs_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v10, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v10
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i32>, ptr %x
  %b = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %a, i1 false)
  store <8 x i32> %b, ptr %x
  ret void
}
declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1)

define void @abs_v4i64(ptr %x) {
; CHECK-LABEL: abs_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v10, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i64>, ptr %x
  %b = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a, i1 false)
  store <4 x i64> %b, ptr %x
  ret void
}
declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)

define void @abs_v4i64_of_sext_v4i8(ptr %x) {
; CHECK-LABEL: abs_v4i64_of_sext_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v10, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i8>, ptr %x
  %a.ext = sext <4 x i8> %a to <4 x i64>
  %b = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a.ext, i1 false)
  store <4 x i64> %b, ptr %x
  ret void
}

define void @abs_v4i64_of_sext_v4i16(ptr %x) {
; CHECK-LABEL: abs_v4i64_of_sext_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v10, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf4 v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i16>, ptr %x
  %a.ext = sext <4 x i16> %a to <4 x i64>
  %b = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a.ext, i1 false)
  store <4 x i64> %b, ptr %x
  ret void
}

define void @abs_v4i64_of_sext_v4i32(ptr %x) {
; CHECK-LABEL: abs_v4i64_of_sext_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v10, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v10
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, ptr %x
  %a.ext = sext <4 x i32> %a to <4 x i64>
  %b = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %a.ext, i1 false)
  store <4 x i64> %b, ptr %x
  ret void
}
