; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define i32 @negated_operand(i32 %x) {
; CHECK-LABEL: @negated_operand(
; CHECK-NEXT:    ret i32 0
;
  %negx = sub i32 0, %x
  %rem = srem i32 %negx, %x
  ret i32 %rem
}

define <2 x i32> @negated_operand_commute_vec(<2 x i32> %x) {
; CHECK-LABEL: @negated_operand_commute_vec(
; CHECK-NEXT:    ret <2 x i32> zeroinitializer
;
  %negx = sub <2 x i32> zeroinitializer, %x
  %rem = srem <2 x i32> %negx, %x
  ret <2 x i32> %rem
}

define i32 @knownnegation(i32 %x, i32 %y) {
; CHECK-LABEL: @knownnegation(
; CHECK-NEXT:    ret i32 0
;
  %xy = sub i32 %x, %y
  %yx = sub i32 %y, %x
  %rem = srem i32 %xy, %yx
  ret i32 %rem
}

define <2 x i32> @knownnegation_commute_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @knownnegation_commute_vec(
; CHECK-NEXT:    ret <2 x i32> zeroinitializer
;
  %xy = sub <2 x i32> %x, %y
  %yx = sub <2 x i32> %y, %x
  %rem = srem <2 x i32> %xy, %yx
  ret <2 x i32> %rem
}

define <3 x i32> @negated_operand_vec_poison(<3 x i32> %x) {
; CHECK-LABEL: @negated_operand_vec_poison(
; CHECK-NEXT:    ret <3 x i32> zeroinitializer
;
  %negx = sub <3 x i32> <i32 0, i32 poison, i32 0>, %x
  %rem = srem <3 x i32> %negx, %x
  ret <3 x i32> %rem
}

define <2 x i32> @negated_operand_vec_nonsplat(<2 x i32> %x) {
; CHECK-LABEL: @negated_operand_vec_nonsplat(
; CHECK-NEXT:    [[NEGX:%.*]] = sub <2 x i32> <i32 0, i32 1>, [[X:%.*]]
; CHECK-NEXT:    [[REM:%.*]] = srem <2 x i32> [[NEGX]], [[X]]
; CHECK-NEXT:    ret <2 x i32> [[REM]]
;
  %negx = sub <2 x i32> <i32 0, i32 1>, %x ; not 0, don't fold
  %rem = srem <2 x i32> %negx, %x
  ret <2 x i32> %rem
}

define i32 @negated_operand_commute(i32 %x) {
; CHECK-LABEL: @negated_operand_commute(
; CHECK-NEXT:    ret i32 0
;
  %negx = sub i32 0, %x
  %rem = srem i32 %x, %negx
  ret i32 %rem
}
