; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE


target triple = "aarch64-unknown-linux-gnu"

;
; Masked Load
;

define <4 x i8> @masked_load_v4i8(ptr %src, <4 x i1> %mask) {
; CHECK-LABEL: masked_load_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1b { z0.h }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v4i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #128
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 128
; NONEON-NOSVE-NEXT:    str d0, [sp, #112]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #114]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #116]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #118]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #112]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    and w9, w9, #0x4
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    bfxil w8, w11, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB0_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldrb w9, [x0]
; NONEON-NOSVE-NEXT:    strh wzr, [sp, #110]
; NONEON-NOSVE-NEXT:    stur wzr, [sp, #106]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #104]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB0_3
; NONEON-NOSVE-NEXT:    b .LBB0_4
; NONEON-NOSVE-NEXT:  .LBB0_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI0_0
; NONEON-NOSVE-NEXT:    ldr d0, [x9, :lo12:.LCPI0_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB0_4
; NONEON-NOSVE-NEXT:  .LBB0_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #1]
; NONEON-NOSVE-NEXT:    str d0, [sp, #80]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #84]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #96]
; NONEON-NOSVE-NEXT:    str w9, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #80]
; NONEON-NOSVE-NEXT:    str d0, [sp, #72]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #72]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #90]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #88]
; NONEON-NOSVE-NEXT:  .LBB0_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB0_7
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB0_8
; NONEON-NOSVE-NEXT:  .LBB0_6: // %else8
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB0_7: // %cond.load4
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #2]
; NONEON-NOSVE-NEXT:    str d0, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #64]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #64]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #48]
; NONEON-NOSVE-NEXT:    str d0, [sp, #40]
; NONEON-NOSVE-NEXT:    str w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB0_6
; NONEON-NOSVE-NEXT:  .LBB0_8: // %cond.load7
; NONEON-NOSVE-NEXT:    ldrb w8, [x0, #3]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str d0, [sp, #16]
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
  %load = call <4 x i8> @llvm.masked.load.v4i8(ptr %src, i32 8, <4 x i1> %mask, <4 x i8> zeroinitializer)
  ret <4 x i8> %load
}

define <8 x i8> @masked_load_v8i8(ptr %src, <8 x i1> %mask) {
; CHECK-LABEL: masked_load_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    lsl z0.b, z0.b, #7
; CHECK-NEXT:    asr z0.b, z0.b, #7
; CHECK-NEXT:    cmpne p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #272
; NONEON-NOSVE-NEXT:    str x29, [sp, #256] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 272
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    str d0, [sp, #240]
; NONEON-NOSVE-NEXT:    add x9, sp, #176
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #242]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #243]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #241]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #244]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #245]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #246]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #240]
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x4
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    sbfx w15, w15, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w8, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #247]
; NONEON-NOSVE-NEXT:    and w11, w11, #0x2
; NONEON-NOSVE-NEXT:    and w13, w13, #0x10
; NONEON-NOSVE-NEXT:    bfxil w11, w12, #0, #1
; NONEON-NOSVE-NEXT:    and w12, w14, #0x20
; NONEON-NOSVE-NEXT:    orr w8, w8, w13
; NONEON-NOSVE-NEXT:    and w13, w15, #0x40
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w11, w8
; NONEON-NOSVE-NEXT:    orr w11, w12, w13
; NONEON-NOSVE-NEXT:    orr w8, w8, w11
; NONEON-NOSVE-NEXT:    and w10, w10, #0x80
; NONEON-NOSVE-NEXT:    add w10, w8, w10
; NONEON-NOSVE-NEXT:    and w8, w10, #0xff
; NONEON-NOSVE-NEXT:    tbz w10, #0, .LBB1_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldrb w10, [x0]
; NONEON-NOSVE-NEXT:    strb wzr, [sp, #239]
; NONEON-NOSVE-NEXT:    sturh wzr, [x9, #61]
; NONEON-NOSVE-NEXT:    stur wzr, [x9, #57]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #232]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #232]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB1_3
; NONEON-NOSVE-NEXT:    b .LBB1_4
; NONEON-NOSVE-NEXT:  .LBB1_2:
; NONEON-NOSVE-NEXT:    adrp x10, .LCPI1_0
; NONEON-NOSVE-NEXT:    ldr d0, [x10, :lo12:.LCPI1_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB1_4
; NONEON-NOSVE-NEXT:  .LBB1_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #1]
; NONEON-NOSVE-NEXT:    str d0, [sp, #208]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #224]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #214]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #224]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #222]
; NONEON-NOSVE-NEXT:    str d0, [sp, #200]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #34]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #42]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #208]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #216]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #200]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #217]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #216]
; NONEON-NOSVE-NEXT:  .LBB1_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB1_12
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB1_13
; NONEON-NOSVE-NEXT:  .LBB1_6: // %else8
; NONEON-NOSVE-NEXT:    tbnz w8, #4, .LBB1_14
; NONEON-NOSVE-NEXT:  .LBB1_7: // %else11
; NONEON-NOSVE-NEXT:    tbnz w8, #5, .LBB1_15
; NONEON-NOSVE-NEXT:  .LBB1_8: // %else14
; NONEON-NOSVE-NEXT:    tbnz w8, #6, .LBB1_16
; NONEON-NOSVE-NEXT:  .LBB1_9: // %else17
; NONEON-NOSVE-NEXT:    tbz w8, #7, .LBB1_11
; NONEON-NOSVE-NEXT:  .LBB1_10: // %cond.load19
; NONEON-NOSVE-NEXT:    ldrb w8, [x0, #7]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    str d0, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:  .LBB1_11: // %else20
; NONEON-NOSVE-NEXT:    ldr x29, [sp, #256] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    add sp, sp, #272
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB1_12: // %cond.load4
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #2]
; NONEON-NOSVE-NEXT:    str d0, [sp, #176]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #192]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #183]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #192]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #191]
; NONEON-NOSVE-NEXT:    str d0, [sp, #168]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #3]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #11]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #176]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #184]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #168]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #186]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #184]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB1_6
; NONEON-NOSVE-NEXT:  .LBB1_13: // %cond.load7
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #3]
; NONEON-NOSVE-NEXT:    str d0, [sp, #144]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #160]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #148]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #160]
; NONEON-NOSVE-NEXT:    str w9, [sp, #156]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #146]
; NONEON-NOSVE-NEXT:    str d0, [sp, #136]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #154]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #144]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #152]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #136]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #155]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #152]
; NONEON-NOSVE-NEXT:    tbz w8, #4, .LBB1_7
; NONEON-NOSVE-NEXT:  .LBB1_14: // %cond.load10
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #4]
; NONEON-NOSVE-NEXT:    str d0, [sp, #112]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #128]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #119]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #128]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #127]
; NONEON-NOSVE-NEXT:    ldurh w9, [sp, #117]
; NONEON-NOSVE-NEXT:    str d0, [sp, #104]
; NONEON-NOSVE-NEXT:    sturh w9, [sp, #125]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #112]
; NONEON-NOSVE-NEXT:    str w9, [sp, #120]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #104]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #124]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #120]
; NONEON-NOSVE-NEXT:    tbz w8, #5, .LBB1_8
; NONEON-NOSVE-NEXT:  .LBB1_15: // %cond.load13
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #5]
; NONEON-NOSVE-NEXT:    str d0, [sp, #80]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #96]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #86]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #96]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #84]
; NONEON-NOSVE-NEXT:    str d0, [sp, #72]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #80]
; NONEON-NOSVE-NEXT:    str w9, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #72]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #93]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #88]
; NONEON-NOSVE-NEXT:    tbz w8, #6, .LBB1_9
; NONEON-NOSVE-NEXT:  .LBB1_16: // %cond.load16
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #6]
; NONEON-NOSVE-NEXT:    str d0, [sp, #48]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #64]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #55]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #64]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    str d0, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #48]
; NONEON-NOSVE-NEXT:    str w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #62]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:    tbnz w8, #7, .LBB1_10
; NONEON-NOSVE-NEXT:    b .LBB1_11
  %load = call <8 x i8> @llvm.masked.load.v8i8(ptr %src, i32 8, <8 x i1> %mask, <8 x i8> zeroinitializer)
  ret <8 x i8> %load
}

define <16 x i8> @masked_load_v16i8(ptr %src, <16 x i1> %mask) {
; CHECK-LABEL: masked_load_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    lsl z0.b, z0.b, #7
; CHECK-NEXT:    asr z0.b, z0.b, #7
; CHECK-NEXT:    cmpne p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    sub sp, sp, #992
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 1008
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    str q0, [sp, #976]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #978]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #979]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #977]
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #980]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #981]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #982]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #976]
; NONEON-NOSVE-NEXT:    sbfx w12, w12, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x4
; NONEON-NOSVE-NEXT:    and w9, w9, #0x8
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #983]
; NONEON-NOSVE-NEXT:    and w10, w10, #0x2
; NONEON-NOSVE-NEXT:    and w12, w12, #0x10
; NONEON-NOSVE-NEXT:    bfxil w10, w11, #0, #1
; NONEON-NOSVE-NEXT:    and w11, w13, #0x20
; NONEON-NOSVE-NEXT:    orr w8, w8, w12
; NONEON-NOSVE-NEXT:    and w12, w14, #0x40
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w10, w8
; NONEON-NOSVE-NEXT:    orr w10, w11, w12
; NONEON-NOSVE-NEXT:    orr w8, w8, w10
; NONEON-NOSVE-NEXT:    and w9, w9, #0xffffff80
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    add x9, sp, #720
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB2_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldrb w10, [x0]
; NONEON-NOSVE-NEXT:    strb wzr, [sp, #975]
; NONEON-NOSVE-NEXT:    sturh wzr, [x9, #253]
; NONEON-NOSVE-NEXT:    stur wzr, [x9, #249]
; NONEON-NOSVE-NEXT:    stur xzr, [x9, #241]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #960]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #960]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB2_3
; NONEON-NOSVE-NEXT:    b .LBB2_4
; NONEON-NOSVE-NEXT:  .LBB2_2:
; NONEON-NOSVE-NEXT:    adrp x10, .LCPI2_0
; NONEON-NOSVE-NEXT:    ldr q0, [x10, :lo12:.LCPI2_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB2_4
; NONEON-NOSVE-NEXT:  .LBB2_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #1]
; NONEON-NOSVE-NEXT:    str q0, [sp, #912]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #944]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #926]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #944]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #942]
; NONEON-NOSVE-NEXT:    str q0, [sp, #896]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #202]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #194]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #218]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #210]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #912]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #928]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #896]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #929]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #928]
; NONEON-NOSVE-NEXT:  .LBB2_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB2_20
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB2_21
; NONEON-NOSVE-NEXT:  .LBB2_6: // %else8
; NONEON-NOSVE-NEXT:    tbnz w8, #4, .LBB2_22
; NONEON-NOSVE-NEXT:  .LBB2_7: // %else11
; NONEON-NOSVE-NEXT:    add x9, sp, #464
; NONEON-NOSVE-NEXT:    tbnz w8, #5, .LBB2_23
; NONEON-NOSVE-NEXT:  .LBB2_8: // %else14
; NONEON-NOSVE-NEXT:    tbnz w8, #6, .LBB2_24
; NONEON-NOSVE-NEXT:  .LBB2_9: // %else17
; NONEON-NOSVE-NEXT:    tbnz w8, #7, .LBB2_25
; NONEON-NOSVE-NEXT:  .LBB2_10: // %else20
; NONEON-NOSVE-NEXT:    tbnz w8, #8, .LBB2_26
; NONEON-NOSVE-NEXT:  .LBB2_11: // %else23
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    tbnz w8, #9, .LBB2_27
; NONEON-NOSVE-NEXT:  .LBB2_12: // %else26
; NONEON-NOSVE-NEXT:    tbnz w8, #10, .LBB2_28
; NONEON-NOSVE-NEXT:  .LBB2_13: // %else29
; NONEON-NOSVE-NEXT:    tbnz w8, #11, .LBB2_29
; NONEON-NOSVE-NEXT:  .LBB2_14: // %else32
; NONEON-NOSVE-NEXT:    tbnz w8, #12, .LBB2_30
; NONEON-NOSVE-NEXT:  .LBB2_15: // %else35
; NONEON-NOSVE-NEXT:    tbnz w8, #13, .LBB2_31
; NONEON-NOSVE-NEXT:  .LBB2_16: // %else38
; NONEON-NOSVE-NEXT:    tbnz w8, #14, .LBB2_32
; NONEON-NOSVE-NEXT:  .LBB2_17: // %else41
; NONEON-NOSVE-NEXT:    tbz w8, #15, .LBB2_19
; NONEON-NOSVE-NEXT:  .LBB2_18: // %cond.load43
; NONEON-NOSVE-NEXT:    ldrb w8, [x0, #15]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:  .LBB2_19: // %else44
; NONEON-NOSVE-NEXT:    add sp, sp, #992
; NONEON-NOSVE-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB2_20: // %cond.load4
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #2]
; NONEON-NOSVE-NEXT:    str q0, [sp, #848]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #880]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #863]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #880]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #879]
; NONEON-NOSVE-NEXT:    str q0, [sp, #832]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #139]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #131]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #155]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #147]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #848]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #864]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #832]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #866]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #864]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB2_6
; NONEON-NOSVE-NEXT:  .LBB2_21: // %cond.load7
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #3]
; NONEON-NOSVE-NEXT:    str q0, [sp, #784]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #816]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #796]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #816]
; NONEON-NOSVE-NEXT:    str w10, [sp, #812]
; NONEON-NOSVE-NEXT:    str q0, [sp, #768]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #68]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #84]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #786]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #802]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #784]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #800]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #768]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #803]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #800]
; NONEON-NOSVE-NEXT:    tbz w8, #4, .LBB2_7
; NONEON-NOSVE-NEXT:  .LBB2_22: // %cond.load10
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #4]
; NONEON-NOSVE-NEXT:    str q0, [sp, #720]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #752]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #735]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #752]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #751]
; NONEON-NOSVE-NEXT:    str q0, [sp, #704]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #5]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #21]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #720]
; NONEON-NOSVE-NEXT:    str w9, [sp, #736]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #704]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #740]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #736]
; NONEON-NOSVE-NEXT:    add x9, sp, #464
; NONEON-NOSVE-NEXT:    tbz w8, #5, .LBB2_8
; NONEON-NOSVE-NEXT:  .LBB2_23: // %cond.load13
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #5]
; NONEON-NOSVE-NEXT:    str q0, [sp, #656]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #688]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #670]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #688]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #686]
; NONEON-NOSVE-NEXT:    str q0, [sp, #640]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #198]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #214]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #660]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #676]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #656]
; NONEON-NOSVE-NEXT:    str w10, [sp, #672]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #640]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #677]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #672]
; NONEON-NOSVE-NEXT:    tbz w8, #6, .LBB2_9
; NONEON-NOSVE-NEXT:  .LBB2_24: // %cond.load16
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #6]
; NONEON-NOSVE-NEXT:    str q0, [sp, #592]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #624]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #607]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #624]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #623]
; NONEON-NOSVE-NEXT:    str q0, [sp, #576]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #135]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #151]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #596]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #612]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #592]
; NONEON-NOSVE-NEXT:    str w10, [sp, #608]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #576]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #614]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #608]
; NONEON-NOSVE-NEXT:    tbz w8, #7, .LBB2_10
; NONEON-NOSVE-NEXT:  .LBB2_25: // %cond.load19
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #7]
; NONEON-NOSVE-NEXT:    str q0, [sp, #528]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #560]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #536]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #560]
; NONEON-NOSVE-NEXT:    str x10, [sp, #552]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #534]
; NONEON-NOSVE-NEXT:    str q0, [sp, #512]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #550]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #532]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #548]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #528]
; NONEON-NOSVE-NEXT:    str w10, [sp, #544]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #512]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #551]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #544]
; NONEON-NOSVE-NEXT:    tbz w8, #8, .LBB2_11
; NONEON-NOSVE-NEXT:  .LBB2_26: // %cond.load22
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #464]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #496]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #479]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #496]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #495]
; NONEON-NOSVE-NEXT:    str q0, [sp, #448]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    ldur w11, [x9, #9]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    stur w11, [x9, #25]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #464]
; NONEON-NOSVE-NEXT:    str x9, [sp, #480]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #448]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #488]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #480]
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    tbz w8, #9, .LBB2_12
; NONEON-NOSVE-NEXT:  .LBB2_27: // %cond.load25
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #9]
; NONEON-NOSVE-NEXT:    str q0, [sp, #400]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #432]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #414]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #432]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #430]
; NONEON-NOSVE-NEXT:    str q0, [sp, #384]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #202]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #218]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #408]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #424]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #400]
; NONEON-NOSVE-NEXT:    str x10, [sp, #416]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #384]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #425]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #416]
; NONEON-NOSVE-NEXT:    tbz w8, #10, .LBB2_13
; NONEON-NOSVE-NEXT:  .LBB2_28: // %cond.load28
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #10]
; NONEON-NOSVE-NEXT:    str q0, [sp, #336]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #368]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #351]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #368]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #367]
; NONEON-NOSVE-NEXT:    str q0, [sp, #320]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #139]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #155]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #344]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #360]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #336]
; NONEON-NOSVE-NEXT:    str x10, [sp, #352]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #320]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #362]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #352]
; NONEON-NOSVE-NEXT:    tbz w8, #11, .LBB2_14
; NONEON-NOSVE-NEXT:  .LBB2_29: // %cond.load31
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #11]
; NONEON-NOSVE-NEXT:    str q0, [sp, #272]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #304]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #284]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #304]
; NONEON-NOSVE-NEXT:    str w10, [sp, #300]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #282]
; NONEON-NOSVE-NEXT:    str q0, [sp, #256]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #298]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #280]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #296]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #272]
; NONEON-NOSVE-NEXT:    str x10, [sp, #288]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #256]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #299]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #288]
; NONEON-NOSVE-NEXT:    tbz w8, #12, .LBB2_15
; NONEON-NOSVE-NEXT:  .LBB2_30: // %cond.load34
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp, #208]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #240]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #223]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #240]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #239]
; NONEON-NOSVE-NEXT:    str q0, [sp, #192]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #216]
; NONEON-NOSVE-NEXT:    str w9, [sp, #232]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #208]
; NONEON-NOSVE-NEXT:    str x9, [sp, #224]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #192]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #236]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #224]
; NONEON-NOSVE-NEXT:    tbz w8, #13, .LBB2_16
; NONEON-NOSVE-NEXT:  .LBB2_31: // %cond.load37
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #13]
; NONEON-NOSVE-NEXT:    str q0, [sp, #144]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #176]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #158]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #176]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #174]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #156]
; NONEON-NOSVE-NEXT:    str q0, [sp, #128]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #172]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #152]
; NONEON-NOSVE-NEXT:    str w9, [sp, #168]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #144]
; NONEON-NOSVE-NEXT:    str x9, [sp, #160]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #128]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #173]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #160]
; NONEON-NOSVE-NEXT:    tbz w8, #14, .LBB2_17
; NONEON-NOSVE-NEXT:  .LBB2_32: // %cond.load40
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #14]
; NONEON-NOSVE-NEXT:    str q0, [sp, #80]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #112]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #95]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #112]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #111]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #92]
; NONEON-NOSVE-NEXT:    str q0, [sp, #64]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #108]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #88]
; NONEON-NOSVE-NEXT:    str w9, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #80]
; NONEON-NOSVE-NEXT:    str x9, [sp, #96]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #64]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #110]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #96]
; NONEON-NOSVE-NEXT:    tbnz w8, #15, .LBB2_18
; NONEON-NOSVE-NEXT:    b .LBB2_19
  %load = call <16 x i8> @llvm.masked.load.v16i8(ptr %src, i32 8, <16 x i1> %mask, <16 x i8> zeroinitializer)
  ret <16 x i8> %load
}

define <32 x i8> @masked_load_v32i8(ptr %src, <32 x i1> %mask) {
; CHECK-LABEL: masked_load_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    ldr w8, [sp, #224]
; CHECK-NEXT:    ldr w9, [sp, #216]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    strb w7, [sp, #6]
; CHECK-NEXT:    strb w8, [sp, #31]
; CHECK-NEXT:    ldr w8, [sp, #208]
; CHECK-NEXT:    strb w9, [sp, #30]
; CHECK-NEXT:    ldr w9, [sp, #200]
; CHECK-NEXT:    strb w8, [sp, #29]
; CHECK-NEXT:    ldr w8, [sp, #192]
; CHECK-NEXT:    strb w9, [sp, #28]
; CHECK-NEXT:    ldr w9, [sp, #184]
; CHECK-NEXT:    strb w8, [sp, #27]
; CHECK-NEXT:    ldr w8, [sp, #176]
; CHECK-NEXT:    strb w9, [sp, #26]
; CHECK-NEXT:    ldr w9, [sp, #168]
; CHECK-NEXT:    strb w8, [sp, #25]
; CHECK-NEXT:    ldr w8, [sp, #160]
; CHECK-NEXT:    strb w9, [sp, #24]
; CHECK-NEXT:    ldr w9, [sp, #152]
; CHECK-NEXT:    strb w8, [sp, #23]
; CHECK-NEXT:    ldr w8, [sp, #144]
; CHECK-NEXT:    strb w9, [sp, #22]
; CHECK-NEXT:    ldr w9, [sp, #136]
; CHECK-NEXT:    strb w8, [sp, #21]
; CHECK-NEXT:    ldr w8, [sp, #128]
; CHECK-NEXT:    strb w9, [sp, #20]
; CHECK-NEXT:    ldr w9, [sp, #120]
; CHECK-NEXT:    strb w8, [sp, #19]
; CHECK-NEXT:    ldr w8, [sp, #112]
; CHECK-NEXT:    strb w9, [sp, #18]
; CHECK-NEXT:    ldr w9, [sp, #104]
; CHECK-NEXT:    strb w8, [sp, #17]
; CHECK-NEXT:    ldr w8, [sp, #96]
; CHECK-NEXT:    strb w9, [sp, #16]
; CHECK-NEXT:    ldr w9, [sp, #88]
; CHECK-NEXT:    strb w8, [sp, #15]
; CHECK-NEXT:    ldr w8, [sp, #80]
; CHECK-NEXT:    strb w9, [sp, #14]
; CHECK-NEXT:    ldr w9, [sp, #72]
; CHECK-NEXT:    strb w8, [sp, #13]
; CHECK-NEXT:    ldr w8, [sp, #64]
; CHECK-NEXT:    strb w9, [sp, #12]
; CHECK-NEXT:    ldr w9, [sp, #56]
; CHECK-NEXT:    strb w8, [sp, #11]
; CHECK-NEXT:    ldr w8, [sp, #48]
; CHECK-NEXT:    strb w9, [sp, #10]
; CHECK-NEXT:    ldr w9, [sp, #40]
; CHECK-NEXT:    strb w8, [sp, #9]
; CHECK-NEXT:    ldr w8, [sp, #32]
; CHECK-NEXT:    strb w9, [sp, #8]
; CHECK-NEXT:    strb w8, [sp, #7]
; CHECK-NEXT:    mov w8, #16 // =0x10
; CHECK-NEXT:    strb w6, [sp, #5]
; CHECK-NEXT:    strb w5, [sp, #4]
; CHECK-NEXT:    strb w4, [sp, #3]
; CHECK-NEXT:    strb w3, [sp, #2]
; CHECK-NEXT:    strb w2, [sp, #1]
; CHECK-NEXT:    strb w1, [sp]
; CHECK-NEXT:    ldp q1, q0, [sp]
; CHECK-NEXT:    lsl z0.b, z0.b, #7
; CHECK-NEXT:    lsl z1.b, z1.b, #7
; CHECK-NEXT:    asr z0.b, z0.b, #7
; CHECK-NEXT:    asr z1.b, z1.b, #7
; CHECK-NEXT:    cmpne p1.b, p0/z, z0.b, #0
; CHECK-NEXT:    cmpne p0.b, p0/z, z1.b, #0
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    ld1b { z1.b }, p1/z, [x0, x8]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    sub sp, sp, #2000
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 2016
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #2096]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #2104]
; NONEON-NOSVE-NEXT:    sbfx w15, w7, #0, #1
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #2112]
; NONEON-NOSVE-NEXT:    ldr w11, [sp, #2088]
; NONEON-NOSVE-NEXT:    ldr w12, [sp, #2120]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    ldr w13, [sp, #2136]
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    ldr w14, [sp, #2144]
; NONEON-NOSVE-NEXT:    ldr w16, [sp, #2016]
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    and w9, w9, #0x4
; NONEON-NOSVE-NEXT:    bfxil w8, w11, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w12, #0, #1
; NONEON-NOSVE-NEXT:    ldr w12, [sp, #2128]
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    and w10, w11, #0x10
; NONEON-NOSVE-NEXT:    sbfx w11, w12, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    sbfx w10, w13, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w12, w4, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    and w9, w11, #0x20
; NONEON-NOSVE-NEXT:    sbfx w11, w3, #0, #1
; NONEON-NOSVE-NEXT:    and w10, w10, #0x40
; NONEON-NOSVE-NEXT:    sbfx w13, w5, #0, #1
; NONEON-NOSVE-NEXT:    and w12, w12, #0x8
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    sbfx w10, w2, #0, #1
; NONEON-NOSVE-NEXT:    and w11, w11, #0x4
; NONEON-NOSVE-NEXT:    orr w11, w11, w12
; NONEON-NOSVE-NEXT:    and w12, w13, #0x10
; NONEON-NOSVE-NEXT:    sbfx w13, w6, #0, #1
; NONEON-NOSVE-NEXT:    and w10, w10, #0x2
; NONEON-NOSVE-NEXT:    orr w11, w11, w12
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    bfxil w10, w1, #0, #1
; NONEON-NOSVE-NEXT:    and w12, w13, #0x20
; NONEON-NOSVE-NEXT:    and w13, w15, #0x40
; NONEON-NOSVE-NEXT:    sbfx w15, w16, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w10, w11
; NONEON-NOSVE-NEXT:    orr w10, w12, w13
; NONEON-NOSVE-NEXT:    and w11, w14, #0xff80
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    and w10, w15, #0xff80
; NONEON-NOSVE-NEXT:    add w11, w8, w11
; NONEON-NOSVE-NEXT:    add w8, w9, w10
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI3_0
; NONEON-NOSVE-NEXT:    bfi w8, w11, #16, #16
; NONEON-NOSVE-NEXT:    ldr q1, [x9, :lo12:.LCPI3_0]
; NONEON-NOSVE-NEXT:    add x9, sp, #1744
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB3_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldrb w10, [x0]
; NONEON-NOSVE-NEXT:    strb wzr, [sp, #1999]
; NONEON-NOSVE-NEXT:    sturh wzr, [x9, #253]
; NONEON-NOSVE-NEXT:    stur wzr, [x9, #249]
; NONEON-NOSVE-NEXT:    stur xzr, [x9, #241]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1984]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1984]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB3_3
; NONEON-NOSVE-NEXT:    b .LBB3_4
; NONEON-NOSVE-NEXT:  .LBB3_2:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    ldr q0, [sp], #16
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB3_4
; NONEON-NOSVE-NEXT:  .LBB3_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #1]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1936]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1968]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1950]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1968]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1966]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1920]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #202]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #194]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #218]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #210]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1936]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1952]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1920]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1953]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1952]
; NONEON-NOSVE-NEXT:  .LBB3_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB3_36
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB3_37
; NONEON-NOSVE-NEXT:  .LBB3_6: // %else8
; NONEON-NOSVE-NEXT:    tbnz w8, #4, .LBB3_38
; NONEON-NOSVE-NEXT:  .LBB3_7: // %else11
; NONEON-NOSVE-NEXT:    add x9, sp, #1488
; NONEON-NOSVE-NEXT:    tbnz w8, #5, .LBB3_39
; NONEON-NOSVE-NEXT:  .LBB3_8: // %else14
; NONEON-NOSVE-NEXT:    tbnz w8, #6, .LBB3_40
; NONEON-NOSVE-NEXT:  .LBB3_9: // %else17
; NONEON-NOSVE-NEXT:    tbnz w8, #7, .LBB3_41
; NONEON-NOSVE-NEXT:  .LBB3_10: // %else20
; NONEON-NOSVE-NEXT:    tbnz w8, #8, .LBB3_42
; NONEON-NOSVE-NEXT:  .LBB3_11: // %else23
; NONEON-NOSVE-NEXT:    add x9, sp, #1232
; NONEON-NOSVE-NEXT:    tbnz w8, #9, .LBB3_43
; NONEON-NOSVE-NEXT:  .LBB3_12: // %else26
; NONEON-NOSVE-NEXT:    tbnz w8, #10, .LBB3_44
; NONEON-NOSVE-NEXT:  .LBB3_13: // %else29
; NONEON-NOSVE-NEXT:    tbnz w8, #11, .LBB3_45
; NONEON-NOSVE-NEXT:  .LBB3_14: // %else32
; NONEON-NOSVE-NEXT:    tbnz w8, #12, .LBB3_46
; NONEON-NOSVE-NEXT:  .LBB3_15: // %else35
; NONEON-NOSVE-NEXT:    tbnz w8, #13, .LBB3_47
; NONEON-NOSVE-NEXT:  .LBB3_16: // %else38
; NONEON-NOSVE-NEXT:    tbnz w8, #14, .LBB3_48
; NONEON-NOSVE-NEXT:  .LBB3_17: // %else41
; NONEON-NOSVE-NEXT:    tbnz w8, #15, .LBB3_49
; NONEON-NOSVE-NEXT:  .LBB3_18: // %else44
; NONEON-NOSVE-NEXT:    tbnz w8, #16, .LBB3_50
; NONEON-NOSVE-NEXT:  .LBB3_19: // %else47
; NONEON-NOSVE-NEXT:    add x9, sp, #720
; NONEON-NOSVE-NEXT:    tbnz w8, #17, .LBB3_51
; NONEON-NOSVE-NEXT:  .LBB3_20: // %else50
; NONEON-NOSVE-NEXT:    tbnz w8, #18, .LBB3_52
; NONEON-NOSVE-NEXT:  .LBB3_21: // %else53
; NONEON-NOSVE-NEXT:    tbnz w8, #19, .LBB3_53
; NONEON-NOSVE-NEXT:  .LBB3_22: // %else56
; NONEON-NOSVE-NEXT:    tbnz w8, #20, .LBB3_54
; NONEON-NOSVE-NEXT:  .LBB3_23: // %else59
; NONEON-NOSVE-NEXT:    add x9, sp, #464
; NONEON-NOSVE-NEXT:    tbnz w8, #21, .LBB3_55
; NONEON-NOSVE-NEXT:  .LBB3_24: // %else62
; NONEON-NOSVE-NEXT:    tbnz w8, #22, .LBB3_56
; NONEON-NOSVE-NEXT:  .LBB3_25: // %else65
; NONEON-NOSVE-NEXT:    tbnz w8, #23, .LBB3_57
; NONEON-NOSVE-NEXT:  .LBB3_26: // %else68
; NONEON-NOSVE-NEXT:    tbnz w8, #24, .LBB3_58
; NONEON-NOSVE-NEXT:  .LBB3_27: // %else71
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    tbnz w8, #25, .LBB3_59
; NONEON-NOSVE-NEXT:  .LBB3_28: // %else74
; NONEON-NOSVE-NEXT:    tbnz w8, #26, .LBB3_60
; NONEON-NOSVE-NEXT:  .LBB3_29: // %else77
; NONEON-NOSVE-NEXT:    tbnz w8, #27, .LBB3_61
; NONEON-NOSVE-NEXT:  .LBB3_30: // %else80
; NONEON-NOSVE-NEXT:    tbnz w8, #28, .LBB3_62
; NONEON-NOSVE-NEXT:  .LBB3_31: // %else83
; NONEON-NOSVE-NEXT:    tbnz w8, #29, .LBB3_63
; NONEON-NOSVE-NEXT:  .LBB3_32: // %else86
; NONEON-NOSVE-NEXT:    tbnz w8, #30, .LBB3_64
; NONEON-NOSVE-NEXT:  .LBB3_33: // %else89
; NONEON-NOSVE-NEXT:    tbz w8, #31, .LBB3_35
; NONEON-NOSVE-NEXT:  .LBB3_34: // %cond.load91
; NONEON-NOSVE-NEXT:    ldrb w8, [x0, #31]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:  .LBB3_35: // %else92
; NONEON-NOSVE-NEXT:    add sp, sp, #2000
; NONEON-NOSVE-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB3_36: // %cond.load4
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #2]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1872]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1904]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1887]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1904]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1903]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1856]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #139]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #131]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #155]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #147]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1872]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1888]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1856]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1890]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1888]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB3_6
; NONEON-NOSVE-NEXT:  .LBB3_37: // %cond.load7
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #3]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1808]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1840]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #1820]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1840]
; NONEON-NOSVE-NEXT:    str w10, [sp, #1836]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1792]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #68]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #84]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1810]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1826]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1808]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1824]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1792]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1827]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1824]
; NONEON-NOSVE-NEXT:    tbz w8, #4, .LBB3_7
; NONEON-NOSVE-NEXT:  .LBB3_38: // %cond.load10
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #4]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1744]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1776]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1759]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1776]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1775]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1728]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #5]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #21]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #1744]
; NONEON-NOSVE-NEXT:    str w9, [sp, #1760]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1728]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1764]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1760]
; NONEON-NOSVE-NEXT:    add x9, sp, #1488
; NONEON-NOSVE-NEXT:    tbz w8, #5, .LBB3_8
; NONEON-NOSVE-NEXT:  .LBB3_39: // %cond.load13
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #5]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1680]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1712]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1694]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1712]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1710]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1664]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #198]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #214]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1684]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1700]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #1680]
; NONEON-NOSVE-NEXT:    str w10, [sp, #1696]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1664]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1701]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1696]
; NONEON-NOSVE-NEXT:    tbz w8, #6, .LBB3_9
; NONEON-NOSVE-NEXT:  .LBB3_40: // %cond.load16
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #6]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1616]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1648]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1631]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1648]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1647]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1600]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #135]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #151]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1620]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1636]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #1616]
; NONEON-NOSVE-NEXT:    str w10, [sp, #1632]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1600]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1638]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1632]
; NONEON-NOSVE-NEXT:    tbz w8, #7, .LBB3_10
; NONEON-NOSVE-NEXT:  .LBB3_41: // %cond.load19
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #7]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1552]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1584]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #1560]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1584]
; NONEON-NOSVE-NEXT:    str x10, [sp, #1576]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1558]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1536]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1574]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1556]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1572]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #1552]
; NONEON-NOSVE-NEXT:    str w10, [sp, #1568]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1536]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1575]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1568]
; NONEON-NOSVE-NEXT:    tbz w8, #8, .LBB3_11
; NONEON-NOSVE-NEXT:  .LBB3_42: // %cond.load22
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1488]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1520]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1503]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1520]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1519]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1472]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    ldur w11, [x9, #9]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    stur w11, [x9, #25]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #1488]
; NONEON-NOSVE-NEXT:    str x9, [sp, #1504]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1472]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1512]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1504]
; NONEON-NOSVE-NEXT:    add x9, sp, #1232
; NONEON-NOSVE-NEXT:    tbz w8, #9, .LBB3_12
; NONEON-NOSVE-NEXT:  .LBB3_43: // %cond.load25
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #9]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1424]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1456]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1438]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1456]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1454]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1408]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #202]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #218]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1432]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1448]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #1424]
; NONEON-NOSVE-NEXT:    str x10, [sp, #1440]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1408]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1449]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1440]
; NONEON-NOSVE-NEXT:    tbz w8, #10, .LBB3_13
; NONEON-NOSVE-NEXT:  .LBB3_44: // %cond.load28
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #10]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1360]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1392]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1375]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1392]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1391]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1344]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #139]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #155]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1368]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1384]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #1360]
; NONEON-NOSVE-NEXT:    str x10, [sp, #1376]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1344]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1386]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1376]
; NONEON-NOSVE-NEXT:    tbz w8, #11, .LBB3_14
; NONEON-NOSVE-NEXT:  .LBB3_45: // %cond.load31
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #11]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1296]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1328]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #1308]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1328]
; NONEON-NOSVE-NEXT:    str w10, [sp, #1324]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1306]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1280]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1322]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #1304]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #1320]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #1296]
; NONEON-NOSVE-NEXT:    str x10, [sp, #1312]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1280]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1323]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1312]
; NONEON-NOSVE-NEXT:    tbz w8, #12, .LBB3_15
; NONEON-NOSVE-NEXT:  .LBB3_46: // %cond.load34
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1232]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1264]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #1247]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1264]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #1263]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1216]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #1240]
; NONEON-NOSVE-NEXT:    str w9, [sp, #1256]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #1232]
; NONEON-NOSVE-NEXT:    str x9, [sp, #1248]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1216]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1260]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1248]
; NONEON-NOSVE-NEXT:    tbz w8, #13, .LBB3_16
; NONEON-NOSVE-NEXT:  .LBB3_47: // %cond.load37
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #13]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1168]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1200]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #1182]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1200]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #1198]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1180]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1152]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1196]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #1176]
; NONEON-NOSVE-NEXT:    str w9, [sp, #1192]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #1168]
; NONEON-NOSVE-NEXT:    str x9, [sp, #1184]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1152]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1197]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1184]
; NONEON-NOSVE-NEXT:    tbz w8, #14, .LBB3_17
; NONEON-NOSVE-NEXT:  .LBB3_48: // %cond.load40
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #14]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1104]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1136]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1119]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1136]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1135]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #1116]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1088]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #1132]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #1112]
; NONEON-NOSVE-NEXT:    str w9, [sp, #1128]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #1104]
; NONEON-NOSVE-NEXT:    str x9, [sp, #1120]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1088]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1134]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1120]
; NONEON-NOSVE-NEXT:    tbz w8, #15, .LBB3_18
; NONEON-NOSVE-NEXT:  .LBB3_49: // %cond.load43
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #15]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1024]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1072]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1038]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1072]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1070]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #1036]
; NONEON-NOSVE-NEXT:    str q0, [sp, #1040]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #1068]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #1032]
; NONEON-NOSVE-NEXT:    str w9, [sp, #1064]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #1024]
; NONEON-NOSVE-NEXT:    str x9, [sp, #1056]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1040]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1071]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #1056]
; NONEON-NOSVE-NEXT:    tbz w8, #16, .LBB3_19
; NONEON-NOSVE-NEXT:  .LBB3_50: // %cond.load46
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [sp, #976]
; NONEON-NOSVE-NEXT:    add x10, sp, #976
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1008]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #991]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #1008]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #1007]
; NONEON-NOSVE-NEXT:    str q1, [sp, #960]
; NONEON-NOSVE-NEXT:    ldurh w9, [x10, #13]
; NONEON-NOSVE-NEXT:    ldur w11, [x10, #9]
; NONEON-NOSVE-NEXT:    sturh w9, [x10, #29]
; NONEON-NOSVE-NEXT:    ldur x9, [x10, #1]
; NONEON-NOSVE-NEXT:    stur w11, [x10, #25]
; NONEON-NOSVE-NEXT:    stur x9, [x10, #17]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #960]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #992]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #992]
; NONEON-NOSVE-NEXT:    add x9, sp, #720
; NONEON-NOSVE-NEXT:    tbz w8, #17, .LBB3_20
; NONEON-NOSVE-NEXT:  .LBB3_51: // %cond.load49
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #17]
; NONEON-NOSVE-NEXT:    str q1, [sp, #912]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #944]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #926]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #944]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #942]
; NONEON-NOSVE-NEXT:    str q1, [sp, #896]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #202]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #194]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #218]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #210]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #912]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #928]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #896]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #929]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #928]
; NONEON-NOSVE-NEXT:    tbz w8, #18, .LBB3_21
; NONEON-NOSVE-NEXT:  .LBB3_52: // %cond.load52
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #18]
; NONEON-NOSVE-NEXT:    str q1, [sp, #848]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #880]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #863]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #880]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #879]
; NONEON-NOSVE-NEXT:    str q1, [sp, #832]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #139]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #131]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #155]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #147]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #848]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #864]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #832]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #866]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #864]
; NONEON-NOSVE-NEXT:    tbz w8, #19, .LBB3_22
; NONEON-NOSVE-NEXT:  .LBB3_53: // %cond.load55
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #19]
; NONEON-NOSVE-NEXT:    str q1, [sp, #784]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #816]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #796]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #816]
; NONEON-NOSVE-NEXT:    str w10, [sp, #812]
; NONEON-NOSVE-NEXT:    str q1, [sp, #768]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #68]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #84]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #786]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #802]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #784]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #800]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #768]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #803]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #800]
; NONEON-NOSVE-NEXT:    tbz w8, #20, .LBB3_23
; NONEON-NOSVE-NEXT:  .LBB3_54: // %cond.load58
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #20]
; NONEON-NOSVE-NEXT:    str q1, [sp, #720]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #752]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #735]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #752]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #751]
; NONEON-NOSVE-NEXT:    str q1, [sp, #704]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #5]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #21]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #720]
; NONEON-NOSVE-NEXT:    str w9, [sp, #736]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #704]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #740]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #736]
; NONEON-NOSVE-NEXT:    add x9, sp, #464
; NONEON-NOSVE-NEXT:    tbz w8, #21, .LBB3_24
; NONEON-NOSVE-NEXT:  .LBB3_55: // %cond.load61
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #21]
; NONEON-NOSVE-NEXT:    str q1, [sp, #656]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #688]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #670]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #688]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #686]
; NONEON-NOSVE-NEXT:    str q1, [sp, #640]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #198]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #214]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #660]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #676]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #656]
; NONEON-NOSVE-NEXT:    str w10, [sp, #672]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #640]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #677]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #672]
; NONEON-NOSVE-NEXT:    tbz w8, #22, .LBB3_25
; NONEON-NOSVE-NEXT:  .LBB3_56: // %cond.load64
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #22]
; NONEON-NOSVE-NEXT:    str q1, [sp, #592]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #624]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #607]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #624]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #623]
; NONEON-NOSVE-NEXT:    str q1, [sp, #576]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #135]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #151]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #596]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #612]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #592]
; NONEON-NOSVE-NEXT:    str w10, [sp, #608]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #576]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #614]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #608]
; NONEON-NOSVE-NEXT:    tbz w8, #23, .LBB3_26
; NONEON-NOSVE-NEXT:  .LBB3_57: // %cond.load67
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #23]
; NONEON-NOSVE-NEXT:    str q1, [sp, #528]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #560]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #536]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #560]
; NONEON-NOSVE-NEXT:    str x10, [sp, #552]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #534]
; NONEON-NOSVE-NEXT:    str q1, [sp, #512]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #550]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #532]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #548]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #528]
; NONEON-NOSVE-NEXT:    str w10, [sp, #544]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #512]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #551]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #544]
; NONEON-NOSVE-NEXT:    tbz w8, #24, .LBB3_27
; NONEON-NOSVE-NEXT:  .LBB3_58: // %cond.load70
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #24]
; NONEON-NOSVE-NEXT:    str q1, [sp, #464]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #496]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #479]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #496]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #495]
; NONEON-NOSVE-NEXT:    str q1, [sp, #448]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    ldur w11, [x9, #9]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    stur w11, [x9, #25]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #464]
; NONEON-NOSVE-NEXT:    str x9, [sp, #480]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #448]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #488]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #480]
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    tbz w8, #25, .LBB3_28
; NONEON-NOSVE-NEXT:  .LBB3_59: // %cond.load73
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #25]
; NONEON-NOSVE-NEXT:    str q1, [sp, #400]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #432]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #414]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #432]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #430]
; NONEON-NOSVE-NEXT:    str q1, [sp, #384]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #202]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #218]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #408]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #424]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #400]
; NONEON-NOSVE-NEXT:    str x10, [sp, #416]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #384]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #425]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #416]
; NONEON-NOSVE-NEXT:    tbz w8, #26, .LBB3_29
; NONEON-NOSVE-NEXT:  .LBB3_60: // %cond.load76
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #26]
; NONEON-NOSVE-NEXT:    str q1, [sp, #336]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #368]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #351]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #368]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #367]
; NONEON-NOSVE-NEXT:    str q1, [sp, #320]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #139]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #155]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #344]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #360]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #336]
; NONEON-NOSVE-NEXT:    str x10, [sp, #352]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #320]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #362]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #352]
; NONEON-NOSVE-NEXT:    tbz w8, #27, .LBB3_30
; NONEON-NOSVE-NEXT:  .LBB3_61: // %cond.load79
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #27]
; NONEON-NOSVE-NEXT:    str q1, [sp, #272]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #304]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #284]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #304]
; NONEON-NOSVE-NEXT:    str w10, [sp, #300]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #282]
; NONEON-NOSVE-NEXT:    str q1, [sp, #256]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #298]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #280]
; NONEON-NOSVE-NEXT:    strh w10, [sp, #296]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #272]
; NONEON-NOSVE-NEXT:    str x10, [sp, #288]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #256]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #299]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #288]
; NONEON-NOSVE-NEXT:    tbz w8, #28, .LBB3_31
; NONEON-NOSVE-NEXT:  .LBB3_62: // %cond.load82
; NONEON-NOSVE-NEXT:    ldrb w10, [x0, #28]
; NONEON-NOSVE-NEXT:    str q1, [sp, #208]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #240]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #223]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #240]
; NONEON-NOSVE-NEXT:    strb w10, [sp, #239]
; NONEON-NOSVE-NEXT:    str q1, [sp, #192]
; NONEON-NOSVE-NEXT:    ldurh w10, [x9, #13]
; NONEON-NOSVE-NEXT:    sturh w10, [x9, #29]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #216]
; NONEON-NOSVE-NEXT:    str w9, [sp, #232]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #208]
; NONEON-NOSVE-NEXT:    str x9, [sp, #224]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #192]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #236]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #224]
; NONEON-NOSVE-NEXT:    tbz w8, #29, .LBB3_32
; NONEON-NOSVE-NEXT:  .LBB3_63: // %cond.load85
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #29]
; NONEON-NOSVE-NEXT:    str q1, [sp, #144]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #176]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #158]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #176]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #174]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #156]
; NONEON-NOSVE-NEXT:    str q1, [sp, #128]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #172]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #152]
; NONEON-NOSVE-NEXT:    str w9, [sp, #168]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #144]
; NONEON-NOSVE-NEXT:    str x9, [sp, #160]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #128]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #173]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #160]
; NONEON-NOSVE-NEXT:    tbz w8, #30, .LBB3_33
; NONEON-NOSVE-NEXT:  .LBB3_64: // %cond.load88
; NONEON-NOSVE-NEXT:    ldrb w9, [x0, #30]
; NONEON-NOSVE-NEXT:    str q1, [sp, #80]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #112]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #95]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #112]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #111]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #92]
; NONEON-NOSVE-NEXT:    str q1, [sp, #64]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #108]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #88]
; NONEON-NOSVE-NEXT:    str w9, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #80]
; NONEON-NOSVE-NEXT:    str x9, [sp, #96]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #64]
; NONEON-NOSVE-NEXT:    strb w9, [sp, #110]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #96]
; NONEON-NOSVE-NEXT:    tbnz w8, #31, .LBB3_34
; NONEON-NOSVE-NEXT:    b .LBB3_35
  %load = call <32 x i8> @llvm.masked.load.v32i8(ptr %src, i32 8, <32 x i1> %mask, <32 x i8> zeroinitializer)
  ret <32 x i8> %load
}

define <2 x half> @masked_load_v2f16(ptr %src, <2 x i1> %mask) {
; CHECK-LABEL: masked_load_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fmov s1, wzr
; CHECK-NEXT:    mov z2.s, z0.s[1]
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    zip1 z0.h, z0.h, z2.h
; CHECK-NEXT:    zip1 z1.h, z1.h, z1.h
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v2f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    str d0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    bfxil w8, w9, #0, #1
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB4_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    fmov s0, wzr
; NONEON-NOSVE-NEXT:    ldr h1, [x0]
; NONEON-NOSVE-NEXT:    str h1, [sp, #24]
; NONEON-NOSVE-NEXT:    str h0, [sp, #26]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB4_3
; NONEON-NOSVE-NEXT:    b .LBB4_4
; NONEON-NOSVE-NEXT:  .LBB4_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI4_0
; NONEON-NOSVE-NEXT:    ldr d0, [x9, :lo12:.LCPI4_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB4_4
; NONEON-NOSVE-NEXT:  .LBB4_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #2]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    str h1, [sp, #18]
; NONEON-NOSVE-NEXT:    str h0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:  .LBB4_4: // %else2
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %load = call <2 x half> @llvm.masked.load.v2f16(ptr %src, i32 8, <2 x i1> %mask, <2 x half> zeroinitializer)
  ret <2 x half> %load
}

define <4 x half> @masked_load_v4f16(ptr %src, <4 x i1> %mask) {
; CHECK-LABEL: masked_load_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #128
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 128
; NONEON-NOSVE-NEXT:    str d0, [sp, #112]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #114]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #116]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #118]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #112]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    and w9, w9, #0x4
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    bfxil w8, w11, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB5_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    fmov s0, wzr
; NONEON-NOSVE-NEXT:    ldr h1, [x0]
; NONEON-NOSVE-NEXT:    stur wzr, [sp, #106]
; NONEON-NOSVE-NEXT:    str h1, [sp, #104]
; NONEON-NOSVE-NEXT:    str h0, [sp, #110]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #104]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB5_3
; NONEON-NOSVE-NEXT:    b .LBB5_4
; NONEON-NOSVE-NEXT:  .LBB5_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI5_0
; NONEON-NOSVE-NEXT:    ldr d0, [x9, :lo12:.LCPI5_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB5_4
; NONEON-NOSVE-NEXT:  .LBB5_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #2]
; NONEON-NOSVE-NEXT:    str d0, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #84]
; NONEON-NOSVE-NEXT:    str h1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #96]
; NONEON-NOSVE-NEXT:    str w9, [sp, #92]
; NONEON-NOSVE-NEXT:    str d0, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #80]
; NONEON-NOSVE-NEXT:    str h0, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #72]
; NONEON-NOSVE-NEXT:    str h0, [sp, #90]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #88]
; NONEON-NOSVE-NEXT:  .LBB5_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB5_7
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB5_8
; NONEON-NOSVE-NEXT:  .LBB5_6: // %else8
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB5_7: // %cond.load4
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #4]
; NONEON-NOSVE-NEXT:    str d0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #48]
; NONEON-NOSVE-NEXT:    str h1, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #64]
; NONEON-NOSVE-NEXT:    str w9, [sp, #56]
; NONEON-NOSVE-NEXT:    str d0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #54]
; NONEON-NOSVE-NEXT:    str h0, [sp, #62]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #40]
; NONEON-NOSVE-NEXT:    str h0, [sp, #60]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB5_6
; NONEON-NOSVE-NEXT:  .LBB5_8: // %cond.load7
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #6]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str h1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    str w8, [sp, #24]
; NONEON-NOSVE-NEXT:    str d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #12]
; NONEON-NOSVE-NEXT:    str h0, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #16]
; NONEON-NOSVE-NEXT:    str h0, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #128
; NONEON-NOSVE-NEXT:    ret
  %load = call <4 x half> @llvm.masked.load.v4f16(ptr %src, i32 8, <4 x i1> %mask, <4 x half> zeroinitializer)
  ret <4 x half> %load
}

define <8 x half> @masked_load_v8f16(ptr %src, <8 x i1> %mask) {
; CHECK-LABEL: masked_load_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #496
; NONEON-NOSVE-NEXT:    str x29, [sp, #480] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 496
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    str d0, [sp, #464]
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #466]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #467]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #465]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #468]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #469]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #470]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #464]
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x4
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    sbfx w15, w15, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w8, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #471]
; NONEON-NOSVE-NEXT:    and w11, w11, #0x2
; NONEON-NOSVE-NEXT:    and w13, w13, #0x10
; NONEON-NOSVE-NEXT:    bfxil w11, w12, #0, #1
; NONEON-NOSVE-NEXT:    and w12, w14, #0x20
; NONEON-NOSVE-NEXT:    orr w8, w8, w13
; NONEON-NOSVE-NEXT:    and w13, w15, #0x40
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w11, w8
; NONEON-NOSVE-NEXT:    orr w11, w12, w13
; NONEON-NOSVE-NEXT:    orr w8, w8, w11
; NONEON-NOSVE-NEXT:    and w10, w10, #0x80
; NONEON-NOSVE-NEXT:    add w10, w8, w10
; NONEON-NOSVE-NEXT:    and w8, w10, #0xff
; NONEON-NOSVE-NEXT:    tbz w10, #0, .LBB6_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    fmov s0, wzr
; NONEON-NOSVE-NEXT:    ldr h1, [x0]
; NONEON-NOSVE-NEXT:    stur wzr, [x9, #250]
; NONEON-NOSVE-NEXT:    stur xzr, [x9, #242]
; NONEON-NOSVE-NEXT:    str h1, [sp, #448]
; NONEON-NOSVE-NEXT:    str h0, [sp, #462]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #448]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB6_3
; NONEON-NOSVE-NEXT:    b .LBB6_4
; NONEON-NOSVE-NEXT:  .LBB6_2:
; NONEON-NOSVE-NEXT:    adrp x10, .LCPI6_0
; NONEON-NOSVE-NEXT:    ldr q0, [x10, :lo12:.LCPI6_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB6_4
; NONEON-NOSVE-NEXT:  .LBB6_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #2]
; NONEON-NOSVE-NEXT:    str q0, [sp, #400]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #412]
; NONEON-NOSVE-NEXT:    str h1, [sp, #432]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #432]
; NONEON-NOSVE-NEXT:    str w10, [sp, #428]
; NONEON-NOSVE-NEXT:    str q0, [sp, #384]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #196]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #212]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #400]
; NONEON-NOSVE-NEXT:    str h0, [sp, #416]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #384]
; NONEON-NOSVE-NEXT:    str h0, [sp, #418]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #416]
; NONEON-NOSVE-NEXT:  .LBB6_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB6_12
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB6_13
; NONEON-NOSVE-NEXT:  .LBB6_6: // %else8
; NONEON-NOSVE-NEXT:    tbnz w8, #4, .LBB6_14
; NONEON-NOSVE-NEXT:  .LBB6_7: // %else11
; NONEON-NOSVE-NEXT:    tbnz w8, #5, .LBB6_15
; NONEON-NOSVE-NEXT:  .LBB6_8: // %else14
; NONEON-NOSVE-NEXT:    tbnz w8, #6, .LBB6_16
; NONEON-NOSVE-NEXT:  .LBB6_9: // %else17
; NONEON-NOSVE-NEXT:    tbz w8, #7, .LBB6_11
; NONEON-NOSVE-NEXT:  .LBB6_10: // %cond.load19
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #14]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str h1, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #12]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    str h0, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #16]
; NONEON-NOSVE-NEXT:    str h0, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:  .LBB6_11: // %else20
; NONEON-NOSVE-NEXT:    ldr x29, [sp, #480] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    add sp, sp, #496
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB6_12: // %cond.load4
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #4]
; NONEON-NOSVE-NEXT:    str q0, [sp, #336]
; NONEON-NOSVE-NEXT:    str h1, [sp, #368]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #368]
; NONEON-NOSVE-NEXT:    str q0, [sp, #320]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #350]
; NONEON-NOSVE-NEXT:    str h0, [sp, #366]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #134]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #150]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #336]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #320]
; NONEON-NOSVE-NEXT:    str w10, [sp, #352]
; NONEON-NOSVE-NEXT:    str h0, [sp, #356]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #352]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB6_6
; NONEON-NOSVE-NEXT:  .LBB6_13: // %cond.load7
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #6]
; NONEON-NOSVE-NEXT:    str q0, [sp, #272]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #280]
; NONEON-NOSVE-NEXT:    str h1, [sp, #304]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #304]
; NONEON-NOSVE-NEXT:    str x10, [sp, #296]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #272]
; NONEON-NOSVE-NEXT:    str q0, [sp, #256]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #276]
; NONEON-NOSVE-NEXT:    str w10, [sp, #288]
; NONEON-NOSVE-NEXT:    str h0, [sp, #292]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #256]
; NONEON-NOSVE-NEXT:    str h0, [sp, #294]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #288]
; NONEON-NOSVE-NEXT:    tbz w8, #4, .LBB6_7
; NONEON-NOSVE-NEXT:  .LBB6_14: // %cond.load10
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #208]
; NONEON-NOSVE-NEXT:    str h1, [sp, #240]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #240]
; NONEON-NOSVE-NEXT:    str q0, [sp, #192]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #222]
; NONEON-NOSVE-NEXT:    str h0, [sp, #238]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #10]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #26]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #208]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #192]
; NONEON-NOSVE-NEXT:    str x9, [sp, #224]
; NONEON-NOSVE-NEXT:    str h0, [sp, #232]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #224]
; NONEON-NOSVE-NEXT:    tbz w8, #5, .LBB6_8
; NONEON-NOSVE-NEXT:  .LBB6_15: // %cond.load13
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #10]
; NONEON-NOSVE-NEXT:    str q0, [sp, #144]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #156]
; NONEON-NOSVE-NEXT:    str h1, [sp, #176]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #176]
; NONEON-NOSVE-NEXT:    str w9, [sp, #172]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #144]
; NONEON-NOSVE-NEXT:    str q0, [sp, #128]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #152]
; NONEON-NOSVE-NEXT:    str x9, [sp, #160]
; NONEON-NOSVE-NEXT:    str h0, [sp, #168]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #128]
; NONEON-NOSVE-NEXT:    str h0, [sp, #170]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #160]
; NONEON-NOSVE-NEXT:    tbz w8, #6, .LBB6_9
; NONEON-NOSVE-NEXT:  .LBB6_16: // %cond.load16
; NONEON-NOSVE-NEXT:    ldr h1, [x0, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #88]
; NONEON-NOSVE-NEXT:    str h1, [sp, #112]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #112]
; NONEON-NOSVE-NEXT:    str w9, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #80]
; NONEON-NOSVE-NEXT:    str q0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #94]
; NONEON-NOSVE-NEXT:    str x9, [sp, #96]
; NONEON-NOSVE-NEXT:    str h0, [sp, #110]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #64]
; NONEON-NOSVE-NEXT:    str h0, [sp, #108]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #96]
; NONEON-NOSVE-NEXT:    tbnz w8, #7, .LBB6_10
; NONEON-NOSVE-NEXT:    b .LBB6_11
  %load = call <8 x half> @llvm.masked.load.v8f16(ptr %src, i32 8, <8 x i1> %mask, <8 x half> zeroinitializer)
  ret <8 x half> %load
}

define <16 x half> @masked_load_v16f16(ptr %src, <16 x i1> %mask) {
; CHECK-LABEL: masked_load_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    uunpklo z1.h, z0.b
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    mov x8, #8 // =0x8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.h, z0.b
; CHECK-NEXT:    lsl z1.h, z1.h, #15
; CHECK-NEXT:    asr z1.h, z1.h, #15
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    cmpne p1.h, p0/z, z1.h, #0
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ld1h { z0.h }, p1/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ld1h { z1.h }, p0/z, [x0, x8, lsl #1]
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    sub sp, sp, #992
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 1008
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    str q0, [sp, #976]
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI7_0
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #978]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #979]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #977]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #980]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #981]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #982]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #976]
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x4
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    sbfx w15, w15, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w8, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #983]
; NONEON-NOSVE-NEXT:    and w11, w11, #0x2
; NONEON-NOSVE-NEXT:    and w13, w13, #0x10
; NONEON-NOSVE-NEXT:    bfxil w11, w12, #0, #1
; NONEON-NOSVE-NEXT:    and w12, w14, #0x20
; NONEON-NOSVE-NEXT:    orr w8, w8, w13
; NONEON-NOSVE-NEXT:    and w13, w15, #0x40
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    orr w8, w11, w8
; NONEON-NOSVE-NEXT:    orr w11, w12, w13
; NONEON-NOSVE-NEXT:    ldr q1, [x9, :lo12:.LCPI7_0]
; NONEON-NOSVE-NEXT:    orr w8, w8, w11
; NONEON-NOSVE-NEXT:    and w10, w10, #0xffffff80
; NONEON-NOSVE-NEXT:    add x9, sp, #720
; NONEON-NOSVE-NEXT:    add w8, w8, w10
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB7_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    fmov s0, wzr
; NONEON-NOSVE-NEXT:    ldr h2, [x0]
; NONEON-NOSVE-NEXT:    stur wzr, [x9, #250]
; NONEON-NOSVE-NEXT:    stur xzr, [x9, #242]
; NONEON-NOSVE-NEXT:    str h2, [sp, #960]
; NONEON-NOSVE-NEXT:    str h0, [sp, #974]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #960]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB7_3
; NONEON-NOSVE-NEXT:    b .LBB7_4
; NONEON-NOSVE-NEXT:  .LBB7_2:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    ldr q0, [sp], #16
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB7_4
; NONEON-NOSVE-NEXT:  .LBB7_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #2]
; NONEON-NOSVE-NEXT:    str q0, [sp, #912]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #924]
; NONEON-NOSVE-NEXT:    str h2, [sp, #944]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #944]
; NONEON-NOSVE-NEXT:    str w10, [sp, #940]
; NONEON-NOSVE-NEXT:    str q0, [sp, #896]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #196]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #212]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #912]
; NONEON-NOSVE-NEXT:    str h0, [sp, #928]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #896]
; NONEON-NOSVE-NEXT:    str h0, [sp, #930]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #928]
; NONEON-NOSVE-NEXT:  .LBB7_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB7_20
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB7_21
; NONEON-NOSVE-NEXT:  .LBB7_6: // %else8
; NONEON-NOSVE-NEXT:    tbnz w8, #4, .LBB7_22
; NONEON-NOSVE-NEXT:  .LBB7_7: // %else11
; NONEON-NOSVE-NEXT:    tbnz w8, #5, .LBB7_23
; NONEON-NOSVE-NEXT:  .LBB7_8: // %else14
; NONEON-NOSVE-NEXT:    tbnz w8, #6, .LBB7_24
; NONEON-NOSVE-NEXT:  .LBB7_9: // %else17
; NONEON-NOSVE-NEXT:    tbnz w8, #7, .LBB7_25
; NONEON-NOSVE-NEXT:  .LBB7_10: // %else20
; NONEON-NOSVE-NEXT:    tbnz w8, #8, .LBB7_26
; NONEON-NOSVE-NEXT:  .LBB7_11: // %else23
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    tbnz w8, #9, .LBB7_27
; NONEON-NOSVE-NEXT:  .LBB7_12: // %else26
; NONEON-NOSVE-NEXT:    tbnz w8, #10, .LBB7_28
; NONEON-NOSVE-NEXT:  .LBB7_13: // %else29
; NONEON-NOSVE-NEXT:    tbnz w8, #11, .LBB7_29
; NONEON-NOSVE-NEXT:  .LBB7_14: // %else32
; NONEON-NOSVE-NEXT:    tbnz w8, #12, .LBB7_30
; NONEON-NOSVE-NEXT:  .LBB7_15: // %else35
; NONEON-NOSVE-NEXT:    tbnz w8, #13, .LBB7_31
; NONEON-NOSVE-NEXT:  .LBB7_16: // %else38
; NONEON-NOSVE-NEXT:    tbnz w8, #14, .LBB7_32
; NONEON-NOSVE-NEXT:  .LBB7_17: // %else41
; NONEON-NOSVE-NEXT:    tbz w8, #15, .LBB7_19
; NONEON-NOSVE-NEXT:  .LBB7_18: // %cond.load43
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #30]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    str h2, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    str h1, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #16]
; NONEON-NOSVE-NEXT:    str h1, [sp, #46]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:  .LBB7_19: // %else44
; NONEON-NOSVE-NEXT:    add sp, sp, #992
; NONEON-NOSVE-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB7_20: // %cond.load4
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #4]
; NONEON-NOSVE-NEXT:    str q0, [sp, #848]
; NONEON-NOSVE-NEXT:    str h2, [sp, #880]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #880]
; NONEON-NOSVE-NEXT:    str q0, [sp, #832]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #862]
; NONEON-NOSVE-NEXT:    str h0, [sp, #878]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #134]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #150]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #848]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #832]
; NONEON-NOSVE-NEXT:    str w10, [sp, #864]
; NONEON-NOSVE-NEXT:    str h0, [sp, #868]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #864]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB7_6
; NONEON-NOSVE-NEXT:  .LBB7_21: // %cond.load7
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #6]
; NONEON-NOSVE-NEXT:    str q0, [sp, #784]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #792]
; NONEON-NOSVE-NEXT:    str h2, [sp, #816]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #816]
; NONEON-NOSVE-NEXT:    str x10, [sp, #808]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #784]
; NONEON-NOSVE-NEXT:    str q0, [sp, #768]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #788]
; NONEON-NOSVE-NEXT:    str w10, [sp, #800]
; NONEON-NOSVE-NEXT:    str h0, [sp, #804]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #768]
; NONEON-NOSVE-NEXT:    str h0, [sp, #806]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #800]
; NONEON-NOSVE-NEXT:    tbz w8, #4, .LBB7_7
; NONEON-NOSVE-NEXT:  .LBB7_22: // %cond.load10
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #720]
; NONEON-NOSVE-NEXT:    str h2, [sp, #752]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #752]
; NONEON-NOSVE-NEXT:    str q0, [sp, #704]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #734]
; NONEON-NOSVE-NEXT:    str h0, [sp, #750]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #10]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #26]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #720]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #704]
; NONEON-NOSVE-NEXT:    str x9, [sp, #736]
; NONEON-NOSVE-NEXT:    str h0, [sp, #744]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #736]
; NONEON-NOSVE-NEXT:    tbz w8, #5, .LBB7_8
; NONEON-NOSVE-NEXT:  .LBB7_23: // %cond.load13
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #10]
; NONEON-NOSVE-NEXT:    str q0, [sp, #656]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #668]
; NONEON-NOSVE-NEXT:    str h2, [sp, #688]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #688]
; NONEON-NOSVE-NEXT:    str w9, [sp, #684]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #656]
; NONEON-NOSVE-NEXT:    str q0, [sp, #640]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #664]
; NONEON-NOSVE-NEXT:    str x9, [sp, #672]
; NONEON-NOSVE-NEXT:    str h0, [sp, #680]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #640]
; NONEON-NOSVE-NEXT:    str h0, [sp, #682]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #672]
; NONEON-NOSVE-NEXT:    tbz w8, #6, .LBB7_9
; NONEON-NOSVE-NEXT:  .LBB7_24: // %cond.load16
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp, #592]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #600]
; NONEON-NOSVE-NEXT:    str h2, [sp, #624]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #624]
; NONEON-NOSVE-NEXT:    str w9, [sp, #616]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #592]
; NONEON-NOSVE-NEXT:    str q0, [sp, #576]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #606]
; NONEON-NOSVE-NEXT:    str x9, [sp, #608]
; NONEON-NOSVE-NEXT:    str h0, [sp, #622]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #576]
; NONEON-NOSVE-NEXT:    str h0, [sp, #620]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #608]
; NONEON-NOSVE-NEXT:    tbz w8, #7, .LBB7_10
; NONEON-NOSVE-NEXT:  .LBB7_25: // %cond.load19
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #14]
; NONEON-NOSVE-NEXT:    str q0, [sp, #512]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #520]
; NONEON-NOSVE-NEXT:    str h2, [sp, #560]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #560]
; NONEON-NOSVE-NEXT:    str w9, [sp, #552]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #512]
; NONEON-NOSVE-NEXT:    str q0, [sp, #528]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #524]
; NONEON-NOSVE-NEXT:    str x9, [sp, #544]
; NONEON-NOSVE-NEXT:    str h0, [sp, #556]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #528]
; NONEON-NOSVE-NEXT:    str h0, [sp, #558]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #544]
; NONEON-NOSVE-NEXT:    tbz w8, #8, .LBB7_11
; NONEON-NOSVE-NEXT:  .LBB7_26: // %cond.load22
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [sp, #464]
; NONEON-NOSVE-NEXT:    add x9, sp, #464
; NONEON-NOSVE-NEXT:    str h2, [sp, #496]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #496]
; NONEON-NOSVE-NEXT:    str q1, [sp, #448]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #478]
; NONEON-NOSVE-NEXT:    str h1, [sp, #494]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #10]
; NONEON-NOSVE-NEXT:    ldur x11, [x9, #2]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #26]
; NONEON-NOSVE-NEXT:    stur x11, [x9, #18]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #448]
; NONEON-NOSVE-NEXT:    str h1, [sp, #480]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #480]
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    tbz w8, #9, .LBB7_12
; NONEON-NOSVE-NEXT:  .LBB7_27: // %cond.load25
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #18]
; NONEON-NOSVE-NEXT:    str q1, [sp, #400]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #412]
; NONEON-NOSVE-NEXT:    str h2, [sp, #432]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #432]
; NONEON-NOSVE-NEXT:    str w10, [sp, #428]
; NONEON-NOSVE-NEXT:    str q1, [sp, #384]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #196]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #212]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #400]
; NONEON-NOSVE-NEXT:    str h1, [sp, #416]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #384]
; NONEON-NOSVE-NEXT:    str h1, [sp, #418]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #416]
; NONEON-NOSVE-NEXT:    tbz w8, #10, .LBB7_13
; NONEON-NOSVE-NEXT:  .LBB7_28: // %cond.load28
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #20]
; NONEON-NOSVE-NEXT:    str q1, [sp, #336]
; NONEON-NOSVE-NEXT:    str h2, [sp, #368]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #368]
; NONEON-NOSVE-NEXT:    str q1, [sp, #320]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #350]
; NONEON-NOSVE-NEXT:    str h1, [sp, #366]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #134]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #150]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #336]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #320]
; NONEON-NOSVE-NEXT:    str w10, [sp, #352]
; NONEON-NOSVE-NEXT:    str h1, [sp, #356]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #352]
; NONEON-NOSVE-NEXT:    tbz w8, #11, .LBB7_14
; NONEON-NOSVE-NEXT:  .LBB7_29: // %cond.load31
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #22]
; NONEON-NOSVE-NEXT:    str q1, [sp, #272]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #280]
; NONEON-NOSVE-NEXT:    str h2, [sp, #304]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #304]
; NONEON-NOSVE-NEXT:    str x10, [sp, #296]
; NONEON-NOSVE-NEXT:    ldr w10, [sp, #272]
; NONEON-NOSVE-NEXT:    str q1, [sp, #256]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #276]
; NONEON-NOSVE-NEXT:    str w10, [sp, #288]
; NONEON-NOSVE-NEXT:    str h1, [sp, #292]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #256]
; NONEON-NOSVE-NEXT:    str h1, [sp, #294]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #288]
; NONEON-NOSVE-NEXT:    tbz w8, #12, .LBB7_15
; NONEON-NOSVE-NEXT:  .LBB7_30: // %cond.load34
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #24]
; NONEON-NOSVE-NEXT:    str q1, [sp, #208]
; NONEON-NOSVE-NEXT:    str h2, [sp, #240]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #240]
; NONEON-NOSVE-NEXT:    str q1, [sp, #192]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #222]
; NONEON-NOSVE-NEXT:    str h1, [sp, #238]
; NONEON-NOSVE-NEXT:    ldur w10, [x9, #10]
; NONEON-NOSVE-NEXT:    stur w10, [x9, #26]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #208]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #192]
; NONEON-NOSVE-NEXT:    str x9, [sp, #224]
; NONEON-NOSVE-NEXT:    str h1, [sp, #232]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #224]
; NONEON-NOSVE-NEXT:    tbz w8, #13, .LBB7_16
; NONEON-NOSVE-NEXT:  .LBB7_31: // %cond.load37
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #26]
; NONEON-NOSVE-NEXT:    str q1, [sp, #144]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #156]
; NONEON-NOSVE-NEXT:    str h2, [sp, #176]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #176]
; NONEON-NOSVE-NEXT:    str w9, [sp, #172]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #144]
; NONEON-NOSVE-NEXT:    str q1, [sp, #128]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #152]
; NONEON-NOSVE-NEXT:    str x9, [sp, #160]
; NONEON-NOSVE-NEXT:    str h1, [sp, #168]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #128]
; NONEON-NOSVE-NEXT:    str h1, [sp, #170]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #160]
; NONEON-NOSVE-NEXT:    tbz w8, #14, .LBB7_17
; NONEON-NOSVE-NEXT:  .LBB7_32: // %cond.load40
; NONEON-NOSVE-NEXT:    ldr h2, [x0, #28]
; NONEON-NOSVE-NEXT:    str q1, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #88]
; NONEON-NOSVE-NEXT:    str h2, [sp, #112]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #112]
; NONEON-NOSVE-NEXT:    str w9, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr x9, [sp, #80]
; NONEON-NOSVE-NEXT:    str q1, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #94]
; NONEON-NOSVE-NEXT:    str x9, [sp, #96]
; NONEON-NOSVE-NEXT:    str h1, [sp, #110]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #64]
; NONEON-NOSVE-NEXT:    str h1, [sp, #108]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #96]
; NONEON-NOSVE-NEXT:    tbnz w8, #15, .LBB7_18
; NONEON-NOSVE-NEXT:    b .LBB7_19
  %load = call <16 x half> @llvm.masked.load.v16f16(ptr %src, i32 8, <16 x i1> %mask, <16 x half> zeroinitializer)
  ret <16 x half> %load
}

define <2 x float> @masked_load_v2f32(ptr %src, <2 x i1> %mask) {
; CHECK-LABEL: masked_load_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    lsl z0.s, z0.s, #31
; CHECK-NEXT:    asr z0.s, z0.s, #31
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    str d0, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #48]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    bfxil w8, w9, #0, #1
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB8_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldr s0, [x0]
; NONEON-NOSVE-NEXT:    str wzr, [sp, #44]
; NONEON-NOSVE-NEXT:    str s0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB8_3
; NONEON-NOSVE-NEXT:    b .LBB8_4
; NONEON-NOSVE-NEXT:  .LBB8_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI8_0
; NONEON-NOSVE-NEXT:    ldr d0, [x9, :lo12:.LCPI8_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB8_4
; NONEON-NOSVE-NEXT:  .LBB8_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr s1, [x0, #4]
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    str s1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    str d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:  .LBB8_4: // %else2
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %load = call <2 x float> @llvm.masked.load.v2f32(ptr %src, i32 8, <2 x i1> %mask, <2 x float> zeroinitializer)
  ret <2 x float> %load
}

define <4 x float> @masked_load_v4f32(ptr %src, <4 x i1> %mask) {
; CHECK-LABEL: masked_load_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    lsl z0.s, z0.s, #31
; CHECK-NEXT:    asr z0.s, z0.s, #31
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #224
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 224
; NONEON-NOSVE-NEXT:    str d0, [sp, #208]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #210]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #212]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #214]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #208]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    and w9, w9, #0x4
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    bfxil w8, w11, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    orr w8, w8, w9
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB9_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldr s0, [x0]
; NONEON-NOSVE-NEXT:    str wzr, [sp, #204]
; NONEON-NOSVE-NEXT:    stur xzr, [sp, #196]
; NONEON-NOSVE-NEXT:    str s0, [sp, #192]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #192]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB9_3
; NONEON-NOSVE-NEXT:    b .LBB9_4
; NONEON-NOSVE-NEXT:  .LBB9_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI9_0
; NONEON-NOSVE-NEXT:    ldr q0, [x9, :lo12:.LCPI9_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB9_4
; NONEON-NOSVE-NEXT:  .LBB9_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr s1, [x0, #4]
; NONEON-NOSVE-NEXT:    str q0, [sp, #144]
; NONEON-NOSVE-NEXT:    str s1, [sp, #176]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #176]
; NONEON-NOSVE-NEXT:    str q0, [sp, #128]
; NONEON-NOSVE-NEXT:    ldp s0, s1, [sp, #152]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #168]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #144]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #128]
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #160]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #160]
; NONEON-NOSVE-NEXT:  .LBB9_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB9_7
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB9_8
; NONEON-NOSVE-NEXT:  .LBB9_6: // %else8
; NONEON-NOSVE-NEXT:    add sp, sp, #224
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB9_7: // %cond.load4
; NONEON-NOSVE-NEXT:    ldr s1, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #80]
; NONEON-NOSVE-NEXT:    str s1, [sp, #112]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #112]
; NONEON-NOSVE-NEXT:    str q0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp s0, s2, [sp, #80]
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #64]
; NONEON-NOSVE-NEXT:    stp s0, s1, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #96]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB9_6
; NONEON-NOSVE-NEXT:  .LBB9_8: // %cond.load7
; NONEON-NOSVE-NEXT:    ldr s1, [x0, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str s1, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s1, s0, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #224
; NONEON-NOSVE-NEXT:    ret
  %load = call <4 x float> @llvm.masked.load.v4f32(ptr %src, i32 8, <4 x i1> %mask, <4 x float> zeroinitializer)
  ret <4 x float> %load
}

define <8 x float> @masked_load_v8f32(ptr %src, <8 x i1> %mask) {
; CHECK-LABEL: masked_load_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    mov z1.b, z0.b[3]
; CHECK-NEXT:    mov z2.b, z0.b[2]
; CHECK-NEXT:    mov x8, #4 // =0x4
; CHECK-NEXT:    mov z3.b, z0.b[1]
; CHECK-NEXT:    mov z4.b, z0.b[7]
; CHECK-NEXT:    mov z5.b, z0.b[6]
; CHECK-NEXT:    mov z6.b, z0.b[5]
; CHECK-NEXT:    mov z7.b, z0.b[4]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    zip1 z1.h, z2.h, z1.h
; CHECK-NEXT:    zip1 z0.h, z0.h, z3.h
; CHECK-NEXT:    zip1 z2.h, z5.h, z4.h
; CHECK-NEXT:    zip1 z3.h, z7.h, z6.h
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    zip1 z1.s, z3.s, z2.s
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    lsl z0.s, z0.s, #31
; CHECK-NEXT:    lsl z1.s, z1.s, #31
; CHECK-NEXT:    asr z0.s, z0.s, #31
; CHECK-NEXT:    asr z1.s, z1.s, #31
; CHECK-NEXT:    cmpne p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    cmpne p0.s, p0/z, z1.s, #0
; CHECK-NEXT:    ld1w { z0.s }, p1/z, [x0]
; CHECK-NEXT:    ld1w { z1.s }, p0/z, [x0, x8, lsl #2]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #496
; NONEON-NOSVE-NEXT:    str x29, [sp, #480] // 8-byte Folded Spill
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 496
; NONEON-NOSVE-NEXT:    .cfi_offset w29, -16
; NONEON-NOSVE-NEXT:    str d0, [sp, #464]
; NONEON-NOSVE-NEXT:    adrp x8, .LCPI10_0
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #466]
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #467]
; NONEON-NOSVE-NEXT:    ldrb w11, [sp, #465]
; NONEON-NOSVE-NEXT:    ldrb w13, [sp, #468]
; NONEON-NOSVE-NEXT:    ldrb w14, [sp, #469]
; NONEON-NOSVE-NEXT:    ldrb w15, [sp, #470]
; NONEON-NOSVE-NEXT:    sbfx w9, w9, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    ldrb w12, [sp, #464]
; NONEON-NOSVE-NEXT:    sbfx w13, w13, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w14, w14, #0, #1
; NONEON-NOSVE-NEXT:    and w9, w9, #0x4
; NONEON-NOSVE-NEXT:    and w10, w10, #0x8
; NONEON-NOSVE-NEXT:    sbfx w15, w15, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w9, w10
; NONEON-NOSVE-NEXT:    ldrb w10, [sp, #471]
; NONEON-NOSVE-NEXT:    and w11, w11, #0x2
; NONEON-NOSVE-NEXT:    and w13, w13, #0x10
; NONEON-NOSVE-NEXT:    bfxil w11, w12, #0, #1
; NONEON-NOSVE-NEXT:    and w12, w14, #0x20
; NONEON-NOSVE-NEXT:    orr w9, w9, w13
; NONEON-NOSVE-NEXT:    and w13, w15, #0x40
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    orr w9, w11, w9
; NONEON-NOSVE-NEXT:    orr w11, w12, w13
; NONEON-NOSVE-NEXT:    ldr q1, [x8, :lo12:.LCPI10_0]
; NONEON-NOSVE-NEXT:    orr w9, w9, w11
; NONEON-NOSVE-NEXT:    and w10, w10, #0x80
; NONEON-NOSVE-NEXT:    add w10, w9, w10
; NONEON-NOSVE-NEXT:    add x9, sp, #208
; NONEON-NOSVE-NEXT:    and w8, w10, #0xff
; NONEON-NOSVE-NEXT:    tbz w10, #0, .LBB10_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldr s0, [x0]
; NONEON-NOSVE-NEXT:    str wzr, [sp, #460]
; NONEON-NOSVE-NEXT:    stur xzr, [x9, #244]
; NONEON-NOSVE-NEXT:    str s0, [sp, #448]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #448]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB10_3
; NONEON-NOSVE-NEXT:    b .LBB10_4
; NONEON-NOSVE-NEXT:  .LBB10_2:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    ldr q0, [sp], #16
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB10_4
; NONEON-NOSVE-NEXT:  .LBB10_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr s2, [x0, #4]
; NONEON-NOSVE-NEXT:    str q0, [sp, #400]
; NONEON-NOSVE-NEXT:    str s2, [sp, #432]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #432]
; NONEON-NOSVE-NEXT:    str q0, [sp, #384]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #412]
; NONEON-NOSVE-NEXT:    str s0, [sp, #428]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #408]
; NONEON-NOSVE-NEXT:    str s0, [sp, #424]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #400]
; NONEON-NOSVE-NEXT:    str s0, [sp, #416]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #384]
; NONEON-NOSVE-NEXT:    str s0, [sp, #420]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #416]
; NONEON-NOSVE-NEXT:  .LBB10_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB10_12
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB10_13
; NONEON-NOSVE-NEXT:  .LBB10_6: // %else8
; NONEON-NOSVE-NEXT:    tbnz w8, #4, .LBB10_14
; NONEON-NOSVE-NEXT:  .LBB10_7: // %else11
; NONEON-NOSVE-NEXT:    tbnz w8, #5, .LBB10_15
; NONEON-NOSVE-NEXT:  .LBB10_8: // %else14
; NONEON-NOSVE-NEXT:    tbnz w8, #6, .LBB10_16
; NONEON-NOSVE-NEXT:  .LBB10_9: // %else17
; NONEON-NOSVE-NEXT:    tbz w8, #7, .LBB10_11
; NONEON-NOSVE-NEXT:  .LBB10_10: // %cond.load19
; NONEON-NOSVE-NEXT:    ldr s2, [x0, #28]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp]
; NONEON-NOSVE-NEXT:    str s2, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr s2, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    str x8, [sp, #32]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #16]
; NONEON-NOSVE-NEXT:    stp s2, s1, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:  .LBB10_11: // %else20
; NONEON-NOSVE-NEXT:    ldr x29, [sp, #480] // 8-byte Folded Reload
; NONEON-NOSVE-NEXT:    add sp, sp, #496
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB10_12: // %cond.load4
; NONEON-NOSVE-NEXT:    ldr s2, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #336]
; NONEON-NOSVE-NEXT:    str s2, [sp, #368]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #368]
; NONEON-NOSVE-NEXT:    str q0, [sp, #320]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #348]
; NONEON-NOSVE-NEXT:    str s0, [sp, #364]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #340]
; NONEON-NOSVE-NEXT:    str s0, [sp, #356]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #336]
; NONEON-NOSVE-NEXT:    str s0, [sp, #352]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #320]
; NONEON-NOSVE-NEXT:    str s0, [sp, #360]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #352]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB10_6
; NONEON-NOSVE-NEXT:  .LBB10_13: // %cond.load7
; NONEON-NOSVE-NEXT:    ldr s2, [x0, #12]
; NONEON-NOSVE-NEXT:    str q0, [sp, #256]
; NONEON-NOSVE-NEXT:    ldr x10, [sp, #256]
; NONEON-NOSVE-NEXT:    str s2, [sp, #304]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #304]
; NONEON-NOSVE-NEXT:    str x10, [sp, #288]
; NONEON-NOSVE-NEXT:    str q0, [sp, #272]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #264]
; NONEON-NOSVE-NEXT:    str s0, [sp, #296]
; NONEON-NOSVE-NEXT:    ldr s0, [sp, #272]
; NONEON-NOSVE-NEXT:    str s0, [sp, #300]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #288]
; NONEON-NOSVE-NEXT:    tbz w8, #4, .LBB10_7
; NONEON-NOSVE-NEXT:  .LBB10_14: // %cond.load10
; NONEON-NOSVE-NEXT:    ldr s2, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [sp, #208]
; NONEON-NOSVE-NEXT:    str s2, [sp, #240]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #240]
; NONEON-NOSVE-NEXT:    str q1, [sp, #192]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #220]
; NONEON-NOSVE-NEXT:    str s1, [sp, #236]
; NONEON-NOSVE-NEXT:    ldur x10, [x9, #4]
; NONEON-NOSVE-NEXT:    stur x10, [x9, #20]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #192]
; NONEON-NOSVE-NEXT:    str s1, [sp, #224]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #224]
; NONEON-NOSVE-NEXT:    tbz w8, #5, .LBB10_8
; NONEON-NOSVE-NEXT:  .LBB10_15: // %cond.load13
; NONEON-NOSVE-NEXT:    ldr s2, [x0, #20]
; NONEON-NOSVE-NEXT:    str q1, [sp, #144]
; NONEON-NOSVE-NEXT:    str s2, [sp, #176]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #176]
; NONEON-NOSVE-NEXT:    str q1, [sp, #128]
; NONEON-NOSVE-NEXT:    ldp s1, s2, [sp, #152]
; NONEON-NOSVE-NEXT:    stp s1, s2, [sp, #168]
; NONEON-NOSVE-NEXT:    ldr s2, [sp, #144]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #128]
; NONEON-NOSVE-NEXT:    stp s2, s1, [sp, #160]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #160]
; NONEON-NOSVE-NEXT:    tbz w8, #6, .LBB10_9
; NONEON-NOSVE-NEXT:  .LBB10_16: // %cond.load16
; NONEON-NOSVE-NEXT:    ldr s2, [x0, #24]
; NONEON-NOSVE-NEXT:    str q1, [sp, #80]
; NONEON-NOSVE-NEXT:    str s2, [sp, #112]
; NONEON-NOSVE-NEXT:    ldr s2, [sp, #92]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #112]
; NONEON-NOSVE-NEXT:    str q1, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp s1, s3, [sp, #80]
; NONEON-NOSVE-NEXT:    stp s1, s3, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr s1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp s1, s2, [sp, #104]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #96]
; NONEON-NOSVE-NEXT:    tbnz w8, #7, .LBB10_10
; NONEON-NOSVE-NEXT:    b .LBB10_11
  %load = call <8 x float> @llvm.masked.load.v8f32(ptr %src, i32 8, <8 x i1> %mask, <8 x float> zeroinitializer)
  ret <8 x float> %load
}

define <2 x double> @masked_load_v2f64(ptr %src, <2 x i1> %mask) {
; CHECK-LABEL: masked_load_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    lsl z0.d, z0.d, #63
; CHECK-NEXT:    asr z0.d, z0.d, #63
; CHECK-NEXT:    cmpne p0.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    str d0, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #80]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    bfxil w8, w9, #0, #1
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB11_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str xzr, [sp, #72]
; NONEON-NOSVE-NEXT:    str d0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #64]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB11_3
; NONEON-NOSVE-NEXT:    b .LBB11_4
; NONEON-NOSVE-NEXT:  .LBB11_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI11_0
; NONEON-NOSVE-NEXT:    ldr q0, [x9, :lo12:.LCPI11_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB11_4
; NONEON-NOSVE-NEXT:  .LBB11_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr d1, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp]
; NONEON-NOSVE-NEXT:    str d1, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr d1, [sp]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d1, d0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:  .LBB11_4: // %else2
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %load = call <2 x double> @llvm.masked.load.v2f64(ptr %src, i32 8, <2 x i1> %mask, <2 x double> zeroinitializer)
  ret <2 x double> %load
}

define <4 x double> @masked_load_v4f64(ptr %src, <4 x i1> %mask) {
; CHECK-LABEL: masked_load_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    mov x8, #2 // =0x2
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    lsl z1.d, z1.d, #63
; CHECK-NEXT:    lsl z0.d, z0.d, #63
; CHECK-NEXT:    asr z1.d, z1.d, #63
; CHECK-NEXT:    asr z0.d, z0.d, #63
; CHECK-NEXT:    cmpne p1.d, p0/z, z1.d, #0
; CHECK-NEXT:    cmpne p0.d, p0/z, z0.d, #0
; CHECK-NEXT:    ld1d { z0.d }, p1/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x0, x8, lsl #3]
; CHECK-NEXT:    // kill: def $q1 killed $q1 killed $z1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #224
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 224
; NONEON-NOSVE-NEXT:    str d0, [sp, #208]
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI12_0
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #210]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #212]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #214]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #208]
; NONEON-NOSVE-NEXT:    ldr q1, [x9, :lo12:.LCPI12_0]
; NONEON-NOSVE-NEXT:    sbfx w8, w8, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w10, w10, #0, #1
; NONEON-NOSVE-NEXT:    sbfx w11, w11, #0, #1
; NONEON-NOSVE-NEXT:    and w8, w8, #0x2
; NONEON-NOSVE-NEXT:    and w10, w10, #0x4
; NONEON-NOSVE-NEXT:    and w11, w11, #0x8
; NONEON-NOSVE-NEXT:    bfxil w8, w12, #0, #1
; NONEON-NOSVE-NEXT:    orr w10, w10, w11
; NONEON-NOSVE-NEXT:    orr w8, w8, w10
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB12_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str xzr, [sp, #200]
; NONEON-NOSVE-NEXT:    str d0, [sp, #192]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #192]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB12_3
; NONEON-NOSVE-NEXT:    b .LBB12_4
; NONEON-NOSVE-NEXT:  .LBB12_2:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    ldr q0, [sp], #16
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB12_4
; NONEON-NOSVE-NEXT:  .LBB12_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldr d2, [x0, #8]
; NONEON-NOSVE-NEXT:    str q0, [sp, #128]
; NONEON-NOSVE-NEXT:    str d2, [sp, #176]
; NONEON-NOSVE-NEXT:    ldr d2, [sp, #128]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #176]
; NONEON-NOSVE-NEXT:    str q0, [sp, #144]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #144]
; NONEON-NOSVE-NEXT:    stp d2, d0, [sp, #160]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #160]
; NONEON-NOSVE-NEXT:  .LBB12_4: // %else2
; NONEON-NOSVE-NEXT:    tbnz w8, #2, .LBB12_7
; NONEON-NOSVE-NEXT:  // %bb.5: // %else5
; NONEON-NOSVE-NEXT:    tbnz w8, #3, .LBB12_8
; NONEON-NOSVE-NEXT:  .LBB12_6: // %else8
; NONEON-NOSVE-NEXT:    add sp, sp, #224
; NONEON-NOSVE-NEXT:    ret
; NONEON-NOSVE-NEXT:  .LBB12_7: // %cond.load4
; NONEON-NOSVE-NEXT:    ldr d2, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [sp, #80]
; NONEON-NOSVE-NEXT:    str d2, [sp, #112]
; NONEON-NOSVE-NEXT:    ldr d2, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #112]
; NONEON-NOSVE-NEXT:    str q1, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp d1, d2, [sp, #96]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #96]
; NONEON-NOSVE-NEXT:    tbz w8, #3, .LBB12_6
; NONEON-NOSVE-NEXT:  .LBB12_8: // %cond.load7
; NONEON-NOSVE-NEXT:    ldr d2, [x0, #24]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    str d2, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr d2, [sp]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #48]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr d1, [sp, #16]
; NONEON-NOSVE-NEXT:    stp d2, d1, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #224
; NONEON-NOSVE-NEXT:    ret
  %load = call <4 x double> @llvm.masked.load.v4f64(ptr %src, i32 8, <4 x i1> %mask, <4 x double> zeroinitializer)
  ret <4 x double> %load
}

define <3 x i32> @masked_load_zext_v3i32(ptr %load_ptr, <3 x i1> %pm) {
; CHECK-LABEL: masked_load_zext_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s0, w2
; CHECK-NEXT:    fmov s1, w1
; CHECK-NEXT:    adrp x8, .LCPI13_0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    zip1 z0.h, z1.h, z0.h
; CHECK-NEXT:    fmov s1, w3
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI13_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1h { z0.s }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_zext_v3i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    and w8, w1, #0x1
; NONEON-NOSVE-NEXT:    bfi w8, w2, #1, #1
; NONEON-NOSVE-NEXT:    bfi w8, w3, #2, #1
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB13_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldrh w9, [x0]
; NONEON-NOSVE-NEXT:    stur wzr, [sp, #66]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #64]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB13_3
; NONEON-NOSVE-NEXT:    b .LBB13_4
; NONEON-NOSVE-NEXT:  .LBB13_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI13_0
; NONEON-NOSVE-NEXT:    ldr d0, [x9, :lo12:.LCPI13_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB13_4
; NONEON-NOSVE-NEXT:  .LBB13_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldrh w9, [x0, #2]
; NONEON-NOSVE-NEXT:    str d0, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:  .LBB13_4: // %else2
; NONEON-NOSVE-NEXT:    tbz w8, #2, .LBB13_6
; NONEON-NOSVE-NEXT:  // %bb.5: // %cond.load4
; NONEON-NOSVE-NEXT:    ldrh w8, [x0, #4]
; NONEON-NOSVE-NEXT:    str d0, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #32]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:  .LBB13_6: // %else5
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %load_value = tail call <3 x i16> @llvm.masked.load.v3i16.p0(ptr %load_ptr, i32 4, <3 x i1> %pm, <3 x i16> zeroinitializer)
  %extend = zext <3 x i16> %load_value to <3 x i32>
  ret <3 x i32> %extend;
}

define <3 x i32> @masked_load_sext_v3i32(ptr %load_ptr, <3 x i1> %pm) {
; CHECK-LABEL: masked_load_sext_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s0, w2
; CHECK-NEXT:    fmov s1, w1
; CHECK-NEXT:    adrp x8, .LCPI14_0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    zip1 z0.h, z1.h, z0.h
; CHECK-NEXT:    fmov s1, w3
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI14_0]
; CHECK-NEXT:    and z0.d, z0.d, z1.d
; CHECK-NEXT:    lsl z0.h, z0.h, #15
; CHECK-NEXT:    asr z0.h, z0.h, #15
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ld1sh { z0.s }, p0/z, [x0]
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: masked_load_sext_v3i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    and w8, w1, #0x1
; NONEON-NOSVE-NEXT:    bfi w8, w2, #1, #1
; NONEON-NOSVE-NEXT:    bfi w8, w3, #2, #1
; NONEON-NOSVE-NEXT:    tbz w8, #0, .LBB14_2
; NONEON-NOSVE-NEXT:  // %bb.1: // %cond.load
; NONEON-NOSVE-NEXT:    ldrh w9, [x0]
; NONEON-NOSVE-NEXT:    stur wzr, [sp, #66]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #64]
; NONEON-NOSVE-NEXT:    tbnz w8, #1, .LBB14_3
; NONEON-NOSVE-NEXT:    b .LBB14_4
; NONEON-NOSVE-NEXT:  .LBB14_2:
; NONEON-NOSVE-NEXT:    adrp x9, .LCPI14_0
; NONEON-NOSVE-NEXT:    ldr d0, [x9, :lo12:.LCPI14_0]
; NONEON-NOSVE-NEXT:    tbz w8, #1, .LBB14_4
; NONEON-NOSVE-NEXT:  .LBB14_3: // %cond.load1
; NONEON-NOSVE-NEXT:    ldrh w9, [x0, #2]
; NONEON-NOSVE-NEXT:    str d0, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:  .LBB14_4: // %else2
; NONEON-NOSVE-NEXT:    tbz w8, #2, .LBB14_6
; NONEON-NOSVE-NEXT:  // %bb.5: // %cond.load4
; NONEON-NOSVE-NEXT:    ldrh w8, [x0, #4]
; NONEON-NOSVE-NEXT:    str d0, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #32]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:  .LBB14_6: // %else5
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %load_value = tail call <3 x i16> @llvm.masked.load.v3i16.p0(ptr %load_ptr, i32 4, <3 x i1> %pm, <3 x i16> zeroinitializer)
  %extend = sext <3 x i16> %load_value to <3 x i32>
  ret <3 x i32> %extend;
}

declare <4 x i8> @llvm.masked.load.v4i8(ptr, i32, <4 x i1>, <4 x i8>)
declare <8 x i8> @llvm.masked.load.v8i8(ptr, i32, <8 x i1>, <8 x i8>)
declare <16 x i8> @llvm.masked.load.v16i8(ptr, i32, <16 x i1>, <16 x i8>)
declare <32 x i8> @llvm.masked.load.v32i8(ptr, i32, <32 x i1>, <32 x i8>)

declare <2 x half> @llvm.masked.load.v2f16(ptr, i32, <2 x i1>, <2 x half>)
declare <4 x half> @llvm.masked.load.v4f16(ptr, i32, <4 x i1>, <4 x half>)
declare <8 x half> @llvm.masked.load.v8f16(ptr, i32, <8 x i1>, <8 x half>)
declare <16 x half> @llvm.masked.load.v16f16(ptr, i32, <16 x i1>, <16 x half>)

declare <2 x float> @llvm.masked.load.v2f32(ptr, i32, <2 x i1>, <2 x float>)
declare <4 x float> @llvm.masked.load.v4f32(ptr, i32, <4 x i1>, <4 x float>)
declare <8 x float> @llvm.masked.load.v8f32(ptr, i32, <8 x i1>, <8 x float>)

declare <2 x double> @llvm.masked.load.v2f64(ptr, i32, <2 x i1>, <2 x double>)
declare <4 x double> @llvm.masked.load.v4f64(ptr, i32, <4 x i1>, <4 x double>)

declare <3 x i16> @llvm.masked.load.v3i16.p0(ptr, i32, <3 x i1>, <3 x i16>)
