; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 -start-before=amdgpu-isel -amdgpu-use-sdag-ptradd=1 < %s | FileCheck --check-prefixes=GFX942,GFX942_PTRADD %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 -start-before=amdgpu-isel -amdgpu-use-sdag-ptradd=0 < %s | FileCheck --check-prefixes=GFX942,GFX942_LEGACY %s

; Tests for undef and poison DAG folds for the ISD::PTRADD SelectionDAG opcode.
; If any additions are generated for these tests, the folds don't work.

define ptr @poison_offset(ptr %p, i64 %offset) {
; GFX942-LABEL: poison_offset:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %gep1 = getelementptr i8, ptr %p, i64 poison
  ret ptr %gep1
}

define ptr @poison_base(ptr %p, i64 %offset) {
; GFX942-LABEL: poison_base:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %gep1 = getelementptr i8, ptr poison, i64 %offset
  ret ptr %gep1
}

define ptr @undef_offset(ptr %p, i64 %offset) {
; GFX942-LABEL: undef_offset:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %gep1 = getelementptr i8, ptr %p, i64 undef
  ret ptr %gep1
}

define ptr @undef_base(ptr %p, i64 %offset) {
; GFX942-LABEL: undef_base:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %gep1 = getelementptr i8, ptr undef, i64 %offset
  ret ptr %gep1
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX942_LEGACY: {{.*}}
; GFX942_PTRADD: {{.*}}
