; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

declare void @llvm.assume(i1)

define i1 @test_mul_const_nuw_unsigned_1(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %t.1 = icmp ult i8 %start, %high
  ret i1 %t.1
}

define i1 @test_mul_const_nuw_unsigned_2(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %t = icmp ult i8 %start.mul.2, %high
  ret i1 %t
}

define i1 @test_mul_const_nuw_unsigned_3(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %start.add.1 = add nuw i8 %start, %start
  %t = icmp ule i8 %start.add.1, %start.mul.2
  ret i1 %t
}


define i1 @test_mul_const_nuw_unsigned_4(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %start.add.1 = add nuw i8 %start, %start
  %f = icmp ult i8 %start.add.1, %start.mul.2
  ret i1 %f
}


define i1 @test_mul_const_nuw_unsigned_5(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %t.4 = icmp ule i8 %start.add.2, %start.mul.4
  ret i1 %t.4
}

define i1 @test_mul_const_nuw_unsigned_6(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    ret i1 false
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %f.2 = icmp ult i8 %start.add.2, %start.mul.4
  ret i1 %f.2
}

define i1 @test_mul_const_nuw_unsigned_7(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add nuw i8 [[START_ADD_2]], 1
; CHECK-NEXT:    ret i1 false
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %start.add.2.1 = add nuw i8 %start.add.2, 1
  %f.3 = icmp ule i8 %start.add.2.1, %start.mul.4
  ret i1 %f.3
}

define i1 @test_mul_const_nuw_unsigned_8(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add nuw i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START]], 3
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %start.add.2.1 = add nuw i8 %start.add.2, 1
  %start.mul.3 = mul nuw i8 %start, 3
  %t.5 = icmp ule i8 %start.add.1, %start.mul.3
  ret i1 %t.5
}

define i1 @test_mul_const_nuw_unsigned_9(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add nuw i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START]], 3
; CHECK-NEXT:    ret i1 false
;
entry:
  %start.mul.4 = mul nuw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %start.add.2.1 = add nuw i8 %start.add.2, 1
  %start.mul.3 = mul nuw i8 %start, 3
  %f.5 = icmp ult i8 %start.add.2, %start.mul.3
  ret i1 %f.5
}

define i1 @test_mul_const_nuw_unsigned_10(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw i8 [[START:%.*]], 5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START]], 3
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.mul.5 = mul nuw i8 %start, 5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nuw i8 %start, 3
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_nuw_unsigned_11(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw i8 [[START:%.*]], 5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START]], 3
; CHECK-NEXT:    ret i1 false
;
entry:
  %start.mul.5 = mul nuw i8 %start, 5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nuw i8 %start, 3
  %c.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %c.1
}

define i1 @test_mul_const_nuw_unsigned_12(i8 %start) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START]], [[START_MUL_3]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw i8 [[START]], 5
; CHECK-NEXT:    ret i1 true
;
entry:
  %start.mul.3 = mul nuw i8 %start, 3
  %c.1 = icmp ult i8 %start, %start.mul.3
  call void @llvm.assume(i1 %c.1)

  %start.mul.5 = mul nuw i8 %start, 5
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_nuw_unsigned_13(i8 %start) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START]], [[START_MUL_3]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw i8 [[START]], 5
; CHECK-NEXT:    ret i1 false
;
entry:
  %start.mul.3 = mul nuw i8 %start, 3
  %c.1 = icmp ult i8 %start, %start.mul.3
  call void @llvm.assume(i1 %c.1)

  %start.mul.5 = mul nuw i8 %start, 5
  %f.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %f.1
}

define i1 @test_mul_const_nuw_unsigned_14(i8 %start) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_14(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw i8 [[START:%.*]], -5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START]], -3
; CHECK-NEXT:    [[T_1:%.*]] = icmp ule i8 [[START_MUL_3]], [[START_MUL_5]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.5 = mul nuw i8 %start, -5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nuw i8 %start, -3
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_nuw_unsigned_15(i8 %start) {
; CHECK-LABEL: @test_mul_const_nuw_unsigned_15(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw i8 [[START:%.*]], -5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw i8 [[START]], -3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i8 [[START_MUL_5]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[C_1]]
;
entry:
  %start.mul.5 = mul nuw i8 %start, -5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nuw i8 %start, -3
  %c.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %c.1
}

define i1 @test_mul_const_nuw_nsw_unsigned_16(i8 %start) {
; CHECK-LABEL: @test_mul_const_nuw_nsw_unsigned_16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw nsw i8 [[START:%.*]], -5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw nsw i8 [[START]], -3
; CHECK-NEXT:    [[T_1:%.*]] = icmp ule i8 [[START_MUL_3]], [[START_MUL_5]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.5 = mul nuw nsw i8 %start, -5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nuw nsw i8 %start, -3
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_nuw_nsw_unsigned_17(i8 %start) {
; CHECK-LABEL: @test_mul_const_nuw_nsw_unsigned_17(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nuw nsw i8 [[START:%.*]], -5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nuw nsw i8 [[START]], -3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i8 [[START_MUL_5]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[C_1]]
;
entry:
  %start.mul.5 = mul nuw nsw i8 %start, -5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nuw nsw i8 %start, -3
  %c.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %c.1
}

define i1 @test_mul_add_const_nuw_unsigned_1(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nuw_unsigned_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    ret i1 true
;
entry:
  %add = add nuw i8 %start, 3
  %start.mul.4 = mul nuw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %t.1 = icmp ult i8 %start, %high
  ret i1 %t.1
}

define i1 @test_mul_add_const_nuw_unsigned_2(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nuw_unsigned_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    ret i1 true
;
entry:
  %add = add nuw i8 %start, 3
  %start.mul.4 = mul nuw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %t.2 = icmp ult i8 %start.mul.2, %high
  ret i1 %t.2
}

define i1 @test_mul_add_const_nuw_unsigned_3(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nuw_unsigned_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %add = add nuw i8 %start, 3
  %start.mul.4 = mul nuw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %t.3 = icmp ule i8 %start.add.2, %start.mul.4
  ret i1 %t.3
}

define i1 @test_mul_add_const_nuw_unsigned_4(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nuw_unsigned_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nuw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    ret i1 true
;
entry:
  %add = add nuw i8 %start, 3
  %start.mul.4 = mul nuw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nuw i8 %start, 2
  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %t.4 = icmp ult i8 %start.add.2, %start.mul.4
  ret i1 %t.4
}

define i1 @test_mul_add_const_nuw_unsigned_5(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nuw_unsigned_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_12:%.*]] = add nuw i8 [[START_ADD_2]], 12
; CHECK-NEXT:    ret i1 true
;
entry:
  %add = add nuw i8 %start, 3
  %start.mul.4 = mul nuw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %start.add.2.12 = add nuw i8 %start.add.2, 12
  %t.5 = icmp ule i8 %start.add.2.12, %start.mul.4
  ret i1 %t.5
}

define i1 @test_mul_add_const_nuw_unsigned_6(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nuw_unsigned_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nuw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nuw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nuw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_13:%.*]] = add nuw i8 [[START_ADD_2]], 13
; CHECK-NEXT:    ret i1 false
;
entry:
  %add = add nuw i8 %start, 3
  %start.mul.4 = mul nuw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nuw i8 %start, %start
  %start.add.2 = add nuw i8 %start.add.1, %start.add.1
  %start.add.2.13 = add nuw i8 %start.add.2, 13
  %f.1 = icmp ule i8 %start.add.2.13, %start.mul.4
  ret i1 %f.1
}

define i1 @test_mul_const_nsw_unsigned_1(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %t.1 = icmp ult i8 %start, %high
  ret i1 %t.1
}

define i1 @test_mul_const_nsw_unsigned_2(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[T:%.*]] = icmp ult i8 [[START_MUL_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %t = icmp ult i8 %start.mul.2, %high
  ret i1 %t
}

define i1 @test_mul_const_nsw_unsigned_3(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[T:%.*]] = icmp ule i8 [[START_ADD_1]], [[START_MUL_2]]
; CHECK-NEXT:    ret i1 [[T]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %start.add.1 = add nsw i8 %start, %start
  %t = icmp ule i8 %start.add.1, %start.mul.2
  ret i1 %t
}


define i1 @test_mul_const_nsw_unsigned_4(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[F:%.*]] = icmp ult i8 [[START_ADD_1]], [[START_MUL_2]]
; CHECK-NEXT:    ret i1 [[F]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %start.add.1 = add nsw i8 %start, %start
  %f = icmp ult i8 %start.add.1, %start.mul.2
  ret i1 %f
}


define i1 @test_mul_const_nsw_unsigned_5(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[T_4:%.*]] = icmp ule i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_4]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %t.4 = icmp ule i8 %start.add.2, %start.mul.4
  ret i1 %t.4
}

define i1 @test_mul_const_nsw_unsigned_6(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[F_2:%.*]] = icmp ult i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[F_2]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %f.2 = icmp ult i8 %start.add.2, %start.mul.4
  ret i1 %f.2
}

define i1 @test_mul_const_nsw_unsigned_7(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add nsw i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[F_3:%.*]] = icmp ule i8 [[START_ADD_2_1]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[F_3]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %start.add.2.1 = add nsw i8 %start.add.2, 1
  %f.3 = icmp ule i8 %start.add.2.1, %start.mul.4
  ret i1 %f.3
}

define i1 @test_mul_const_nsw_unsigned_8(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add nsw i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nsw i8 [[START]], 3
; CHECK-NEXT:    [[T_5:%.*]] = icmp ule i8 [[START_ADD_1]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[T_5]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %start.add.2.1 = add nsw i8 %start.add.2, 1
  %start.mul.3 = mul nsw i8 %start, 3
  %t.5 = icmp ule i8 %start.add.1, %start.mul.3
  ret i1 %t.5
}

define i1 @test_mul_const_nsw_unsigned_9(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add nsw i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nsw i8 [[START]], 3
; CHECK-NEXT:    [[F_5:%.*]] = icmp ult i8 [[START_ADD_2]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[F_5]]
;
entry:
  %start.mul.4 = mul nsw i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %start.add.2.1 = add nsw i8 %start.add.2, 1
  %start.mul.3 = mul nsw i8 %start, 3
  %f.5 = icmp ult i8 %start.add.2, %start.mul.3
  ret i1 %f.5
}

define i1 @test_mul_const_nsw_unsigned_10(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nsw i8 [[START:%.*]], 5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nsw i8 [[START]], 3
; CHECK-NEXT:    [[T_1:%.*]] = icmp ule i8 [[START_MUL_3]], [[START_MUL_5]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.5 = mul nsw i8 %start, 5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nsw i8 %start, 3
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_nsw_unsigned_11(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nsw i8 [[START:%.*]], 5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nsw i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i8 [[START_MUL_5]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[C_1]]
;
entry:
  %start.mul.5 = mul nsw i8 %start, 5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nsw i8 %start, 3
  %c.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %c.1
}

define i1 @test_mul_const_nsw_unsigned_12(i8 %start) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nsw i8 [[START:%.*]], -5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nsw i8 [[START]], -3
; CHECK-NEXT:    [[T_1:%.*]] = icmp ule i8 [[START_MUL_3]], [[START_MUL_5]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.5 = mul nsw i8 %start, -5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nsw i8 %start, -3
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_nsw_unsigned_13(i8 %start) {
; CHECK-LABEL: @test_mul_const_nsw_unsigned_13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul nsw i8 [[START:%.*]], -5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul nsw i8 [[START]], -3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i8 [[START_MUL_5]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[C_1]]
;
entry:
  %start.mul.5 = mul nsw i8 %start, -5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul nsw i8 %start, -3
  %c.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %c.1
}

define i1 @test_mul_add_const_nsw_unsigned_1(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nsw_unsigned_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %add = add nsw i8 %start, 3
  %start.mul.4 = mul nsw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %t.1 = icmp ult i8 %start, %high
  ret i1 %t.1
}

define i1 @test_mul_add_const_nsw_unsigned_2(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nsw_unsigned_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i8 [[START_MUL_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T_2]]
;
entry:
  %add = add nsw i8 %start, 3
  %start.mul.4 = mul nsw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %t.2 = icmp ult i8 %start.mul.2, %high
  ret i1 %t.2
}

define i1 @test_mul_add_const_nsw_unsigned_3(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nsw_unsigned_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[T_3:%.*]] = icmp ule i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_3]]
;
entry:
  %add = add nsw i8 %start, 3
  %start.mul.4 = mul nsw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %t.3 = icmp ule i8 %start.add.2, %start.mul.4
  ret i1 %t.3
}

define i1 @test_mul_add_const_nsw_unsigned_4(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nsw_unsigned_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul nsw i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[T_4:%.*]] = icmp ult i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_4]]
;
entry:
  %add = add nsw i8 %start, 3
  %start.mul.4 = mul nsw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul nsw i8 %start, 2
  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %t.4 = icmp ult i8 %start.add.2, %start.mul.4
  ret i1 %t.4
}

define i1 @test_mul_add_const_nsw_unsigned_5(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nsw_unsigned_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_12:%.*]] = add nsw i8 [[START_ADD_2]], 12
; CHECK-NEXT:    [[T_5:%.*]] = icmp ule i8 [[START_ADD_2_12]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_5]]
;
entry:
  %add = add nsw i8 %start, 3
  %start.mul.4 = mul nsw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %start.add.2.12 = add nsw i8 %start.add.2, 12
  %t.5 = icmp ule i8 %start.add.2.12, %start.mul.4
  ret i1 %t.5
}

define i1 @test_mul_add_const_nsw_unsigned_6(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_nsw_unsigned_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul nsw i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add nsw i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add nsw i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_13:%.*]] = add nsw i8 [[START_ADD_2]], 13
; CHECK-NEXT:    [[F_1:%.*]] = icmp ule i8 [[START_ADD_2_13]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[F_1]]
;
entry:
  %add = add nsw i8 %start, 3
  %start.mul.4 = mul nsw i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add nsw i8 %start, %start
  %start.add.2 = add nsw i8 %start.add.1, %start.add.1
  %start.add.2.13 = add nsw i8 %start.add.2, 13
  %f.1 = icmp ule i8 %start.add.2.13, %start.mul.4
  ret i1 %f.1
}

define i1 @test_mul_const_no_nuw_unsigned_1(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %t.1 = icmp ult i8 %start, %high
  ret i1 %t.1
}

define i1 @test_mul_const_no_nuw_unsigned_2(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[T:%.*]] = icmp ult i8 [[START_MUL_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %t = icmp ult i8 %start.mul.2, %high
  ret i1 %t
}

define i1 @test_mul_const_no_nuw_unsigned_3(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[T:%.*]] = icmp ule i8 [[START_ADD_1]], [[START_MUL_2]]
; CHECK-NEXT:    ret i1 [[T]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %start.add.1 = add i8 %start, %start
  %t = icmp ule i8 %start.add.1, %start.mul.2
  ret i1 %t
}


define i1 @test_mul_const_no_nuw_unsigned_4(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[F:%.*]] = icmp ult i8 [[START_ADD_1]], [[START_MUL_2]]
; CHECK-NEXT:    ret i1 [[F]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %start.add.1 = add i8 %start, %start
  %f = icmp ult i8 %start.add.1, %start.mul.2
  ret i1 %f
}


define i1 @test_mul_const_no_nuw_unsigned_5(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[T_4:%.*]] = icmp ule i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_4]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %t.4 = icmp ule i8 %start.add.2, %start.mul.4
  ret i1 %t.4
}

define i1 @test_mul_const_no_nuw_unsigned_6(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[F_2:%.*]] = icmp ult i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[F_2]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %f.2 = icmp ult i8 %start.add.2, %start.mul.4
  ret i1 %f.2
}

define i1 @test_mul_const_no_nuw_unsigned_7(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[F_3:%.*]] = icmp ule i8 [[START_ADD_2_1]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[F_3]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %start.add.2.1 = add i8 %start.add.2, 1
  %f.3 = icmp ule i8 %start.add.2.1, %start.mul.4
  ret i1 %f.3
}

define i1 @test_mul_const_no_nuw_unsigned_8(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul i8 [[START]], 3
; CHECK-NEXT:    [[T_5:%.*]] = icmp ule i8 [[START_ADD_1]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[T_5]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %start.add.2.1 = add i8 %start.add.2, 1
  %start.mul.3 = mul i8 %start, 3
  %t.5 = icmp ule i8 %start.add.1, %start.mul.3
  ret i1 %t.5
}

define i1 @test_mul_const_no_nuw_unsigned_9(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[START:%.*]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_1:%.*]] = add i8 [[START_ADD_2]], 1
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul i8 [[START]], 3
; CHECK-NEXT:    [[F_5:%.*]] = icmp ult i8 [[START_ADD_2]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[F_5]]
;
entry:
  %start.mul.4 = mul i8 %start, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %start.add.2.1 = add i8 %start.add.2, 1
  %start.mul.3 = mul i8 %start, 3
  %f.5 = icmp ult i8 %start.add.2, %start.mul.3
  ret i1 %f.5
}

define i1 @test_mul_const_no_nuw_unsigned_10(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul i8 [[START:%.*]], 5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul i8 [[START]], 3
; CHECK-NEXT:    [[T_1:%.*]] = icmp ule i8 [[START_MUL_3]], [[START_MUL_5]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.5 = mul i8 %start, 5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul i8 %start, 3
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_no_nuw_unsigned_11(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul i8 [[START:%.*]], 5
; CHECK-NEXT:    [[C_0:%.*]] = icmp ult i8 [[START]], [[START_MUL_5]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_0]])
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul i8 [[START]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ule i8 [[START_MUL_5]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[C_1]]
;
entry:
  %start.mul.5 = mul i8 %start, 5
  %c.0 = icmp ult i8 %start, %start.mul.5
  call void @llvm.assume(i1 %c.0)

  %start.mul.3 = mul i8 %start, 3
  %c.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %c.1
}

define i1 @test_mul_const_no_nuw_unsigned_12(i8 %start) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul i8 [[START:%.*]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START]], [[START_MUL_3]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul i8 [[START]], 5
; CHECK-NEXT:    [[T_1:%.*]] = icmp ule i8 [[START_MUL_3]], [[START_MUL_5]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %start.mul.3 = mul i8 %start, 3
  %c.1 = icmp ult i8 %start, %start.mul.3
  call void @llvm.assume(i1 %c.1)

  %start.mul.5 = mul i8 %start, 5
  %t.1 = icmp ule i8 %start.mul.3, %start.mul.5
  ret i1 %t.1
}

define i1 @test_mul_const_no_nuw_unsigned_13(i8 %start) {
; CHECK-LABEL: @test_mul_const_no_nuw_unsigned_13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[START_MUL_3:%.*]] = mul i8 [[START:%.*]], 3
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START]], [[START_MUL_3]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_5:%.*]] = mul i8 [[START]], 5
; CHECK-NEXT:    [[F_1:%.*]] = icmp ule i8 [[START_MUL_5]], [[START_MUL_3]]
; CHECK-NEXT:    ret i1 [[F_1]]
;
entry:
  %start.mul.3 = mul i8 %start, 3
  %c.1 = icmp ult i8 %start, %start.mul.3
  call void @llvm.assume(i1 %c.1)

  %start.mul.5 = mul i8 %start, 5
  %f.1 = icmp ule i8 %start.mul.5, %start.mul.3
  ret i1 %f.1
}

define i1 @test_mul_add_const_no_nuw_unsigned_1(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_no_nuw_unsigned_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i8 [[START]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T_1]]
;
entry:
  %add = add i8 %start, 3
  %start.mul.4 = mul i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %t.1 = icmp ult i8 %start, %high
  ret i1 %t.1
}

define i1 @test_mul_add_const_no_nuw_unsigned_2(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_no_nuw_unsigned_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i8 [[START_MUL_2]], [[HIGH]]
; CHECK-NEXT:    ret i1 [[T_2]]
;
entry:
  %add = add i8 %start, 3
  %start.mul.4 = mul i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %t.2 = icmp ult i8 %start.mul.2, %high
  ret i1 %t.2
}

define i1 @test_mul_add_const_no_nuw_unsigned_3(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_no_nuw_unsigned_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[T_3:%.*]] = icmp ule i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_3]]
;
entry:
  %add = add i8 %start, 3
  %start.mul.4 = mul i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %t.3 = icmp ule i8 %start.add.2, %start.mul.4
  ret i1 %t.3
}

define i1 @test_mul_add_const_no_nuw_unsigned_4(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_no_nuw_unsigned_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_MUL_2:%.*]] = mul i8 [[START]], 2
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[T_4:%.*]] = icmp ult i8 [[START_ADD_2]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_4]]
;
entry:
  %add = add i8 %start, 3
  %start.mul.4 = mul i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.mul.2 = mul i8 %start, 2
  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %t.4 = icmp ult i8 %start.add.2, %start.mul.4
  ret i1 %t.4
}

define i1 @test_mul_add_const_no_nuw_unsigned_5(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_no_nuw_unsigned_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_12:%.*]] = add i8 [[START_ADD_2]], 12
; CHECK-NEXT:    [[T_5:%.*]] = icmp ule i8 [[START_ADD_2_12]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[T_5]]
;
entry:
  %add = add i8 %start, 3
  %start.mul.4 = mul i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %start.add.2.12 = add i8 %start.add.2, 12
  %t.5 = icmp ule i8 %start.add.2.12, %start.mul.4
  ret i1 %t.5
}

define i1 @test_mul_add_const_no_nuw_unsigned_6(i8 %start, i8 %high) {
; CHECK-LABEL: @test_mul_add_const_no_nuw_unsigned_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD:%.*]] = add i8 [[START:%.*]], 3
; CHECK-NEXT:    [[START_MUL_4:%.*]] = mul i8 [[ADD]], 4
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i8 [[START_MUL_4]], [[HIGH:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    [[START_ADD_1:%.*]] = add i8 [[START]], [[START]]
; CHECK-NEXT:    [[START_ADD_2:%.*]] = add i8 [[START_ADD_1]], [[START_ADD_1]]
; CHECK-NEXT:    [[START_ADD_2_13:%.*]] = add i8 [[START_ADD_2]], 13
; CHECK-NEXT:    [[F_1:%.*]] = icmp ule i8 [[START_ADD_2_13]], [[START_MUL_4]]
; CHECK-NEXT:    ret i1 [[F_1]]
;
entry:
  %add = add i8 %start, 3
  %start.mul.4 = mul i8 %add, 4
  %c.1 = icmp ult i8 %start.mul.4, %high
  call void @llvm.assume(i1 %c.1)

  %start.add.1 = add i8 %start, %start
  %start.add.2 = add i8 %start.add.1, %start.add.1
  %start.add.2.13 = add i8 %start.add.2, 13
  %f.1 = icmp ule i8 %start.add.2.13, %start.mul.4
  ret i1 %f.1
}

