; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i8 @urem_low_bits_know(i8 %xx, i8 %yy) {
; CHECK-LABEL: @urem_low_bits_know(
; CHECK-NEXT:    ret i8 2
;
  %x = or i8 %xx, 2
  %y = and i8 %yy, -4
  %rem = urem i8 %x, %y
  %r = and i8 %rem, 2
  ret i8 %r
}

define i8 @urem_high_bits_know(i8 %xx, i8 %yy) {
; CHECK-LABEL: @urem_high_bits_know(
; CHECK-NEXT:    ret i8 0
;
  %x = and i8 %xx, 2
  %y = and i8 %yy, -4
  %rem = urem i8 %x, %y
  %r = and i8 %rem, 8
  ret i8 %r
}

define i8 @urem_low_bits_know2(i8 %xx, i8 %yy) {
; CHECK-LABEL: @urem_low_bits_know2(
; CHECK-NEXT:    ret i8 2
;
  %xo = or i8 %xx, 2
  %x = and i8 %xo, 254
  %y = and i8 %yy, -4
  %rem = urem i8 %x, %y
  %r = and i8 %rem, 3
  ret i8 %r
}

define i8 @urem_todo_low_bits_partially_know_should_fold_out_urem(i8 %xx, i8 %yy) {
; CHECK-LABEL: @urem_todo_low_bits_partially_know_should_fold_out_urem(
; CHECK-NEXT:    [[X:%.*]] = or i8 [[XX:%.*]], 2
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY:%.*]], -4
; CHECK-NEXT:    [[REM:%.*]] = urem i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[REM]], 3
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or i8 %xx, 2
  %y = and i8 %yy, -4
  %rem = urem i8 %x, %y
  %r = and i8 %rem, 3
  ret i8 %r
}

define i8 @urem_fail_low_bits_unknown(i8 %xx, i8 %yy) {
; CHECK-LABEL: @urem_fail_low_bits_unknown(
; CHECK-NEXT:    [[X:%.*]] = or i8 [[XX:%.*]], 4
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY:%.*]], -4
; CHECK-NEXT:    [[REM:%.*]] = urem i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[REM]], 2
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or i8 %xx, 4
  %y = and i8 %yy, -4
  %rem = urem i8 %x, %y
  %r = and i8 %rem, 2
  ret i8 %r
}

define i8 @urem_fail_low_bits_unknown2(i8 %xx, i8 %yy) {
; CHECK-LABEL: @urem_fail_low_bits_unknown2(
; CHECK-NEXT:    [[X:%.*]] = or i8 [[XX:%.*]], 1
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY:%.*]], -5
; CHECK-NEXT:    [[REM:%.*]] = urem i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[REM]], 2
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or i8 %xx, 1
  %y = and i8 %yy, -5
  %rem = urem i8 %x, %y
  %r = and i8 %rem, 2
  ret i8 %r
}

define i8 @srem_low_bits_know(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_low_bits_know(
; CHECK-NEXT:    ret i8 2
;
  %x = or i8 %xx, 10
  %y = and i8 %yy, -4
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 2
  ret i8 %r
}

define i8 @srem_low_bits_know2(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_low_bits_know2(
; CHECK-NEXT:    ret i8 1
;
  %x = or i8 %xx, 1
  %y = and i8 %yy, -2
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 1
  ret i8 %r
}

define i8 @srem_high_bits_know(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_high_bits_know(
; CHECK-NEXT:    ret i8 -2
;
  %x = or i8 %xx, -2
  %y = and i8 %yy, -4
  %rem = srem i8 %x, %y
  %r = and i8 %rem, -2
  ret i8 %r
}

define i8 @srem_high_bits_know2(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_high_bits_know2(
; CHECK-NEXT:    ret i8 0
;
  %x = and i8 %xx, 13
  %y = or i8 %yy, -4
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 8
  ret i8 %r
}

define i8 @srem_high_bits_know3(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_high_bits_know3(
; CHECK-NEXT:    ret i8 8
;
  %x = or i8 %xx, -13
  %y = and i8 %yy, 4
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 8
  ret i8 %r
}

define i8 @srem_high_bits_know4(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_high_bits_know4(
; CHECK-NEXT:    ret i8 0
;
  %x = and i8 %xx, 4
  %y = or i8 %yy, -13
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 8
  ret i8 %r
}

define i8 @srem_high_bits_know5(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_high_bits_know5(
; CHECK-NEXT:    [[X:%.*]] = and i8 [[XX:%.*]], 2
; CHECK-NEXT:    ret i8 [[X]]
;
  %x = and i8 %xx, 2
  %y = and i8 %yy, 4
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 2
  ret i8 %r
}

define i8 @srem_todo_low_bits_partially_know_should_fold_out_srem(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_todo_low_bits_partially_know_should_fold_out_srem(
; CHECK-NEXT:    [[X:%.*]] = or i8 [[XX:%.*]], 10
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY:%.*]], -4
; CHECK-NEXT:    [[REM:%.*]] = srem i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[REM]], 3
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or i8 %xx, 10
  %y = and i8 %yy, -4
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 3
  ret i8 %r
}

define i8 @srem_fail_low_bits_unknown(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_fail_low_bits_unknown(
; CHECK-NEXT:    [[X:%.*]] = or i8 [[XX:%.*]], 4
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY:%.*]], -4
; CHECK-NEXT:    [[REM:%.*]] = srem i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[REM]], 2
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or i8 %xx, 4
  %y = and i8 %yy, -4
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 2
  ret i8 %r
}

define i8 @srem_fail_irrelivent_bits_known(i8 %xx, i8 %yy) {
; CHECK-LABEL: @srem_fail_irrelivent_bits_known(
; CHECK-NEXT:    [[X:%.*]] = or i8 [[XX:%.*]], 3
; CHECK-NEXT:    [[Y:%.*]] = and i8 [[YY:%.*]], -6
; CHECK-NEXT:    [[REM:%.*]] = srem i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = and i8 [[REM]], 2
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = or i8 %xx, 3
  %y = and i8 %yy, -6
  %rem = srem i8 %x, %y
  %r = and i8 %rem, 2
  ret i8 %r
}
