; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse3 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512
;
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=slm | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=goldmont | FileCheck %s --check-prefixes=SSE41
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mcpu=btver2 | FileCheck %s --check-prefixes=AVX1

define i32 @cmp_float_oeq(i32 %arg) {
; SSE2-LABEL: 'cmp_float_oeq'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp oeq float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp oeq <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp oeq <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp oeq <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp oeq <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp oeq double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp oeq <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp oeq <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp oeq <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp oeq <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_oeq'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp oeq float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp oeq <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp oeq <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp oeq <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp oeq <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp oeq double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp oeq <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp oeq <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp oeq <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp oeq <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_oeq'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp oeq float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp oeq <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp oeq <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp oeq <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp oeq <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp oeq double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp oeq <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp oeq <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp oeq <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp oeq <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_oeq'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp oeq float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp oeq <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp oeq <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp oeq <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp oeq <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp oeq double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp oeq <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp oeq <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp oeq <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp oeq <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_oeq'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp oeq float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp oeq <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp oeq <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp oeq <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp oeq <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp oeq double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp oeq <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp oeq <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp oeq <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp oeq <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp oeq float undef, undef
  %V2F32 = fcmp oeq <2 x float> undef, undef
  %V4F32 = fcmp oeq <4 x float> undef, undef
  %V8F32 = fcmp oeq <8 x float> undef, undef
  %V16F32 = fcmp oeq <16 x float> undef, undef

  %F64 = fcmp oeq double undef, undef
  %V2F64 = fcmp oeq <2 x double> undef, undef
  %V4F64 = fcmp oeq <4 x double> undef, undef
  %V8F64 = fcmp oeq <8 x double> undef, undef
  %V16F64 = fcmp oeq <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_one(i32 %arg) {
; SSE2-LABEL: 'cmp_float_one'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp one float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2F32 = fcmp one <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V4F32 = fcmp one <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:21 SizeLat:5 for: %V8F32 = fcmp one <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:41 SizeLat:9 for: %V16F32 = fcmp one <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp one double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2F64 = fcmp one <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:21 SizeLat:5 for: %V4F64 = fcmp one <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:41 SizeLat:9 for: %V8F64 = fcmp one <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:17 Lat:81 SizeLat:17 for: %V16F64 = fcmp one <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_one'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp one float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2F32 = fcmp one <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V4F32 = fcmp one <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:21 SizeLat:5 for: %V8F32 = fcmp one <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:41 SizeLat:9 for: %V16F32 = fcmp one <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp one double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2F64 = fcmp one <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:21 SizeLat:5 for: %V4F64 = fcmp one <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:41 SizeLat:9 for: %V8F64 = fcmp one <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:17 Lat:81 SizeLat:17 for: %V16F64 = fcmp one <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_one'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp one float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp one <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp one <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp one <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp one <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp one double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp one <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp one <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp one <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp one <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_one'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp one float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp one <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp one <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp one <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp one <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp one double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp one <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp one <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp one <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp one <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_one'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp one float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp one <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp one <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp one <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp one <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp one double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp one <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp one <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp one <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp one <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp one float undef, undef
  %V2F32 = fcmp one <2 x float> undef, undef
  %V4F32 = fcmp one <4 x float> undef, undef
  %V8F32 = fcmp one <8 x float> undef, undef
  %V16F32 = fcmp one <16 x float> undef, undef

  %F64 = fcmp one double undef, undef
  %V2F64 = fcmp one <2 x double> undef, undef
  %V4F64 = fcmp one <4 x double> undef, undef
  %V8F64 = fcmp one <8 x double> undef, undef
  %V16F64 = fcmp one <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ord(i32 %arg) {
; SSE2-LABEL: 'cmp_float_ord'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ord float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ord <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ord <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ord <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ord <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ord double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ord <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ord <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ord <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ord <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_ord'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ord float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ord <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ord <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ord <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ord <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ord double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ord <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ord <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ord <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ord <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_ord'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp ord float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp ord <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp ord <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp ord <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp ord <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp ord double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp ord <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp ord <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp ord <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp ord <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_ord'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ord float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ord <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ord <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp ord <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp ord <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ord double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ord <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp ord <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp ord <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp ord <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ord'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ord float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ord <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ord <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp ord <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp ord <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ord double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ord <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp ord <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp ord <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp ord <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp ord float undef, undef
  %V2F32 = fcmp ord <2 x float> undef, undef
  %V4F32 = fcmp ord <4 x float> undef, undef
  %V8F32 = fcmp ord <8 x float> undef, undef
  %V16F32 = fcmp ord <16 x float> undef, undef

  %F64 = fcmp ord double undef, undef
  %V2F64 = fcmp ord <2 x double> undef, undef
  %V4F64 = fcmp ord <4 x double> undef, undef
  %V8F64 = fcmp ord <8 x double> undef, undef
  %V16F64 = fcmp ord <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_oge(i32 %arg) {
; SSE2-LABEL: 'cmp_float_oge'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp oge float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp oge <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp oge <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp oge <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp oge <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp oge double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp oge <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp oge <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp oge <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp oge <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_oge'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp oge float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp oge <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp oge <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp oge <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp oge <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp oge double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp oge <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp oge <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp oge <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp oge <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_oge'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp oge float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp oge <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp oge <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp oge <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp oge <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp oge double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp oge <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp oge <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp oge <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp oge <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_oge'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp oge float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp oge <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp oge <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp oge <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp oge <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp oge double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp oge <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp oge <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp oge <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp oge <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_oge'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp oge float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp oge <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp oge <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp oge <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp oge <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp oge double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp oge <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp oge <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp oge <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp oge <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp oge float undef, undef
  %V2F32 = fcmp oge <2 x float> undef, undef
  %V4F32 = fcmp oge <4 x float> undef, undef
  %V8F32 = fcmp oge <8 x float> undef, undef
  %V16F32 = fcmp oge <16 x float> undef, undef

  %F64 = fcmp oge double undef, undef
  %V2F64 = fcmp oge <2 x double> undef, undef
  %V4F64 = fcmp oge <4 x double> undef, undef
  %V8F64 = fcmp oge <8 x double> undef, undef
  %V16F64 = fcmp oge <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ogt(i32 %arg) {
; SSE2-LABEL: 'cmp_float_ogt'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ogt float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ogt <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ogt <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ogt <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ogt <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ogt double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ogt <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ogt <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ogt <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ogt <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_ogt'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ogt float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ogt <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ogt <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ogt <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ogt <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ogt double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ogt <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ogt <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ogt <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ogt <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_ogt'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp ogt float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp ogt <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp ogt <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp ogt <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp ogt <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp ogt double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp ogt <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp ogt <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp ogt <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp ogt <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_ogt'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ogt float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ogt <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ogt <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp ogt <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp ogt <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ogt double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ogt <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp ogt <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp ogt <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp ogt <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ogt'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ogt float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ogt <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ogt <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp ogt <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp ogt <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ogt double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ogt <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp ogt <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp ogt <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp ogt <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp ogt float undef, undef
  %V2F32 = fcmp ogt <2 x float> undef, undef
  %V4F32 = fcmp ogt <4 x float> undef, undef
  %V8F32 = fcmp ogt <8 x float> undef, undef
  %V16F32 = fcmp ogt <16 x float> undef, undef

  %F64 = fcmp ogt double undef, undef
  %V2F64 = fcmp ogt <2 x double> undef, undef
  %V4F64 = fcmp ogt <4 x double> undef, undef
  %V8F64 = fcmp ogt <8 x double> undef, undef
  %V16F64 = fcmp ogt <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ole(i32 %arg) {
; SSE2-LABEL: 'cmp_float_ole'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ole float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ole <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ole <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ole <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ole <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ole double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ole <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ole <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ole <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ole <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_ole'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ole float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ole <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ole <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ole <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ole <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ole double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ole <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ole <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ole <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ole <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_ole'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp ole float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp ole <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp ole <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp ole <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp ole <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp ole double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp ole <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp ole <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp ole <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp ole <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_ole'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ole float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ole <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ole <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp ole <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp ole <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ole double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ole <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp ole <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp ole <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp ole <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ole'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ole float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ole <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ole <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp ole <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp ole <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ole double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ole <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp ole <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp ole <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp ole <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp ole float undef, undef
  %V2F32 = fcmp ole <2 x float> undef, undef
  %V4F32 = fcmp ole <4 x float> undef, undef
  %V8F32 = fcmp ole <8 x float> undef, undef
  %V16F32 = fcmp ole <16 x float> undef, undef

  %F64 = fcmp ole double undef, undef
  %V2F64 = fcmp ole <2 x double> undef, undef
  %V4F64 = fcmp ole <4 x double> undef, undef
  %V8F64 = fcmp ole <8 x double> undef, undef
  %V16F64 = fcmp ole <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_olt(i32 %arg) {
; SSE2-LABEL: 'cmp_float_olt'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp olt float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp olt <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp olt <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp olt <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp olt <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp olt double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp olt <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp olt <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp olt <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp olt <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_olt'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp olt float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp olt <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp olt <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp olt <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp olt <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp olt double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp olt <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp olt <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp olt <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp olt <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_olt'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp olt float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp olt <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp olt <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp olt <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp olt <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp olt double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp olt <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp olt <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp olt <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp olt <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_olt'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp olt float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp olt <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp olt <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp olt <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp olt <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp olt double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp olt <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp olt <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp olt <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp olt <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_olt'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp olt float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp olt <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp olt <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp olt <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp olt <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp olt double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp olt <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp olt <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp olt <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp olt <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp olt float undef, undef
  %V2F32 = fcmp olt <2 x float> undef, undef
  %V4F32 = fcmp olt <4 x float> undef, undef
  %V8F32 = fcmp olt <8 x float> undef, undef
  %V16F32 = fcmp olt <16 x float> undef, undef

  %F64 = fcmp olt double undef, undef
  %V2F64 = fcmp olt <2 x double> undef, undef
  %V4F64 = fcmp olt <4 x double> undef, undef
  %V8F64 = fcmp olt <8 x double> undef, undef
  %V16F64 = fcmp olt <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ueq(i32 %arg) {
; SSE2-LABEL: 'cmp_float_ueq'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ueq float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2F32 = fcmp ueq <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V4F32 = fcmp ueq <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:21 SizeLat:5 for: %V8F32 = fcmp ueq <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:41 SizeLat:9 for: %V16F32 = fcmp ueq <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ueq double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:3 Lat:11 SizeLat:3 for: %V2F64 = fcmp ueq <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:5 Lat:21 SizeLat:5 for: %V4F64 = fcmp ueq <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:9 Lat:41 SizeLat:9 for: %V8F64 = fcmp ueq <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:17 Lat:81 SizeLat:17 for: %V16F64 = fcmp ueq <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_ueq'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ueq float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2F32 = fcmp ueq <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V4F32 = fcmp ueq <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:21 SizeLat:5 for: %V8F32 = fcmp ueq <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:41 SizeLat:9 for: %V16F32 = fcmp ueq <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ueq double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:3 Lat:11 SizeLat:3 for: %V2F64 = fcmp ueq <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:5 Lat:21 SizeLat:5 for: %V4F64 = fcmp ueq <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:9 Lat:41 SizeLat:9 for: %V8F64 = fcmp ueq <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:17 CodeSize:17 Lat:81 SizeLat:17 for: %V16F64 = fcmp ueq <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_ueq'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp ueq float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp ueq <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp ueq <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp ueq <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp ueq <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp ueq double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp ueq <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp ueq <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp ueq <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp ueq <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_ueq'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ueq float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ueq <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ueq <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp ueq <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp ueq <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ueq double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ueq <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp ueq <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp ueq <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp ueq <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ueq'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ueq float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ueq <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ueq <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp ueq <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp ueq <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ueq double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ueq <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp ueq <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp ueq <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp ueq <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp ueq float undef, undef
  %V2F32 = fcmp ueq <2 x float> undef, undef
  %V4F32 = fcmp ueq <4 x float> undef, undef
  %V8F32 = fcmp ueq <8 x float> undef, undef
  %V16F32 = fcmp ueq <16 x float> undef, undef

  %F64 = fcmp ueq double undef, undef
  %V2F64 = fcmp ueq <2 x double> undef, undef
  %V4F64 = fcmp ueq <4 x double> undef, undef
  %V8F64 = fcmp ueq <8 x double> undef, undef
  %V16F64 = fcmp ueq <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_une(i32 %arg) {
; SSE2-LABEL: 'cmp_float_une'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp une float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp une <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp une <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp une <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp une <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp une double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp une <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp une <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp une <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp une <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_une'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp une float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp une <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp une <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp une <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp une <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp une double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp une <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp une <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp une <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp une <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_une'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp une float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp une <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp une <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp une <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp une <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp une double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp une <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp une <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp une <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp une <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_une'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp une float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp une <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp une <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp une <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp une <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp une double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp une <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp une <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp une <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp une <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_une'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp une float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp une <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp une <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp une <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp une <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp une double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp une <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp une <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp une <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp une <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp une float undef, undef
  %V2F32 = fcmp une <2 x float> undef, undef
  %V4F32 = fcmp une <4 x float> undef, undef
  %V8F32 = fcmp une <8 x float> undef, undef
  %V16F32 = fcmp une <16 x float> undef, undef

  %F64 = fcmp une double undef, undef
  %V2F64 = fcmp une <2 x double> undef, undef
  %V4F64 = fcmp une <4 x double> undef, undef
  %V8F64 = fcmp une <8 x double> undef, undef
  %V16F64 = fcmp une <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_uno(i32 %arg) {
; SSE2-LABEL: 'cmp_float_uno'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp uno float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp uno <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp uno <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp uno <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp uno <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp uno double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp uno <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp uno <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp uno <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp uno <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_uno'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp uno float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp uno <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp uno <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp uno <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp uno <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp uno double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp uno <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp uno <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp uno <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp uno <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_uno'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp uno float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp uno <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp uno <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp uno <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp uno <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp uno double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp uno <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp uno <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp uno <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp uno <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_uno'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp uno float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp uno <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp uno <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp uno <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp uno <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp uno double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp uno <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp uno <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp uno <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp uno <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_uno'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp uno float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp uno <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp uno <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp uno <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp uno <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp uno double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp uno <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp uno <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp uno <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp uno <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp uno float undef, undef
  %V2F32 = fcmp uno <2 x float> undef, undef
  %V4F32 = fcmp uno <4 x float> undef, undef
  %V8F32 = fcmp uno <8 x float> undef, undef
  %V16F32 = fcmp uno <16 x float> undef, undef

  %F64 = fcmp uno double undef, undef
  %V2F64 = fcmp uno <2 x double> undef, undef
  %V4F64 = fcmp uno <4 x double> undef, undef
  %V8F64 = fcmp uno <8 x double> undef, undef
  %V16F64 = fcmp uno <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_uge(i32 %arg) {
; SSE2-LABEL: 'cmp_float_uge'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp uge float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp uge <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp uge <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp uge <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp uge <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp uge double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp uge <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp uge <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp uge <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp uge <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_uge'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp uge float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp uge <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp uge <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp uge <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp uge <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp uge double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp uge <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp uge <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp uge <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp uge <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_uge'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp uge float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp uge <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp uge <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp uge <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp uge <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp uge double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp uge <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp uge <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp uge <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp uge <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_uge'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp uge float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp uge <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp uge <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp uge <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp uge <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp uge double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp uge <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp uge <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp uge <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp uge <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_uge'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp uge float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp uge <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp uge <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp uge <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp uge <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp uge double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp uge <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp uge <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp uge <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp uge <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp uge float undef, undef
  %V2F32 = fcmp uge <2 x float> undef, undef
  %V4F32 = fcmp uge <4 x float> undef, undef
  %V8F32 = fcmp uge <8 x float> undef, undef
  %V16F32 = fcmp uge <16 x float> undef, undef

  %F64 = fcmp uge double undef, undef
  %V2F64 = fcmp uge <2 x double> undef, undef
  %V4F64 = fcmp uge <4 x double> undef, undef
  %V8F64 = fcmp uge <8 x double> undef, undef
  %V16F64 = fcmp uge <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ugt(i32 %arg) {
; SSE2-LABEL: 'cmp_float_ugt'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ugt float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ugt <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ugt <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ugt <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ugt <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ugt double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ugt <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ugt <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ugt <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ugt <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_ugt'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ugt float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ugt <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ugt <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ugt <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ugt <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ugt double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ugt <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ugt <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ugt <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ugt <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_ugt'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp ugt float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp ugt <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp ugt <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp ugt <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp ugt <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp ugt double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp ugt <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp ugt <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp ugt <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp ugt <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_ugt'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ugt float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ugt <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ugt <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp ugt <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp ugt <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ugt double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ugt <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp ugt <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp ugt <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp ugt <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ugt'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ugt float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ugt <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ugt <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp ugt <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp ugt <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ugt double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ugt <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp ugt <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp ugt <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp ugt <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp ugt float undef, undef
  %V2F32 = fcmp ugt <2 x float> undef, undef
  %V4F32 = fcmp ugt <4 x float> undef, undef
  %V8F32 = fcmp ugt <8 x float> undef, undef
  %V16F32 = fcmp ugt <16 x float> undef, undef

  %F64 = fcmp ugt double undef, undef
  %V2F64 = fcmp ugt <2 x double> undef, undef
  %V4F64 = fcmp ugt <4 x double> undef, undef
  %V8F64 = fcmp ugt <8 x double> undef, undef
  %V16F64 = fcmp ugt <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ule(i32 %arg) {
; SSE2-LABEL: 'cmp_float_ule'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ule float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ule <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ule <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ule <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ule <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ule double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ule <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ule <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ule <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ule <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_ule'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ule float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ule <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ule <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ule <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ule <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ule double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ule <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ule <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ule <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ule <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_ule'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp ule float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp ule <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp ule <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp ule <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp ule <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp ule double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp ule <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp ule <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp ule <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp ule <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_ule'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ule float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ule <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ule <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp ule <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp ule <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ule double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ule <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp ule <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp ule <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp ule <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ule'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ule float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ule <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ule <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp ule <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp ule <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ule double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ule <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp ule <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp ule <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp ule <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp ule float undef, undef
  %V2F32 = fcmp ule <2 x float> undef, undef
  %V4F32 = fcmp ule <4 x float> undef, undef
  %V8F32 = fcmp ule <8 x float> undef, undef
  %V16F32 = fcmp ule <16 x float> undef, undef

  %F64 = fcmp ule double undef, undef
  %V2F64 = fcmp ule <2 x double> undef, undef
  %V4F64 = fcmp ule <4 x double> undef, undef
  %V8F64 = fcmp ule <8 x double> undef, undef
  %V16F64 = fcmp ule <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ult(i32 %arg) {
; SSE2-LABEL: 'cmp_float_ult'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ult float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ult <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ult <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ult <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ult <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ult double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ult <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ult <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ult <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ult <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_ult'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp ult float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp ult <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp ult <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp ult <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp ult <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp ult double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp ult <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp ult <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp ult <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp ult <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_ult'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp ult float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp ult <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp ult <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp ult <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp ult <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp ult double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp ult <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp ult <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp ult <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp ult <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_ult'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ult float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ult <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ult <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp ult <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp ult <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ult double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ult <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp ult <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp ult <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp ult <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ult'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp ult float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp ult <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp ult <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp ult <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp ult <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp ult double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp ult <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp ult <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp ult <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp ult <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp ult float undef, undef
  %V2F32 = fcmp ult <2 x float> undef, undef
  %V4F32 = fcmp ult <4 x float> undef, undef
  %V8F32 = fcmp ult <8 x float> undef, undef
  %V16F32 = fcmp ult <16 x float> undef, undef

  %F64 = fcmp ult double undef, undef
  %V2F64 = fcmp ult <2 x double> undef, undef
  %V4F64 = fcmp ult <4 x double> undef, undef
  %V8F64 = fcmp ult <8 x double> undef, undef
  %V16F64 = fcmp ult <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_false(i32 %arg) {
; SSE2-LABEL: 'cmp_float_false'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp false float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp false <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp false <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp false <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp false <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp false double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp false <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp false <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp false <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp false <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_false'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp false float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp false <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp false <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp false <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp false <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp false double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp false <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp false <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp false <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp false <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_false'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp false float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp false <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp false <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp false <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp false <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp false double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp false <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp false <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp false <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp false <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_false'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp false float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp false <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp false <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp false <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp false <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp false double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp false <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp false <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp false <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp false <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_false'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp false float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp false <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp false <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp false <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp false <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp false double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp false <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp false <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp false <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp false <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp false float undef, undef
  %V2F32 = fcmp false <2 x float> undef, undef
  %V4F32 = fcmp false <4 x float> undef, undef
  %V8F32 = fcmp false <8 x float> undef, undef
  %V16F32 = fcmp false <16 x float> undef, undef

  %F64 = fcmp false double undef, undef
  %V2F64 = fcmp false <2 x double> undef, undef
  %V4F64 = fcmp false <4 x double> undef, undef
  %V8F64 = fcmp false <8 x double> undef, undef
  %V16F64 = fcmp false <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_true(i32 %arg) {
; SSE2-LABEL: 'cmp_float_true'
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp true float undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp true <2 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp true <4 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp true <8 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp true <16 x float> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp true double undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp true <2 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp true <4 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp true <8 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp true <16 x double> undef, undef
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE41-LABEL: 'cmp_float_true'
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F32 = fcmp true float undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F32 = fcmp true <2 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V4F32 = fcmp true <4 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V8F32 = fcmp true <8 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V16F32 = fcmp true <16 x float> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %F64 = fcmp true double undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:5 SizeLat:1 for: %V2F64 = fcmp true <2 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:10 SizeLat:2 for: %V4F64 = fcmp true <4 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:20 SizeLat:4 for: %V8F64 = fcmp true <8 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:8 Lat:40 SizeLat:8 for: %V16F64 = fcmp true <16 x double> undef, undef
; SSE41-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'cmp_float_true'
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F32 = fcmp true float undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F32 = fcmp true <2 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V4F32 = fcmp true <4 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V8F32 = fcmp true <8 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V16F32 = fcmp true <16 x float> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %F64 = fcmp true double undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:3 SizeLat:1 for: %V2F64 = fcmp true <2 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:3 SizeLat:2 for: %V4F64 = fcmp true <4 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:6 SizeLat:4 for: %V8F64 = fcmp true <8 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:12 SizeLat:8 for: %V16F64 = fcmp true <16 x double> undef, undef
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'cmp_float_true'
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp true float undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp true <2 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp true <4 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V8F32 = fcmp true <8 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V16F32 = fcmp true <16 x float> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp true double undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp true <2 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:2 for: %V4F64 = fcmp true <4 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:4 for: %V8F64 = fcmp true <8 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:16 SizeLat:8 for: %V16F64 = fcmp true <16 x double> undef, undef
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_true'
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F32 = fcmp true float undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F32 = fcmp true <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F32 = fcmp true <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F32 = fcmp true <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V16F32 = fcmp true <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %F64 = fcmp true double undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V2F64 = fcmp true <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V4F64 = fcmp true <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:4 SizeLat:1 for: %V8F64 = fcmp true <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:8 SizeLat:2 for: %V16F64 = fcmp true <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %F32 = fcmp true float undef, undef
  %V2F32 = fcmp true <2 x float> undef, undef
  %V4F32 = fcmp true <4 x float> undef, undef
  %V8F32 = fcmp true <8 x float> undef, undef
  %V16F32 = fcmp true <16 x float> undef, undef

  %F64 = fcmp true double undef, undef
  %V2F64 = fcmp true <2 x double> undef, undef
  %V4F64 = fcmp true <4 x double> undef, undef
  %V8F64 = fcmp true <8 x double> undef, undef
  %V16F64 = fcmp true <16 x double> undef, undef

  ret i32 undef
}
