/* PR libgcc/113604 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c23 -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 513
signed _BitInt(513)
foo (signed _BitInt(513) x, signed _BitInt(513) y)
{
  return x % y;
}
#endif

#if __BITINT_MAXWIDTH__ >= 512
unsigned _BitInt(512)
bar (unsigned _BitInt(512) x, unsigned _BitInt(512) y)
{
  return x % y;
}
#endif

#if __BITINT_MAXWIDTH__ >= 256
unsigned _BitInt(256)
baz (unsigned _BitInt(256) x, unsigned _BitInt(256) y)
{
  return x % y;
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 513
  if (foo (11155754932722990178552651944728825929130437979239421228991532051555943675wb,
	   32783817256434357484609367438786815wb) != 0wb)
    __builtin_abort ();
  if (foo (542904728531209767665756029992981529373473101602268731408384wb,
	   235447394450476261134537147263765988105wb)
      != 235447394450476261116090403190056436489wb)
    __builtin_abort ();
  if (foo (542904728531209767665690117878483036079552477922114364506112wb,
	   235447394450476261134537147263765988105wb)
      != 169535279951982967195466723035689534217wb)
    __builtin_abort ();
  if (foo (542904728531209767665690117878483036079534031178040654954496wb,
	   235447394450476261134537147263765988105wb)
      != 169535279951982967177019978961979982601wb)
    __builtin_abort ();
  if (foo (542904728531209767665454670484032559818581851459155356811264wb,
	   235447394450476261134537147263765988105wb)
      != 169535279951982967359377407340447827474wb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 512
  if (bar (6703903964971298549787012499102923063739682910296196688861780721860882015036773488400937149083451713845015929093243025426876941405973284973216824503042048uwb,
	   170141183460469231731687303715884105735uwb) != 19208uwb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 256
  if (baz (115792089237316195423570985008687907853269984665640564039457584007913129639926uwb,
	   68056473384187692692674921486353642292uwb) != 6uwb)
    __builtin_abort ();
#endif
  return 0;
}
