/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-O2 -std=c23 -pedantic-errors" } */

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _Decimal64
tests192 (_BitInt(192) b)
{
  return b;
}

__attribute__((noipa)) _Decimal64
testu192 (unsigned _BitInt(192) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _Decimal64
tests575 (_BitInt(575) b)
{
  return b;
}

__attribute__((noipa)) _Decimal64
testu575 (unsigned _BitInt(575) b)
{
  return b;
}
#endif

int
main ()
{
  _Decimal64 a, b;
#define CHECK(x, y) (a = (x), b = (y), a != (y) || __builtin_memcmp (&a, &b, sizeof (a)))
#if __BITINT_MAXWIDTH__ >= 192
  if (CHECK (tests192 (0wb), 0.DD)
      || CHECK (tests192 (7wb), 7.DD)
      || CHECK (tests192 (-42wb), -42.DD)
      || CHECK (tests192 (-777777777wb), -777777777.DD)
      || CHECK (tests192 (9999999999999000wb), 9999999999999000.DD)
      || CHECK (tests192 (-9999999999999999wb), -9999999999999999.DD)
      || CHECK (tests192 (-99999999999999994wb), -9999999999999999.e+1DD)
      || CHECK (tests192 (99999999999999995wb), 1000000000000000.e+2DD)
      || CHECK (tests192 (999999999999999900wb), 9999999999999999.e+2DD)
      || CHECK (tests192 (999999999999999949wb), 9999999999999999.e+2DD)
      || CHECK (tests192 (-9999999999999999000wb), -9999999999999999.e+3DD)
      || CHECK (tests192 (9999999999999999499wb), 9999999999999999.e+3DD)
      || CHECK (tests192 (999999999999999900000wb), 9999999999999999.e+5DD)
      || CHECK (tests192 (999999999999999949999wb), 9999999999999999.e+5DD)
      || CHECK (tests192 (-9999999999999999000000wb), -9999999999999999.e+6DD)
      || CHECK (tests192 (-9999999999999999499999wb), -9999999999999999.e+6DD)
      || CHECK (tests192 (123456789012345600000000wb), 1234567890123456.e+8DD)
      || CHECK (tests192 (34242319854454290000000000000000000000wb), 3424231985445429e+22DD)
      || CHECK (tests192 (999999999999999900000000000000000000000000000000wb), 9999999999999999.e+32DD)
      || CHECK (tests192 (999999999999999949999999999999999999999999999999wb), 9999999999999999.e+32DD)
      || CHECK (tests192 (-999999999999999900000000000000000000000000000000000000000wb), -9999999999999999.e+41DD)
      || CHECK (tests192 (-2138550877694459000000000000000000000000000000000000000000wb), -2138550877694459e+42DD)
      || CHECK (tests192 (-2138550877694459500000000000000000000000000000000000000000wb), -2138550877694460e+42DD)
      || CHECK (tests192 (-2138550877694459499999999999999999999999999999999999999999wb), -2138550877694459e+42DD)
      || CHECK (tests192 (-2138550877694459999999999999999999999999999999999999999999wb), -2138550877694460e+42DD)
      || CHECK (tests192 (-2138550877694458000000000000000000000000000000000000000000wb), -2138550877694458e+42DD)
      || CHECK (tests192 (-2138550877694458500000000000000000000000000000000000000000wb), -2138550877694458e+42DD)
      || CHECK (tests192 (-2138550877694458500000000000000000000000000000000000000001wb), -2138550877694459e+42DD)
      || CHECK (tests192 (3138550867693340000000000000000000000000000000000000000000wb), 3138550867693340e+42DD)
      || CHECK (tests192 (3138550867693340381917894711603833208051177722232017256447wb), 3138550867693340e+42DD)
      || CHECK (tests192 (-3138550867693340000000000000000000000000000000000000000000wb), -3138550867693340e+42DD)
      || CHECK (tests192 (-3138550867693340381917894711603833208051177722232017256447wb - 1wb), -3138550867693340e+42DD))
    __builtin_abort ();
  if (CHECK (testu192 (0uwb), 0.DD)
      || CHECK (testu192 (7uwb), 7.DD)
      || CHECK (testu192 (42uwb), 42.DD)
      || CHECK (testu192 (777777777uwb), 777777777.DD)
      || CHECK (testu192 (9999999999999000uwb), 9999999999999000.DD)
      || CHECK (testu192 (999999999999999900uwb), 9999999999999999.e+2DD)
      || CHECK (testu192 (9999999999999999000uwb), 9999999999999999.e+3DD)
      || CHECK (testu192 (99999999999999994999uwb), 9999999999999999.e+4DD)
      || CHECK (testu192 (999999999999999900000uwb), 9999999999999999.e+5DD)
      || CHECK (testu192 (9999999999999999000000uwb), 9999999999999999.e+6DD)
      || CHECK (testu192 (123456789012345600000000uwb), 1234567890123456.e+8DD)
      || CHECK (testu192 (34242319854454290000000000000000000000uwb), 3424231985445429e+22DD)
      || CHECK (testu192 (9999999999999999000000000000000000000000000000000uwb), 9999999999999999.e+33DD)
      || CHECK (testu192 (618935436546517900000000000000000000000000000000000000uwb), 6189354365465179e+38DD)
      || CHECK (testu192 (618935436546517950000000000000000000000000000000000000uwb), 6189354365465180e+38DD)
      || CHECK (testu192 (618935436546517949999999999999999999999999999999999999uwb), 6189354365465179e+38DD)
      || CHECK (testu192 (618935436546517999999999999999999999999999999999999999uwb), 6189354365465180e+38DD)
      || CHECK (testu192 (618935436546517800000000000000000000000000000000000000uwb), 6189354365465178e+38DD)
      || CHECK (testu192 (618935436546517850000000000000000000000000000000000000uwb), 6189354365465178e+38DD)
      || CHECK (testu192 (618935436546517850000000000000000000000000000000000001uwb), 6189354365465179e+38DD)
      || CHECK (testu192 (99999999999999990000000000000000000000000000000000000000uwb), 9999999999999999.e+40DD)
      || CHECK (testu192 (6277101735386680000000000000000000000000000000000000000000uwb), 6277101735386680e+42DD)
      || CHECK (testu192 (6277101735386680499999999999999999999999999999999999999999uwb), 6277101735386680e+42DD)
      || CHECK (testu192 (6277101735386680500000000000000000000000000000000000000000uwb), 6277101735386680e+42DD)
      || CHECK (testu192 (6277101735386680500000000000000000000000000000000000000001uwb), 6277101735386681e+42DD)
      || CHECK (testu192 (6277101735386680500000000000000000000010000000000000000000uwb), 6277101735386681e+42DD)
      || CHECK (testu192 (6277101735386680763835789423207666416102355444464034512895uwb), 6277101735386681e+42DD))
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  if (CHECK (tests575 (0wb), 0.DD)
      || CHECK (tests575 (7wb), 7.DD)
      || CHECK (tests575 (-42wb), -42.DD)
      || CHECK (tests575 (-444444444wb), -444444444.DD)
      || CHECK (tests575 (9999999999999000wb), 9999999999999000.DD)
      || CHECK (tests575 (-9999999999999999wb), -9999999999999999.DD)
      || CHECK (tests575 (999999999999999900wb), 9999999999999999.e+2DD)
      || CHECK (tests575 (-9999999999999999000wb), -9999999999999999.e+3DD)
      || CHECK (tests575 (999999999999999900000wb), 9999999999999999.e+5DD)
      || CHECK (tests575 (-99999999999999990000000wb), -9999999999999999.e+7DD)
      || CHECK (tests575 (1234567890123456000000000wb), 1234567890123456.e+9DD)
      || CHECK (tests575 (3424231985445429000000000000000000000000wb), 3424231985445429e+24DD)
      || CHECK (tests575 (99999999999999990000000000000000000000000000000000000000wb), 9999999999999999.e+40DD)
      || CHECK (tests575 (-9999999999999999000000000000000000000000000000000000000000000000000000000000000wb), -9999999999999999.e+63DD)
      || CHECK (tests575 (-213855087769445900000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138550877694459e+86DD)
      || CHECK (tests575 (-213855087769445950000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138550877694460e+86DD)
      || CHECK (tests575 (-213855087769445949999999999999999999999999999999999999999999999999999999999999999999999999999999999999wb), -2138550877694459e+86DD)
      || CHECK (tests575 (-213855087769445999999999999999999999999999999999999999999999999999999999999999999999999999999999999999wb), -2138550877694460e+86DD)
      || CHECK (tests575 (-213855087769445800000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138550877694458e+86DD)
      || CHECK (tests575 (-213855087769445850000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138550877694458e+86DD)
      || CHECK (tests575 (-213855087769445850000000000000000000000000000000000000000000000000000000000000000000000000000000000001wb), -2138550877694459e+86DD)
      || CHECK (tests575 (61832600368276130000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), 6183260036827613e+157DD)
      || CHECK (tests575 (61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb), 6183260036827613e+157DD)
      || CHECK (tests575 (-61832600368276130000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -6183260036827613e+157DD)
      || CHECK (tests575 (-61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb), -6183260036827613e+157DD))
    __builtin_abort ();
  if (CHECK (testu575 (0uwb), 0.DD)
      || CHECK (testu575 (17uwb), 17.DD)
      || CHECK (testu575 (420uwb), 420.DD)
      || CHECK (testu575 (888888888uwb), 888888888.DD)
      || CHECK (testu575 (9999999999999000uwb), 9999999999999000.DD)
      || CHECK (testu575 (99999999999999990000000uwb), 9999999999999999.e+7DD)
      || CHECK (testu575 (9999999999999999000000000uwb), 9999999999999999.e+9DD)
      || CHECK (testu575 (99999999999999990000000000000uwb), 9999999999999999.e+13DD)
      || CHECK (testu575 (9999999999999999000000000000000uwb), 9999999999999999.e+15DD)
      || CHECK (testu575 (1234567890123456000000000000000000uwb), 1234567890123456.e+18DD)
      || CHECK (testu575 (34242319854454290000000000000000000000uwb), 3424231985445429e+22DD)
      || CHECK (testu575 (9999999999999999000000000000000000000000000000000uwb), 9999999999999999.e+33DD)
      || CHECK (testu575 (618935436546517900000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189354365465179e+104DD)
      || CHECK (testu575 (618935436546517950000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189354365465180e+104DD)
      || CHECK (testu575 (618935436546517949999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999uwb), 6189354365465179e+104DD)
      || CHECK (testu575 (618935436546517999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999uwb), 6189354365465180e+104DD)
      || CHECK (testu575 (618935436546517800000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189354365465178e+104DD)
      || CHECK (testu575 (618935436546517850000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189354365465178e+104DD)
      || CHECK (testu575 (618935436546517850000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001uwb), 6189354365465179e+104DD)
      || CHECK (testu575 (99999999999999990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 9999999999999999.e+139DD)
      || CHECK (testu575 (123665200736552200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 1236652007365522e+158DD)
      || CHECK (testu575 (123665200736552249999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999uwb), 1236652007365522e+158DD)
      || CHECK (testu575 (123665200736552250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 1236652007365522e+158DD)
      || CHECK (testu575 (123665200736552250000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001uwb), 1236652007365523e+158DD)
      || CHECK (testu575 (123665200736552250000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 1236652007365523e+158DD)
      || CHECK (testu575 (123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb), 1236652007365523e+158DD))
    __builtin_abort ();
#endif
}
