-- AA2010A.ADA

--                             Grant of Unlimited Rights
--
--     Under contracts F33600-87-D-0337, F33600-84-D-0280, MDA903-79-C-0687,
--     F08630-91-C-0015, and DCA100-97-D-0025, the U.S. Government obtained 
--     unlimited rights in the software and documentation contained herein.
--     Unlimited rights are defined in DFAR 252.227-7013(a)(19).  By making 
--     this public release, the Government intends to confer upon all 
--     recipients unlimited rights  equal to those held by the Government.  
--     These rights include rights to use, duplicate, release or disclose the 
--     released technical data and computer software in whole or in part, in 
--     any manner and for any purpose whatsoever, and to have or permit others 
--     to do so.
--
--                                    DISCLAIMER
--
--     ALL MATERIALS OR INFORMATION HEREIN RELEASED, MADE AVAILABLE OR
--     DISCLOSED ARE AS IS.  THE GOVERNMENT MAKES NO EXPRESS OR IMPLIED 
--     WARRANTY AS TO ANY MATTER WHATSOEVER, INCLUDING THE CONDITIONS OF THE
--     SOFTWARE, DOCUMENTATION OR OTHER INFORMATION RELEASED, MADE AVAILABLE 
--     OR DISCLOSED, OR THE OWNERSHIP, MERCHANTABILITY, OR FITNESS FOR A
--     PARTICULAR PURPOSE OF SAID MATERIAL.
--*
-- CHECK THAT SUBUNIT NAMES CAN BE IDENTICAL TO IDENTIFIERS DECLARED IN
-- STANDARD, NAMELY, BOOLEAN, INTEGER, FLOAT, CHARACTER, ASCII, 
-- NATURAL, POSITIVE, STRING, DURATION, CONSTRAINT_ERROR, 
-- NUMERIC_ERROR, PROGRAM_ERROR, STORAGE_ERROR, AND TASKING_ERROR.

-- R.WILLIAMS 9/18/86

PACKAGE AA2010A_TYPEDEF IS
     TYPE ENUM IS (E1, E2, E3);
END AA2010A_TYPEDEF;

WITH AA2010A_TYPEDEF; USE AA2010A_TYPEDEF;
PACKAGE AA2010A_PARENT IS

     PROCEDURE BOOLEAN;
     FUNCTION INTEGER RETURN ENUM;
     PACKAGE FLOAT IS END FLOAT;

     PROCEDURE CHARACTER;
     FUNCTION ASCII RETURN ENUM;

     TASK NATURAL IS
          ENTRY E;
     END NATURAL;

     PROCEDURE POSITIVE;
     FUNCTION STRING RETURN ENUM;
     PACKAGE DURATION IS END DURATION;

     PROCEDURE CONSTRAINT_ERROR;
     FUNCTION NUMERIC_ERROR RETURN ENUM;

     TASK PROGRAM_ERROR IS
          ENTRY E;
     END PROGRAM_ERROR;

     PROCEDURE STORAGE_ERROR;
     FUNCTION TASKING_ERROR RETURN ENUM;

END AA2010A_PARENT;

PACKAGE BODY AA2010A_PARENT IS

     PROCEDURE BOOLEAN IS SEPARATE;
     FUNCTION INTEGER RETURN ENUM IS SEPARATE;
     PACKAGE BODY FLOAT IS SEPARATE;

     PROCEDURE CHARACTER IS SEPARATE;
     FUNCTION ASCII RETURN ENUM IS SEPARATE;
     TASK BODY NATURAL IS SEPARATE;

     PROCEDURE POSITIVE IS SEPARATE;
     FUNCTION STRING RETURN ENUM IS SEPARATE;
     PACKAGE BODY DURATION IS SEPARATE;

     PROCEDURE CONSTRAINT_ERROR IS SEPARATE;
     FUNCTION NUMERIC_ERROR RETURN ENUM IS SEPARATE;
     TASK BODY PROGRAM_ERROR IS SEPARATE;

     PROCEDURE STORAGE_ERROR IS SEPARATE;
     FUNCTION TASKING_ERROR RETURN ENUM IS SEPARATE;

END AA2010A_PARENT;

SEPARATE (AA2010A_PARENT)
PROCEDURE BOOLEAN IS 
BEGIN
     NULL;
END;

SEPARATE (AA2010A_PARENT)
FUNCTION INTEGER RETURN ENUM IS 
BEGIN
     RETURN E1;
END;

SEPARATE (AA2010A_PARENT)
PACKAGE BODY FLOAT IS END;

SEPARATE (AA2010A_PARENT)
PROCEDURE CHARACTER IS 
BEGIN
     NULL;
END;

SEPARATE (AA2010A_PARENT)
FUNCTION ASCII RETURN ENUM IS 
BEGIN
     RETURN E1;
END;

SEPARATE (AA2010A_PARENT)
TASK BODY NATURAL IS 
BEGIN
     ACCEPT E;
END;

SEPARATE (AA2010A_PARENT)
PROCEDURE POSITIVE IS 
BEGIN
     NULL;
END;

SEPARATE (AA2010A_PARENT)
FUNCTION STRING RETURN ENUM IS 
BEGIN
     RETURN E1;
END;

SEPARATE (AA2010A_PARENT)
PACKAGE BODY DURATION IS END;

SEPARATE (AA2010A_PARENT)
PROCEDURE CONSTRAINT_ERROR IS 
BEGIN
     NULL;
END;

SEPARATE (AA2010A_PARENT)
FUNCTION NUMERIC_ERROR RETURN ENUM IS 
BEGIN
     RETURN E1;
END;

SEPARATE (AA2010A_PARENT)
TASK BODY PROGRAM_ERROR IS 
BEGIN
     ACCEPT E;     
END;

SEPARATE (AA2010A_PARENT)
PROCEDURE STORAGE_ERROR IS 
BEGIN
     NULL;
END;

SEPARATE (AA2010A_PARENT)
FUNCTION TASKING_ERROR RETURN ENUM IS 
BEGIN
     RETURN E1;
END;

WITH REPORT; USE REPORT;
WITH AA2010A_TYPEDEF; USE AA2010A_TYPEDEF;
WITH AA2010A_PARENT; USE AA2010A_PARENT; 
PROCEDURE AA2010A IS
     E : ENUM;
BEGIN
     TEST ( "AA2010A", "CHECK THAT SUBUNIT NAMES CAN BE IDENTICAL " &
                       "TO IDENTIFIERS DECLARED IN STANDARD, " &
                       "NAMELY, BOOLEAN, INTEGER, FLOAT, " &
                       "CHARACTER, ASCII, NATURAL, POSITIVE, " &
                       "STRING, DURATION, CONSTRAINT_ERROR, " &
                       "NUMERIC_ERROR, PROGRAM_ERROR, " &
                       "STORAGE_ERROR, AND TASKING_ERROR" );
     
     AA2010A_PARENT.BOOLEAN;
     E := AA2010A_PARENT.INTEGER;

     AA2010A_PARENT.CHARACTER;
     E := AA2010A_PARENT.ASCII;
     AA2010A_PARENT.NATURAL.E;

     AA2010A_PARENT.POSITIVE;
     E := AA2010A_PARENT.STRING;

     AA2010A_PARENT.CONSTRAINT_ERROR;
     E := AA2010A_PARENT.NUMERIC_ERROR;
     AA2010A_PARENT.PROGRAM_ERROR.E;

     AA2010A_PARENT.STORAGE_ERROR;
     E := AA2010A_PARENT.TASKING_ERROR;

     RESULT;
END AA2010A;
