/* do not edit automatically generated by mc from SFIO.  */
/* SFIO.mod provides a String interface to the opening routines of FIO.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _SFIO_C

#include "GSFIO.h"
#   include "GASCII.h"
#   include "GDynamicStrings.h"
#   include "GFIO.h"


/*
   Exists - returns TRUE if a file named, fname exists for reading.
*/

extern "C" bool SFIO_Exists (DynamicStrings_String fname);

/*
   OpenToRead - attempts to open a file, fname, for reading and
                it returns this file.
                The success of this operation can be checked by
                calling IsNoError.
*/

extern "C" FIO_File SFIO_OpenToRead (DynamicStrings_String fname);

/*
   OpenToWrite - attempts to open a file, fname, for write and
                 it returns this file.
                 The success of this operation can be checked by
                 calling IsNoError.
*/

extern "C" FIO_File SFIO_OpenToWrite (DynamicStrings_String fname);

/*
   OpenForRandom - attempts to open a file, fname, for random access
                   read or write and it returns this file.
                   The success of this operation can be checked by
                   calling IsNoError.
                   towrite, determines whether the file should be
                   opened for writing or reading.
                   if towrite is TRUE or whether the previous file should
                   be left alone, allowing this descriptor to seek
                   and modify an existing file.
*/

extern "C" FIO_File SFIO_OpenForRandom (DynamicStrings_String fname, bool towrite, bool newfile);

/*
   WriteS - writes a string, s, to, file. It returns the String, s.
*/

extern "C" DynamicStrings_String SFIO_WriteS (FIO_File file, DynamicStrings_String s);

/*
   ReadS - reads and returns a string from, file.
           It stops reading the string at the end of line or end of file.
           It consumes the newline at the end of line but does not place
           this into the returned string.
*/

extern "C" DynamicStrings_String SFIO_ReadS (FIO_File file);

/*
   GetFileName - return a new string containing the name of the file.
                 The string should be killed by the caller.
*/

extern "C" DynamicStrings_String SFIO_GetFileName (FIO_File file);


/*
   Exists - returns TRUE if a file named, fname exists for reading.
*/

extern "C" bool SFIO_Exists (DynamicStrings_String fname)
{
  return FIO_exists (DynamicStrings_string (fname), DynamicStrings_Length (fname));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OpenToRead - attempts to open a file, fname, for reading and
                it returns this file.
                The success of this operation can be checked by
                calling IsNoError.
*/

extern "C" FIO_File SFIO_OpenToRead (DynamicStrings_String fname)
{
  return FIO_openToRead (DynamicStrings_string (fname), DynamicStrings_Length (fname));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OpenToWrite - attempts to open a file, fname, for write and
                 it returns this file.
                 The success of this operation can be checked by
                 calling IsNoError.
*/

extern "C" FIO_File SFIO_OpenToWrite (DynamicStrings_String fname)
{
  return FIO_openToWrite (DynamicStrings_string (fname), DynamicStrings_Length (fname));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OpenForRandom - attempts to open a file, fname, for random access
                   read or write and it returns this file.
                   The success of this operation can be checked by
                   calling IsNoError.
                   towrite, determines whether the file should be
                   opened for writing or reading.
                   if towrite is TRUE or whether the previous file should
                   be left alone, allowing this descriptor to seek
                   and modify an existing file.
*/

extern "C" FIO_File SFIO_OpenForRandom (DynamicStrings_String fname, bool towrite, bool newfile)
{
  return FIO_openForRandom (DynamicStrings_string (fname), DynamicStrings_Length (fname), towrite, newfile);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WriteS - writes a string, s, to, file. It returns the String, s.
*/

extern "C" DynamicStrings_String SFIO_WriteS (FIO_File file, DynamicStrings_String s)
{
  unsigned int nBytes;

  if (s != NULL)
    {
      nBytes = FIO_WriteNBytes (file, DynamicStrings_Length (s), DynamicStrings_string (s));
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ReadS - reads and returns a string from, file.
           It stops reading the string at the end of line or end of file.
           It consumes the newline at the end of line but does not place
           this into the returned string.
*/

extern "C" DynamicStrings_String SFIO_ReadS (FIO_File file)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitString ((const char *) "", 0);
  while (((! (FIO_EOLN (file))) && (! (FIO_EOF (file)))) && (FIO_IsNoError (file)))
    {
      s = DynamicStrings_ConCatChar (s, FIO_ReadChar (file));
    }
  if (FIO_EOLN (file))
    {
      /* consume nl  */
      if ((FIO_ReadChar (file)) == ASCII_nul)
        {}  /* empty.  */
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFileName - return a new string containing the name of the file.
                 The string should be killed by the caller.
*/

extern "C" DynamicStrings_String SFIO_GetFileName (FIO_File file)
{
  return DynamicStrings_InitStringCharStar (FIO_getFileName (file));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_SFIO_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_SFIO_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
