# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/), and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

- [Changelog](#changelog)
	- [\[v5.1.3\] - 2025-03-09](#v513---2025-03-09)
		- [Fixed](#fixed)
	- [\[v5.1.2\] - 2025-02-23](#v512---2025-02-23)
		- [Added](#added)
		- [Changed](#changed)
		- [Fixed](#fixed-1)
	- [\[v5.1.1\] - 2024-12-01](#v511---2024-12-01)
		- [Added](#added-1)
		- [Changed](#changed-1)
		- [Fixed](#fixed-2)
	- [\[v5.1.0\] - 2024-10-07](#v510---2024-10-07)
		- [Added](#added-2)
		- [Changed](#changed-2)
		- [Removed](#removed)
		- [Fixed](#fixed-3)
	- [\[v5.0.4\] - 2024-04-28](#v504---2024-04-28)
		- [Changed](#changed-3)
		- [Fixed](#fixed-4)
	- [\[v5.0.3\] - 2024-01-06](#v503---2024-01-06)
		- [Changed](#changed-4)
		- [Fixed](#fixed-5)
	- [\[v5.0.2\] - 2023-11-12](#v502---2023-11-12)
		- [Changed](#changed-5)
		- [Fixed](#fixed-6)
	- [\[v5.0.1\] - 2023-10-21](#v501---2023-10-21)
		- [Changed](#changed-6)
		- [Fixed](#fixed-7)
	- [\[v5.0.0\] - 2023-10-15](#v500---2023-10-15)
		- [Added](#added-3)
		- [Changed](#changed-7)
		- [Removed](#removed-1)
		- [Fixed](#fixed-8)
	- [\[v4.5.3\] - 2023-04-02](#v453---2023-04-02)
		- [Added](#added-4)
		- [Changed](#changed-8)
		- [Fixed](#fixed-9)
	- [\[v4.5.2\] - 2022-11-12](#v452---2022-11-12)
		- [Changed](#changed-9)
		- [Fixed](#fixed-10)
	- [\[v4.5.1\] - 2022-10-23](#v451---2022-10-23)
		- [Changed](#changed-10)
		- [Fixed](#fixed-11)
	- [\[v4.5.0\] - 2022-10-09](#v450---2022-10-09)
		- [Added](#added-5)
		- [Changed](#changed-11)
		- [Removed](#removed-2)
		- [Fixed](#fixed-12)
	- [\[v4.4.0\] - 2022-08-28](#v440---2022-08-28)
		- [Added](#added-6)
		- [Changed](#changed-12)
		- [Fixed](#fixed-13)
	- [\[v4.3.1\] - 2022-05-08](#v431---2022-05-08)
		- [Fixed](#fixed-14)
	- [\[v4.3.0\] - 2022-02-18](#v430---2022-02-18)
		- [Added](#added-7)
		- [Changed](#changed-13)
		- [Fixed](#fixed-15)
	- [\[v4.2.0\] - 2021-03-28](#v420---2021-03-28)
		- [Added](#added-8)
		- [Changed](#changed-14)
		- [Removed](#removed-3)
		- [Fixed](#fixed-16)
	- [\[v4.1.0\] - 2021-01-10](#v410---2021-01-10)
		- [Added](#added-9)
		- [Changed](#changed-15)
		- [Fixed](#fixed-17)
	- [\[v4.0.1\] - 2020-06-13](#v401---2020-06-13)
		- [Changed](#changed-16)
		- [Fixed](#fixed-18)
	- [\[v4.0.0\] - 2020-05-17](#v400---2020-05-17)
		- [Added](#added-10)
		- [Changed](#changed-17)
		- [Removed](#removed-4)
		- [Fixed](#fixed-19)
	- [\[v3.2.4\] - 2019-01-13](#v324---2019-01-13)
		- [Changed](#changed-18)
		- [Deprecated](#deprecated)
		- [Fixed](#fixed-20)
	- [\[v3.2.3\] - 2018-07-01](#v323---2018-07-01)
		- [Added](#added-11)
		- [Changed](#changed-19)
		- [Removed](#removed-5)
	- [\[v3.2.2\] - 2018-05-03](#v322---2018-05-03)
		- [Changed](#changed-20)
		- [Fixed](#fixed-21)
	- [\[v3.2.1\] - 2018-03-24](#v321---2018-03-24)
		- [Changed](#changed-21)
		- [Removed](#removed-6)
		- [Fixed](#fixed-22)
	- [\[v3.2.0\] - 2018-01-31](#v320---2018-01-31)
		- [Added](#added-12)
		- [Changed](#changed-22)
		- [Removed](#removed-7)
		- [Fixed](#fixed-23)
	- [\[v3.1.3\] - 2016-10-25](#v313---2016-10-25)
		- [Added](#added-13)
		- [Changed](#changed-23)
		- [Fixed](#fixed-24)
	- [\[v3.1.2\] - 2016-10-23](#v312---2016-10-23)
		- [Added](#added-14)
		- [Changed](#changed-24)
		- [Fixed](#fixed-25)
	- [\[v3.1.1\] - 2016-10-16](#v311---2016-10-16)
		- [Fixed](#fixed-26)
	- [\[v3.1.0\] - 2016-09-24](#v310---2016-09-24)
		- [Added](#added-15)
		- [Changed](#changed-25)
		- [Removed](#removed-8)
		- [Fixed](#fixed-27)
	- [\[v3.0.1\] - 2016-08-23](#v301---2016-08-23)
		- [Changed](#changed-26)
		- [Fixed](#fixed-28)
	- [\[v3.0.0\] - 2016-06-15](#v300---2016-06-15)
		- [Added](#added-16)
		- [Changed](#changed-27)
		- [Removed](#removed-9)
	- [\[v2.2.2\] - 2015-12-02](#v222---2015-12-02)
		- [Changed](#changed-28)
		- [Fixed](#fixed-29)
	- [\[v2.2.1\] - 2015-11-27](#v221---2015-11-27)
		- [Changed](#changed-29)
		- [Fixed](#fixed-30)
	- [\[v2.2.0\] - 2015-11-21](#v220---2015-11-21)
		- [Added](#added-17)
		- [Changed](#changed-30)
		- [Fixed](#fixed-31)
	- [\[v2.1.1\] - 2015-08-26](#v211---2015-08-26)
		- [Added](#added-18)
		- [Changed](#changed-31)
		- [Fixed](#fixed-32)
	- [\[v2.1.0\] - 2015-08-08](#v210---2015-08-08)
		- [Added](#added-19)
		- [Changed](#changed-32)
		- [Fixed](#fixed-33)
	- [\[v2.0.3\] - 2015-03-15](#v203---2015-03-15)
		- [Added](#added-20)
		- [Changed](#changed-33)
		- [Removed](#removed-10)
		- [Fixed](#fixed-34)
	- [\[v2.0.2\] - 2015-02-08](#v202---2015-02-08)
		- [Added](#added-21)
		- [Changed](#changed-34)
		- [Fixed](#fixed-35)
	- [\[v2.0.1\] - 2014-11-23](#v201---2014-11-23)
		- [Added](#added-22)
		- [Changed](#changed-35)
		- [Fixed](#fixed-36)
	- [\[v2.0.0\] - 2014-11-16](#v200---2014-11-16)
		- [Added](#added-23)
		- [Changed](#changed-36)
		- [Fixed](#fixed-37)
	- [\[v1.2.2\] - 2014-11-05](#v122---2014-11-05)
		- [Added](#added-24)
		- [Changed](#changed-37)
		- [Fixed](#fixed-38)
	- [\[v1.2.1\] - 2014-10-24](#v121---2014-10-24)
		- [Added](#added-25)
		- [Changed](#changed-38)
		- [Fixed](#fixed-39)
	- [\[v1.2.0\] - 2014-10-12](#v120---2014-10-12)
		- [Added](#added-26)
		- [Changed](#changed-39)
		- [Fixed](#fixed-40)
	- [\[v1.1.0\] - 2014-09-28](#v110---2014-09-28)
		- [Added](#added-27)
		- [Changed](#changed-40)
	- [\[v1.0.0\] - 2014-09-21](#v100---2014-09-21)

---

## [v5.1.3] - 2025-03-09

### Fixed

- Fix crash on ARM64/sdm670 platform (#371)
- Fix crash on Wayland for multi-GPU systems (##370)

---

## [v5.1.2] - 2025-02-23

### Added

- Re-add `APPIMAGE` option in CMake

### Changed

- Allow to force use fallback CPU multipliers with `CPUX_FORCE_CPU_FALLBACK`
- Update databases (AMD Turin Dense)

### Fixed

- Fix issue with CMake `STREQUAL` statements (#362)
- Fix data load path for AppImage and Flatpak (#364)
- Fix daemon startup for Flatpak on AArch64
- Fix GPU User Mode Driver (UMD) for NVIDIA dGPU (#367)

---

## [v5.1.1] - 2024-12-01

### Added

- Add support for CMake 3.31, enabling CMP0177 to new behavior

### Changed

- Align properties for 2 lines labels in GTK GUI (#356)
- Move the 'Start daemon' button to an InfoBar in GTK GUI
- Update databases (Intel Arrow-Lake-S, AMD Turin)

### Fixed

- Avoid to display GPU interface information if unavailable (#356)
- Load files from installation directory in GTK GUI (#360)
- Fix exception handling when files cannot be loaded in GTK GUI (#360)
- Fix issue with FreeBSD port about CMAKE_INSTALL_FULL_LIBEXECDIR (#360)
- Install PolKit policy under the correct path (#360)

---

## [v5.1.0] - 2024-10-07

### Added

- Add support for ARM CPUs (libcpuid v0.7.0 is required)
- Add support for Raspberry Pi SBCs
- Display EFI PK certificate information (#336)

### Changed

- Update databases (AMD Hawk Point, Granite Ridge and Strix Point)
- Hide some tabs if there is no data to display, aligned for all modes (dump, NCurses, GTK)
- Build Bandwidth only on x86 CPUs
- Truncate labels with too many characters in GTK GUI
- Patch dmidecode to version 3.6.b70f6ee
- Improve ncursesw detection on FreeBSD

### Removed

- Remove support for libcpuid before v0.7.0

### Fixed

- Handle SIGABRT in Vulkan code (#330)
- Fix broken Graphics tab with long model name (#334)
- Fix wrong PCIe speed for AMDGPU devices (#335)
- Fix deprecated function in NCuses TUI
- Fix empty Instruction and Model labels in NCurses TUI
- Fix build when libcpuid is missing
- Fix Name and Kernel labels in System tab on FreeBSD
- Fix exception when parsing invalid optional argument
- Fix missing OpenCL info for some drivers

---

## [v5.0.4] - 2024-04-28

### Changed

- Update databases (more CPU packages, Intel Meteor Lake-H, Intel Emerald Rapids-SP)
- Patch dmidecode to version 3.6

### Fixed

- Do not display unavailable DMI fields in Memory tab (#322)

---

## [v5.0.3] - 2024-01-06

### Changed

- Improvements for Flatpak runtime
- Do not print OpenGL version for unknown user mode driver
- Reword labels about 'theme' in Settings (#314)
- Set tooltip for all labels with full text in GTK GUI (#316)
- Update databases (AMD Storm Peak)

### Fixed

- Fix active graphic card in GTK GUI (#313)
- Fix missing AMD GPU power average for some cards (#315)

---

## [v5.0.2] - 2023-11-12

### Changed

- Print vendor ID and device ID in Graphics tab for "Device ID" label (#311)
- Update various tags in appdata.xml file
- Rename AppID from com.github.thetumultuousunicornofdarkness.cpu-x to io.github.thetumultuousunicornofdarkness.cpu-x

### Fixed

- Fix daemon socket path when prefix is `/usr/local` (#310)
- Fix launchable field in appdata.xml file
- Fix icon name field in PolKit policy file

---

## [v5.0.1] - 2023-10-21

### Changed

- Update databases (AMD Chagall, more Intel CPU packages)
- Do not try to read memory frequency for iGPU with AMDGPU driver

### Fixed

- Fix build on CentOS/RHEL 7 (#305)
- Fix build when libcpuid header is not present (#306)
- Fix abort with stoull() when retrieving GPU monitoring information (#304)
- Fix wrong CPU temperature in fallback mode (#308)
- Fix unknown user mode driver for NVIDIA graphic cards (#307)

---

## [v5.0.0] - 2023-10-15

### Added

- Support for C++17, involving a major rewrite of project from C to C++
- Add more debug data, including a debug mode for the daemon
- Add an option to choose temperature unit among Celsius, Fahrenheit, Kelvin and Rankine
- Add initial Flatpak support with `FLATPAK` option in CMake

### Changed

- Update databases (AMD Genoa, Intel Sapphire Rapids-WS, AMD Phoenix, Intel Alder Lake-U, Intel Apollo Lake)
- Update Intel vendor logo in GTK GUI
- Rename AppData, PolKit policy, Desktop and GSchema files with `com.github.thetumultuousunicornofdarkness` prefix
- Redesign Memory tab
- Rename 'Distribution' label to 'Name' in System tab

### Removed

- Remove support for CMake < 3.12
- Remove 'Compiler' label from System tab
- Remove the need to have gawk/mawk/nawk at the same time during build for test execution
- Remove `APPIMAGE` option in CMake

### Fixed

- Fix CPU temperature in fallback mode on FreeBSD
- Fix build with NCURSES and Intl CMake modules on FreeBSD
- Fix threads affinity for benchmarks
- Fix elapsed time for benchmarks

---

## [v4.5.3] - 2023-04-02

### Added

- Add BAR size for Intel discrete GPU
- Add total VRAM size via Vulkan API for checking ResizableBAR

### Changed

- Update databases (Intel Alder Lake, Intel Raptor Lake-S/P/U)
- Disable OpenCL support by default
- Update brand logos for AMD and Intel
- Make yellow brighter for dark themes in GTK GUI
- Patch dmidecode to version 3.5.484f893
- Update 'Technology' label in CPU tab for new node name (like Intel 7) and change prefix for technology nodes >= 100nm to µm

### Fixed

- Print correct memory speed
- Fix empty 'Interface' label in Graphics tab for NVIDIA cards (get DRM path for all graphic cards)
- Fix race condition with cache test selection

---

## [v4.5.2] - 2022-11-12

### Changed

- Support for procps-ng 4.0.1rc3
- Update databases (Intel Tremont, Intel Ice Lake Xeon-D, AMD Mendocino, AMD Zen 2 Desktop Kit, AMD Athlon 64 Sherman)

### Fixed

- Do not print Vulkan Ray tracing status when indeterminate

---

## [v4.5.1] - 2022-10-23

### Changed

- Update databases (Intel Raptor Lake)
- Display memory DIMMs with "Not Specified" manufacturer
- Improve memory DIMMs capacity format

### Fixed

- Fix segmentation fault in Vulkan code (specific to NVIDIA proprietary driver)
- Fix "invalid write" when detecting OpenCL compute units

---

## [v4.5.0] - 2022-10-09

### Added

- Add support for hybrid CPUs (libcpuid v0.6.0 is required)
- Add support for 'tab' key in NCurses TUI
- Add scrolling in Memory tab in NCurses TUI

### Changed

- Update databases (Intel Alder Lake, AMD Zen 4 (Raphael))
- Improve Vulkan Ray Tracing detection and device matching
- Patch dmidecode to version 3.4.f50b925

### Removed

- Remove CPU voltage reading from in0_input probe
- Remove support for libcpuid before v0.6.0

### Fixed

- Fix segmentation fault during arguments parsing when some features are disabled
- Fix random numbers when CPU technology is not present in database (AMD)
- Fix segmentation fault in Vulkan code (specific to Intel Anv)
- Workaround in OpenCL code in case of aborted signal (specific to AMD ROCm)

---

## [v4.4.0] - 2022-08-28

### Added

- Support for libproc-2 (procps-ng is still supported)
- Add Graphics API Version and Vulkan Ray Tracing in Graphics tab (Vulkan libraries are optionally required)
- Add VBIOS Version in Graphics tab

### Changed

- Display "Configured Memory Speed" instead of "Speed" in Memory tab
- Patch dmidecode to version 3.4.a1a2258
- Update CPU databases (AMD Rembrandt)

### Fixed

- Fix build when libstatgrab support is forced
- Fix flickering in Graphics tab during refresh

---

## [v4.3.1] - 2022-05-08

### Fixed

- Fix CPU usage in System tab when theme is Auto
- Fix a crash when libpci is upgraded and CPU-X is not rebuild against the new shared library

---

## [v4.3.0] - 2022-02-18

### Added

- Add Compute Unit in Graphics Tab (require OpenCL)
- Add Resizable BAR in Graphics tab 

### Changed

- Update databases
- Rename from "Ext. Family/Model" to "Disp. Family/Model"
- Display a warning for unsupported CPUs
- Patch dmidecode to version 3.3.024b0fb4

### Fixed

- Fix build with musl libc
- Limit number of characters for labels in Graphics tab (GTK GUI)
- Allow to translate settings (GTK GUI)

---

## [v4.2.0] - 2021-03-28

### Added

- Add new option `--cpuid-decimal` to display CPUID values in decimal
- Add User Mode Driver (UMD) in Graphics Tab (require GLFW)
- Add GPU DeviceID:RevisonID in Graphics tab
- Add PCIe link speed/width in Graphics tab

### Changed

- Reduce the GPU clock precision in Graphics tab
- Reserve 'HT' keyword for Intel CPUs only, and use 'SMT' for other vendors instead
- Update CPU databases
- Support more GPU in Graphics tab
- Use unit prefixes in System tab
- Add a dropdown list in Graphics tab to choose graphic card to monitor

### Removed

- Remove support for libcpuid before v0.5.0

### Fixed

- Apply dmidecode upstream patch to fix warnings
- Fix for `--issue-fmt`
- Fix overflow caused by some translations
- Fix socket path on FreeBSD

---

## [v4.1.0] - 2021-01-10

### Added

- Add `CPUX_ARGS` environment variable to set default command line
- Add alternative key mapping for NCurses mode (option `--keymap`)
- Add debug mode (option `--debug`)
- Add screen reader accessibility on GUI
- Add Core Voltage, Power Avg and Memory Used in Graphics tab (AMDGPU only)

### Changed

- Prefix all hexadecimal values with `0x`
- Reword nonsensical messages
- Update databases
- Request `Tdie` temperature for `k10temp` if available
- Change bars color in System tab in GTK GUI when Dark theme is used
- Patch dmidecode to version 3.3.3c111e4
- Use binary prefixes for System tab

### Fixed

- Fix build on FreeBSD when GTK is enabled
- Fix build on musl libc
- Fix list of influenceable environment variables in help
- Fix override of refresh value when GTK is enabled
- Fix screen flickering in NCurses TUI
- Ignore batteries voltage when searching CPU voltage
- Fix build when gettext support is disabled
- Allow to run CPU-X daemon from AppImage

---

## [v4.0.1] - 2020-06-13

### Changed

- Optimize images
- Prioritize rootless GPU load percentage retrievement for AMDGPU GPU

### Fixed

- Fix double MHz and % symbols on Graphics page with NVIDIA GPU
- Fix reopening of settings window in GTK GUI
- Fix `optirun: command not found` error with NVIDIA GPU
- Mount debugfs if not mounted before reading GPU load percentage for AMDGPU GPU

---

## [v4.0.0] - 2020-05-17

### Added

- Add a daemon to handle privileged access
- Add basic completions for Bash/Fish/Zsh
- Add settings window in GUI
- Add "Driver" label in Graphics tab
- Retrieve CPU temperature on FreeBSD
- Add support for zenpower module
- Add continuous build of AppImage

### Changed

- Patch dmidecode to version 3.2.5b3c8e9
- Move translations from Transifex to Weblate
- Uniform all units (byte and octet)
- Rewrite all CLI options
- Write output to `/tmp/cpu-x.log` and `/tmp/cpu-x-daemon.log` files when `--issue-fmt` is used
- Update databases
- Replace `nvidia-settings` command calls by `nvidia-smi`
- Support for L1 Instruction Cache information 

### Removed

- Remove portable binary
- Remove libcurl dependency
- Remove libjson-c dependency
- Remove all privileged access in `cpu-x` binary (moved to `cpu-x-daemon`)
- Remove "CPU-X (Root)" desktop launcher

### Fixed

- Fix some awk regex
- Fix `load_module()` function
- Fix options parsing
- Fix build on FreeBSD
- Various C fixes (unsafe functions and warnings)
- Fix Bumblebee support for NVIDIA/Nouveau
- Fix with VFIO GPU driver
- Fix GUI switches appearance in Bench tab
- Fix issues with AppImage
- Various fixes in NCurses TUI

---

## [v3.2.4] - 2019-01-13

### Changed

- Build portable binary without PIE
- Improve AppImage experience
- Use GitHub API to check new version (libjson-c)

### Deprecated

- Deprecate the portable version

### Fixed

- Wrong GPU clocks with AMDGPU driver
- Empty memory bank label
- Build without gettext

---

## [v3.2.3] - 2018-07-01

### Added

- `TEXTDOMAINDIR`/`TERMINFO` support
- Add AppData metainfo file
- NVIDIA Bumblebee support

### Changed

- Patch Dmidecode to v3.1.20180620

### Removed

- Support for CMake < 3.0

---

## [v3.2.2] - 2018-05-03

### Changed

- Update CPU database

### Fixed

- Segfault when retrieving AMD GPU temperature

---

## [v3.2.1] - 2018-03-24

### Changed

- Switch Cache and Swap colors in System tab

### Removed

- Drop 32-bit portable version for future releases

### Fixed

- Swap bar in NCurses TUI
- Bug in Bandwidth related to AVX instructions

---

## [v3.2.0] - 2018-01-31

### Added

- Add ability to read CPUID raw file (CPUX_CPUID_RAW environment variable)
- Add `--issue-fmt` argument
- Allow to enforce BCLK (CPUX_BCLK environment variable)
- New GTK theme for Dark themes
- Retrive CPU frequency in fallback mode
- Add GPU usage and GPU clocks in Graphics tab
- Add Polish translation (thanks to eloaders)
- Add Russian translation (thanks to TotalCaesar659)
- Add Czech translation (thanks to pavelb)
- Add Chinese translation (thanks to 高垚鑫)

### Changed

- Update CPU database
- Display influenceable environment variables in help
- Display CPU family/model in hex only
- Add a second line for Instructions label
- Improve CPU temperature and voltage retrieval in fallback mode
- Improve GPU temperature retrieval
- Rework GPU detection and improve multi-GPU support
- Patch Dmidecode to v3.1.20180131
- Patch Bandwidth to v1.5.1

### Removed

- Support for libcpuid < 0.4.0

### Fixed

- SSE3 feature detection
- Cache labels format
- `--nocolor` option
- Set window icon in GTK GUI
- cpu-x_polkit command on Wayland (used by cpu-x-root.desktop)
- Buffer overflow in some cases when Dmidecode is called

---

## [v3.1.3] - 2016-10-25

### Added

- Add Russian translation to shortcuts (thanks to TotalCaesar659)

### Changed

- Add more AMD Kaveri CPUs in database
- Print CPUID raw dumps when using `--dump --verbose`

### Fixed

- Segfault in `call_libcpuid_static()`
- GTK GUI theme

---

## [v3.1.2] - 2016-10-23

### Added

- Allow to set Bclk through CPUX_BCLK environment variable

### Changed

- Avoid to refresh Bclk and minimum/maximum CPU multipliers
- Rework CPU multipliers calculation
- Add AMD Tyler CPUs in database
- Reorganize databases

### Fixed

- Segfault caused by `free_multi()`
- Socket detection in fallback mode
- Kernel module load in fallback mode

---

## [v3.1.1] - 2016-10-16

### Fixed

- Bandwidth build on system without stropts.h
- Segfault in `cpu_multipliers_fallback()`
- Asking for update when already up-to-date in portable version
- Dynamic allocation checking
- Memory leaks

---

## [v3.1.0] - 2016-09-24

### Added

- Libcurl support
- Libarchive support in portable version
- Add support for L4 cache in Caches tab
- Add `--tab` option

### Changed

- Patch Dmidecode to 3.0.20160907
- Rebase Bandwidth on v1.3.1
- Decrease Dmidecode verbosity with `--verbose`
- Merge Descriptor label in Size label in Caches tab
- Hide absent cache levels in Caches tab in GTK GUI
- Hide empty pages in GTK GUI
- Refactor Memory tab
- Various minor core enhancements

### Removed

- Support for libcpuid < 0.3.0
- Support for GTK 3.8 & 3.10

### Fixed

- Broken redirection with `--dump`
- Memory leaks
- Bandwidth build with -DWITH_LIBCPUID=0
- Set speed to 0 for unavailable Bandwidth tests

---

## [v3.0.1] - 2016-08-23

### Changed

- Add more CPU and sockets in database
- Decrease verbosity in Dmidecode and Bandwidth
- Improve fallback mode

### Fixed

- Refresh in fallback mode
- Detection of GPU temperature with NVIDIA proprietary driver
- Check for a new version when network is unreachable
- Various minor fixes

---

## [v3.0.0] - 2016-06-15

### Added

- Report total CPU usage
- Add a signal handler to provide backtrace on crash
- Add `--nocolor` option
- Add `--cachetest` option
- Add `--bandwidth` option
- Add `--core` option
- Add a Bench tab

### Changed

- More CMake improvements, allow to build with CMake 2.8
- Full core rewrite
- Improve options parsing
- Rewrite update module for portable version + add `--update` option
- Rewrite NCurses UI + add color support + add help
- CPU-X logo redesign
- Patch dmidecode with latest source code (commit cff11af)
- Rebase bandwidth on v1.1
- Recognize more CPUs for the "Technology" label in CPU tab
- Print some values > 9 in hexadecimal in CPU tab
- More fallback support
- More strings in `--verbose` mode
- A lot of GTK UI tweaks
- Run bandwith in a separate thread to avoid UI slowdown

### Removed

- Drop support for Darwin/Mac OS X
- Report CPU BogoMIPS value

---

## [v2.2.2] - 2015-12-02

### Changed

- Add technology report for some Clarksfield & Richland CPUs

### Fixed

- Avoid to free dynamic labels in Caches tab
- Free memory when possible in `pcidev()` function
- Fix a buffer overflow on HT detection, causing bug in bandwidth

---

## [v2.2.1] - 2015-11-27

### Changed

- Add debugs symbols in bandwidth source code when using CMAKE_BUILD_TYPE=Debug

### Fixed

- Segfault on NULL pointer in `bandwidth()`
- Buffer overflow when setting label name in Caches tab

---

## [v2.2.0] - 2015-11-21

### Added

- Add support for libcpuid 0.2.2
- Add new tab Caches
- Add labels Technology, Voltage and Temp in CPU tab
- Add lebel Temperature in Graphics tab

### Changed

- Some changes in options parsing
- Update to dmidecode 3.0
- In NCurses TUI, add tab names
- Merge Architecture label in Instructions label in CPU tab
- Merge GPU driver with GPU vendor in Graphics tab
- Update GUI for GTK >= 3.8 and < 3.14

### Fixed

- Typo
- L3 cache value
- Some problems with `libdmi_fallback()`
- .desktop files
- Build with Clang
- Stop update if curl is missing

---

## [v2.1.1] - 2015-08-26

### Added

- Add translations support in portable version
- Add HyperThreading detection
- Option `--version` informs if a new version is available
- Add an auto-update module for portable version
- Add pt_BR translation (thanks to ShyPixie)

### Changed

- Some text changes in `--verbose` mode
- Improve translations support (rewrite target updatepo, add target newpo...)

### Fixed

- Segfault with `strdup()` on NULL pointer
- Avoid multipliers "(0 ## 0)" in CPU tab and "-nan" values in System tab
- Fixes garbages after freeing
- Some problems with build
- Do changes to enable compilation with libpci.a in portable version

---

## [v2.1.0] - 2015-08-08

### Added

- Add libsystem
- Add a button to change GTK GUI color
- Add new chipset section in Motherboard tab
- Add new tab Graphics
- GTK 3.14 support / partial GTK 3.16 support

### Changed

- Improve drawing bars in System tab in GTK GUI
- Use dynamic arrays instead of static arrays
- Use GResource instead of GdkPixbuf in GTK embedded GUI

### Fixed

- Build
- Options
- Deprecated functions in GTK GUI code

---

## [v2.0.3] - 2015-03-15

### Added

- Add verbose mode (for CPU-X, previously Dmidecode only)
- Colorized messages
- Add a "Run as root" button in GTK GUI
- Add `make uninstall` target to allow to properly uninstall CPU-X
- Add `make genpot` target to generate a pot file
- Add `make updatepo` target to update a po file from a newer pot file

### Changed

- Better support for non-Linux OS
- Improve displaying of memory usage in System tab

### Removed

- Remove RPATH

### Fixed

- Stop spam errors (in Dmidecode)
- Options when built without GTK
- Incomplete possibility for translation
- Output messages (verbose and error)

---

## [v2.0.2] - 2015-02-08

### Added

- Add argument `--dmidecode` to run (internal) Dmidecode alone

### Changed

- Rebase dmidecode code on 2.12
- Improve options parsing
- Less (useless) function recalls on refresh loop
- Display dashes for empty banks in RAM tab

### Fixed

- Empty RAM tab on certain machines

---

## [v2.0.1] - 2014-11-23

### Added

- Add possibility to resize terminal with NCurses TUI

### Changed

- Better CPU multiplier calculation
- Hide non-existent banks in tab RAM
- Better compiler detection
- Improve option `--help`
- Better translation support

### Fixed

- NCurses TUI: correct refresh (when left key/button 3 on mouse are spammed)
- NCurses TUI: segfault when spamming right key
- GTK GUI/NCurses TUI: use timeout instead of new thread to refresh
- Segfault when file `/etc/os-release` could not be open
- Add more static libraries in portable binary

---

## [v2.0.0] - 2014-11-16

### Added

- Add argument `--dump` (no start GUI)
- Add fallback mode for Libdmi (but it not replaces Libdmi)
- Add new tab System
- Add new tab RAM
- Add support for translations (only French available)
- Add CPU-X launchers (depends of GTK); cpu-x.desktop and cpu-x-root.desktop
- Add possibility to run CPU-X as root with pkexec
- Add more CPU vendor logos

### Changed

- Big changes in core
- Full rewrite GTK GUI
- Minor changes in NCurses TUI

### Fixed

- Segfault when compiling with target Release
- Memory leak (with function get_path)

---

## [v1.2.2] - 2014-11-05

### Added

- Add argument `--verbose` (set Dmidecode verbose)

### Changed

- Print nothing on impossible values (Caches section)

### Fixed

- Stop distort GTK GUI when label length is large
- Stop spam errors (about CPU frequencies)
- Typos (BogoMIPS, CPU Vendor, label Manufacturer)

---

## [v1.2.1] - 2014-10-24

### Added

- Add arguments support (`--no-gui`, `--version`, `--help`)
- Add support for custom refresh time (`--refresh`)

### Changed

- Rewrite error messages
- Restructuration of files and functions in files

### Fixed

- Segfault when compiling without GTK & embeded
- Unwanted characters in NCurses
- Compilation with CMake

---

## [v1.2.0] - 2014-10-12

### Added

- Add NCurses mode

### Changed

- Add possibility to disable GTK/NCurses/Libcpuid/Libdmi before compiling

### Fixed

- CPU multipliers calculation
- Relative path of file on error
- Segfault on unknown multiplier
- Unwanted characters

---

## [v1.1.0] - 2014-09-28

### Added

- Add possibility to change install prefix

### Changed

- Change build system from Makefile to CMake
- Remove calls to external command `dmidecode`, use provided library instead of
- Remove calls to external command `lscpu`

---

## [v1.0.0] - 2014-09-21

- Initial release
