use strict;
use warnings;

use RT::Test tests => undef;
plan skip_all => "Requires perl >= 5.14.0 to generate the warnings"
    if $] lt '5.014';

my $mail = <<'EOF';
From: root@localhost
To: rt@localhost
Subject: Testing
Content-Type: text/plain; charset="utf-32LE"
Content-Transfer-Encoding: base64

EOF
$mail .= (("F" x 76)."\r\n") x 100;

# We do this via callback on the logger because it is otherwise hard to
# know what got skipped by our $SIG{__WARN__}
my @warnings;

# Stop warnings from going to STDERR; even when passing, we expect this
# to generate warnings.
ok $RT::Logger->remove( 'rttest' );

$RT::Logger->add_callback(
    sub {
        my (%args) = @_;
        push @warnings, $args{message} if $args{level} eq "warning";
        return $args{message};
    }
);

my ($status, $id) = RT::Test->send_via_mailgate(
    $mail,
    queue => "general"
);

ok @warnings < 20, "There are up to a small number or warnings; got @{[@warnings+0]}";

# Clear our the warnings to make Test::NoWarnings happy.  We know we
# generated some.
Test::NoWarnings->clear_warnings;

done_testing;


