/**********************************************************************
  Copyright(c) 2011-2016 Intel Corporation All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/
#include <stdint.h>
#include <igzip_lib.h>

#if (IGZIP_HIST_SIZE <= 8192)

const uint8_t gzip_hdr[] = {
	0x1f, 0x8b, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff
};

const uint32_t gzip_hdr_bytes = 10;
const uint32_t gzip_trl_bytes = 8;

const uint8_t zlib_hdr[] = { 0x78, 0x01 };

const uint32_t zlib_hdr_bytes = 2;
const uint32_t zlib_trl_bytes = 4;

struct isal_hufftables hufftables_default = {

	.deflate_hdr = {
			0xed, 0xf9, 0x09, 0x60, 0x54, 0xd5, 0xf9, 0x37,
			0x00, 0x9f, 0x90, 0x04, 0xc8, 0x40, 0x00, 0x77,
			0xdb, 0x5a, 0x38, 0x22, 0x4a, 0xd0, 0xc9, 0x98,
			0x15, 0x02, 0x20, 0x24, 0x09, 0x5b, 0x10, 0x20,
			0x12, 0x10, 0x77, 0x39, 0x33, 0xf7, 0xcc, 0xcc,
			0x25, 0x77, 0xee, 0x1d, 0xef, 0xbd, 0x37, 0xc3,
			0x50, 0x55, 0x5a, 0x6d, 0xb5, 0xb5, 0xad, 0x76,
			0xdf, 0x5b, 0xdb, 0x5a, 0x6b, 0x77, 0xdb, 0xda,
			0xbd, 0x56, 0x84, 0xb6, 0xda, 0x55, 0xbb, 0xef,
			0x2d, 0x56, 0x5b, 0xed, 0x2a, 0x56, 0xdb, 0x62,
			0x8b, 0xe4, 0xfb, 0x7e, 0xcf, 0x39, 0x77, 0xe6,
			0x24, 0x09, 0xae, 0xfd, 0xbf, 0xef, 0xff, 0xfd,
			0xbe, 0x22, 0x92, 0xdc, 0x7b, 0xcf, 0x79, 0xce,
			0xb3, 0x9f, 0xdf, 0xf3, 0x3c},

	.deflate_hdr_count = 109,
	.deflate_hdr_extra_bits = 0,

	.dist_table = {
		       0x00000fe9, 0x00003fea,
#ifdef LONGER_HUFFTABLE
		       0x00002fe9, 0x00007fea, 0x00001fea, 0x00005fea,
		       0x000007e9, 0x000027e9, 0x000017ea, 0x000037ea,
		       0x000057ea, 0x000077ea, 0x000001e8, 0x000009e8,
		       0x000011e8, 0x000019e8, 0x000005e9, 0x00000de9,
		       0x000015e9, 0x00001de9, 0x000025e9, 0x00002de9,
		       0x000035e9, 0x00003de9, 0x000003e9, 0x00000be9,
		       0x000013e9, 0x00001be9, 0x000023e9, 0x00002be9,
		       0x000033e9, 0x00003be9, 0x00000169, 0x00000569,
		       0x00000969, 0x00000d69, 0x00001169, 0x00001569,
		       0x00001969, 0x00001d69, 0x00002169, 0x00002569,
		       0x00002969, 0x00002d69, 0x00003169, 0x00003569,
		       0x00003969, 0x00003d69, 0x00000369, 0x00000769,
		       0x00000b69, 0x00000f69, 0x00001369, 0x00001769,
		       0x00001b69, 0x00001f69, 0x00002369, 0x00002769,
		       0x00002b69, 0x00002f69, 0x00003369, 0x00003769,
		       0x00003b69, 0x00003f69, 0x00000089, 0x00000289,
		       0x00000489, 0x00000689, 0x00000889, 0x00000a89,
		       0x00000c89, 0x00000e89, 0x00001089, 0x00001289,
		       0x00001489, 0x00001689, 0x00001889, 0x00001a89,
		       0x00001c89, 0x00001e89, 0x00002089, 0x00002289,
		       0x00002489, 0x00002689, 0x00002889, 0x00002a89,
		       0x00002c89, 0x00002e89, 0x00003089, 0x00003289,
		       0x00003489, 0x00003689, 0x00003889, 0x00003a89,
		       0x00003c89, 0x00003e89, 0x000000ea, 0x000004ea,
		       0x000008ea, 0x00000cea, 0x000010ea, 0x000014ea,
		       0x000018ea, 0x00001cea, 0x000020ea, 0x000024ea,
		       0x000028ea, 0x00002cea, 0x000030ea, 0x000034ea,
		       0x000038ea, 0x00003cea, 0x000040ea, 0x000044ea,
		       0x000048ea, 0x00004cea, 0x000050ea, 0x000054ea,
		       0x000058ea, 0x00005cea, 0x000060ea, 0x000064ea,
		       0x000068ea, 0x00006cea, 0x000070ea, 0x000074ea,
		       0x000078ea, 0x00007cea, 0x0000018a, 0x0000038a,
		       0x0000058a, 0x0000078a, 0x0000098a, 0x00000b8a,
		       0x00000d8a, 0x00000f8a, 0x0000118a, 0x0000138a,
		       0x0000158a, 0x0000178a, 0x0000198a, 0x00001b8a,
		       0x00001d8a, 0x00001f8a, 0x0000218a, 0x0000238a,
		       0x0000258a, 0x0000278a, 0x0000298a, 0x00002b8a,
		       0x00002d8a, 0x00002f8a, 0x0000318a, 0x0000338a,
		       0x0000358a, 0x0000378a, 0x0000398a, 0x00003b8a,
		       0x00003d8a, 0x00003f8a, 0x0000418a, 0x0000438a,
		       0x0000458a, 0x0000478a, 0x0000498a, 0x00004b8a,
		       0x00004d8a, 0x00004f8a, 0x0000518a, 0x0000538a,
		       0x0000558a, 0x0000578a, 0x0000598a, 0x00005b8a,
		       0x00005d8a, 0x00005f8a, 0x0000618a, 0x0000638a,
		       0x0000658a, 0x0000678a, 0x0000698a, 0x00006b8a,
		       0x00006d8a, 0x00006f8a, 0x0000718a, 0x0000738a,
		       0x0000758a, 0x0000778a, 0x0000798a, 0x00007b8a,
		       0x00007d8a, 0x00007f8a, 0x0000004a, 0x0000024a,
		       0x0000044a, 0x0000064a, 0x0000084a, 0x00000a4a,
		       0x00000c4a, 0x00000e4a, 0x0000104a, 0x0000124a,
		       0x0000144a, 0x0000164a, 0x0000184a, 0x00001a4a,
		       0x00001c4a, 0x00001e4a, 0x0000204a, 0x0000224a,
		       0x0000244a, 0x0000264a, 0x0000284a, 0x00002a4a,
		       0x00002c4a, 0x00002e4a, 0x0000304a, 0x0000324a,
		       0x0000344a, 0x0000364a, 0x0000384a, 0x00003a4a,
		       0x00003c4a, 0x00003e4a, 0x0000404a, 0x0000424a,
		       0x0000444a, 0x0000464a, 0x0000484a, 0x00004a4a,
		       0x00004c4a, 0x00004e4a, 0x0000504a, 0x0000524a,
		       0x0000544a, 0x0000564a, 0x0000584a, 0x00005a4a,
		       0x00005c4a, 0x00005e4a, 0x0000604a, 0x0000624a,
		       0x0000644a, 0x0000664a, 0x0000684a, 0x00006a4a,
		       0x00006c4a, 0x00006e4a, 0x0000704a, 0x0000724a,
		       0x0000744a, 0x0000764a, 0x0000784a, 0x00007a4a,
		       0x00007c4a, 0x00007e4a, 0x0000014b, 0x0000034b,
		       0x0000054b, 0x0000074b, 0x0000094b, 0x00000b4b,
		       0x00000d4b, 0x00000f4b, 0x0000114b, 0x0000134b,
		       0x0000154b, 0x0000174b, 0x0000194b, 0x00001b4b,
		       0x00001d4b, 0x00001f4b, 0x0000214b, 0x0000234b,
		       0x0000254b, 0x0000274b, 0x0000294b, 0x00002b4b,
		       0x00002d4b, 0x00002f4b, 0x0000314b, 0x0000334b,
		       0x0000354b, 0x0000374b, 0x0000394b, 0x00003b4b,
		       0x00003d4b, 0x00003f4b, 0x0000414b, 0x0000434b,
		       0x0000454b, 0x0000474b, 0x0000494b, 0x00004b4b,
		       0x00004d4b, 0x00004f4b, 0x0000514b, 0x0000534b,
		       0x0000554b, 0x0000574b, 0x0000594b, 0x00005b4b,
		       0x00005d4b, 0x00005f4b, 0x0000614b, 0x0000634b,
		       0x0000654b, 0x0000674b, 0x0000694b, 0x00006b4b,
		       0x00006d4b, 0x00006f4b, 0x0000714b, 0x0000734b,
		       0x0000754b, 0x0000774b, 0x0000794b, 0x00007b4b,
		       0x00007d4b, 0x00007f4b, 0x0000814b, 0x0000834b,
		       0x0000854b, 0x0000874b, 0x0000894b, 0x00008b4b,
		       0x00008d4b, 0x00008f4b, 0x0000914b, 0x0000934b,
		       0x0000954b, 0x0000974b, 0x0000994b, 0x00009b4b,
		       0x00009d4b, 0x00009f4b, 0x0000a14b, 0x0000a34b,
		       0x0000a54b, 0x0000a74b, 0x0000a94b, 0x0000ab4b,
		       0x0000ad4b, 0x0000af4b, 0x0000b14b, 0x0000b34b,
		       0x0000b54b, 0x0000b74b, 0x0000b94b, 0x0000bb4b,
		       0x0000bd4b, 0x0000bf4b, 0x0000c14b, 0x0000c34b,
		       0x0000c54b, 0x0000c74b, 0x0000c94b, 0x0000cb4b,
		       0x0000cd4b, 0x0000cf4b, 0x0000d14b, 0x0000d34b,
		       0x0000d54b, 0x0000d74b, 0x0000d94b, 0x0000db4b,
		       0x0000dd4b, 0x0000df4b, 0x0000e14b, 0x0000e34b,
		       0x0000e54b, 0x0000e74b, 0x0000e94b, 0x0000eb4b,
		       0x0000ed4b, 0x0000ef4b, 0x0000f14b, 0x0000f34b,
		       0x0000f54b, 0x0000f74b, 0x0000f94b, 0x0000fb4b,
		       0x0000fd4b, 0x0000ff4b, 0x000000cb, 0x000002cb,
		       0x000004cb, 0x000006cb, 0x000008cb, 0x00000acb,
		       0x00000ccb, 0x00000ecb, 0x000010cb, 0x000012cb,
		       0x000014cb, 0x000016cb, 0x000018cb, 0x00001acb,
		       0x00001ccb, 0x00001ecb, 0x000020cb, 0x000022cb,
		       0x000024cb, 0x000026cb, 0x000028cb, 0x00002acb,
		       0x00002ccb, 0x00002ecb, 0x000030cb, 0x000032cb,
		       0x000034cb, 0x000036cb, 0x000038cb, 0x00003acb,
		       0x00003ccb, 0x00003ecb, 0x000040cb, 0x000042cb,
		       0x000044cb, 0x000046cb, 0x000048cb, 0x00004acb,
		       0x00004ccb, 0x00004ecb, 0x000050cb, 0x000052cb,
		       0x000054cb, 0x000056cb, 0x000058cb, 0x00005acb,
		       0x00005ccb, 0x00005ecb, 0x000060cb, 0x000062cb,
		       0x000064cb, 0x000066cb, 0x000068cb, 0x00006acb,
		       0x00006ccb, 0x00006ecb, 0x000070cb, 0x000072cb,
		       0x000074cb, 0x000076cb, 0x000078cb, 0x00007acb,
		       0x00007ccb, 0x00007ecb, 0x000080cb, 0x000082cb,
		       0x000084cb, 0x000086cb, 0x000088cb, 0x00008acb,
		       0x00008ccb, 0x00008ecb, 0x000090cb, 0x000092cb,
		       0x000094cb, 0x000096cb, 0x000098cb, 0x00009acb,
		       0x00009ccb, 0x00009ecb, 0x0000a0cb, 0x0000a2cb,
		       0x0000a4cb, 0x0000a6cb, 0x0000a8cb, 0x0000aacb,
		       0x0000accb, 0x0000aecb, 0x0000b0cb, 0x0000b2cb,
		       0x0000b4cb, 0x0000b6cb, 0x0000b8cb, 0x0000bacb,
		       0x0000bccb, 0x0000becb, 0x0000c0cb, 0x0000c2cb,
		       0x0000c4cb, 0x0000c6cb, 0x0000c8cb, 0x0000cacb,
		       0x0000cccb, 0x0000cecb, 0x0000d0cb, 0x0000d2cb,
		       0x0000d4cb, 0x0000d6cb, 0x0000d8cb, 0x0000dacb,
		       0x0000dccb, 0x0000decb, 0x0000e0cb, 0x0000e2cb,
		       0x0000e4cb, 0x0000e6cb, 0x0000e8cb, 0x0000eacb,
		       0x0000eccb, 0x0000eecb, 0x0000f0cb, 0x0000f2cb,
		       0x0000f4cb, 0x0000f6cb, 0x0000f8cb, 0x0000facb,
		       0x0000fccb, 0x0000fecb, 0x000001cc, 0x000003cc,
		       0x000005cc, 0x000007cc, 0x000009cc, 0x00000bcc,
		       0x00000dcc, 0x00000fcc, 0x000011cc, 0x000013cc,
		       0x000015cc, 0x000017cc, 0x000019cc, 0x00001bcc,
		       0x00001dcc, 0x00001fcc, 0x000021cc, 0x000023cc,
		       0x000025cc, 0x000027cc, 0x000029cc, 0x00002bcc,
		       0x00002dcc, 0x00002fcc, 0x000031cc, 0x000033cc,
		       0x000035cc, 0x000037cc, 0x000039cc, 0x00003bcc,
		       0x00003dcc, 0x00003fcc, 0x000041cc, 0x000043cc,
		       0x000045cc, 0x000047cc, 0x000049cc, 0x00004bcc,
		       0x00004dcc, 0x00004fcc, 0x000051cc, 0x000053cc,
		       0x000055cc, 0x000057cc, 0x000059cc, 0x00005bcc,
		       0x00005dcc, 0x00005fcc, 0x000061cc, 0x000063cc,
		       0x000065cc, 0x000067cc, 0x000069cc, 0x00006bcc,
		       0x00006dcc, 0x00006fcc, 0x000071cc, 0x000073cc,
		       0x000075cc, 0x000077cc, 0x000079cc, 0x00007bcc,
		       0x00007dcc, 0x00007fcc, 0x000081cc, 0x000083cc,
		       0x000085cc, 0x000087cc, 0x000089cc, 0x00008bcc,
		       0x00008dcc, 0x00008fcc, 0x000091cc, 0x000093cc,
		       0x000095cc, 0x000097cc, 0x000099cc, 0x00009bcc,
		       0x00009dcc, 0x00009fcc, 0x0000a1cc, 0x0000a3cc,
		       0x0000a5cc, 0x0000a7cc, 0x0000a9cc, 0x0000abcc,
		       0x0000adcc, 0x0000afcc, 0x0000b1cc, 0x0000b3cc,
		       0x0000b5cc, 0x0000b7cc, 0x0000b9cc, 0x0000bbcc,
		       0x0000bdcc, 0x0000bfcc, 0x0000c1cc, 0x0000c3cc,
		       0x0000c5cc, 0x0000c7cc, 0x0000c9cc, 0x0000cbcc,
		       0x0000cdcc, 0x0000cfcc, 0x0000d1cc, 0x0000d3cc,
		       0x0000d5cc, 0x0000d7cc, 0x0000d9cc, 0x0000dbcc,
		       0x0000ddcc, 0x0000dfcc, 0x0000e1cc, 0x0000e3cc,
		       0x0000e5cc, 0x0000e7cc, 0x0000e9cc, 0x0000ebcc,
		       0x0000edcc, 0x0000efcc, 0x0000f1cc, 0x0000f3cc,
		       0x0000f5cc, 0x0000f7cc, 0x0000f9cc, 0x0000fbcc,
		       0x0000fdcc, 0x0000ffcc, 0x000101cc, 0x000103cc,
		       0x000105cc, 0x000107cc, 0x000109cc, 0x00010bcc,
		       0x00010dcc, 0x00010fcc, 0x000111cc, 0x000113cc,
		       0x000115cc, 0x000117cc, 0x000119cc, 0x00011bcc,
		       0x00011dcc, 0x00011fcc, 0x000121cc, 0x000123cc,
		       0x000125cc, 0x000127cc, 0x000129cc, 0x00012bcc,
		       0x00012dcc, 0x00012fcc, 0x000131cc, 0x000133cc,
		       0x000135cc, 0x000137cc, 0x000139cc, 0x00013bcc,
		       0x00013dcc, 0x00013fcc, 0x000141cc, 0x000143cc,
		       0x000145cc, 0x000147cc, 0x000149cc, 0x00014bcc,
		       0x00014dcc, 0x00014fcc, 0x000151cc, 0x000153cc,
		       0x000155cc, 0x000157cc, 0x000159cc, 0x00015bcc,
		       0x00015dcc, 0x00015fcc, 0x000161cc, 0x000163cc,
		       0x000165cc, 0x000167cc, 0x000169cc, 0x00016bcc,
		       0x00016dcc, 0x00016fcc, 0x000171cc, 0x000173cc,
		       0x000175cc, 0x000177cc, 0x000179cc, 0x00017bcc,
		       0x00017dcc, 0x00017fcc, 0x000181cc, 0x000183cc,
		       0x000185cc, 0x000187cc, 0x000189cc, 0x00018bcc,
		       0x00018dcc, 0x00018fcc, 0x000191cc, 0x000193cc,
		       0x000195cc, 0x000197cc, 0x000199cc, 0x00019bcc,
		       0x00019dcc, 0x00019fcc, 0x0001a1cc, 0x0001a3cc,
		       0x0001a5cc, 0x0001a7cc, 0x0001a9cc, 0x0001abcc,
		       0x0001adcc, 0x0001afcc, 0x0001b1cc, 0x0001b3cc,
		       0x0001b5cc, 0x0001b7cc, 0x0001b9cc, 0x0001bbcc,
		       0x0001bdcc, 0x0001bfcc, 0x0001c1cc, 0x0001c3cc,
		       0x0001c5cc, 0x0001c7cc, 0x0001c9cc, 0x0001cbcc,
		       0x0001cdcc, 0x0001cfcc, 0x0001d1cc, 0x0001d3cc,
		       0x0001d5cc, 0x0001d7cc, 0x0001d9cc, 0x0001dbcc,
		       0x0001ddcc, 0x0001dfcc, 0x0001e1cc, 0x0001e3cc,
		       0x0001e5cc, 0x0001e7cc, 0x0001e9cc, 0x0001ebcc,
		       0x0001edcc, 0x0001efcc, 0x0001f1cc, 0x0001f3cc,
		       0x0001f5cc, 0x0001f7cc, 0x0001f9cc, 0x0001fbcc,
		       0x0001fdcc, 0x0001ffcc, 0x0000002c, 0x0000022c,
		       0x0000042c, 0x0000062c, 0x0000082c, 0x00000a2c,
		       0x00000c2c, 0x00000e2c, 0x0000102c, 0x0000122c,
		       0x0000142c, 0x0000162c, 0x0000182c, 0x00001a2c,
		       0x00001c2c, 0x00001e2c, 0x0000202c, 0x0000222c,
		       0x0000242c, 0x0000262c, 0x0000282c, 0x00002a2c,
		       0x00002c2c, 0x00002e2c, 0x0000302c, 0x0000322c,
		       0x0000342c, 0x0000362c, 0x0000382c, 0x00003a2c,
		       0x00003c2c, 0x00003e2c, 0x0000402c, 0x0000422c,
		       0x0000442c, 0x0000462c, 0x0000482c, 0x00004a2c,
		       0x00004c2c, 0x00004e2c, 0x0000502c, 0x0000522c,
		       0x0000542c, 0x0000562c, 0x0000582c, 0x00005a2c,
		       0x00005c2c, 0x00005e2c, 0x0000602c, 0x0000622c,
		       0x0000642c, 0x0000662c, 0x0000682c, 0x00006a2c,
		       0x00006c2c, 0x00006e2c, 0x0000702c, 0x0000722c,
		       0x0000742c, 0x0000762c, 0x0000782c, 0x00007a2c,
		       0x00007c2c, 0x00007e2c, 0x0000802c, 0x0000822c,
		       0x0000842c, 0x0000862c, 0x0000882c, 0x00008a2c,
		       0x00008c2c, 0x00008e2c, 0x0000902c, 0x0000922c,
		       0x0000942c, 0x0000962c, 0x0000982c, 0x00009a2c,
		       0x00009c2c, 0x00009e2c, 0x0000a02c, 0x0000a22c,
		       0x0000a42c, 0x0000a62c, 0x0000a82c, 0x0000aa2c,
		       0x0000ac2c, 0x0000ae2c, 0x0000b02c, 0x0000b22c,
		       0x0000b42c, 0x0000b62c, 0x0000b82c, 0x0000ba2c,
		       0x0000bc2c, 0x0000be2c, 0x0000c02c, 0x0000c22c,
		       0x0000c42c, 0x0000c62c, 0x0000c82c, 0x0000ca2c,
		       0x0000cc2c, 0x0000ce2c, 0x0000d02c, 0x0000d22c,
		       0x0000d42c, 0x0000d62c, 0x0000d82c, 0x0000da2c,
		       0x0000dc2c, 0x0000de2c, 0x0000e02c, 0x0000e22c,
		       0x0000e42c, 0x0000e62c, 0x0000e82c, 0x0000ea2c,
		       0x0000ec2c, 0x0000ee2c, 0x0000f02c, 0x0000f22c,
		       0x0000f42c, 0x0000f62c, 0x0000f82c, 0x0000fa2c,
		       0x0000fc2c, 0x0000fe2c, 0x0001002c, 0x0001022c,
		       0x0001042c, 0x0001062c, 0x0001082c, 0x00010a2c,
		       0x00010c2c, 0x00010e2c, 0x0001102c, 0x0001122c,
		       0x0001142c, 0x0001162c, 0x0001182c, 0x00011a2c,
		       0x00011c2c, 0x00011e2c, 0x0001202c, 0x0001222c,
		       0x0001242c, 0x0001262c, 0x0001282c, 0x00012a2c,
		       0x00012c2c, 0x00012e2c, 0x0001302c, 0x0001322c,
		       0x0001342c, 0x0001362c, 0x0001382c, 0x00013a2c,
		       0x00013c2c, 0x00013e2c, 0x0001402c, 0x0001422c,
		       0x0001442c, 0x0001462c, 0x0001482c, 0x00014a2c,
		       0x00014c2c, 0x00014e2c, 0x0001502c, 0x0001522c,
		       0x0001542c, 0x0001562c, 0x0001582c, 0x00015a2c,
		       0x00015c2c, 0x00015e2c, 0x0001602c, 0x0001622c,
		       0x0001642c, 0x0001662c, 0x0001682c, 0x00016a2c,
		       0x00016c2c, 0x00016e2c, 0x0001702c, 0x0001722c,
		       0x0001742c, 0x0001762c, 0x0001782c, 0x00017a2c,
		       0x00017c2c, 0x00017e2c, 0x0001802c, 0x0001822c,
		       0x0001842c, 0x0001862c, 0x0001882c, 0x00018a2c,
		       0x00018c2c, 0x00018e2c, 0x0001902c, 0x0001922c,
		       0x0001942c, 0x0001962c, 0x0001982c, 0x00019a2c,
		       0x00019c2c, 0x00019e2c, 0x0001a02c, 0x0001a22c,
		       0x0001a42c, 0x0001a62c, 0x0001a82c, 0x0001aa2c,
		       0x0001ac2c, 0x0001ae2c, 0x0001b02c, 0x0001b22c,
		       0x0001b42c, 0x0001b62c, 0x0001b82c, 0x0001ba2c,
		       0x0001bc2c, 0x0001be2c, 0x0001c02c, 0x0001c22c,
		       0x0001c42c, 0x0001c62c, 0x0001c82c, 0x0001ca2c,
		       0x0001cc2c, 0x0001ce2c, 0x0001d02c, 0x0001d22c,
		       0x0001d42c, 0x0001d62c, 0x0001d82c, 0x0001da2c,
		       0x0001dc2c, 0x0001de2c, 0x0001e02c, 0x0001e22c,
		       0x0001e42c, 0x0001e62c, 0x0001e82c, 0x0001ea2c,
		       0x0001ec2c, 0x0001ee2c, 0x0001f02c, 0x0001f22c,
		       0x0001f42c, 0x0001f62c, 0x0001f82c, 0x0001fa2c,
		       0x0001fc2c, 0x0001fe2c, 0x0000012d, 0x0000032d,
		       0x0000052d, 0x0000072d, 0x0000092d, 0x00000b2d,
		       0x00000d2d, 0x00000f2d, 0x0000112d, 0x0000132d,
		       0x0000152d, 0x0000172d, 0x0000192d, 0x00001b2d,
		       0x00001d2d, 0x00001f2d, 0x0000212d, 0x0000232d,
		       0x0000252d, 0x0000272d, 0x0000292d, 0x00002b2d,
		       0x00002d2d, 0x00002f2d, 0x0000312d, 0x0000332d,
		       0x0000352d, 0x0000372d, 0x0000392d, 0x00003b2d,
		       0x00003d2d, 0x00003f2d, 0x0000412d, 0x0000432d,
		       0x0000452d, 0x0000472d, 0x0000492d, 0x00004b2d,
		       0x00004d2d, 0x00004f2d, 0x0000512d, 0x0000532d,
		       0x0000552d, 0x0000572d, 0x0000592d, 0x00005b2d,
		       0x00005d2d, 0x00005f2d, 0x0000612d, 0x0000632d,
		       0x0000652d, 0x0000672d, 0x0000692d, 0x00006b2d,
		       0x00006d2d, 0x00006f2d, 0x0000712d, 0x0000732d,
		       0x0000752d, 0x0000772d, 0x0000792d, 0x00007b2d,
		       0x00007d2d, 0x00007f2d, 0x0000812d, 0x0000832d,
		       0x0000852d, 0x0000872d, 0x0000892d, 0x00008b2d,
		       0x00008d2d, 0x00008f2d, 0x0000912d, 0x0000932d,
		       0x0000952d, 0x0000972d, 0x0000992d, 0x00009b2d,
		       0x00009d2d, 0x00009f2d, 0x0000a12d, 0x0000a32d,
		       0x0000a52d, 0x0000a72d, 0x0000a92d, 0x0000ab2d,
		       0x0000ad2d, 0x0000af2d, 0x0000b12d, 0x0000b32d,
		       0x0000b52d, 0x0000b72d, 0x0000b92d, 0x0000bb2d,
		       0x0000bd2d, 0x0000bf2d, 0x0000c12d, 0x0000c32d,
		       0x0000c52d, 0x0000c72d, 0x0000c92d, 0x0000cb2d,
		       0x0000cd2d, 0x0000cf2d, 0x0000d12d, 0x0000d32d,
		       0x0000d52d, 0x0000d72d, 0x0000d92d, 0x0000db2d,
		       0x0000dd2d, 0x0000df2d, 0x0000e12d, 0x0000e32d,
		       0x0000e52d, 0x0000e72d, 0x0000e92d, 0x0000eb2d,
		       0x0000ed2d, 0x0000ef2d, 0x0000f12d, 0x0000f32d,
		       0x0000f52d, 0x0000f72d, 0x0000f92d, 0x0000fb2d,
		       0x0000fd2d, 0x0000ff2d, 0x0001012d, 0x0001032d,
		       0x0001052d, 0x0001072d, 0x0001092d, 0x00010b2d,
		       0x00010d2d, 0x00010f2d, 0x0001112d, 0x0001132d,
		       0x0001152d, 0x0001172d, 0x0001192d, 0x00011b2d,
		       0x00011d2d, 0x00011f2d, 0x0001212d, 0x0001232d,
		       0x0001252d, 0x0001272d, 0x0001292d, 0x00012b2d,
		       0x00012d2d, 0x00012f2d, 0x0001312d, 0x0001332d,
		       0x0001352d, 0x0001372d, 0x0001392d, 0x00013b2d,
		       0x00013d2d, 0x00013f2d, 0x0001412d, 0x0001432d,
		       0x0001452d, 0x0001472d, 0x0001492d, 0x00014b2d,
		       0x00014d2d, 0x00014f2d, 0x0001512d, 0x0001532d,
		       0x0001552d, 0x0001572d, 0x0001592d, 0x00015b2d,
		       0x00015d2d, 0x00015f2d, 0x0001612d, 0x0001632d,
		       0x0001652d, 0x0001672d, 0x0001692d, 0x00016b2d,
		       0x00016d2d, 0x00016f2d, 0x0001712d, 0x0001732d,
		       0x0001752d, 0x0001772d, 0x0001792d, 0x00017b2d,
		       0x00017d2d, 0x00017f2d, 0x0001812d, 0x0001832d,
		       0x0001852d, 0x0001872d, 0x0001892d, 0x00018b2d,
		       0x00018d2d, 0x00018f2d, 0x0001912d, 0x0001932d,
		       0x0001952d, 0x0001972d, 0x0001992d, 0x00019b2d,
		       0x00019d2d, 0x00019f2d, 0x0001a12d, 0x0001a32d,
		       0x0001a52d, 0x0001a72d, 0x0001a92d, 0x0001ab2d,
		       0x0001ad2d, 0x0001af2d, 0x0001b12d, 0x0001b32d,
		       0x0001b52d, 0x0001b72d, 0x0001b92d, 0x0001bb2d,
		       0x0001bd2d, 0x0001bf2d, 0x0001c12d, 0x0001c32d,
		       0x0001c52d, 0x0001c72d, 0x0001c92d, 0x0001cb2d,
		       0x0001cd2d, 0x0001cf2d, 0x0001d12d, 0x0001d32d,
		       0x0001d52d, 0x0001d72d, 0x0001d92d, 0x0001db2d,
		       0x0001dd2d, 0x0001df2d, 0x0001e12d, 0x0001e32d,
		       0x0001e52d, 0x0001e72d, 0x0001e92d, 0x0001eb2d,
		       0x0001ed2d, 0x0001ef2d, 0x0001f12d, 0x0001f32d,
		       0x0001f52d, 0x0001f72d, 0x0001f92d, 0x0001fb2d,
		       0x0001fd2d, 0x0001ff2d, 0x0002012d, 0x0002032d,
		       0x0002052d, 0x0002072d, 0x0002092d, 0x00020b2d,
		       0x00020d2d, 0x00020f2d, 0x0002112d, 0x0002132d,
		       0x0002152d, 0x0002172d, 0x0002192d, 0x00021b2d,
		       0x00021d2d, 0x00021f2d, 0x0002212d, 0x0002232d,
		       0x0002252d, 0x0002272d, 0x0002292d, 0x00022b2d,
		       0x00022d2d, 0x00022f2d, 0x0002312d, 0x0002332d,
		       0x0002352d, 0x0002372d, 0x0002392d, 0x00023b2d,
		       0x00023d2d, 0x00023f2d, 0x0002412d, 0x0002432d,
		       0x0002452d, 0x0002472d, 0x0002492d, 0x00024b2d,
		       0x00024d2d, 0x00024f2d, 0x0002512d, 0x0002532d,
		       0x0002552d, 0x0002572d, 0x0002592d, 0x00025b2d,
		       0x00025d2d, 0x00025f2d, 0x0002612d, 0x0002632d,
		       0x0002652d, 0x0002672d, 0x0002692d, 0x00026b2d,
		       0x00026d2d, 0x00026f2d, 0x0002712d, 0x0002732d,
		       0x0002752d, 0x0002772d, 0x0002792d, 0x00027b2d,
		       0x00027d2d, 0x00027f2d, 0x0002812d, 0x0002832d,
		       0x0002852d, 0x0002872d, 0x0002892d, 0x00028b2d,
		       0x00028d2d, 0x00028f2d, 0x0002912d, 0x0002932d,
		       0x0002952d, 0x0002972d, 0x0002992d, 0x00029b2d,
		       0x00029d2d, 0x00029f2d, 0x0002a12d, 0x0002a32d,
		       0x0002a52d, 0x0002a72d, 0x0002a92d, 0x0002ab2d,
		       0x0002ad2d, 0x0002af2d, 0x0002b12d, 0x0002b32d,
		       0x0002b52d, 0x0002b72d, 0x0002b92d, 0x0002bb2d,
		       0x0002bd2d, 0x0002bf2d, 0x0002c12d, 0x0002c32d,
		       0x0002c52d, 0x0002c72d, 0x0002c92d, 0x0002cb2d,
		       0x0002cd2d, 0x0002cf2d, 0x0002d12d, 0x0002d32d,
		       0x0002d52d, 0x0002d72d, 0x0002d92d, 0x0002db2d,
		       0x0002dd2d, 0x0002df2d, 0x0002e12d, 0x0002e32d,
		       0x0002e52d, 0x0002e72d, 0x0002e92d, 0x0002eb2d,
		       0x0002ed2d, 0x0002ef2d, 0x0002f12d, 0x0002f32d,
		       0x0002f52d, 0x0002f72d, 0x0002f92d, 0x0002fb2d,
		       0x0002fd2d, 0x0002ff2d, 0x0003012d, 0x0003032d,
		       0x0003052d, 0x0003072d, 0x0003092d, 0x00030b2d,
		       0x00030d2d, 0x00030f2d, 0x0003112d, 0x0003132d,
		       0x0003152d, 0x0003172d, 0x0003192d, 0x00031b2d,
		       0x00031d2d, 0x00031f2d, 0x0003212d, 0x0003232d,
		       0x0003252d, 0x0003272d, 0x0003292d, 0x00032b2d,
		       0x00032d2d, 0x00032f2d, 0x0003312d, 0x0003332d,
		       0x0003352d, 0x0003372d, 0x0003392d, 0x00033b2d,
		       0x00033d2d, 0x00033f2d, 0x0003412d, 0x0003432d,
		       0x0003452d, 0x0003472d, 0x0003492d, 0x00034b2d,
		       0x00034d2d, 0x00034f2d, 0x0003512d, 0x0003532d,
		       0x0003552d, 0x0003572d, 0x0003592d, 0x00035b2d,
		       0x00035d2d, 0x00035f2d, 0x0003612d, 0x0003632d,
		       0x0003652d, 0x0003672d, 0x0003692d, 0x00036b2d,
		       0x00036d2d, 0x00036f2d, 0x0003712d, 0x0003732d,
		       0x0003752d, 0x0003772d, 0x0003792d, 0x00037b2d,
		       0x00037d2d, 0x00037f2d, 0x0003812d, 0x0003832d,
		       0x0003852d, 0x0003872d, 0x0003892d, 0x00038b2d,
		       0x00038d2d, 0x00038f2d, 0x0003912d, 0x0003932d,
		       0x0003952d, 0x0003972d, 0x0003992d, 0x00039b2d,
		       0x00039d2d, 0x00039f2d, 0x0003a12d, 0x0003a32d,
		       0x0003a52d, 0x0003a72d, 0x0003a92d, 0x0003ab2d,
		       0x0003ad2d, 0x0003af2d, 0x0003b12d, 0x0003b32d,
		       0x0003b52d, 0x0003b72d, 0x0003b92d, 0x0003bb2d,
		       0x0003bd2d, 0x0003bf2d, 0x0003c12d, 0x0003c32d,
		       0x0003c52d, 0x0003c72d, 0x0003c92d, 0x0003cb2d,
		       0x0003cd2d, 0x0003cf2d, 0x0003d12d, 0x0003d32d,
		       0x0003d52d, 0x0003d72d, 0x0003d92d, 0x0003db2d,
		       0x0003dd2d, 0x0003df2d, 0x0003e12d, 0x0003e32d,
		       0x0003e52d, 0x0003e72d, 0x0003e92d, 0x0003eb2d,
		       0x0003ed2d, 0x0003ef2d, 0x0003f12d, 0x0003f32d,
		       0x0003f52d, 0x0003f72d, 0x0003f92d, 0x0003fb2d,
		       0x0003fd2d, 0x0003ff2d, 0x000002ee, 0x000006ee,
		       0x00000aee, 0x00000eee, 0x000012ee, 0x000016ee,
		       0x00001aee, 0x00001eee, 0x000022ee, 0x000026ee,
		       0x00002aee, 0x00002eee, 0x000032ee, 0x000036ee,
		       0x00003aee, 0x00003eee, 0x000042ee, 0x000046ee,
		       0x00004aee, 0x00004eee, 0x000052ee, 0x000056ee,
		       0x00005aee, 0x00005eee, 0x000062ee, 0x000066ee,
		       0x00006aee, 0x00006eee, 0x000072ee, 0x000076ee,
		       0x00007aee, 0x00007eee, 0x000082ee, 0x000086ee,
		       0x00008aee, 0x00008eee, 0x000092ee, 0x000096ee,
		       0x00009aee, 0x00009eee, 0x0000a2ee, 0x0000a6ee,
		       0x0000aaee, 0x0000aeee, 0x0000b2ee, 0x0000b6ee,
		       0x0000baee, 0x0000beee, 0x0000c2ee, 0x0000c6ee,
		       0x0000caee, 0x0000ceee, 0x0000d2ee, 0x0000d6ee,
		       0x0000daee, 0x0000deee, 0x0000e2ee, 0x0000e6ee,
		       0x0000eaee, 0x0000eeee, 0x0000f2ee, 0x0000f6ee,
		       0x0000faee, 0x0000feee, 0x000102ee, 0x000106ee,
		       0x00010aee, 0x00010eee, 0x000112ee, 0x000116ee,
		       0x00011aee, 0x00011eee, 0x000122ee, 0x000126ee,
		       0x00012aee, 0x00012eee, 0x000132ee, 0x000136ee,
		       0x00013aee, 0x00013eee, 0x000142ee, 0x000146ee,
		       0x00014aee, 0x00014eee, 0x000152ee, 0x000156ee,
		       0x00015aee, 0x00015eee, 0x000162ee, 0x000166ee,
		       0x00016aee, 0x00016eee, 0x000172ee, 0x000176ee,
		       0x00017aee, 0x00017eee, 0x000182ee, 0x000186ee,
		       0x00018aee, 0x00018eee, 0x000192ee, 0x000196ee,
		       0x00019aee, 0x00019eee, 0x0001a2ee, 0x0001a6ee,
		       0x0001aaee, 0x0001aeee, 0x0001b2ee, 0x0001b6ee,
		       0x0001baee, 0x0001beee, 0x0001c2ee, 0x0001c6ee,
		       0x0001caee, 0x0001ceee, 0x0001d2ee, 0x0001d6ee,
		       0x0001daee, 0x0001deee, 0x0001e2ee, 0x0001e6ee,
		       0x0001eaee, 0x0001eeee, 0x0001f2ee, 0x0001f6ee,
		       0x0001faee, 0x0001feee, 0x000202ee, 0x000206ee,
		       0x00020aee, 0x00020eee, 0x000212ee, 0x000216ee,
		       0x00021aee, 0x00021eee, 0x000222ee, 0x000226ee,
		       0x00022aee, 0x00022eee, 0x000232ee, 0x000236ee,
		       0x00023aee, 0x00023eee, 0x000242ee, 0x000246ee,
		       0x00024aee, 0x00024eee, 0x000252ee, 0x000256ee,
		       0x00025aee, 0x00025eee, 0x000262ee, 0x000266ee,
		       0x00026aee, 0x00026eee, 0x000272ee, 0x000276ee,
		       0x00027aee, 0x00027eee, 0x000282ee, 0x000286ee,
		       0x00028aee, 0x00028eee, 0x000292ee, 0x000296ee,
		       0x00029aee, 0x00029eee, 0x0002a2ee, 0x0002a6ee,
		       0x0002aaee, 0x0002aeee, 0x0002b2ee, 0x0002b6ee,
		       0x0002baee, 0x0002beee, 0x0002c2ee, 0x0002c6ee,
		       0x0002caee, 0x0002ceee, 0x0002d2ee, 0x0002d6ee,
		       0x0002daee, 0x0002deee, 0x0002e2ee, 0x0002e6ee,
		       0x0002eaee, 0x0002eeee, 0x0002f2ee, 0x0002f6ee,
		       0x0002faee, 0x0002feee, 0x000302ee, 0x000306ee,
		       0x00030aee, 0x00030eee, 0x000312ee, 0x000316ee,
		       0x00031aee, 0x00031eee, 0x000322ee, 0x000326ee,
		       0x00032aee, 0x00032eee, 0x000332ee, 0x000336ee,
		       0x00033aee, 0x00033eee, 0x000342ee, 0x000346ee,
		       0x00034aee, 0x00034eee, 0x000352ee, 0x000356ee,
		       0x00035aee, 0x00035eee, 0x000362ee, 0x000366ee,
		       0x00036aee, 0x00036eee, 0x000372ee, 0x000376ee,
		       0x00037aee, 0x00037eee, 0x000382ee, 0x000386ee,
		       0x00038aee, 0x00038eee, 0x000392ee, 0x000396ee,
		       0x00039aee, 0x00039eee, 0x0003a2ee, 0x0003a6ee,
		       0x0003aaee, 0x0003aeee, 0x0003b2ee, 0x0003b6ee,
		       0x0003baee, 0x0003beee, 0x0003c2ee, 0x0003c6ee,
		       0x0003caee, 0x0003ceee, 0x0003d2ee, 0x0003d6ee,
		       0x0003daee, 0x0003deee, 0x0003e2ee, 0x0003e6ee,
		       0x0003eaee, 0x0003eeee, 0x0003f2ee, 0x0003f6ee,
		       0x0003faee, 0x0003feee, 0x000402ee, 0x000406ee,
		       0x00040aee, 0x00040eee, 0x000412ee, 0x000416ee,
		       0x00041aee, 0x00041eee, 0x000422ee, 0x000426ee,
		       0x00042aee, 0x00042eee, 0x000432ee, 0x000436ee,
		       0x00043aee, 0x00043eee, 0x000442ee, 0x000446ee,
		       0x00044aee, 0x00044eee, 0x000452ee, 0x000456ee,
		       0x00045aee, 0x00045eee, 0x000462ee, 0x000466ee,
		       0x00046aee, 0x00046eee, 0x000472ee, 0x000476ee,
		       0x00047aee, 0x00047eee, 0x000482ee, 0x000486ee,
		       0x00048aee, 0x00048eee, 0x000492ee, 0x000496ee,
		       0x00049aee, 0x00049eee, 0x0004a2ee, 0x0004a6ee,
		       0x0004aaee, 0x0004aeee, 0x0004b2ee, 0x0004b6ee,
		       0x0004baee, 0x0004beee, 0x0004c2ee, 0x0004c6ee,
		       0x0004caee, 0x0004ceee, 0x0004d2ee, 0x0004d6ee,
		       0x0004daee, 0x0004deee, 0x0004e2ee, 0x0004e6ee,
		       0x0004eaee, 0x0004eeee, 0x0004f2ee, 0x0004f6ee,
		       0x0004faee, 0x0004feee, 0x000502ee, 0x000506ee,
		       0x00050aee, 0x00050eee, 0x000512ee, 0x000516ee,
		       0x00051aee, 0x00051eee, 0x000522ee, 0x000526ee,
		       0x00052aee, 0x00052eee, 0x000532ee, 0x000536ee,
		       0x00053aee, 0x00053eee, 0x000542ee, 0x000546ee,
		       0x00054aee, 0x00054eee, 0x000552ee, 0x000556ee,
		       0x00055aee, 0x00055eee, 0x000562ee, 0x000566ee,
		       0x00056aee, 0x00056eee, 0x000572ee, 0x000576ee,
		       0x00057aee, 0x00057eee, 0x000582ee, 0x000586ee,
		       0x00058aee, 0x00058eee, 0x000592ee, 0x000596ee,
		       0x00059aee, 0x00059eee, 0x0005a2ee, 0x0005a6ee,
		       0x0005aaee, 0x0005aeee, 0x0005b2ee, 0x0005b6ee,
		       0x0005baee, 0x0005beee, 0x0005c2ee, 0x0005c6ee,
		       0x0005caee, 0x0005ceee, 0x0005d2ee, 0x0005d6ee,
		       0x0005daee, 0x0005deee, 0x0005e2ee, 0x0005e6ee,
		       0x0005eaee, 0x0005eeee, 0x0005f2ee, 0x0005f6ee,
		       0x0005faee, 0x0005feee, 0x000602ee, 0x000606ee,
		       0x00060aee, 0x00060eee, 0x000612ee, 0x000616ee,
		       0x00061aee, 0x00061eee, 0x000622ee, 0x000626ee,
		       0x00062aee, 0x00062eee, 0x000632ee, 0x000636ee,
		       0x00063aee, 0x00063eee, 0x000642ee, 0x000646ee,
		       0x00064aee, 0x00064eee, 0x000652ee, 0x000656ee,
		       0x00065aee, 0x00065eee, 0x000662ee, 0x000666ee,
		       0x00066aee, 0x00066eee, 0x000672ee, 0x000676ee,
		       0x00067aee, 0x00067eee, 0x000682ee, 0x000686ee,
		       0x00068aee, 0x00068eee, 0x000692ee, 0x000696ee,
		       0x00069aee, 0x00069eee, 0x0006a2ee, 0x0006a6ee,
		       0x0006aaee, 0x0006aeee, 0x0006b2ee, 0x0006b6ee,
		       0x0006baee, 0x0006beee, 0x0006c2ee, 0x0006c6ee,
		       0x0006caee, 0x0006ceee, 0x0006d2ee, 0x0006d6ee,
		       0x0006daee, 0x0006deee, 0x0006e2ee, 0x0006e6ee,
		       0x0006eaee, 0x0006eeee, 0x0006f2ee, 0x0006f6ee,
		       0x0006faee, 0x0006feee, 0x000702ee, 0x000706ee,
		       0x00070aee, 0x00070eee, 0x000712ee, 0x000716ee,
		       0x00071aee, 0x00071eee, 0x000722ee, 0x000726ee,
		       0x00072aee, 0x00072eee, 0x000732ee, 0x000736ee,
		       0x00073aee, 0x00073eee, 0x000742ee, 0x000746ee,
		       0x00074aee, 0x00074eee, 0x000752ee, 0x000756ee,
		       0x00075aee, 0x00075eee, 0x000762ee, 0x000766ee,
		       0x00076aee, 0x00076eee, 0x000772ee, 0x000776ee,
		       0x00077aee, 0x00077eee, 0x000782ee, 0x000786ee,
		       0x00078aee, 0x00078eee, 0x000792ee, 0x000796ee,
		       0x00079aee, 0x00079eee, 0x0007a2ee, 0x0007a6ee,
		       0x0007aaee, 0x0007aeee, 0x0007b2ee, 0x0007b6ee,
		       0x0007baee, 0x0007beee, 0x0007c2ee, 0x0007c6ee,
		       0x0007caee, 0x0007ceee, 0x0007d2ee, 0x0007d6ee,
		       0x0007daee, 0x0007deee, 0x0007e2ee, 0x0007e6ee,
		       0x0007eaee, 0x0007eeee, 0x0007f2ee, 0x0007f6ee,
		       0x0007faee, 0x0007feee, 0x0000000d, 0x0000010d,
		       0x0000020d, 0x0000030d, 0x0000040d, 0x0000050d,
		       0x0000060d, 0x0000070d, 0x0000080d, 0x0000090d,
		       0x00000a0d, 0x00000b0d, 0x00000c0d, 0x00000d0d,
		       0x00000e0d, 0x00000f0d, 0x0000100d, 0x0000110d,
		       0x0000120d, 0x0000130d, 0x0000140d, 0x0000150d,
		       0x0000160d, 0x0000170d, 0x0000180d, 0x0000190d,
		       0x00001a0d, 0x00001b0d, 0x00001c0d, 0x00001d0d,
		       0x00001e0d, 0x00001f0d, 0x0000200d, 0x0000210d,
		       0x0000220d, 0x0000230d, 0x0000240d, 0x0000250d,
		       0x0000260d, 0x0000270d, 0x0000280d, 0x0000290d,
		       0x00002a0d, 0x00002b0d, 0x00002c0d, 0x00002d0d,
		       0x00002e0d, 0x00002f0d, 0x0000300d, 0x0000310d,
		       0x0000320d, 0x0000330d, 0x0000340d, 0x0000350d,
		       0x0000360d, 0x0000370d, 0x0000380d, 0x0000390d,
		       0x00003a0d, 0x00003b0d, 0x00003c0d, 0x00003d0d,
		       0x00003e0d, 0x00003f0d, 0x0000400d, 0x0000410d,
		       0x0000420d, 0x0000430d, 0x0000440d, 0x0000450d,
		       0x0000460d, 0x0000470d, 0x0000480d, 0x0000490d,
		       0x00004a0d, 0x00004b0d, 0x00004c0d, 0x00004d0d,
		       0x00004e0d, 0x00004f0d, 0x0000500d, 0x0000510d,
		       0x0000520d, 0x0000530d, 0x0000540d, 0x0000550d,
		       0x0000560d, 0x0000570d, 0x0000580d, 0x0000590d,
		       0x00005a0d, 0x00005b0d, 0x00005c0d, 0x00005d0d,
		       0x00005e0d, 0x00005f0d, 0x0000600d, 0x0000610d,
		       0x0000620d, 0x0000630d, 0x0000640d, 0x0000650d,
		       0x0000660d, 0x0000670d, 0x0000680d, 0x0000690d,
		       0x00006a0d, 0x00006b0d, 0x00006c0d, 0x00006d0d,
		       0x00006e0d, 0x00006f0d, 0x0000700d, 0x0000710d,
		       0x0000720d, 0x0000730d, 0x0000740d, 0x0000750d,
		       0x0000760d, 0x0000770d, 0x0000780d, 0x0000790d,
		       0x00007a0d, 0x00007b0d, 0x00007c0d, 0x00007d0d,
		       0x00007e0d, 0x00007f0d, 0x0000800d, 0x0000810d,
		       0x0000820d, 0x0000830d, 0x0000840d, 0x0000850d,
		       0x0000860d, 0x0000870d, 0x0000880d, 0x0000890d,
		       0x00008a0d, 0x00008b0d, 0x00008c0d, 0x00008d0d,
		       0x00008e0d, 0x00008f0d, 0x0000900d, 0x0000910d,
		       0x0000920d, 0x0000930d, 0x0000940d, 0x0000950d,
		       0x0000960d, 0x0000970d, 0x0000980d, 0x0000990d,
		       0x00009a0d, 0x00009b0d, 0x00009c0d, 0x00009d0d,
		       0x00009e0d, 0x00009f0d, 0x0000a00d, 0x0000a10d,
		       0x0000a20d, 0x0000a30d, 0x0000a40d, 0x0000a50d,
		       0x0000a60d, 0x0000a70d, 0x0000a80d, 0x0000a90d,
		       0x0000aa0d, 0x0000ab0d, 0x0000ac0d, 0x0000ad0d,
		       0x0000ae0d, 0x0000af0d, 0x0000b00d, 0x0000b10d,
		       0x0000b20d, 0x0000b30d, 0x0000b40d, 0x0000b50d,
		       0x0000b60d, 0x0000b70d, 0x0000b80d, 0x0000b90d,
		       0x0000ba0d, 0x0000bb0d, 0x0000bc0d, 0x0000bd0d,
		       0x0000be0d, 0x0000bf0d, 0x0000c00d, 0x0000c10d,
		       0x0000c20d, 0x0000c30d, 0x0000c40d, 0x0000c50d,
		       0x0000c60d, 0x0000c70d, 0x0000c80d, 0x0000c90d,
		       0x0000ca0d, 0x0000cb0d, 0x0000cc0d, 0x0000cd0d,
		       0x0000ce0d, 0x0000cf0d, 0x0000d00d, 0x0000d10d,
		       0x0000d20d, 0x0000d30d, 0x0000d40d, 0x0000d50d,
		       0x0000d60d, 0x0000d70d, 0x0000d80d, 0x0000d90d,
		       0x0000da0d, 0x0000db0d, 0x0000dc0d, 0x0000dd0d,
		       0x0000de0d, 0x0000df0d, 0x0000e00d, 0x0000e10d,
		       0x0000e20d, 0x0000e30d, 0x0000e40d, 0x0000e50d,
		       0x0000e60d, 0x0000e70d, 0x0000e80d, 0x0000e90d,
		       0x0000ea0d, 0x0000eb0d, 0x0000ec0d, 0x0000ed0d,
		       0x0000ee0d, 0x0000ef0d, 0x0000f00d, 0x0000f10d,
		       0x0000f20d, 0x0000f30d, 0x0000f40d, 0x0000f50d,
		       0x0000f60d, 0x0000f70d, 0x0000f80d, 0x0000f90d,
		       0x0000fa0d, 0x0000fb0d, 0x0000fc0d, 0x0000fd0d,
		       0x0000fe0d, 0x0000ff0d, 0x0001000d, 0x0001010d,
		       0x0001020d, 0x0001030d, 0x0001040d, 0x0001050d,
		       0x0001060d, 0x0001070d, 0x0001080d, 0x0001090d,
		       0x00010a0d, 0x00010b0d, 0x00010c0d, 0x00010d0d,
		       0x00010e0d, 0x00010f0d, 0x0001100d, 0x0001110d,
		       0x0001120d, 0x0001130d, 0x0001140d, 0x0001150d,
		       0x0001160d, 0x0001170d, 0x0001180d, 0x0001190d,
		       0x00011a0d, 0x00011b0d, 0x00011c0d, 0x00011d0d,
		       0x00011e0d, 0x00011f0d, 0x0001200d, 0x0001210d,
		       0x0001220d, 0x0001230d, 0x0001240d, 0x0001250d,
		       0x0001260d, 0x0001270d, 0x0001280d, 0x0001290d,
		       0x00012a0d, 0x00012b0d, 0x00012c0d, 0x00012d0d,
		       0x00012e0d, 0x00012f0d, 0x0001300d, 0x0001310d,
		       0x0001320d, 0x0001330d, 0x0001340d, 0x0001350d,
		       0x0001360d, 0x0001370d, 0x0001380d, 0x0001390d,
		       0x00013a0d, 0x00013b0d, 0x00013c0d, 0x00013d0d,
		       0x00013e0d, 0x00013f0d, 0x0001400d, 0x0001410d,
		       0x0001420d, 0x0001430d, 0x0001440d, 0x0001450d,
		       0x0001460d, 0x0001470d, 0x0001480d, 0x0001490d,
		       0x00014a0d, 0x00014b0d, 0x00014c0d, 0x00014d0d,
		       0x00014e0d, 0x00014f0d, 0x0001500d, 0x0001510d,
		       0x0001520d, 0x0001530d, 0x0001540d, 0x0001550d,
		       0x0001560d, 0x0001570d, 0x0001580d, 0x0001590d,
		       0x00015a0d, 0x00015b0d, 0x00015c0d, 0x00015d0d,
		       0x00015e0d, 0x00015f0d, 0x0001600d, 0x0001610d,
		       0x0001620d, 0x0001630d, 0x0001640d, 0x0001650d,
		       0x0001660d, 0x0001670d, 0x0001680d, 0x0001690d,
		       0x00016a0d, 0x00016b0d, 0x00016c0d, 0x00016d0d,
		       0x00016e0d, 0x00016f0d, 0x0001700d, 0x0001710d,
		       0x0001720d, 0x0001730d, 0x0001740d, 0x0001750d,
		       0x0001760d, 0x0001770d, 0x0001780d, 0x0001790d,
		       0x00017a0d, 0x00017b0d, 0x00017c0d, 0x00017d0d,
		       0x00017e0d, 0x00017f0d, 0x0001800d, 0x0001810d,
		       0x0001820d, 0x0001830d, 0x0001840d, 0x0001850d,
		       0x0001860d, 0x0001870d, 0x0001880d, 0x0001890d,
		       0x00018a0d, 0x00018b0d, 0x00018c0d, 0x00018d0d,
		       0x00018e0d, 0x00018f0d, 0x0001900d, 0x0001910d,
		       0x0001920d, 0x0001930d, 0x0001940d, 0x0001950d,
		       0x0001960d, 0x0001970d, 0x0001980d, 0x0001990d,
		       0x00019a0d, 0x00019b0d, 0x00019c0d, 0x00019d0d,
		       0x00019e0d, 0x00019f0d, 0x0001a00d, 0x0001a10d,
		       0x0001a20d, 0x0001a30d, 0x0001a40d, 0x0001a50d,
		       0x0001a60d, 0x0001a70d, 0x0001a80d, 0x0001a90d,
		       0x0001aa0d, 0x0001ab0d, 0x0001ac0d, 0x0001ad0d,
		       0x0001ae0d, 0x0001af0d, 0x0001b00d, 0x0001b10d,
		       0x0001b20d, 0x0001b30d, 0x0001b40d, 0x0001b50d,
		       0x0001b60d, 0x0001b70d, 0x0001b80d, 0x0001b90d,
		       0x0001ba0d, 0x0001bb0d, 0x0001bc0d, 0x0001bd0d,
		       0x0001be0d, 0x0001bf0d, 0x0001c00d, 0x0001c10d,
		       0x0001c20d, 0x0001c30d, 0x0001c40d, 0x0001c50d,
		       0x0001c60d, 0x0001c70d, 0x0001c80d, 0x0001c90d,
		       0x0001ca0d, 0x0001cb0d, 0x0001cc0d, 0x0001cd0d,
		       0x0001ce0d, 0x0001cf0d, 0x0001d00d, 0x0001d10d,
		       0x0001d20d, 0x0001d30d, 0x0001d40d, 0x0001d50d,
		       0x0001d60d, 0x0001d70d, 0x0001d80d, 0x0001d90d,
		       0x0001da0d, 0x0001db0d, 0x0001dc0d, 0x0001dd0d,
		       0x0001de0d, 0x0001df0d, 0x0001e00d, 0x0001e10d,
		       0x0001e20d, 0x0001e30d, 0x0001e40d, 0x0001e50d,
		       0x0001e60d, 0x0001e70d, 0x0001e80d, 0x0001e90d,
		       0x0001ea0d, 0x0001eb0d, 0x0001ec0d, 0x0001ed0d,
		       0x0001ee0d, 0x0001ef0d, 0x0001f00d, 0x0001f10d,
		       0x0001f20d, 0x0001f30d, 0x0001f40d, 0x0001f50d,
		       0x0001f60d, 0x0001f70d, 0x0001f80d, 0x0001f90d,
		       0x0001fa0d, 0x0001fb0d, 0x0001fc0d, 0x0001fd0d,
		       0x0001fe0d, 0x0001ff0d, 0x0002000d, 0x0002010d,
		       0x0002020d, 0x0002030d, 0x0002040d, 0x0002050d,
		       0x0002060d, 0x0002070d, 0x0002080d, 0x0002090d,
		       0x00020a0d, 0x00020b0d, 0x00020c0d, 0x00020d0d,
		       0x00020e0d, 0x00020f0d, 0x0002100d, 0x0002110d,
		       0x0002120d, 0x0002130d, 0x0002140d, 0x0002150d,
		       0x0002160d, 0x0002170d, 0x0002180d, 0x0002190d,
		       0x00021a0d, 0x00021b0d, 0x00021c0d, 0x00021d0d,
		       0x00021e0d, 0x00021f0d, 0x0002200d, 0x0002210d,
		       0x0002220d, 0x0002230d, 0x0002240d, 0x0002250d,
		       0x0002260d, 0x0002270d, 0x0002280d, 0x0002290d,
		       0x00022a0d, 0x00022b0d, 0x00022c0d, 0x00022d0d,
		       0x00022e0d, 0x00022f0d, 0x0002300d, 0x0002310d,
		       0x0002320d, 0x0002330d, 0x0002340d, 0x0002350d,
		       0x0002360d, 0x0002370d, 0x0002380d, 0x0002390d,
		       0x00023a0d, 0x00023b0d, 0x00023c0d, 0x00023d0d,
		       0x00023e0d, 0x00023f0d, 0x0002400d, 0x0002410d,
		       0x0002420d, 0x0002430d, 0x0002440d, 0x0002450d,
		       0x0002460d, 0x0002470d, 0x0002480d, 0x0002490d,
		       0x00024a0d, 0x00024b0d, 0x00024c0d, 0x00024d0d,
		       0x00024e0d, 0x00024f0d, 0x0002500d, 0x0002510d,
		       0x0002520d, 0x0002530d, 0x0002540d, 0x0002550d,
		       0x0002560d, 0x0002570d, 0x0002580d, 0x0002590d,
		       0x00025a0d, 0x00025b0d, 0x00025c0d, 0x00025d0d,
		       0x00025e0d, 0x00025f0d, 0x0002600d, 0x0002610d,
		       0x0002620d, 0x0002630d, 0x0002640d, 0x0002650d,
		       0x0002660d, 0x0002670d, 0x0002680d, 0x0002690d,
		       0x00026a0d, 0x00026b0d, 0x00026c0d, 0x00026d0d,
		       0x00026e0d, 0x00026f0d, 0x0002700d, 0x0002710d,
		       0x0002720d, 0x0002730d, 0x0002740d, 0x0002750d,
		       0x0002760d, 0x0002770d, 0x0002780d, 0x0002790d,
		       0x00027a0d, 0x00027b0d, 0x00027c0d, 0x00027d0d,
		       0x00027e0d, 0x00027f0d, 0x0002800d, 0x0002810d,
		       0x0002820d, 0x0002830d, 0x0002840d, 0x0002850d,
		       0x0002860d, 0x0002870d, 0x0002880d, 0x0002890d,
		       0x00028a0d, 0x00028b0d, 0x00028c0d, 0x00028d0d,
		       0x00028e0d, 0x00028f0d, 0x0002900d, 0x0002910d,
		       0x0002920d, 0x0002930d, 0x0002940d, 0x0002950d,
		       0x0002960d, 0x0002970d, 0x0002980d, 0x0002990d,
		       0x00029a0d, 0x00029b0d, 0x00029c0d, 0x00029d0d,
		       0x00029e0d, 0x00029f0d, 0x0002a00d, 0x0002a10d,
		       0x0002a20d, 0x0002a30d, 0x0002a40d, 0x0002a50d,
		       0x0002a60d, 0x0002a70d, 0x0002a80d, 0x0002a90d,
		       0x0002aa0d, 0x0002ab0d, 0x0002ac0d, 0x0002ad0d,
		       0x0002ae0d, 0x0002af0d, 0x0002b00d, 0x0002b10d,
		       0x0002b20d, 0x0002b30d, 0x0002b40d, 0x0002b50d,
		       0x0002b60d, 0x0002b70d, 0x0002b80d, 0x0002b90d,
		       0x0002ba0d, 0x0002bb0d, 0x0002bc0d, 0x0002bd0d,
		       0x0002be0d, 0x0002bf0d, 0x0002c00d, 0x0002c10d,
		       0x0002c20d, 0x0002c30d, 0x0002c40d, 0x0002c50d,
		       0x0002c60d, 0x0002c70d, 0x0002c80d, 0x0002c90d,
		       0x0002ca0d, 0x0002cb0d, 0x0002cc0d, 0x0002cd0d,
		       0x0002ce0d, 0x0002cf0d, 0x0002d00d, 0x0002d10d,
		       0x0002d20d, 0x0002d30d, 0x0002d40d, 0x0002d50d,
		       0x0002d60d, 0x0002d70d, 0x0002d80d, 0x0002d90d,
		       0x0002da0d, 0x0002db0d, 0x0002dc0d, 0x0002dd0d,
		       0x0002de0d, 0x0002df0d, 0x0002e00d, 0x0002e10d,
		       0x0002e20d, 0x0002e30d, 0x0002e40d, 0x0002e50d,
		       0x0002e60d, 0x0002e70d, 0x0002e80d, 0x0002e90d,
		       0x0002ea0d, 0x0002eb0d, 0x0002ec0d, 0x0002ed0d,
		       0x0002ee0d, 0x0002ef0d, 0x0002f00d, 0x0002f10d,
		       0x0002f20d, 0x0002f30d, 0x0002f40d, 0x0002f50d,
		       0x0002f60d, 0x0002f70d, 0x0002f80d, 0x0002f90d,
		       0x0002fa0d, 0x0002fb0d, 0x0002fc0d, 0x0002fd0d,
		       0x0002fe0d, 0x0002ff0d, 0x0003000d, 0x0003010d,
		       0x0003020d, 0x0003030d, 0x0003040d, 0x0003050d,
		       0x0003060d, 0x0003070d, 0x0003080d, 0x0003090d,
		       0x00030a0d, 0x00030b0d, 0x00030c0d, 0x00030d0d,
		       0x00030e0d, 0x00030f0d, 0x0003100d, 0x0003110d,
		       0x0003120d, 0x0003130d, 0x0003140d, 0x0003150d,
		       0x0003160d, 0x0003170d, 0x0003180d, 0x0003190d,
		       0x00031a0d, 0x00031b0d, 0x00031c0d, 0x00031d0d,
		       0x00031e0d, 0x00031f0d, 0x0003200d, 0x0003210d,
		       0x0003220d, 0x0003230d, 0x0003240d, 0x0003250d,
		       0x0003260d, 0x0003270d, 0x0003280d, 0x0003290d,
		       0x00032a0d, 0x00032b0d, 0x00032c0d, 0x00032d0d,
		       0x00032e0d, 0x00032f0d, 0x0003300d, 0x0003310d,
		       0x0003320d, 0x0003330d, 0x0003340d, 0x0003350d,
		       0x0003360d, 0x0003370d, 0x0003380d, 0x0003390d,
		       0x00033a0d, 0x00033b0d, 0x00033c0d, 0x00033d0d,
		       0x00033e0d, 0x00033f0d, 0x0003400d, 0x0003410d,
		       0x0003420d, 0x0003430d, 0x0003440d, 0x0003450d,
		       0x0003460d, 0x0003470d, 0x0003480d, 0x0003490d,
		       0x00034a0d, 0x00034b0d, 0x00034c0d, 0x00034d0d,
		       0x00034e0d, 0x00034f0d, 0x0003500d, 0x0003510d,
		       0x0003520d, 0x0003530d, 0x0003540d, 0x0003550d,
		       0x0003560d, 0x0003570d, 0x0003580d, 0x0003590d,
		       0x00035a0d, 0x00035b0d, 0x00035c0d, 0x00035d0d,
		       0x00035e0d, 0x00035f0d, 0x0003600d, 0x0003610d,
		       0x0003620d, 0x0003630d, 0x0003640d, 0x0003650d,
		       0x0003660d, 0x0003670d, 0x0003680d, 0x0003690d,
		       0x00036a0d, 0x00036b0d, 0x00036c0d, 0x00036d0d,
		       0x00036e0d, 0x00036f0d, 0x0003700d, 0x0003710d,
		       0x0003720d, 0x0003730d, 0x0003740d, 0x0003750d,
		       0x0003760d, 0x0003770d, 0x0003780d, 0x0003790d,
		       0x00037a0d, 0x00037b0d, 0x00037c0d, 0x00037d0d,
		       0x00037e0d, 0x00037f0d, 0x0003800d, 0x0003810d,
		       0x0003820d, 0x0003830d, 0x0003840d, 0x0003850d,
		       0x0003860d, 0x0003870d, 0x0003880d, 0x0003890d,
		       0x00038a0d, 0x00038b0d, 0x00038c0d, 0x00038d0d,
		       0x00038e0d, 0x00038f0d, 0x0003900d, 0x0003910d,
		       0x0003920d, 0x0003930d, 0x0003940d, 0x0003950d,
		       0x0003960d, 0x0003970d, 0x0003980d, 0x0003990d,
		       0x00039a0d, 0x00039b0d, 0x00039c0d, 0x00039d0d,
		       0x00039e0d, 0x00039f0d, 0x0003a00d, 0x0003a10d,
		       0x0003a20d, 0x0003a30d, 0x0003a40d, 0x0003a50d,
		       0x0003a60d, 0x0003a70d, 0x0003a80d, 0x0003a90d,
		       0x0003aa0d, 0x0003ab0d, 0x0003ac0d, 0x0003ad0d,
		       0x0003ae0d, 0x0003af0d, 0x0003b00d, 0x0003b10d,
		       0x0003b20d, 0x0003b30d, 0x0003b40d, 0x0003b50d,
		       0x0003b60d, 0x0003b70d, 0x0003b80d, 0x0003b90d,
		       0x0003ba0d, 0x0003bb0d, 0x0003bc0d, 0x0003bd0d,
		       0x0003be0d, 0x0003bf0d, 0x0003c00d, 0x0003c10d,
		       0x0003c20d, 0x0003c30d, 0x0003c40d, 0x0003c50d,
		       0x0003c60d, 0x0003c70d, 0x0003c80d, 0x0003c90d,
		       0x0003ca0d, 0x0003cb0d, 0x0003cc0d, 0x0003cd0d,
		       0x0003ce0d, 0x0003cf0d, 0x0003d00d, 0x0003d10d,
		       0x0003d20d, 0x0003d30d, 0x0003d40d, 0x0003d50d,
		       0x0003d60d, 0x0003d70d, 0x0003d80d, 0x0003d90d,
		       0x0003da0d, 0x0003db0d, 0x0003dc0d, 0x0003dd0d,
		       0x0003de0d, 0x0003df0d, 0x0003e00d, 0x0003e10d,
		       0x0003e20d, 0x0003e30d, 0x0003e40d, 0x0003e50d,
		       0x0003e60d, 0x0003e70d, 0x0003e80d, 0x0003e90d,
		       0x0003ea0d, 0x0003eb0d, 0x0003ec0d, 0x0003ed0d,
		       0x0003ee0d, 0x0003ef0d, 0x0003f00d, 0x0003f10d,
		       0x0003f20d, 0x0003f30d, 0x0003f40d, 0x0003f50d,
		       0x0003f60d, 0x0003f70d, 0x0003f80d, 0x0003f90d,
		       0x0003fa0d, 0x0003fb0d, 0x0003fc0d, 0x0003fd0d,
		       0x0003fe0d, 0x0003ff0d, 0x000000ae, 0x000002ae,
		       0x000004ae, 0x000006ae, 0x000008ae, 0x00000aae,
		       0x00000cae, 0x00000eae, 0x000010ae, 0x000012ae,
		       0x000014ae, 0x000016ae, 0x000018ae, 0x00001aae,
		       0x00001cae, 0x00001eae, 0x000020ae, 0x000022ae,
		       0x000024ae, 0x000026ae, 0x000028ae, 0x00002aae,
		       0x00002cae, 0x00002eae, 0x000030ae, 0x000032ae,
		       0x000034ae, 0x000036ae, 0x000038ae, 0x00003aae,
		       0x00003cae, 0x00003eae, 0x000040ae, 0x000042ae,
		       0x000044ae, 0x000046ae, 0x000048ae, 0x00004aae,
		       0x00004cae, 0x00004eae, 0x000050ae, 0x000052ae,
		       0x000054ae, 0x000056ae, 0x000058ae, 0x00005aae,
		       0x00005cae, 0x00005eae, 0x000060ae, 0x000062ae,
		       0x000064ae, 0x000066ae, 0x000068ae, 0x00006aae,
		       0x00006cae, 0x00006eae, 0x000070ae, 0x000072ae,
		       0x000074ae, 0x000076ae, 0x000078ae, 0x00007aae,
		       0x00007cae, 0x00007eae, 0x000080ae, 0x000082ae,
		       0x000084ae, 0x000086ae, 0x000088ae, 0x00008aae,
		       0x00008cae, 0x00008eae, 0x000090ae, 0x000092ae,
		       0x000094ae, 0x000096ae, 0x000098ae, 0x00009aae,
		       0x00009cae, 0x00009eae, 0x0000a0ae, 0x0000a2ae,
		       0x0000a4ae, 0x0000a6ae, 0x0000a8ae, 0x0000aaae,
		       0x0000acae, 0x0000aeae, 0x0000b0ae, 0x0000b2ae,
		       0x0000b4ae, 0x0000b6ae, 0x0000b8ae, 0x0000baae,
		       0x0000bcae, 0x0000beae, 0x0000c0ae, 0x0000c2ae,
		       0x0000c4ae, 0x0000c6ae, 0x0000c8ae, 0x0000caae,
		       0x0000ccae, 0x0000ceae, 0x0000d0ae, 0x0000d2ae,
		       0x0000d4ae, 0x0000d6ae, 0x0000d8ae, 0x0000daae,
		       0x0000dcae, 0x0000deae, 0x0000e0ae, 0x0000e2ae,
		       0x0000e4ae, 0x0000e6ae, 0x0000e8ae, 0x0000eaae,
		       0x0000ecae, 0x0000eeae, 0x0000f0ae, 0x0000f2ae,
		       0x0000f4ae, 0x0000f6ae, 0x0000f8ae, 0x0000faae,
		       0x0000fcae, 0x0000feae, 0x000100ae, 0x000102ae,
		       0x000104ae, 0x000106ae, 0x000108ae, 0x00010aae,
		       0x00010cae, 0x00010eae, 0x000110ae, 0x000112ae,
		       0x000114ae, 0x000116ae, 0x000118ae, 0x00011aae,
		       0x00011cae, 0x00011eae, 0x000120ae, 0x000122ae,
		       0x000124ae, 0x000126ae, 0x000128ae, 0x00012aae,
		       0x00012cae, 0x00012eae, 0x000130ae, 0x000132ae,
		       0x000134ae, 0x000136ae, 0x000138ae, 0x00013aae,
		       0x00013cae, 0x00013eae, 0x000140ae, 0x000142ae,
		       0x000144ae, 0x000146ae, 0x000148ae, 0x00014aae,
		       0x00014cae, 0x00014eae, 0x000150ae, 0x000152ae,
		       0x000154ae, 0x000156ae, 0x000158ae, 0x00015aae,
		       0x00015cae, 0x00015eae, 0x000160ae, 0x000162ae,
		       0x000164ae, 0x000166ae, 0x000168ae, 0x00016aae,
		       0x00016cae, 0x00016eae, 0x000170ae, 0x000172ae,
		       0x000174ae, 0x000176ae, 0x000178ae, 0x00017aae,
		       0x00017cae, 0x00017eae, 0x000180ae, 0x000182ae,
		       0x000184ae, 0x000186ae, 0x000188ae, 0x00018aae,
		       0x00018cae, 0x00018eae, 0x000190ae, 0x000192ae,
		       0x000194ae, 0x000196ae, 0x000198ae, 0x00019aae,
		       0x00019cae, 0x00019eae, 0x0001a0ae, 0x0001a2ae,
		       0x0001a4ae, 0x0001a6ae, 0x0001a8ae, 0x0001aaae,
		       0x0001acae, 0x0001aeae, 0x0001b0ae, 0x0001b2ae,
		       0x0001b4ae, 0x0001b6ae, 0x0001b8ae, 0x0001baae,
		       0x0001bcae, 0x0001beae, 0x0001c0ae, 0x0001c2ae,
		       0x0001c4ae, 0x0001c6ae, 0x0001c8ae, 0x0001caae,
		       0x0001ccae, 0x0001ceae, 0x0001d0ae, 0x0001d2ae,
		       0x0001d4ae, 0x0001d6ae, 0x0001d8ae, 0x0001daae,
		       0x0001dcae, 0x0001deae, 0x0001e0ae, 0x0001e2ae,
		       0x0001e4ae, 0x0001e6ae, 0x0001e8ae, 0x0001eaae,
		       0x0001ecae, 0x0001eeae, 0x0001f0ae, 0x0001f2ae,
		       0x0001f4ae, 0x0001f6ae, 0x0001f8ae, 0x0001faae,
		       0x0001fcae, 0x0001feae, 0x000200ae, 0x000202ae,
		       0x000204ae, 0x000206ae, 0x000208ae, 0x00020aae,
		       0x00020cae, 0x00020eae, 0x000210ae, 0x000212ae,
		       0x000214ae, 0x000216ae, 0x000218ae, 0x00021aae,
		       0x00021cae, 0x00021eae, 0x000220ae, 0x000222ae,
		       0x000224ae, 0x000226ae, 0x000228ae, 0x00022aae,
		       0x00022cae, 0x00022eae, 0x000230ae, 0x000232ae,
		       0x000234ae, 0x000236ae, 0x000238ae, 0x00023aae,
		       0x00023cae, 0x00023eae, 0x000240ae, 0x000242ae,
		       0x000244ae, 0x000246ae, 0x000248ae, 0x00024aae,
		       0x00024cae, 0x00024eae, 0x000250ae, 0x000252ae,
		       0x000254ae, 0x000256ae, 0x000258ae, 0x00025aae,
		       0x00025cae, 0x00025eae, 0x000260ae, 0x000262ae,
		       0x000264ae, 0x000266ae, 0x000268ae, 0x00026aae,
		       0x00026cae, 0x00026eae, 0x000270ae, 0x000272ae,
		       0x000274ae, 0x000276ae, 0x000278ae, 0x00027aae,
		       0x00027cae, 0x00027eae, 0x000280ae, 0x000282ae,
		       0x000284ae, 0x000286ae, 0x000288ae, 0x00028aae,
		       0x00028cae, 0x00028eae, 0x000290ae, 0x000292ae,
		       0x000294ae, 0x000296ae, 0x000298ae, 0x00029aae,
		       0x00029cae, 0x00029eae, 0x0002a0ae, 0x0002a2ae,
		       0x0002a4ae, 0x0002a6ae, 0x0002a8ae, 0x0002aaae,
		       0x0002acae, 0x0002aeae, 0x0002b0ae, 0x0002b2ae,
		       0x0002b4ae, 0x0002b6ae, 0x0002b8ae, 0x0002baae,
		       0x0002bcae, 0x0002beae, 0x0002c0ae, 0x0002c2ae,
		       0x0002c4ae, 0x0002c6ae, 0x0002c8ae, 0x0002caae,
		       0x0002ccae, 0x0002ceae, 0x0002d0ae, 0x0002d2ae,
		       0x0002d4ae, 0x0002d6ae, 0x0002d8ae, 0x0002daae,
		       0x0002dcae, 0x0002deae, 0x0002e0ae, 0x0002e2ae,
		       0x0002e4ae, 0x0002e6ae, 0x0002e8ae, 0x0002eaae,
		       0x0002ecae, 0x0002eeae, 0x0002f0ae, 0x0002f2ae,
		       0x0002f4ae, 0x0002f6ae, 0x0002f8ae, 0x0002faae,
		       0x0002fcae, 0x0002feae, 0x000300ae, 0x000302ae,
		       0x000304ae, 0x000306ae, 0x000308ae, 0x00030aae,
		       0x00030cae, 0x00030eae, 0x000310ae, 0x000312ae,
		       0x000314ae, 0x000316ae, 0x000318ae, 0x00031aae,
		       0x00031cae, 0x00031eae, 0x000320ae, 0x000322ae,
		       0x000324ae, 0x000326ae, 0x000328ae, 0x00032aae,
		       0x00032cae, 0x00032eae, 0x000330ae, 0x000332ae,
		       0x000334ae, 0x000336ae, 0x000338ae, 0x00033aae,
		       0x00033cae, 0x00033eae, 0x000340ae, 0x000342ae,
		       0x000344ae, 0x000346ae, 0x000348ae, 0x00034aae,
		       0x00034cae, 0x00034eae, 0x000350ae, 0x000352ae,
		       0x000354ae, 0x000356ae, 0x000358ae, 0x00035aae,
		       0x00035cae, 0x00035eae, 0x000360ae, 0x000362ae,
		       0x000364ae, 0x000366ae, 0x000368ae, 0x00036aae,
		       0x00036cae, 0x00036eae, 0x000370ae, 0x000372ae,
		       0x000374ae, 0x000376ae, 0x000378ae, 0x00037aae,
		       0x00037cae, 0x00037eae, 0x000380ae, 0x000382ae,
		       0x000384ae, 0x000386ae, 0x000388ae, 0x00038aae,
		       0x00038cae, 0x00038eae, 0x000390ae, 0x000392ae,
		       0x000394ae, 0x000396ae, 0x000398ae, 0x00039aae,
		       0x00039cae, 0x00039eae, 0x0003a0ae, 0x0003a2ae,
		       0x0003a4ae, 0x0003a6ae, 0x0003a8ae, 0x0003aaae,
		       0x0003acae, 0x0003aeae, 0x0003b0ae, 0x0003b2ae,
		       0x0003b4ae, 0x0003b6ae, 0x0003b8ae, 0x0003baae,
		       0x0003bcae, 0x0003beae, 0x0003c0ae, 0x0003c2ae,
		       0x0003c4ae, 0x0003c6ae, 0x0003c8ae, 0x0003caae,
		       0x0003ccae, 0x0003ceae, 0x0003d0ae, 0x0003d2ae,
		       0x0003d4ae, 0x0003d6ae, 0x0003d8ae, 0x0003daae,
		       0x0003dcae, 0x0003deae, 0x0003e0ae, 0x0003e2ae,
		       0x0003e4ae, 0x0003e6ae, 0x0003e8ae, 0x0003eaae,
		       0x0003ecae, 0x0003eeae, 0x0003f0ae, 0x0003f2ae,
		       0x0003f4ae, 0x0003f6ae, 0x0003f8ae, 0x0003faae,
		       0x0003fcae, 0x0003feae, 0x000400ae, 0x000402ae,
		       0x000404ae, 0x000406ae, 0x000408ae, 0x00040aae,
		       0x00040cae, 0x00040eae, 0x000410ae, 0x000412ae,
		       0x000414ae, 0x000416ae, 0x000418ae, 0x00041aae,
		       0x00041cae, 0x00041eae, 0x000420ae, 0x000422ae,
		       0x000424ae, 0x000426ae, 0x000428ae, 0x00042aae,
		       0x00042cae, 0x00042eae, 0x000430ae, 0x000432ae,
		       0x000434ae, 0x000436ae, 0x000438ae, 0x00043aae,
		       0x00043cae, 0x00043eae, 0x000440ae, 0x000442ae,
		       0x000444ae, 0x000446ae, 0x000448ae, 0x00044aae,
		       0x00044cae, 0x00044eae, 0x000450ae, 0x000452ae,
		       0x000454ae, 0x000456ae, 0x000458ae, 0x00045aae,
		       0x00045cae, 0x00045eae, 0x000460ae, 0x000462ae,
		       0x000464ae, 0x000466ae, 0x000468ae, 0x00046aae,
		       0x00046cae, 0x00046eae, 0x000470ae, 0x000472ae,
		       0x000474ae, 0x000476ae, 0x000478ae, 0x00047aae,
		       0x00047cae, 0x00047eae, 0x000480ae, 0x000482ae,
		       0x000484ae, 0x000486ae, 0x000488ae, 0x00048aae,
		       0x00048cae, 0x00048eae, 0x000490ae, 0x000492ae,
		       0x000494ae, 0x000496ae, 0x000498ae, 0x00049aae,
		       0x00049cae, 0x00049eae, 0x0004a0ae, 0x0004a2ae,
		       0x0004a4ae, 0x0004a6ae, 0x0004a8ae, 0x0004aaae,
		       0x0004acae, 0x0004aeae, 0x0004b0ae, 0x0004b2ae,
		       0x0004b4ae, 0x0004b6ae, 0x0004b8ae, 0x0004baae,
		       0x0004bcae, 0x0004beae, 0x0004c0ae, 0x0004c2ae,
		       0x0004c4ae, 0x0004c6ae, 0x0004c8ae, 0x0004caae,
		       0x0004ccae, 0x0004ceae, 0x0004d0ae, 0x0004d2ae,
		       0x0004d4ae, 0x0004d6ae, 0x0004d8ae, 0x0004daae,
		       0x0004dcae, 0x0004deae, 0x0004e0ae, 0x0004e2ae,
		       0x0004e4ae, 0x0004e6ae, 0x0004e8ae, 0x0004eaae,
		       0x0004ecae, 0x0004eeae, 0x0004f0ae, 0x0004f2ae,
		       0x0004f4ae, 0x0004f6ae, 0x0004f8ae, 0x0004faae,
		       0x0004fcae, 0x0004feae, 0x000500ae, 0x000502ae,
		       0x000504ae, 0x000506ae, 0x000508ae, 0x00050aae,
		       0x00050cae, 0x00050eae, 0x000510ae, 0x000512ae,
		       0x000514ae, 0x000516ae, 0x000518ae, 0x00051aae,
		       0x00051cae, 0x00051eae, 0x000520ae, 0x000522ae,
		       0x000524ae, 0x000526ae, 0x000528ae, 0x00052aae,
		       0x00052cae, 0x00052eae, 0x000530ae, 0x000532ae,
		       0x000534ae, 0x000536ae, 0x000538ae, 0x00053aae,
		       0x00053cae, 0x00053eae, 0x000540ae, 0x000542ae,
		       0x000544ae, 0x000546ae, 0x000548ae, 0x00054aae,
		       0x00054cae, 0x00054eae, 0x000550ae, 0x000552ae,
		       0x000554ae, 0x000556ae, 0x000558ae, 0x00055aae,
		       0x00055cae, 0x00055eae, 0x000560ae, 0x000562ae,
		       0x000564ae, 0x000566ae, 0x000568ae, 0x00056aae,
		       0x00056cae, 0x00056eae, 0x000570ae, 0x000572ae,
		       0x000574ae, 0x000576ae, 0x000578ae, 0x00057aae,
		       0x00057cae, 0x00057eae, 0x000580ae, 0x000582ae,
		       0x000584ae, 0x000586ae, 0x000588ae, 0x00058aae,
		       0x00058cae, 0x00058eae, 0x000590ae, 0x000592ae,
		       0x000594ae, 0x000596ae, 0x000598ae, 0x00059aae,
		       0x00059cae, 0x00059eae, 0x0005a0ae, 0x0005a2ae,
		       0x0005a4ae, 0x0005a6ae, 0x0005a8ae, 0x0005aaae,
		       0x0005acae, 0x0005aeae, 0x0005b0ae, 0x0005b2ae,
		       0x0005b4ae, 0x0005b6ae, 0x0005b8ae, 0x0005baae,
		       0x0005bcae, 0x0005beae, 0x0005c0ae, 0x0005c2ae,
		       0x0005c4ae, 0x0005c6ae, 0x0005c8ae, 0x0005caae,
		       0x0005ccae, 0x0005ceae, 0x0005d0ae, 0x0005d2ae,
		       0x0005d4ae, 0x0005d6ae, 0x0005d8ae, 0x0005daae,
		       0x0005dcae, 0x0005deae, 0x0005e0ae, 0x0005e2ae,
		       0x0005e4ae, 0x0005e6ae, 0x0005e8ae, 0x0005eaae,
		       0x0005ecae, 0x0005eeae, 0x0005f0ae, 0x0005f2ae,
		       0x0005f4ae, 0x0005f6ae, 0x0005f8ae, 0x0005faae,
		       0x0005fcae, 0x0005feae, 0x000600ae, 0x000602ae,
		       0x000604ae, 0x000606ae, 0x000608ae, 0x00060aae,
		       0x00060cae, 0x00060eae, 0x000610ae, 0x000612ae,
		       0x000614ae, 0x000616ae, 0x000618ae, 0x00061aae,
		       0x00061cae, 0x00061eae, 0x000620ae, 0x000622ae,
		       0x000624ae, 0x000626ae, 0x000628ae, 0x00062aae,
		       0x00062cae, 0x00062eae, 0x000630ae, 0x000632ae,
		       0x000634ae, 0x000636ae, 0x000638ae, 0x00063aae,
		       0x00063cae, 0x00063eae, 0x000640ae, 0x000642ae,
		       0x000644ae, 0x000646ae, 0x000648ae, 0x00064aae,
		       0x00064cae, 0x00064eae, 0x000650ae, 0x000652ae,
		       0x000654ae, 0x000656ae, 0x000658ae, 0x00065aae,
		       0x00065cae, 0x00065eae, 0x000660ae, 0x000662ae,
		       0x000664ae, 0x000666ae, 0x000668ae, 0x00066aae,
		       0x00066cae, 0x00066eae, 0x000670ae, 0x000672ae,
		       0x000674ae, 0x000676ae, 0x000678ae, 0x00067aae,
		       0x00067cae, 0x00067eae, 0x000680ae, 0x000682ae,
		       0x000684ae, 0x000686ae, 0x000688ae, 0x00068aae,
		       0x00068cae, 0x00068eae, 0x000690ae, 0x000692ae,
		       0x000694ae, 0x000696ae, 0x000698ae, 0x00069aae,
		       0x00069cae, 0x00069eae, 0x0006a0ae, 0x0006a2ae,
		       0x0006a4ae, 0x0006a6ae, 0x0006a8ae, 0x0006aaae,
		       0x0006acae, 0x0006aeae, 0x0006b0ae, 0x0006b2ae,
		       0x0006b4ae, 0x0006b6ae, 0x0006b8ae, 0x0006baae,
		       0x0006bcae, 0x0006beae, 0x0006c0ae, 0x0006c2ae,
		       0x0006c4ae, 0x0006c6ae, 0x0006c8ae, 0x0006caae,
		       0x0006ccae, 0x0006ceae, 0x0006d0ae, 0x0006d2ae,
		       0x0006d4ae, 0x0006d6ae, 0x0006d8ae, 0x0006daae,
		       0x0006dcae, 0x0006deae, 0x0006e0ae, 0x0006e2ae,
		       0x0006e4ae, 0x0006e6ae, 0x0006e8ae, 0x0006eaae,
		       0x0006ecae, 0x0006eeae, 0x0006f0ae, 0x0006f2ae,
		       0x0006f4ae, 0x0006f6ae, 0x0006f8ae, 0x0006faae,
		       0x0006fcae, 0x0006feae, 0x000700ae, 0x000702ae,
		       0x000704ae, 0x000706ae, 0x000708ae, 0x00070aae,
		       0x00070cae, 0x00070eae, 0x000710ae, 0x000712ae,
		       0x000714ae, 0x000716ae, 0x000718ae, 0x00071aae,
		       0x00071cae, 0x00071eae, 0x000720ae, 0x000722ae,
		       0x000724ae, 0x000726ae, 0x000728ae, 0x00072aae,
		       0x00072cae, 0x00072eae, 0x000730ae, 0x000732ae,
		       0x000734ae, 0x000736ae, 0x000738ae, 0x00073aae,
		       0x00073cae, 0x00073eae, 0x000740ae, 0x000742ae,
		       0x000744ae, 0x000746ae, 0x000748ae, 0x00074aae,
		       0x00074cae, 0x00074eae, 0x000750ae, 0x000752ae,
		       0x000754ae, 0x000756ae, 0x000758ae, 0x00075aae,
		       0x00075cae, 0x00075eae, 0x000760ae, 0x000762ae,
		       0x000764ae, 0x000766ae, 0x000768ae, 0x00076aae,
		       0x00076cae, 0x00076eae, 0x000770ae, 0x000772ae,
		       0x000774ae, 0x000776ae, 0x000778ae, 0x00077aae,
		       0x00077cae, 0x00077eae, 0x000780ae, 0x000782ae,
		       0x000784ae, 0x000786ae, 0x000788ae, 0x00078aae,
		       0x00078cae, 0x00078eae, 0x000790ae, 0x000792ae,
		       0x000794ae, 0x000796ae, 0x000798ae, 0x00079aae,
		       0x00079cae, 0x00079eae, 0x0007a0ae, 0x0007a2ae,
		       0x0007a4ae, 0x0007a6ae, 0x0007a8ae, 0x0007aaae,
		       0x0007acae, 0x0007aeae, 0x0007b0ae, 0x0007b2ae,
		       0x0007b4ae, 0x0007b6ae, 0x0007b8ae, 0x0007baae,
		       0x0007bcae, 0x0007beae, 0x0007c0ae, 0x0007c2ae,
		       0x0007c4ae, 0x0007c6ae, 0x0007c8ae, 0x0007caae,
		       0x0007ccae, 0x0007ceae, 0x0007d0ae, 0x0007d2ae,
		       0x0007d4ae, 0x0007d6ae, 0x0007d8ae, 0x0007daae,
		       0x0007dcae, 0x0007deae, 0x0007e0ae, 0x0007e2ae,
		       0x0007e4ae, 0x0007e6ae, 0x0007e8ae, 0x0007eaae,
		       0x0007ecae, 0x0007eeae, 0x0007f0ae, 0x0007f2ae,
		       0x0007f4ae, 0x0007f6ae, 0x0007f8ae, 0x0007faae,
		       0x0007fcae, 0x0007feae, 0x000001af, 0x000003af,
		       0x000005af, 0x000007af, 0x000009af, 0x00000baf,
		       0x00000daf, 0x00000faf, 0x000011af, 0x000013af,
		       0x000015af, 0x000017af, 0x000019af, 0x00001baf,
		       0x00001daf, 0x00001faf, 0x000021af, 0x000023af,
		       0x000025af, 0x000027af, 0x000029af, 0x00002baf,
		       0x00002daf, 0x00002faf, 0x000031af, 0x000033af,
		       0x000035af, 0x000037af, 0x000039af, 0x00003baf,
		       0x00003daf, 0x00003faf, 0x000041af, 0x000043af,
		       0x000045af, 0x000047af, 0x000049af, 0x00004baf,
		       0x00004daf, 0x00004faf, 0x000051af, 0x000053af,
		       0x000055af, 0x000057af, 0x000059af, 0x00005baf,
		       0x00005daf, 0x00005faf, 0x000061af, 0x000063af,
		       0x000065af, 0x000067af, 0x000069af, 0x00006baf,
		       0x00006daf, 0x00006faf, 0x000071af, 0x000073af,
		       0x000075af, 0x000077af, 0x000079af, 0x00007baf,
		       0x00007daf, 0x00007faf, 0x000081af, 0x000083af,
		       0x000085af, 0x000087af, 0x000089af, 0x00008baf,
		       0x00008daf, 0x00008faf, 0x000091af, 0x000093af,
		       0x000095af, 0x000097af, 0x000099af, 0x00009baf,
		       0x00009daf, 0x00009faf, 0x0000a1af, 0x0000a3af,
		       0x0000a5af, 0x0000a7af, 0x0000a9af, 0x0000abaf,
		       0x0000adaf, 0x0000afaf, 0x0000b1af, 0x0000b3af,
		       0x0000b5af, 0x0000b7af, 0x0000b9af, 0x0000bbaf,
		       0x0000bdaf, 0x0000bfaf, 0x0000c1af, 0x0000c3af,
		       0x0000c5af, 0x0000c7af, 0x0000c9af, 0x0000cbaf,
		       0x0000cdaf, 0x0000cfaf, 0x0000d1af, 0x0000d3af,
		       0x0000d5af, 0x0000d7af, 0x0000d9af, 0x0000dbaf,
		       0x0000ddaf, 0x0000dfaf, 0x0000e1af, 0x0000e3af,
		       0x0000e5af, 0x0000e7af, 0x0000e9af, 0x0000ebaf,
		       0x0000edaf, 0x0000efaf, 0x0000f1af, 0x0000f3af,
		       0x0000f5af, 0x0000f7af, 0x0000f9af, 0x0000fbaf,
		       0x0000fdaf, 0x0000ffaf, 0x000101af, 0x000103af,
		       0x000105af, 0x000107af, 0x000109af, 0x00010baf,
		       0x00010daf, 0x00010faf, 0x000111af, 0x000113af,
		       0x000115af, 0x000117af, 0x000119af, 0x00011baf,
		       0x00011daf, 0x00011faf, 0x000121af, 0x000123af,
		       0x000125af, 0x000127af, 0x000129af, 0x00012baf,
		       0x00012daf, 0x00012faf, 0x000131af, 0x000133af,
		       0x000135af, 0x000137af, 0x000139af, 0x00013baf,
		       0x00013daf, 0x00013faf, 0x000141af, 0x000143af,
		       0x000145af, 0x000147af, 0x000149af, 0x00014baf,
		       0x00014daf, 0x00014faf, 0x000151af, 0x000153af,
		       0x000155af, 0x000157af, 0x000159af, 0x00015baf,
		       0x00015daf, 0x00015faf, 0x000161af, 0x000163af,
		       0x000165af, 0x000167af, 0x000169af, 0x00016baf,
		       0x00016daf, 0x00016faf, 0x000171af, 0x000173af,
		       0x000175af, 0x000177af, 0x000179af, 0x00017baf,
		       0x00017daf, 0x00017faf, 0x000181af, 0x000183af,
		       0x000185af, 0x000187af, 0x000189af, 0x00018baf,
		       0x00018daf, 0x00018faf, 0x000191af, 0x000193af,
		       0x000195af, 0x000197af, 0x000199af, 0x00019baf,
		       0x00019daf, 0x00019faf, 0x0001a1af, 0x0001a3af,
		       0x0001a5af, 0x0001a7af, 0x0001a9af, 0x0001abaf,
		       0x0001adaf, 0x0001afaf, 0x0001b1af, 0x0001b3af,
		       0x0001b5af, 0x0001b7af, 0x0001b9af, 0x0001bbaf,
		       0x0001bdaf, 0x0001bfaf, 0x0001c1af, 0x0001c3af,
		       0x0001c5af, 0x0001c7af, 0x0001c9af, 0x0001cbaf,
		       0x0001cdaf, 0x0001cfaf, 0x0001d1af, 0x0001d3af,
		       0x0001d5af, 0x0001d7af, 0x0001d9af, 0x0001dbaf,
		       0x0001ddaf, 0x0001dfaf, 0x0001e1af, 0x0001e3af,
		       0x0001e5af, 0x0001e7af, 0x0001e9af, 0x0001ebaf,
		       0x0001edaf, 0x0001efaf, 0x0001f1af, 0x0001f3af,
		       0x0001f5af, 0x0001f7af, 0x0001f9af, 0x0001fbaf,
		       0x0001fdaf, 0x0001ffaf, 0x000201af, 0x000203af,
		       0x000205af, 0x000207af, 0x000209af, 0x00020baf,
		       0x00020daf, 0x00020faf, 0x000211af, 0x000213af,
		       0x000215af, 0x000217af, 0x000219af, 0x00021baf,
		       0x00021daf, 0x00021faf, 0x000221af, 0x000223af,
		       0x000225af, 0x000227af, 0x000229af, 0x00022baf,
		       0x00022daf, 0x00022faf, 0x000231af, 0x000233af,
		       0x000235af, 0x000237af, 0x000239af, 0x00023baf,
		       0x00023daf, 0x00023faf, 0x000241af, 0x000243af,
		       0x000245af, 0x000247af, 0x000249af, 0x00024baf,
		       0x00024daf, 0x00024faf, 0x000251af, 0x000253af,
		       0x000255af, 0x000257af, 0x000259af, 0x00025baf,
		       0x00025daf, 0x00025faf, 0x000261af, 0x000263af,
		       0x000265af, 0x000267af, 0x000269af, 0x00026baf,
		       0x00026daf, 0x00026faf, 0x000271af, 0x000273af,
		       0x000275af, 0x000277af, 0x000279af, 0x00027baf,
		       0x00027daf, 0x00027faf, 0x000281af, 0x000283af,
		       0x000285af, 0x000287af, 0x000289af, 0x00028baf,
		       0x00028daf, 0x00028faf, 0x000291af, 0x000293af,
		       0x000295af, 0x000297af, 0x000299af, 0x00029baf,
		       0x00029daf, 0x00029faf, 0x0002a1af, 0x0002a3af,
		       0x0002a5af, 0x0002a7af, 0x0002a9af, 0x0002abaf,
		       0x0002adaf, 0x0002afaf, 0x0002b1af, 0x0002b3af,
		       0x0002b5af, 0x0002b7af, 0x0002b9af, 0x0002bbaf,
		       0x0002bdaf, 0x0002bfaf, 0x0002c1af, 0x0002c3af,
		       0x0002c5af, 0x0002c7af, 0x0002c9af, 0x0002cbaf,
		       0x0002cdaf, 0x0002cfaf, 0x0002d1af, 0x0002d3af,
		       0x0002d5af, 0x0002d7af, 0x0002d9af, 0x0002dbaf,
		       0x0002ddaf, 0x0002dfaf, 0x0002e1af, 0x0002e3af,
		       0x0002e5af, 0x0002e7af, 0x0002e9af, 0x0002ebaf,
		       0x0002edaf, 0x0002efaf, 0x0002f1af, 0x0002f3af,
		       0x0002f5af, 0x0002f7af, 0x0002f9af, 0x0002fbaf,
		       0x0002fdaf, 0x0002ffaf, 0x000301af, 0x000303af,
		       0x000305af, 0x000307af, 0x000309af, 0x00030baf,
		       0x00030daf, 0x00030faf, 0x000311af, 0x000313af,
		       0x000315af, 0x000317af, 0x000319af, 0x00031baf,
		       0x00031daf, 0x00031faf, 0x000321af, 0x000323af,
		       0x000325af, 0x000327af, 0x000329af, 0x00032baf,
		       0x00032daf, 0x00032faf, 0x000331af, 0x000333af,
		       0x000335af, 0x000337af, 0x000339af, 0x00033baf,
		       0x00033daf, 0x00033faf, 0x000341af, 0x000343af,
		       0x000345af, 0x000347af, 0x000349af, 0x00034baf,
		       0x00034daf, 0x00034faf, 0x000351af, 0x000353af,
		       0x000355af, 0x000357af, 0x000359af, 0x00035baf,
		       0x00035daf, 0x00035faf, 0x000361af, 0x000363af,
		       0x000365af, 0x000367af, 0x000369af, 0x00036baf,
		       0x00036daf, 0x00036faf, 0x000371af, 0x000373af,
		       0x000375af, 0x000377af, 0x000379af, 0x00037baf,
		       0x00037daf, 0x00037faf, 0x000381af, 0x000383af,
		       0x000385af, 0x000387af, 0x000389af, 0x00038baf,
		       0x00038daf, 0x00038faf, 0x000391af, 0x000393af,
		       0x000395af, 0x000397af, 0x000399af, 0x00039baf,
		       0x00039daf, 0x00039faf, 0x0003a1af, 0x0003a3af,
		       0x0003a5af, 0x0003a7af, 0x0003a9af, 0x0003abaf,
		       0x0003adaf, 0x0003afaf, 0x0003b1af, 0x0003b3af,
		       0x0003b5af, 0x0003b7af, 0x0003b9af, 0x0003bbaf,
		       0x0003bdaf, 0x0003bfaf, 0x0003c1af, 0x0003c3af,
		       0x0003c5af, 0x0003c7af, 0x0003c9af, 0x0003cbaf,
		       0x0003cdaf, 0x0003cfaf, 0x0003d1af, 0x0003d3af,
		       0x0003d5af, 0x0003d7af, 0x0003d9af, 0x0003dbaf,
		       0x0003ddaf, 0x0003dfaf, 0x0003e1af, 0x0003e3af,
		       0x0003e5af, 0x0003e7af, 0x0003e9af, 0x0003ebaf,
		       0x0003edaf, 0x0003efaf, 0x0003f1af, 0x0003f3af,
		       0x0003f5af, 0x0003f7af, 0x0003f9af, 0x0003fbaf,
		       0x0003fdaf, 0x0003ffaf, 0x000401af, 0x000403af,
		       0x000405af, 0x000407af, 0x000409af, 0x00040baf,
		       0x00040daf, 0x00040faf, 0x000411af, 0x000413af,
		       0x000415af, 0x000417af, 0x000419af, 0x00041baf,
		       0x00041daf, 0x00041faf, 0x000421af, 0x000423af,
		       0x000425af, 0x000427af, 0x000429af, 0x00042baf,
		       0x00042daf, 0x00042faf, 0x000431af, 0x000433af,
		       0x000435af, 0x000437af, 0x000439af, 0x00043baf,
		       0x00043daf, 0x00043faf, 0x000441af, 0x000443af,
		       0x000445af, 0x000447af, 0x000449af, 0x00044baf,
		       0x00044daf, 0x00044faf, 0x000451af, 0x000453af,
		       0x000455af, 0x000457af, 0x000459af, 0x00045baf,
		       0x00045daf, 0x00045faf, 0x000461af, 0x000463af,
		       0x000465af, 0x000467af, 0x000469af, 0x00046baf,
		       0x00046daf, 0x00046faf, 0x000471af, 0x000473af,
		       0x000475af, 0x000477af, 0x000479af, 0x00047baf,
		       0x00047daf, 0x00047faf, 0x000481af, 0x000483af,
		       0x000485af, 0x000487af, 0x000489af, 0x00048baf,
		       0x00048daf, 0x00048faf, 0x000491af, 0x000493af,
		       0x000495af, 0x000497af, 0x000499af, 0x00049baf,
		       0x00049daf, 0x00049faf, 0x0004a1af, 0x0004a3af,
		       0x0004a5af, 0x0004a7af, 0x0004a9af, 0x0004abaf,
		       0x0004adaf, 0x0004afaf, 0x0004b1af, 0x0004b3af,
		       0x0004b5af, 0x0004b7af, 0x0004b9af, 0x0004bbaf,
		       0x0004bdaf, 0x0004bfaf, 0x0004c1af, 0x0004c3af,
		       0x0004c5af, 0x0004c7af, 0x0004c9af, 0x0004cbaf,
		       0x0004cdaf, 0x0004cfaf, 0x0004d1af, 0x0004d3af,
		       0x0004d5af, 0x0004d7af, 0x0004d9af, 0x0004dbaf,
		       0x0004ddaf, 0x0004dfaf, 0x0004e1af, 0x0004e3af,
		       0x0004e5af, 0x0004e7af, 0x0004e9af, 0x0004ebaf,
		       0x0004edaf, 0x0004efaf, 0x0004f1af, 0x0004f3af,
		       0x0004f5af, 0x0004f7af, 0x0004f9af, 0x0004fbaf,
		       0x0004fdaf, 0x0004ffaf, 0x000501af, 0x000503af,
		       0x000505af, 0x000507af, 0x000509af, 0x00050baf,
		       0x00050daf, 0x00050faf, 0x000511af, 0x000513af,
		       0x000515af, 0x000517af, 0x000519af, 0x00051baf,
		       0x00051daf, 0x00051faf, 0x000521af, 0x000523af,
		       0x000525af, 0x000527af, 0x000529af, 0x00052baf,
		       0x00052daf, 0x00052faf, 0x000531af, 0x000533af,
		       0x000535af, 0x000537af, 0x000539af, 0x00053baf,
		       0x00053daf, 0x00053faf, 0x000541af, 0x000543af,
		       0x000545af, 0x000547af, 0x000549af, 0x00054baf,
		       0x00054daf, 0x00054faf, 0x000551af, 0x000553af,
		       0x000555af, 0x000557af, 0x000559af, 0x00055baf,
		       0x00055daf, 0x00055faf, 0x000561af, 0x000563af,
		       0x000565af, 0x000567af, 0x000569af, 0x00056baf,
		       0x00056daf, 0x00056faf, 0x000571af, 0x000573af,
		       0x000575af, 0x000577af, 0x000579af, 0x00057baf,
		       0x00057daf, 0x00057faf, 0x000581af, 0x000583af,
		       0x000585af, 0x000587af, 0x000589af, 0x00058baf,
		       0x00058daf, 0x00058faf, 0x000591af, 0x000593af,
		       0x000595af, 0x000597af, 0x000599af, 0x00059baf,
		       0x00059daf, 0x00059faf, 0x0005a1af, 0x0005a3af,
		       0x0005a5af, 0x0005a7af, 0x0005a9af, 0x0005abaf,
		       0x0005adaf, 0x0005afaf, 0x0005b1af, 0x0005b3af,
		       0x0005b5af, 0x0005b7af, 0x0005b9af, 0x0005bbaf,
		       0x0005bdaf, 0x0005bfaf, 0x0005c1af, 0x0005c3af,
		       0x0005c5af, 0x0005c7af, 0x0005c9af, 0x0005cbaf,
		       0x0005cdaf, 0x0005cfaf, 0x0005d1af, 0x0005d3af,
		       0x0005d5af, 0x0005d7af, 0x0005d9af, 0x0005dbaf,
		       0x0005ddaf, 0x0005dfaf, 0x0005e1af, 0x0005e3af,
		       0x0005e5af, 0x0005e7af, 0x0005e9af, 0x0005ebaf,
		       0x0005edaf, 0x0005efaf, 0x0005f1af, 0x0005f3af,
		       0x0005f5af, 0x0005f7af, 0x0005f9af, 0x0005fbaf,
		       0x0005fdaf, 0x0005ffaf, 0x000601af, 0x000603af,
		       0x000605af, 0x000607af, 0x000609af, 0x00060baf,
		       0x00060daf, 0x00060faf, 0x000611af, 0x000613af,
		       0x000615af, 0x000617af, 0x000619af, 0x00061baf,
		       0x00061daf, 0x00061faf, 0x000621af, 0x000623af,
		       0x000625af, 0x000627af, 0x000629af, 0x00062baf,
		       0x00062daf, 0x00062faf, 0x000631af, 0x000633af,
		       0x000635af, 0x000637af, 0x000639af, 0x00063baf,
		       0x00063daf, 0x00063faf, 0x000641af, 0x000643af,
		       0x000645af, 0x000647af, 0x000649af, 0x00064baf,
		       0x00064daf, 0x00064faf, 0x000651af, 0x000653af,
		       0x000655af, 0x000657af, 0x000659af, 0x00065baf,
		       0x00065daf, 0x00065faf, 0x000661af, 0x000663af,
		       0x000665af, 0x000667af, 0x000669af, 0x00066baf,
		       0x00066daf, 0x00066faf, 0x000671af, 0x000673af,
		       0x000675af, 0x000677af, 0x000679af, 0x00067baf,
		       0x00067daf, 0x00067faf, 0x000681af, 0x000683af,
		       0x000685af, 0x000687af, 0x000689af, 0x00068baf,
		       0x00068daf, 0x00068faf, 0x000691af, 0x000693af,
		       0x000695af, 0x000697af, 0x000699af, 0x00069baf,
		       0x00069daf, 0x00069faf, 0x0006a1af, 0x0006a3af,
		       0x0006a5af, 0x0006a7af, 0x0006a9af, 0x0006abaf,
		       0x0006adaf, 0x0006afaf, 0x0006b1af, 0x0006b3af,
		       0x0006b5af, 0x0006b7af, 0x0006b9af, 0x0006bbaf,
		       0x0006bdaf, 0x0006bfaf, 0x0006c1af, 0x0006c3af,
		       0x0006c5af, 0x0006c7af, 0x0006c9af, 0x0006cbaf,
		       0x0006cdaf, 0x0006cfaf, 0x0006d1af, 0x0006d3af,
		       0x0006d5af, 0x0006d7af, 0x0006d9af, 0x0006dbaf,
		       0x0006ddaf, 0x0006dfaf, 0x0006e1af, 0x0006e3af,
		       0x0006e5af, 0x0006e7af, 0x0006e9af, 0x0006ebaf,
		       0x0006edaf, 0x0006efaf, 0x0006f1af, 0x0006f3af,
		       0x0006f5af, 0x0006f7af, 0x0006f9af, 0x0006fbaf,
		       0x0006fdaf, 0x0006ffaf, 0x000701af, 0x000703af,
		       0x000705af, 0x000707af, 0x000709af, 0x00070baf,
		       0x00070daf, 0x00070faf, 0x000711af, 0x000713af,
		       0x000715af, 0x000717af, 0x000719af, 0x00071baf,
		       0x00071daf, 0x00071faf, 0x000721af, 0x000723af,
		       0x000725af, 0x000727af, 0x000729af, 0x00072baf,
		       0x00072daf, 0x00072faf, 0x000731af, 0x000733af,
		       0x000735af, 0x000737af, 0x000739af, 0x00073baf,
		       0x00073daf, 0x00073faf, 0x000741af, 0x000743af,
		       0x000745af, 0x000747af, 0x000749af, 0x00074baf,
		       0x00074daf, 0x00074faf, 0x000751af, 0x000753af,
		       0x000755af, 0x000757af, 0x000759af, 0x00075baf,
		       0x00075daf, 0x00075faf, 0x000761af, 0x000763af,
		       0x000765af, 0x000767af, 0x000769af, 0x00076baf,
		       0x00076daf, 0x00076faf, 0x000771af, 0x000773af,
		       0x000775af, 0x000777af, 0x000779af, 0x00077baf,
		       0x00077daf, 0x00077faf, 0x000781af, 0x000783af,
		       0x000785af, 0x000787af, 0x000789af, 0x00078baf,
		       0x00078daf, 0x00078faf, 0x000791af, 0x000793af,
		       0x000795af, 0x000797af, 0x000799af, 0x00079baf,
		       0x00079daf, 0x00079faf, 0x0007a1af, 0x0007a3af,
		       0x0007a5af, 0x0007a7af, 0x0007a9af, 0x0007abaf,
		       0x0007adaf, 0x0007afaf, 0x0007b1af, 0x0007b3af,
		       0x0007b5af, 0x0007b7af, 0x0007b9af, 0x0007bbaf,
		       0x0007bdaf, 0x0007bfaf, 0x0007c1af, 0x0007c3af,
		       0x0007c5af, 0x0007c7af, 0x0007c9af, 0x0007cbaf,
		       0x0007cdaf, 0x0007cfaf, 0x0007d1af, 0x0007d3af,
		       0x0007d5af, 0x0007d7af, 0x0007d9af, 0x0007dbaf,
		       0x0007ddaf, 0x0007dfaf, 0x0007e1af, 0x0007e3af,
		       0x0007e5af, 0x0007e7af, 0x0007e9af, 0x0007ebaf,
		       0x0007edaf, 0x0007efaf, 0x0007f1af, 0x0007f3af,
		       0x0007f5af, 0x0007f7af, 0x0007f9af, 0x0007fbaf,
		       0x0007fdaf, 0x0007ffaf, 0x000801af, 0x000803af,
		       0x000805af, 0x000807af, 0x000809af, 0x00080baf,
		       0x00080daf, 0x00080faf, 0x000811af, 0x000813af,
		       0x000815af, 0x000817af, 0x000819af, 0x00081baf,
		       0x00081daf, 0x00081faf, 0x000821af, 0x000823af,
		       0x000825af, 0x000827af, 0x000829af, 0x00082baf,
		       0x00082daf, 0x00082faf, 0x000831af, 0x000833af,
		       0x000835af, 0x000837af, 0x000839af, 0x00083baf,
		       0x00083daf, 0x00083faf, 0x000841af, 0x000843af,
		       0x000845af, 0x000847af, 0x000849af, 0x00084baf,
		       0x00084daf, 0x00084faf, 0x000851af, 0x000853af,
		       0x000855af, 0x000857af, 0x000859af, 0x00085baf,
		       0x00085daf, 0x00085faf, 0x000861af, 0x000863af,
		       0x000865af, 0x000867af, 0x000869af, 0x00086baf,
		       0x00086daf, 0x00086faf, 0x000871af, 0x000873af,
		       0x000875af, 0x000877af, 0x000879af, 0x00087baf,
		       0x00087daf, 0x00087faf, 0x000881af, 0x000883af,
		       0x000885af, 0x000887af, 0x000889af, 0x00088baf,
		       0x00088daf, 0x00088faf, 0x000891af, 0x000893af,
		       0x000895af, 0x000897af, 0x000899af, 0x00089baf,
		       0x00089daf, 0x00089faf, 0x0008a1af, 0x0008a3af,
		       0x0008a5af, 0x0008a7af, 0x0008a9af, 0x0008abaf,
		       0x0008adaf, 0x0008afaf, 0x0008b1af, 0x0008b3af,
		       0x0008b5af, 0x0008b7af, 0x0008b9af, 0x0008bbaf,
		       0x0008bdaf, 0x0008bfaf, 0x0008c1af, 0x0008c3af,
		       0x0008c5af, 0x0008c7af, 0x0008c9af, 0x0008cbaf,
		       0x0008cdaf, 0x0008cfaf, 0x0008d1af, 0x0008d3af,
		       0x0008d5af, 0x0008d7af, 0x0008d9af, 0x0008dbaf,
		       0x0008ddaf, 0x0008dfaf, 0x0008e1af, 0x0008e3af,
		       0x0008e5af, 0x0008e7af, 0x0008e9af, 0x0008ebaf,
		       0x0008edaf, 0x0008efaf, 0x0008f1af, 0x0008f3af,
		       0x0008f5af, 0x0008f7af, 0x0008f9af, 0x0008fbaf,
		       0x0008fdaf, 0x0008ffaf, 0x000901af, 0x000903af,
		       0x000905af, 0x000907af, 0x000909af, 0x00090baf,
		       0x00090daf, 0x00090faf, 0x000911af, 0x000913af,
		       0x000915af, 0x000917af, 0x000919af, 0x00091baf,
		       0x00091daf, 0x00091faf, 0x000921af, 0x000923af,
		       0x000925af, 0x000927af, 0x000929af, 0x00092baf,
		       0x00092daf, 0x00092faf, 0x000931af, 0x000933af,
		       0x000935af, 0x000937af, 0x000939af, 0x00093baf,
		       0x00093daf, 0x00093faf, 0x000941af, 0x000943af,
		       0x000945af, 0x000947af, 0x000949af, 0x00094baf,
		       0x00094daf, 0x00094faf, 0x000951af, 0x000953af,
		       0x000955af, 0x000957af, 0x000959af, 0x00095baf,
		       0x00095daf, 0x00095faf, 0x000961af, 0x000963af,
		       0x000965af, 0x000967af, 0x000969af, 0x00096baf,
		       0x00096daf, 0x00096faf, 0x000971af, 0x000973af,
		       0x000975af, 0x000977af, 0x000979af, 0x00097baf,
		       0x00097daf, 0x00097faf, 0x000981af, 0x000983af,
		       0x000985af, 0x000987af, 0x000989af, 0x00098baf,
		       0x00098daf, 0x00098faf, 0x000991af, 0x000993af,
		       0x000995af, 0x000997af, 0x000999af, 0x00099baf,
		       0x00099daf, 0x00099faf, 0x0009a1af, 0x0009a3af,
		       0x0009a5af, 0x0009a7af, 0x0009a9af, 0x0009abaf,
		       0x0009adaf, 0x0009afaf, 0x0009b1af, 0x0009b3af,
		       0x0009b5af, 0x0009b7af, 0x0009b9af, 0x0009bbaf,
		       0x0009bdaf, 0x0009bfaf, 0x0009c1af, 0x0009c3af,
		       0x0009c5af, 0x0009c7af, 0x0009c9af, 0x0009cbaf,
		       0x0009cdaf, 0x0009cfaf, 0x0009d1af, 0x0009d3af,
		       0x0009d5af, 0x0009d7af, 0x0009d9af, 0x0009dbaf,
		       0x0009ddaf, 0x0009dfaf, 0x0009e1af, 0x0009e3af,
		       0x0009e5af, 0x0009e7af, 0x0009e9af, 0x0009ebaf,
		       0x0009edaf, 0x0009efaf, 0x0009f1af, 0x0009f3af,
		       0x0009f5af, 0x0009f7af, 0x0009f9af, 0x0009fbaf,
		       0x0009fdaf, 0x0009ffaf, 0x000a01af, 0x000a03af,
		       0x000a05af, 0x000a07af, 0x000a09af, 0x000a0baf,
		       0x000a0daf, 0x000a0faf, 0x000a11af, 0x000a13af,
		       0x000a15af, 0x000a17af, 0x000a19af, 0x000a1baf,
		       0x000a1daf, 0x000a1faf, 0x000a21af, 0x000a23af,
		       0x000a25af, 0x000a27af, 0x000a29af, 0x000a2baf,
		       0x000a2daf, 0x000a2faf, 0x000a31af, 0x000a33af,
		       0x000a35af, 0x000a37af, 0x000a39af, 0x000a3baf,
		       0x000a3daf, 0x000a3faf, 0x000a41af, 0x000a43af,
		       0x000a45af, 0x000a47af, 0x000a49af, 0x000a4baf,
		       0x000a4daf, 0x000a4faf, 0x000a51af, 0x000a53af,
		       0x000a55af, 0x000a57af, 0x000a59af, 0x000a5baf,
		       0x000a5daf, 0x000a5faf, 0x000a61af, 0x000a63af,
		       0x000a65af, 0x000a67af, 0x000a69af, 0x000a6baf,
		       0x000a6daf, 0x000a6faf, 0x000a71af, 0x000a73af,
		       0x000a75af, 0x000a77af, 0x000a79af, 0x000a7baf,
		       0x000a7daf, 0x000a7faf, 0x000a81af, 0x000a83af,
		       0x000a85af, 0x000a87af, 0x000a89af, 0x000a8baf,
		       0x000a8daf, 0x000a8faf, 0x000a91af, 0x000a93af,
		       0x000a95af, 0x000a97af, 0x000a99af, 0x000a9baf,
		       0x000a9daf, 0x000a9faf, 0x000aa1af, 0x000aa3af,
		       0x000aa5af, 0x000aa7af, 0x000aa9af, 0x000aabaf,
		       0x000aadaf, 0x000aafaf, 0x000ab1af, 0x000ab3af,
		       0x000ab5af, 0x000ab7af, 0x000ab9af, 0x000abbaf,
		       0x000abdaf, 0x000abfaf, 0x000ac1af, 0x000ac3af,
		       0x000ac5af, 0x000ac7af, 0x000ac9af, 0x000acbaf,
		       0x000acdaf, 0x000acfaf, 0x000ad1af, 0x000ad3af,
		       0x000ad5af, 0x000ad7af, 0x000ad9af, 0x000adbaf,
		       0x000addaf, 0x000adfaf, 0x000ae1af, 0x000ae3af,
		       0x000ae5af, 0x000ae7af, 0x000ae9af, 0x000aebaf,
		       0x000aedaf, 0x000aefaf, 0x000af1af, 0x000af3af,
		       0x000af5af, 0x000af7af, 0x000af9af, 0x000afbaf,
		       0x000afdaf, 0x000affaf, 0x000b01af, 0x000b03af,
		       0x000b05af, 0x000b07af, 0x000b09af, 0x000b0baf,
		       0x000b0daf, 0x000b0faf, 0x000b11af, 0x000b13af,
		       0x000b15af, 0x000b17af, 0x000b19af, 0x000b1baf,
		       0x000b1daf, 0x000b1faf, 0x000b21af, 0x000b23af,
		       0x000b25af, 0x000b27af, 0x000b29af, 0x000b2baf,
		       0x000b2daf, 0x000b2faf, 0x000b31af, 0x000b33af,
		       0x000b35af, 0x000b37af, 0x000b39af, 0x000b3baf,
		       0x000b3daf, 0x000b3faf, 0x000b41af, 0x000b43af,
		       0x000b45af, 0x000b47af, 0x000b49af, 0x000b4baf,
		       0x000b4daf, 0x000b4faf, 0x000b51af, 0x000b53af,
		       0x000b55af, 0x000b57af, 0x000b59af, 0x000b5baf,
		       0x000b5daf, 0x000b5faf, 0x000b61af, 0x000b63af,
		       0x000b65af, 0x000b67af, 0x000b69af, 0x000b6baf,
		       0x000b6daf, 0x000b6faf, 0x000b71af, 0x000b73af,
		       0x000b75af, 0x000b77af, 0x000b79af, 0x000b7baf,
		       0x000b7daf, 0x000b7faf, 0x000b81af, 0x000b83af,
		       0x000b85af, 0x000b87af, 0x000b89af, 0x000b8baf,
		       0x000b8daf, 0x000b8faf, 0x000b91af, 0x000b93af,
		       0x000b95af, 0x000b97af, 0x000b99af, 0x000b9baf,
		       0x000b9daf, 0x000b9faf, 0x000ba1af, 0x000ba3af,
		       0x000ba5af, 0x000ba7af, 0x000ba9af, 0x000babaf,
		       0x000badaf, 0x000bafaf, 0x000bb1af, 0x000bb3af,
		       0x000bb5af, 0x000bb7af, 0x000bb9af, 0x000bbbaf,
		       0x000bbdaf, 0x000bbfaf, 0x000bc1af, 0x000bc3af,
		       0x000bc5af, 0x000bc7af, 0x000bc9af, 0x000bcbaf,
		       0x000bcdaf, 0x000bcfaf, 0x000bd1af, 0x000bd3af,
		       0x000bd5af, 0x000bd7af, 0x000bd9af, 0x000bdbaf,
		       0x000bddaf, 0x000bdfaf, 0x000be1af, 0x000be3af,
		       0x000be5af, 0x000be7af, 0x000be9af, 0x000bebaf,
		       0x000bedaf, 0x000befaf, 0x000bf1af, 0x000bf3af,
		       0x000bf5af, 0x000bf7af, 0x000bf9af, 0x000bfbaf,
		       0x000bfdaf, 0x000bffaf, 0x000c01af, 0x000c03af,
		       0x000c05af, 0x000c07af, 0x000c09af, 0x000c0baf,
		       0x000c0daf, 0x000c0faf, 0x000c11af, 0x000c13af,
		       0x000c15af, 0x000c17af, 0x000c19af, 0x000c1baf,
		       0x000c1daf, 0x000c1faf, 0x000c21af, 0x000c23af,
		       0x000c25af, 0x000c27af, 0x000c29af, 0x000c2baf,
		       0x000c2daf, 0x000c2faf, 0x000c31af, 0x000c33af,
		       0x000c35af, 0x000c37af, 0x000c39af, 0x000c3baf,
		       0x000c3daf, 0x000c3faf, 0x000c41af, 0x000c43af,
		       0x000c45af, 0x000c47af, 0x000c49af, 0x000c4baf,
		       0x000c4daf, 0x000c4faf, 0x000c51af, 0x000c53af,
		       0x000c55af, 0x000c57af, 0x000c59af, 0x000c5baf,
		       0x000c5daf, 0x000c5faf, 0x000c61af, 0x000c63af,
		       0x000c65af, 0x000c67af, 0x000c69af, 0x000c6baf,
		       0x000c6daf, 0x000c6faf, 0x000c71af, 0x000c73af,
		       0x000c75af, 0x000c77af, 0x000c79af, 0x000c7baf,
		       0x000c7daf, 0x000c7faf, 0x000c81af, 0x000c83af,
		       0x000c85af, 0x000c87af, 0x000c89af, 0x000c8baf,
		       0x000c8daf, 0x000c8faf, 0x000c91af, 0x000c93af,
		       0x000c95af, 0x000c97af, 0x000c99af, 0x000c9baf,
		       0x000c9daf, 0x000c9faf, 0x000ca1af, 0x000ca3af,
		       0x000ca5af, 0x000ca7af, 0x000ca9af, 0x000cabaf,
		       0x000cadaf, 0x000cafaf, 0x000cb1af, 0x000cb3af,
		       0x000cb5af, 0x000cb7af, 0x000cb9af, 0x000cbbaf,
		       0x000cbdaf, 0x000cbfaf, 0x000cc1af, 0x000cc3af,
		       0x000cc5af, 0x000cc7af, 0x000cc9af, 0x000ccbaf,
		       0x000ccdaf, 0x000ccfaf, 0x000cd1af, 0x000cd3af,
		       0x000cd5af, 0x000cd7af, 0x000cd9af, 0x000cdbaf,
		       0x000cddaf, 0x000cdfaf, 0x000ce1af, 0x000ce3af,
		       0x000ce5af, 0x000ce7af, 0x000ce9af, 0x000cebaf,
		       0x000cedaf, 0x000cefaf, 0x000cf1af, 0x000cf3af,
		       0x000cf5af, 0x000cf7af, 0x000cf9af, 0x000cfbaf,
		       0x000cfdaf, 0x000cffaf, 0x000d01af, 0x000d03af,
		       0x000d05af, 0x000d07af, 0x000d09af, 0x000d0baf,
		       0x000d0daf, 0x000d0faf, 0x000d11af, 0x000d13af,
		       0x000d15af, 0x000d17af, 0x000d19af, 0x000d1baf,
		       0x000d1daf, 0x000d1faf, 0x000d21af, 0x000d23af,
		       0x000d25af, 0x000d27af, 0x000d29af, 0x000d2baf,
		       0x000d2daf, 0x000d2faf, 0x000d31af, 0x000d33af,
		       0x000d35af, 0x000d37af, 0x000d39af, 0x000d3baf,
		       0x000d3daf, 0x000d3faf, 0x000d41af, 0x000d43af,
		       0x000d45af, 0x000d47af, 0x000d49af, 0x000d4baf,
		       0x000d4daf, 0x000d4faf, 0x000d51af, 0x000d53af,
		       0x000d55af, 0x000d57af, 0x000d59af, 0x000d5baf,
		       0x000d5daf, 0x000d5faf, 0x000d61af, 0x000d63af,
		       0x000d65af, 0x000d67af, 0x000d69af, 0x000d6baf,
		       0x000d6daf, 0x000d6faf, 0x000d71af, 0x000d73af,
		       0x000d75af, 0x000d77af, 0x000d79af, 0x000d7baf,
		       0x000d7daf, 0x000d7faf, 0x000d81af, 0x000d83af,
		       0x000d85af, 0x000d87af, 0x000d89af, 0x000d8baf,
		       0x000d8daf, 0x000d8faf, 0x000d91af, 0x000d93af,
		       0x000d95af, 0x000d97af, 0x000d99af, 0x000d9baf,
		       0x000d9daf, 0x000d9faf, 0x000da1af, 0x000da3af,
		       0x000da5af, 0x000da7af, 0x000da9af, 0x000dabaf,
		       0x000dadaf, 0x000dafaf, 0x000db1af, 0x000db3af,
		       0x000db5af, 0x000db7af, 0x000db9af, 0x000dbbaf,
		       0x000dbdaf, 0x000dbfaf, 0x000dc1af, 0x000dc3af,
		       0x000dc5af, 0x000dc7af, 0x000dc9af, 0x000dcbaf,
		       0x000dcdaf, 0x000dcfaf, 0x000dd1af, 0x000dd3af,
		       0x000dd5af, 0x000dd7af, 0x000dd9af, 0x000ddbaf,
		       0x000dddaf, 0x000ddfaf, 0x000de1af, 0x000de3af,
		       0x000de5af, 0x000de7af, 0x000de9af, 0x000debaf,
		       0x000dedaf, 0x000defaf, 0x000df1af, 0x000df3af,
		       0x000df5af, 0x000df7af, 0x000df9af, 0x000dfbaf,
		       0x000dfdaf, 0x000dffaf, 0x000e01af, 0x000e03af,
		       0x000e05af, 0x000e07af, 0x000e09af, 0x000e0baf,
		       0x000e0daf, 0x000e0faf, 0x000e11af, 0x000e13af,
		       0x000e15af, 0x000e17af, 0x000e19af, 0x000e1baf,
		       0x000e1daf, 0x000e1faf, 0x000e21af, 0x000e23af,
		       0x000e25af, 0x000e27af, 0x000e29af, 0x000e2baf,
		       0x000e2daf, 0x000e2faf, 0x000e31af, 0x000e33af,
		       0x000e35af, 0x000e37af, 0x000e39af, 0x000e3baf,
		       0x000e3daf, 0x000e3faf, 0x000e41af, 0x000e43af,
		       0x000e45af, 0x000e47af, 0x000e49af, 0x000e4baf,
		       0x000e4daf, 0x000e4faf, 0x000e51af, 0x000e53af,
		       0x000e55af, 0x000e57af, 0x000e59af, 0x000e5baf,
		       0x000e5daf, 0x000e5faf, 0x000e61af, 0x000e63af,
		       0x000e65af, 0x000e67af, 0x000e69af, 0x000e6baf,
		       0x000e6daf, 0x000e6faf, 0x000e71af, 0x000e73af,
		       0x000e75af, 0x000e77af, 0x000e79af, 0x000e7baf,
		       0x000e7daf, 0x000e7faf, 0x000e81af, 0x000e83af,
		       0x000e85af, 0x000e87af, 0x000e89af, 0x000e8baf,
		       0x000e8daf, 0x000e8faf, 0x000e91af, 0x000e93af,
		       0x000e95af, 0x000e97af, 0x000e99af, 0x000e9baf,
		       0x000e9daf, 0x000e9faf, 0x000ea1af, 0x000ea3af,
		       0x000ea5af, 0x000ea7af, 0x000ea9af, 0x000eabaf,
		       0x000eadaf, 0x000eafaf, 0x000eb1af, 0x000eb3af,
		       0x000eb5af, 0x000eb7af, 0x000eb9af, 0x000ebbaf,
		       0x000ebdaf, 0x000ebfaf, 0x000ec1af, 0x000ec3af,
		       0x000ec5af, 0x000ec7af, 0x000ec9af, 0x000ecbaf,
		       0x000ecdaf, 0x000ecfaf, 0x000ed1af, 0x000ed3af,
		       0x000ed5af, 0x000ed7af, 0x000ed9af, 0x000edbaf,
		       0x000eddaf, 0x000edfaf, 0x000ee1af, 0x000ee3af,
		       0x000ee5af, 0x000ee7af, 0x000ee9af, 0x000eebaf,
		       0x000eedaf, 0x000eefaf, 0x000ef1af, 0x000ef3af,
		       0x000ef5af, 0x000ef7af, 0x000ef9af, 0x000efbaf,
		       0x000efdaf, 0x000effaf, 0x000f01af, 0x000f03af,
		       0x000f05af, 0x000f07af, 0x000f09af, 0x000f0baf,
		       0x000f0daf, 0x000f0faf, 0x000f11af, 0x000f13af,
		       0x000f15af, 0x000f17af, 0x000f19af, 0x000f1baf,
		       0x000f1daf, 0x000f1faf, 0x000f21af, 0x000f23af,
		       0x000f25af, 0x000f27af, 0x000f29af, 0x000f2baf,
		       0x000f2daf, 0x000f2faf, 0x000f31af, 0x000f33af,
		       0x000f35af, 0x000f37af, 0x000f39af, 0x000f3baf,
		       0x000f3daf, 0x000f3faf, 0x000f41af, 0x000f43af,
		       0x000f45af, 0x000f47af, 0x000f49af, 0x000f4baf,
		       0x000f4daf, 0x000f4faf, 0x000f51af, 0x000f53af,
		       0x000f55af, 0x000f57af, 0x000f59af, 0x000f5baf,
		       0x000f5daf, 0x000f5faf, 0x000f61af, 0x000f63af,
		       0x000f65af, 0x000f67af, 0x000f69af, 0x000f6baf,
		       0x000f6daf, 0x000f6faf, 0x000f71af, 0x000f73af,
		       0x000f75af, 0x000f77af, 0x000f79af, 0x000f7baf,
		       0x000f7daf, 0x000f7faf, 0x000f81af, 0x000f83af,
		       0x000f85af, 0x000f87af, 0x000f89af, 0x000f8baf,
		       0x000f8daf, 0x000f8faf, 0x000f91af, 0x000f93af,
		       0x000f95af, 0x000f97af, 0x000f99af, 0x000f9baf,
		       0x000f9daf, 0x000f9faf, 0x000fa1af, 0x000fa3af,
		       0x000fa5af, 0x000fa7af, 0x000fa9af, 0x000fabaf,
		       0x000fadaf, 0x000fafaf, 0x000fb1af, 0x000fb3af,
		       0x000fb5af, 0x000fb7af, 0x000fb9af, 0x000fbbaf,
		       0x000fbdaf, 0x000fbfaf, 0x000fc1af, 0x000fc3af,
		       0x000fc5af, 0x000fc7af, 0x000fc9af, 0x000fcbaf,
		       0x000fcdaf, 0x000fcfaf, 0x000fd1af, 0x000fd3af,
		       0x000fd5af, 0x000fd7af, 0x000fd9af, 0x000fdbaf,
		       0x000fddaf, 0x000fdfaf, 0x000fe1af, 0x000fe3af,
		       0x000fe5af, 0x000fe7af, 0x000fe9af, 0x000febaf,
		       0x000fedaf, 0x000fefaf, 0x000ff1af, 0x000ff3af,
		       0x000ff5af, 0x000ff7af, 0x000ff9af, 0x000ffbaf,
		       0x000ffdaf, 0x000fffaf, 0x0000006f, 0x0000026f,
		       0x0000046f, 0x0000066f, 0x0000086f, 0x00000a6f,
		       0x00000c6f, 0x00000e6f, 0x0000106f, 0x0000126f,
		       0x0000146f, 0x0000166f, 0x0000186f, 0x00001a6f,
		       0x00001c6f, 0x00001e6f, 0x0000206f, 0x0000226f,
		       0x0000246f, 0x0000266f, 0x0000286f, 0x00002a6f,
		       0x00002c6f, 0x00002e6f, 0x0000306f, 0x0000326f,
		       0x0000346f, 0x0000366f, 0x0000386f, 0x00003a6f,
		       0x00003c6f, 0x00003e6f, 0x0000406f, 0x0000426f,
		       0x0000446f, 0x0000466f, 0x0000486f, 0x00004a6f,
		       0x00004c6f, 0x00004e6f, 0x0000506f, 0x0000526f,
		       0x0000546f, 0x0000566f, 0x0000586f, 0x00005a6f,
		       0x00005c6f, 0x00005e6f, 0x0000606f, 0x0000626f,
		       0x0000646f, 0x0000666f, 0x0000686f, 0x00006a6f,
		       0x00006c6f, 0x00006e6f, 0x0000706f, 0x0000726f,
		       0x0000746f, 0x0000766f, 0x0000786f, 0x00007a6f,
		       0x00007c6f, 0x00007e6f, 0x0000806f, 0x0000826f,
		       0x0000846f, 0x0000866f, 0x0000886f, 0x00008a6f,
		       0x00008c6f, 0x00008e6f, 0x0000906f, 0x0000926f,
		       0x0000946f, 0x0000966f, 0x0000986f, 0x00009a6f,
		       0x00009c6f, 0x00009e6f, 0x0000a06f, 0x0000a26f,
		       0x0000a46f, 0x0000a66f, 0x0000a86f, 0x0000aa6f,
		       0x0000ac6f, 0x0000ae6f, 0x0000b06f, 0x0000b26f,
		       0x0000b46f, 0x0000b66f, 0x0000b86f, 0x0000ba6f,
		       0x0000bc6f, 0x0000be6f, 0x0000c06f, 0x0000c26f,
		       0x0000c46f, 0x0000c66f, 0x0000c86f, 0x0000ca6f,
		       0x0000cc6f, 0x0000ce6f, 0x0000d06f, 0x0000d26f,
		       0x0000d46f, 0x0000d66f, 0x0000d86f, 0x0000da6f,
		       0x0000dc6f, 0x0000de6f, 0x0000e06f, 0x0000e26f,
		       0x0000e46f, 0x0000e66f, 0x0000e86f, 0x0000ea6f,
		       0x0000ec6f, 0x0000ee6f, 0x0000f06f, 0x0000f26f,
		       0x0000f46f, 0x0000f66f, 0x0000f86f, 0x0000fa6f,
		       0x0000fc6f, 0x0000fe6f, 0x0001006f, 0x0001026f,
		       0x0001046f, 0x0001066f, 0x0001086f, 0x00010a6f,
		       0x00010c6f, 0x00010e6f, 0x0001106f, 0x0001126f,
		       0x0001146f, 0x0001166f, 0x0001186f, 0x00011a6f,
		       0x00011c6f, 0x00011e6f, 0x0001206f, 0x0001226f,
		       0x0001246f, 0x0001266f, 0x0001286f, 0x00012a6f,
		       0x00012c6f, 0x00012e6f, 0x0001306f, 0x0001326f,
		       0x0001346f, 0x0001366f, 0x0001386f, 0x00013a6f,
		       0x00013c6f, 0x00013e6f, 0x0001406f, 0x0001426f,
		       0x0001446f, 0x0001466f, 0x0001486f, 0x00014a6f,
		       0x00014c6f, 0x00014e6f, 0x0001506f, 0x0001526f,
		       0x0001546f, 0x0001566f, 0x0001586f, 0x00015a6f,
		       0x00015c6f, 0x00015e6f, 0x0001606f, 0x0001626f,
		       0x0001646f, 0x0001666f, 0x0001686f, 0x00016a6f,
		       0x00016c6f, 0x00016e6f, 0x0001706f, 0x0001726f,
		       0x0001746f, 0x0001766f, 0x0001786f, 0x00017a6f,
		       0x00017c6f, 0x00017e6f, 0x0001806f, 0x0001826f,
		       0x0001846f, 0x0001866f, 0x0001886f, 0x00018a6f,
		       0x00018c6f, 0x00018e6f, 0x0001906f, 0x0001926f,
		       0x0001946f, 0x0001966f, 0x0001986f, 0x00019a6f,
		       0x00019c6f, 0x00019e6f, 0x0001a06f, 0x0001a26f,
		       0x0001a46f, 0x0001a66f, 0x0001a86f, 0x0001aa6f,
		       0x0001ac6f, 0x0001ae6f, 0x0001b06f, 0x0001b26f,
		       0x0001b46f, 0x0001b66f, 0x0001b86f, 0x0001ba6f,
		       0x0001bc6f, 0x0001be6f, 0x0001c06f, 0x0001c26f,
		       0x0001c46f, 0x0001c66f, 0x0001c86f, 0x0001ca6f,
		       0x0001cc6f, 0x0001ce6f, 0x0001d06f, 0x0001d26f,
		       0x0001d46f, 0x0001d66f, 0x0001d86f, 0x0001da6f,
		       0x0001dc6f, 0x0001de6f, 0x0001e06f, 0x0001e26f,
		       0x0001e46f, 0x0001e66f, 0x0001e86f, 0x0001ea6f,
		       0x0001ec6f, 0x0001ee6f, 0x0001f06f, 0x0001f26f,
		       0x0001f46f, 0x0001f66f, 0x0001f86f, 0x0001fa6f,
		       0x0001fc6f, 0x0001fe6f, 0x0002006f, 0x0002026f,
		       0x0002046f, 0x0002066f, 0x0002086f, 0x00020a6f,
		       0x00020c6f, 0x00020e6f, 0x0002106f, 0x0002126f,
		       0x0002146f, 0x0002166f, 0x0002186f, 0x00021a6f,
		       0x00021c6f, 0x00021e6f, 0x0002206f, 0x0002226f,
		       0x0002246f, 0x0002266f, 0x0002286f, 0x00022a6f,
		       0x00022c6f, 0x00022e6f, 0x0002306f, 0x0002326f,
		       0x0002346f, 0x0002366f, 0x0002386f, 0x00023a6f,
		       0x00023c6f, 0x00023e6f, 0x0002406f, 0x0002426f,
		       0x0002446f, 0x0002466f, 0x0002486f, 0x00024a6f,
		       0x00024c6f, 0x00024e6f, 0x0002506f, 0x0002526f,
		       0x0002546f, 0x0002566f, 0x0002586f, 0x00025a6f,
		       0x00025c6f, 0x00025e6f, 0x0002606f, 0x0002626f,
		       0x0002646f, 0x0002666f, 0x0002686f, 0x00026a6f,
		       0x00026c6f, 0x00026e6f, 0x0002706f, 0x0002726f,
		       0x0002746f, 0x0002766f, 0x0002786f, 0x00027a6f,
		       0x00027c6f, 0x00027e6f, 0x0002806f, 0x0002826f,
		       0x0002846f, 0x0002866f, 0x0002886f, 0x00028a6f,
		       0x00028c6f, 0x00028e6f, 0x0002906f, 0x0002926f,
		       0x0002946f, 0x0002966f, 0x0002986f, 0x00029a6f,
		       0x00029c6f, 0x00029e6f, 0x0002a06f, 0x0002a26f,
		       0x0002a46f, 0x0002a66f, 0x0002a86f, 0x0002aa6f,
		       0x0002ac6f, 0x0002ae6f, 0x0002b06f, 0x0002b26f,
		       0x0002b46f, 0x0002b66f, 0x0002b86f, 0x0002ba6f,
		       0x0002bc6f, 0x0002be6f, 0x0002c06f, 0x0002c26f,
		       0x0002c46f, 0x0002c66f, 0x0002c86f, 0x0002ca6f,
		       0x0002cc6f, 0x0002ce6f, 0x0002d06f, 0x0002d26f,
		       0x0002d46f, 0x0002d66f, 0x0002d86f, 0x0002da6f,
		       0x0002dc6f, 0x0002de6f, 0x0002e06f, 0x0002e26f,
		       0x0002e46f, 0x0002e66f, 0x0002e86f, 0x0002ea6f,
		       0x0002ec6f, 0x0002ee6f, 0x0002f06f, 0x0002f26f,
		       0x0002f46f, 0x0002f66f, 0x0002f86f, 0x0002fa6f,
		       0x0002fc6f, 0x0002fe6f, 0x0003006f, 0x0003026f,
		       0x0003046f, 0x0003066f, 0x0003086f, 0x00030a6f,
		       0x00030c6f, 0x00030e6f, 0x0003106f, 0x0003126f,
		       0x0003146f, 0x0003166f, 0x0003186f, 0x00031a6f,
		       0x00031c6f, 0x00031e6f, 0x0003206f, 0x0003226f,
		       0x0003246f, 0x0003266f, 0x0003286f, 0x00032a6f,
		       0x00032c6f, 0x00032e6f, 0x0003306f, 0x0003326f,
		       0x0003346f, 0x0003366f, 0x0003386f, 0x00033a6f,
		       0x00033c6f, 0x00033e6f, 0x0003406f, 0x0003426f,
		       0x0003446f, 0x0003466f, 0x0003486f, 0x00034a6f,
		       0x00034c6f, 0x00034e6f, 0x0003506f, 0x0003526f,
		       0x0003546f, 0x0003566f, 0x0003586f, 0x00035a6f,
		       0x00035c6f, 0x00035e6f, 0x0003606f, 0x0003626f,
		       0x0003646f, 0x0003666f, 0x0003686f, 0x00036a6f,
		       0x00036c6f, 0x00036e6f, 0x0003706f, 0x0003726f,
		       0x0003746f, 0x0003766f, 0x0003786f, 0x00037a6f,
		       0x00037c6f, 0x00037e6f, 0x0003806f, 0x0003826f,
		       0x0003846f, 0x0003866f, 0x0003886f, 0x00038a6f,
		       0x00038c6f, 0x00038e6f, 0x0003906f, 0x0003926f,
		       0x0003946f, 0x0003966f, 0x0003986f, 0x00039a6f,
		       0x00039c6f, 0x00039e6f, 0x0003a06f, 0x0003a26f,
		       0x0003a46f, 0x0003a66f, 0x0003a86f, 0x0003aa6f,
		       0x0003ac6f, 0x0003ae6f, 0x0003b06f, 0x0003b26f,
		       0x0003b46f, 0x0003b66f, 0x0003b86f, 0x0003ba6f,
		       0x0003bc6f, 0x0003be6f, 0x0003c06f, 0x0003c26f,
		       0x0003c46f, 0x0003c66f, 0x0003c86f, 0x0003ca6f,
		       0x0003cc6f, 0x0003ce6f, 0x0003d06f, 0x0003d26f,
		       0x0003d46f, 0x0003d66f, 0x0003d86f, 0x0003da6f,
		       0x0003dc6f, 0x0003de6f, 0x0003e06f, 0x0003e26f,
		       0x0003e46f, 0x0003e66f, 0x0003e86f, 0x0003ea6f,
		       0x0003ec6f, 0x0003ee6f, 0x0003f06f, 0x0003f26f,
		       0x0003f46f, 0x0003f66f, 0x0003f86f, 0x0003fa6f,
		       0x0003fc6f, 0x0003fe6f, 0x0004006f, 0x0004026f,
		       0x0004046f, 0x0004066f, 0x0004086f, 0x00040a6f,
		       0x00040c6f, 0x00040e6f, 0x0004106f, 0x0004126f,
		       0x0004146f, 0x0004166f, 0x0004186f, 0x00041a6f,
		       0x00041c6f, 0x00041e6f, 0x0004206f, 0x0004226f,
		       0x0004246f, 0x0004266f, 0x0004286f, 0x00042a6f,
		       0x00042c6f, 0x00042e6f, 0x0004306f, 0x0004326f,
		       0x0004346f, 0x0004366f, 0x0004386f, 0x00043a6f,
		       0x00043c6f, 0x00043e6f, 0x0004406f, 0x0004426f,
		       0x0004446f, 0x0004466f, 0x0004486f, 0x00044a6f,
		       0x00044c6f, 0x00044e6f, 0x0004506f, 0x0004526f,
		       0x0004546f, 0x0004566f, 0x0004586f, 0x00045a6f,
		       0x00045c6f, 0x00045e6f, 0x0004606f, 0x0004626f,
		       0x0004646f, 0x0004666f, 0x0004686f, 0x00046a6f,
		       0x00046c6f, 0x00046e6f, 0x0004706f, 0x0004726f,
		       0x0004746f, 0x0004766f, 0x0004786f, 0x00047a6f,
		       0x00047c6f, 0x00047e6f, 0x0004806f, 0x0004826f,
		       0x0004846f, 0x0004866f, 0x0004886f, 0x00048a6f,
		       0x00048c6f, 0x00048e6f, 0x0004906f, 0x0004926f,
		       0x0004946f, 0x0004966f, 0x0004986f, 0x00049a6f,
		       0x00049c6f, 0x00049e6f, 0x0004a06f, 0x0004a26f,
		       0x0004a46f, 0x0004a66f, 0x0004a86f, 0x0004aa6f,
		       0x0004ac6f, 0x0004ae6f, 0x0004b06f, 0x0004b26f,
		       0x0004b46f, 0x0004b66f, 0x0004b86f, 0x0004ba6f,
		       0x0004bc6f, 0x0004be6f, 0x0004c06f, 0x0004c26f,
		       0x0004c46f, 0x0004c66f, 0x0004c86f, 0x0004ca6f,
		       0x0004cc6f, 0x0004ce6f, 0x0004d06f, 0x0004d26f,
		       0x0004d46f, 0x0004d66f, 0x0004d86f, 0x0004da6f,
		       0x0004dc6f, 0x0004de6f, 0x0004e06f, 0x0004e26f,
		       0x0004e46f, 0x0004e66f, 0x0004e86f, 0x0004ea6f,
		       0x0004ec6f, 0x0004ee6f, 0x0004f06f, 0x0004f26f,
		       0x0004f46f, 0x0004f66f, 0x0004f86f, 0x0004fa6f,
		       0x0004fc6f, 0x0004fe6f, 0x0005006f, 0x0005026f,
		       0x0005046f, 0x0005066f, 0x0005086f, 0x00050a6f,
		       0x00050c6f, 0x00050e6f, 0x0005106f, 0x0005126f,
		       0x0005146f, 0x0005166f, 0x0005186f, 0x00051a6f,
		       0x00051c6f, 0x00051e6f, 0x0005206f, 0x0005226f,
		       0x0005246f, 0x0005266f, 0x0005286f, 0x00052a6f,
		       0x00052c6f, 0x00052e6f, 0x0005306f, 0x0005326f,
		       0x0005346f, 0x0005366f, 0x0005386f, 0x00053a6f,
		       0x00053c6f, 0x00053e6f, 0x0005406f, 0x0005426f,
		       0x0005446f, 0x0005466f, 0x0005486f, 0x00054a6f,
		       0x00054c6f, 0x00054e6f, 0x0005506f, 0x0005526f,
		       0x0005546f, 0x0005566f, 0x0005586f, 0x00055a6f,
		       0x00055c6f, 0x00055e6f, 0x0005606f, 0x0005626f,
		       0x0005646f, 0x0005666f, 0x0005686f, 0x00056a6f,
		       0x00056c6f, 0x00056e6f, 0x0005706f, 0x0005726f,
		       0x0005746f, 0x0005766f, 0x0005786f, 0x00057a6f,
		       0x00057c6f, 0x00057e6f, 0x0005806f, 0x0005826f,
		       0x0005846f, 0x0005866f, 0x0005886f, 0x00058a6f,
		       0x00058c6f, 0x00058e6f, 0x0005906f, 0x0005926f,
		       0x0005946f, 0x0005966f, 0x0005986f, 0x00059a6f,
		       0x00059c6f, 0x00059e6f, 0x0005a06f, 0x0005a26f,
		       0x0005a46f, 0x0005a66f, 0x0005a86f, 0x0005aa6f,
		       0x0005ac6f, 0x0005ae6f, 0x0005b06f, 0x0005b26f,
		       0x0005b46f, 0x0005b66f, 0x0005b86f, 0x0005ba6f,
		       0x0005bc6f, 0x0005be6f, 0x0005c06f, 0x0005c26f,
		       0x0005c46f, 0x0005c66f, 0x0005c86f, 0x0005ca6f,
		       0x0005cc6f, 0x0005ce6f, 0x0005d06f, 0x0005d26f,
		       0x0005d46f, 0x0005d66f, 0x0005d86f, 0x0005da6f,
		       0x0005dc6f, 0x0005de6f, 0x0005e06f, 0x0005e26f,
		       0x0005e46f, 0x0005e66f, 0x0005e86f, 0x0005ea6f,
		       0x0005ec6f, 0x0005ee6f, 0x0005f06f, 0x0005f26f,
		       0x0005f46f, 0x0005f66f, 0x0005f86f, 0x0005fa6f,
		       0x0005fc6f, 0x0005fe6f, 0x0006006f, 0x0006026f,
		       0x0006046f, 0x0006066f, 0x0006086f, 0x00060a6f,
		       0x00060c6f, 0x00060e6f, 0x0006106f, 0x0006126f,
		       0x0006146f, 0x0006166f, 0x0006186f, 0x00061a6f,
		       0x00061c6f, 0x00061e6f, 0x0006206f, 0x0006226f,
		       0x0006246f, 0x0006266f, 0x0006286f, 0x00062a6f,
		       0x00062c6f, 0x00062e6f, 0x0006306f, 0x0006326f,
		       0x0006346f, 0x0006366f, 0x0006386f, 0x00063a6f,
		       0x00063c6f, 0x00063e6f, 0x0006406f, 0x0006426f,
		       0x0006446f, 0x0006466f, 0x0006486f, 0x00064a6f,
		       0x00064c6f, 0x00064e6f, 0x0006506f, 0x0006526f,
		       0x0006546f, 0x0006566f, 0x0006586f, 0x00065a6f,
		       0x00065c6f, 0x00065e6f, 0x0006606f, 0x0006626f,
		       0x0006646f, 0x0006666f, 0x0006686f, 0x00066a6f,
		       0x00066c6f, 0x00066e6f, 0x0006706f, 0x0006726f,
		       0x0006746f, 0x0006766f, 0x0006786f, 0x00067a6f,
		       0x00067c6f, 0x00067e6f, 0x0006806f, 0x0006826f,
		       0x0006846f, 0x0006866f, 0x0006886f, 0x00068a6f,
		       0x00068c6f, 0x00068e6f, 0x0006906f, 0x0006926f,
		       0x0006946f, 0x0006966f, 0x0006986f, 0x00069a6f,
		       0x00069c6f, 0x00069e6f, 0x0006a06f, 0x0006a26f,
		       0x0006a46f, 0x0006a66f, 0x0006a86f, 0x0006aa6f,
		       0x0006ac6f, 0x0006ae6f, 0x0006b06f, 0x0006b26f,
		       0x0006b46f, 0x0006b66f, 0x0006b86f, 0x0006ba6f,
		       0x0006bc6f, 0x0006be6f, 0x0006c06f, 0x0006c26f,
		       0x0006c46f, 0x0006c66f, 0x0006c86f, 0x0006ca6f,
		       0x0006cc6f, 0x0006ce6f, 0x0006d06f, 0x0006d26f,
		       0x0006d46f, 0x0006d66f, 0x0006d86f, 0x0006da6f,
		       0x0006dc6f, 0x0006de6f, 0x0006e06f, 0x0006e26f,
		       0x0006e46f, 0x0006e66f, 0x0006e86f, 0x0006ea6f,
		       0x0006ec6f, 0x0006ee6f, 0x0006f06f, 0x0006f26f,
		       0x0006f46f, 0x0006f66f, 0x0006f86f, 0x0006fa6f,
		       0x0006fc6f, 0x0006fe6f, 0x0007006f, 0x0007026f,
		       0x0007046f, 0x0007066f, 0x0007086f, 0x00070a6f,
		       0x00070c6f, 0x00070e6f, 0x0007106f, 0x0007126f,
		       0x0007146f, 0x0007166f, 0x0007186f, 0x00071a6f,
		       0x00071c6f, 0x00071e6f, 0x0007206f, 0x0007226f,
		       0x0007246f, 0x0007266f, 0x0007286f, 0x00072a6f,
		       0x00072c6f, 0x00072e6f, 0x0007306f, 0x0007326f,
		       0x0007346f, 0x0007366f, 0x0007386f, 0x00073a6f,
		       0x00073c6f, 0x00073e6f, 0x0007406f, 0x0007426f,
		       0x0007446f, 0x0007466f, 0x0007486f, 0x00074a6f,
		       0x00074c6f, 0x00074e6f, 0x0007506f, 0x0007526f,
		       0x0007546f, 0x0007566f, 0x0007586f, 0x00075a6f,
		       0x00075c6f, 0x00075e6f, 0x0007606f, 0x0007626f,
		       0x0007646f, 0x0007666f, 0x0007686f, 0x00076a6f,
		       0x00076c6f, 0x00076e6f, 0x0007706f, 0x0007726f,
		       0x0007746f, 0x0007766f, 0x0007786f, 0x00077a6f,
		       0x00077c6f, 0x00077e6f, 0x0007806f, 0x0007826f,
		       0x0007846f, 0x0007866f, 0x0007886f, 0x00078a6f,
		       0x00078c6f, 0x00078e6f, 0x0007906f, 0x0007926f,
		       0x0007946f, 0x0007966f, 0x0007986f, 0x00079a6f,
		       0x00079c6f, 0x00079e6f, 0x0007a06f, 0x0007a26f,
		       0x0007a46f, 0x0007a66f, 0x0007a86f, 0x0007aa6f,
		       0x0007ac6f, 0x0007ae6f, 0x0007b06f, 0x0007b26f,
		       0x0007b46f, 0x0007b66f, 0x0007b86f, 0x0007ba6f,
		       0x0007bc6f, 0x0007be6f, 0x0007c06f, 0x0007c26f,
		       0x0007c46f, 0x0007c66f, 0x0007c86f, 0x0007ca6f,
		       0x0007cc6f, 0x0007ce6f, 0x0007d06f, 0x0007d26f,
		       0x0007d46f, 0x0007d66f, 0x0007d86f, 0x0007da6f,
		       0x0007dc6f, 0x0007de6f, 0x0007e06f, 0x0007e26f,
		       0x0007e46f, 0x0007e66f, 0x0007e86f, 0x0007ea6f,
		       0x0007ec6f, 0x0007ee6f, 0x0007f06f, 0x0007f26f,
		       0x0007f46f, 0x0007f66f, 0x0007f86f, 0x0007fa6f,
		       0x0007fc6f, 0x0007fe6f, 0x0008006f, 0x0008026f,
		       0x0008046f, 0x0008066f, 0x0008086f, 0x00080a6f,
		       0x00080c6f, 0x00080e6f, 0x0008106f, 0x0008126f,
		       0x0008146f, 0x0008166f, 0x0008186f, 0x00081a6f,
		       0x00081c6f, 0x00081e6f, 0x0008206f, 0x0008226f,
		       0x0008246f, 0x0008266f, 0x0008286f, 0x00082a6f,
		       0x00082c6f, 0x00082e6f, 0x0008306f, 0x0008326f,
		       0x0008346f, 0x0008366f, 0x0008386f, 0x00083a6f,
		       0x00083c6f, 0x00083e6f, 0x0008406f, 0x0008426f,
		       0x0008446f, 0x0008466f, 0x0008486f, 0x00084a6f,
		       0x00084c6f, 0x00084e6f, 0x0008506f, 0x0008526f,
		       0x0008546f, 0x0008566f, 0x0008586f, 0x00085a6f,
		       0x00085c6f, 0x00085e6f, 0x0008606f, 0x0008626f,
		       0x0008646f, 0x0008666f, 0x0008686f, 0x00086a6f,
		       0x00086c6f, 0x00086e6f, 0x0008706f, 0x0008726f,
		       0x0008746f, 0x0008766f, 0x0008786f, 0x00087a6f,
		       0x00087c6f, 0x00087e6f, 0x0008806f, 0x0008826f,
		       0x0008846f, 0x0008866f, 0x0008886f, 0x00088a6f,
		       0x00088c6f, 0x00088e6f, 0x0008906f, 0x0008926f,
		       0x0008946f, 0x0008966f, 0x0008986f, 0x00089a6f,
		       0x00089c6f, 0x00089e6f, 0x0008a06f, 0x0008a26f,
		       0x0008a46f, 0x0008a66f, 0x0008a86f, 0x0008aa6f,
		       0x0008ac6f, 0x0008ae6f, 0x0008b06f, 0x0008b26f,
		       0x0008b46f, 0x0008b66f, 0x0008b86f, 0x0008ba6f,
		       0x0008bc6f, 0x0008be6f, 0x0008c06f, 0x0008c26f,
		       0x0008c46f, 0x0008c66f, 0x0008c86f, 0x0008ca6f,
		       0x0008cc6f, 0x0008ce6f, 0x0008d06f, 0x0008d26f,
		       0x0008d46f, 0x0008d66f, 0x0008d86f, 0x0008da6f,
		       0x0008dc6f, 0x0008de6f, 0x0008e06f, 0x0008e26f,
		       0x0008e46f, 0x0008e66f, 0x0008e86f, 0x0008ea6f,
		       0x0008ec6f, 0x0008ee6f, 0x0008f06f, 0x0008f26f,
		       0x0008f46f, 0x0008f66f, 0x0008f86f, 0x0008fa6f,
		       0x0008fc6f, 0x0008fe6f, 0x0009006f, 0x0009026f,
		       0x0009046f, 0x0009066f, 0x0009086f, 0x00090a6f,
		       0x00090c6f, 0x00090e6f, 0x0009106f, 0x0009126f,
		       0x0009146f, 0x0009166f, 0x0009186f, 0x00091a6f,
		       0x00091c6f, 0x00091e6f, 0x0009206f, 0x0009226f,
		       0x0009246f, 0x0009266f, 0x0009286f, 0x00092a6f,
		       0x00092c6f, 0x00092e6f, 0x0009306f, 0x0009326f,
		       0x0009346f, 0x0009366f, 0x0009386f, 0x00093a6f,
		       0x00093c6f, 0x00093e6f, 0x0009406f, 0x0009426f,
		       0x0009446f, 0x0009466f, 0x0009486f, 0x00094a6f,
		       0x00094c6f, 0x00094e6f, 0x0009506f, 0x0009526f,
		       0x0009546f, 0x0009566f, 0x0009586f, 0x00095a6f,
		       0x00095c6f, 0x00095e6f, 0x0009606f, 0x0009626f,
		       0x0009646f, 0x0009666f, 0x0009686f, 0x00096a6f,
		       0x00096c6f, 0x00096e6f, 0x0009706f, 0x0009726f,
		       0x0009746f, 0x0009766f, 0x0009786f, 0x00097a6f,
		       0x00097c6f, 0x00097e6f, 0x0009806f, 0x0009826f,
		       0x0009846f, 0x0009866f, 0x0009886f, 0x00098a6f,
		       0x00098c6f, 0x00098e6f, 0x0009906f, 0x0009926f,
		       0x0009946f, 0x0009966f, 0x0009986f, 0x00099a6f,
		       0x00099c6f, 0x00099e6f, 0x0009a06f, 0x0009a26f,
		       0x0009a46f, 0x0009a66f, 0x0009a86f, 0x0009aa6f,
		       0x0009ac6f, 0x0009ae6f, 0x0009b06f, 0x0009b26f,
		       0x0009b46f, 0x0009b66f, 0x0009b86f, 0x0009ba6f,
		       0x0009bc6f, 0x0009be6f, 0x0009c06f, 0x0009c26f,
		       0x0009c46f, 0x0009c66f, 0x0009c86f, 0x0009ca6f,
		       0x0009cc6f, 0x0009ce6f, 0x0009d06f, 0x0009d26f,
		       0x0009d46f, 0x0009d66f, 0x0009d86f, 0x0009da6f,
		       0x0009dc6f, 0x0009de6f, 0x0009e06f, 0x0009e26f,
		       0x0009e46f, 0x0009e66f, 0x0009e86f, 0x0009ea6f,
		       0x0009ec6f, 0x0009ee6f, 0x0009f06f, 0x0009f26f,
		       0x0009f46f, 0x0009f66f, 0x0009f86f, 0x0009fa6f,
		       0x0009fc6f, 0x0009fe6f, 0x000a006f, 0x000a026f,
		       0x000a046f, 0x000a066f, 0x000a086f, 0x000a0a6f,
		       0x000a0c6f, 0x000a0e6f, 0x000a106f, 0x000a126f,
		       0x000a146f, 0x000a166f, 0x000a186f, 0x000a1a6f,
		       0x000a1c6f, 0x000a1e6f, 0x000a206f, 0x000a226f,
		       0x000a246f, 0x000a266f, 0x000a286f, 0x000a2a6f,
		       0x000a2c6f, 0x000a2e6f, 0x000a306f, 0x000a326f,
		       0x000a346f, 0x000a366f, 0x000a386f, 0x000a3a6f,
		       0x000a3c6f, 0x000a3e6f, 0x000a406f, 0x000a426f,
		       0x000a446f, 0x000a466f, 0x000a486f, 0x000a4a6f,
		       0x000a4c6f, 0x000a4e6f, 0x000a506f, 0x000a526f,
		       0x000a546f, 0x000a566f, 0x000a586f, 0x000a5a6f,
		       0x000a5c6f, 0x000a5e6f, 0x000a606f, 0x000a626f,
		       0x000a646f, 0x000a666f, 0x000a686f, 0x000a6a6f,
		       0x000a6c6f, 0x000a6e6f, 0x000a706f, 0x000a726f,
		       0x000a746f, 0x000a766f, 0x000a786f, 0x000a7a6f,
		       0x000a7c6f, 0x000a7e6f, 0x000a806f, 0x000a826f,
		       0x000a846f, 0x000a866f, 0x000a886f, 0x000a8a6f,
		       0x000a8c6f, 0x000a8e6f, 0x000a906f, 0x000a926f,
		       0x000a946f, 0x000a966f, 0x000a986f, 0x000a9a6f,
		       0x000a9c6f, 0x000a9e6f, 0x000aa06f, 0x000aa26f,
		       0x000aa46f, 0x000aa66f, 0x000aa86f, 0x000aaa6f,
		       0x000aac6f, 0x000aae6f, 0x000ab06f, 0x000ab26f,
		       0x000ab46f, 0x000ab66f, 0x000ab86f, 0x000aba6f,
		       0x000abc6f, 0x000abe6f, 0x000ac06f, 0x000ac26f,
		       0x000ac46f, 0x000ac66f, 0x000ac86f, 0x000aca6f,
		       0x000acc6f, 0x000ace6f, 0x000ad06f, 0x000ad26f,
		       0x000ad46f, 0x000ad66f, 0x000ad86f, 0x000ada6f,
		       0x000adc6f, 0x000ade6f, 0x000ae06f, 0x000ae26f,
		       0x000ae46f, 0x000ae66f, 0x000ae86f, 0x000aea6f,
		       0x000aec6f, 0x000aee6f, 0x000af06f, 0x000af26f,
		       0x000af46f, 0x000af66f, 0x000af86f, 0x000afa6f,
		       0x000afc6f, 0x000afe6f, 0x000b006f, 0x000b026f,
		       0x000b046f, 0x000b066f, 0x000b086f, 0x000b0a6f,
		       0x000b0c6f, 0x000b0e6f, 0x000b106f, 0x000b126f,
		       0x000b146f, 0x000b166f, 0x000b186f, 0x000b1a6f,
		       0x000b1c6f, 0x000b1e6f, 0x000b206f, 0x000b226f,
		       0x000b246f, 0x000b266f, 0x000b286f, 0x000b2a6f,
		       0x000b2c6f, 0x000b2e6f, 0x000b306f, 0x000b326f,
		       0x000b346f, 0x000b366f, 0x000b386f, 0x000b3a6f,
		       0x000b3c6f, 0x000b3e6f, 0x000b406f, 0x000b426f,
		       0x000b446f, 0x000b466f, 0x000b486f, 0x000b4a6f,
		       0x000b4c6f, 0x000b4e6f, 0x000b506f, 0x000b526f,
		       0x000b546f, 0x000b566f, 0x000b586f, 0x000b5a6f,
		       0x000b5c6f, 0x000b5e6f, 0x000b606f, 0x000b626f,
		       0x000b646f, 0x000b666f, 0x000b686f, 0x000b6a6f,
		       0x000b6c6f, 0x000b6e6f, 0x000b706f, 0x000b726f,
		       0x000b746f, 0x000b766f, 0x000b786f, 0x000b7a6f,
		       0x000b7c6f, 0x000b7e6f, 0x000b806f, 0x000b826f,
		       0x000b846f, 0x000b866f, 0x000b886f, 0x000b8a6f,
		       0x000b8c6f, 0x000b8e6f, 0x000b906f, 0x000b926f,
		       0x000b946f, 0x000b966f, 0x000b986f, 0x000b9a6f,
		       0x000b9c6f, 0x000b9e6f, 0x000ba06f, 0x000ba26f,
		       0x000ba46f, 0x000ba66f, 0x000ba86f, 0x000baa6f,
		       0x000bac6f, 0x000bae6f, 0x000bb06f, 0x000bb26f,
		       0x000bb46f, 0x000bb66f, 0x000bb86f, 0x000bba6f,
		       0x000bbc6f, 0x000bbe6f, 0x000bc06f, 0x000bc26f,
		       0x000bc46f, 0x000bc66f, 0x000bc86f, 0x000bca6f,
		       0x000bcc6f, 0x000bce6f, 0x000bd06f, 0x000bd26f,
		       0x000bd46f, 0x000bd66f, 0x000bd86f, 0x000bda6f,
		       0x000bdc6f, 0x000bde6f, 0x000be06f, 0x000be26f,
		       0x000be46f, 0x000be66f, 0x000be86f, 0x000bea6f,
		       0x000bec6f, 0x000bee6f, 0x000bf06f, 0x000bf26f,
		       0x000bf46f, 0x000bf66f, 0x000bf86f, 0x000bfa6f,
		       0x000bfc6f, 0x000bfe6f, 0x000c006f, 0x000c026f,
		       0x000c046f, 0x000c066f, 0x000c086f, 0x000c0a6f,
		       0x000c0c6f, 0x000c0e6f, 0x000c106f, 0x000c126f,
		       0x000c146f, 0x000c166f, 0x000c186f, 0x000c1a6f,
		       0x000c1c6f, 0x000c1e6f, 0x000c206f, 0x000c226f,
		       0x000c246f, 0x000c266f, 0x000c286f, 0x000c2a6f,
		       0x000c2c6f, 0x000c2e6f, 0x000c306f, 0x000c326f,
		       0x000c346f, 0x000c366f, 0x000c386f, 0x000c3a6f,
		       0x000c3c6f, 0x000c3e6f, 0x000c406f, 0x000c426f,
		       0x000c446f, 0x000c466f, 0x000c486f, 0x000c4a6f,
		       0x000c4c6f, 0x000c4e6f, 0x000c506f, 0x000c526f,
		       0x000c546f, 0x000c566f, 0x000c586f, 0x000c5a6f,
		       0x000c5c6f, 0x000c5e6f, 0x000c606f, 0x000c626f,
		       0x000c646f, 0x000c666f, 0x000c686f, 0x000c6a6f,
		       0x000c6c6f, 0x000c6e6f, 0x000c706f, 0x000c726f,
		       0x000c746f, 0x000c766f, 0x000c786f, 0x000c7a6f,
		       0x000c7c6f, 0x000c7e6f, 0x000c806f, 0x000c826f,
		       0x000c846f, 0x000c866f, 0x000c886f, 0x000c8a6f,
		       0x000c8c6f, 0x000c8e6f, 0x000c906f, 0x000c926f,
		       0x000c946f, 0x000c966f, 0x000c986f, 0x000c9a6f,
		       0x000c9c6f, 0x000c9e6f, 0x000ca06f, 0x000ca26f,
		       0x000ca46f, 0x000ca66f, 0x000ca86f, 0x000caa6f,
		       0x000cac6f, 0x000cae6f, 0x000cb06f, 0x000cb26f,
		       0x000cb46f, 0x000cb66f, 0x000cb86f, 0x000cba6f,
		       0x000cbc6f, 0x000cbe6f, 0x000cc06f, 0x000cc26f,
		       0x000cc46f, 0x000cc66f, 0x000cc86f, 0x000cca6f,
		       0x000ccc6f, 0x000cce6f, 0x000cd06f, 0x000cd26f,
		       0x000cd46f, 0x000cd66f, 0x000cd86f, 0x000cda6f,
		       0x000cdc6f, 0x000cde6f, 0x000ce06f, 0x000ce26f,
		       0x000ce46f, 0x000ce66f, 0x000ce86f, 0x000cea6f,
		       0x000cec6f, 0x000cee6f, 0x000cf06f, 0x000cf26f,
		       0x000cf46f, 0x000cf66f, 0x000cf86f, 0x000cfa6f,
		       0x000cfc6f, 0x000cfe6f, 0x000d006f, 0x000d026f,
		       0x000d046f, 0x000d066f, 0x000d086f, 0x000d0a6f,
		       0x000d0c6f, 0x000d0e6f, 0x000d106f, 0x000d126f,
		       0x000d146f, 0x000d166f, 0x000d186f, 0x000d1a6f,
		       0x000d1c6f, 0x000d1e6f, 0x000d206f, 0x000d226f,
		       0x000d246f, 0x000d266f, 0x000d286f, 0x000d2a6f,
		       0x000d2c6f, 0x000d2e6f, 0x000d306f, 0x000d326f,
		       0x000d346f, 0x000d366f, 0x000d386f, 0x000d3a6f,
		       0x000d3c6f, 0x000d3e6f, 0x000d406f, 0x000d426f,
		       0x000d446f, 0x000d466f, 0x000d486f, 0x000d4a6f,
		       0x000d4c6f, 0x000d4e6f, 0x000d506f, 0x000d526f,
		       0x000d546f, 0x000d566f, 0x000d586f, 0x000d5a6f,
		       0x000d5c6f, 0x000d5e6f, 0x000d606f, 0x000d626f,
		       0x000d646f, 0x000d666f, 0x000d686f, 0x000d6a6f,
		       0x000d6c6f, 0x000d6e6f, 0x000d706f, 0x000d726f,
		       0x000d746f, 0x000d766f, 0x000d786f, 0x000d7a6f,
		       0x000d7c6f, 0x000d7e6f, 0x000d806f, 0x000d826f,
		       0x000d846f, 0x000d866f, 0x000d886f, 0x000d8a6f,
		       0x000d8c6f, 0x000d8e6f, 0x000d906f, 0x000d926f,
		       0x000d946f, 0x000d966f, 0x000d986f, 0x000d9a6f,
		       0x000d9c6f, 0x000d9e6f, 0x000da06f, 0x000da26f,
		       0x000da46f, 0x000da66f, 0x000da86f, 0x000daa6f,
		       0x000dac6f, 0x000dae6f, 0x000db06f, 0x000db26f,
		       0x000db46f, 0x000db66f, 0x000db86f, 0x000dba6f,
		       0x000dbc6f, 0x000dbe6f, 0x000dc06f, 0x000dc26f,
		       0x000dc46f, 0x000dc66f, 0x000dc86f, 0x000dca6f,
		       0x000dcc6f, 0x000dce6f, 0x000dd06f, 0x000dd26f,
		       0x000dd46f, 0x000dd66f, 0x000dd86f, 0x000dda6f,
		       0x000ddc6f, 0x000dde6f, 0x000de06f, 0x000de26f,
		       0x000de46f, 0x000de66f, 0x000de86f, 0x000dea6f,
		       0x000dec6f, 0x000dee6f, 0x000df06f, 0x000df26f,
		       0x000df46f, 0x000df66f, 0x000df86f, 0x000dfa6f,
		       0x000dfc6f, 0x000dfe6f, 0x000e006f, 0x000e026f,
		       0x000e046f, 0x000e066f, 0x000e086f, 0x000e0a6f,
		       0x000e0c6f, 0x000e0e6f, 0x000e106f, 0x000e126f,
		       0x000e146f, 0x000e166f, 0x000e186f, 0x000e1a6f,
		       0x000e1c6f, 0x000e1e6f, 0x000e206f, 0x000e226f,
		       0x000e246f, 0x000e266f, 0x000e286f, 0x000e2a6f,
		       0x000e2c6f, 0x000e2e6f, 0x000e306f, 0x000e326f,
		       0x000e346f, 0x000e366f, 0x000e386f, 0x000e3a6f,
		       0x000e3c6f, 0x000e3e6f, 0x000e406f, 0x000e426f,
		       0x000e446f, 0x000e466f, 0x000e486f, 0x000e4a6f,
		       0x000e4c6f, 0x000e4e6f, 0x000e506f, 0x000e526f,
		       0x000e546f, 0x000e566f, 0x000e586f, 0x000e5a6f,
		       0x000e5c6f, 0x000e5e6f, 0x000e606f, 0x000e626f,
		       0x000e646f, 0x000e666f, 0x000e686f, 0x000e6a6f,
		       0x000e6c6f, 0x000e6e6f, 0x000e706f, 0x000e726f,
		       0x000e746f, 0x000e766f, 0x000e786f, 0x000e7a6f,
		       0x000e7c6f, 0x000e7e6f, 0x000e806f, 0x000e826f,
		       0x000e846f, 0x000e866f, 0x000e886f, 0x000e8a6f,
		       0x000e8c6f, 0x000e8e6f, 0x000e906f, 0x000e926f,
		       0x000e946f, 0x000e966f, 0x000e986f, 0x000e9a6f,
		       0x000e9c6f, 0x000e9e6f, 0x000ea06f, 0x000ea26f,
		       0x000ea46f, 0x000ea66f, 0x000ea86f, 0x000eaa6f,
		       0x000eac6f, 0x000eae6f, 0x000eb06f, 0x000eb26f,
		       0x000eb46f, 0x000eb66f, 0x000eb86f, 0x000eba6f,
		       0x000ebc6f, 0x000ebe6f, 0x000ec06f, 0x000ec26f,
		       0x000ec46f, 0x000ec66f, 0x000ec86f, 0x000eca6f,
		       0x000ecc6f, 0x000ece6f, 0x000ed06f, 0x000ed26f,
		       0x000ed46f, 0x000ed66f, 0x000ed86f, 0x000eda6f,
		       0x000edc6f, 0x000ede6f, 0x000ee06f, 0x000ee26f,
		       0x000ee46f, 0x000ee66f, 0x000ee86f, 0x000eea6f,
		       0x000eec6f, 0x000eee6f, 0x000ef06f, 0x000ef26f,
		       0x000ef46f, 0x000ef66f, 0x000ef86f, 0x000efa6f,
		       0x000efc6f, 0x000efe6f, 0x000f006f, 0x000f026f,
		       0x000f046f, 0x000f066f, 0x000f086f, 0x000f0a6f,
		       0x000f0c6f, 0x000f0e6f, 0x000f106f, 0x000f126f,
		       0x000f146f, 0x000f166f, 0x000f186f, 0x000f1a6f,
		       0x000f1c6f, 0x000f1e6f, 0x000f206f, 0x000f226f,
		       0x000f246f, 0x000f266f, 0x000f286f, 0x000f2a6f,
		       0x000f2c6f, 0x000f2e6f, 0x000f306f, 0x000f326f,
		       0x000f346f, 0x000f366f, 0x000f386f, 0x000f3a6f,
		       0x000f3c6f, 0x000f3e6f, 0x000f406f, 0x000f426f,
		       0x000f446f, 0x000f466f, 0x000f486f, 0x000f4a6f,
		       0x000f4c6f, 0x000f4e6f, 0x000f506f, 0x000f526f,
		       0x000f546f, 0x000f566f, 0x000f586f, 0x000f5a6f,
		       0x000f5c6f, 0x000f5e6f, 0x000f606f, 0x000f626f,
		       0x000f646f, 0x000f666f, 0x000f686f, 0x000f6a6f,
		       0x000f6c6f, 0x000f6e6f, 0x000f706f, 0x000f726f,
		       0x000f746f, 0x000f766f, 0x000f786f, 0x000f7a6f,
		       0x000f7c6f, 0x000f7e6f, 0x000f806f, 0x000f826f,
		       0x000f846f, 0x000f866f, 0x000f886f, 0x000f8a6f,
		       0x000f8c6f, 0x000f8e6f, 0x000f906f, 0x000f926f,
		       0x000f946f, 0x000f966f, 0x000f986f, 0x000f9a6f,
		       0x000f9c6f, 0x000f9e6f, 0x000fa06f, 0x000fa26f,
		       0x000fa46f, 0x000fa66f, 0x000fa86f, 0x000faa6f,
		       0x000fac6f, 0x000fae6f, 0x000fb06f, 0x000fb26f,
		       0x000fb46f, 0x000fb66f, 0x000fb86f, 0x000fba6f,
		       0x000fbc6f, 0x000fbe6f, 0x000fc06f, 0x000fc26f,
		       0x000fc46f, 0x000fc66f, 0x000fc86f, 0x000fca6f,
		       0x000fcc6f, 0x000fce6f, 0x000fd06f, 0x000fd26f,
		       0x000fd46f, 0x000fd66f, 0x000fd86f, 0x000fda6f,
		       0x000fdc6f, 0x000fde6f, 0x000fe06f, 0x000fe26f,
		       0x000fe46f, 0x000fe66f, 0x000fe86f, 0x000fea6f,
		       0x000fec6f, 0x000fee6f, 0x000ff06f, 0x000ff26f,
		       0x000ff46f, 0x000ff66f, 0x000ff86f, 0x000ffa6f,
		       0x000ffc6f, 0x000ffe6f
#endif /* LONGER_HUFFTABLE */
		       },

	.len_table = {
		      0x000bffef, 0x00000003, 0x00000084, 0x00000145,
		      0x00000345, 0x00000626, 0x000002a7, 0x00000aa7,
		      0x000000c6, 0x000004c6, 0x00001469, 0x00003469,
		      0x00000c69, 0x00002c69, 0x00001c69, 0x00003c69,
		      0x0000026a, 0x0000226a, 0x0000426a, 0x0000626a,
		      0x000008eb, 0x000048eb, 0x000088eb, 0x0000c8eb,
		      0x000029ec, 0x0000a9ec, 0x000129ec, 0x0001a9ec,
		      0x000069ec, 0x0000e9ec, 0x000169ec, 0x0001e9ec,
		      0x000019ed, 0x000099ed, 0x000119ed, 0x000199ed,
		      0x000219ed, 0x000299ed, 0x000319ed, 0x000399ed,
		      0x000059ed, 0x0000d9ed, 0x000159ed, 0x0001d9ed,
		      0x000259ed, 0x0002d9ed, 0x000359ed, 0x0003d9ed,
		      0x000039ed, 0x0000b9ed, 0x000139ed, 0x0001b9ed,
		      0x000239ed, 0x0002b9ed, 0x000339ed, 0x0003b9ed,
		      0x000079ed, 0x0000f9ed, 0x000179ed, 0x0001f9ed,
		      0x000279ed, 0x0002f9ed, 0x000379ed, 0x0003f9ed,
		      0x00003fef, 0x00013fef, 0x00023fef, 0x00033fef,
		      0x00043fef, 0x00053fef, 0x00063fef, 0x00073fef,
		      0x00083fef, 0x00093fef, 0x000a3fef, 0x000b3fef,
		      0x000c3fef, 0x000d3fef, 0x000e3fef, 0x000f3fef,
		      0x00007ff0, 0x00027ff0, 0x00047ff0, 0x00067ff0,
		      0x00087ff0, 0x000a7ff0, 0x000c7ff0, 0x000e7ff0,
		      0x00107ff0, 0x00127ff0, 0x00147ff0, 0x00167ff0,
		      0x00187ff0, 0x001a7ff0, 0x001c7ff0, 0x001e7ff0,
		      0x0000fff1, 0x0004fff1, 0x0008fff1, 0x000cfff1,
		      0x0010fff1, 0x0014fff1, 0x0018fff1, 0x001cfff1,
		      0x0020fff1, 0x0024fff1, 0x0028fff1, 0x002cfff1,
		      0x0030fff1, 0x0034fff1, 0x0038fff1, 0x003cfff1,
		      0x0002fff1, 0x0006fff1, 0x000afff1, 0x000efff1,
		      0x0012fff1, 0x0016fff1, 0x001afff1, 0x001efff1,
		      0x0022fff1, 0x0026fff1, 0x002afff1, 0x002efff1,
		      0x0032fff1, 0x0036fff1, 0x003afff1, 0x003efff1,
		      0x00017ff1, 0x00037ff1, 0x00057ff1, 0x00077ff1,
		      0x00097ff1, 0x000b7ff1, 0x000d7ff1, 0x000f7ff1,
		      0x00117ff1, 0x00137ff1, 0x00157ff1, 0x00177ff1,
		      0x00197ff1, 0x001b7ff1, 0x001d7ff1, 0x001f7ff1,
		      0x00217ff1, 0x00237ff1, 0x00257ff1, 0x00277ff1,
		      0x00297ff1, 0x002b7ff1, 0x002d7ff1, 0x002f7ff1,
		      0x00317ff1, 0x00337ff1, 0x00357ff1, 0x00377ff1,
		      0x00397ff1, 0x003b7ff1, 0x003d7ff1, 0x003f7ff1,
		      0x0001fff2, 0x0005fff2, 0x0009fff2, 0x000dfff2,
		      0x0011fff2, 0x0015fff2, 0x0019fff2, 0x001dfff2,
		      0x0021fff2, 0x0025fff2, 0x0029fff2, 0x002dfff2,
		      0x0031fff2, 0x0035fff2, 0x0039fff2, 0x003dfff2,
		      0x0041fff2, 0x0045fff2, 0x0049fff2, 0x004dfff2,
		      0x0051fff2, 0x0055fff2, 0x0059fff2, 0x005dfff2,
		      0x0061fff2, 0x0065fff2, 0x0069fff2, 0x006dfff2,
		      0x0071fff2, 0x0075fff2, 0x0079fff2, 0x007dfff2,
		      0x0007fff4, 0x0017fff4, 0x0027fff4, 0x0037fff4,
		      0x0047fff4, 0x0057fff4, 0x0067fff4, 0x0077fff4,
		      0x0087fff4, 0x0097fff4, 0x00a7fff4, 0x00b7fff4,
		      0x00c7fff4, 0x00d7fff4, 0x00e7fff4, 0x00f7fff4,
		      0x0107fff4, 0x0117fff4, 0x0127fff4, 0x0137fff4,
		      0x0147fff4, 0x0157fff4, 0x0167fff4, 0x0177fff4,
		      0x0187fff4, 0x0197fff4, 0x01a7fff4, 0x01b7fff4,
		      0x01c7fff4, 0x01d7fff4, 0x01e7fff4, 0x01f7fff4,
		      0x000ffff4, 0x001ffff4, 0x002ffff4, 0x003ffff4,
		      0x004ffff4, 0x005ffff4, 0x006ffff4, 0x007ffff4,
		      0x008ffff4, 0x009ffff4, 0x00affff4, 0x00bffff4,
		      0x00cffff4, 0x00dffff4, 0x00effff4, 0x00fffff4,
		      0x010ffff4, 0x011ffff4, 0x012ffff4, 0x013ffff4,
		      0x014ffff4, 0x015ffff4, 0x016ffff4, 0x017ffff4,
		      0x018ffff4, 0x019ffff4, 0x01affff4, 0x01bffff4,
		      0x01cffff4, 0x01dffff4, 0x01effff4, 0x0000bfeb},

	.lit_table = {
		      0x000c, 0x0035, 0x0093, 0x00b5, 0x0075, 0x00f5, 0x0193, 0x0053,
		      0x0153, 0x000d, 0x0009, 0x00d3, 0x01d3, 0x008d, 0x0033, 0x0133,
		      0x00b3, 0x0147, 0x0347, 0x00c7, 0x02c7, 0x01c7, 0x03c7, 0x0027,
		      0x0227, 0x002f, 0x042f, 0x022f, 0x0127, 0x062f, 0x01b3, 0x0073,
		      0x001c, 0x0327, 0x0173, 0x00a7, 0x00f3, 0x02a7, 0x01a7, 0x01f3,
		      0x004d, 0x000b, 0x03a7, 0x0067, 0x0049, 0x00cd, 0x0029, 0x0267,
		      0x002d, 0x00ad, 0x006d, 0x00ed, 0x001d, 0x009d, 0x010b, 0x008b,
		      0x005d, 0x018b, 0x004b, 0x014b, 0x00cb, 0x0167, 0x01cb, 0x002b,
		      0x00dd, 0x003d, 0x00bd, 0x007d, 0x012b, 0x00ab, 0x01ab, 0x006b,
		      0x016b, 0x00fd, 0x00eb, 0x0367, 0x01eb, 0x001b, 0x011b, 0x009b,
		      0x0003, 0x00e7, 0x019b, 0x0083, 0x005b, 0x015b, 0x02e7, 0x00db,
		      0x01e7, 0x03e7, 0x0017, 0x0217, 0x0117, 0x0317, 0x0097, 0x0297,
		      0x01db, 0x0002, 0x0069, 0x0019, 0x0016, 0x0012, 0x0059, 0x0039,
		      0x0079, 0x0036, 0x003b, 0x0043, 0x000e, 0x0005, 0x002e, 0x001e,
		      0x0045, 0x0197, 0x003e, 0x0001, 0x0021, 0x0011, 0x00c3, 0x0025,
		      0x013b, 0x0065, 0x00bb, 0x012f, 0x0397, 0x0057, 0x0257, 0x0157,
		      0x01bb, 0x052f, 0x032f, 0x0357, 0x00d7, 0x072f, 0x00af, 0x02d7,
		      0x01d7, 0x04af, 0x02af, 0x03d7, 0x06af, 0x01af, 0x05af, 0x0037,
		      0x0237, 0x03af, 0x07af, 0x006f, 0x046f, 0x026f, 0x066f, 0x016f,
		      0x056f, 0x036f, 0x076f, 0x00ef, 0x04ef, 0x02ef, 0x06ef, 0x01ef,
		      0x0137, 0x05ef, 0x03ef, 0x07ef, 0x0337, 0x001f, 0x00b7, 0x041f,
		      0x02b7, 0x021f, 0x061f, 0x011f, 0x051f, 0x031f, 0x071f, 0x009f,
		      0x01b7, 0x049f, 0x029f, 0x069f, 0x03b7, 0x019f, 0x059f, 0x039f,
		      0x079f, 0x005f, 0x045f, 0x025f, 0x065f, 0x0077, 0x015f, 0x0277,
		      0x007b, 0x0177, 0x017b, 0x00fb, 0x055f, 0x035f, 0x075f, 0x0377,
		      0x00f7, 0x00df, 0x04df, 0x02df, 0x06df, 0x01df, 0x05df, 0x02f7,
		      0x01f7, 0x03df, 0x07df, 0x003f, 0x043f, 0x023f, 0x063f, 0x013f,
		      0x053f, 0x033f, 0x073f, 0x00bf, 0x04bf, 0x02bf, 0x06bf, 0x01bf,
		      0x01fb, 0x03f7, 0x05bf, 0x000f, 0x020f, 0x03bf, 0x07bf, 0x010f,
		      0x030f, 0x007f, 0x047f, 0x027f, 0x067f, 0x017f, 0x057f, 0x008f,
		      0x0007, 0x028f, 0x037f, 0x018f, 0x038f, 0x077f, 0x00ff, 0x04ff,
		      0x0107, 0x004f, 0x02ff, 0x06ff, 0x0087, 0x024f, 0x0187, 0x0023,
		      0x1fff},

	.lit_table_sizes = {
			    0x05, 0x08, 0x09, 0x08, 0x08, 0x08, 0x09, 0x09,
			    0x09, 0x08, 0x07, 0x09, 0x09, 0x08, 0x09, 0x09,
			    0x09, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x09, 0x09,
			    0x05, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x0a, 0x09,
			    0x08, 0x09, 0x0a, 0x0a, 0x07, 0x08, 0x07, 0x0a,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x09, 0x09,
			    0x08, 0x09, 0x09, 0x09, 0x09, 0x0a, 0x09, 0x09,
			    0x08, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x08, 0x09, 0x0a, 0x09, 0x09, 0x09, 0x09,
			    0x08, 0x0a, 0x09, 0x08, 0x09, 0x09, 0x0a, 0x09,
			    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
			    0x09, 0x05, 0x07, 0x07, 0x06, 0x05, 0x07, 0x07,
			    0x07, 0x06, 0x09, 0x08, 0x06, 0x07, 0x06, 0x06,
			    0x07, 0x0a, 0x06, 0x06, 0x06, 0x06, 0x08, 0x07,
			    0x09, 0x07, 0x09, 0x0b, 0x0a, 0x0a, 0x0a, 0x0a,
			    0x09, 0x0b, 0x0b, 0x0a, 0x0a, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0a, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0a, 0x0b,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0b, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0a,
			    0x09, 0x0a, 0x09, 0x09, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x09, 0x0a, 0x0b, 0x0a, 0x0a, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x09, 0x0a, 0x0b, 0x0a, 0x0a, 0x0b, 0x0b, 0x0b,
			    0x09, 0x0a, 0x0b, 0x0b, 0x09, 0x0a, 0x09, 0x08,
			    0x0f},

#ifndef LONGER_HUFFTABLE
	.dcodes = {
		   0x007f, 0x01ff, 0x017f, 0x03ff, 0x00ff, 0x003f, 0x00bf, 0x000f,
		   0x002f, 0x001f, 0x000b, 0x001b, 0x0004, 0x0007, 0x000c, 0x0002,
		   0x000a, 0x0006, 0x000e, 0x0001, 0x0009, 0x0017, 0x0000, 0x0005,
		   0x000d, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000},

	.dcodes_sizes = {
			 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x08, 0x08, 0x06,
			 0x06, 0x06, 0x05, 0x05, 0x04, 0x05, 0x04, 0x04,
			 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x03, 0x04,
			 0x04, 0x04, 0x00, 0x00, 0x00, 0x00}
#else
	.dcodes = {
		   0x0000, 0x0000, 0x0000, 0x0000},

	.dcodes_sizes = {
			 0x00, 0x00, 0x00, 0x00}
#endif
};

#else // LARGE_WINDOW

const uint8_t gzip_hdr[] = {
	0x1f, 0x8b, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff
};

const uint32_t gzip_hdr_bytes = 10;
const uint32_t gzip_trl_bytes = 8;

const uint8_t zlib_hdr[] = { 0x78, 0x01 };

const uint32_t zlib_hdr_bytes = 2;
const uint32_t zlib_trl_bytes = 4;

struct isal_hufftables hufftables_default = {

	.deflate_hdr = {
			0xed, 0xfd, 0x09, 0x80, 0x1c, 0x45, 0xf9, 0xbf,
			0x81, 0xf7, 0x66, 0x37, 0xd7, 0x24, 0x9b, 0x04,
			0x40, 0x45, 0x45, 0x52, 0x04, 0x20, 0x09, 0xcc,
			0x2e, 0xbb, 0x9b, 0x3b, 0x81, 0x24, 0xbb, 0xb9,
			0x21, 0x17, 0x49, 0xb8, 0x04, 0x85, 0xde, 0x99,
			0xde, 0x9d, 0x26, 0x33, 0xd3, 0x43, 0xf7, 0x4c,
			0x36, 0x8b, 0x08, 0xf1, 0x56, 0x51, 0xc1, 0xfb,
			0x56, 0x54, 0xc4, 0x5b, 0x51, 0xf1, 0x16, 0x0d,
			0x89, 0x8a, 0x37, 0x78, 0xdf, 0x1a, 0x45, 0x05,
			0xef, 0x20, 0xaa, 0xa0, 0x90, 0xfd, 0xff, 0x9f,
			0xf7, 0xad, 0x9e, 0xa9, 0xdd, 0xdd, 0x70, 0xfa,
			0xfd, 0xfd, 0xbe, 0xbf, 0xff, 0xdf, 0xcd, 0x66,
			0x67, 0xba, 0xbb, 0xaa, 0xea, 0x7d, 0xdf, 0x7a,
			0xeb, 0xad, 0x4f, 0xbd, 0xf5, 0x56, 0x35},

	.deflate_hdr_count = 110,
	.deflate_hdr_extra_bits = 6,

	.dist_table = {
		       0x000007e8, 0x00001fe9,
#ifdef LONGER_HUFFTABLE
		       0x000017e8, 0x00003fe9, 0x00000fe9, 0x00002fe9,
		       0x000003e8, 0x000013e8, 0x00000be9, 0x00001be9,
		       0x00002be9, 0x00003be9, 0x000002e8, 0x00000ae8,
		       0x000012e8, 0x00001ae8, 0x000006e9, 0x00000ee9,
		       0x000016e9, 0x00001ee9, 0x000026e9, 0x00002ee9,
		       0x000036e9, 0x00003ee9, 0x000001e9, 0x000009e9,
		       0x000011e9, 0x000019e9, 0x000021e9, 0x000029e9,
		       0x000031e9, 0x000039e9, 0x00000129, 0x00000529,
		       0x00000929, 0x00000d29, 0x00001129, 0x00001529,
		       0x00001929, 0x00001d29, 0x00002129, 0x00002529,
		       0x00002929, 0x00002d29, 0x00003129, 0x00003529,
		       0x00003929, 0x00003d29, 0x00000329, 0x00000729,
		       0x00000b29, 0x00000f29, 0x00001329, 0x00001729,
		       0x00001b29, 0x00001f29, 0x00002329, 0x00002729,
		       0x00002b29, 0x00002f29, 0x00003329, 0x00003729,
		       0x00003b29, 0x00003f29, 0x000000aa, 0x000004aa,
		       0x000008aa, 0x00000caa, 0x000010aa, 0x000014aa,
		       0x000018aa, 0x00001caa, 0x000020aa, 0x000024aa,
		       0x000028aa, 0x00002caa, 0x000030aa, 0x000034aa,
		       0x000038aa, 0x00003caa, 0x000040aa, 0x000044aa,
		       0x000048aa, 0x00004caa, 0x000050aa, 0x000054aa,
		       0x000058aa, 0x00005caa, 0x000060aa, 0x000064aa,
		       0x000068aa, 0x00006caa, 0x000070aa, 0x000074aa,
		       0x000078aa, 0x00007caa, 0x000002aa, 0x000006aa,
		       0x00000aaa, 0x00000eaa, 0x000012aa, 0x000016aa,
		       0x00001aaa, 0x00001eaa, 0x000022aa, 0x000026aa,
		       0x00002aaa, 0x00002eaa, 0x000032aa, 0x000036aa,
		       0x00003aaa, 0x00003eaa, 0x000042aa, 0x000046aa,
		       0x00004aaa, 0x00004eaa, 0x000052aa, 0x000056aa,
		       0x00005aaa, 0x00005eaa, 0x000062aa, 0x000066aa,
		       0x00006aaa, 0x00006eaa, 0x000072aa, 0x000076aa,
		       0x00007aaa, 0x00007eaa, 0x0000008a, 0x0000028a,
		       0x0000048a, 0x0000068a, 0x0000088a, 0x00000a8a,
		       0x00000c8a, 0x00000e8a, 0x0000108a, 0x0000128a,
		       0x0000148a, 0x0000168a, 0x0000188a, 0x00001a8a,
		       0x00001c8a, 0x00001e8a, 0x0000208a, 0x0000228a,
		       0x0000248a, 0x0000268a, 0x0000288a, 0x00002a8a,
		       0x00002c8a, 0x00002e8a, 0x0000308a, 0x0000328a,
		       0x0000348a, 0x0000368a, 0x0000388a, 0x00003a8a,
		       0x00003c8a, 0x00003e8a, 0x0000408a, 0x0000428a,
		       0x0000448a, 0x0000468a, 0x0000488a, 0x00004a8a,
		       0x00004c8a, 0x00004e8a, 0x0000508a, 0x0000528a,
		       0x0000548a, 0x0000568a, 0x0000588a, 0x00005a8a,
		       0x00005c8a, 0x00005e8a, 0x0000608a, 0x0000628a,
		       0x0000648a, 0x0000668a, 0x0000688a, 0x00006a8a,
		       0x00006c8a, 0x00006e8a, 0x0000708a, 0x0000728a,
		       0x0000748a, 0x0000768a, 0x0000788a, 0x00007a8a,
		       0x00007c8a, 0x00007e8a, 0x0000018a, 0x0000038a,
		       0x0000058a, 0x0000078a, 0x0000098a, 0x00000b8a,
		       0x00000d8a, 0x00000f8a, 0x0000118a, 0x0000138a,
		       0x0000158a, 0x0000178a, 0x0000198a, 0x00001b8a,
		       0x00001d8a, 0x00001f8a, 0x0000218a, 0x0000238a,
		       0x0000258a, 0x0000278a, 0x0000298a, 0x00002b8a,
		       0x00002d8a, 0x00002f8a, 0x0000318a, 0x0000338a,
		       0x0000358a, 0x0000378a, 0x0000398a, 0x00003b8a,
		       0x00003d8a, 0x00003f8a, 0x0000418a, 0x0000438a,
		       0x0000458a, 0x0000478a, 0x0000498a, 0x00004b8a,
		       0x00004d8a, 0x00004f8a, 0x0000518a, 0x0000538a,
		       0x0000558a, 0x0000578a, 0x0000598a, 0x00005b8a,
		       0x00005d8a, 0x00005f8a, 0x0000618a, 0x0000638a,
		       0x0000658a, 0x0000678a, 0x0000698a, 0x00006b8a,
		       0x00006d8a, 0x00006f8a, 0x0000718a, 0x0000738a,
		       0x0000758a, 0x0000778a, 0x0000798a, 0x00007b8a,
		       0x00007d8a, 0x00007f8a, 0x0000004b, 0x0000024b,
		       0x0000044b, 0x0000064b, 0x0000084b, 0x00000a4b,
		       0x00000c4b, 0x00000e4b, 0x0000104b, 0x0000124b,
		       0x0000144b, 0x0000164b, 0x0000184b, 0x00001a4b,
		       0x00001c4b, 0x00001e4b, 0x0000204b, 0x0000224b,
		       0x0000244b, 0x0000264b, 0x0000284b, 0x00002a4b,
		       0x00002c4b, 0x00002e4b, 0x0000304b, 0x0000324b,
		       0x0000344b, 0x0000364b, 0x0000384b, 0x00003a4b,
		       0x00003c4b, 0x00003e4b, 0x0000404b, 0x0000424b,
		       0x0000444b, 0x0000464b, 0x0000484b, 0x00004a4b,
		       0x00004c4b, 0x00004e4b, 0x0000504b, 0x0000524b,
		       0x0000544b, 0x0000564b, 0x0000584b, 0x00005a4b,
		       0x00005c4b, 0x00005e4b, 0x0000604b, 0x0000624b,
		       0x0000644b, 0x0000664b, 0x0000684b, 0x00006a4b,
		       0x00006c4b, 0x00006e4b, 0x0000704b, 0x0000724b,
		       0x0000744b, 0x0000764b, 0x0000784b, 0x00007a4b,
		       0x00007c4b, 0x00007e4b, 0x0000804b, 0x0000824b,
		       0x0000844b, 0x0000864b, 0x0000884b, 0x00008a4b,
		       0x00008c4b, 0x00008e4b, 0x0000904b, 0x0000924b,
		       0x0000944b, 0x0000964b, 0x0000984b, 0x00009a4b,
		       0x00009c4b, 0x00009e4b, 0x0000a04b, 0x0000a24b,
		       0x0000a44b, 0x0000a64b, 0x0000a84b, 0x0000aa4b,
		       0x0000ac4b, 0x0000ae4b, 0x0000b04b, 0x0000b24b,
		       0x0000b44b, 0x0000b64b, 0x0000b84b, 0x0000ba4b,
		       0x0000bc4b, 0x0000be4b, 0x0000c04b, 0x0000c24b,
		       0x0000c44b, 0x0000c64b, 0x0000c84b, 0x0000ca4b,
		       0x0000cc4b, 0x0000ce4b, 0x0000d04b, 0x0000d24b,
		       0x0000d44b, 0x0000d64b, 0x0000d84b, 0x0000da4b,
		       0x0000dc4b, 0x0000de4b, 0x0000e04b, 0x0000e24b,
		       0x0000e44b, 0x0000e64b, 0x0000e84b, 0x0000ea4b,
		       0x0000ec4b, 0x0000ee4b, 0x0000f04b, 0x0000f24b,
		       0x0000f44b, 0x0000f64b, 0x0000f84b, 0x0000fa4b,
		       0x0000fc4b, 0x0000fe4b, 0x000001ac, 0x000005ac,
		       0x000009ac, 0x00000dac, 0x000011ac, 0x000015ac,
		       0x000019ac, 0x00001dac, 0x000021ac, 0x000025ac,
		       0x000029ac, 0x00002dac, 0x000031ac, 0x000035ac,
		       0x000039ac, 0x00003dac, 0x000041ac, 0x000045ac,
		       0x000049ac, 0x00004dac, 0x000051ac, 0x000055ac,
		       0x000059ac, 0x00005dac, 0x000061ac, 0x000065ac,
		       0x000069ac, 0x00006dac, 0x000071ac, 0x000075ac,
		       0x000079ac, 0x00007dac, 0x000081ac, 0x000085ac,
		       0x000089ac, 0x00008dac, 0x000091ac, 0x000095ac,
		       0x000099ac, 0x00009dac, 0x0000a1ac, 0x0000a5ac,
		       0x0000a9ac, 0x0000adac, 0x0000b1ac, 0x0000b5ac,
		       0x0000b9ac, 0x0000bdac, 0x0000c1ac, 0x0000c5ac,
		       0x0000c9ac, 0x0000cdac, 0x0000d1ac, 0x0000d5ac,
		       0x0000d9ac, 0x0000ddac, 0x0000e1ac, 0x0000e5ac,
		       0x0000e9ac, 0x0000edac, 0x0000f1ac, 0x0000f5ac,
		       0x0000f9ac, 0x0000fdac, 0x000101ac, 0x000105ac,
		       0x000109ac, 0x00010dac, 0x000111ac, 0x000115ac,
		       0x000119ac, 0x00011dac, 0x000121ac, 0x000125ac,
		       0x000129ac, 0x00012dac, 0x000131ac, 0x000135ac,
		       0x000139ac, 0x00013dac, 0x000141ac, 0x000145ac,
		       0x000149ac, 0x00014dac, 0x000151ac, 0x000155ac,
		       0x000159ac, 0x00015dac, 0x000161ac, 0x000165ac,
		       0x000169ac, 0x00016dac, 0x000171ac, 0x000175ac,
		       0x000179ac, 0x00017dac, 0x000181ac, 0x000185ac,
		       0x000189ac, 0x00018dac, 0x000191ac, 0x000195ac,
		       0x000199ac, 0x00019dac, 0x0001a1ac, 0x0001a5ac,
		       0x0001a9ac, 0x0001adac, 0x0001b1ac, 0x0001b5ac,
		       0x0001b9ac, 0x0001bdac, 0x0001c1ac, 0x0001c5ac,
		       0x0001c9ac, 0x0001cdac, 0x0001d1ac, 0x0001d5ac,
		       0x0001d9ac, 0x0001ddac, 0x0001e1ac, 0x0001e5ac,
		       0x0001e9ac, 0x0001edac, 0x0001f1ac, 0x0001f5ac,
		       0x0001f9ac, 0x0001fdac, 0x0000014c, 0x0000034c,
		       0x0000054c, 0x0000074c, 0x0000094c, 0x00000b4c,
		       0x00000d4c, 0x00000f4c, 0x0000114c, 0x0000134c,
		       0x0000154c, 0x0000174c, 0x0000194c, 0x00001b4c,
		       0x00001d4c, 0x00001f4c, 0x0000214c, 0x0000234c,
		       0x0000254c, 0x0000274c, 0x0000294c, 0x00002b4c,
		       0x00002d4c, 0x00002f4c, 0x0000314c, 0x0000334c,
		       0x0000354c, 0x0000374c, 0x0000394c, 0x00003b4c,
		       0x00003d4c, 0x00003f4c, 0x0000414c, 0x0000434c,
		       0x0000454c, 0x0000474c, 0x0000494c, 0x00004b4c,
		       0x00004d4c, 0x00004f4c, 0x0000514c, 0x0000534c,
		       0x0000554c, 0x0000574c, 0x0000594c, 0x00005b4c,
		       0x00005d4c, 0x00005f4c, 0x0000614c, 0x0000634c,
		       0x0000654c, 0x0000674c, 0x0000694c, 0x00006b4c,
		       0x00006d4c, 0x00006f4c, 0x0000714c, 0x0000734c,
		       0x0000754c, 0x0000774c, 0x0000794c, 0x00007b4c,
		       0x00007d4c, 0x00007f4c, 0x0000814c, 0x0000834c,
		       0x0000854c, 0x0000874c, 0x0000894c, 0x00008b4c,
		       0x00008d4c, 0x00008f4c, 0x0000914c, 0x0000934c,
		       0x0000954c, 0x0000974c, 0x0000994c, 0x00009b4c,
		       0x00009d4c, 0x00009f4c, 0x0000a14c, 0x0000a34c,
		       0x0000a54c, 0x0000a74c, 0x0000a94c, 0x0000ab4c,
		       0x0000ad4c, 0x0000af4c, 0x0000b14c, 0x0000b34c,
		       0x0000b54c, 0x0000b74c, 0x0000b94c, 0x0000bb4c,
		       0x0000bd4c, 0x0000bf4c, 0x0000c14c, 0x0000c34c,
		       0x0000c54c, 0x0000c74c, 0x0000c94c, 0x0000cb4c,
		       0x0000cd4c, 0x0000cf4c, 0x0000d14c, 0x0000d34c,
		       0x0000d54c, 0x0000d74c, 0x0000d94c, 0x0000db4c,
		       0x0000dd4c, 0x0000df4c, 0x0000e14c, 0x0000e34c,
		       0x0000e54c, 0x0000e74c, 0x0000e94c, 0x0000eb4c,
		       0x0000ed4c, 0x0000ef4c, 0x0000f14c, 0x0000f34c,
		       0x0000f54c, 0x0000f74c, 0x0000f94c, 0x0000fb4c,
		       0x0000fd4c, 0x0000ff4c, 0x0001014c, 0x0001034c,
		       0x0001054c, 0x0001074c, 0x0001094c, 0x00010b4c,
		       0x00010d4c, 0x00010f4c, 0x0001114c, 0x0001134c,
		       0x0001154c, 0x0001174c, 0x0001194c, 0x00011b4c,
		       0x00011d4c, 0x00011f4c, 0x0001214c, 0x0001234c,
		       0x0001254c, 0x0001274c, 0x0001294c, 0x00012b4c,
		       0x00012d4c, 0x00012f4c, 0x0001314c, 0x0001334c,
		       0x0001354c, 0x0001374c, 0x0001394c, 0x00013b4c,
		       0x00013d4c, 0x00013f4c, 0x0001414c, 0x0001434c,
		       0x0001454c, 0x0001474c, 0x0001494c, 0x00014b4c,
		       0x00014d4c, 0x00014f4c, 0x0001514c, 0x0001534c,
		       0x0001554c, 0x0001574c, 0x0001594c, 0x00015b4c,
		       0x00015d4c, 0x00015f4c, 0x0001614c, 0x0001634c,
		       0x0001654c, 0x0001674c, 0x0001694c, 0x00016b4c,
		       0x00016d4c, 0x00016f4c, 0x0001714c, 0x0001734c,
		       0x0001754c, 0x0001774c, 0x0001794c, 0x00017b4c,
		       0x00017d4c, 0x00017f4c, 0x0001814c, 0x0001834c,
		       0x0001854c, 0x0001874c, 0x0001894c, 0x00018b4c,
		       0x00018d4c, 0x00018f4c, 0x0001914c, 0x0001934c,
		       0x0001954c, 0x0001974c, 0x0001994c, 0x00019b4c,
		       0x00019d4c, 0x00019f4c, 0x0001a14c, 0x0001a34c,
		       0x0001a54c, 0x0001a74c, 0x0001a94c, 0x0001ab4c,
		       0x0001ad4c, 0x0001af4c, 0x0001b14c, 0x0001b34c,
		       0x0001b54c, 0x0001b74c, 0x0001b94c, 0x0001bb4c,
		       0x0001bd4c, 0x0001bf4c, 0x0001c14c, 0x0001c34c,
		       0x0001c54c, 0x0001c74c, 0x0001c94c, 0x0001cb4c,
		       0x0001cd4c, 0x0001cf4c, 0x0001d14c, 0x0001d34c,
		       0x0001d54c, 0x0001d74c, 0x0001d94c, 0x0001db4c,
		       0x0001dd4c, 0x0001df4c, 0x0001e14c, 0x0001e34c,
		       0x0001e54c, 0x0001e74c, 0x0001e94c, 0x0001eb4c,
		       0x0001ed4c, 0x0001ef4c, 0x0001f14c, 0x0001f34c,
		       0x0001f54c, 0x0001f74c, 0x0001f94c, 0x0001fb4c,
		       0x0001fd4c, 0x0001ff4c, 0x000003ad, 0x000007ad,
		       0x00000bad, 0x00000fad, 0x000013ad, 0x000017ad,
		       0x00001bad, 0x00001fad, 0x000023ad, 0x000027ad,
		       0x00002bad, 0x00002fad, 0x000033ad, 0x000037ad,
		       0x00003bad, 0x00003fad, 0x000043ad, 0x000047ad,
		       0x00004bad, 0x00004fad, 0x000053ad, 0x000057ad,
		       0x00005bad, 0x00005fad, 0x000063ad, 0x000067ad,
		       0x00006bad, 0x00006fad, 0x000073ad, 0x000077ad,
		       0x00007bad, 0x00007fad, 0x000083ad, 0x000087ad,
		       0x00008bad, 0x00008fad, 0x000093ad, 0x000097ad,
		       0x00009bad, 0x00009fad, 0x0000a3ad, 0x0000a7ad,
		       0x0000abad, 0x0000afad, 0x0000b3ad, 0x0000b7ad,
		       0x0000bbad, 0x0000bfad, 0x0000c3ad, 0x0000c7ad,
		       0x0000cbad, 0x0000cfad, 0x0000d3ad, 0x0000d7ad,
		       0x0000dbad, 0x0000dfad, 0x0000e3ad, 0x0000e7ad,
		       0x0000ebad, 0x0000efad, 0x0000f3ad, 0x0000f7ad,
		       0x0000fbad, 0x0000ffad, 0x000103ad, 0x000107ad,
		       0x00010bad, 0x00010fad, 0x000113ad, 0x000117ad,
		       0x00011bad, 0x00011fad, 0x000123ad, 0x000127ad,
		       0x00012bad, 0x00012fad, 0x000133ad, 0x000137ad,
		       0x00013bad, 0x00013fad, 0x000143ad, 0x000147ad,
		       0x00014bad, 0x00014fad, 0x000153ad, 0x000157ad,
		       0x00015bad, 0x00015fad, 0x000163ad, 0x000167ad,
		       0x00016bad, 0x00016fad, 0x000173ad, 0x000177ad,
		       0x00017bad, 0x00017fad, 0x000183ad, 0x000187ad,
		       0x00018bad, 0x00018fad, 0x000193ad, 0x000197ad,
		       0x00019bad, 0x00019fad, 0x0001a3ad, 0x0001a7ad,
		       0x0001abad, 0x0001afad, 0x0001b3ad, 0x0001b7ad,
		       0x0001bbad, 0x0001bfad, 0x0001c3ad, 0x0001c7ad,
		       0x0001cbad, 0x0001cfad, 0x0001d3ad, 0x0001d7ad,
		       0x0001dbad, 0x0001dfad, 0x0001e3ad, 0x0001e7ad,
		       0x0001ebad, 0x0001efad, 0x0001f3ad, 0x0001f7ad,
		       0x0001fbad, 0x0001ffad, 0x000203ad, 0x000207ad,
		       0x00020bad, 0x00020fad, 0x000213ad, 0x000217ad,
		       0x00021bad, 0x00021fad, 0x000223ad, 0x000227ad,
		       0x00022bad, 0x00022fad, 0x000233ad, 0x000237ad,
		       0x00023bad, 0x00023fad, 0x000243ad, 0x000247ad,
		       0x00024bad, 0x00024fad, 0x000253ad, 0x000257ad,
		       0x00025bad, 0x00025fad, 0x000263ad, 0x000267ad,
		       0x00026bad, 0x00026fad, 0x000273ad, 0x000277ad,
		       0x00027bad, 0x00027fad, 0x000283ad, 0x000287ad,
		       0x00028bad, 0x00028fad, 0x000293ad, 0x000297ad,
		       0x00029bad, 0x00029fad, 0x0002a3ad, 0x0002a7ad,
		       0x0002abad, 0x0002afad, 0x0002b3ad, 0x0002b7ad,
		       0x0002bbad, 0x0002bfad, 0x0002c3ad, 0x0002c7ad,
		       0x0002cbad, 0x0002cfad, 0x0002d3ad, 0x0002d7ad,
		       0x0002dbad, 0x0002dfad, 0x0002e3ad, 0x0002e7ad,
		       0x0002ebad, 0x0002efad, 0x0002f3ad, 0x0002f7ad,
		       0x0002fbad, 0x0002ffad, 0x000303ad, 0x000307ad,
		       0x00030bad, 0x00030fad, 0x000313ad, 0x000317ad,
		       0x00031bad, 0x00031fad, 0x000323ad, 0x000327ad,
		       0x00032bad, 0x00032fad, 0x000333ad, 0x000337ad,
		       0x00033bad, 0x00033fad, 0x000343ad, 0x000347ad,
		       0x00034bad, 0x00034fad, 0x000353ad, 0x000357ad,
		       0x00035bad, 0x00035fad, 0x000363ad, 0x000367ad,
		       0x00036bad, 0x00036fad, 0x000373ad, 0x000377ad,
		       0x00037bad, 0x00037fad, 0x000383ad, 0x000387ad,
		       0x00038bad, 0x00038fad, 0x000393ad, 0x000397ad,
		       0x00039bad, 0x00039fad, 0x0003a3ad, 0x0003a7ad,
		       0x0003abad, 0x0003afad, 0x0003b3ad, 0x0003b7ad,
		       0x0003bbad, 0x0003bfad, 0x0003c3ad, 0x0003c7ad,
		       0x0003cbad, 0x0003cfad, 0x0003d3ad, 0x0003d7ad,
		       0x0003dbad, 0x0003dfad, 0x0003e3ad, 0x0003e7ad,
		       0x0003ebad, 0x0003efad, 0x0003f3ad, 0x0003f7ad,
		       0x0003fbad, 0x0003ffad, 0x000000cd, 0x000002cd,
		       0x000004cd, 0x000006cd, 0x000008cd, 0x00000acd,
		       0x00000ccd, 0x00000ecd, 0x000010cd, 0x000012cd,
		       0x000014cd, 0x000016cd, 0x000018cd, 0x00001acd,
		       0x00001ccd, 0x00001ecd, 0x000020cd, 0x000022cd,
		       0x000024cd, 0x000026cd, 0x000028cd, 0x00002acd,
		       0x00002ccd, 0x00002ecd, 0x000030cd, 0x000032cd,
		       0x000034cd, 0x000036cd, 0x000038cd, 0x00003acd,
		       0x00003ccd, 0x00003ecd, 0x000040cd, 0x000042cd,
		       0x000044cd, 0x000046cd, 0x000048cd, 0x00004acd,
		       0x00004ccd, 0x00004ecd, 0x000050cd, 0x000052cd,
		       0x000054cd, 0x000056cd, 0x000058cd, 0x00005acd,
		       0x00005ccd, 0x00005ecd, 0x000060cd, 0x000062cd,
		       0x000064cd, 0x000066cd, 0x000068cd, 0x00006acd,
		       0x00006ccd, 0x00006ecd, 0x000070cd, 0x000072cd,
		       0x000074cd, 0x000076cd, 0x000078cd, 0x00007acd,
		       0x00007ccd, 0x00007ecd, 0x000080cd, 0x000082cd,
		       0x000084cd, 0x000086cd, 0x000088cd, 0x00008acd,
		       0x00008ccd, 0x00008ecd, 0x000090cd, 0x000092cd,
		       0x000094cd, 0x000096cd, 0x000098cd, 0x00009acd,
		       0x00009ccd, 0x00009ecd, 0x0000a0cd, 0x0000a2cd,
		       0x0000a4cd, 0x0000a6cd, 0x0000a8cd, 0x0000aacd,
		       0x0000accd, 0x0000aecd, 0x0000b0cd, 0x0000b2cd,
		       0x0000b4cd, 0x0000b6cd, 0x0000b8cd, 0x0000bacd,
		       0x0000bccd, 0x0000becd, 0x0000c0cd, 0x0000c2cd,
		       0x0000c4cd, 0x0000c6cd, 0x0000c8cd, 0x0000cacd,
		       0x0000cccd, 0x0000cecd, 0x0000d0cd, 0x0000d2cd,
		       0x0000d4cd, 0x0000d6cd, 0x0000d8cd, 0x0000dacd,
		       0x0000dccd, 0x0000decd, 0x0000e0cd, 0x0000e2cd,
		       0x0000e4cd, 0x0000e6cd, 0x0000e8cd, 0x0000eacd,
		       0x0000eccd, 0x0000eecd, 0x0000f0cd, 0x0000f2cd,
		       0x0000f4cd, 0x0000f6cd, 0x0000f8cd, 0x0000facd,
		       0x0000fccd, 0x0000fecd, 0x000100cd, 0x000102cd,
		       0x000104cd, 0x000106cd, 0x000108cd, 0x00010acd,
		       0x00010ccd, 0x00010ecd, 0x000110cd, 0x000112cd,
		       0x000114cd, 0x000116cd, 0x000118cd, 0x00011acd,
		       0x00011ccd, 0x00011ecd, 0x000120cd, 0x000122cd,
		       0x000124cd, 0x000126cd, 0x000128cd, 0x00012acd,
		       0x00012ccd, 0x00012ecd, 0x000130cd, 0x000132cd,
		       0x000134cd, 0x000136cd, 0x000138cd, 0x00013acd,
		       0x00013ccd, 0x00013ecd, 0x000140cd, 0x000142cd,
		       0x000144cd, 0x000146cd, 0x000148cd, 0x00014acd,
		       0x00014ccd, 0x00014ecd, 0x000150cd, 0x000152cd,
		       0x000154cd, 0x000156cd, 0x000158cd, 0x00015acd,
		       0x00015ccd, 0x00015ecd, 0x000160cd, 0x000162cd,
		       0x000164cd, 0x000166cd, 0x000168cd, 0x00016acd,
		       0x00016ccd, 0x00016ecd, 0x000170cd, 0x000172cd,
		       0x000174cd, 0x000176cd, 0x000178cd, 0x00017acd,
		       0x00017ccd, 0x00017ecd, 0x000180cd, 0x000182cd,
		       0x000184cd, 0x000186cd, 0x000188cd, 0x00018acd,
		       0x00018ccd, 0x00018ecd, 0x000190cd, 0x000192cd,
		       0x000194cd, 0x000196cd, 0x000198cd, 0x00019acd,
		       0x00019ccd, 0x00019ecd, 0x0001a0cd, 0x0001a2cd,
		       0x0001a4cd, 0x0001a6cd, 0x0001a8cd, 0x0001aacd,
		       0x0001accd, 0x0001aecd, 0x0001b0cd, 0x0001b2cd,
		       0x0001b4cd, 0x0001b6cd, 0x0001b8cd, 0x0001bacd,
		       0x0001bccd, 0x0001becd, 0x0001c0cd, 0x0001c2cd,
		       0x0001c4cd, 0x0001c6cd, 0x0001c8cd, 0x0001cacd,
		       0x0001cccd, 0x0001cecd, 0x0001d0cd, 0x0001d2cd,
		       0x0001d4cd, 0x0001d6cd, 0x0001d8cd, 0x0001dacd,
		       0x0001dccd, 0x0001decd, 0x0001e0cd, 0x0001e2cd,
		       0x0001e4cd, 0x0001e6cd, 0x0001e8cd, 0x0001eacd,
		       0x0001eccd, 0x0001eecd, 0x0001f0cd, 0x0001f2cd,
		       0x0001f4cd, 0x0001f6cd, 0x0001f8cd, 0x0001facd,
		       0x0001fccd, 0x0001fecd, 0x000200cd, 0x000202cd,
		       0x000204cd, 0x000206cd, 0x000208cd, 0x00020acd,
		       0x00020ccd, 0x00020ecd, 0x000210cd, 0x000212cd,
		       0x000214cd, 0x000216cd, 0x000218cd, 0x00021acd,
		       0x00021ccd, 0x00021ecd, 0x000220cd, 0x000222cd,
		       0x000224cd, 0x000226cd, 0x000228cd, 0x00022acd,
		       0x00022ccd, 0x00022ecd, 0x000230cd, 0x000232cd,
		       0x000234cd, 0x000236cd, 0x000238cd, 0x00023acd,
		       0x00023ccd, 0x00023ecd, 0x000240cd, 0x000242cd,
		       0x000244cd, 0x000246cd, 0x000248cd, 0x00024acd,
		       0x00024ccd, 0x00024ecd, 0x000250cd, 0x000252cd,
		       0x000254cd, 0x000256cd, 0x000258cd, 0x00025acd,
		       0x00025ccd, 0x00025ecd, 0x000260cd, 0x000262cd,
		       0x000264cd, 0x000266cd, 0x000268cd, 0x00026acd,
		       0x00026ccd, 0x00026ecd, 0x000270cd, 0x000272cd,
		       0x000274cd, 0x000276cd, 0x000278cd, 0x00027acd,
		       0x00027ccd, 0x00027ecd, 0x000280cd, 0x000282cd,
		       0x000284cd, 0x000286cd, 0x000288cd, 0x00028acd,
		       0x00028ccd, 0x00028ecd, 0x000290cd, 0x000292cd,
		       0x000294cd, 0x000296cd, 0x000298cd, 0x00029acd,
		       0x00029ccd, 0x00029ecd, 0x0002a0cd, 0x0002a2cd,
		       0x0002a4cd, 0x0002a6cd, 0x0002a8cd, 0x0002aacd,
		       0x0002accd, 0x0002aecd, 0x0002b0cd, 0x0002b2cd,
		       0x0002b4cd, 0x0002b6cd, 0x0002b8cd, 0x0002bacd,
		       0x0002bccd, 0x0002becd, 0x0002c0cd, 0x0002c2cd,
		       0x0002c4cd, 0x0002c6cd, 0x0002c8cd, 0x0002cacd,
		       0x0002cccd, 0x0002cecd, 0x0002d0cd, 0x0002d2cd,
		       0x0002d4cd, 0x0002d6cd, 0x0002d8cd, 0x0002dacd,
		       0x0002dccd, 0x0002decd, 0x0002e0cd, 0x0002e2cd,
		       0x0002e4cd, 0x0002e6cd, 0x0002e8cd, 0x0002eacd,
		       0x0002eccd, 0x0002eecd, 0x0002f0cd, 0x0002f2cd,
		       0x0002f4cd, 0x0002f6cd, 0x0002f8cd, 0x0002facd,
		       0x0002fccd, 0x0002fecd, 0x000300cd, 0x000302cd,
		       0x000304cd, 0x000306cd, 0x000308cd, 0x00030acd,
		       0x00030ccd, 0x00030ecd, 0x000310cd, 0x000312cd,
		       0x000314cd, 0x000316cd, 0x000318cd, 0x00031acd,
		       0x00031ccd, 0x00031ecd, 0x000320cd, 0x000322cd,
		       0x000324cd, 0x000326cd, 0x000328cd, 0x00032acd,
		       0x00032ccd, 0x00032ecd, 0x000330cd, 0x000332cd,
		       0x000334cd, 0x000336cd, 0x000338cd, 0x00033acd,
		       0x00033ccd, 0x00033ecd, 0x000340cd, 0x000342cd,
		       0x000344cd, 0x000346cd, 0x000348cd, 0x00034acd,
		       0x00034ccd, 0x00034ecd, 0x000350cd, 0x000352cd,
		       0x000354cd, 0x000356cd, 0x000358cd, 0x00035acd,
		       0x00035ccd, 0x00035ecd, 0x000360cd, 0x000362cd,
		       0x000364cd, 0x000366cd, 0x000368cd, 0x00036acd,
		       0x00036ccd, 0x00036ecd, 0x000370cd, 0x000372cd,
		       0x000374cd, 0x000376cd, 0x000378cd, 0x00037acd,
		       0x00037ccd, 0x00037ecd, 0x000380cd, 0x000382cd,
		       0x000384cd, 0x000386cd, 0x000388cd, 0x00038acd,
		       0x00038ccd, 0x00038ecd, 0x000390cd, 0x000392cd,
		       0x000394cd, 0x000396cd, 0x000398cd, 0x00039acd,
		       0x00039ccd, 0x00039ecd, 0x0003a0cd, 0x0003a2cd,
		       0x0003a4cd, 0x0003a6cd, 0x0003a8cd, 0x0003aacd,
		       0x0003accd, 0x0003aecd, 0x0003b0cd, 0x0003b2cd,
		       0x0003b4cd, 0x0003b6cd, 0x0003b8cd, 0x0003bacd,
		       0x0003bccd, 0x0003becd, 0x0003c0cd, 0x0003c2cd,
		       0x0003c4cd, 0x0003c6cd, 0x0003c8cd, 0x0003cacd,
		       0x0003cccd, 0x0003cecd, 0x0003d0cd, 0x0003d2cd,
		       0x0003d4cd, 0x0003d6cd, 0x0003d8cd, 0x0003dacd,
		       0x0003dccd, 0x0003decd, 0x0003e0cd, 0x0003e2cd,
		       0x0003e4cd, 0x0003e6cd, 0x0003e8cd, 0x0003eacd,
		       0x0003eccd, 0x0003eecd, 0x0003f0cd, 0x0003f2cd,
		       0x0003f4cd, 0x0003f6cd, 0x0003f8cd, 0x0003facd,
		       0x0003fccd, 0x0003fecd, 0x0000006e, 0x0000046e,
		       0x0000086e, 0x00000c6e, 0x0000106e, 0x0000146e,
		       0x0000186e, 0x00001c6e, 0x0000206e, 0x0000246e,
		       0x0000286e, 0x00002c6e, 0x0000306e, 0x0000346e,
		       0x0000386e, 0x00003c6e, 0x0000406e, 0x0000446e,
		       0x0000486e, 0x00004c6e, 0x0000506e, 0x0000546e,
		       0x0000586e, 0x00005c6e, 0x0000606e, 0x0000646e,
		       0x0000686e, 0x00006c6e, 0x0000706e, 0x0000746e,
		       0x0000786e, 0x00007c6e, 0x0000806e, 0x0000846e,
		       0x0000886e, 0x00008c6e, 0x0000906e, 0x0000946e,
		       0x0000986e, 0x00009c6e, 0x0000a06e, 0x0000a46e,
		       0x0000a86e, 0x0000ac6e, 0x0000b06e, 0x0000b46e,
		       0x0000b86e, 0x0000bc6e, 0x0000c06e, 0x0000c46e,
		       0x0000c86e, 0x0000cc6e, 0x0000d06e, 0x0000d46e,
		       0x0000d86e, 0x0000dc6e, 0x0000e06e, 0x0000e46e,
		       0x0000e86e, 0x0000ec6e, 0x0000f06e, 0x0000f46e,
		       0x0000f86e, 0x0000fc6e, 0x0001006e, 0x0001046e,
		       0x0001086e, 0x00010c6e, 0x0001106e, 0x0001146e,
		       0x0001186e, 0x00011c6e, 0x0001206e, 0x0001246e,
		       0x0001286e, 0x00012c6e, 0x0001306e, 0x0001346e,
		       0x0001386e, 0x00013c6e, 0x0001406e, 0x0001446e,
		       0x0001486e, 0x00014c6e, 0x0001506e, 0x0001546e,
		       0x0001586e, 0x00015c6e, 0x0001606e, 0x0001646e,
		       0x0001686e, 0x00016c6e, 0x0001706e, 0x0001746e,
		       0x0001786e, 0x00017c6e, 0x0001806e, 0x0001846e,
		       0x0001886e, 0x00018c6e, 0x0001906e, 0x0001946e,
		       0x0001986e, 0x00019c6e, 0x0001a06e, 0x0001a46e,
		       0x0001a86e, 0x0001ac6e, 0x0001b06e, 0x0001b46e,
		       0x0001b86e, 0x0001bc6e, 0x0001c06e, 0x0001c46e,
		       0x0001c86e, 0x0001cc6e, 0x0001d06e, 0x0001d46e,
		       0x0001d86e, 0x0001dc6e, 0x0001e06e, 0x0001e46e,
		       0x0001e86e, 0x0001ec6e, 0x0001f06e, 0x0001f46e,
		       0x0001f86e, 0x0001fc6e, 0x0002006e, 0x0002046e,
		       0x0002086e, 0x00020c6e, 0x0002106e, 0x0002146e,
		       0x0002186e, 0x00021c6e, 0x0002206e, 0x0002246e,
		       0x0002286e, 0x00022c6e, 0x0002306e, 0x0002346e,
		       0x0002386e, 0x00023c6e, 0x0002406e, 0x0002446e,
		       0x0002486e, 0x00024c6e, 0x0002506e, 0x0002546e,
		       0x0002586e, 0x00025c6e, 0x0002606e, 0x0002646e,
		       0x0002686e, 0x00026c6e, 0x0002706e, 0x0002746e,
		       0x0002786e, 0x00027c6e, 0x0002806e, 0x0002846e,
		       0x0002886e, 0x00028c6e, 0x0002906e, 0x0002946e,
		       0x0002986e, 0x00029c6e, 0x0002a06e, 0x0002a46e,
		       0x0002a86e, 0x0002ac6e, 0x0002b06e, 0x0002b46e,
		       0x0002b86e, 0x0002bc6e, 0x0002c06e, 0x0002c46e,
		       0x0002c86e, 0x0002cc6e, 0x0002d06e, 0x0002d46e,
		       0x0002d86e, 0x0002dc6e, 0x0002e06e, 0x0002e46e,
		       0x0002e86e, 0x0002ec6e, 0x0002f06e, 0x0002f46e,
		       0x0002f86e, 0x0002fc6e, 0x0003006e, 0x0003046e,
		       0x0003086e, 0x00030c6e, 0x0003106e, 0x0003146e,
		       0x0003186e, 0x00031c6e, 0x0003206e, 0x0003246e,
		       0x0003286e, 0x00032c6e, 0x0003306e, 0x0003346e,
		       0x0003386e, 0x00033c6e, 0x0003406e, 0x0003446e,
		       0x0003486e, 0x00034c6e, 0x0003506e, 0x0003546e,
		       0x0003586e, 0x00035c6e, 0x0003606e, 0x0003646e,
		       0x0003686e, 0x00036c6e, 0x0003706e, 0x0003746e,
		       0x0003786e, 0x00037c6e, 0x0003806e, 0x0003846e,
		       0x0003886e, 0x00038c6e, 0x0003906e, 0x0003946e,
		       0x0003986e, 0x00039c6e, 0x0003a06e, 0x0003a46e,
		       0x0003a86e, 0x0003ac6e, 0x0003b06e, 0x0003b46e,
		       0x0003b86e, 0x0003bc6e, 0x0003c06e, 0x0003c46e,
		       0x0003c86e, 0x0003cc6e, 0x0003d06e, 0x0003d46e,
		       0x0003d86e, 0x0003dc6e, 0x0003e06e, 0x0003e46e,
		       0x0003e86e, 0x0003ec6e, 0x0003f06e, 0x0003f46e,
		       0x0003f86e, 0x0003fc6e, 0x0004006e, 0x0004046e,
		       0x0004086e, 0x00040c6e, 0x0004106e, 0x0004146e,
		       0x0004186e, 0x00041c6e, 0x0004206e, 0x0004246e,
		       0x0004286e, 0x00042c6e, 0x0004306e, 0x0004346e,
		       0x0004386e, 0x00043c6e, 0x0004406e, 0x0004446e,
		       0x0004486e, 0x00044c6e, 0x0004506e, 0x0004546e,
		       0x0004586e, 0x00045c6e, 0x0004606e, 0x0004646e,
		       0x0004686e, 0x00046c6e, 0x0004706e, 0x0004746e,
		       0x0004786e, 0x00047c6e, 0x0004806e, 0x0004846e,
		       0x0004886e, 0x00048c6e, 0x0004906e, 0x0004946e,
		       0x0004986e, 0x00049c6e, 0x0004a06e, 0x0004a46e,
		       0x0004a86e, 0x0004ac6e, 0x0004b06e, 0x0004b46e,
		       0x0004b86e, 0x0004bc6e, 0x0004c06e, 0x0004c46e,
		       0x0004c86e, 0x0004cc6e, 0x0004d06e, 0x0004d46e,
		       0x0004d86e, 0x0004dc6e, 0x0004e06e, 0x0004e46e,
		       0x0004e86e, 0x0004ec6e, 0x0004f06e, 0x0004f46e,
		       0x0004f86e, 0x0004fc6e, 0x0005006e, 0x0005046e,
		       0x0005086e, 0x00050c6e, 0x0005106e, 0x0005146e,
		       0x0005186e, 0x00051c6e, 0x0005206e, 0x0005246e,
		       0x0005286e, 0x00052c6e, 0x0005306e, 0x0005346e,
		       0x0005386e, 0x00053c6e, 0x0005406e, 0x0005446e,
		       0x0005486e, 0x00054c6e, 0x0005506e, 0x0005546e,
		       0x0005586e, 0x00055c6e, 0x0005606e, 0x0005646e,
		       0x0005686e, 0x00056c6e, 0x0005706e, 0x0005746e,
		       0x0005786e, 0x00057c6e, 0x0005806e, 0x0005846e,
		       0x0005886e, 0x00058c6e, 0x0005906e, 0x0005946e,
		       0x0005986e, 0x00059c6e, 0x0005a06e, 0x0005a46e,
		       0x0005a86e, 0x0005ac6e, 0x0005b06e, 0x0005b46e,
		       0x0005b86e, 0x0005bc6e, 0x0005c06e, 0x0005c46e,
		       0x0005c86e, 0x0005cc6e, 0x0005d06e, 0x0005d46e,
		       0x0005d86e, 0x0005dc6e, 0x0005e06e, 0x0005e46e,
		       0x0005e86e, 0x0005ec6e, 0x0005f06e, 0x0005f46e,
		       0x0005f86e, 0x0005fc6e, 0x0006006e, 0x0006046e,
		       0x0006086e, 0x00060c6e, 0x0006106e, 0x0006146e,
		       0x0006186e, 0x00061c6e, 0x0006206e, 0x0006246e,
		       0x0006286e, 0x00062c6e, 0x0006306e, 0x0006346e,
		       0x0006386e, 0x00063c6e, 0x0006406e, 0x0006446e,
		       0x0006486e, 0x00064c6e, 0x0006506e, 0x0006546e,
		       0x0006586e, 0x00065c6e, 0x0006606e, 0x0006646e,
		       0x0006686e, 0x00066c6e, 0x0006706e, 0x0006746e,
		       0x0006786e, 0x00067c6e, 0x0006806e, 0x0006846e,
		       0x0006886e, 0x00068c6e, 0x0006906e, 0x0006946e,
		       0x0006986e, 0x00069c6e, 0x0006a06e, 0x0006a46e,
		       0x0006a86e, 0x0006ac6e, 0x0006b06e, 0x0006b46e,
		       0x0006b86e, 0x0006bc6e, 0x0006c06e, 0x0006c46e,
		       0x0006c86e, 0x0006cc6e, 0x0006d06e, 0x0006d46e,
		       0x0006d86e, 0x0006dc6e, 0x0006e06e, 0x0006e46e,
		       0x0006e86e, 0x0006ec6e, 0x0006f06e, 0x0006f46e,
		       0x0006f86e, 0x0006fc6e, 0x0007006e, 0x0007046e,
		       0x0007086e, 0x00070c6e, 0x0007106e, 0x0007146e,
		       0x0007186e, 0x00071c6e, 0x0007206e, 0x0007246e,
		       0x0007286e, 0x00072c6e, 0x0007306e, 0x0007346e,
		       0x0007386e, 0x00073c6e, 0x0007406e, 0x0007446e,
		       0x0007486e, 0x00074c6e, 0x0007506e, 0x0007546e,
		       0x0007586e, 0x00075c6e, 0x0007606e, 0x0007646e,
		       0x0007686e, 0x00076c6e, 0x0007706e, 0x0007746e,
		       0x0007786e, 0x00077c6e, 0x0007806e, 0x0007846e,
		       0x0007886e, 0x00078c6e, 0x0007906e, 0x0007946e,
		       0x0007986e, 0x00079c6e, 0x0007a06e, 0x0007a46e,
		       0x0007a86e, 0x0007ac6e, 0x0007b06e, 0x0007b46e,
		       0x0007b86e, 0x0007bc6e, 0x0007c06e, 0x0007c46e,
		       0x0007c86e, 0x0007cc6e, 0x0007d06e, 0x0007d46e,
		       0x0007d86e, 0x0007dc6e, 0x0007e06e, 0x0007e46e,
		       0x0007e86e, 0x0007ec6e, 0x0007f06e, 0x0007f46e,
		       0x0007f86e, 0x0007fc6e, 0x0000000d, 0x0000010d,
		       0x0000020d, 0x0000030d, 0x0000040d, 0x0000050d,
		       0x0000060d, 0x0000070d, 0x0000080d, 0x0000090d,
		       0x00000a0d, 0x00000b0d, 0x00000c0d, 0x00000d0d,
		       0x00000e0d, 0x00000f0d, 0x0000100d, 0x0000110d,
		       0x0000120d, 0x0000130d, 0x0000140d, 0x0000150d,
		       0x0000160d, 0x0000170d, 0x0000180d, 0x0000190d,
		       0x00001a0d, 0x00001b0d, 0x00001c0d, 0x00001d0d,
		       0x00001e0d, 0x00001f0d, 0x0000200d, 0x0000210d,
		       0x0000220d, 0x0000230d, 0x0000240d, 0x0000250d,
		       0x0000260d, 0x0000270d, 0x0000280d, 0x0000290d,
		       0x00002a0d, 0x00002b0d, 0x00002c0d, 0x00002d0d,
		       0x00002e0d, 0x00002f0d, 0x0000300d, 0x0000310d,
		       0x0000320d, 0x0000330d, 0x0000340d, 0x0000350d,
		       0x0000360d, 0x0000370d, 0x0000380d, 0x0000390d,
		       0x00003a0d, 0x00003b0d, 0x00003c0d, 0x00003d0d,
		       0x00003e0d, 0x00003f0d, 0x0000400d, 0x0000410d,
		       0x0000420d, 0x0000430d, 0x0000440d, 0x0000450d,
		       0x0000460d, 0x0000470d, 0x0000480d, 0x0000490d,
		       0x00004a0d, 0x00004b0d, 0x00004c0d, 0x00004d0d,
		       0x00004e0d, 0x00004f0d, 0x0000500d, 0x0000510d,
		       0x0000520d, 0x0000530d, 0x0000540d, 0x0000550d,
		       0x0000560d, 0x0000570d, 0x0000580d, 0x0000590d,
		       0x00005a0d, 0x00005b0d, 0x00005c0d, 0x00005d0d,
		       0x00005e0d, 0x00005f0d, 0x0000600d, 0x0000610d,
		       0x0000620d, 0x0000630d, 0x0000640d, 0x0000650d,
		       0x0000660d, 0x0000670d, 0x0000680d, 0x0000690d,
		       0x00006a0d, 0x00006b0d, 0x00006c0d, 0x00006d0d,
		       0x00006e0d, 0x00006f0d, 0x0000700d, 0x0000710d,
		       0x0000720d, 0x0000730d, 0x0000740d, 0x0000750d,
		       0x0000760d, 0x0000770d, 0x0000780d, 0x0000790d,
		       0x00007a0d, 0x00007b0d, 0x00007c0d, 0x00007d0d,
		       0x00007e0d, 0x00007f0d, 0x0000800d, 0x0000810d,
		       0x0000820d, 0x0000830d, 0x0000840d, 0x0000850d,
		       0x0000860d, 0x0000870d, 0x0000880d, 0x0000890d,
		       0x00008a0d, 0x00008b0d, 0x00008c0d, 0x00008d0d,
		       0x00008e0d, 0x00008f0d, 0x0000900d, 0x0000910d,
		       0x0000920d, 0x0000930d, 0x0000940d, 0x0000950d,
		       0x0000960d, 0x0000970d, 0x0000980d, 0x0000990d,
		       0x00009a0d, 0x00009b0d, 0x00009c0d, 0x00009d0d,
		       0x00009e0d, 0x00009f0d, 0x0000a00d, 0x0000a10d,
		       0x0000a20d, 0x0000a30d, 0x0000a40d, 0x0000a50d,
		       0x0000a60d, 0x0000a70d, 0x0000a80d, 0x0000a90d,
		       0x0000aa0d, 0x0000ab0d, 0x0000ac0d, 0x0000ad0d,
		       0x0000ae0d, 0x0000af0d, 0x0000b00d, 0x0000b10d,
		       0x0000b20d, 0x0000b30d, 0x0000b40d, 0x0000b50d,
		       0x0000b60d, 0x0000b70d, 0x0000b80d, 0x0000b90d,
		       0x0000ba0d, 0x0000bb0d, 0x0000bc0d, 0x0000bd0d,
		       0x0000be0d, 0x0000bf0d, 0x0000c00d, 0x0000c10d,
		       0x0000c20d, 0x0000c30d, 0x0000c40d, 0x0000c50d,
		       0x0000c60d, 0x0000c70d, 0x0000c80d, 0x0000c90d,
		       0x0000ca0d, 0x0000cb0d, 0x0000cc0d, 0x0000cd0d,
		       0x0000ce0d, 0x0000cf0d, 0x0000d00d, 0x0000d10d,
		       0x0000d20d, 0x0000d30d, 0x0000d40d, 0x0000d50d,
		       0x0000d60d, 0x0000d70d, 0x0000d80d, 0x0000d90d,
		       0x0000da0d, 0x0000db0d, 0x0000dc0d, 0x0000dd0d,
		       0x0000de0d, 0x0000df0d, 0x0000e00d, 0x0000e10d,
		       0x0000e20d, 0x0000e30d, 0x0000e40d, 0x0000e50d,
		       0x0000e60d, 0x0000e70d, 0x0000e80d, 0x0000e90d,
		       0x0000ea0d, 0x0000eb0d, 0x0000ec0d, 0x0000ed0d,
		       0x0000ee0d, 0x0000ef0d, 0x0000f00d, 0x0000f10d,
		       0x0000f20d, 0x0000f30d, 0x0000f40d, 0x0000f50d,
		       0x0000f60d, 0x0000f70d, 0x0000f80d, 0x0000f90d,
		       0x0000fa0d, 0x0000fb0d, 0x0000fc0d, 0x0000fd0d,
		       0x0000fe0d, 0x0000ff0d, 0x0001000d, 0x0001010d,
		       0x0001020d, 0x0001030d, 0x0001040d, 0x0001050d,
		       0x0001060d, 0x0001070d, 0x0001080d, 0x0001090d,
		       0x00010a0d, 0x00010b0d, 0x00010c0d, 0x00010d0d,
		       0x00010e0d, 0x00010f0d, 0x0001100d, 0x0001110d,
		       0x0001120d, 0x0001130d, 0x0001140d, 0x0001150d,
		       0x0001160d, 0x0001170d, 0x0001180d, 0x0001190d,
		       0x00011a0d, 0x00011b0d, 0x00011c0d, 0x00011d0d,
		       0x00011e0d, 0x00011f0d, 0x0001200d, 0x0001210d,
		       0x0001220d, 0x0001230d, 0x0001240d, 0x0001250d,
		       0x0001260d, 0x0001270d, 0x0001280d, 0x0001290d,
		       0x00012a0d, 0x00012b0d, 0x00012c0d, 0x00012d0d,
		       0x00012e0d, 0x00012f0d, 0x0001300d, 0x0001310d,
		       0x0001320d, 0x0001330d, 0x0001340d, 0x0001350d,
		       0x0001360d, 0x0001370d, 0x0001380d, 0x0001390d,
		       0x00013a0d, 0x00013b0d, 0x00013c0d, 0x00013d0d,
		       0x00013e0d, 0x00013f0d, 0x0001400d, 0x0001410d,
		       0x0001420d, 0x0001430d, 0x0001440d, 0x0001450d,
		       0x0001460d, 0x0001470d, 0x0001480d, 0x0001490d,
		       0x00014a0d, 0x00014b0d, 0x00014c0d, 0x00014d0d,
		       0x00014e0d, 0x00014f0d, 0x0001500d, 0x0001510d,
		       0x0001520d, 0x0001530d, 0x0001540d, 0x0001550d,
		       0x0001560d, 0x0001570d, 0x0001580d, 0x0001590d,
		       0x00015a0d, 0x00015b0d, 0x00015c0d, 0x00015d0d,
		       0x00015e0d, 0x00015f0d, 0x0001600d, 0x0001610d,
		       0x0001620d, 0x0001630d, 0x0001640d, 0x0001650d,
		       0x0001660d, 0x0001670d, 0x0001680d, 0x0001690d,
		       0x00016a0d, 0x00016b0d, 0x00016c0d, 0x00016d0d,
		       0x00016e0d, 0x00016f0d, 0x0001700d, 0x0001710d,
		       0x0001720d, 0x0001730d, 0x0001740d, 0x0001750d,
		       0x0001760d, 0x0001770d, 0x0001780d, 0x0001790d,
		       0x00017a0d, 0x00017b0d, 0x00017c0d, 0x00017d0d,
		       0x00017e0d, 0x00017f0d, 0x0001800d, 0x0001810d,
		       0x0001820d, 0x0001830d, 0x0001840d, 0x0001850d,
		       0x0001860d, 0x0001870d, 0x0001880d, 0x0001890d,
		       0x00018a0d, 0x00018b0d, 0x00018c0d, 0x00018d0d,
		       0x00018e0d, 0x00018f0d, 0x0001900d, 0x0001910d,
		       0x0001920d, 0x0001930d, 0x0001940d, 0x0001950d,
		       0x0001960d, 0x0001970d, 0x0001980d, 0x0001990d,
		       0x00019a0d, 0x00019b0d, 0x00019c0d, 0x00019d0d,
		       0x00019e0d, 0x00019f0d, 0x0001a00d, 0x0001a10d,
		       0x0001a20d, 0x0001a30d, 0x0001a40d, 0x0001a50d,
		       0x0001a60d, 0x0001a70d, 0x0001a80d, 0x0001a90d,
		       0x0001aa0d, 0x0001ab0d, 0x0001ac0d, 0x0001ad0d,
		       0x0001ae0d, 0x0001af0d, 0x0001b00d, 0x0001b10d,
		       0x0001b20d, 0x0001b30d, 0x0001b40d, 0x0001b50d,
		       0x0001b60d, 0x0001b70d, 0x0001b80d, 0x0001b90d,
		       0x0001ba0d, 0x0001bb0d, 0x0001bc0d, 0x0001bd0d,
		       0x0001be0d, 0x0001bf0d, 0x0001c00d, 0x0001c10d,
		       0x0001c20d, 0x0001c30d, 0x0001c40d, 0x0001c50d,
		       0x0001c60d, 0x0001c70d, 0x0001c80d, 0x0001c90d,
		       0x0001ca0d, 0x0001cb0d, 0x0001cc0d, 0x0001cd0d,
		       0x0001ce0d, 0x0001cf0d, 0x0001d00d, 0x0001d10d,
		       0x0001d20d, 0x0001d30d, 0x0001d40d, 0x0001d50d,
		       0x0001d60d, 0x0001d70d, 0x0001d80d, 0x0001d90d,
		       0x0001da0d, 0x0001db0d, 0x0001dc0d, 0x0001dd0d,
		       0x0001de0d, 0x0001df0d, 0x0001e00d, 0x0001e10d,
		       0x0001e20d, 0x0001e30d, 0x0001e40d, 0x0001e50d,
		       0x0001e60d, 0x0001e70d, 0x0001e80d, 0x0001e90d,
		       0x0001ea0d, 0x0001eb0d, 0x0001ec0d, 0x0001ed0d,
		       0x0001ee0d, 0x0001ef0d, 0x0001f00d, 0x0001f10d,
		       0x0001f20d, 0x0001f30d, 0x0001f40d, 0x0001f50d,
		       0x0001f60d, 0x0001f70d, 0x0001f80d, 0x0001f90d,
		       0x0001fa0d, 0x0001fb0d, 0x0001fc0d, 0x0001fd0d,
		       0x0001fe0d, 0x0001ff0d, 0x0002000d, 0x0002010d,
		       0x0002020d, 0x0002030d, 0x0002040d, 0x0002050d,
		       0x0002060d, 0x0002070d, 0x0002080d, 0x0002090d,
		       0x00020a0d, 0x00020b0d, 0x00020c0d, 0x00020d0d,
		       0x00020e0d, 0x00020f0d, 0x0002100d, 0x0002110d,
		       0x0002120d, 0x0002130d, 0x0002140d, 0x0002150d,
		       0x0002160d, 0x0002170d, 0x0002180d, 0x0002190d,
		       0x00021a0d, 0x00021b0d, 0x00021c0d, 0x00021d0d,
		       0x00021e0d, 0x00021f0d, 0x0002200d, 0x0002210d,
		       0x0002220d, 0x0002230d, 0x0002240d, 0x0002250d,
		       0x0002260d, 0x0002270d, 0x0002280d, 0x0002290d,
		       0x00022a0d, 0x00022b0d, 0x00022c0d, 0x00022d0d,
		       0x00022e0d, 0x00022f0d, 0x0002300d, 0x0002310d,
		       0x0002320d, 0x0002330d, 0x0002340d, 0x0002350d,
		       0x0002360d, 0x0002370d, 0x0002380d, 0x0002390d,
		       0x00023a0d, 0x00023b0d, 0x00023c0d, 0x00023d0d,
		       0x00023e0d, 0x00023f0d, 0x0002400d, 0x0002410d,
		       0x0002420d, 0x0002430d, 0x0002440d, 0x0002450d,
		       0x0002460d, 0x0002470d, 0x0002480d, 0x0002490d,
		       0x00024a0d, 0x00024b0d, 0x00024c0d, 0x00024d0d,
		       0x00024e0d, 0x00024f0d, 0x0002500d, 0x0002510d,
		       0x0002520d, 0x0002530d, 0x0002540d, 0x0002550d,
		       0x0002560d, 0x0002570d, 0x0002580d, 0x0002590d,
		       0x00025a0d, 0x00025b0d, 0x00025c0d, 0x00025d0d,
		       0x00025e0d, 0x00025f0d, 0x0002600d, 0x0002610d,
		       0x0002620d, 0x0002630d, 0x0002640d, 0x0002650d,
		       0x0002660d, 0x0002670d, 0x0002680d, 0x0002690d,
		       0x00026a0d, 0x00026b0d, 0x00026c0d, 0x00026d0d,
		       0x00026e0d, 0x00026f0d, 0x0002700d, 0x0002710d,
		       0x0002720d, 0x0002730d, 0x0002740d, 0x0002750d,
		       0x0002760d, 0x0002770d, 0x0002780d, 0x0002790d,
		       0x00027a0d, 0x00027b0d, 0x00027c0d, 0x00027d0d,
		       0x00027e0d, 0x00027f0d, 0x0002800d, 0x0002810d,
		       0x0002820d, 0x0002830d, 0x0002840d, 0x0002850d,
		       0x0002860d, 0x0002870d, 0x0002880d, 0x0002890d,
		       0x00028a0d, 0x00028b0d, 0x00028c0d, 0x00028d0d,
		       0x00028e0d, 0x00028f0d, 0x0002900d, 0x0002910d,
		       0x0002920d, 0x0002930d, 0x0002940d, 0x0002950d,
		       0x0002960d, 0x0002970d, 0x0002980d, 0x0002990d,
		       0x00029a0d, 0x00029b0d, 0x00029c0d, 0x00029d0d,
		       0x00029e0d, 0x00029f0d, 0x0002a00d, 0x0002a10d,
		       0x0002a20d, 0x0002a30d, 0x0002a40d, 0x0002a50d,
		       0x0002a60d, 0x0002a70d, 0x0002a80d, 0x0002a90d,
		       0x0002aa0d, 0x0002ab0d, 0x0002ac0d, 0x0002ad0d,
		       0x0002ae0d, 0x0002af0d, 0x0002b00d, 0x0002b10d,
		       0x0002b20d, 0x0002b30d, 0x0002b40d, 0x0002b50d,
		       0x0002b60d, 0x0002b70d, 0x0002b80d, 0x0002b90d,
		       0x0002ba0d, 0x0002bb0d, 0x0002bc0d, 0x0002bd0d,
		       0x0002be0d, 0x0002bf0d, 0x0002c00d, 0x0002c10d,
		       0x0002c20d, 0x0002c30d, 0x0002c40d, 0x0002c50d,
		       0x0002c60d, 0x0002c70d, 0x0002c80d, 0x0002c90d,
		       0x0002ca0d, 0x0002cb0d, 0x0002cc0d, 0x0002cd0d,
		       0x0002ce0d, 0x0002cf0d, 0x0002d00d, 0x0002d10d,
		       0x0002d20d, 0x0002d30d, 0x0002d40d, 0x0002d50d,
		       0x0002d60d, 0x0002d70d, 0x0002d80d, 0x0002d90d,
		       0x0002da0d, 0x0002db0d, 0x0002dc0d, 0x0002dd0d,
		       0x0002de0d, 0x0002df0d, 0x0002e00d, 0x0002e10d,
		       0x0002e20d, 0x0002e30d, 0x0002e40d, 0x0002e50d,
		       0x0002e60d, 0x0002e70d, 0x0002e80d, 0x0002e90d,
		       0x0002ea0d, 0x0002eb0d, 0x0002ec0d, 0x0002ed0d,
		       0x0002ee0d, 0x0002ef0d, 0x0002f00d, 0x0002f10d,
		       0x0002f20d, 0x0002f30d, 0x0002f40d, 0x0002f50d,
		       0x0002f60d, 0x0002f70d, 0x0002f80d, 0x0002f90d,
		       0x0002fa0d, 0x0002fb0d, 0x0002fc0d, 0x0002fd0d,
		       0x0002fe0d, 0x0002ff0d, 0x0003000d, 0x0003010d,
		       0x0003020d, 0x0003030d, 0x0003040d, 0x0003050d,
		       0x0003060d, 0x0003070d, 0x0003080d, 0x0003090d,
		       0x00030a0d, 0x00030b0d, 0x00030c0d, 0x00030d0d,
		       0x00030e0d, 0x00030f0d, 0x0003100d, 0x0003110d,
		       0x0003120d, 0x0003130d, 0x0003140d, 0x0003150d,
		       0x0003160d, 0x0003170d, 0x0003180d, 0x0003190d,
		       0x00031a0d, 0x00031b0d, 0x00031c0d, 0x00031d0d,
		       0x00031e0d, 0x00031f0d, 0x0003200d, 0x0003210d,
		       0x0003220d, 0x0003230d, 0x0003240d, 0x0003250d,
		       0x0003260d, 0x0003270d, 0x0003280d, 0x0003290d,
		       0x00032a0d, 0x00032b0d, 0x00032c0d, 0x00032d0d,
		       0x00032e0d, 0x00032f0d, 0x0003300d, 0x0003310d,
		       0x0003320d, 0x0003330d, 0x0003340d, 0x0003350d,
		       0x0003360d, 0x0003370d, 0x0003380d, 0x0003390d,
		       0x00033a0d, 0x00033b0d, 0x00033c0d, 0x00033d0d,
		       0x00033e0d, 0x00033f0d, 0x0003400d, 0x0003410d,
		       0x0003420d, 0x0003430d, 0x0003440d, 0x0003450d,
		       0x0003460d, 0x0003470d, 0x0003480d, 0x0003490d,
		       0x00034a0d, 0x00034b0d, 0x00034c0d, 0x00034d0d,
		       0x00034e0d, 0x00034f0d, 0x0003500d, 0x0003510d,
		       0x0003520d, 0x0003530d, 0x0003540d, 0x0003550d,
		       0x0003560d, 0x0003570d, 0x0003580d, 0x0003590d,
		       0x00035a0d, 0x00035b0d, 0x00035c0d, 0x00035d0d,
		       0x00035e0d, 0x00035f0d, 0x0003600d, 0x0003610d,
		       0x0003620d, 0x0003630d, 0x0003640d, 0x0003650d,
		       0x0003660d, 0x0003670d, 0x0003680d, 0x0003690d,
		       0x00036a0d, 0x00036b0d, 0x00036c0d, 0x00036d0d,
		       0x00036e0d, 0x00036f0d, 0x0003700d, 0x0003710d,
		       0x0003720d, 0x0003730d, 0x0003740d, 0x0003750d,
		       0x0003760d, 0x0003770d, 0x0003780d, 0x0003790d,
		       0x00037a0d, 0x00037b0d, 0x00037c0d, 0x00037d0d,
		       0x00037e0d, 0x00037f0d, 0x0003800d, 0x0003810d,
		       0x0003820d, 0x0003830d, 0x0003840d, 0x0003850d,
		       0x0003860d, 0x0003870d, 0x0003880d, 0x0003890d,
		       0x00038a0d, 0x00038b0d, 0x00038c0d, 0x00038d0d,
		       0x00038e0d, 0x00038f0d, 0x0003900d, 0x0003910d,
		       0x0003920d, 0x0003930d, 0x0003940d, 0x0003950d,
		       0x0003960d, 0x0003970d, 0x0003980d, 0x0003990d,
		       0x00039a0d, 0x00039b0d, 0x00039c0d, 0x00039d0d,
		       0x00039e0d, 0x00039f0d, 0x0003a00d, 0x0003a10d,
		       0x0003a20d, 0x0003a30d, 0x0003a40d, 0x0003a50d,
		       0x0003a60d, 0x0003a70d, 0x0003a80d, 0x0003a90d,
		       0x0003aa0d, 0x0003ab0d, 0x0003ac0d, 0x0003ad0d,
		       0x0003ae0d, 0x0003af0d, 0x0003b00d, 0x0003b10d,
		       0x0003b20d, 0x0003b30d, 0x0003b40d, 0x0003b50d,
		       0x0003b60d, 0x0003b70d, 0x0003b80d, 0x0003b90d,
		       0x0003ba0d, 0x0003bb0d, 0x0003bc0d, 0x0003bd0d,
		       0x0003be0d, 0x0003bf0d, 0x0003c00d, 0x0003c10d,
		       0x0003c20d, 0x0003c30d, 0x0003c40d, 0x0003c50d,
		       0x0003c60d, 0x0003c70d, 0x0003c80d, 0x0003c90d,
		       0x0003ca0d, 0x0003cb0d, 0x0003cc0d, 0x0003cd0d,
		       0x0003ce0d, 0x0003cf0d, 0x0003d00d, 0x0003d10d,
		       0x0003d20d, 0x0003d30d, 0x0003d40d, 0x0003d50d,
		       0x0003d60d, 0x0003d70d, 0x0003d80d, 0x0003d90d,
		       0x0003da0d, 0x0003db0d, 0x0003dc0d, 0x0003dd0d,
		       0x0003de0d, 0x0003df0d, 0x0003e00d, 0x0003e10d,
		       0x0003e20d, 0x0003e30d, 0x0003e40d, 0x0003e50d,
		       0x0003e60d, 0x0003e70d, 0x0003e80d, 0x0003e90d,
		       0x0003ea0d, 0x0003eb0d, 0x0003ec0d, 0x0003ed0d,
		       0x0003ee0d, 0x0003ef0d, 0x0003f00d, 0x0003f10d,
		       0x0003f20d, 0x0003f30d, 0x0003f40d, 0x0003f50d,
		       0x0003f60d, 0x0003f70d, 0x0003f80d, 0x0003f90d,
		       0x0003fa0d, 0x0003fb0d, 0x0003fc0d, 0x0003fd0d,
		       0x0003fe0d, 0x0003ff0d, 0x0000026f, 0x0000066f,
		       0x00000a6f, 0x00000e6f, 0x0000126f, 0x0000166f,
		       0x00001a6f, 0x00001e6f, 0x0000226f, 0x0000266f,
		       0x00002a6f, 0x00002e6f, 0x0000326f, 0x0000366f,
		       0x00003a6f, 0x00003e6f, 0x0000426f, 0x0000466f,
		       0x00004a6f, 0x00004e6f, 0x0000526f, 0x0000566f,
		       0x00005a6f, 0x00005e6f, 0x0000626f, 0x0000666f,
		       0x00006a6f, 0x00006e6f, 0x0000726f, 0x0000766f,
		       0x00007a6f, 0x00007e6f, 0x0000826f, 0x0000866f,
		       0x00008a6f, 0x00008e6f, 0x0000926f, 0x0000966f,
		       0x00009a6f, 0x00009e6f, 0x0000a26f, 0x0000a66f,
		       0x0000aa6f, 0x0000ae6f, 0x0000b26f, 0x0000b66f,
		       0x0000ba6f, 0x0000be6f, 0x0000c26f, 0x0000c66f,
		       0x0000ca6f, 0x0000ce6f, 0x0000d26f, 0x0000d66f,
		       0x0000da6f, 0x0000de6f, 0x0000e26f, 0x0000e66f,
		       0x0000ea6f, 0x0000ee6f, 0x0000f26f, 0x0000f66f,
		       0x0000fa6f, 0x0000fe6f, 0x0001026f, 0x0001066f,
		       0x00010a6f, 0x00010e6f, 0x0001126f, 0x0001166f,
		       0x00011a6f, 0x00011e6f, 0x0001226f, 0x0001266f,
		       0x00012a6f, 0x00012e6f, 0x0001326f, 0x0001366f,
		       0x00013a6f, 0x00013e6f, 0x0001426f, 0x0001466f,
		       0x00014a6f, 0x00014e6f, 0x0001526f, 0x0001566f,
		       0x00015a6f, 0x00015e6f, 0x0001626f, 0x0001666f,
		       0x00016a6f, 0x00016e6f, 0x0001726f, 0x0001766f,
		       0x00017a6f, 0x00017e6f, 0x0001826f, 0x0001866f,
		       0x00018a6f, 0x00018e6f, 0x0001926f, 0x0001966f,
		       0x00019a6f, 0x00019e6f, 0x0001a26f, 0x0001a66f,
		       0x0001aa6f, 0x0001ae6f, 0x0001b26f, 0x0001b66f,
		       0x0001ba6f, 0x0001be6f, 0x0001c26f, 0x0001c66f,
		       0x0001ca6f, 0x0001ce6f, 0x0001d26f, 0x0001d66f,
		       0x0001da6f, 0x0001de6f, 0x0001e26f, 0x0001e66f,
		       0x0001ea6f, 0x0001ee6f, 0x0001f26f, 0x0001f66f,
		       0x0001fa6f, 0x0001fe6f, 0x0002026f, 0x0002066f,
		       0x00020a6f, 0x00020e6f, 0x0002126f, 0x0002166f,
		       0x00021a6f, 0x00021e6f, 0x0002226f, 0x0002266f,
		       0x00022a6f, 0x00022e6f, 0x0002326f, 0x0002366f,
		       0x00023a6f, 0x00023e6f, 0x0002426f, 0x0002466f,
		       0x00024a6f, 0x00024e6f, 0x0002526f, 0x0002566f,
		       0x00025a6f, 0x00025e6f, 0x0002626f, 0x0002666f,
		       0x00026a6f, 0x00026e6f, 0x0002726f, 0x0002766f,
		       0x00027a6f, 0x00027e6f, 0x0002826f, 0x0002866f,
		       0x00028a6f, 0x00028e6f, 0x0002926f, 0x0002966f,
		       0x00029a6f, 0x00029e6f, 0x0002a26f, 0x0002a66f,
		       0x0002aa6f, 0x0002ae6f, 0x0002b26f, 0x0002b66f,
		       0x0002ba6f, 0x0002be6f, 0x0002c26f, 0x0002c66f,
		       0x0002ca6f, 0x0002ce6f, 0x0002d26f, 0x0002d66f,
		       0x0002da6f, 0x0002de6f, 0x0002e26f, 0x0002e66f,
		       0x0002ea6f, 0x0002ee6f, 0x0002f26f, 0x0002f66f,
		       0x0002fa6f, 0x0002fe6f, 0x0003026f, 0x0003066f,
		       0x00030a6f, 0x00030e6f, 0x0003126f, 0x0003166f,
		       0x00031a6f, 0x00031e6f, 0x0003226f, 0x0003266f,
		       0x00032a6f, 0x00032e6f, 0x0003326f, 0x0003366f,
		       0x00033a6f, 0x00033e6f, 0x0003426f, 0x0003466f,
		       0x00034a6f, 0x00034e6f, 0x0003526f, 0x0003566f,
		       0x00035a6f, 0x00035e6f, 0x0003626f, 0x0003666f,
		       0x00036a6f, 0x00036e6f, 0x0003726f, 0x0003766f,
		       0x00037a6f, 0x00037e6f, 0x0003826f, 0x0003866f,
		       0x00038a6f, 0x00038e6f, 0x0003926f, 0x0003966f,
		       0x00039a6f, 0x00039e6f, 0x0003a26f, 0x0003a66f,
		       0x0003aa6f, 0x0003ae6f, 0x0003b26f, 0x0003b66f,
		       0x0003ba6f, 0x0003be6f, 0x0003c26f, 0x0003c66f,
		       0x0003ca6f, 0x0003ce6f, 0x0003d26f, 0x0003d66f,
		       0x0003da6f, 0x0003de6f, 0x0003e26f, 0x0003e66f,
		       0x0003ea6f, 0x0003ee6f, 0x0003f26f, 0x0003f66f,
		       0x0003fa6f, 0x0003fe6f, 0x0004026f, 0x0004066f,
		       0x00040a6f, 0x00040e6f, 0x0004126f, 0x0004166f,
		       0x00041a6f, 0x00041e6f, 0x0004226f, 0x0004266f,
		       0x00042a6f, 0x00042e6f, 0x0004326f, 0x0004366f,
		       0x00043a6f, 0x00043e6f, 0x0004426f, 0x0004466f,
		       0x00044a6f, 0x00044e6f, 0x0004526f, 0x0004566f,
		       0x00045a6f, 0x00045e6f, 0x0004626f, 0x0004666f,
		       0x00046a6f, 0x00046e6f, 0x0004726f, 0x0004766f,
		       0x00047a6f, 0x00047e6f, 0x0004826f, 0x0004866f,
		       0x00048a6f, 0x00048e6f, 0x0004926f, 0x0004966f,
		       0x00049a6f, 0x00049e6f, 0x0004a26f, 0x0004a66f,
		       0x0004aa6f, 0x0004ae6f, 0x0004b26f, 0x0004b66f,
		       0x0004ba6f, 0x0004be6f, 0x0004c26f, 0x0004c66f,
		       0x0004ca6f, 0x0004ce6f, 0x0004d26f, 0x0004d66f,
		       0x0004da6f, 0x0004de6f, 0x0004e26f, 0x0004e66f,
		       0x0004ea6f, 0x0004ee6f, 0x0004f26f, 0x0004f66f,
		       0x0004fa6f, 0x0004fe6f, 0x0005026f, 0x0005066f,
		       0x00050a6f, 0x00050e6f, 0x0005126f, 0x0005166f,
		       0x00051a6f, 0x00051e6f, 0x0005226f, 0x0005266f,
		       0x00052a6f, 0x00052e6f, 0x0005326f, 0x0005366f,
		       0x00053a6f, 0x00053e6f, 0x0005426f, 0x0005466f,
		       0x00054a6f, 0x00054e6f, 0x0005526f, 0x0005566f,
		       0x00055a6f, 0x00055e6f, 0x0005626f, 0x0005666f,
		       0x00056a6f, 0x00056e6f, 0x0005726f, 0x0005766f,
		       0x00057a6f, 0x00057e6f, 0x0005826f, 0x0005866f,
		       0x00058a6f, 0x00058e6f, 0x0005926f, 0x0005966f,
		       0x00059a6f, 0x00059e6f, 0x0005a26f, 0x0005a66f,
		       0x0005aa6f, 0x0005ae6f, 0x0005b26f, 0x0005b66f,
		       0x0005ba6f, 0x0005be6f, 0x0005c26f, 0x0005c66f,
		       0x0005ca6f, 0x0005ce6f, 0x0005d26f, 0x0005d66f,
		       0x0005da6f, 0x0005de6f, 0x0005e26f, 0x0005e66f,
		       0x0005ea6f, 0x0005ee6f, 0x0005f26f, 0x0005f66f,
		       0x0005fa6f, 0x0005fe6f, 0x0006026f, 0x0006066f,
		       0x00060a6f, 0x00060e6f, 0x0006126f, 0x0006166f,
		       0x00061a6f, 0x00061e6f, 0x0006226f, 0x0006266f,
		       0x00062a6f, 0x00062e6f, 0x0006326f, 0x0006366f,
		       0x00063a6f, 0x00063e6f, 0x0006426f, 0x0006466f,
		       0x00064a6f, 0x00064e6f, 0x0006526f, 0x0006566f,
		       0x00065a6f, 0x00065e6f, 0x0006626f, 0x0006666f,
		       0x00066a6f, 0x00066e6f, 0x0006726f, 0x0006766f,
		       0x00067a6f, 0x00067e6f, 0x0006826f, 0x0006866f,
		       0x00068a6f, 0x00068e6f, 0x0006926f, 0x0006966f,
		       0x00069a6f, 0x00069e6f, 0x0006a26f, 0x0006a66f,
		       0x0006aa6f, 0x0006ae6f, 0x0006b26f, 0x0006b66f,
		       0x0006ba6f, 0x0006be6f, 0x0006c26f, 0x0006c66f,
		       0x0006ca6f, 0x0006ce6f, 0x0006d26f, 0x0006d66f,
		       0x0006da6f, 0x0006de6f, 0x0006e26f, 0x0006e66f,
		       0x0006ea6f, 0x0006ee6f, 0x0006f26f, 0x0006f66f,
		       0x0006fa6f, 0x0006fe6f, 0x0007026f, 0x0007066f,
		       0x00070a6f, 0x00070e6f, 0x0007126f, 0x0007166f,
		       0x00071a6f, 0x00071e6f, 0x0007226f, 0x0007266f,
		       0x00072a6f, 0x00072e6f, 0x0007326f, 0x0007366f,
		       0x00073a6f, 0x00073e6f, 0x0007426f, 0x0007466f,
		       0x00074a6f, 0x00074e6f, 0x0007526f, 0x0007566f,
		       0x00075a6f, 0x00075e6f, 0x0007626f, 0x0007666f,
		       0x00076a6f, 0x00076e6f, 0x0007726f, 0x0007766f,
		       0x00077a6f, 0x00077e6f, 0x0007826f, 0x0007866f,
		       0x00078a6f, 0x00078e6f, 0x0007926f, 0x0007966f,
		       0x00079a6f, 0x00079e6f, 0x0007a26f, 0x0007a66f,
		       0x0007aa6f, 0x0007ae6f, 0x0007b26f, 0x0007b66f,
		       0x0007ba6f, 0x0007be6f, 0x0007c26f, 0x0007c66f,
		       0x0007ca6f, 0x0007ce6f, 0x0007d26f, 0x0007d66f,
		       0x0007da6f, 0x0007de6f, 0x0007e26f, 0x0007e66f,
		       0x0007ea6f, 0x0007ee6f, 0x0007f26f, 0x0007f66f,
		       0x0007fa6f, 0x0007fe6f, 0x0008026f, 0x0008066f,
		       0x00080a6f, 0x00080e6f, 0x0008126f, 0x0008166f,
		       0x00081a6f, 0x00081e6f, 0x0008226f, 0x0008266f,
		       0x00082a6f, 0x00082e6f, 0x0008326f, 0x0008366f,
		       0x00083a6f, 0x00083e6f, 0x0008426f, 0x0008466f,
		       0x00084a6f, 0x00084e6f, 0x0008526f, 0x0008566f,
		       0x00085a6f, 0x00085e6f, 0x0008626f, 0x0008666f,
		       0x00086a6f, 0x00086e6f, 0x0008726f, 0x0008766f,
		       0x00087a6f, 0x00087e6f, 0x0008826f, 0x0008866f,
		       0x00088a6f, 0x00088e6f, 0x0008926f, 0x0008966f,
		       0x00089a6f, 0x00089e6f, 0x0008a26f, 0x0008a66f,
		       0x0008aa6f, 0x0008ae6f, 0x0008b26f, 0x0008b66f,
		       0x0008ba6f, 0x0008be6f, 0x0008c26f, 0x0008c66f,
		       0x0008ca6f, 0x0008ce6f, 0x0008d26f, 0x0008d66f,
		       0x0008da6f, 0x0008de6f, 0x0008e26f, 0x0008e66f,
		       0x0008ea6f, 0x0008ee6f, 0x0008f26f, 0x0008f66f,
		       0x0008fa6f, 0x0008fe6f, 0x0009026f, 0x0009066f,
		       0x00090a6f, 0x00090e6f, 0x0009126f, 0x0009166f,
		       0x00091a6f, 0x00091e6f, 0x0009226f, 0x0009266f,
		       0x00092a6f, 0x00092e6f, 0x0009326f, 0x0009366f,
		       0x00093a6f, 0x00093e6f, 0x0009426f, 0x0009466f,
		       0x00094a6f, 0x00094e6f, 0x0009526f, 0x0009566f,
		       0x00095a6f, 0x00095e6f, 0x0009626f, 0x0009666f,
		       0x00096a6f, 0x00096e6f, 0x0009726f, 0x0009766f,
		       0x00097a6f, 0x00097e6f, 0x0009826f, 0x0009866f,
		       0x00098a6f, 0x00098e6f, 0x0009926f, 0x0009966f,
		       0x00099a6f, 0x00099e6f, 0x0009a26f, 0x0009a66f,
		       0x0009aa6f, 0x0009ae6f, 0x0009b26f, 0x0009b66f,
		       0x0009ba6f, 0x0009be6f, 0x0009c26f, 0x0009c66f,
		       0x0009ca6f, 0x0009ce6f, 0x0009d26f, 0x0009d66f,
		       0x0009da6f, 0x0009de6f, 0x0009e26f, 0x0009e66f,
		       0x0009ea6f, 0x0009ee6f, 0x0009f26f, 0x0009f66f,
		       0x0009fa6f, 0x0009fe6f, 0x000a026f, 0x000a066f,
		       0x000a0a6f, 0x000a0e6f, 0x000a126f, 0x000a166f,
		       0x000a1a6f, 0x000a1e6f, 0x000a226f, 0x000a266f,
		       0x000a2a6f, 0x000a2e6f, 0x000a326f, 0x000a366f,
		       0x000a3a6f, 0x000a3e6f, 0x000a426f, 0x000a466f,
		       0x000a4a6f, 0x000a4e6f, 0x000a526f, 0x000a566f,
		       0x000a5a6f, 0x000a5e6f, 0x000a626f, 0x000a666f,
		       0x000a6a6f, 0x000a6e6f, 0x000a726f, 0x000a766f,
		       0x000a7a6f, 0x000a7e6f, 0x000a826f, 0x000a866f,
		       0x000a8a6f, 0x000a8e6f, 0x000a926f, 0x000a966f,
		       0x000a9a6f, 0x000a9e6f, 0x000aa26f, 0x000aa66f,
		       0x000aaa6f, 0x000aae6f, 0x000ab26f, 0x000ab66f,
		       0x000aba6f, 0x000abe6f, 0x000ac26f, 0x000ac66f,
		       0x000aca6f, 0x000ace6f, 0x000ad26f, 0x000ad66f,
		       0x000ada6f, 0x000ade6f, 0x000ae26f, 0x000ae66f,
		       0x000aea6f, 0x000aee6f, 0x000af26f, 0x000af66f,
		       0x000afa6f, 0x000afe6f, 0x000b026f, 0x000b066f,
		       0x000b0a6f, 0x000b0e6f, 0x000b126f, 0x000b166f,
		       0x000b1a6f, 0x000b1e6f, 0x000b226f, 0x000b266f,
		       0x000b2a6f, 0x000b2e6f, 0x000b326f, 0x000b366f,
		       0x000b3a6f, 0x000b3e6f, 0x000b426f, 0x000b466f,
		       0x000b4a6f, 0x000b4e6f, 0x000b526f, 0x000b566f,
		       0x000b5a6f, 0x000b5e6f, 0x000b626f, 0x000b666f,
		       0x000b6a6f, 0x000b6e6f, 0x000b726f, 0x000b766f,
		       0x000b7a6f, 0x000b7e6f, 0x000b826f, 0x000b866f,
		       0x000b8a6f, 0x000b8e6f, 0x000b926f, 0x000b966f,
		       0x000b9a6f, 0x000b9e6f, 0x000ba26f, 0x000ba66f,
		       0x000baa6f, 0x000bae6f, 0x000bb26f, 0x000bb66f,
		       0x000bba6f, 0x000bbe6f, 0x000bc26f, 0x000bc66f,
		       0x000bca6f, 0x000bce6f, 0x000bd26f, 0x000bd66f,
		       0x000bda6f, 0x000bde6f, 0x000be26f, 0x000be66f,
		       0x000bea6f, 0x000bee6f, 0x000bf26f, 0x000bf66f,
		       0x000bfa6f, 0x000bfe6f, 0x000c026f, 0x000c066f,
		       0x000c0a6f, 0x000c0e6f, 0x000c126f, 0x000c166f,
		       0x000c1a6f, 0x000c1e6f, 0x000c226f, 0x000c266f,
		       0x000c2a6f, 0x000c2e6f, 0x000c326f, 0x000c366f,
		       0x000c3a6f, 0x000c3e6f, 0x000c426f, 0x000c466f,
		       0x000c4a6f, 0x000c4e6f, 0x000c526f, 0x000c566f,
		       0x000c5a6f, 0x000c5e6f, 0x000c626f, 0x000c666f,
		       0x000c6a6f, 0x000c6e6f, 0x000c726f, 0x000c766f,
		       0x000c7a6f, 0x000c7e6f, 0x000c826f, 0x000c866f,
		       0x000c8a6f, 0x000c8e6f, 0x000c926f, 0x000c966f,
		       0x000c9a6f, 0x000c9e6f, 0x000ca26f, 0x000ca66f,
		       0x000caa6f, 0x000cae6f, 0x000cb26f, 0x000cb66f,
		       0x000cba6f, 0x000cbe6f, 0x000cc26f, 0x000cc66f,
		       0x000cca6f, 0x000cce6f, 0x000cd26f, 0x000cd66f,
		       0x000cda6f, 0x000cde6f, 0x000ce26f, 0x000ce66f,
		       0x000cea6f, 0x000cee6f, 0x000cf26f, 0x000cf66f,
		       0x000cfa6f, 0x000cfe6f, 0x000d026f, 0x000d066f,
		       0x000d0a6f, 0x000d0e6f, 0x000d126f, 0x000d166f,
		       0x000d1a6f, 0x000d1e6f, 0x000d226f, 0x000d266f,
		       0x000d2a6f, 0x000d2e6f, 0x000d326f, 0x000d366f,
		       0x000d3a6f, 0x000d3e6f, 0x000d426f, 0x000d466f,
		       0x000d4a6f, 0x000d4e6f, 0x000d526f, 0x000d566f,
		       0x000d5a6f, 0x000d5e6f, 0x000d626f, 0x000d666f,
		       0x000d6a6f, 0x000d6e6f, 0x000d726f, 0x000d766f,
		       0x000d7a6f, 0x000d7e6f, 0x000d826f, 0x000d866f,
		       0x000d8a6f, 0x000d8e6f, 0x000d926f, 0x000d966f,
		       0x000d9a6f, 0x000d9e6f, 0x000da26f, 0x000da66f,
		       0x000daa6f, 0x000dae6f, 0x000db26f, 0x000db66f,
		       0x000dba6f, 0x000dbe6f, 0x000dc26f, 0x000dc66f,
		       0x000dca6f, 0x000dce6f, 0x000dd26f, 0x000dd66f,
		       0x000dda6f, 0x000dde6f, 0x000de26f, 0x000de66f,
		       0x000dea6f, 0x000dee6f, 0x000df26f, 0x000df66f,
		       0x000dfa6f, 0x000dfe6f, 0x000e026f, 0x000e066f,
		       0x000e0a6f, 0x000e0e6f, 0x000e126f, 0x000e166f,
		       0x000e1a6f, 0x000e1e6f, 0x000e226f, 0x000e266f,
		       0x000e2a6f, 0x000e2e6f, 0x000e326f, 0x000e366f,
		       0x000e3a6f, 0x000e3e6f, 0x000e426f, 0x000e466f,
		       0x000e4a6f, 0x000e4e6f, 0x000e526f, 0x000e566f,
		       0x000e5a6f, 0x000e5e6f, 0x000e626f, 0x000e666f,
		       0x000e6a6f, 0x000e6e6f, 0x000e726f, 0x000e766f,
		       0x000e7a6f, 0x000e7e6f, 0x000e826f, 0x000e866f,
		       0x000e8a6f, 0x000e8e6f, 0x000e926f, 0x000e966f,
		       0x000e9a6f, 0x000e9e6f, 0x000ea26f, 0x000ea66f,
		       0x000eaa6f, 0x000eae6f, 0x000eb26f, 0x000eb66f,
		       0x000eba6f, 0x000ebe6f, 0x000ec26f, 0x000ec66f,
		       0x000eca6f, 0x000ece6f, 0x000ed26f, 0x000ed66f,
		       0x000eda6f, 0x000ede6f, 0x000ee26f, 0x000ee66f,
		       0x000eea6f, 0x000eee6f, 0x000ef26f, 0x000ef66f,
		       0x000efa6f, 0x000efe6f, 0x000f026f, 0x000f066f,
		       0x000f0a6f, 0x000f0e6f, 0x000f126f, 0x000f166f,
		       0x000f1a6f, 0x000f1e6f, 0x000f226f, 0x000f266f,
		       0x000f2a6f, 0x000f2e6f, 0x000f326f, 0x000f366f,
		       0x000f3a6f, 0x000f3e6f, 0x000f426f, 0x000f466f,
		       0x000f4a6f, 0x000f4e6f, 0x000f526f, 0x000f566f,
		       0x000f5a6f, 0x000f5e6f, 0x000f626f, 0x000f666f,
		       0x000f6a6f, 0x000f6e6f, 0x000f726f, 0x000f766f,
		       0x000f7a6f, 0x000f7e6f, 0x000f826f, 0x000f866f,
		       0x000f8a6f, 0x000f8e6f, 0x000f926f, 0x000f966f,
		       0x000f9a6f, 0x000f9e6f, 0x000fa26f, 0x000fa66f,
		       0x000faa6f, 0x000fae6f, 0x000fb26f, 0x000fb66f,
		       0x000fba6f, 0x000fbe6f, 0x000fc26f, 0x000fc66f,
		       0x000fca6f, 0x000fce6f, 0x000fd26f, 0x000fd66f,
		       0x000fda6f, 0x000fde6f, 0x000fe26f, 0x000fe66f,
		       0x000fea6f, 0x000fee6f, 0x000ff26f, 0x000ff66f,
		       0x000ffa6f, 0x000ffe6f, 0x000001cf, 0x000003cf,
		       0x000005cf, 0x000007cf, 0x000009cf, 0x00000bcf,
		       0x00000dcf, 0x00000fcf, 0x000011cf, 0x000013cf,
		       0x000015cf, 0x000017cf, 0x000019cf, 0x00001bcf,
		       0x00001dcf, 0x00001fcf, 0x000021cf, 0x000023cf,
		       0x000025cf, 0x000027cf, 0x000029cf, 0x00002bcf,
		       0x00002dcf, 0x00002fcf, 0x000031cf, 0x000033cf,
		       0x000035cf, 0x000037cf, 0x000039cf, 0x00003bcf,
		       0x00003dcf, 0x00003fcf, 0x000041cf, 0x000043cf,
		       0x000045cf, 0x000047cf, 0x000049cf, 0x00004bcf,
		       0x00004dcf, 0x00004fcf, 0x000051cf, 0x000053cf,
		       0x000055cf, 0x000057cf, 0x000059cf, 0x00005bcf,
		       0x00005dcf, 0x00005fcf, 0x000061cf, 0x000063cf,
		       0x000065cf, 0x000067cf, 0x000069cf, 0x00006bcf,
		       0x00006dcf, 0x00006fcf, 0x000071cf, 0x000073cf,
		       0x000075cf, 0x000077cf, 0x000079cf, 0x00007bcf,
		       0x00007dcf, 0x00007fcf, 0x000081cf, 0x000083cf,
		       0x000085cf, 0x000087cf, 0x000089cf, 0x00008bcf,
		       0x00008dcf, 0x00008fcf, 0x000091cf, 0x000093cf,
		       0x000095cf, 0x000097cf, 0x000099cf, 0x00009bcf,
		       0x00009dcf, 0x00009fcf, 0x0000a1cf, 0x0000a3cf,
		       0x0000a5cf, 0x0000a7cf, 0x0000a9cf, 0x0000abcf,
		       0x0000adcf, 0x0000afcf, 0x0000b1cf, 0x0000b3cf,
		       0x0000b5cf, 0x0000b7cf, 0x0000b9cf, 0x0000bbcf,
		       0x0000bdcf, 0x0000bfcf, 0x0000c1cf, 0x0000c3cf,
		       0x0000c5cf, 0x0000c7cf, 0x0000c9cf, 0x0000cbcf,
		       0x0000cdcf, 0x0000cfcf, 0x0000d1cf, 0x0000d3cf,
		       0x0000d5cf, 0x0000d7cf, 0x0000d9cf, 0x0000dbcf,
		       0x0000ddcf, 0x0000dfcf, 0x0000e1cf, 0x0000e3cf,
		       0x0000e5cf, 0x0000e7cf, 0x0000e9cf, 0x0000ebcf,
		       0x0000edcf, 0x0000efcf, 0x0000f1cf, 0x0000f3cf,
		       0x0000f5cf, 0x0000f7cf, 0x0000f9cf, 0x0000fbcf,
		       0x0000fdcf, 0x0000ffcf, 0x000101cf, 0x000103cf,
		       0x000105cf, 0x000107cf, 0x000109cf, 0x00010bcf,
		       0x00010dcf, 0x00010fcf, 0x000111cf, 0x000113cf,
		       0x000115cf, 0x000117cf, 0x000119cf, 0x00011bcf,
		       0x00011dcf, 0x00011fcf, 0x000121cf, 0x000123cf,
		       0x000125cf, 0x000127cf, 0x000129cf, 0x00012bcf,
		       0x00012dcf, 0x00012fcf, 0x000131cf, 0x000133cf,
		       0x000135cf, 0x000137cf, 0x000139cf, 0x00013bcf,
		       0x00013dcf, 0x00013fcf, 0x000141cf, 0x000143cf,
		       0x000145cf, 0x000147cf, 0x000149cf, 0x00014bcf,
		       0x00014dcf, 0x00014fcf, 0x000151cf, 0x000153cf,
		       0x000155cf, 0x000157cf, 0x000159cf, 0x00015bcf,
		       0x00015dcf, 0x00015fcf, 0x000161cf, 0x000163cf,
		       0x000165cf, 0x000167cf, 0x000169cf, 0x00016bcf,
		       0x00016dcf, 0x00016fcf, 0x000171cf, 0x000173cf,
		       0x000175cf, 0x000177cf, 0x000179cf, 0x00017bcf,
		       0x00017dcf, 0x00017fcf, 0x000181cf, 0x000183cf,
		       0x000185cf, 0x000187cf, 0x000189cf, 0x00018bcf,
		       0x00018dcf, 0x00018fcf, 0x000191cf, 0x000193cf,
		       0x000195cf, 0x000197cf, 0x000199cf, 0x00019bcf,
		       0x00019dcf, 0x00019fcf, 0x0001a1cf, 0x0001a3cf,
		       0x0001a5cf, 0x0001a7cf, 0x0001a9cf, 0x0001abcf,
		       0x0001adcf, 0x0001afcf, 0x0001b1cf, 0x0001b3cf,
		       0x0001b5cf, 0x0001b7cf, 0x0001b9cf, 0x0001bbcf,
		       0x0001bdcf, 0x0001bfcf, 0x0001c1cf, 0x0001c3cf,
		       0x0001c5cf, 0x0001c7cf, 0x0001c9cf, 0x0001cbcf,
		       0x0001cdcf, 0x0001cfcf, 0x0001d1cf, 0x0001d3cf,
		       0x0001d5cf, 0x0001d7cf, 0x0001d9cf, 0x0001dbcf,
		       0x0001ddcf, 0x0001dfcf, 0x0001e1cf, 0x0001e3cf,
		       0x0001e5cf, 0x0001e7cf, 0x0001e9cf, 0x0001ebcf,
		       0x0001edcf, 0x0001efcf, 0x0001f1cf, 0x0001f3cf,
		       0x0001f5cf, 0x0001f7cf, 0x0001f9cf, 0x0001fbcf,
		       0x0001fdcf, 0x0001ffcf, 0x000201cf, 0x000203cf,
		       0x000205cf, 0x000207cf, 0x000209cf, 0x00020bcf,
		       0x00020dcf, 0x00020fcf, 0x000211cf, 0x000213cf,
		       0x000215cf, 0x000217cf, 0x000219cf, 0x00021bcf,
		       0x00021dcf, 0x00021fcf, 0x000221cf, 0x000223cf,
		       0x000225cf, 0x000227cf, 0x000229cf, 0x00022bcf,
		       0x00022dcf, 0x00022fcf, 0x000231cf, 0x000233cf,
		       0x000235cf, 0x000237cf, 0x000239cf, 0x00023bcf,
		       0x00023dcf, 0x00023fcf, 0x000241cf, 0x000243cf,
		       0x000245cf, 0x000247cf, 0x000249cf, 0x00024bcf,
		       0x00024dcf, 0x00024fcf, 0x000251cf, 0x000253cf,
		       0x000255cf, 0x000257cf, 0x000259cf, 0x00025bcf,
		       0x00025dcf, 0x00025fcf, 0x000261cf, 0x000263cf,
		       0x000265cf, 0x000267cf, 0x000269cf, 0x00026bcf,
		       0x00026dcf, 0x00026fcf, 0x000271cf, 0x000273cf,
		       0x000275cf, 0x000277cf, 0x000279cf, 0x00027bcf,
		       0x00027dcf, 0x00027fcf, 0x000281cf, 0x000283cf,
		       0x000285cf, 0x000287cf, 0x000289cf, 0x00028bcf,
		       0x00028dcf, 0x00028fcf, 0x000291cf, 0x000293cf,
		       0x000295cf, 0x000297cf, 0x000299cf, 0x00029bcf,
		       0x00029dcf, 0x00029fcf, 0x0002a1cf, 0x0002a3cf,
		       0x0002a5cf, 0x0002a7cf, 0x0002a9cf, 0x0002abcf,
		       0x0002adcf, 0x0002afcf, 0x0002b1cf, 0x0002b3cf,
		       0x0002b5cf, 0x0002b7cf, 0x0002b9cf, 0x0002bbcf,
		       0x0002bdcf, 0x0002bfcf, 0x0002c1cf, 0x0002c3cf,
		       0x0002c5cf, 0x0002c7cf, 0x0002c9cf, 0x0002cbcf,
		       0x0002cdcf, 0x0002cfcf, 0x0002d1cf, 0x0002d3cf,
		       0x0002d5cf, 0x0002d7cf, 0x0002d9cf, 0x0002dbcf,
		       0x0002ddcf, 0x0002dfcf, 0x0002e1cf, 0x0002e3cf,
		       0x0002e5cf, 0x0002e7cf, 0x0002e9cf, 0x0002ebcf,
		       0x0002edcf, 0x0002efcf, 0x0002f1cf, 0x0002f3cf,
		       0x0002f5cf, 0x0002f7cf, 0x0002f9cf, 0x0002fbcf,
		       0x0002fdcf, 0x0002ffcf, 0x000301cf, 0x000303cf,
		       0x000305cf, 0x000307cf, 0x000309cf, 0x00030bcf,
		       0x00030dcf, 0x00030fcf, 0x000311cf, 0x000313cf,
		       0x000315cf, 0x000317cf, 0x000319cf, 0x00031bcf,
		       0x00031dcf, 0x00031fcf, 0x000321cf, 0x000323cf,
		       0x000325cf, 0x000327cf, 0x000329cf, 0x00032bcf,
		       0x00032dcf, 0x00032fcf, 0x000331cf, 0x000333cf,
		       0x000335cf, 0x000337cf, 0x000339cf, 0x00033bcf,
		       0x00033dcf, 0x00033fcf, 0x000341cf, 0x000343cf,
		       0x000345cf, 0x000347cf, 0x000349cf, 0x00034bcf,
		       0x00034dcf, 0x00034fcf, 0x000351cf, 0x000353cf,
		       0x000355cf, 0x000357cf, 0x000359cf, 0x00035bcf,
		       0x00035dcf, 0x00035fcf, 0x000361cf, 0x000363cf,
		       0x000365cf, 0x000367cf, 0x000369cf, 0x00036bcf,
		       0x00036dcf, 0x00036fcf, 0x000371cf, 0x000373cf,
		       0x000375cf, 0x000377cf, 0x000379cf, 0x00037bcf,
		       0x00037dcf, 0x00037fcf, 0x000381cf, 0x000383cf,
		       0x000385cf, 0x000387cf, 0x000389cf, 0x00038bcf,
		       0x00038dcf, 0x00038fcf, 0x000391cf, 0x000393cf,
		       0x000395cf, 0x000397cf, 0x000399cf, 0x00039bcf,
		       0x00039dcf, 0x00039fcf, 0x0003a1cf, 0x0003a3cf,
		       0x0003a5cf, 0x0003a7cf, 0x0003a9cf, 0x0003abcf,
		       0x0003adcf, 0x0003afcf, 0x0003b1cf, 0x0003b3cf,
		       0x0003b5cf, 0x0003b7cf, 0x0003b9cf, 0x0003bbcf,
		       0x0003bdcf, 0x0003bfcf, 0x0003c1cf, 0x0003c3cf,
		       0x0003c5cf, 0x0003c7cf, 0x0003c9cf, 0x0003cbcf,
		       0x0003cdcf, 0x0003cfcf, 0x0003d1cf, 0x0003d3cf,
		       0x0003d5cf, 0x0003d7cf, 0x0003d9cf, 0x0003dbcf,
		       0x0003ddcf, 0x0003dfcf, 0x0003e1cf, 0x0003e3cf,
		       0x0003e5cf, 0x0003e7cf, 0x0003e9cf, 0x0003ebcf,
		       0x0003edcf, 0x0003efcf, 0x0003f1cf, 0x0003f3cf,
		       0x0003f5cf, 0x0003f7cf, 0x0003f9cf, 0x0003fbcf,
		       0x0003fdcf, 0x0003ffcf, 0x000401cf, 0x000403cf,
		       0x000405cf, 0x000407cf, 0x000409cf, 0x00040bcf,
		       0x00040dcf, 0x00040fcf, 0x000411cf, 0x000413cf,
		       0x000415cf, 0x000417cf, 0x000419cf, 0x00041bcf,
		       0x00041dcf, 0x00041fcf, 0x000421cf, 0x000423cf,
		       0x000425cf, 0x000427cf, 0x000429cf, 0x00042bcf,
		       0x00042dcf, 0x00042fcf, 0x000431cf, 0x000433cf,
		       0x000435cf, 0x000437cf, 0x000439cf, 0x00043bcf,
		       0x00043dcf, 0x00043fcf, 0x000441cf, 0x000443cf,
		       0x000445cf, 0x000447cf, 0x000449cf, 0x00044bcf,
		       0x00044dcf, 0x00044fcf, 0x000451cf, 0x000453cf,
		       0x000455cf, 0x000457cf, 0x000459cf, 0x00045bcf,
		       0x00045dcf, 0x00045fcf, 0x000461cf, 0x000463cf,
		       0x000465cf, 0x000467cf, 0x000469cf, 0x00046bcf,
		       0x00046dcf, 0x00046fcf, 0x000471cf, 0x000473cf,
		       0x000475cf, 0x000477cf, 0x000479cf, 0x00047bcf,
		       0x00047dcf, 0x00047fcf, 0x000481cf, 0x000483cf,
		       0x000485cf, 0x000487cf, 0x000489cf, 0x00048bcf,
		       0x00048dcf, 0x00048fcf, 0x000491cf, 0x000493cf,
		       0x000495cf, 0x000497cf, 0x000499cf, 0x00049bcf,
		       0x00049dcf, 0x00049fcf, 0x0004a1cf, 0x0004a3cf,
		       0x0004a5cf, 0x0004a7cf, 0x0004a9cf, 0x0004abcf,
		       0x0004adcf, 0x0004afcf, 0x0004b1cf, 0x0004b3cf,
		       0x0004b5cf, 0x0004b7cf, 0x0004b9cf, 0x0004bbcf,
		       0x0004bdcf, 0x0004bfcf, 0x0004c1cf, 0x0004c3cf,
		       0x0004c5cf, 0x0004c7cf, 0x0004c9cf, 0x0004cbcf,
		       0x0004cdcf, 0x0004cfcf, 0x0004d1cf, 0x0004d3cf,
		       0x0004d5cf, 0x0004d7cf, 0x0004d9cf, 0x0004dbcf,
		       0x0004ddcf, 0x0004dfcf, 0x0004e1cf, 0x0004e3cf,
		       0x0004e5cf, 0x0004e7cf, 0x0004e9cf, 0x0004ebcf,
		       0x0004edcf, 0x0004efcf, 0x0004f1cf, 0x0004f3cf,
		       0x0004f5cf, 0x0004f7cf, 0x0004f9cf, 0x0004fbcf,
		       0x0004fdcf, 0x0004ffcf, 0x000501cf, 0x000503cf,
		       0x000505cf, 0x000507cf, 0x000509cf, 0x00050bcf,
		       0x00050dcf, 0x00050fcf, 0x000511cf, 0x000513cf,
		       0x000515cf, 0x000517cf, 0x000519cf, 0x00051bcf,
		       0x00051dcf, 0x00051fcf, 0x000521cf, 0x000523cf,
		       0x000525cf, 0x000527cf, 0x000529cf, 0x00052bcf,
		       0x00052dcf, 0x00052fcf, 0x000531cf, 0x000533cf,
		       0x000535cf, 0x000537cf, 0x000539cf, 0x00053bcf,
		       0x00053dcf, 0x00053fcf, 0x000541cf, 0x000543cf,
		       0x000545cf, 0x000547cf, 0x000549cf, 0x00054bcf,
		       0x00054dcf, 0x00054fcf, 0x000551cf, 0x000553cf,
		       0x000555cf, 0x000557cf, 0x000559cf, 0x00055bcf,
		       0x00055dcf, 0x00055fcf, 0x000561cf, 0x000563cf,
		       0x000565cf, 0x000567cf, 0x000569cf, 0x00056bcf,
		       0x00056dcf, 0x00056fcf, 0x000571cf, 0x000573cf,
		       0x000575cf, 0x000577cf, 0x000579cf, 0x00057bcf,
		       0x00057dcf, 0x00057fcf, 0x000581cf, 0x000583cf,
		       0x000585cf, 0x000587cf, 0x000589cf, 0x00058bcf,
		       0x00058dcf, 0x00058fcf, 0x000591cf, 0x000593cf,
		       0x000595cf, 0x000597cf, 0x000599cf, 0x00059bcf,
		       0x00059dcf, 0x00059fcf, 0x0005a1cf, 0x0005a3cf,
		       0x0005a5cf, 0x0005a7cf, 0x0005a9cf, 0x0005abcf,
		       0x0005adcf, 0x0005afcf, 0x0005b1cf, 0x0005b3cf,
		       0x0005b5cf, 0x0005b7cf, 0x0005b9cf, 0x0005bbcf,
		       0x0005bdcf, 0x0005bfcf, 0x0005c1cf, 0x0005c3cf,
		       0x0005c5cf, 0x0005c7cf, 0x0005c9cf, 0x0005cbcf,
		       0x0005cdcf, 0x0005cfcf, 0x0005d1cf, 0x0005d3cf,
		       0x0005d5cf, 0x0005d7cf, 0x0005d9cf, 0x0005dbcf,
		       0x0005ddcf, 0x0005dfcf, 0x0005e1cf, 0x0005e3cf,
		       0x0005e5cf, 0x0005e7cf, 0x0005e9cf, 0x0005ebcf,
		       0x0005edcf, 0x0005efcf, 0x0005f1cf, 0x0005f3cf,
		       0x0005f5cf, 0x0005f7cf, 0x0005f9cf, 0x0005fbcf,
		       0x0005fdcf, 0x0005ffcf, 0x000601cf, 0x000603cf,
		       0x000605cf, 0x000607cf, 0x000609cf, 0x00060bcf,
		       0x00060dcf, 0x00060fcf, 0x000611cf, 0x000613cf,
		       0x000615cf, 0x000617cf, 0x000619cf, 0x00061bcf,
		       0x00061dcf, 0x00061fcf, 0x000621cf, 0x000623cf,
		       0x000625cf, 0x000627cf, 0x000629cf, 0x00062bcf,
		       0x00062dcf, 0x00062fcf, 0x000631cf, 0x000633cf,
		       0x000635cf, 0x000637cf, 0x000639cf, 0x00063bcf,
		       0x00063dcf, 0x00063fcf, 0x000641cf, 0x000643cf,
		       0x000645cf, 0x000647cf, 0x000649cf, 0x00064bcf,
		       0x00064dcf, 0x00064fcf, 0x000651cf, 0x000653cf,
		       0x000655cf, 0x000657cf, 0x000659cf, 0x00065bcf,
		       0x00065dcf, 0x00065fcf, 0x000661cf, 0x000663cf,
		       0x000665cf, 0x000667cf, 0x000669cf, 0x00066bcf,
		       0x00066dcf, 0x00066fcf, 0x000671cf, 0x000673cf,
		       0x000675cf, 0x000677cf, 0x000679cf, 0x00067bcf,
		       0x00067dcf, 0x00067fcf, 0x000681cf, 0x000683cf,
		       0x000685cf, 0x000687cf, 0x000689cf, 0x00068bcf,
		       0x00068dcf, 0x00068fcf, 0x000691cf, 0x000693cf,
		       0x000695cf, 0x000697cf, 0x000699cf, 0x00069bcf,
		       0x00069dcf, 0x00069fcf, 0x0006a1cf, 0x0006a3cf,
		       0x0006a5cf, 0x0006a7cf, 0x0006a9cf, 0x0006abcf,
		       0x0006adcf, 0x0006afcf, 0x0006b1cf, 0x0006b3cf,
		       0x0006b5cf, 0x0006b7cf, 0x0006b9cf, 0x0006bbcf,
		       0x0006bdcf, 0x0006bfcf, 0x0006c1cf, 0x0006c3cf,
		       0x0006c5cf, 0x0006c7cf, 0x0006c9cf, 0x0006cbcf,
		       0x0006cdcf, 0x0006cfcf, 0x0006d1cf, 0x0006d3cf,
		       0x0006d5cf, 0x0006d7cf, 0x0006d9cf, 0x0006dbcf,
		       0x0006ddcf, 0x0006dfcf, 0x0006e1cf, 0x0006e3cf,
		       0x0006e5cf, 0x0006e7cf, 0x0006e9cf, 0x0006ebcf,
		       0x0006edcf, 0x0006efcf, 0x0006f1cf, 0x0006f3cf,
		       0x0006f5cf, 0x0006f7cf, 0x0006f9cf, 0x0006fbcf,
		       0x0006fdcf, 0x0006ffcf, 0x000701cf, 0x000703cf,
		       0x000705cf, 0x000707cf, 0x000709cf, 0x00070bcf,
		       0x00070dcf, 0x00070fcf, 0x000711cf, 0x000713cf,
		       0x000715cf, 0x000717cf, 0x000719cf, 0x00071bcf,
		       0x00071dcf, 0x00071fcf, 0x000721cf, 0x000723cf,
		       0x000725cf, 0x000727cf, 0x000729cf, 0x00072bcf,
		       0x00072dcf, 0x00072fcf, 0x000731cf, 0x000733cf,
		       0x000735cf, 0x000737cf, 0x000739cf, 0x00073bcf,
		       0x00073dcf, 0x00073fcf, 0x000741cf, 0x000743cf,
		       0x000745cf, 0x000747cf, 0x000749cf, 0x00074bcf,
		       0x00074dcf, 0x00074fcf, 0x000751cf, 0x000753cf,
		       0x000755cf, 0x000757cf, 0x000759cf, 0x00075bcf,
		       0x00075dcf, 0x00075fcf, 0x000761cf, 0x000763cf,
		       0x000765cf, 0x000767cf, 0x000769cf, 0x00076bcf,
		       0x00076dcf, 0x00076fcf, 0x000771cf, 0x000773cf,
		       0x000775cf, 0x000777cf, 0x000779cf, 0x00077bcf,
		       0x00077dcf, 0x00077fcf, 0x000781cf, 0x000783cf,
		       0x000785cf, 0x000787cf, 0x000789cf, 0x00078bcf,
		       0x00078dcf, 0x00078fcf, 0x000791cf, 0x000793cf,
		       0x000795cf, 0x000797cf, 0x000799cf, 0x00079bcf,
		       0x00079dcf, 0x00079fcf, 0x0007a1cf, 0x0007a3cf,
		       0x0007a5cf, 0x0007a7cf, 0x0007a9cf, 0x0007abcf,
		       0x0007adcf, 0x0007afcf, 0x0007b1cf, 0x0007b3cf,
		       0x0007b5cf, 0x0007b7cf, 0x0007b9cf, 0x0007bbcf,
		       0x0007bdcf, 0x0007bfcf, 0x0007c1cf, 0x0007c3cf,
		       0x0007c5cf, 0x0007c7cf, 0x0007c9cf, 0x0007cbcf,
		       0x0007cdcf, 0x0007cfcf, 0x0007d1cf, 0x0007d3cf,
		       0x0007d5cf, 0x0007d7cf, 0x0007d9cf, 0x0007dbcf,
		       0x0007ddcf, 0x0007dfcf, 0x0007e1cf, 0x0007e3cf,
		       0x0007e5cf, 0x0007e7cf, 0x0007e9cf, 0x0007ebcf,
		       0x0007edcf, 0x0007efcf, 0x0007f1cf, 0x0007f3cf,
		       0x0007f5cf, 0x0007f7cf, 0x0007f9cf, 0x0007fbcf,
		       0x0007fdcf, 0x0007ffcf, 0x000801cf, 0x000803cf,
		       0x000805cf, 0x000807cf, 0x000809cf, 0x00080bcf,
		       0x00080dcf, 0x00080fcf, 0x000811cf, 0x000813cf,
		       0x000815cf, 0x000817cf, 0x000819cf, 0x00081bcf,
		       0x00081dcf, 0x00081fcf, 0x000821cf, 0x000823cf,
		       0x000825cf, 0x000827cf, 0x000829cf, 0x00082bcf,
		       0x00082dcf, 0x00082fcf, 0x000831cf, 0x000833cf,
		       0x000835cf, 0x000837cf, 0x000839cf, 0x00083bcf,
		       0x00083dcf, 0x00083fcf, 0x000841cf, 0x000843cf,
		       0x000845cf, 0x000847cf, 0x000849cf, 0x00084bcf,
		       0x00084dcf, 0x00084fcf, 0x000851cf, 0x000853cf,
		       0x000855cf, 0x000857cf, 0x000859cf, 0x00085bcf,
		       0x00085dcf, 0x00085fcf, 0x000861cf, 0x000863cf,
		       0x000865cf, 0x000867cf, 0x000869cf, 0x00086bcf,
		       0x00086dcf, 0x00086fcf, 0x000871cf, 0x000873cf,
		       0x000875cf, 0x000877cf, 0x000879cf, 0x00087bcf,
		       0x00087dcf, 0x00087fcf, 0x000881cf, 0x000883cf,
		       0x000885cf, 0x000887cf, 0x000889cf, 0x00088bcf,
		       0x00088dcf, 0x00088fcf, 0x000891cf, 0x000893cf,
		       0x000895cf, 0x000897cf, 0x000899cf, 0x00089bcf,
		       0x00089dcf, 0x00089fcf, 0x0008a1cf, 0x0008a3cf,
		       0x0008a5cf, 0x0008a7cf, 0x0008a9cf, 0x0008abcf,
		       0x0008adcf, 0x0008afcf, 0x0008b1cf, 0x0008b3cf,
		       0x0008b5cf, 0x0008b7cf, 0x0008b9cf, 0x0008bbcf,
		       0x0008bdcf, 0x0008bfcf, 0x0008c1cf, 0x0008c3cf,
		       0x0008c5cf, 0x0008c7cf, 0x0008c9cf, 0x0008cbcf,
		       0x0008cdcf, 0x0008cfcf, 0x0008d1cf, 0x0008d3cf,
		       0x0008d5cf, 0x0008d7cf, 0x0008d9cf, 0x0008dbcf,
		       0x0008ddcf, 0x0008dfcf, 0x0008e1cf, 0x0008e3cf,
		       0x0008e5cf, 0x0008e7cf, 0x0008e9cf, 0x0008ebcf,
		       0x0008edcf, 0x0008efcf, 0x0008f1cf, 0x0008f3cf,
		       0x0008f5cf, 0x0008f7cf, 0x0008f9cf, 0x0008fbcf,
		       0x0008fdcf, 0x0008ffcf, 0x000901cf, 0x000903cf,
		       0x000905cf, 0x000907cf, 0x000909cf, 0x00090bcf,
		       0x00090dcf, 0x00090fcf, 0x000911cf, 0x000913cf,
		       0x000915cf, 0x000917cf, 0x000919cf, 0x00091bcf,
		       0x00091dcf, 0x00091fcf, 0x000921cf, 0x000923cf,
		       0x000925cf, 0x000927cf, 0x000929cf, 0x00092bcf,
		       0x00092dcf, 0x00092fcf, 0x000931cf, 0x000933cf,
		       0x000935cf, 0x000937cf, 0x000939cf, 0x00093bcf,
		       0x00093dcf, 0x00093fcf, 0x000941cf, 0x000943cf,
		       0x000945cf, 0x000947cf, 0x000949cf, 0x00094bcf,
		       0x00094dcf, 0x00094fcf, 0x000951cf, 0x000953cf,
		       0x000955cf, 0x000957cf, 0x000959cf, 0x00095bcf,
		       0x00095dcf, 0x00095fcf, 0x000961cf, 0x000963cf,
		       0x000965cf, 0x000967cf, 0x000969cf, 0x00096bcf,
		       0x00096dcf, 0x00096fcf, 0x000971cf, 0x000973cf,
		       0x000975cf, 0x000977cf, 0x000979cf, 0x00097bcf,
		       0x00097dcf, 0x00097fcf, 0x000981cf, 0x000983cf,
		       0x000985cf, 0x000987cf, 0x000989cf, 0x00098bcf,
		       0x00098dcf, 0x00098fcf, 0x000991cf, 0x000993cf,
		       0x000995cf, 0x000997cf, 0x000999cf, 0x00099bcf,
		       0x00099dcf, 0x00099fcf, 0x0009a1cf, 0x0009a3cf,
		       0x0009a5cf, 0x0009a7cf, 0x0009a9cf, 0x0009abcf,
		       0x0009adcf, 0x0009afcf, 0x0009b1cf, 0x0009b3cf,
		       0x0009b5cf, 0x0009b7cf, 0x0009b9cf, 0x0009bbcf,
		       0x0009bdcf, 0x0009bfcf, 0x0009c1cf, 0x0009c3cf,
		       0x0009c5cf, 0x0009c7cf, 0x0009c9cf, 0x0009cbcf,
		       0x0009cdcf, 0x0009cfcf, 0x0009d1cf, 0x0009d3cf,
		       0x0009d5cf, 0x0009d7cf, 0x0009d9cf, 0x0009dbcf,
		       0x0009ddcf, 0x0009dfcf, 0x0009e1cf, 0x0009e3cf,
		       0x0009e5cf, 0x0009e7cf, 0x0009e9cf, 0x0009ebcf,
		       0x0009edcf, 0x0009efcf, 0x0009f1cf, 0x0009f3cf,
		       0x0009f5cf, 0x0009f7cf, 0x0009f9cf, 0x0009fbcf,
		       0x0009fdcf, 0x0009ffcf, 0x000a01cf, 0x000a03cf,
		       0x000a05cf, 0x000a07cf, 0x000a09cf, 0x000a0bcf,
		       0x000a0dcf, 0x000a0fcf, 0x000a11cf, 0x000a13cf,
		       0x000a15cf, 0x000a17cf, 0x000a19cf, 0x000a1bcf,
		       0x000a1dcf, 0x000a1fcf, 0x000a21cf, 0x000a23cf,
		       0x000a25cf, 0x000a27cf, 0x000a29cf, 0x000a2bcf,
		       0x000a2dcf, 0x000a2fcf, 0x000a31cf, 0x000a33cf,
		       0x000a35cf, 0x000a37cf, 0x000a39cf, 0x000a3bcf,
		       0x000a3dcf, 0x000a3fcf, 0x000a41cf, 0x000a43cf,
		       0x000a45cf, 0x000a47cf, 0x000a49cf, 0x000a4bcf,
		       0x000a4dcf, 0x000a4fcf, 0x000a51cf, 0x000a53cf,
		       0x000a55cf, 0x000a57cf, 0x000a59cf, 0x000a5bcf,
		       0x000a5dcf, 0x000a5fcf, 0x000a61cf, 0x000a63cf,
		       0x000a65cf, 0x000a67cf, 0x000a69cf, 0x000a6bcf,
		       0x000a6dcf, 0x000a6fcf, 0x000a71cf, 0x000a73cf,
		       0x000a75cf, 0x000a77cf, 0x000a79cf, 0x000a7bcf,
		       0x000a7dcf, 0x000a7fcf, 0x000a81cf, 0x000a83cf,
		       0x000a85cf, 0x000a87cf, 0x000a89cf, 0x000a8bcf,
		       0x000a8dcf, 0x000a8fcf, 0x000a91cf, 0x000a93cf,
		       0x000a95cf, 0x000a97cf, 0x000a99cf, 0x000a9bcf,
		       0x000a9dcf, 0x000a9fcf, 0x000aa1cf, 0x000aa3cf,
		       0x000aa5cf, 0x000aa7cf, 0x000aa9cf, 0x000aabcf,
		       0x000aadcf, 0x000aafcf, 0x000ab1cf, 0x000ab3cf,
		       0x000ab5cf, 0x000ab7cf, 0x000ab9cf, 0x000abbcf,
		       0x000abdcf, 0x000abfcf, 0x000ac1cf, 0x000ac3cf,
		       0x000ac5cf, 0x000ac7cf, 0x000ac9cf, 0x000acbcf,
		       0x000acdcf, 0x000acfcf, 0x000ad1cf, 0x000ad3cf,
		       0x000ad5cf, 0x000ad7cf, 0x000ad9cf, 0x000adbcf,
		       0x000addcf, 0x000adfcf, 0x000ae1cf, 0x000ae3cf,
		       0x000ae5cf, 0x000ae7cf, 0x000ae9cf, 0x000aebcf,
		       0x000aedcf, 0x000aefcf, 0x000af1cf, 0x000af3cf,
		       0x000af5cf, 0x000af7cf, 0x000af9cf, 0x000afbcf,
		       0x000afdcf, 0x000affcf, 0x000b01cf, 0x000b03cf,
		       0x000b05cf, 0x000b07cf, 0x000b09cf, 0x000b0bcf,
		       0x000b0dcf, 0x000b0fcf, 0x000b11cf, 0x000b13cf,
		       0x000b15cf, 0x000b17cf, 0x000b19cf, 0x000b1bcf,
		       0x000b1dcf, 0x000b1fcf, 0x000b21cf, 0x000b23cf,
		       0x000b25cf, 0x000b27cf, 0x000b29cf, 0x000b2bcf,
		       0x000b2dcf, 0x000b2fcf, 0x000b31cf, 0x000b33cf,
		       0x000b35cf, 0x000b37cf, 0x000b39cf, 0x000b3bcf,
		       0x000b3dcf, 0x000b3fcf, 0x000b41cf, 0x000b43cf,
		       0x000b45cf, 0x000b47cf, 0x000b49cf, 0x000b4bcf,
		       0x000b4dcf, 0x000b4fcf, 0x000b51cf, 0x000b53cf,
		       0x000b55cf, 0x000b57cf, 0x000b59cf, 0x000b5bcf,
		       0x000b5dcf, 0x000b5fcf, 0x000b61cf, 0x000b63cf,
		       0x000b65cf, 0x000b67cf, 0x000b69cf, 0x000b6bcf,
		       0x000b6dcf, 0x000b6fcf, 0x000b71cf, 0x000b73cf,
		       0x000b75cf, 0x000b77cf, 0x000b79cf, 0x000b7bcf,
		       0x000b7dcf, 0x000b7fcf, 0x000b81cf, 0x000b83cf,
		       0x000b85cf, 0x000b87cf, 0x000b89cf, 0x000b8bcf,
		       0x000b8dcf, 0x000b8fcf, 0x000b91cf, 0x000b93cf,
		       0x000b95cf, 0x000b97cf, 0x000b99cf, 0x000b9bcf,
		       0x000b9dcf, 0x000b9fcf, 0x000ba1cf, 0x000ba3cf,
		       0x000ba5cf, 0x000ba7cf, 0x000ba9cf, 0x000babcf,
		       0x000badcf, 0x000bafcf, 0x000bb1cf, 0x000bb3cf,
		       0x000bb5cf, 0x000bb7cf, 0x000bb9cf, 0x000bbbcf,
		       0x000bbdcf, 0x000bbfcf, 0x000bc1cf, 0x000bc3cf,
		       0x000bc5cf, 0x000bc7cf, 0x000bc9cf, 0x000bcbcf,
		       0x000bcdcf, 0x000bcfcf, 0x000bd1cf, 0x000bd3cf,
		       0x000bd5cf, 0x000bd7cf, 0x000bd9cf, 0x000bdbcf,
		       0x000bddcf, 0x000bdfcf, 0x000be1cf, 0x000be3cf,
		       0x000be5cf, 0x000be7cf, 0x000be9cf, 0x000bebcf,
		       0x000bedcf, 0x000befcf, 0x000bf1cf, 0x000bf3cf,
		       0x000bf5cf, 0x000bf7cf, 0x000bf9cf, 0x000bfbcf,
		       0x000bfdcf, 0x000bffcf, 0x000c01cf, 0x000c03cf,
		       0x000c05cf, 0x000c07cf, 0x000c09cf, 0x000c0bcf,
		       0x000c0dcf, 0x000c0fcf, 0x000c11cf, 0x000c13cf,
		       0x000c15cf, 0x000c17cf, 0x000c19cf, 0x000c1bcf,
		       0x000c1dcf, 0x000c1fcf, 0x000c21cf, 0x000c23cf,
		       0x000c25cf, 0x000c27cf, 0x000c29cf, 0x000c2bcf,
		       0x000c2dcf, 0x000c2fcf, 0x000c31cf, 0x000c33cf,
		       0x000c35cf, 0x000c37cf, 0x000c39cf, 0x000c3bcf,
		       0x000c3dcf, 0x000c3fcf, 0x000c41cf, 0x000c43cf,
		       0x000c45cf, 0x000c47cf, 0x000c49cf, 0x000c4bcf,
		       0x000c4dcf, 0x000c4fcf, 0x000c51cf, 0x000c53cf,
		       0x000c55cf, 0x000c57cf, 0x000c59cf, 0x000c5bcf,
		       0x000c5dcf, 0x000c5fcf, 0x000c61cf, 0x000c63cf,
		       0x000c65cf, 0x000c67cf, 0x000c69cf, 0x000c6bcf,
		       0x000c6dcf, 0x000c6fcf, 0x000c71cf, 0x000c73cf,
		       0x000c75cf, 0x000c77cf, 0x000c79cf, 0x000c7bcf,
		       0x000c7dcf, 0x000c7fcf, 0x000c81cf, 0x000c83cf,
		       0x000c85cf, 0x000c87cf, 0x000c89cf, 0x000c8bcf,
		       0x000c8dcf, 0x000c8fcf, 0x000c91cf, 0x000c93cf,
		       0x000c95cf, 0x000c97cf, 0x000c99cf, 0x000c9bcf,
		       0x000c9dcf, 0x000c9fcf, 0x000ca1cf, 0x000ca3cf,
		       0x000ca5cf, 0x000ca7cf, 0x000ca9cf, 0x000cabcf,
		       0x000cadcf, 0x000cafcf, 0x000cb1cf, 0x000cb3cf,
		       0x000cb5cf, 0x000cb7cf, 0x000cb9cf, 0x000cbbcf,
		       0x000cbdcf, 0x000cbfcf, 0x000cc1cf, 0x000cc3cf,
		       0x000cc5cf, 0x000cc7cf, 0x000cc9cf, 0x000ccbcf,
		       0x000ccdcf, 0x000ccfcf, 0x000cd1cf, 0x000cd3cf,
		       0x000cd5cf, 0x000cd7cf, 0x000cd9cf, 0x000cdbcf,
		       0x000cddcf, 0x000cdfcf, 0x000ce1cf, 0x000ce3cf,
		       0x000ce5cf, 0x000ce7cf, 0x000ce9cf, 0x000cebcf,
		       0x000cedcf, 0x000cefcf, 0x000cf1cf, 0x000cf3cf,
		       0x000cf5cf, 0x000cf7cf, 0x000cf9cf, 0x000cfbcf,
		       0x000cfdcf, 0x000cffcf, 0x000d01cf, 0x000d03cf,
		       0x000d05cf, 0x000d07cf, 0x000d09cf, 0x000d0bcf,
		       0x000d0dcf, 0x000d0fcf, 0x000d11cf, 0x000d13cf,
		       0x000d15cf, 0x000d17cf, 0x000d19cf, 0x000d1bcf,
		       0x000d1dcf, 0x000d1fcf, 0x000d21cf, 0x000d23cf,
		       0x000d25cf, 0x000d27cf, 0x000d29cf, 0x000d2bcf,
		       0x000d2dcf, 0x000d2fcf, 0x000d31cf, 0x000d33cf,
		       0x000d35cf, 0x000d37cf, 0x000d39cf, 0x000d3bcf,
		       0x000d3dcf, 0x000d3fcf, 0x000d41cf, 0x000d43cf,
		       0x000d45cf, 0x000d47cf, 0x000d49cf, 0x000d4bcf,
		       0x000d4dcf, 0x000d4fcf, 0x000d51cf, 0x000d53cf,
		       0x000d55cf, 0x000d57cf, 0x000d59cf, 0x000d5bcf,
		       0x000d5dcf, 0x000d5fcf, 0x000d61cf, 0x000d63cf,
		       0x000d65cf, 0x000d67cf, 0x000d69cf, 0x000d6bcf,
		       0x000d6dcf, 0x000d6fcf, 0x000d71cf, 0x000d73cf,
		       0x000d75cf, 0x000d77cf, 0x000d79cf, 0x000d7bcf,
		       0x000d7dcf, 0x000d7fcf, 0x000d81cf, 0x000d83cf,
		       0x000d85cf, 0x000d87cf, 0x000d89cf, 0x000d8bcf,
		       0x000d8dcf, 0x000d8fcf, 0x000d91cf, 0x000d93cf,
		       0x000d95cf, 0x000d97cf, 0x000d99cf, 0x000d9bcf,
		       0x000d9dcf, 0x000d9fcf, 0x000da1cf, 0x000da3cf,
		       0x000da5cf, 0x000da7cf, 0x000da9cf, 0x000dabcf,
		       0x000dadcf, 0x000dafcf, 0x000db1cf, 0x000db3cf,
		       0x000db5cf, 0x000db7cf, 0x000db9cf, 0x000dbbcf,
		       0x000dbdcf, 0x000dbfcf, 0x000dc1cf, 0x000dc3cf,
		       0x000dc5cf, 0x000dc7cf, 0x000dc9cf, 0x000dcbcf,
		       0x000dcdcf, 0x000dcfcf, 0x000dd1cf, 0x000dd3cf,
		       0x000dd5cf, 0x000dd7cf, 0x000dd9cf, 0x000ddbcf,
		       0x000dddcf, 0x000ddfcf, 0x000de1cf, 0x000de3cf,
		       0x000de5cf, 0x000de7cf, 0x000de9cf, 0x000debcf,
		       0x000dedcf, 0x000defcf, 0x000df1cf, 0x000df3cf,
		       0x000df5cf, 0x000df7cf, 0x000df9cf, 0x000dfbcf,
		       0x000dfdcf, 0x000dffcf, 0x000e01cf, 0x000e03cf,
		       0x000e05cf, 0x000e07cf, 0x000e09cf, 0x000e0bcf,
		       0x000e0dcf, 0x000e0fcf, 0x000e11cf, 0x000e13cf,
		       0x000e15cf, 0x000e17cf, 0x000e19cf, 0x000e1bcf,
		       0x000e1dcf, 0x000e1fcf, 0x000e21cf, 0x000e23cf,
		       0x000e25cf, 0x000e27cf, 0x000e29cf, 0x000e2bcf,
		       0x000e2dcf, 0x000e2fcf, 0x000e31cf, 0x000e33cf,
		       0x000e35cf, 0x000e37cf, 0x000e39cf, 0x000e3bcf,
		       0x000e3dcf, 0x000e3fcf, 0x000e41cf, 0x000e43cf,
		       0x000e45cf, 0x000e47cf, 0x000e49cf, 0x000e4bcf,
		       0x000e4dcf, 0x000e4fcf, 0x000e51cf, 0x000e53cf,
		       0x000e55cf, 0x000e57cf, 0x000e59cf, 0x000e5bcf,
		       0x000e5dcf, 0x000e5fcf, 0x000e61cf, 0x000e63cf,
		       0x000e65cf, 0x000e67cf, 0x000e69cf, 0x000e6bcf,
		       0x000e6dcf, 0x000e6fcf, 0x000e71cf, 0x000e73cf,
		       0x000e75cf, 0x000e77cf, 0x000e79cf, 0x000e7bcf,
		       0x000e7dcf, 0x000e7fcf, 0x000e81cf, 0x000e83cf,
		       0x000e85cf, 0x000e87cf, 0x000e89cf, 0x000e8bcf,
		       0x000e8dcf, 0x000e8fcf, 0x000e91cf, 0x000e93cf,
		       0x000e95cf, 0x000e97cf, 0x000e99cf, 0x000e9bcf,
		       0x000e9dcf, 0x000e9fcf, 0x000ea1cf, 0x000ea3cf,
		       0x000ea5cf, 0x000ea7cf, 0x000ea9cf, 0x000eabcf,
		       0x000eadcf, 0x000eafcf, 0x000eb1cf, 0x000eb3cf,
		       0x000eb5cf, 0x000eb7cf, 0x000eb9cf, 0x000ebbcf,
		       0x000ebdcf, 0x000ebfcf, 0x000ec1cf, 0x000ec3cf,
		       0x000ec5cf, 0x000ec7cf, 0x000ec9cf, 0x000ecbcf,
		       0x000ecdcf, 0x000ecfcf, 0x000ed1cf, 0x000ed3cf,
		       0x000ed5cf, 0x000ed7cf, 0x000ed9cf, 0x000edbcf,
		       0x000eddcf, 0x000edfcf, 0x000ee1cf, 0x000ee3cf,
		       0x000ee5cf, 0x000ee7cf, 0x000ee9cf, 0x000eebcf,
		       0x000eedcf, 0x000eefcf, 0x000ef1cf, 0x000ef3cf,
		       0x000ef5cf, 0x000ef7cf, 0x000ef9cf, 0x000efbcf,
		       0x000efdcf, 0x000effcf, 0x000f01cf, 0x000f03cf,
		       0x000f05cf, 0x000f07cf, 0x000f09cf, 0x000f0bcf,
		       0x000f0dcf, 0x000f0fcf, 0x000f11cf, 0x000f13cf,
		       0x000f15cf, 0x000f17cf, 0x000f19cf, 0x000f1bcf,
		       0x000f1dcf, 0x000f1fcf, 0x000f21cf, 0x000f23cf,
		       0x000f25cf, 0x000f27cf, 0x000f29cf, 0x000f2bcf,
		       0x000f2dcf, 0x000f2fcf, 0x000f31cf, 0x000f33cf,
		       0x000f35cf, 0x000f37cf, 0x000f39cf, 0x000f3bcf,
		       0x000f3dcf, 0x000f3fcf, 0x000f41cf, 0x000f43cf,
		       0x000f45cf, 0x000f47cf, 0x000f49cf, 0x000f4bcf,
		       0x000f4dcf, 0x000f4fcf, 0x000f51cf, 0x000f53cf,
		       0x000f55cf, 0x000f57cf, 0x000f59cf, 0x000f5bcf,
		       0x000f5dcf, 0x000f5fcf, 0x000f61cf, 0x000f63cf,
		       0x000f65cf, 0x000f67cf, 0x000f69cf, 0x000f6bcf,
		       0x000f6dcf, 0x000f6fcf, 0x000f71cf, 0x000f73cf,
		       0x000f75cf, 0x000f77cf, 0x000f79cf, 0x000f7bcf,
		       0x000f7dcf, 0x000f7fcf, 0x000f81cf, 0x000f83cf,
		       0x000f85cf, 0x000f87cf, 0x000f89cf, 0x000f8bcf,
		       0x000f8dcf, 0x000f8fcf, 0x000f91cf, 0x000f93cf,
		       0x000f95cf, 0x000f97cf, 0x000f99cf, 0x000f9bcf,
		       0x000f9dcf, 0x000f9fcf, 0x000fa1cf, 0x000fa3cf,
		       0x000fa5cf, 0x000fa7cf, 0x000fa9cf, 0x000fabcf,
		       0x000fadcf, 0x000fafcf, 0x000fb1cf, 0x000fb3cf,
		       0x000fb5cf, 0x000fb7cf, 0x000fb9cf, 0x000fbbcf,
		       0x000fbdcf, 0x000fbfcf, 0x000fc1cf, 0x000fc3cf,
		       0x000fc5cf, 0x000fc7cf, 0x000fc9cf, 0x000fcbcf,
		       0x000fcdcf, 0x000fcfcf, 0x000fd1cf, 0x000fd3cf,
		       0x000fd5cf, 0x000fd7cf, 0x000fd9cf, 0x000fdbcf,
		       0x000fddcf, 0x000fdfcf, 0x000fe1cf, 0x000fe3cf,
		       0x000fe5cf, 0x000fe7cf, 0x000fe9cf, 0x000febcf,
		       0x000fedcf, 0x000fefcf, 0x000ff1cf, 0x000ff3cf,
		       0x000ff5cf, 0x000ff7cf, 0x000ff9cf, 0x000ffbcf,
		       0x000ffdcf, 0x000fffcf, 0x00000170, 0x00000570,
		       0x00000970, 0x00000d70, 0x00001170, 0x00001570,
		       0x00001970, 0x00001d70, 0x00002170, 0x00002570,
		       0x00002970, 0x00002d70, 0x00003170, 0x00003570,
		       0x00003970, 0x00003d70, 0x00004170, 0x00004570,
		       0x00004970, 0x00004d70, 0x00005170, 0x00005570,
		       0x00005970, 0x00005d70, 0x00006170, 0x00006570,
		       0x00006970, 0x00006d70, 0x00007170, 0x00007570,
		       0x00007970, 0x00007d70, 0x00008170, 0x00008570,
		       0x00008970, 0x00008d70, 0x00009170, 0x00009570,
		       0x00009970, 0x00009d70, 0x0000a170, 0x0000a570,
		       0x0000a970, 0x0000ad70, 0x0000b170, 0x0000b570,
		       0x0000b970, 0x0000bd70, 0x0000c170, 0x0000c570,
		       0x0000c970, 0x0000cd70, 0x0000d170, 0x0000d570,
		       0x0000d970, 0x0000dd70, 0x0000e170, 0x0000e570,
		       0x0000e970, 0x0000ed70, 0x0000f170, 0x0000f570,
		       0x0000f970, 0x0000fd70, 0x00010170, 0x00010570,
		       0x00010970, 0x00010d70, 0x00011170, 0x00011570,
		       0x00011970, 0x00011d70, 0x00012170, 0x00012570,
		       0x00012970, 0x00012d70, 0x00013170, 0x00013570,
		       0x00013970, 0x00013d70, 0x00014170, 0x00014570,
		       0x00014970, 0x00014d70, 0x00015170, 0x00015570,
		       0x00015970, 0x00015d70, 0x00016170, 0x00016570,
		       0x00016970, 0x00016d70, 0x00017170, 0x00017570,
		       0x00017970, 0x00017d70, 0x00018170, 0x00018570,
		       0x00018970, 0x00018d70, 0x00019170, 0x00019570,
		       0x00019970, 0x00019d70, 0x0001a170, 0x0001a570,
		       0x0001a970, 0x0001ad70, 0x0001b170, 0x0001b570,
		       0x0001b970, 0x0001bd70, 0x0001c170, 0x0001c570,
		       0x0001c970, 0x0001cd70, 0x0001d170, 0x0001d570,
		       0x0001d970, 0x0001dd70, 0x0001e170, 0x0001e570,
		       0x0001e970, 0x0001ed70, 0x0001f170, 0x0001f570,
		       0x0001f970, 0x0001fd70, 0x00020170, 0x00020570,
		       0x00020970, 0x00020d70, 0x00021170, 0x00021570,
		       0x00021970, 0x00021d70, 0x00022170, 0x00022570,
		       0x00022970, 0x00022d70, 0x00023170, 0x00023570,
		       0x00023970, 0x00023d70, 0x00024170, 0x00024570,
		       0x00024970, 0x00024d70, 0x00025170, 0x00025570,
		       0x00025970, 0x00025d70, 0x00026170, 0x00026570,
		       0x00026970, 0x00026d70, 0x00027170, 0x00027570,
		       0x00027970, 0x00027d70, 0x00028170, 0x00028570,
		       0x00028970, 0x00028d70, 0x00029170, 0x00029570,
		       0x00029970, 0x00029d70, 0x0002a170, 0x0002a570,
		       0x0002a970, 0x0002ad70, 0x0002b170, 0x0002b570,
		       0x0002b970, 0x0002bd70, 0x0002c170, 0x0002c570,
		       0x0002c970, 0x0002cd70, 0x0002d170, 0x0002d570,
		       0x0002d970, 0x0002dd70, 0x0002e170, 0x0002e570,
		       0x0002e970, 0x0002ed70, 0x0002f170, 0x0002f570,
		       0x0002f970, 0x0002fd70, 0x00030170, 0x00030570,
		       0x00030970, 0x00030d70, 0x00031170, 0x00031570,
		       0x00031970, 0x00031d70, 0x00032170, 0x00032570,
		       0x00032970, 0x00032d70, 0x00033170, 0x00033570,
		       0x00033970, 0x00033d70, 0x00034170, 0x00034570,
		       0x00034970, 0x00034d70, 0x00035170, 0x00035570,
		       0x00035970, 0x00035d70, 0x00036170, 0x00036570,
		       0x00036970, 0x00036d70, 0x00037170, 0x00037570,
		       0x00037970, 0x00037d70, 0x00038170, 0x00038570,
		       0x00038970, 0x00038d70, 0x00039170, 0x00039570,
		       0x00039970, 0x00039d70, 0x0003a170, 0x0003a570,
		       0x0003a970, 0x0003ad70, 0x0003b170, 0x0003b570,
		       0x0003b970, 0x0003bd70, 0x0003c170, 0x0003c570,
		       0x0003c970, 0x0003cd70, 0x0003d170, 0x0003d570,
		       0x0003d970, 0x0003dd70, 0x0003e170, 0x0003e570,
		       0x0003e970, 0x0003ed70, 0x0003f170, 0x0003f570,
		       0x0003f970, 0x0003fd70, 0x00040170, 0x00040570,
		       0x00040970, 0x00040d70, 0x00041170, 0x00041570,
		       0x00041970, 0x00041d70, 0x00042170, 0x00042570,
		       0x00042970, 0x00042d70, 0x00043170, 0x00043570,
		       0x00043970, 0x00043d70, 0x00044170, 0x00044570,
		       0x00044970, 0x00044d70, 0x00045170, 0x00045570,
		       0x00045970, 0x00045d70, 0x00046170, 0x00046570,
		       0x00046970, 0x00046d70, 0x00047170, 0x00047570,
		       0x00047970, 0x00047d70, 0x00048170, 0x00048570,
		       0x00048970, 0x00048d70, 0x00049170, 0x00049570,
		       0x00049970, 0x00049d70, 0x0004a170, 0x0004a570,
		       0x0004a970, 0x0004ad70, 0x0004b170, 0x0004b570,
		       0x0004b970, 0x0004bd70, 0x0004c170, 0x0004c570,
		       0x0004c970, 0x0004cd70, 0x0004d170, 0x0004d570,
		       0x0004d970, 0x0004dd70, 0x0004e170, 0x0004e570,
		       0x0004e970, 0x0004ed70, 0x0004f170, 0x0004f570,
		       0x0004f970, 0x0004fd70, 0x00050170, 0x00050570,
		       0x00050970, 0x00050d70, 0x00051170, 0x00051570,
		       0x00051970, 0x00051d70, 0x00052170, 0x00052570,
		       0x00052970, 0x00052d70, 0x00053170, 0x00053570,
		       0x00053970, 0x00053d70, 0x00054170, 0x00054570,
		       0x00054970, 0x00054d70, 0x00055170, 0x00055570,
		       0x00055970, 0x00055d70, 0x00056170, 0x00056570,
		       0x00056970, 0x00056d70, 0x00057170, 0x00057570,
		       0x00057970, 0x00057d70, 0x00058170, 0x00058570,
		       0x00058970, 0x00058d70, 0x00059170, 0x00059570,
		       0x00059970, 0x00059d70, 0x0005a170, 0x0005a570,
		       0x0005a970, 0x0005ad70, 0x0005b170, 0x0005b570,
		       0x0005b970, 0x0005bd70, 0x0005c170, 0x0005c570,
		       0x0005c970, 0x0005cd70, 0x0005d170, 0x0005d570,
		       0x0005d970, 0x0005dd70, 0x0005e170, 0x0005e570,
		       0x0005e970, 0x0005ed70, 0x0005f170, 0x0005f570,
		       0x0005f970, 0x0005fd70, 0x00060170, 0x00060570,
		       0x00060970, 0x00060d70, 0x00061170, 0x00061570,
		       0x00061970, 0x00061d70, 0x00062170, 0x00062570,
		       0x00062970, 0x00062d70, 0x00063170, 0x00063570,
		       0x00063970, 0x00063d70, 0x00064170, 0x00064570,
		       0x00064970, 0x00064d70, 0x00065170, 0x00065570,
		       0x00065970, 0x00065d70, 0x00066170, 0x00066570,
		       0x00066970, 0x00066d70, 0x00067170, 0x00067570,
		       0x00067970, 0x00067d70, 0x00068170, 0x00068570,
		       0x00068970, 0x00068d70, 0x00069170, 0x00069570,
		       0x00069970, 0x00069d70, 0x0006a170, 0x0006a570,
		       0x0006a970, 0x0006ad70, 0x0006b170, 0x0006b570,
		       0x0006b970, 0x0006bd70, 0x0006c170, 0x0006c570,
		       0x0006c970, 0x0006cd70, 0x0006d170, 0x0006d570,
		       0x0006d970, 0x0006dd70, 0x0006e170, 0x0006e570,
		       0x0006e970, 0x0006ed70, 0x0006f170, 0x0006f570,
		       0x0006f970, 0x0006fd70, 0x00070170, 0x00070570,
		       0x00070970, 0x00070d70, 0x00071170, 0x00071570,
		       0x00071970, 0x00071d70, 0x00072170, 0x00072570,
		       0x00072970, 0x00072d70, 0x00073170, 0x00073570,
		       0x00073970, 0x00073d70, 0x00074170, 0x00074570,
		       0x00074970, 0x00074d70, 0x00075170, 0x00075570,
		       0x00075970, 0x00075d70, 0x00076170, 0x00076570,
		       0x00076970, 0x00076d70, 0x00077170, 0x00077570,
		       0x00077970, 0x00077d70, 0x00078170, 0x00078570,
		       0x00078970, 0x00078d70, 0x00079170, 0x00079570,
		       0x00079970, 0x00079d70, 0x0007a170, 0x0007a570,
		       0x0007a970, 0x0007ad70, 0x0007b170, 0x0007b570,
		       0x0007b970, 0x0007bd70, 0x0007c170, 0x0007c570,
		       0x0007c970, 0x0007cd70, 0x0007d170, 0x0007d570,
		       0x0007d970, 0x0007dd70, 0x0007e170, 0x0007e570,
		       0x0007e970, 0x0007ed70, 0x0007f170, 0x0007f570,
		       0x0007f970, 0x0007fd70, 0x00080170, 0x00080570,
		       0x00080970, 0x00080d70, 0x00081170, 0x00081570,
		       0x00081970, 0x00081d70, 0x00082170, 0x00082570,
		       0x00082970, 0x00082d70, 0x00083170, 0x00083570,
		       0x00083970, 0x00083d70, 0x00084170, 0x00084570,
		       0x00084970, 0x00084d70, 0x00085170, 0x00085570,
		       0x00085970, 0x00085d70, 0x00086170, 0x00086570,
		       0x00086970, 0x00086d70, 0x00087170, 0x00087570,
		       0x00087970, 0x00087d70, 0x00088170, 0x00088570,
		       0x00088970, 0x00088d70, 0x00089170, 0x00089570,
		       0x00089970, 0x00089d70, 0x0008a170, 0x0008a570,
		       0x0008a970, 0x0008ad70, 0x0008b170, 0x0008b570,
		       0x0008b970, 0x0008bd70, 0x0008c170, 0x0008c570,
		       0x0008c970, 0x0008cd70, 0x0008d170, 0x0008d570,
		       0x0008d970, 0x0008dd70, 0x0008e170, 0x0008e570,
		       0x0008e970, 0x0008ed70, 0x0008f170, 0x0008f570,
		       0x0008f970, 0x0008fd70, 0x00090170, 0x00090570,
		       0x00090970, 0x00090d70, 0x00091170, 0x00091570,
		       0x00091970, 0x00091d70, 0x00092170, 0x00092570,
		       0x00092970, 0x00092d70, 0x00093170, 0x00093570,
		       0x00093970, 0x00093d70, 0x00094170, 0x00094570,
		       0x00094970, 0x00094d70, 0x00095170, 0x00095570,
		       0x00095970, 0x00095d70, 0x00096170, 0x00096570,
		       0x00096970, 0x00096d70, 0x00097170, 0x00097570,
		       0x00097970, 0x00097d70, 0x00098170, 0x00098570,
		       0x00098970, 0x00098d70, 0x00099170, 0x00099570,
		       0x00099970, 0x00099d70, 0x0009a170, 0x0009a570,
		       0x0009a970, 0x0009ad70, 0x0009b170, 0x0009b570,
		       0x0009b970, 0x0009bd70, 0x0009c170, 0x0009c570,
		       0x0009c970, 0x0009cd70, 0x0009d170, 0x0009d570,
		       0x0009d970, 0x0009dd70, 0x0009e170, 0x0009e570,
		       0x0009e970, 0x0009ed70, 0x0009f170, 0x0009f570,
		       0x0009f970, 0x0009fd70, 0x000a0170, 0x000a0570,
		       0x000a0970, 0x000a0d70, 0x000a1170, 0x000a1570,
		       0x000a1970, 0x000a1d70, 0x000a2170, 0x000a2570,
		       0x000a2970, 0x000a2d70, 0x000a3170, 0x000a3570,
		       0x000a3970, 0x000a3d70, 0x000a4170, 0x000a4570,
		       0x000a4970, 0x000a4d70, 0x000a5170, 0x000a5570,
		       0x000a5970, 0x000a5d70, 0x000a6170, 0x000a6570,
		       0x000a6970, 0x000a6d70, 0x000a7170, 0x000a7570,
		       0x000a7970, 0x000a7d70, 0x000a8170, 0x000a8570,
		       0x000a8970, 0x000a8d70, 0x000a9170, 0x000a9570,
		       0x000a9970, 0x000a9d70, 0x000aa170, 0x000aa570,
		       0x000aa970, 0x000aad70, 0x000ab170, 0x000ab570,
		       0x000ab970, 0x000abd70, 0x000ac170, 0x000ac570,
		       0x000ac970, 0x000acd70, 0x000ad170, 0x000ad570,
		       0x000ad970, 0x000add70, 0x000ae170, 0x000ae570,
		       0x000ae970, 0x000aed70, 0x000af170, 0x000af570,
		       0x000af970, 0x000afd70, 0x000b0170, 0x000b0570,
		       0x000b0970, 0x000b0d70, 0x000b1170, 0x000b1570,
		       0x000b1970, 0x000b1d70, 0x000b2170, 0x000b2570,
		       0x000b2970, 0x000b2d70, 0x000b3170, 0x000b3570,
		       0x000b3970, 0x000b3d70, 0x000b4170, 0x000b4570,
		       0x000b4970, 0x000b4d70, 0x000b5170, 0x000b5570,
		       0x000b5970, 0x000b5d70, 0x000b6170, 0x000b6570,
		       0x000b6970, 0x000b6d70, 0x000b7170, 0x000b7570,
		       0x000b7970, 0x000b7d70, 0x000b8170, 0x000b8570,
		       0x000b8970, 0x000b8d70, 0x000b9170, 0x000b9570,
		       0x000b9970, 0x000b9d70, 0x000ba170, 0x000ba570,
		       0x000ba970, 0x000bad70, 0x000bb170, 0x000bb570,
		       0x000bb970, 0x000bbd70, 0x000bc170, 0x000bc570,
		       0x000bc970, 0x000bcd70, 0x000bd170, 0x000bd570,
		       0x000bd970, 0x000bdd70, 0x000be170, 0x000be570,
		       0x000be970, 0x000bed70, 0x000bf170, 0x000bf570,
		       0x000bf970, 0x000bfd70, 0x000c0170, 0x000c0570,
		       0x000c0970, 0x000c0d70, 0x000c1170, 0x000c1570,
		       0x000c1970, 0x000c1d70, 0x000c2170, 0x000c2570,
		       0x000c2970, 0x000c2d70, 0x000c3170, 0x000c3570,
		       0x000c3970, 0x000c3d70, 0x000c4170, 0x000c4570,
		       0x000c4970, 0x000c4d70, 0x000c5170, 0x000c5570,
		       0x000c5970, 0x000c5d70, 0x000c6170, 0x000c6570,
		       0x000c6970, 0x000c6d70, 0x000c7170, 0x000c7570,
		       0x000c7970, 0x000c7d70, 0x000c8170, 0x000c8570,
		       0x000c8970, 0x000c8d70, 0x000c9170, 0x000c9570,
		       0x000c9970, 0x000c9d70, 0x000ca170, 0x000ca570,
		       0x000ca970, 0x000cad70, 0x000cb170, 0x000cb570,
		       0x000cb970, 0x000cbd70, 0x000cc170, 0x000cc570,
		       0x000cc970, 0x000ccd70, 0x000cd170, 0x000cd570,
		       0x000cd970, 0x000cdd70, 0x000ce170, 0x000ce570,
		       0x000ce970, 0x000ced70, 0x000cf170, 0x000cf570,
		       0x000cf970, 0x000cfd70, 0x000d0170, 0x000d0570,
		       0x000d0970, 0x000d0d70, 0x000d1170, 0x000d1570,
		       0x000d1970, 0x000d1d70, 0x000d2170, 0x000d2570,
		       0x000d2970, 0x000d2d70, 0x000d3170, 0x000d3570,
		       0x000d3970, 0x000d3d70, 0x000d4170, 0x000d4570,
		       0x000d4970, 0x000d4d70, 0x000d5170, 0x000d5570,
		       0x000d5970, 0x000d5d70, 0x000d6170, 0x000d6570,
		       0x000d6970, 0x000d6d70, 0x000d7170, 0x000d7570,
		       0x000d7970, 0x000d7d70, 0x000d8170, 0x000d8570,
		       0x000d8970, 0x000d8d70, 0x000d9170, 0x000d9570,
		       0x000d9970, 0x000d9d70, 0x000da170, 0x000da570,
		       0x000da970, 0x000dad70, 0x000db170, 0x000db570,
		       0x000db970, 0x000dbd70, 0x000dc170, 0x000dc570,
		       0x000dc970, 0x000dcd70, 0x000dd170, 0x000dd570,
		       0x000dd970, 0x000ddd70, 0x000de170, 0x000de570,
		       0x000de970, 0x000ded70, 0x000df170, 0x000df570,
		       0x000df970, 0x000dfd70, 0x000e0170, 0x000e0570,
		       0x000e0970, 0x000e0d70, 0x000e1170, 0x000e1570,
		       0x000e1970, 0x000e1d70, 0x000e2170, 0x000e2570,
		       0x000e2970, 0x000e2d70, 0x000e3170, 0x000e3570,
		       0x000e3970, 0x000e3d70, 0x000e4170, 0x000e4570,
		       0x000e4970, 0x000e4d70, 0x000e5170, 0x000e5570,
		       0x000e5970, 0x000e5d70, 0x000e6170, 0x000e6570,
		       0x000e6970, 0x000e6d70, 0x000e7170, 0x000e7570,
		       0x000e7970, 0x000e7d70, 0x000e8170, 0x000e8570,
		       0x000e8970, 0x000e8d70, 0x000e9170, 0x000e9570,
		       0x000e9970, 0x000e9d70, 0x000ea170, 0x000ea570,
		       0x000ea970, 0x000ead70, 0x000eb170, 0x000eb570,
		       0x000eb970, 0x000ebd70, 0x000ec170, 0x000ec570,
		       0x000ec970, 0x000ecd70, 0x000ed170, 0x000ed570,
		       0x000ed970, 0x000edd70, 0x000ee170, 0x000ee570,
		       0x000ee970, 0x000eed70, 0x000ef170, 0x000ef570,
		       0x000ef970, 0x000efd70, 0x000f0170, 0x000f0570,
		       0x000f0970, 0x000f0d70, 0x000f1170, 0x000f1570,
		       0x000f1970, 0x000f1d70, 0x000f2170, 0x000f2570,
		       0x000f2970, 0x000f2d70, 0x000f3170, 0x000f3570,
		       0x000f3970, 0x000f3d70, 0x000f4170, 0x000f4570,
		       0x000f4970, 0x000f4d70, 0x000f5170, 0x000f5570,
		       0x000f5970, 0x000f5d70, 0x000f6170, 0x000f6570,
		       0x000f6970, 0x000f6d70, 0x000f7170, 0x000f7570,
		       0x000f7970, 0x000f7d70, 0x000f8170, 0x000f8570,
		       0x000f8970, 0x000f8d70, 0x000f9170, 0x000f9570,
		       0x000f9970, 0x000f9d70, 0x000fa170, 0x000fa570,
		       0x000fa970, 0x000fad70, 0x000fb170, 0x000fb570,
		       0x000fb970, 0x000fbd70, 0x000fc170, 0x000fc570,
		       0x000fc970, 0x000fcd70, 0x000fd170, 0x000fd570,
		       0x000fd970, 0x000fdd70, 0x000fe170, 0x000fe570,
		       0x000fe970, 0x000fed70, 0x000ff170, 0x000ff570,
		       0x000ff970, 0x000ffd70, 0x00100170, 0x00100570,
		       0x00100970, 0x00100d70, 0x00101170, 0x00101570,
		       0x00101970, 0x00101d70, 0x00102170, 0x00102570,
		       0x00102970, 0x00102d70, 0x00103170, 0x00103570,
		       0x00103970, 0x00103d70, 0x00104170, 0x00104570,
		       0x00104970, 0x00104d70, 0x00105170, 0x00105570,
		       0x00105970, 0x00105d70, 0x00106170, 0x00106570,
		       0x00106970, 0x00106d70, 0x00107170, 0x00107570,
		       0x00107970, 0x00107d70, 0x00108170, 0x00108570,
		       0x00108970, 0x00108d70, 0x00109170, 0x00109570,
		       0x00109970, 0x00109d70, 0x0010a170, 0x0010a570,
		       0x0010a970, 0x0010ad70, 0x0010b170, 0x0010b570,
		       0x0010b970, 0x0010bd70, 0x0010c170, 0x0010c570,
		       0x0010c970, 0x0010cd70, 0x0010d170, 0x0010d570,
		       0x0010d970, 0x0010dd70, 0x0010e170, 0x0010e570,
		       0x0010e970, 0x0010ed70, 0x0010f170, 0x0010f570,
		       0x0010f970, 0x0010fd70, 0x00110170, 0x00110570,
		       0x00110970, 0x00110d70, 0x00111170, 0x00111570,
		       0x00111970, 0x00111d70, 0x00112170, 0x00112570,
		       0x00112970, 0x00112d70, 0x00113170, 0x00113570,
		       0x00113970, 0x00113d70, 0x00114170, 0x00114570,
		       0x00114970, 0x00114d70, 0x00115170, 0x00115570,
		       0x00115970, 0x00115d70, 0x00116170, 0x00116570,
		       0x00116970, 0x00116d70, 0x00117170, 0x00117570,
		       0x00117970, 0x00117d70, 0x00118170, 0x00118570,
		       0x00118970, 0x00118d70, 0x00119170, 0x00119570,
		       0x00119970, 0x00119d70, 0x0011a170, 0x0011a570,
		       0x0011a970, 0x0011ad70, 0x0011b170, 0x0011b570,
		       0x0011b970, 0x0011bd70, 0x0011c170, 0x0011c570,
		       0x0011c970, 0x0011cd70, 0x0011d170, 0x0011d570,
		       0x0011d970, 0x0011dd70, 0x0011e170, 0x0011e570,
		       0x0011e970, 0x0011ed70, 0x0011f170, 0x0011f570,
		       0x0011f970, 0x0011fd70, 0x00120170, 0x00120570,
		       0x00120970, 0x00120d70, 0x00121170, 0x00121570,
		       0x00121970, 0x00121d70, 0x00122170, 0x00122570,
		       0x00122970, 0x00122d70, 0x00123170, 0x00123570,
		       0x00123970, 0x00123d70, 0x00124170, 0x00124570,
		       0x00124970, 0x00124d70, 0x00125170, 0x00125570,
		       0x00125970, 0x00125d70, 0x00126170, 0x00126570,
		       0x00126970, 0x00126d70, 0x00127170, 0x00127570,
		       0x00127970, 0x00127d70, 0x00128170, 0x00128570,
		       0x00128970, 0x00128d70, 0x00129170, 0x00129570,
		       0x00129970, 0x00129d70, 0x0012a170, 0x0012a570,
		       0x0012a970, 0x0012ad70, 0x0012b170, 0x0012b570,
		       0x0012b970, 0x0012bd70, 0x0012c170, 0x0012c570,
		       0x0012c970, 0x0012cd70, 0x0012d170, 0x0012d570,
		       0x0012d970, 0x0012dd70, 0x0012e170, 0x0012e570,
		       0x0012e970, 0x0012ed70, 0x0012f170, 0x0012f570,
		       0x0012f970, 0x0012fd70, 0x00130170, 0x00130570,
		       0x00130970, 0x00130d70, 0x00131170, 0x00131570,
		       0x00131970, 0x00131d70, 0x00132170, 0x00132570,
		       0x00132970, 0x00132d70, 0x00133170, 0x00133570,
		       0x00133970, 0x00133d70, 0x00134170, 0x00134570,
		       0x00134970, 0x00134d70, 0x00135170, 0x00135570,
		       0x00135970, 0x00135d70, 0x00136170, 0x00136570,
		       0x00136970, 0x00136d70, 0x00137170, 0x00137570,
		       0x00137970, 0x00137d70, 0x00138170, 0x00138570,
		       0x00138970, 0x00138d70, 0x00139170, 0x00139570,
		       0x00139970, 0x00139d70, 0x0013a170, 0x0013a570,
		       0x0013a970, 0x0013ad70, 0x0013b170, 0x0013b570,
		       0x0013b970, 0x0013bd70, 0x0013c170, 0x0013c570,
		       0x0013c970, 0x0013cd70, 0x0013d170, 0x0013d570,
		       0x0013d970, 0x0013dd70, 0x0013e170, 0x0013e570,
		       0x0013e970, 0x0013ed70, 0x0013f170, 0x0013f570,
		       0x0013f970, 0x0013fd70, 0x00140170, 0x00140570,
		       0x00140970, 0x00140d70, 0x00141170, 0x00141570,
		       0x00141970, 0x00141d70, 0x00142170, 0x00142570,
		       0x00142970, 0x00142d70, 0x00143170, 0x00143570,
		       0x00143970, 0x00143d70, 0x00144170, 0x00144570,
		       0x00144970, 0x00144d70, 0x00145170, 0x00145570,
		       0x00145970, 0x00145d70, 0x00146170, 0x00146570,
		       0x00146970, 0x00146d70, 0x00147170, 0x00147570,
		       0x00147970, 0x00147d70, 0x00148170, 0x00148570,
		       0x00148970, 0x00148d70, 0x00149170, 0x00149570,
		       0x00149970, 0x00149d70, 0x0014a170, 0x0014a570,
		       0x0014a970, 0x0014ad70, 0x0014b170, 0x0014b570,
		       0x0014b970, 0x0014bd70, 0x0014c170, 0x0014c570,
		       0x0014c970, 0x0014cd70, 0x0014d170, 0x0014d570,
		       0x0014d970, 0x0014dd70, 0x0014e170, 0x0014e570,
		       0x0014e970, 0x0014ed70, 0x0014f170, 0x0014f570,
		       0x0014f970, 0x0014fd70, 0x00150170, 0x00150570,
		       0x00150970, 0x00150d70, 0x00151170, 0x00151570,
		       0x00151970, 0x00151d70, 0x00152170, 0x00152570,
		       0x00152970, 0x00152d70, 0x00153170, 0x00153570,
		       0x00153970, 0x00153d70, 0x00154170, 0x00154570,
		       0x00154970, 0x00154d70, 0x00155170, 0x00155570,
		       0x00155970, 0x00155d70, 0x00156170, 0x00156570,
		       0x00156970, 0x00156d70, 0x00157170, 0x00157570,
		       0x00157970, 0x00157d70, 0x00158170, 0x00158570,
		       0x00158970, 0x00158d70, 0x00159170, 0x00159570,
		       0x00159970, 0x00159d70, 0x0015a170, 0x0015a570,
		       0x0015a970, 0x0015ad70, 0x0015b170, 0x0015b570,
		       0x0015b970, 0x0015bd70, 0x0015c170, 0x0015c570,
		       0x0015c970, 0x0015cd70, 0x0015d170, 0x0015d570,
		       0x0015d970, 0x0015dd70, 0x0015e170, 0x0015e570,
		       0x0015e970, 0x0015ed70, 0x0015f170, 0x0015f570,
		       0x0015f970, 0x0015fd70, 0x00160170, 0x00160570,
		       0x00160970, 0x00160d70, 0x00161170, 0x00161570,
		       0x00161970, 0x00161d70, 0x00162170, 0x00162570,
		       0x00162970, 0x00162d70, 0x00163170, 0x00163570,
		       0x00163970, 0x00163d70, 0x00164170, 0x00164570,
		       0x00164970, 0x00164d70, 0x00165170, 0x00165570,
		       0x00165970, 0x00165d70, 0x00166170, 0x00166570,
		       0x00166970, 0x00166d70, 0x00167170, 0x00167570,
		       0x00167970, 0x00167d70, 0x00168170, 0x00168570,
		       0x00168970, 0x00168d70, 0x00169170, 0x00169570,
		       0x00169970, 0x00169d70, 0x0016a170, 0x0016a570,
		       0x0016a970, 0x0016ad70, 0x0016b170, 0x0016b570,
		       0x0016b970, 0x0016bd70, 0x0016c170, 0x0016c570,
		       0x0016c970, 0x0016cd70, 0x0016d170, 0x0016d570,
		       0x0016d970, 0x0016dd70, 0x0016e170, 0x0016e570,
		       0x0016e970, 0x0016ed70, 0x0016f170, 0x0016f570,
		       0x0016f970, 0x0016fd70, 0x00170170, 0x00170570,
		       0x00170970, 0x00170d70, 0x00171170, 0x00171570,
		       0x00171970, 0x00171d70, 0x00172170, 0x00172570,
		       0x00172970, 0x00172d70, 0x00173170, 0x00173570,
		       0x00173970, 0x00173d70, 0x00174170, 0x00174570,
		       0x00174970, 0x00174d70, 0x00175170, 0x00175570,
		       0x00175970, 0x00175d70, 0x00176170, 0x00176570,
		       0x00176970, 0x00176d70, 0x00177170, 0x00177570,
		       0x00177970, 0x00177d70, 0x00178170, 0x00178570,
		       0x00178970, 0x00178d70, 0x00179170, 0x00179570,
		       0x00179970, 0x00179d70, 0x0017a170, 0x0017a570,
		       0x0017a970, 0x0017ad70, 0x0017b170, 0x0017b570,
		       0x0017b970, 0x0017bd70, 0x0017c170, 0x0017c570,
		       0x0017c970, 0x0017cd70, 0x0017d170, 0x0017d570,
		       0x0017d970, 0x0017dd70, 0x0017e170, 0x0017e570,
		       0x0017e970, 0x0017ed70, 0x0017f170, 0x0017f570,
		       0x0017f970, 0x0017fd70, 0x00180170, 0x00180570,
		       0x00180970, 0x00180d70, 0x00181170, 0x00181570,
		       0x00181970, 0x00181d70, 0x00182170, 0x00182570,
		       0x00182970, 0x00182d70, 0x00183170, 0x00183570,
		       0x00183970, 0x00183d70, 0x00184170, 0x00184570,
		       0x00184970, 0x00184d70, 0x00185170, 0x00185570,
		       0x00185970, 0x00185d70, 0x00186170, 0x00186570,
		       0x00186970, 0x00186d70, 0x00187170, 0x00187570,
		       0x00187970, 0x00187d70, 0x00188170, 0x00188570,
		       0x00188970, 0x00188d70, 0x00189170, 0x00189570,
		       0x00189970, 0x00189d70, 0x0018a170, 0x0018a570,
		       0x0018a970, 0x0018ad70, 0x0018b170, 0x0018b570,
		       0x0018b970, 0x0018bd70, 0x0018c170, 0x0018c570,
		       0x0018c970, 0x0018cd70, 0x0018d170, 0x0018d570,
		       0x0018d970, 0x0018dd70, 0x0018e170, 0x0018e570,
		       0x0018e970, 0x0018ed70, 0x0018f170, 0x0018f570,
		       0x0018f970, 0x0018fd70, 0x00190170, 0x00190570,
		       0x00190970, 0x00190d70, 0x00191170, 0x00191570,
		       0x00191970, 0x00191d70, 0x00192170, 0x00192570,
		       0x00192970, 0x00192d70, 0x00193170, 0x00193570,
		       0x00193970, 0x00193d70, 0x00194170, 0x00194570,
		       0x00194970, 0x00194d70, 0x00195170, 0x00195570,
		       0x00195970, 0x00195d70, 0x00196170, 0x00196570,
		       0x00196970, 0x00196d70, 0x00197170, 0x00197570,
		       0x00197970, 0x00197d70, 0x00198170, 0x00198570,
		       0x00198970, 0x00198d70, 0x00199170, 0x00199570,
		       0x00199970, 0x00199d70, 0x0019a170, 0x0019a570,
		       0x0019a970, 0x0019ad70, 0x0019b170, 0x0019b570,
		       0x0019b970, 0x0019bd70, 0x0019c170, 0x0019c570,
		       0x0019c970, 0x0019cd70, 0x0019d170, 0x0019d570,
		       0x0019d970, 0x0019dd70, 0x0019e170, 0x0019e570,
		       0x0019e970, 0x0019ed70, 0x0019f170, 0x0019f570,
		       0x0019f970, 0x0019fd70, 0x001a0170, 0x001a0570,
		       0x001a0970, 0x001a0d70, 0x001a1170, 0x001a1570,
		       0x001a1970, 0x001a1d70, 0x001a2170, 0x001a2570,
		       0x001a2970, 0x001a2d70, 0x001a3170, 0x001a3570,
		       0x001a3970, 0x001a3d70, 0x001a4170, 0x001a4570,
		       0x001a4970, 0x001a4d70, 0x001a5170, 0x001a5570,
		       0x001a5970, 0x001a5d70, 0x001a6170, 0x001a6570,
		       0x001a6970, 0x001a6d70, 0x001a7170, 0x001a7570,
		       0x001a7970, 0x001a7d70, 0x001a8170, 0x001a8570,
		       0x001a8970, 0x001a8d70, 0x001a9170, 0x001a9570,
		       0x001a9970, 0x001a9d70, 0x001aa170, 0x001aa570,
		       0x001aa970, 0x001aad70, 0x001ab170, 0x001ab570,
		       0x001ab970, 0x001abd70, 0x001ac170, 0x001ac570,
		       0x001ac970, 0x001acd70, 0x001ad170, 0x001ad570,
		       0x001ad970, 0x001add70, 0x001ae170, 0x001ae570,
		       0x001ae970, 0x001aed70, 0x001af170, 0x001af570,
		       0x001af970, 0x001afd70, 0x001b0170, 0x001b0570,
		       0x001b0970, 0x001b0d70, 0x001b1170, 0x001b1570,
		       0x001b1970, 0x001b1d70, 0x001b2170, 0x001b2570,
		       0x001b2970, 0x001b2d70, 0x001b3170, 0x001b3570,
		       0x001b3970, 0x001b3d70, 0x001b4170, 0x001b4570,
		       0x001b4970, 0x001b4d70, 0x001b5170, 0x001b5570,
		       0x001b5970, 0x001b5d70, 0x001b6170, 0x001b6570,
		       0x001b6970, 0x001b6d70, 0x001b7170, 0x001b7570,
		       0x001b7970, 0x001b7d70, 0x001b8170, 0x001b8570,
		       0x001b8970, 0x001b8d70, 0x001b9170, 0x001b9570,
		       0x001b9970, 0x001b9d70, 0x001ba170, 0x001ba570,
		       0x001ba970, 0x001bad70, 0x001bb170, 0x001bb570,
		       0x001bb970, 0x001bbd70, 0x001bc170, 0x001bc570,
		       0x001bc970, 0x001bcd70, 0x001bd170, 0x001bd570,
		       0x001bd970, 0x001bdd70, 0x001be170, 0x001be570,
		       0x001be970, 0x001bed70, 0x001bf170, 0x001bf570,
		       0x001bf970, 0x001bfd70, 0x001c0170, 0x001c0570,
		       0x001c0970, 0x001c0d70, 0x001c1170, 0x001c1570,
		       0x001c1970, 0x001c1d70, 0x001c2170, 0x001c2570,
		       0x001c2970, 0x001c2d70, 0x001c3170, 0x001c3570,
		       0x001c3970, 0x001c3d70, 0x001c4170, 0x001c4570,
		       0x001c4970, 0x001c4d70, 0x001c5170, 0x001c5570,
		       0x001c5970, 0x001c5d70, 0x001c6170, 0x001c6570,
		       0x001c6970, 0x001c6d70, 0x001c7170, 0x001c7570,
		       0x001c7970, 0x001c7d70, 0x001c8170, 0x001c8570,
		       0x001c8970, 0x001c8d70, 0x001c9170, 0x001c9570,
		       0x001c9970, 0x001c9d70, 0x001ca170, 0x001ca570,
		       0x001ca970, 0x001cad70, 0x001cb170, 0x001cb570,
		       0x001cb970, 0x001cbd70, 0x001cc170, 0x001cc570,
		       0x001cc970, 0x001ccd70, 0x001cd170, 0x001cd570,
		       0x001cd970, 0x001cdd70, 0x001ce170, 0x001ce570,
		       0x001ce970, 0x001ced70, 0x001cf170, 0x001cf570,
		       0x001cf970, 0x001cfd70, 0x001d0170, 0x001d0570,
		       0x001d0970, 0x001d0d70, 0x001d1170, 0x001d1570,
		       0x001d1970, 0x001d1d70, 0x001d2170, 0x001d2570,
		       0x001d2970, 0x001d2d70, 0x001d3170, 0x001d3570,
		       0x001d3970, 0x001d3d70, 0x001d4170, 0x001d4570,
		       0x001d4970, 0x001d4d70, 0x001d5170, 0x001d5570,
		       0x001d5970, 0x001d5d70, 0x001d6170, 0x001d6570,
		       0x001d6970, 0x001d6d70, 0x001d7170, 0x001d7570,
		       0x001d7970, 0x001d7d70, 0x001d8170, 0x001d8570,
		       0x001d8970, 0x001d8d70, 0x001d9170, 0x001d9570,
		       0x001d9970, 0x001d9d70, 0x001da170, 0x001da570,
		       0x001da970, 0x001dad70, 0x001db170, 0x001db570,
		       0x001db970, 0x001dbd70, 0x001dc170, 0x001dc570,
		       0x001dc970, 0x001dcd70, 0x001dd170, 0x001dd570,
		       0x001dd970, 0x001ddd70, 0x001de170, 0x001de570,
		       0x001de970, 0x001ded70, 0x001df170, 0x001df570,
		       0x001df970, 0x001dfd70, 0x001e0170, 0x001e0570,
		       0x001e0970, 0x001e0d70, 0x001e1170, 0x001e1570,
		       0x001e1970, 0x001e1d70, 0x001e2170, 0x001e2570,
		       0x001e2970, 0x001e2d70, 0x001e3170, 0x001e3570,
		       0x001e3970, 0x001e3d70, 0x001e4170, 0x001e4570,
		       0x001e4970, 0x001e4d70, 0x001e5170, 0x001e5570,
		       0x001e5970, 0x001e5d70, 0x001e6170, 0x001e6570,
		       0x001e6970, 0x001e6d70, 0x001e7170, 0x001e7570,
		       0x001e7970, 0x001e7d70, 0x001e8170, 0x001e8570,
		       0x001e8970, 0x001e8d70, 0x001e9170, 0x001e9570,
		       0x001e9970, 0x001e9d70, 0x001ea170, 0x001ea570,
		       0x001ea970, 0x001ead70, 0x001eb170, 0x001eb570,
		       0x001eb970, 0x001ebd70, 0x001ec170, 0x001ec570,
		       0x001ec970, 0x001ecd70, 0x001ed170, 0x001ed570,
		       0x001ed970, 0x001edd70, 0x001ee170, 0x001ee570,
		       0x001ee970, 0x001eed70, 0x001ef170, 0x001ef570,
		       0x001ef970, 0x001efd70, 0x001f0170, 0x001f0570,
		       0x001f0970, 0x001f0d70, 0x001f1170, 0x001f1570,
		       0x001f1970, 0x001f1d70, 0x001f2170, 0x001f2570,
		       0x001f2970, 0x001f2d70, 0x001f3170, 0x001f3570,
		       0x001f3970, 0x001f3d70, 0x001f4170, 0x001f4570,
		       0x001f4970, 0x001f4d70, 0x001f5170, 0x001f5570,
		       0x001f5970, 0x001f5d70, 0x001f6170, 0x001f6570,
		       0x001f6970, 0x001f6d70, 0x001f7170, 0x001f7570,
		       0x001f7970, 0x001f7d70, 0x001f8170, 0x001f8570,
		       0x001f8970, 0x001f8d70, 0x001f9170, 0x001f9570,
		       0x001f9970, 0x001f9d70, 0x001fa170, 0x001fa570,
		       0x001fa970, 0x001fad70, 0x001fb170, 0x001fb570,
		       0x001fb970, 0x001fbd70, 0x001fc170, 0x001fc570,
		       0x001fc970, 0x001fcd70, 0x001fd170, 0x001fd570,
		       0x001fd970, 0x001fdd70, 0x001fe170, 0x001fe570,
		       0x001fe970, 0x001fed70, 0x001ff170, 0x001ff570,
		       0x001ff970, 0x001ffd70
#endif /* LONGER_HUFFTABLE */
		       },

	.len_table = {
		      0x000bffef, 0x00000002, 0x00000044, 0x00000144,
		      0x000002c5, 0x00000526, 0x00000ea7, 0x000001a7,
		      0x000001c6, 0x000005c6, 0x00001869, 0x00003869,
		      0x00000469, 0x00002469, 0x00001469, 0x00003469,
		      0x00000c6a, 0x00002c6a, 0x00004c6a, 0x00006c6a,
		      0x000030eb, 0x000070eb, 0x0000b0eb, 0x0000f0eb,
		      0x000041ec, 0x0000c1ec, 0x000141ec, 0x0001c1ec,
		      0x000021ec, 0x0000a1ec, 0x000121ec, 0x0001a1ec,
		      0x000061ed, 0x0000e1ed, 0x000161ed, 0x0001e1ed,
		      0x000261ed, 0x0002e1ed, 0x000361ed, 0x0003e1ed,
		      0x000011ed, 0x000091ed, 0x000111ed, 0x000191ed,
		      0x000211ed, 0x000291ed, 0x000311ed, 0x000391ed,
		      0x000051ed, 0x0000d1ed, 0x000151ed, 0x0001d1ed,
		      0x000251ed, 0x0002d1ed, 0x000351ed, 0x0003d1ed,
		      0x000031ed, 0x0000b1ed, 0x000131ed, 0x0001b1ed,
		      0x000231ed, 0x0002b1ed, 0x000331ed, 0x0003b1ed,
		      0x00003fef, 0x00013fef, 0x00023fef, 0x00033fef,
		      0x00043fef, 0x00053fef, 0x00063fef, 0x00073fef,
		      0x00083fef, 0x00093fef, 0x000a3fef, 0x000b3fef,
		      0x000c3fef, 0x000d3fef, 0x000e3fef, 0x000f3fef,
		      0x00007ff0, 0x00027ff0, 0x00047ff0, 0x00067ff0,
		      0x00087ff0, 0x000a7ff0, 0x000c7ff0, 0x000e7ff0,
		      0x00107ff0, 0x00127ff0, 0x00147ff0, 0x00167ff0,
		      0x00187ff0, 0x001a7ff0, 0x001c7ff0, 0x001e7ff0,
		      0x0000fff1, 0x0004fff1, 0x0008fff1, 0x000cfff1,
		      0x0010fff1, 0x0014fff1, 0x0018fff1, 0x001cfff1,
		      0x0020fff1, 0x0024fff1, 0x0028fff1, 0x002cfff1,
		      0x0030fff1, 0x0034fff1, 0x0038fff1, 0x003cfff1,
		      0x0002fff1, 0x0006fff1, 0x000afff1, 0x000efff1,
		      0x0012fff1, 0x0016fff1, 0x001afff1, 0x001efff1,
		      0x0022fff1, 0x0026fff1, 0x002afff1, 0x002efff1,
		      0x0032fff1, 0x0036fff1, 0x003afff1, 0x003efff1,
		      0x00017ff1, 0x00037ff1, 0x00057ff1, 0x00077ff1,
		      0x00097ff1, 0x000b7ff1, 0x000d7ff1, 0x000f7ff1,
		      0x00117ff1, 0x00137ff1, 0x00157ff1, 0x00177ff1,
		      0x00197ff1, 0x001b7ff1, 0x001d7ff1, 0x001f7ff1,
		      0x00217ff1, 0x00237ff1, 0x00257ff1, 0x00277ff1,
		      0x00297ff1, 0x002b7ff1, 0x002d7ff1, 0x002f7ff1,
		      0x00317ff1, 0x00337ff1, 0x00357ff1, 0x00377ff1,
		      0x00397ff1, 0x003b7ff1, 0x003d7ff1, 0x003f7ff1,
		      0x0001fff2, 0x0005fff2, 0x0009fff2, 0x000dfff2,
		      0x0011fff2, 0x0015fff2, 0x0019fff2, 0x001dfff2,
		      0x0021fff2, 0x0025fff2, 0x0029fff2, 0x002dfff2,
		      0x0031fff2, 0x0035fff2, 0x0039fff2, 0x003dfff2,
		      0x0041fff2, 0x0045fff2, 0x0049fff2, 0x004dfff2,
		      0x0051fff2, 0x0055fff2, 0x0059fff2, 0x005dfff2,
		      0x0061fff2, 0x0065fff2, 0x0069fff2, 0x006dfff2,
		      0x0071fff2, 0x0075fff2, 0x0079fff2, 0x007dfff2,
		      0x0007fff4, 0x0017fff4, 0x0027fff4, 0x0037fff4,
		      0x0047fff4, 0x0057fff4, 0x0067fff4, 0x0077fff4,
		      0x0087fff4, 0x0097fff4, 0x00a7fff4, 0x00b7fff4,
		      0x00c7fff4, 0x00d7fff4, 0x00e7fff4, 0x00f7fff4,
		      0x0107fff4, 0x0117fff4, 0x0127fff4, 0x0137fff4,
		      0x0147fff4, 0x0157fff4, 0x0167fff4, 0x0177fff4,
		      0x0187fff4, 0x0197fff4, 0x01a7fff4, 0x01b7fff4,
		      0x01c7fff4, 0x01d7fff4, 0x01e7fff4, 0x01f7fff4,
		      0x000ffff4, 0x001ffff4, 0x002ffff4, 0x003ffff4,
		      0x004ffff4, 0x005ffff4, 0x006ffff4, 0x007ffff4,
		      0x008ffff4, 0x009ffff4, 0x00affff4, 0x00bffff4,
		      0x00cffff4, 0x00dffff4, 0x00effff4, 0x00fffff4,
		      0x010ffff4, 0x011ffff4, 0x012ffff4, 0x013ffff4,
		      0x014ffff4, 0x015ffff4, 0x016ffff4, 0x017ffff4,
		      0x018ffff4, 0x019ffff4, 0x01affff4, 0x01bffff4,
		      0x01cffff4, 0x01dffff4, 0x01effff4, 0x0000bfeb},

	.lit_table = {
		      0x001e, 0x004d, 0x00e3, 0x00cd, 0x002d, 0x01e3, 0x0013, 0x0113,
		      0x0093, 0x0193, 0x0019, 0x0053, 0x0153, 0x00ad, 0x00d3, 0x01d3,
		      0x0033, 0x0047, 0x0247, 0x0147, 0x0347, 0x038f, 0x078f, 0x004f,
		      0x00c7, 0x044f, 0x024f, 0x064f, 0x02c7, 0x014f, 0x01c7, 0x0133,
		      0x0006, 0x03c7, 0x00b3, 0x0027, 0x0227, 0x0127, 0x0327, 0x01b3,
		      0x0073, 0x0173, 0x00a7, 0x02a7, 0x0059, 0x006d, 0x00ed, 0x01a7,
		      0x001d, 0x009d, 0x005d, 0x00f3, 0x01f3, 0x000b, 0x010b, 0x008b,
		      0x018b, 0x004b, 0x014b, 0x00cb, 0x03a7, 0x0067, 0x01cb, 0x002b,
		      0x012b, 0x00dd, 0x003d, 0x00ab, 0x01ab, 0x006b, 0x016b, 0x00eb,
		      0x01eb, 0x001b, 0x0267, 0x0167, 0x011b, 0x009b, 0x019b, 0x005b,
		      0x015b, 0x0367, 0x00db, 0x01db, 0x003b, 0x00e7, 0x02e7, 0x01e7,
		      0x03e7, 0x0017, 0x054f, 0x0217, 0x0117, 0x034f, 0x074f, 0x0317,
		      0x0097, 0x003e, 0x00bd, 0x0039, 0x0079, 0x0001, 0x007d, 0x00fd,
		      0x0005, 0x0021, 0x0297, 0x013b, 0x0045, 0x0025, 0x0065, 0x0011,
		      0x0015, 0x0197, 0x0031, 0x0009, 0x0055, 0x0035, 0x00bb, 0x0003,
		      0x01bb, 0x0083, 0x0397, 0x00cf, 0x0057, 0x04cf, 0x0257, 0x0157,
		      0x007b, 0x02cf, 0x06cf, 0x01cf, 0x05cf, 0x03cf, 0x07cf, 0x002f,
		      0x042f, 0x022f, 0x062f, 0x0357, 0x012f, 0x052f, 0x032f, 0x00d7,
		      0x02d7, 0x072f, 0x00af, 0x04af, 0x02af, 0x06af, 0x01af, 0x05af,
		      0x03af, 0x07af, 0x006f, 0x046f, 0x026f, 0x066f, 0x016f, 0x056f,
		      0x01d7, 0x036f, 0x076f, 0x00ef, 0x03d7, 0x04ef, 0x0037, 0x02ef,
		      0x06ef, 0x01ef, 0x05ef, 0x03ef, 0x07ef, 0x001f, 0x041f, 0x021f,
		      0x0237, 0x061f, 0x011f, 0x051f, 0x0137, 0x031f, 0x071f, 0x009f,
		      0x049f, 0x029f, 0x069f, 0x019f, 0x059f, 0x0337, 0x039f, 0x079f,
		      0x017b, 0x00b7, 0x00fb, 0x01fb, 0x005f, 0x045f, 0x025f, 0x02b7,
		      0x065f, 0x015f, 0x055f, 0x035f, 0x075f, 0x00df, 0x04df, 0x01b7,
		      0x03b7, 0x02df, 0x06df, 0x01df, 0x05df, 0x03df, 0x07df, 0x003f,
		      0x043f, 0x023f, 0x063f, 0x013f, 0x053f, 0x033f, 0x073f, 0x00bf,
		      0x0007, 0x04bf, 0x02bf, 0x0077, 0x06bf, 0x01bf, 0x05bf, 0x0277,
		      0x0177, 0x03bf, 0x07bf, 0x007f, 0x047f, 0x027f, 0x067f, 0x017f,
		      0x0107, 0x0377, 0x057f, 0x00f7, 0x037f, 0x077f, 0x00ff, 0x04ff,
		      0x02f7, 0x01f7, 0x02ff, 0x06ff, 0x03f7, 0x000f, 0x0087, 0x0043,
		      0x1fff},

	.lit_table_sizes = {
			    0x06, 0x08, 0x09, 0x08, 0x08, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x07, 0x09, 0x09, 0x08, 0x09, 0x09,
			    0x09, 0x0a, 0x0a, 0x0a, 0x0a, 0x0b, 0x0b, 0x0b,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0a, 0x09,
			    0x05, 0x0a, 0x09, 0x0a, 0x0a, 0x0a, 0x0a, 0x09,
			    0x09, 0x09, 0x0a, 0x0a, 0x07, 0x08, 0x08, 0x0a,
			    0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x0a, 0x0a, 0x09, 0x09,
			    0x09, 0x08, 0x08, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x0a, 0x0a, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x0a, 0x09, 0x09, 0x09, 0x0a, 0x0a, 0x0a,
			    0x0a, 0x0a, 0x0b, 0x0a, 0x0a, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x06, 0x08, 0x07, 0x07, 0x06, 0x08, 0x08,
			    0x07, 0x06, 0x0a, 0x09, 0x07, 0x07, 0x07, 0x06,
			    0x07, 0x0a, 0x06, 0x06, 0x07, 0x07, 0x09, 0x08,
			    0x09, 0x08, 0x0a, 0x0b, 0x0a, 0x0b, 0x0a, 0x0a,
			    0x09, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0a, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0b, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0a, 0x0b, 0x0b,
			    0x09, 0x0a, 0x09, 0x09, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x09, 0x0b, 0x0b, 0x0a, 0x0b, 0x0b, 0x0b, 0x0a,
			    0x0a, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x09, 0x0a, 0x0b, 0x0a, 0x0b, 0x0b, 0x0b, 0x0b,
			    0x0a, 0x0a, 0x0b, 0x0b, 0x0a, 0x0a, 0x09, 0x08,
			    0x0f},

#ifndef LONGER_HUFFTABLE
	.dcodes = {
		   0x003f, 0x00ff, 0x00bf, 0x01ff, 0x007f, 0x001f, 0x005f, 0x0017,
		   0x0037, 0x000f, 0x0009, 0x0019, 0x0005, 0x0015, 0x0004, 0x000c,
		   0x0002, 0x000d, 0x000a, 0x001d, 0x0006, 0x0003, 0x0000, 0x0013,
		   0x000e, 0x000b, 0x0001, 0x001b, 0x0007, 0x002f},

	.dcodes_sizes = {
			 0x08, 0x09, 0x08, 0x09, 0x08, 0x07, 0x07, 0x06,
			 0x06, 0x06, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04,
			 0x04, 0x05, 0x04, 0x05, 0x04, 0x05, 0x03, 0x05,
			 0x04, 0x05, 0x04, 0x05, 0x05, 0x06}
#else
	.dcodes = {
		   0x0001, 0x001b, 0x0007, 0x002f},

	.dcodes_sizes = {
			 0x04, 0x05, 0x05, 0x06}
#endif
};
#endif // LARGE_WINDOW

struct isal_hufftables hufftables_static = {

	.deflate_hdr = {0x03},
	.deflate_hdr_count = 0,
	.deflate_hdr_extra_bits = 3,

	.dist_table = {
		       0x00000005, 0x00000205,
#ifdef LONGER_HUFFTABLE
		       0x00000105, 0x00000305, 0x00000086, 0x00000486,
		       0x00000286, 0x00000686, 0x00000187, 0x00000587,
		       0x00000987, 0x00000d87, 0x00000387, 0x00000787,
		       0x00000b87, 0x00000f87, 0x00000048, 0x00000448,
		       0x00000848, 0x00000c48, 0x00001048, 0x00001448,
		       0x00001848, 0x00001c48, 0x00000248, 0x00000648,
		       0x00000a48, 0x00000e48, 0x00001248, 0x00001648,
		       0x00001a48, 0x00001e48, 0x00000149, 0x00000549,
		       0x00000949, 0x00000d49, 0x00001149, 0x00001549,
		       0x00001949, 0x00001d49, 0x00002149, 0x00002549,
		       0x00002949, 0x00002d49, 0x00003149, 0x00003549,
		       0x00003949, 0x00003d49, 0x00000349, 0x00000749,
		       0x00000b49, 0x00000f49, 0x00001349, 0x00001749,
		       0x00001b49, 0x00001f49, 0x00002349, 0x00002749,
		       0x00002b49, 0x00002f49, 0x00003349, 0x00003749,
		       0x00003b49, 0x00003f49, 0x000000ca, 0x000004ca,
		       0x000008ca, 0x00000cca, 0x000010ca, 0x000014ca,
		       0x000018ca, 0x00001cca, 0x000020ca, 0x000024ca,
		       0x000028ca, 0x00002cca, 0x000030ca, 0x000034ca,
		       0x000038ca, 0x00003cca, 0x000040ca, 0x000044ca,
		       0x000048ca, 0x00004cca, 0x000050ca, 0x000054ca,
		       0x000058ca, 0x00005cca, 0x000060ca, 0x000064ca,
		       0x000068ca, 0x00006cca, 0x000070ca, 0x000074ca,
		       0x000078ca, 0x00007cca, 0x000002ca, 0x000006ca,
		       0x00000aca, 0x00000eca, 0x000012ca, 0x000016ca,
		       0x00001aca, 0x00001eca, 0x000022ca, 0x000026ca,
		       0x00002aca, 0x00002eca, 0x000032ca, 0x000036ca,
		       0x00003aca, 0x00003eca, 0x000042ca, 0x000046ca,
		       0x00004aca, 0x00004eca, 0x000052ca, 0x000056ca,
		       0x00005aca, 0x00005eca, 0x000062ca, 0x000066ca,
		       0x00006aca, 0x00006eca, 0x000072ca, 0x000076ca,
		       0x00007aca, 0x00007eca, 0x000001cb, 0x000005cb,
		       0x000009cb, 0x00000dcb, 0x000011cb, 0x000015cb,
		       0x000019cb, 0x00001dcb, 0x000021cb, 0x000025cb,
		       0x000029cb, 0x00002dcb, 0x000031cb, 0x000035cb,
		       0x000039cb, 0x00003dcb, 0x000041cb, 0x000045cb,
		       0x000049cb, 0x00004dcb, 0x000051cb, 0x000055cb,
		       0x000059cb, 0x00005dcb, 0x000061cb, 0x000065cb,
		       0x000069cb, 0x00006dcb, 0x000071cb, 0x000075cb,
		       0x000079cb, 0x00007dcb, 0x000081cb, 0x000085cb,
		       0x000089cb, 0x00008dcb, 0x000091cb, 0x000095cb,
		       0x000099cb, 0x00009dcb, 0x0000a1cb, 0x0000a5cb,
		       0x0000a9cb, 0x0000adcb, 0x0000b1cb, 0x0000b5cb,
		       0x0000b9cb, 0x0000bdcb, 0x0000c1cb, 0x0000c5cb,
		       0x0000c9cb, 0x0000cdcb, 0x0000d1cb, 0x0000d5cb,
		       0x0000d9cb, 0x0000ddcb, 0x0000e1cb, 0x0000e5cb,
		       0x0000e9cb, 0x0000edcb, 0x0000f1cb, 0x0000f5cb,
		       0x0000f9cb, 0x0000fdcb, 0x000003cb, 0x000007cb,
		       0x00000bcb, 0x00000fcb, 0x000013cb, 0x000017cb,
		       0x00001bcb, 0x00001fcb, 0x000023cb, 0x000027cb,
		       0x00002bcb, 0x00002fcb, 0x000033cb, 0x000037cb,
		       0x00003bcb, 0x00003fcb, 0x000043cb, 0x000047cb,
		       0x00004bcb, 0x00004fcb, 0x000053cb, 0x000057cb,
		       0x00005bcb, 0x00005fcb, 0x000063cb, 0x000067cb,
		       0x00006bcb, 0x00006fcb, 0x000073cb, 0x000077cb,
		       0x00007bcb, 0x00007fcb, 0x000083cb, 0x000087cb,
		       0x00008bcb, 0x00008fcb, 0x000093cb, 0x000097cb,
		       0x00009bcb, 0x00009fcb, 0x0000a3cb, 0x0000a7cb,
		       0x0000abcb, 0x0000afcb, 0x0000b3cb, 0x0000b7cb,
		       0x0000bbcb, 0x0000bfcb, 0x0000c3cb, 0x0000c7cb,
		       0x0000cbcb, 0x0000cfcb, 0x0000d3cb, 0x0000d7cb,
		       0x0000dbcb, 0x0000dfcb, 0x0000e3cb, 0x0000e7cb,
		       0x0000ebcb, 0x0000efcb, 0x0000f3cb, 0x0000f7cb,
		       0x0000fbcb, 0x0000ffcb, 0x0000002c, 0x0000042c,
		       0x0000082c, 0x00000c2c, 0x0000102c, 0x0000142c,
		       0x0000182c, 0x00001c2c, 0x0000202c, 0x0000242c,
		       0x0000282c, 0x00002c2c, 0x0000302c, 0x0000342c,
		       0x0000382c, 0x00003c2c, 0x0000402c, 0x0000442c,
		       0x0000482c, 0x00004c2c, 0x0000502c, 0x0000542c,
		       0x0000582c, 0x00005c2c, 0x0000602c, 0x0000642c,
		       0x0000682c, 0x00006c2c, 0x0000702c, 0x0000742c,
		       0x0000782c, 0x00007c2c, 0x0000802c, 0x0000842c,
		       0x0000882c, 0x00008c2c, 0x0000902c, 0x0000942c,
		       0x0000982c, 0x00009c2c, 0x0000a02c, 0x0000a42c,
		       0x0000a82c, 0x0000ac2c, 0x0000b02c, 0x0000b42c,
		       0x0000b82c, 0x0000bc2c, 0x0000c02c, 0x0000c42c,
		       0x0000c82c, 0x0000cc2c, 0x0000d02c, 0x0000d42c,
		       0x0000d82c, 0x0000dc2c, 0x0000e02c, 0x0000e42c,
		       0x0000e82c, 0x0000ec2c, 0x0000f02c, 0x0000f42c,
		       0x0000f82c, 0x0000fc2c, 0x0001002c, 0x0001042c,
		       0x0001082c, 0x00010c2c, 0x0001102c, 0x0001142c,
		       0x0001182c, 0x00011c2c, 0x0001202c, 0x0001242c,
		       0x0001282c, 0x00012c2c, 0x0001302c, 0x0001342c,
		       0x0001382c, 0x00013c2c, 0x0001402c, 0x0001442c,
		       0x0001482c, 0x00014c2c, 0x0001502c, 0x0001542c,
		       0x0001582c, 0x00015c2c, 0x0001602c, 0x0001642c,
		       0x0001682c, 0x00016c2c, 0x0001702c, 0x0001742c,
		       0x0001782c, 0x00017c2c, 0x0001802c, 0x0001842c,
		       0x0001882c, 0x00018c2c, 0x0001902c, 0x0001942c,
		       0x0001982c, 0x00019c2c, 0x0001a02c, 0x0001a42c,
		       0x0001a82c, 0x0001ac2c, 0x0001b02c, 0x0001b42c,
		       0x0001b82c, 0x0001bc2c, 0x0001c02c, 0x0001c42c,
		       0x0001c82c, 0x0001cc2c, 0x0001d02c, 0x0001d42c,
		       0x0001d82c, 0x0001dc2c, 0x0001e02c, 0x0001e42c,
		       0x0001e82c, 0x0001ec2c, 0x0001f02c, 0x0001f42c,
		       0x0001f82c, 0x0001fc2c, 0x0000022c, 0x0000062c,
		       0x00000a2c, 0x00000e2c, 0x0000122c, 0x0000162c,
		       0x00001a2c, 0x00001e2c, 0x0000222c, 0x0000262c,
		       0x00002a2c, 0x00002e2c, 0x0000322c, 0x0000362c,
		       0x00003a2c, 0x00003e2c, 0x0000422c, 0x0000462c,
		       0x00004a2c, 0x00004e2c, 0x0000522c, 0x0000562c,
		       0x00005a2c, 0x00005e2c, 0x0000622c, 0x0000662c,
		       0x00006a2c, 0x00006e2c, 0x0000722c, 0x0000762c,
		       0x00007a2c, 0x00007e2c, 0x0000822c, 0x0000862c,
		       0x00008a2c, 0x00008e2c, 0x0000922c, 0x0000962c,
		       0x00009a2c, 0x00009e2c, 0x0000a22c, 0x0000a62c,
		       0x0000aa2c, 0x0000ae2c, 0x0000b22c, 0x0000b62c,
		       0x0000ba2c, 0x0000be2c, 0x0000c22c, 0x0000c62c,
		       0x0000ca2c, 0x0000ce2c, 0x0000d22c, 0x0000d62c,
		       0x0000da2c, 0x0000de2c, 0x0000e22c, 0x0000e62c,
		       0x0000ea2c, 0x0000ee2c, 0x0000f22c, 0x0000f62c,
		       0x0000fa2c, 0x0000fe2c, 0x0001022c, 0x0001062c,
		       0x00010a2c, 0x00010e2c, 0x0001122c, 0x0001162c,
		       0x00011a2c, 0x00011e2c, 0x0001222c, 0x0001262c,
		       0x00012a2c, 0x00012e2c, 0x0001322c, 0x0001362c,
		       0x00013a2c, 0x00013e2c, 0x0001422c, 0x0001462c,
		       0x00014a2c, 0x00014e2c, 0x0001522c, 0x0001562c,
		       0x00015a2c, 0x00015e2c, 0x0001622c, 0x0001662c,
		       0x00016a2c, 0x00016e2c, 0x0001722c, 0x0001762c,
		       0x00017a2c, 0x00017e2c, 0x0001822c, 0x0001862c,
		       0x00018a2c, 0x00018e2c, 0x0001922c, 0x0001962c,
		       0x00019a2c, 0x00019e2c, 0x0001a22c, 0x0001a62c,
		       0x0001aa2c, 0x0001ae2c, 0x0001b22c, 0x0001b62c,
		       0x0001ba2c, 0x0001be2c, 0x0001c22c, 0x0001c62c,
		       0x0001ca2c, 0x0001ce2c, 0x0001d22c, 0x0001d62c,
		       0x0001da2c, 0x0001de2c, 0x0001e22c, 0x0001e62c,
		       0x0001ea2c, 0x0001ee2c, 0x0001f22c, 0x0001f62c,
		       0x0001fa2c, 0x0001fe2c, 0x0000012d, 0x0000052d,
		       0x0000092d, 0x00000d2d, 0x0000112d, 0x0000152d,
		       0x0000192d, 0x00001d2d, 0x0000212d, 0x0000252d,
		       0x0000292d, 0x00002d2d, 0x0000312d, 0x0000352d,
		       0x0000392d, 0x00003d2d, 0x0000412d, 0x0000452d,
		       0x0000492d, 0x00004d2d, 0x0000512d, 0x0000552d,
		       0x0000592d, 0x00005d2d, 0x0000612d, 0x0000652d,
		       0x0000692d, 0x00006d2d, 0x0000712d, 0x0000752d,
		       0x0000792d, 0x00007d2d, 0x0000812d, 0x0000852d,
		       0x0000892d, 0x00008d2d, 0x0000912d, 0x0000952d,
		       0x0000992d, 0x00009d2d, 0x0000a12d, 0x0000a52d,
		       0x0000a92d, 0x0000ad2d, 0x0000b12d, 0x0000b52d,
		       0x0000b92d, 0x0000bd2d, 0x0000c12d, 0x0000c52d,
		       0x0000c92d, 0x0000cd2d, 0x0000d12d, 0x0000d52d,
		       0x0000d92d, 0x0000dd2d, 0x0000e12d, 0x0000e52d,
		       0x0000e92d, 0x0000ed2d, 0x0000f12d, 0x0000f52d,
		       0x0000f92d, 0x0000fd2d, 0x0001012d, 0x0001052d,
		       0x0001092d, 0x00010d2d, 0x0001112d, 0x0001152d,
		       0x0001192d, 0x00011d2d, 0x0001212d, 0x0001252d,
		       0x0001292d, 0x00012d2d, 0x0001312d, 0x0001352d,
		       0x0001392d, 0x00013d2d, 0x0001412d, 0x0001452d,
		       0x0001492d, 0x00014d2d, 0x0001512d, 0x0001552d,
		       0x0001592d, 0x00015d2d, 0x0001612d, 0x0001652d,
		       0x0001692d, 0x00016d2d, 0x0001712d, 0x0001752d,
		       0x0001792d, 0x00017d2d, 0x0001812d, 0x0001852d,
		       0x0001892d, 0x00018d2d, 0x0001912d, 0x0001952d,
		       0x0001992d, 0x00019d2d, 0x0001a12d, 0x0001a52d,
		       0x0001a92d, 0x0001ad2d, 0x0001b12d, 0x0001b52d,
		       0x0001b92d, 0x0001bd2d, 0x0001c12d, 0x0001c52d,
		       0x0001c92d, 0x0001cd2d, 0x0001d12d, 0x0001d52d,
		       0x0001d92d, 0x0001dd2d, 0x0001e12d, 0x0001e52d,
		       0x0001e92d, 0x0001ed2d, 0x0001f12d, 0x0001f52d,
		       0x0001f92d, 0x0001fd2d, 0x0002012d, 0x0002052d,
		       0x0002092d, 0x00020d2d, 0x0002112d, 0x0002152d,
		       0x0002192d, 0x00021d2d, 0x0002212d, 0x0002252d,
		       0x0002292d, 0x00022d2d, 0x0002312d, 0x0002352d,
		       0x0002392d, 0x00023d2d, 0x0002412d, 0x0002452d,
		       0x0002492d, 0x00024d2d, 0x0002512d, 0x0002552d,
		       0x0002592d, 0x00025d2d, 0x0002612d, 0x0002652d,
		       0x0002692d, 0x00026d2d, 0x0002712d, 0x0002752d,
		       0x0002792d, 0x00027d2d, 0x0002812d, 0x0002852d,
		       0x0002892d, 0x00028d2d, 0x0002912d, 0x0002952d,
		       0x0002992d, 0x00029d2d, 0x0002a12d, 0x0002a52d,
		       0x0002a92d, 0x0002ad2d, 0x0002b12d, 0x0002b52d,
		       0x0002b92d, 0x0002bd2d, 0x0002c12d, 0x0002c52d,
		       0x0002c92d, 0x0002cd2d, 0x0002d12d, 0x0002d52d,
		       0x0002d92d, 0x0002dd2d, 0x0002e12d, 0x0002e52d,
		       0x0002e92d, 0x0002ed2d, 0x0002f12d, 0x0002f52d,
		       0x0002f92d, 0x0002fd2d, 0x0003012d, 0x0003052d,
		       0x0003092d, 0x00030d2d, 0x0003112d, 0x0003152d,
		       0x0003192d, 0x00031d2d, 0x0003212d, 0x0003252d,
		       0x0003292d, 0x00032d2d, 0x0003312d, 0x0003352d,
		       0x0003392d, 0x00033d2d, 0x0003412d, 0x0003452d,
		       0x0003492d, 0x00034d2d, 0x0003512d, 0x0003552d,
		       0x0003592d, 0x00035d2d, 0x0003612d, 0x0003652d,
		       0x0003692d, 0x00036d2d, 0x0003712d, 0x0003752d,
		       0x0003792d, 0x00037d2d, 0x0003812d, 0x0003852d,
		       0x0003892d, 0x00038d2d, 0x0003912d, 0x0003952d,
		       0x0003992d, 0x00039d2d, 0x0003a12d, 0x0003a52d,
		       0x0003a92d, 0x0003ad2d, 0x0003b12d, 0x0003b52d,
		       0x0003b92d, 0x0003bd2d, 0x0003c12d, 0x0003c52d,
		       0x0003c92d, 0x0003cd2d, 0x0003d12d, 0x0003d52d,
		       0x0003d92d, 0x0003dd2d, 0x0003e12d, 0x0003e52d,
		       0x0003e92d, 0x0003ed2d, 0x0003f12d, 0x0003f52d,
		       0x0003f92d, 0x0003fd2d, 0x0000032d, 0x0000072d,
		       0x00000b2d, 0x00000f2d, 0x0000132d, 0x0000172d,
		       0x00001b2d, 0x00001f2d, 0x0000232d, 0x0000272d,
		       0x00002b2d, 0x00002f2d, 0x0000332d, 0x0000372d,
		       0x00003b2d, 0x00003f2d, 0x0000432d, 0x0000472d,
		       0x00004b2d, 0x00004f2d, 0x0000532d, 0x0000572d,
		       0x00005b2d, 0x00005f2d, 0x0000632d, 0x0000672d,
		       0x00006b2d, 0x00006f2d, 0x0000732d, 0x0000772d,
		       0x00007b2d, 0x00007f2d, 0x0000832d, 0x0000872d,
		       0x00008b2d, 0x00008f2d, 0x0000932d, 0x0000972d,
		       0x00009b2d, 0x00009f2d, 0x0000a32d, 0x0000a72d,
		       0x0000ab2d, 0x0000af2d, 0x0000b32d, 0x0000b72d,
		       0x0000bb2d, 0x0000bf2d, 0x0000c32d, 0x0000c72d,
		       0x0000cb2d, 0x0000cf2d, 0x0000d32d, 0x0000d72d,
		       0x0000db2d, 0x0000df2d, 0x0000e32d, 0x0000e72d,
		       0x0000eb2d, 0x0000ef2d, 0x0000f32d, 0x0000f72d,
		       0x0000fb2d, 0x0000ff2d, 0x0001032d, 0x0001072d,
		       0x00010b2d, 0x00010f2d, 0x0001132d, 0x0001172d,
		       0x00011b2d, 0x00011f2d, 0x0001232d, 0x0001272d,
		       0x00012b2d, 0x00012f2d, 0x0001332d, 0x0001372d,
		       0x00013b2d, 0x00013f2d, 0x0001432d, 0x0001472d,
		       0x00014b2d, 0x00014f2d, 0x0001532d, 0x0001572d,
		       0x00015b2d, 0x00015f2d, 0x0001632d, 0x0001672d,
		       0x00016b2d, 0x00016f2d, 0x0001732d, 0x0001772d,
		       0x00017b2d, 0x00017f2d, 0x0001832d, 0x0001872d,
		       0x00018b2d, 0x00018f2d, 0x0001932d, 0x0001972d,
		       0x00019b2d, 0x00019f2d, 0x0001a32d, 0x0001a72d,
		       0x0001ab2d, 0x0001af2d, 0x0001b32d, 0x0001b72d,
		       0x0001bb2d, 0x0001bf2d, 0x0001c32d, 0x0001c72d,
		       0x0001cb2d, 0x0001cf2d, 0x0001d32d, 0x0001d72d,
		       0x0001db2d, 0x0001df2d, 0x0001e32d, 0x0001e72d,
		       0x0001eb2d, 0x0001ef2d, 0x0001f32d, 0x0001f72d,
		       0x0001fb2d, 0x0001ff2d, 0x0002032d, 0x0002072d,
		       0x00020b2d, 0x00020f2d, 0x0002132d, 0x0002172d,
		       0x00021b2d, 0x00021f2d, 0x0002232d, 0x0002272d,
		       0x00022b2d, 0x00022f2d, 0x0002332d, 0x0002372d,
		       0x00023b2d, 0x00023f2d, 0x0002432d, 0x0002472d,
		       0x00024b2d, 0x00024f2d, 0x0002532d, 0x0002572d,
		       0x00025b2d, 0x00025f2d, 0x0002632d, 0x0002672d,
		       0x00026b2d, 0x00026f2d, 0x0002732d, 0x0002772d,
		       0x00027b2d, 0x00027f2d, 0x0002832d, 0x0002872d,
		       0x00028b2d, 0x00028f2d, 0x0002932d, 0x0002972d,
		       0x00029b2d, 0x00029f2d, 0x0002a32d, 0x0002a72d,
		       0x0002ab2d, 0x0002af2d, 0x0002b32d, 0x0002b72d,
		       0x0002bb2d, 0x0002bf2d, 0x0002c32d, 0x0002c72d,
		       0x0002cb2d, 0x0002cf2d, 0x0002d32d, 0x0002d72d,
		       0x0002db2d, 0x0002df2d, 0x0002e32d, 0x0002e72d,
		       0x0002eb2d, 0x0002ef2d, 0x0002f32d, 0x0002f72d,
		       0x0002fb2d, 0x0002ff2d, 0x0003032d, 0x0003072d,
		       0x00030b2d, 0x00030f2d, 0x0003132d, 0x0003172d,
		       0x00031b2d, 0x00031f2d, 0x0003232d, 0x0003272d,
		       0x00032b2d, 0x00032f2d, 0x0003332d, 0x0003372d,
		       0x00033b2d, 0x00033f2d, 0x0003432d, 0x0003472d,
		       0x00034b2d, 0x00034f2d, 0x0003532d, 0x0003572d,
		       0x00035b2d, 0x00035f2d, 0x0003632d, 0x0003672d,
		       0x00036b2d, 0x00036f2d, 0x0003732d, 0x0003772d,
		       0x00037b2d, 0x00037f2d, 0x0003832d, 0x0003872d,
		       0x00038b2d, 0x00038f2d, 0x0003932d, 0x0003972d,
		       0x00039b2d, 0x00039f2d, 0x0003a32d, 0x0003a72d,
		       0x0003ab2d, 0x0003af2d, 0x0003b32d, 0x0003b72d,
		       0x0003bb2d, 0x0003bf2d, 0x0003c32d, 0x0003c72d,
		       0x0003cb2d, 0x0003cf2d, 0x0003d32d, 0x0003d72d,
		       0x0003db2d, 0x0003df2d, 0x0003e32d, 0x0003e72d,
		       0x0003eb2d, 0x0003ef2d, 0x0003f32d, 0x0003f72d,
		       0x0003fb2d, 0x0003ff2d, 0x000000ae, 0x000004ae,
		       0x000008ae, 0x00000cae, 0x000010ae, 0x000014ae,
		       0x000018ae, 0x00001cae, 0x000020ae, 0x000024ae,
		       0x000028ae, 0x00002cae, 0x000030ae, 0x000034ae,
		       0x000038ae, 0x00003cae, 0x000040ae, 0x000044ae,
		       0x000048ae, 0x00004cae, 0x000050ae, 0x000054ae,
		       0x000058ae, 0x00005cae, 0x000060ae, 0x000064ae,
		       0x000068ae, 0x00006cae, 0x000070ae, 0x000074ae,
		       0x000078ae, 0x00007cae, 0x000080ae, 0x000084ae,
		       0x000088ae, 0x00008cae, 0x000090ae, 0x000094ae,
		       0x000098ae, 0x00009cae, 0x0000a0ae, 0x0000a4ae,
		       0x0000a8ae, 0x0000acae, 0x0000b0ae, 0x0000b4ae,
		       0x0000b8ae, 0x0000bcae, 0x0000c0ae, 0x0000c4ae,
		       0x0000c8ae, 0x0000ccae, 0x0000d0ae, 0x0000d4ae,
		       0x0000d8ae, 0x0000dcae, 0x0000e0ae, 0x0000e4ae,
		       0x0000e8ae, 0x0000ecae, 0x0000f0ae, 0x0000f4ae,
		       0x0000f8ae, 0x0000fcae, 0x000100ae, 0x000104ae,
		       0x000108ae, 0x00010cae, 0x000110ae, 0x000114ae,
		       0x000118ae, 0x00011cae, 0x000120ae, 0x000124ae,
		       0x000128ae, 0x00012cae, 0x000130ae, 0x000134ae,
		       0x000138ae, 0x00013cae, 0x000140ae, 0x000144ae,
		       0x000148ae, 0x00014cae, 0x000150ae, 0x000154ae,
		       0x000158ae, 0x00015cae, 0x000160ae, 0x000164ae,
		       0x000168ae, 0x00016cae, 0x000170ae, 0x000174ae,
		       0x000178ae, 0x00017cae, 0x000180ae, 0x000184ae,
		       0x000188ae, 0x00018cae, 0x000190ae, 0x000194ae,
		       0x000198ae, 0x00019cae, 0x0001a0ae, 0x0001a4ae,
		       0x0001a8ae, 0x0001acae, 0x0001b0ae, 0x0001b4ae,
		       0x0001b8ae, 0x0001bcae, 0x0001c0ae, 0x0001c4ae,
		       0x0001c8ae, 0x0001ccae, 0x0001d0ae, 0x0001d4ae,
		       0x0001d8ae, 0x0001dcae, 0x0001e0ae, 0x0001e4ae,
		       0x0001e8ae, 0x0001ecae, 0x0001f0ae, 0x0001f4ae,
		       0x0001f8ae, 0x0001fcae, 0x000200ae, 0x000204ae,
		       0x000208ae, 0x00020cae, 0x000210ae, 0x000214ae,
		       0x000218ae, 0x00021cae, 0x000220ae, 0x000224ae,
		       0x000228ae, 0x00022cae, 0x000230ae, 0x000234ae,
		       0x000238ae, 0x00023cae, 0x000240ae, 0x000244ae,
		       0x000248ae, 0x00024cae, 0x000250ae, 0x000254ae,
		       0x000258ae, 0x00025cae, 0x000260ae, 0x000264ae,
		       0x000268ae, 0x00026cae, 0x000270ae, 0x000274ae,
		       0x000278ae, 0x00027cae, 0x000280ae, 0x000284ae,
		       0x000288ae, 0x00028cae, 0x000290ae, 0x000294ae,
		       0x000298ae, 0x00029cae, 0x0002a0ae, 0x0002a4ae,
		       0x0002a8ae, 0x0002acae, 0x0002b0ae, 0x0002b4ae,
		       0x0002b8ae, 0x0002bcae, 0x0002c0ae, 0x0002c4ae,
		       0x0002c8ae, 0x0002ccae, 0x0002d0ae, 0x0002d4ae,
		       0x0002d8ae, 0x0002dcae, 0x0002e0ae, 0x0002e4ae,
		       0x0002e8ae, 0x0002ecae, 0x0002f0ae, 0x0002f4ae,
		       0x0002f8ae, 0x0002fcae, 0x000300ae, 0x000304ae,
		       0x000308ae, 0x00030cae, 0x000310ae, 0x000314ae,
		       0x000318ae, 0x00031cae, 0x000320ae, 0x000324ae,
		       0x000328ae, 0x00032cae, 0x000330ae, 0x000334ae,
		       0x000338ae, 0x00033cae, 0x000340ae, 0x000344ae,
		       0x000348ae, 0x00034cae, 0x000350ae, 0x000354ae,
		       0x000358ae, 0x00035cae, 0x000360ae, 0x000364ae,
		       0x000368ae, 0x00036cae, 0x000370ae, 0x000374ae,
		       0x000378ae, 0x00037cae, 0x000380ae, 0x000384ae,
		       0x000388ae, 0x00038cae, 0x000390ae, 0x000394ae,
		       0x000398ae, 0x00039cae, 0x0003a0ae, 0x0003a4ae,
		       0x0003a8ae, 0x0003acae, 0x0003b0ae, 0x0003b4ae,
		       0x0003b8ae, 0x0003bcae, 0x0003c0ae, 0x0003c4ae,
		       0x0003c8ae, 0x0003ccae, 0x0003d0ae, 0x0003d4ae,
		       0x0003d8ae, 0x0003dcae, 0x0003e0ae, 0x0003e4ae,
		       0x0003e8ae, 0x0003ecae, 0x0003f0ae, 0x0003f4ae,
		       0x0003f8ae, 0x0003fcae, 0x000400ae, 0x000404ae,
		       0x000408ae, 0x00040cae, 0x000410ae, 0x000414ae,
		       0x000418ae, 0x00041cae, 0x000420ae, 0x000424ae,
		       0x000428ae, 0x00042cae, 0x000430ae, 0x000434ae,
		       0x000438ae, 0x00043cae, 0x000440ae, 0x000444ae,
		       0x000448ae, 0x00044cae, 0x000450ae, 0x000454ae,
		       0x000458ae, 0x00045cae, 0x000460ae, 0x000464ae,
		       0x000468ae, 0x00046cae, 0x000470ae, 0x000474ae,
		       0x000478ae, 0x00047cae, 0x000480ae, 0x000484ae,
		       0x000488ae, 0x00048cae, 0x000490ae, 0x000494ae,
		       0x000498ae, 0x00049cae, 0x0004a0ae, 0x0004a4ae,
		       0x0004a8ae, 0x0004acae, 0x0004b0ae, 0x0004b4ae,
		       0x0004b8ae, 0x0004bcae, 0x0004c0ae, 0x0004c4ae,
		       0x0004c8ae, 0x0004ccae, 0x0004d0ae, 0x0004d4ae,
		       0x0004d8ae, 0x0004dcae, 0x0004e0ae, 0x0004e4ae,
		       0x0004e8ae, 0x0004ecae, 0x0004f0ae, 0x0004f4ae,
		       0x0004f8ae, 0x0004fcae, 0x000500ae, 0x000504ae,
		       0x000508ae, 0x00050cae, 0x000510ae, 0x000514ae,
		       0x000518ae, 0x00051cae, 0x000520ae, 0x000524ae,
		       0x000528ae, 0x00052cae, 0x000530ae, 0x000534ae,
		       0x000538ae, 0x00053cae, 0x000540ae, 0x000544ae,
		       0x000548ae, 0x00054cae, 0x000550ae, 0x000554ae,
		       0x000558ae, 0x00055cae, 0x000560ae, 0x000564ae,
		       0x000568ae, 0x00056cae, 0x000570ae, 0x000574ae,
		       0x000578ae, 0x00057cae, 0x000580ae, 0x000584ae,
		       0x000588ae, 0x00058cae, 0x000590ae, 0x000594ae,
		       0x000598ae, 0x00059cae, 0x0005a0ae, 0x0005a4ae,
		       0x0005a8ae, 0x0005acae, 0x0005b0ae, 0x0005b4ae,
		       0x0005b8ae, 0x0005bcae, 0x0005c0ae, 0x0005c4ae,
		       0x0005c8ae, 0x0005ccae, 0x0005d0ae, 0x0005d4ae,
		       0x0005d8ae, 0x0005dcae, 0x0005e0ae, 0x0005e4ae,
		       0x0005e8ae, 0x0005ecae, 0x0005f0ae, 0x0005f4ae,
		       0x0005f8ae, 0x0005fcae, 0x000600ae, 0x000604ae,
		       0x000608ae, 0x00060cae, 0x000610ae, 0x000614ae,
		       0x000618ae, 0x00061cae, 0x000620ae, 0x000624ae,
		       0x000628ae, 0x00062cae, 0x000630ae, 0x000634ae,
		       0x000638ae, 0x00063cae, 0x000640ae, 0x000644ae,
		       0x000648ae, 0x00064cae, 0x000650ae, 0x000654ae,
		       0x000658ae, 0x00065cae, 0x000660ae, 0x000664ae,
		       0x000668ae, 0x00066cae, 0x000670ae, 0x000674ae,
		       0x000678ae, 0x00067cae, 0x000680ae, 0x000684ae,
		       0x000688ae, 0x00068cae, 0x000690ae, 0x000694ae,
		       0x000698ae, 0x00069cae, 0x0006a0ae, 0x0006a4ae,
		       0x0006a8ae, 0x0006acae, 0x0006b0ae, 0x0006b4ae,
		       0x0006b8ae, 0x0006bcae, 0x0006c0ae, 0x0006c4ae,
		       0x0006c8ae, 0x0006ccae, 0x0006d0ae, 0x0006d4ae,
		       0x0006d8ae, 0x0006dcae, 0x0006e0ae, 0x0006e4ae,
		       0x0006e8ae, 0x0006ecae, 0x0006f0ae, 0x0006f4ae,
		       0x0006f8ae, 0x0006fcae, 0x000700ae, 0x000704ae,
		       0x000708ae, 0x00070cae, 0x000710ae, 0x000714ae,
		       0x000718ae, 0x00071cae, 0x000720ae, 0x000724ae,
		       0x000728ae, 0x00072cae, 0x000730ae, 0x000734ae,
		       0x000738ae, 0x00073cae, 0x000740ae, 0x000744ae,
		       0x000748ae, 0x00074cae, 0x000750ae, 0x000754ae,
		       0x000758ae, 0x00075cae, 0x000760ae, 0x000764ae,
		       0x000768ae, 0x00076cae, 0x000770ae, 0x000774ae,
		       0x000778ae, 0x00077cae, 0x000780ae, 0x000784ae,
		       0x000788ae, 0x00078cae, 0x000790ae, 0x000794ae,
		       0x000798ae, 0x00079cae, 0x0007a0ae, 0x0007a4ae,
		       0x0007a8ae, 0x0007acae, 0x0007b0ae, 0x0007b4ae,
		       0x0007b8ae, 0x0007bcae, 0x0007c0ae, 0x0007c4ae,
		       0x0007c8ae, 0x0007ccae, 0x0007d0ae, 0x0007d4ae,
		       0x0007d8ae, 0x0007dcae, 0x0007e0ae, 0x0007e4ae,
		       0x0007e8ae, 0x0007ecae, 0x0007f0ae, 0x0007f4ae,
		       0x0007f8ae, 0x0007fcae, 0x000002ae, 0x000006ae,
		       0x00000aae, 0x00000eae, 0x000012ae, 0x000016ae,
		       0x00001aae, 0x00001eae, 0x000022ae, 0x000026ae,
		       0x00002aae, 0x00002eae, 0x000032ae, 0x000036ae,
		       0x00003aae, 0x00003eae, 0x000042ae, 0x000046ae,
		       0x00004aae, 0x00004eae, 0x000052ae, 0x000056ae,
		       0x00005aae, 0x00005eae, 0x000062ae, 0x000066ae,
		       0x00006aae, 0x00006eae, 0x000072ae, 0x000076ae,
		       0x00007aae, 0x00007eae, 0x000082ae, 0x000086ae,
		       0x00008aae, 0x00008eae, 0x000092ae, 0x000096ae,
		       0x00009aae, 0x00009eae, 0x0000a2ae, 0x0000a6ae,
		       0x0000aaae, 0x0000aeae, 0x0000b2ae, 0x0000b6ae,
		       0x0000baae, 0x0000beae, 0x0000c2ae, 0x0000c6ae,
		       0x0000caae, 0x0000ceae, 0x0000d2ae, 0x0000d6ae,
		       0x0000daae, 0x0000deae, 0x0000e2ae, 0x0000e6ae,
		       0x0000eaae, 0x0000eeae, 0x0000f2ae, 0x0000f6ae,
		       0x0000faae, 0x0000feae, 0x000102ae, 0x000106ae,
		       0x00010aae, 0x00010eae, 0x000112ae, 0x000116ae,
		       0x00011aae, 0x00011eae, 0x000122ae, 0x000126ae,
		       0x00012aae, 0x00012eae, 0x000132ae, 0x000136ae,
		       0x00013aae, 0x00013eae, 0x000142ae, 0x000146ae,
		       0x00014aae, 0x00014eae, 0x000152ae, 0x000156ae,
		       0x00015aae, 0x00015eae, 0x000162ae, 0x000166ae,
		       0x00016aae, 0x00016eae, 0x000172ae, 0x000176ae,
		       0x00017aae, 0x00017eae, 0x000182ae, 0x000186ae,
		       0x00018aae, 0x00018eae, 0x000192ae, 0x000196ae,
		       0x00019aae, 0x00019eae, 0x0001a2ae, 0x0001a6ae,
		       0x0001aaae, 0x0001aeae, 0x0001b2ae, 0x0001b6ae,
		       0x0001baae, 0x0001beae, 0x0001c2ae, 0x0001c6ae,
		       0x0001caae, 0x0001ceae, 0x0001d2ae, 0x0001d6ae,
		       0x0001daae, 0x0001deae, 0x0001e2ae, 0x0001e6ae,
		       0x0001eaae, 0x0001eeae, 0x0001f2ae, 0x0001f6ae,
		       0x0001faae, 0x0001feae, 0x000202ae, 0x000206ae,
		       0x00020aae, 0x00020eae, 0x000212ae, 0x000216ae,
		       0x00021aae, 0x00021eae, 0x000222ae, 0x000226ae,
		       0x00022aae, 0x00022eae, 0x000232ae, 0x000236ae,
		       0x00023aae, 0x00023eae, 0x000242ae, 0x000246ae,
		       0x00024aae, 0x00024eae, 0x000252ae, 0x000256ae,
		       0x00025aae, 0x00025eae, 0x000262ae, 0x000266ae,
		       0x00026aae, 0x00026eae, 0x000272ae, 0x000276ae,
		       0x00027aae, 0x00027eae, 0x000282ae, 0x000286ae,
		       0x00028aae, 0x00028eae, 0x000292ae, 0x000296ae,
		       0x00029aae, 0x00029eae, 0x0002a2ae, 0x0002a6ae,
		       0x0002aaae, 0x0002aeae, 0x0002b2ae, 0x0002b6ae,
		       0x0002baae, 0x0002beae, 0x0002c2ae, 0x0002c6ae,
		       0x0002caae, 0x0002ceae, 0x0002d2ae, 0x0002d6ae,
		       0x0002daae, 0x0002deae, 0x0002e2ae, 0x0002e6ae,
		       0x0002eaae, 0x0002eeae, 0x0002f2ae, 0x0002f6ae,
		       0x0002faae, 0x0002feae, 0x000302ae, 0x000306ae,
		       0x00030aae, 0x00030eae, 0x000312ae, 0x000316ae,
		       0x00031aae, 0x00031eae, 0x000322ae, 0x000326ae,
		       0x00032aae, 0x00032eae, 0x000332ae, 0x000336ae,
		       0x00033aae, 0x00033eae, 0x000342ae, 0x000346ae,
		       0x00034aae, 0x00034eae, 0x000352ae, 0x000356ae,
		       0x00035aae, 0x00035eae, 0x000362ae, 0x000366ae,
		       0x00036aae, 0x00036eae, 0x000372ae, 0x000376ae,
		       0x00037aae, 0x00037eae, 0x000382ae, 0x000386ae,
		       0x00038aae, 0x00038eae, 0x000392ae, 0x000396ae,
		       0x00039aae, 0x00039eae, 0x0003a2ae, 0x0003a6ae,
		       0x0003aaae, 0x0003aeae, 0x0003b2ae, 0x0003b6ae,
		       0x0003baae, 0x0003beae, 0x0003c2ae, 0x0003c6ae,
		       0x0003caae, 0x0003ceae, 0x0003d2ae, 0x0003d6ae,
		       0x0003daae, 0x0003deae, 0x0003e2ae, 0x0003e6ae,
		       0x0003eaae, 0x0003eeae, 0x0003f2ae, 0x0003f6ae,
		       0x0003faae, 0x0003feae, 0x000402ae, 0x000406ae,
		       0x00040aae, 0x00040eae, 0x000412ae, 0x000416ae,
		       0x00041aae, 0x00041eae, 0x000422ae, 0x000426ae,
		       0x00042aae, 0x00042eae, 0x000432ae, 0x000436ae,
		       0x00043aae, 0x00043eae, 0x000442ae, 0x000446ae,
		       0x00044aae, 0x00044eae, 0x000452ae, 0x000456ae,
		       0x00045aae, 0x00045eae, 0x000462ae, 0x000466ae,
		       0x00046aae, 0x00046eae, 0x000472ae, 0x000476ae,
		       0x00047aae, 0x00047eae, 0x000482ae, 0x000486ae,
		       0x00048aae, 0x00048eae, 0x000492ae, 0x000496ae,
		       0x00049aae, 0x00049eae, 0x0004a2ae, 0x0004a6ae,
		       0x0004aaae, 0x0004aeae, 0x0004b2ae, 0x0004b6ae,
		       0x0004baae, 0x0004beae, 0x0004c2ae, 0x0004c6ae,
		       0x0004caae, 0x0004ceae, 0x0004d2ae, 0x0004d6ae,
		       0x0004daae, 0x0004deae, 0x0004e2ae, 0x0004e6ae,
		       0x0004eaae, 0x0004eeae, 0x0004f2ae, 0x0004f6ae,
		       0x0004faae, 0x0004feae, 0x000502ae, 0x000506ae,
		       0x00050aae, 0x00050eae, 0x000512ae, 0x000516ae,
		       0x00051aae, 0x00051eae, 0x000522ae, 0x000526ae,
		       0x00052aae, 0x00052eae, 0x000532ae, 0x000536ae,
		       0x00053aae, 0x00053eae, 0x000542ae, 0x000546ae,
		       0x00054aae, 0x00054eae, 0x000552ae, 0x000556ae,
		       0x00055aae, 0x00055eae, 0x000562ae, 0x000566ae,
		       0x00056aae, 0x00056eae, 0x000572ae, 0x000576ae,
		       0x00057aae, 0x00057eae, 0x000582ae, 0x000586ae,
		       0x00058aae, 0x00058eae, 0x000592ae, 0x000596ae,
		       0x00059aae, 0x00059eae, 0x0005a2ae, 0x0005a6ae,
		       0x0005aaae, 0x0005aeae, 0x0005b2ae, 0x0005b6ae,
		       0x0005baae, 0x0005beae, 0x0005c2ae, 0x0005c6ae,
		       0x0005caae, 0x0005ceae, 0x0005d2ae, 0x0005d6ae,
		       0x0005daae, 0x0005deae, 0x0005e2ae, 0x0005e6ae,
		       0x0005eaae, 0x0005eeae, 0x0005f2ae, 0x0005f6ae,
		       0x0005faae, 0x0005feae, 0x000602ae, 0x000606ae,
		       0x00060aae, 0x00060eae, 0x000612ae, 0x000616ae,
		       0x00061aae, 0x00061eae, 0x000622ae, 0x000626ae,
		       0x00062aae, 0x00062eae, 0x000632ae, 0x000636ae,
		       0x00063aae, 0x00063eae, 0x000642ae, 0x000646ae,
		       0x00064aae, 0x00064eae, 0x000652ae, 0x000656ae,
		       0x00065aae, 0x00065eae, 0x000662ae, 0x000666ae,
		       0x00066aae, 0x00066eae, 0x000672ae, 0x000676ae,
		       0x00067aae, 0x00067eae, 0x000682ae, 0x000686ae,
		       0x00068aae, 0x00068eae, 0x000692ae, 0x000696ae,
		       0x00069aae, 0x00069eae, 0x0006a2ae, 0x0006a6ae,
		       0x0006aaae, 0x0006aeae, 0x0006b2ae, 0x0006b6ae,
		       0x0006baae, 0x0006beae, 0x0006c2ae, 0x0006c6ae,
		       0x0006caae, 0x0006ceae, 0x0006d2ae, 0x0006d6ae,
		       0x0006daae, 0x0006deae, 0x0006e2ae, 0x0006e6ae,
		       0x0006eaae, 0x0006eeae, 0x0006f2ae, 0x0006f6ae,
		       0x0006faae, 0x0006feae, 0x000702ae, 0x000706ae,
		       0x00070aae, 0x00070eae, 0x000712ae, 0x000716ae,
		       0x00071aae, 0x00071eae, 0x000722ae, 0x000726ae,
		       0x00072aae, 0x00072eae, 0x000732ae, 0x000736ae,
		       0x00073aae, 0x00073eae, 0x000742ae, 0x000746ae,
		       0x00074aae, 0x00074eae, 0x000752ae, 0x000756ae,
		       0x00075aae, 0x00075eae, 0x000762ae, 0x000766ae,
		       0x00076aae, 0x00076eae, 0x000772ae, 0x000776ae,
		       0x00077aae, 0x00077eae, 0x000782ae, 0x000786ae,
		       0x00078aae, 0x00078eae, 0x000792ae, 0x000796ae,
		       0x00079aae, 0x00079eae, 0x0007a2ae, 0x0007a6ae,
		       0x0007aaae, 0x0007aeae, 0x0007b2ae, 0x0007b6ae,
		       0x0007baae, 0x0007beae, 0x0007c2ae, 0x0007c6ae,
		       0x0007caae, 0x0007ceae, 0x0007d2ae, 0x0007d6ae,
		       0x0007daae, 0x0007deae, 0x0007e2ae, 0x0007e6ae,
		       0x0007eaae, 0x0007eeae, 0x0007f2ae, 0x0007f6ae,
		       0x0007faae, 0x0007feae, 0x000001af, 0x000005af,
		       0x000009af, 0x00000daf, 0x000011af, 0x000015af,
		       0x000019af, 0x00001daf, 0x000021af, 0x000025af,
		       0x000029af, 0x00002daf, 0x000031af, 0x000035af,
		       0x000039af, 0x00003daf, 0x000041af, 0x000045af,
		       0x000049af, 0x00004daf, 0x000051af, 0x000055af,
		       0x000059af, 0x00005daf, 0x000061af, 0x000065af,
		       0x000069af, 0x00006daf, 0x000071af, 0x000075af,
		       0x000079af, 0x00007daf, 0x000081af, 0x000085af,
		       0x000089af, 0x00008daf, 0x000091af, 0x000095af,
		       0x000099af, 0x00009daf, 0x0000a1af, 0x0000a5af,
		       0x0000a9af, 0x0000adaf, 0x0000b1af, 0x0000b5af,
		       0x0000b9af, 0x0000bdaf, 0x0000c1af, 0x0000c5af,
		       0x0000c9af, 0x0000cdaf, 0x0000d1af, 0x0000d5af,
		       0x0000d9af, 0x0000ddaf, 0x0000e1af, 0x0000e5af,
		       0x0000e9af, 0x0000edaf, 0x0000f1af, 0x0000f5af,
		       0x0000f9af, 0x0000fdaf, 0x000101af, 0x000105af,
		       0x000109af, 0x00010daf, 0x000111af, 0x000115af,
		       0x000119af, 0x00011daf, 0x000121af, 0x000125af,
		       0x000129af, 0x00012daf, 0x000131af, 0x000135af,
		       0x000139af, 0x00013daf, 0x000141af, 0x000145af,
		       0x000149af, 0x00014daf, 0x000151af, 0x000155af,
		       0x000159af, 0x00015daf, 0x000161af, 0x000165af,
		       0x000169af, 0x00016daf, 0x000171af, 0x000175af,
		       0x000179af, 0x00017daf, 0x000181af, 0x000185af,
		       0x000189af, 0x00018daf, 0x000191af, 0x000195af,
		       0x000199af, 0x00019daf, 0x0001a1af, 0x0001a5af,
		       0x0001a9af, 0x0001adaf, 0x0001b1af, 0x0001b5af,
		       0x0001b9af, 0x0001bdaf, 0x0001c1af, 0x0001c5af,
		       0x0001c9af, 0x0001cdaf, 0x0001d1af, 0x0001d5af,
		       0x0001d9af, 0x0001ddaf, 0x0001e1af, 0x0001e5af,
		       0x0001e9af, 0x0001edaf, 0x0001f1af, 0x0001f5af,
		       0x0001f9af, 0x0001fdaf, 0x000201af, 0x000205af,
		       0x000209af, 0x00020daf, 0x000211af, 0x000215af,
		       0x000219af, 0x00021daf, 0x000221af, 0x000225af,
		       0x000229af, 0x00022daf, 0x000231af, 0x000235af,
		       0x000239af, 0x00023daf, 0x000241af, 0x000245af,
		       0x000249af, 0x00024daf, 0x000251af, 0x000255af,
		       0x000259af, 0x00025daf, 0x000261af, 0x000265af,
		       0x000269af, 0x00026daf, 0x000271af, 0x000275af,
		       0x000279af, 0x00027daf, 0x000281af, 0x000285af,
		       0x000289af, 0x00028daf, 0x000291af, 0x000295af,
		       0x000299af, 0x00029daf, 0x0002a1af, 0x0002a5af,
		       0x0002a9af, 0x0002adaf, 0x0002b1af, 0x0002b5af,
		       0x0002b9af, 0x0002bdaf, 0x0002c1af, 0x0002c5af,
		       0x0002c9af, 0x0002cdaf, 0x0002d1af, 0x0002d5af,
		       0x0002d9af, 0x0002ddaf, 0x0002e1af, 0x0002e5af,
		       0x0002e9af, 0x0002edaf, 0x0002f1af, 0x0002f5af,
		       0x0002f9af, 0x0002fdaf, 0x000301af, 0x000305af,
		       0x000309af, 0x00030daf, 0x000311af, 0x000315af,
		       0x000319af, 0x00031daf, 0x000321af, 0x000325af,
		       0x000329af, 0x00032daf, 0x000331af, 0x000335af,
		       0x000339af, 0x00033daf, 0x000341af, 0x000345af,
		       0x000349af, 0x00034daf, 0x000351af, 0x000355af,
		       0x000359af, 0x00035daf, 0x000361af, 0x000365af,
		       0x000369af, 0x00036daf, 0x000371af, 0x000375af,
		       0x000379af, 0x00037daf, 0x000381af, 0x000385af,
		       0x000389af, 0x00038daf, 0x000391af, 0x000395af,
		       0x000399af, 0x00039daf, 0x0003a1af, 0x0003a5af,
		       0x0003a9af, 0x0003adaf, 0x0003b1af, 0x0003b5af,
		       0x0003b9af, 0x0003bdaf, 0x0003c1af, 0x0003c5af,
		       0x0003c9af, 0x0003cdaf, 0x0003d1af, 0x0003d5af,
		       0x0003d9af, 0x0003ddaf, 0x0003e1af, 0x0003e5af,
		       0x0003e9af, 0x0003edaf, 0x0003f1af, 0x0003f5af,
		       0x0003f9af, 0x0003fdaf, 0x000401af, 0x000405af,
		       0x000409af, 0x00040daf, 0x000411af, 0x000415af,
		       0x000419af, 0x00041daf, 0x000421af, 0x000425af,
		       0x000429af, 0x00042daf, 0x000431af, 0x000435af,
		       0x000439af, 0x00043daf, 0x000441af, 0x000445af,
		       0x000449af, 0x00044daf, 0x000451af, 0x000455af,
		       0x000459af, 0x00045daf, 0x000461af, 0x000465af,
		       0x000469af, 0x00046daf, 0x000471af, 0x000475af,
		       0x000479af, 0x00047daf, 0x000481af, 0x000485af,
		       0x000489af, 0x00048daf, 0x000491af, 0x000495af,
		       0x000499af, 0x00049daf, 0x0004a1af, 0x0004a5af,
		       0x0004a9af, 0x0004adaf, 0x0004b1af, 0x0004b5af,
		       0x0004b9af, 0x0004bdaf, 0x0004c1af, 0x0004c5af,
		       0x0004c9af, 0x0004cdaf, 0x0004d1af, 0x0004d5af,
		       0x0004d9af, 0x0004ddaf, 0x0004e1af, 0x0004e5af,
		       0x0004e9af, 0x0004edaf, 0x0004f1af, 0x0004f5af,
		       0x0004f9af, 0x0004fdaf, 0x000501af, 0x000505af,
		       0x000509af, 0x00050daf, 0x000511af, 0x000515af,
		       0x000519af, 0x00051daf, 0x000521af, 0x000525af,
		       0x000529af, 0x00052daf, 0x000531af, 0x000535af,
		       0x000539af, 0x00053daf, 0x000541af, 0x000545af,
		       0x000549af, 0x00054daf, 0x000551af, 0x000555af,
		       0x000559af, 0x00055daf, 0x000561af, 0x000565af,
		       0x000569af, 0x00056daf, 0x000571af, 0x000575af,
		       0x000579af, 0x00057daf, 0x000581af, 0x000585af,
		       0x000589af, 0x00058daf, 0x000591af, 0x000595af,
		       0x000599af, 0x00059daf, 0x0005a1af, 0x0005a5af,
		       0x0005a9af, 0x0005adaf, 0x0005b1af, 0x0005b5af,
		       0x0005b9af, 0x0005bdaf, 0x0005c1af, 0x0005c5af,
		       0x0005c9af, 0x0005cdaf, 0x0005d1af, 0x0005d5af,
		       0x0005d9af, 0x0005ddaf, 0x0005e1af, 0x0005e5af,
		       0x0005e9af, 0x0005edaf, 0x0005f1af, 0x0005f5af,
		       0x0005f9af, 0x0005fdaf, 0x000601af, 0x000605af,
		       0x000609af, 0x00060daf, 0x000611af, 0x000615af,
		       0x000619af, 0x00061daf, 0x000621af, 0x000625af,
		       0x000629af, 0x00062daf, 0x000631af, 0x000635af,
		       0x000639af, 0x00063daf, 0x000641af, 0x000645af,
		       0x000649af, 0x00064daf, 0x000651af, 0x000655af,
		       0x000659af, 0x00065daf, 0x000661af, 0x000665af,
		       0x000669af, 0x00066daf, 0x000671af, 0x000675af,
		       0x000679af, 0x00067daf, 0x000681af, 0x000685af,
		       0x000689af, 0x00068daf, 0x000691af, 0x000695af,
		       0x000699af, 0x00069daf, 0x0006a1af, 0x0006a5af,
		       0x0006a9af, 0x0006adaf, 0x0006b1af, 0x0006b5af,
		       0x0006b9af, 0x0006bdaf, 0x0006c1af, 0x0006c5af,
		       0x0006c9af, 0x0006cdaf, 0x0006d1af, 0x0006d5af,
		       0x0006d9af, 0x0006ddaf, 0x0006e1af, 0x0006e5af,
		       0x0006e9af, 0x0006edaf, 0x0006f1af, 0x0006f5af,
		       0x0006f9af, 0x0006fdaf, 0x000701af, 0x000705af,
		       0x000709af, 0x00070daf, 0x000711af, 0x000715af,
		       0x000719af, 0x00071daf, 0x000721af, 0x000725af,
		       0x000729af, 0x00072daf, 0x000731af, 0x000735af,
		       0x000739af, 0x00073daf, 0x000741af, 0x000745af,
		       0x000749af, 0x00074daf, 0x000751af, 0x000755af,
		       0x000759af, 0x00075daf, 0x000761af, 0x000765af,
		       0x000769af, 0x00076daf, 0x000771af, 0x000775af,
		       0x000779af, 0x00077daf, 0x000781af, 0x000785af,
		       0x000789af, 0x00078daf, 0x000791af, 0x000795af,
		       0x000799af, 0x00079daf, 0x0007a1af, 0x0007a5af,
		       0x0007a9af, 0x0007adaf, 0x0007b1af, 0x0007b5af,
		       0x0007b9af, 0x0007bdaf, 0x0007c1af, 0x0007c5af,
		       0x0007c9af, 0x0007cdaf, 0x0007d1af, 0x0007d5af,
		       0x0007d9af, 0x0007ddaf, 0x0007e1af, 0x0007e5af,
		       0x0007e9af, 0x0007edaf, 0x0007f1af, 0x0007f5af,
		       0x0007f9af, 0x0007fdaf, 0x000801af, 0x000805af,
		       0x000809af, 0x00080daf, 0x000811af, 0x000815af,
		       0x000819af, 0x00081daf, 0x000821af, 0x000825af,
		       0x000829af, 0x00082daf, 0x000831af, 0x000835af,
		       0x000839af, 0x00083daf, 0x000841af, 0x000845af,
		       0x000849af, 0x00084daf, 0x000851af, 0x000855af,
		       0x000859af, 0x00085daf, 0x000861af, 0x000865af,
		       0x000869af, 0x00086daf, 0x000871af, 0x000875af,
		       0x000879af, 0x00087daf, 0x000881af, 0x000885af,
		       0x000889af, 0x00088daf, 0x000891af, 0x000895af,
		       0x000899af, 0x00089daf, 0x0008a1af, 0x0008a5af,
		       0x0008a9af, 0x0008adaf, 0x0008b1af, 0x0008b5af,
		       0x0008b9af, 0x0008bdaf, 0x0008c1af, 0x0008c5af,
		       0x0008c9af, 0x0008cdaf, 0x0008d1af, 0x0008d5af,
		       0x0008d9af, 0x0008ddaf, 0x0008e1af, 0x0008e5af,
		       0x0008e9af, 0x0008edaf, 0x0008f1af, 0x0008f5af,
		       0x0008f9af, 0x0008fdaf, 0x000901af, 0x000905af,
		       0x000909af, 0x00090daf, 0x000911af, 0x000915af,
		       0x000919af, 0x00091daf, 0x000921af, 0x000925af,
		       0x000929af, 0x00092daf, 0x000931af, 0x000935af,
		       0x000939af, 0x00093daf, 0x000941af, 0x000945af,
		       0x000949af, 0x00094daf, 0x000951af, 0x000955af,
		       0x000959af, 0x00095daf, 0x000961af, 0x000965af,
		       0x000969af, 0x00096daf, 0x000971af, 0x000975af,
		       0x000979af, 0x00097daf, 0x000981af, 0x000985af,
		       0x000989af, 0x00098daf, 0x000991af, 0x000995af,
		       0x000999af, 0x00099daf, 0x0009a1af, 0x0009a5af,
		       0x0009a9af, 0x0009adaf, 0x0009b1af, 0x0009b5af,
		       0x0009b9af, 0x0009bdaf, 0x0009c1af, 0x0009c5af,
		       0x0009c9af, 0x0009cdaf, 0x0009d1af, 0x0009d5af,
		       0x0009d9af, 0x0009ddaf, 0x0009e1af, 0x0009e5af,
		       0x0009e9af, 0x0009edaf, 0x0009f1af, 0x0009f5af,
		       0x0009f9af, 0x0009fdaf, 0x000a01af, 0x000a05af,
		       0x000a09af, 0x000a0daf, 0x000a11af, 0x000a15af,
		       0x000a19af, 0x000a1daf, 0x000a21af, 0x000a25af,
		       0x000a29af, 0x000a2daf, 0x000a31af, 0x000a35af,
		       0x000a39af, 0x000a3daf, 0x000a41af, 0x000a45af,
		       0x000a49af, 0x000a4daf, 0x000a51af, 0x000a55af,
		       0x000a59af, 0x000a5daf, 0x000a61af, 0x000a65af,
		       0x000a69af, 0x000a6daf, 0x000a71af, 0x000a75af,
		       0x000a79af, 0x000a7daf, 0x000a81af, 0x000a85af,
		       0x000a89af, 0x000a8daf, 0x000a91af, 0x000a95af,
		       0x000a99af, 0x000a9daf, 0x000aa1af, 0x000aa5af,
		       0x000aa9af, 0x000aadaf, 0x000ab1af, 0x000ab5af,
		       0x000ab9af, 0x000abdaf, 0x000ac1af, 0x000ac5af,
		       0x000ac9af, 0x000acdaf, 0x000ad1af, 0x000ad5af,
		       0x000ad9af, 0x000addaf, 0x000ae1af, 0x000ae5af,
		       0x000ae9af, 0x000aedaf, 0x000af1af, 0x000af5af,
		       0x000af9af, 0x000afdaf, 0x000b01af, 0x000b05af,
		       0x000b09af, 0x000b0daf, 0x000b11af, 0x000b15af,
		       0x000b19af, 0x000b1daf, 0x000b21af, 0x000b25af,
		       0x000b29af, 0x000b2daf, 0x000b31af, 0x000b35af,
		       0x000b39af, 0x000b3daf, 0x000b41af, 0x000b45af,
		       0x000b49af, 0x000b4daf, 0x000b51af, 0x000b55af,
		       0x000b59af, 0x000b5daf, 0x000b61af, 0x000b65af,
		       0x000b69af, 0x000b6daf, 0x000b71af, 0x000b75af,
		       0x000b79af, 0x000b7daf, 0x000b81af, 0x000b85af,
		       0x000b89af, 0x000b8daf, 0x000b91af, 0x000b95af,
		       0x000b99af, 0x000b9daf, 0x000ba1af, 0x000ba5af,
		       0x000ba9af, 0x000badaf, 0x000bb1af, 0x000bb5af,
		       0x000bb9af, 0x000bbdaf, 0x000bc1af, 0x000bc5af,
		       0x000bc9af, 0x000bcdaf, 0x000bd1af, 0x000bd5af,
		       0x000bd9af, 0x000bddaf, 0x000be1af, 0x000be5af,
		       0x000be9af, 0x000bedaf, 0x000bf1af, 0x000bf5af,
		       0x000bf9af, 0x000bfdaf, 0x000c01af, 0x000c05af,
		       0x000c09af, 0x000c0daf, 0x000c11af, 0x000c15af,
		       0x000c19af, 0x000c1daf, 0x000c21af, 0x000c25af,
		       0x000c29af, 0x000c2daf, 0x000c31af, 0x000c35af,
		       0x000c39af, 0x000c3daf, 0x000c41af, 0x000c45af,
		       0x000c49af, 0x000c4daf, 0x000c51af, 0x000c55af,
		       0x000c59af, 0x000c5daf, 0x000c61af, 0x000c65af,
		       0x000c69af, 0x000c6daf, 0x000c71af, 0x000c75af,
		       0x000c79af, 0x000c7daf, 0x000c81af, 0x000c85af,
		       0x000c89af, 0x000c8daf, 0x000c91af, 0x000c95af,
		       0x000c99af, 0x000c9daf, 0x000ca1af, 0x000ca5af,
		       0x000ca9af, 0x000cadaf, 0x000cb1af, 0x000cb5af,
		       0x000cb9af, 0x000cbdaf, 0x000cc1af, 0x000cc5af,
		       0x000cc9af, 0x000ccdaf, 0x000cd1af, 0x000cd5af,
		       0x000cd9af, 0x000cddaf, 0x000ce1af, 0x000ce5af,
		       0x000ce9af, 0x000cedaf, 0x000cf1af, 0x000cf5af,
		       0x000cf9af, 0x000cfdaf, 0x000d01af, 0x000d05af,
		       0x000d09af, 0x000d0daf, 0x000d11af, 0x000d15af,
		       0x000d19af, 0x000d1daf, 0x000d21af, 0x000d25af,
		       0x000d29af, 0x000d2daf, 0x000d31af, 0x000d35af,
		       0x000d39af, 0x000d3daf, 0x000d41af, 0x000d45af,
		       0x000d49af, 0x000d4daf, 0x000d51af, 0x000d55af,
		       0x000d59af, 0x000d5daf, 0x000d61af, 0x000d65af,
		       0x000d69af, 0x000d6daf, 0x000d71af, 0x000d75af,
		       0x000d79af, 0x000d7daf, 0x000d81af, 0x000d85af,
		       0x000d89af, 0x000d8daf, 0x000d91af, 0x000d95af,
		       0x000d99af, 0x000d9daf, 0x000da1af, 0x000da5af,
		       0x000da9af, 0x000dadaf, 0x000db1af, 0x000db5af,
		       0x000db9af, 0x000dbdaf, 0x000dc1af, 0x000dc5af,
		       0x000dc9af, 0x000dcdaf, 0x000dd1af, 0x000dd5af,
		       0x000dd9af, 0x000dddaf, 0x000de1af, 0x000de5af,
		       0x000de9af, 0x000dedaf, 0x000df1af, 0x000df5af,
		       0x000df9af, 0x000dfdaf, 0x000e01af, 0x000e05af,
		       0x000e09af, 0x000e0daf, 0x000e11af, 0x000e15af,
		       0x000e19af, 0x000e1daf, 0x000e21af, 0x000e25af,
		       0x000e29af, 0x000e2daf, 0x000e31af, 0x000e35af,
		       0x000e39af, 0x000e3daf, 0x000e41af, 0x000e45af,
		       0x000e49af, 0x000e4daf, 0x000e51af, 0x000e55af,
		       0x000e59af, 0x000e5daf, 0x000e61af, 0x000e65af,
		       0x000e69af, 0x000e6daf, 0x000e71af, 0x000e75af,
		       0x000e79af, 0x000e7daf, 0x000e81af, 0x000e85af,
		       0x000e89af, 0x000e8daf, 0x000e91af, 0x000e95af,
		       0x000e99af, 0x000e9daf, 0x000ea1af, 0x000ea5af,
		       0x000ea9af, 0x000eadaf, 0x000eb1af, 0x000eb5af,
		       0x000eb9af, 0x000ebdaf, 0x000ec1af, 0x000ec5af,
		       0x000ec9af, 0x000ecdaf, 0x000ed1af, 0x000ed5af,
		       0x000ed9af, 0x000eddaf, 0x000ee1af, 0x000ee5af,
		       0x000ee9af, 0x000eedaf, 0x000ef1af, 0x000ef5af,
		       0x000ef9af, 0x000efdaf, 0x000f01af, 0x000f05af,
		       0x000f09af, 0x000f0daf, 0x000f11af, 0x000f15af,
		       0x000f19af, 0x000f1daf, 0x000f21af, 0x000f25af,
		       0x000f29af, 0x000f2daf, 0x000f31af, 0x000f35af,
		       0x000f39af, 0x000f3daf, 0x000f41af, 0x000f45af,
		       0x000f49af, 0x000f4daf, 0x000f51af, 0x000f55af,
		       0x000f59af, 0x000f5daf, 0x000f61af, 0x000f65af,
		       0x000f69af, 0x000f6daf, 0x000f71af, 0x000f75af,
		       0x000f79af, 0x000f7daf, 0x000f81af, 0x000f85af,
		       0x000f89af, 0x000f8daf, 0x000f91af, 0x000f95af,
		       0x000f99af, 0x000f9daf, 0x000fa1af, 0x000fa5af,
		       0x000fa9af, 0x000fadaf, 0x000fb1af, 0x000fb5af,
		       0x000fb9af, 0x000fbdaf, 0x000fc1af, 0x000fc5af,
		       0x000fc9af, 0x000fcdaf, 0x000fd1af, 0x000fd5af,
		       0x000fd9af, 0x000fddaf, 0x000fe1af, 0x000fe5af,
		       0x000fe9af, 0x000fedaf, 0x000ff1af, 0x000ff5af,
		       0x000ff9af, 0x000ffdaf, 0x000003af, 0x000007af,
		       0x00000baf, 0x00000faf, 0x000013af, 0x000017af,
		       0x00001baf, 0x00001faf, 0x000023af, 0x000027af,
		       0x00002baf, 0x00002faf, 0x000033af, 0x000037af,
		       0x00003baf, 0x00003faf, 0x000043af, 0x000047af,
		       0x00004baf, 0x00004faf, 0x000053af, 0x000057af,
		       0x00005baf, 0x00005faf, 0x000063af, 0x000067af,
		       0x00006baf, 0x00006faf, 0x000073af, 0x000077af,
		       0x00007baf, 0x00007faf, 0x000083af, 0x000087af,
		       0x00008baf, 0x00008faf, 0x000093af, 0x000097af,
		       0x00009baf, 0x00009faf, 0x0000a3af, 0x0000a7af,
		       0x0000abaf, 0x0000afaf, 0x0000b3af, 0x0000b7af,
		       0x0000bbaf, 0x0000bfaf, 0x0000c3af, 0x0000c7af,
		       0x0000cbaf, 0x0000cfaf, 0x0000d3af, 0x0000d7af,
		       0x0000dbaf, 0x0000dfaf, 0x0000e3af, 0x0000e7af,
		       0x0000ebaf, 0x0000efaf, 0x0000f3af, 0x0000f7af,
		       0x0000fbaf, 0x0000ffaf, 0x000103af, 0x000107af,
		       0x00010baf, 0x00010faf, 0x000113af, 0x000117af,
		       0x00011baf, 0x00011faf, 0x000123af, 0x000127af,
		       0x00012baf, 0x00012faf, 0x000133af, 0x000137af,
		       0x00013baf, 0x00013faf, 0x000143af, 0x000147af,
		       0x00014baf, 0x00014faf, 0x000153af, 0x000157af,
		       0x00015baf, 0x00015faf, 0x000163af, 0x000167af,
		       0x00016baf, 0x00016faf, 0x000173af, 0x000177af,
		       0x00017baf, 0x00017faf, 0x000183af, 0x000187af,
		       0x00018baf, 0x00018faf, 0x000193af, 0x000197af,
		       0x00019baf, 0x00019faf, 0x0001a3af, 0x0001a7af,
		       0x0001abaf, 0x0001afaf, 0x0001b3af, 0x0001b7af,
		       0x0001bbaf, 0x0001bfaf, 0x0001c3af, 0x0001c7af,
		       0x0001cbaf, 0x0001cfaf, 0x0001d3af, 0x0001d7af,
		       0x0001dbaf, 0x0001dfaf, 0x0001e3af, 0x0001e7af,
		       0x0001ebaf, 0x0001efaf, 0x0001f3af, 0x0001f7af,
		       0x0001fbaf, 0x0001ffaf, 0x000203af, 0x000207af,
		       0x00020baf, 0x00020faf, 0x000213af, 0x000217af,
		       0x00021baf, 0x00021faf, 0x000223af, 0x000227af,
		       0x00022baf, 0x00022faf, 0x000233af, 0x000237af,
		       0x00023baf, 0x00023faf, 0x000243af, 0x000247af,
		       0x00024baf, 0x00024faf, 0x000253af, 0x000257af,
		       0x00025baf, 0x00025faf, 0x000263af, 0x000267af,
		       0x00026baf, 0x00026faf, 0x000273af, 0x000277af,
		       0x00027baf, 0x00027faf, 0x000283af, 0x000287af,
		       0x00028baf, 0x00028faf, 0x000293af, 0x000297af,
		       0x00029baf, 0x00029faf, 0x0002a3af, 0x0002a7af,
		       0x0002abaf, 0x0002afaf, 0x0002b3af, 0x0002b7af,
		       0x0002bbaf, 0x0002bfaf, 0x0002c3af, 0x0002c7af,
		       0x0002cbaf, 0x0002cfaf, 0x0002d3af, 0x0002d7af,
		       0x0002dbaf, 0x0002dfaf, 0x0002e3af, 0x0002e7af,
		       0x0002ebaf, 0x0002efaf, 0x0002f3af, 0x0002f7af,
		       0x0002fbaf, 0x0002ffaf, 0x000303af, 0x000307af,
		       0x00030baf, 0x00030faf, 0x000313af, 0x000317af,
		       0x00031baf, 0x00031faf, 0x000323af, 0x000327af,
		       0x00032baf, 0x00032faf, 0x000333af, 0x000337af,
		       0x00033baf, 0x00033faf, 0x000343af, 0x000347af,
		       0x00034baf, 0x00034faf, 0x000353af, 0x000357af,
		       0x00035baf, 0x00035faf, 0x000363af, 0x000367af,
		       0x00036baf, 0x00036faf, 0x000373af, 0x000377af,
		       0x00037baf, 0x00037faf, 0x000383af, 0x000387af,
		       0x00038baf, 0x00038faf, 0x000393af, 0x000397af,
		       0x00039baf, 0x00039faf, 0x0003a3af, 0x0003a7af,
		       0x0003abaf, 0x0003afaf, 0x0003b3af, 0x0003b7af,
		       0x0003bbaf, 0x0003bfaf, 0x0003c3af, 0x0003c7af,
		       0x0003cbaf, 0x0003cfaf, 0x0003d3af, 0x0003d7af,
		       0x0003dbaf, 0x0003dfaf, 0x0003e3af, 0x0003e7af,
		       0x0003ebaf, 0x0003efaf, 0x0003f3af, 0x0003f7af,
		       0x0003fbaf, 0x0003ffaf, 0x000403af, 0x000407af,
		       0x00040baf, 0x00040faf, 0x000413af, 0x000417af,
		       0x00041baf, 0x00041faf, 0x000423af, 0x000427af,
		       0x00042baf, 0x00042faf, 0x000433af, 0x000437af,
		       0x00043baf, 0x00043faf, 0x000443af, 0x000447af,
		       0x00044baf, 0x00044faf, 0x000453af, 0x000457af,
		       0x00045baf, 0x00045faf, 0x000463af, 0x000467af,
		       0x00046baf, 0x00046faf, 0x000473af, 0x000477af,
		       0x00047baf, 0x00047faf, 0x000483af, 0x000487af,
		       0x00048baf, 0x00048faf, 0x000493af, 0x000497af,
		       0x00049baf, 0x00049faf, 0x0004a3af, 0x0004a7af,
		       0x0004abaf, 0x0004afaf, 0x0004b3af, 0x0004b7af,
		       0x0004bbaf, 0x0004bfaf, 0x0004c3af, 0x0004c7af,
		       0x0004cbaf, 0x0004cfaf, 0x0004d3af, 0x0004d7af,
		       0x0004dbaf, 0x0004dfaf, 0x0004e3af, 0x0004e7af,
		       0x0004ebaf, 0x0004efaf, 0x0004f3af, 0x0004f7af,
		       0x0004fbaf, 0x0004ffaf, 0x000503af, 0x000507af,
		       0x00050baf, 0x00050faf, 0x000513af, 0x000517af,
		       0x00051baf, 0x00051faf, 0x000523af, 0x000527af,
		       0x00052baf, 0x00052faf, 0x000533af, 0x000537af,
		       0x00053baf, 0x00053faf, 0x000543af, 0x000547af,
		       0x00054baf, 0x00054faf, 0x000553af, 0x000557af,
		       0x00055baf, 0x00055faf, 0x000563af, 0x000567af,
		       0x00056baf, 0x00056faf, 0x000573af, 0x000577af,
		       0x00057baf, 0x00057faf, 0x000583af, 0x000587af,
		       0x00058baf, 0x00058faf, 0x000593af, 0x000597af,
		       0x00059baf, 0x00059faf, 0x0005a3af, 0x0005a7af,
		       0x0005abaf, 0x0005afaf, 0x0005b3af, 0x0005b7af,
		       0x0005bbaf, 0x0005bfaf, 0x0005c3af, 0x0005c7af,
		       0x0005cbaf, 0x0005cfaf, 0x0005d3af, 0x0005d7af,
		       0x0005dbaf, 0x0005dfaf, 0x0005e3af, 0x0005e7af,
		       0x0005ebaf, 0x0005efaf, 0x0005f3af, 0x0005f7af,
		       0x0005fbaf, 0x0005ffaf, 0x000603af, 0x000607af,
		       0x00060baf, 0x00060faf, 0x000613af, 0x000617af,
		       0x00061baf, 0x00061faf, 0x000623af, 0x000627af,
		       0x00062baf, 0x00062faf, 0x000633af, 0x000637af,
		       0x00063baf, 0x00063faf, 0x000643af, 0x000647af,
		       0x00064baf, 0x00064faf, 0x000653af, 0x000657af,
		       0x00065baf, 0x00065faf, 0x000663af, 0x000667af,
		       0x00066baf, 0x00066faf, 0x000673af, 0x000677af,
		       0x00067baf, 0x00067faf, 0x000683af, 0x000687af,
		       0x00068baf, 0x00068faf, 0x000693af, 0x000697af,
		       0x00069baf, 0x00069faf, 0x0006a3af, 0x0006a7af,
		       0x0006abaf, 0x0006afaf, 0x0006b3af, 0x0006b7af,
		       0x0006bbaf, 0x0006bfaf, 0x0006c3af, 0x0006c7af,
		       0x0006cbaf, 0x0006cfaf, 0x0006d3af, 0x0006d7af,
		       0x0006dbaf, 0x0006dfaf, 0x0006e3af, 0x0006e7af,
		       0x0006ebaf, 0x0006efaf, 0x0006f3af, 0x0006f7af,
		       0x0006fbaf, 0x0006ffaf, 0x000703af, 0x000707af,
		       0x00070baf, 0x00070faf, 0x000713af, 0x000717af,
		       0x00071baf, 0x00071faf, 0x000723af, 0x000727af,
		       0x00072baf, 0x00072faf, 0x000733af, 0x000737af,
		       0x00073baf, 0x00073faf, 0x000743af, 0x000747af,
		       0x00074baf, 0x00074faf, 0x000753af, 0x000757af,
		       0x00075baf, 0x00075faf, 0x000763af, 0x000767af,
		       0x00076baf, 0x00076faf, 0x000773af, 0x000777af,
		       0x00077baf, 0x00077faf, 0x000783af, 0x000787af,
		       0x00078baf, 0x00078faf, 0x000793af, 0x000797af,
		       0x00079baf, 0x00079faf, 0x0007a3af, 0x0007a7af,
		       0x0007abaf, 0x0007afaf, 0x0007b3af, 0x0007b7af,
		       0x0007bbaf, 0x0007bfaf, 0x0007c3af, 0x0007c7af,
		       0x0007cbaf, 0x0007cfaf, 0x0007d3af, 0x0007d7af,
		       0x0007dbaf, 0x0007dfaf, 0x0007e3af, 0x0007e7af,
		       0x0007ebaf, 0x0007efaf, 0x0007f3af, 0x0007f7af,
		       0x0007fbaf, 0x0007ffaf, 0x000803af, 0x000807af,
		       0x00080baf, 0x00080faf, 0x000813af, 0x000817af,
		       0x00081baf, 0x00081faf, 0x000823af, 0x000827af,
		       0x00082baf, 0x00082faf, 0x000833af, 0x000837af,
		       0x00083baf, 0x00083faf, 0x000843af, 0x000847af,
		       0x00084baf, 0x00084faf, 0x000853af, 0x000857af,
		       0x00085baf, 0x00085faf, 0x000863af, 0x000867af,
		       0x00086baf, 0x00086faf, 0x000873af, 0x000877af,
		       0x00087baf, 0x00087faf, 0x000883af, 0x000887af,
		       0x00088baf, 0x00088faf, 0x000893af, 0x000897af,
		       0x00089baf, 0x00089faf, 0x0008a3af, 0x0008a7af,
		       0x0008abaf, 0x0008afaf, 0x0008b3af, 0x0008b7af,
		       0x0008bbaf, 0x0008bfaf, 0x0008c3af, 0x0008c7af,
		       0x0008cbaf, 0x0008cfaf, 0x0008d3af, 0x0008d7af,
		       0x0008dbaf, 0x0008dfaf, 0x0008e3af, 0x0008e7af,
		       0x0008ebaf, 0x0008efaf, 0x0008f3af, 0x0008f7af,
		       0x0008fbaf, 0x0008ffaf, 0x000903af, 0x000907af,
		       0x00090baf, 0x00090faf, 0x000913af, 0x000917af,
		       0x00091baf, 0x00091faf, 0x000923af, 0x000927af,
		       0x00092baf, 0x00092faf, 0x000933af, 0x000937af,
		       0x00093baf, 0x00093faf, 0x000943af, 0x000947af,
		       0x00094baf, 0x00094faf, 0x000953af, 0x000957af,
		       0x00095baf, 0x00095faf, 0x000963af, 0x000967af,
		       0x00096baf, 0x00096faf, 0x000973af, 0x000977af,
		       0x00097baf, 0x00097faf, 0x000983af, 0x000987af,
		       0x00098baf, 0x00098faf, 0x000993af, 0x000997af,
		       0x00099baf, 0x00099faf, 0x0009a3af, 0x0009a7af,
		       0x0009abaf, 0x0009afaf, 0x0009b3af, 0x0009b7af,
		       0x0009bbaf, 0x0009bfaf, 0x0009c3af, 0x0009c7af,
		       0x0009cbaf, 0x0009cfaf, 0x0009d3af, 0x0009d7af,
		       0x0009dbaf, 0x0009dfaf, 0x0009e3af, 0x0009e7af,
		       0x0009ebaf, 0x0009efaf, 0x0009f3af, 0x0009f7af,
		       0x0009fbaf, 0x0009ffaf, 0x000a03af, 0x000a07af,
		       0x000a0baf, 0x000a0faf, 0x000a13af, 0x000a17af,
		       0x000a1baf, 0x000a1faf, 0x000a23af, 0x000a27af,
		       0x000a2baf, 0x000a2faf, 0x000a33af, 0x000a37af,
		       0x000a3baf, 0x000a3faf, 0x000a43af, 0x000a47af,
		       0x000a4baf, 0x000a4faf, 0x000a53af, 0x000a57af,
		       0x000a5baf, 0x000a5faf, 0x000a63af, 0x000a67af,
		       0x000a6baf, 0x000a6faf, 0x000a73af, 0x000a77af,
		       0x000a7baf, 0x000a7faf, 0x000a83af, 0x000a87af,
		       0x000a8baf, 0x000a8faf, 0x000a93af, 0x000a97af,
		       0x000a9baf, 0x000a9faf, 0x000aa3af, 0x000aa7af,
		       0x000aabaf, 0x000aafaf, 0x000ab3af, 0x000ab7af,
		       0x000abbaf, 0x000abfaf, 0x000ac3af, 0x000ac7af,
		       0x000acbaf, 0x000acfaf, 0x000ad3af, 0x000ad7af,
		       0x000adbaf, 0x000adfaf, 0x000ae3af, 0x000ae7af,
		       0x000aebaf, 0x000aefaf, 0x000af3af, 0x000af7af,
		       0x000afbaf, 0x000affaf, 0x000b03af, 0x000b07af,
		       0x000b0baf, 0x000b0faf, 0x000b13af, 0x000b17af,
		       0x000b1baf, 0x000b1faf, 0x000b23af, 0x000b27af,
		       0x000b2baf, 0x000b2faf, 0x000b33af, 0x000b37af,
		       0x000b3baf, 0x000b3faf, 0x000b43af, 0x000b47af,
		       0x000b4baf, 0x000b4faf, 0x000b53af, 0x000b57af,
		       0x000b5baf, 0x000b5faf, 0x000b63af, 0x000b67af,
		       0x000b6baf, 0x000b6faf, 0x000b73af, 0x000b77af,
		       0x000b7baf, 0x000b7faf, 0x000b83af, 0x000b87af,
		       0x000b8baf, 0x000b8faf, 0x000b93af, 0x000b97af,
		       0x000b9baf, 0x000b9faf, 0x000ba3af, 0x000ba7af,
		       0x000babaf, 0x000bafaf, 0x000bb3af, 0x000bb7af,
		       0x000bbbaf, 0x000bbfaf, 0x000bc3af, 0x000bc7af,
		       0x000bcbaf, 0x000bcfaf, 0x000bd3af, 0x000bd7af,
		       0x000bdbaf, 0x000bdfaf, 0x000be3af, 0x000be7af,
		       0x000bebaf, 0x000befaf, 0x000bf3af, 0x000bf7af,
		       0x000bfbaf, 0x000bffaf, 0x000c03af, 0x000c07af,
		       0x000c0baf, 0x000c0faf, 0x000c13af, 0x000c17af,
		       0x000c1baf, 0x000c1faf, 0x000c23af, 0x000c27af,
		       0x000c2baf, 0x000c2faf, 0x000c33af, 0x000c37af,
		       0x000c3baf, 0x000c3faf, 0x000c43af, 0x000c47af,
		       0x000c4baf, 0x000c4faf, 0x000c53af, 0x000c57af,
		       0x000c5baf, 0x000c5faf, 0x000c63af, 0x000c67af,
		       0x000c6baf, 0x000c6faf, 0x000c73af, 0x000c77af,
		       0x000c7baf, 0x000c7faf, 0x000c83af, 0x000c87af,
		       0x000c8baf, 0x000c8faf, 0x000c93af, 0x000c97af,
		       0x000c9baf, 0x000c9faf, 0x000ca3af, 0x000ca7af,
		       0x000cabaf, 0x000cafaf, 0x000cb3af, 0x000cb7af,
		       0x000cbbaf, 0x000cbfaf, 0x000cc3af, 0x000cc7af,
		       0x000ccbaf, 0x000ccfaf, 0x000cd3af, 0x000cd7af,
		       0x000cdbaf, 0x000cdfaf, 0x000ce3af, 0x000ce7af,
		       0x000cebaf, 0x000cefaf, 0x000cf3af, 0x000cf7af,
		       0x000cfbaf, 0x000cffaf, 0x000d03af, 0x000d07af,
		       0x000d0baf, 0x000d0faf, 0x000d13af, 0x000d17af,
		       0x000d1baf, 0x000d1faf, 0x000d23af, 0x000d27af,
		       0x000d2baf, 0x000d2faf, 0x000d33af, 0x000d37af,
		       0x000d3baf, 0x000d3faf, 0x000d43af, 0x000d47af,
		       0x000d4baf, 0x000d4faf, 0x000d53af, 0x000d57af,
		       0x000d5baf, 0x000d5faf, 0x000d63af, 0x000d67af,
		       0x000d6baf, 0x000d6faf, 0x000d73af, 0x000d77af,
		       0x000d7baf, 0x000d7faf, 0x000d83af, 0x000d87af,
		       0x000d8baf, 0x000d8faf, 0x000d93af, 0x000d97af,
		       0x000d9baf, 0x000d9faf, 0x000da3af, 0x000da7af,
		       0x000dabaf, 0x000dafaf, 0x000db3af, 0x000db7af,
		       0x000dbbaf, 0x000dbfaf, 0x000dc3af, 0x000dc7af,
		       0x000dcbaf, 0x000dcfaf, 0x000dd3af, 0x000dd7af,
		       0x000ddbaf, 0x000ddfaf, 0x000de3af, 0x000de7af,
		       0x000debaf, 0x000defaf, 0x000df3af, 0x000df7af,
		       0x000dfbaf, 0x000dffaf, 0x000e03af, 0x000e07af,
		       0x000e0baf, 0x000e0faf, 0x000e13af, 0x000e17af,
		       0x000e1baf, 0x000e1faf, 0x000e23af, 0x000e27af,
		       0x000e2baf, 0x000e2faf, 0x000e33af, 0x000e37af,
		       0x000e3baf, 0x000e3faf, 0x000e43af, 0x000e47af,
		       0x000e4baf, 0x000e4faf, 0x000e53af, 0x000e57af,
		       0x000e5baf, 0x000e5faf, 0x000e63af, 0x000e67af,
		       0x000e6baf, 0x000e6faf, 0x000e73af, 0x000e77af,
		       0x000e7baf, 0x000e7faf, 0x000e83af, 0x000e87af,
		       0x000e8baf, 0x000e8faf, 0x000e93af, 0x000e97af,
		       0x000e9baf, 0x000e9faf, 0x000ea3af, 0x000ea7af,
		       0x000eabaf, 0x000eafaf, 0x000eb3af, 0x000eb7af,
		       0x000ebbaf, 0x000ebfaf, 0x000ec3af, 0x000ec7af,
		       0x000ecbaf, 0x000ecfaf, 0x000ed3af, 0x000ed7af,
		       0x000edbaf, 0x000edfaf, 0x000ee3af, 0x000ee7af,
		       0x000eebaf, 0x000eefaf, 0x000ef3af, 0x000ef7af,
		       0x000efbaf, 0x000effaf, 0x000f03af, 0x000f07af,
		       0x000f0baf, 0x000f0faf, 0x000f13af, 0x000f17af,
		       0x000f1baf, 0x000f1faf, 0x000f23af, 0x000f27af,
		       0x000f2baf, 0x000f2faf, 0x000f33af, 0x000f37af,
		       0x000f3baf, 0x000f3faf, 0x000f43af, 0x000f47af,
		       0x000f4baf, 0x000f4faf, 0x000f53af, 0x000f57af,
		       0x000f5baf, 0x000f5faf, 0x000f63af, 0x000f67af,
		       0x000f6baf, 0x000f6faf, 0x000f73af, 0x000f77af,
		       0x000f7baf, 0x000f7faf, 0x000f83af, 0x000f87af,
		       0x000f8baf, 0x000f8faf, 0x000f93af, 0x000f97af,
		       0x000f9baf, 0x000f9faf, 0x000fa3af, 0x000fa7af,
		       0x000fabaf, 0x000fafaf, 0x000fb3af, 0x000fb7af,
		       0x000fbbaf, 0x000fbfaf, 0x000fc3af, 0x000fc7af,
		       0x000fcbaf, 0x000fcfaf, 0x000fd3af, 0x000fd7af,
		       0x000fdbaf, 0x000fdfaf, 0x000fe3af, 0x000fe7af,
		       0x000febaf, 0x000fefaf, 0x000ff3af, 0x000ff7af,
		       0x000ffbaf, 0x000fffaf, 0x00000070, 0x00000470,
		       0x00000870, 0x00000c70, 0x00001070, 0x00001470,
		       0x00001870, 0x00001c70, 0x00002070, 0x00002470,
		       0x00002870, 0x00002c70, 0x00003070, 0x00003470,
		       0x00003870, 0x00003c70, 0x00004070, 0x00004470,
		       0x00004870, 0x00004c70, 0x00005070, 0x00005470,
		       0x00005870, 0x00005c70, 0x00006070, 0x00006470,
		       0x00006870, 0x00006c70, 0x00007070, 0x00007470,
		       0x00007870, 0x00007c70, 0x00008070, 0x00008470,
		       0x00008870, 0x00008c70, 0x00009070, 0x00009470,
		       0x00009870, 0x00009c70, 0x0000a070, 0x0000a470,
		       0x0000a870, 0x0000ac70, 0x0000b070, 0x0000b470,
		       0x0000b870, 0x0000bc70, 0x0000c070, 0x0000c470,
		       0x0000c870, 0x0000cc70, 0x0000d070, 0x0000d470,
		       0x0000d870, 0x0000dc70, 0x0000e070, 0x0000e470,
		       0x0000e870, 0x0000ec70, 0x0000f070, 0x0000f470,
		       0x0000f870, 0x0000fc70, 0x00010070, 0x00010470,
		       0x00010870, 0x00010c70, 0x00011070, 0x00011470,
		       0x00011870, 0x00011c70, 0x00012070, 0x00012470,
		       0x00012870, 0x00012c70, 0x00013070, 0x00013470,
		       0x00013870, 0x00013c70, 0x00014070, 0x00014470,
		       0x00014870, 0x00014c70, 0x00015070, 0x00015470,
		       0x00015870, 0x00015c70, 0x00016070, 0x00016470,
		       0x00016870, 0x00016c70, 0x00017070, 0x00017470,
		       0x00017870, 0x00017c70, 0x00018070, 0x00018470,
		       0x00018870, 0x00018c70, 0x00019070, 0x00019470,
		       0x00019870, 0x00019c70, 0x0001a070, 0x0001a470,
		       0x0001a870, 0x0001ac70, 0x0001b070, 0x0001b470,
		       0x0001b870, 0x0001bc70, 0x0001c070, 0x0001c470,
		       0x0001c870, 0x0001cc70, 0x0001d070, 0x0001d470,
		       0x0001d870, 0x0001dc70, 0x0001e070, 0x0001e470,
		       0x0001e870, 0x0001ec70, 0x0001f070, 0x0001f470,
		       0x0001f870, 0x0001fc70, 0x00020070, 0x00020470,
		       0x00020870, 0x00020c70, 0x00021070, 0x00021470,
		       0x00021870, 0x00021c70, 0x00022070, 0x00022470,
		       0x00022870, 0x00022c70, 0x00023070, 0x00023470,
		       0x00023870, 0x00023c70, 0x00024070, 0x00024470,
		       0x00024870, 0x00024c70, 0x00025070, 0x00025470,
		       0x00025870, 0x00025c70, 0x00026070, 0x00026470,
		       0x00026870, 0x00026c70, 0x00027070, 0x00027470,
		       0x00027870, 0x00027c70, 0x00028070, 0x00028470,
		       0x00028870, 0x00028c70, 0x00029070, 0x00029470,
		       0x00029870, 0x00029c70, 0x0002a070, 0x0002a470,
		       0x0002a870, 0x0002ac70, 0x0002b070, 0x0002b470,
		       0x0002b870, 0x0002bc70, 0x0002c070, 0x0002c470,
		       0x0002c870, 0x0002cc70, 0x0002d070, 0x0002d470,
		       0x0002d870, 0x0002dc70, 0x0002e070, 0x0002e470,
		       0x0002e870, 0x0002ec70, 0x0002f070, 0x0002f470,
		       0x0002f870, 0x0002fc70, 0x00030070, 0x00030470,
		       0x00030870, 0x00030c70, 0x00031070, 0x00031470,
		       0x00031870, 0x00031c70, 0x00032070, 0x00032470,
		       0x00032870, 0x00032c70, 0x00033070, 0x00033470,
		       0x00033870, 0x00033c70, 0x00034070, 0x00034470,
		       0x00034870, 0x00034c70, 0x00035070, 0x00035470,
		       0x00035870, 0x00035c70, 0x00036070, 0x00036470,
		       0x00036870, 0x00036c70, 0x00037070, 0x00037470,
		       0x00037870, 0x00037c70, 0x00038070, 0x00038470,
		       0x00038870, 0x00038c70, 0x00039070, 0x00039470,
		       0x00039870, 0x00039c70, 0x0003a070, 0x0003a470,
		       0x0003a870, 0x0003ac70, 0x0003b070, 0x0003b470,
		       0x0003b870, 0x0003bc70, 0x0003c070, 0x0003c470,
		       0x0003c870, 0x0003cc70, 0x0003d070, 0x0003d470,
		       0x0003d870, 0x0003dc70, 0x0003e070, 0x0003e470,
		       0x0003e870, 0x0003ec70, 0x0003f070, 0x0003f470,
		       0x0003f870, 0x0003fc70, 0x00040070, 0x00040470,
		       0x00040870, 0x00040c70, 0x00041070, 0x00041470,
		       0x00041870, 0x00041c70, 0x00042070, 0x00042470,
		       0x00042870, 0x00042c70, 0x00043070, 0x00043470,
		       0x00043870, 0x00043c70, 0x00044070, 0x00044470,
		       0x00044870, 0x00044c70, 0x00045070, 0x00045470,
		       0x00045870, 0x00045c70, 0x00046070, 0x00046470,
		       0x00046870, 0x00046c70, 0x00047070, 0x00047470,
		       0x00047870, 0x00047c70, 0x00048070, 0x00048470,
		       0x00048870, 0x00048c70, 0x00049070, 0x00049470,
		       0x00049870, 0x00049c70, 0x0004a070, 0x0004a470,
		       0x0004a870, 0x0004ac70, 0x0004b070, 0x0004b470,
		       0x0004b870, 0x0004bc70, 0x0004c070, 0x0004c470,
		       0x0004c870, 0x0004cc70, 0x0004d070, 0x0004d470,
		       0x0004d870, 0x0004dc70, 0x0004e070, 0x0004e470,
		       0x0004e870, 0x0004ec70, 0x0004f070, 0x0004f470,
		       0x0004f870, 0x0004fc70, 0x00050070, 0x00050470,
		       0x00050870, 0x00050c70, 0x00051070, 0x00051470,
		       0x00051870, 0x00051c70, 0x00052070, 0x00052470,
		       0x00052870, 0x00052c70, 0x00053070, 0x00053470,
		       0x00053870, 0x00053c70, 0x00054070, 0x00054470,
		       0x00054870, 0x00054c70, 0x00055070, 0x00055470,
		       0x00055870, 0x00055c70, 0x00056070, 0x00056470,
		       0x00056870, 0x00056c70, 0x00057070, 0x00057470,
		       0x00057870, 0x00057c70, 0x00058070, 0x00058470,
		       0x00058870, 0x00058c70, 0x00059070, 0x00059470,
		       0x00059870, 0x00059c70, 0x0005a070, 0x0005a470,
		       0x0005a870, 0x0005ac70, 0x0005b070, 0x0005b470,
		       0x0005b870, 0x0005bc70, 0x0005c070, 0x0005c470,
		       0x0005c870, 0x0005cc70, 0x0005d070, 0x0005d470,
		       0x0005d870, 0x0005dc70, 0x0005e070, 0x0005e470,
		       0x0005e870, 0x0005ec70, 0x0005f070, 0x0005f470,
		       0x0005f870, 0x0005fc70, 0x00060070, 0x00060470,
		       0x00060870, 0x00060c70, 0x00061070, 0x00061470,
		       0x00061870, 0x00061c70, 0x00062070, 0x00062470,
		       0x00062870, 0x00062c70, 0x00063070, 0x00063470,
		       0x00063870, 0x00063c70, 0x00064070, 0x00064470,
		       0x00064870, 0x00064c70, 0x00065070, 0x00065470,
		       0x00065870, 0x00065c70, 0x00066070, 0x00066470,
		       0x00066870, 0x00066c70, 0x00067070, 0x00067470,
		       0x00067870, 0x00067c70, 0x00068070, 0x00068470,
		       0x00068870, 0x00068c70, 0x00069070, 0x00069470,
		       0x00069870, 0x00069c70, 0x0006a070, 0x0006a470,
		       0x0006a870, 0x0006ac70, 0x0006b070, 0x0006b470,
		       0x0006b870, 0x0006bc70, 0x0006c070, 0x0006c470,
		       0x0006c870, 0x0006cc70, 0x0006d070, 0x0006d470,
		       0x0006d870, 0x0006dc70, 0x0006e070, 0x0006e470,
		       0x0006e870, 0x0006ec70, 0x0006f070, 0x0006f470,
		       0x0006f870, 0x0006fc70, 0x00070070, 0x00070470,
		       0x00070870, 0x00070c70, 0x00071070, 0x00071470,
		       0x00071870, 0x00071c70, 0x00072070, 0x00072470,
		       0x00072870, 0x00072c70, 0x00073070, 0x00073470,
		       0x00073870, 0x00073c70, 0x00074070, 0x00074470,
		       0x00074870, 0x00074c70, 0x00075070, 0x00075470,
		       0x00075870, 0x00075c70, 0x00076070, 0x00076470,
		       0x00076870, 0x00076c70, 0x00077070, 0x00077470,
		       0x00077870, 0x00077c70, 0x00078070, 0x00078470,
		       0x00078870, 0x00078c70, 0x00079070, 0x00079470,
		       0x00079870, 0x00079c70, 0x0007a070, 0x0007a470,
		       0x0007a870, 0x0007ac70, 0x0007b070, 0x0007b470,
		       0x0007b870, 0x0007bc70, 0x0007c070, 0x0007c470,
		       0x0007c870, 0x0007cc70, 0x0007d070, 0x0007d470,
		       0x0007d870, 0x0007dc70, 0x0007e070, 0x0007e470,
		       0x0007e870, 0x0007ec70, 0x0007f070, 0x0007f470,
		       0x0007f870, 0x0007fc70, 0x00080070, 0x00080470,
		       0x00080870, 0x00080c70, 0x00081070, 0x00081470,
		       0x00081870, 0x00081c70, 0x00082070, 0x00082470,
		       0x00082870, 0x00082c70, 0x00083070, 0x00083470,
		       0x00083870, 0x00083c70, 0x00084070, 0x00084470,
		       0x00084870, 0x00084c70, 0x00085070, 0x00085470,
		       0x00085870, 0x00085c70, 0x00086070, 0x00086470,
		       0x00086870, 0x00086c70, 0x00087070, 0x00087470,
		       0x00087870, 0x00087c70, 0x00088070, 0x00088470,
		       0x00088870, 0x00088c70, 0x00089070, 0x00089470,
		       0x00089870, 0x00089c70, 0x0008a070, 0x0008a470,
		       0x0008a870, 0x0008ac70, 0x0008b070, 0x0008b470,
		       0x0008b870, 0x0008bc70, 0x0008c070, 0x0008c470,
		       0x0008c870, 0x0008cc70, 0x0008d070, 0x0008d470,
		       0x0008d870, 0x0008dc70, 0x0008e070, 0x0008e470,
		       0x0008e870, 0x0008ec70, 0x0008f070, 0x0008f470,
		       0x0008f870, 0x0008fc70, 0x00090070, 0x00090470,
		       0x00090870, 0x00090c70, 0x00091070, 0x00091470,
		       0x00091870, 0x00091c70, 0x00092070, 0x00092470,
		       0x00092870, 0x00092c70, 0x00093070, 0x00093470,
		       0x00093870, 0x00093c70, 0x00094070, 0x00094470,
		       0x00094870, 0x00094c70, 0x00095070, 0x00095470,
		       0x00095870, 0x00095c70, 0x00096070, 0x00096470,
		       0x00096870, 0x00096c70, 0x00097070, 0x00097470,
		       0x00097870, 0x00097c70, 0x00098070, 0x00098470,
		       0x00098870, 0x00098c70, 0x00099070, 0x00099470,
		       0x00099870, 0x00099c70, 0x0009a070, 0x0009a470,
		       0x0009a870, 0x0009ac70, 0x0009b070, 0x0009b470,
		       0x0009b870, 0x0009bc70, 0x0009c070, 0x0009c470,
		       0x0009c870, 0x0009cc70, 0x0009d070, 0x0009d470,
		       0x0009d870, 0x0009dc70, 0x0009e070, 0x0009e470,
		       0x0009e870, 0x0009ec70, 0x0009f070, 0x0009f470,
		       0x0009f870, 0x0009fc70, 0x000a0070, 0x000a0470,
		       0x000a0870, 0x000a0c70, 0x000a1070, 0x000a1470,
		       0x000a1870, 0x000a1c70, 0x000a2070, 0x000a2470,
		       0x000a2870, 0x000a2c70, 0x000a3070, 0x000a3470,
		       0x000a3870, 0x000a3c70, 0x000a4070, 0x000a4470,
		       0x000a4870, 0x000a4c70, 0x000a5070, 0x000a5470,
		       0x000a5870, 0x000a5c70, 0x000a6070, 0x000a6470,
		       0x000a6870, 0x000a6c70, 0x000a7070, 0x000a7470,
		       0x000a7870, 0x000a7c70, 0x000a8070, 0x000a8470,
		       0x000a8870, 0x000a8c70, 0x000a9070, 0x000a9470,
		       0x000a9870, 0x000a9c70, 0x000aa070, 0x000aa470,
		       0x000aa870, 0x000aac70, 0x000ab070, 0x000ab470,
		       0x000ab870, 0x000abc70, 0x000ac070, 0x000ac470,
		       0x000ac870, 0x000acc70, 0x000ad070, 0x000ad470,
		       0x000ad870, 0x000adc70, 0x000ae070, 0x000ae470,
		       0x000ae870, 0x000aec70, 0x000af070, 0x000af470,
		       0x000af870, 0x000afc70, 0x000b0070, 0x000b0470,
		       0x000b0870, 0x000b0c70, 0x000b1070, 0x000b1470,
		       0x000b1870, 0x000b1c70, 0x000b2070, 0x000b2470,
		       0x000b2870, 0x000b2c70, 0x000b3070, 0x000b3470,
		       0x000b3870, 0x000b3c70, 0x000b4070, 0x000b4470,
		       0x000b4870, 0x000b4c70, 0x000b5070, 0x000b5470,
		       0x000b5870, 0x000b5c70, 0x000b6070, 0x000b6470,
		       0x000b6870, 0x000b6c70, 0x000b7070, 0x000b7470,
		       0x000b7870, 0x000b7c70, 0x000b8070, 0x000b8470,
		       0x000b8870, 0x000b8c70, 0x000b9070, 0x000b9470,
		       0x000b9870, 0x000b9c70, 0x000ba070, 0x000ba470,
		       0x000ba870, 0x000bac70, 0x000bb070, 0x000bb470,
		       0x000bb870, 0x000bbc70, 0x000bc070, 0x000bc470,
		       0x000bc870, 0x000bcc70, 0x000bd070, 0x000bd470,
		       0x000bd870, 0x000bdc70, 0x000be070, 0x000be470,
		       0x000be870, 0x000bec70, 0x000bf070, 0x000bf470,
		       0x000bf870, 0x000bfc70, 0x000c0070, 0x000c0470,
		       0x000c0870, 0x000c0c70, 0x000c1070, 0x000c1470,
		       0x000c1870, 0x000c1c70, 0x000c2070, 0x000c2470,
		       0x000c2870, 0x000c2c70, 0x000c3070, 0x000c3470,
		       0x000c3870, 0x000c3c70, 0x000c4070, 0x000c4470,
		       0x000c4870, 0x000c4c70, 0x000c5070, 0x000c5470,
		       0x000c5870, 0x000c5c70, 0x000c6070, 0x000c6470,
		       0x000c6870, 0x000c6c70, 0x000c7070, 0x000c7470,
		       0x000c7870, 0x000c7c70, 0x000c8070, 0x000c8470,
		       0x000c8870, 0x000c8c70, 0x000c9070, 0x000c9470,
		       0x000c9870, 0x000c9c70, 0x000ca070, 0x000ca470,
		       0x000ca870, 0x000cac70, 0x000cb070, 0x000cb470,
		       0x000cb870, 0x000cbc70, 0x000cc070, 0x000cc470,
		       0x000cc870, 0x000ccc70, 0x000cd070, 0x000cd470,
		       0x000cd870, 0x000cdc70, 0x000ce070, 0x000ce470,
		       0x000ce870, 0x000cec70, 0x000cf070, 0x000cf470,
		       0x000cf870, 0x000cfc70, 0x000d0070, 0x000d0470,
		       0x000d0870, 0x000d0c70, 0x000d1070, 0x000d1470,
		       0x000d1870, 0x000d1c70, 0x000d2070, 0x000d2470,
		       0x000d2870, 0x000d2c70, 0x000d3070, 0x000d3470,
		       0x000d3870, 0x000d3c70, 0x000d4070, 0x000d4470,
		       0x000d4870, 0x000d4c70, 0x000d5070, 0x000d5470,
		       0x000d5870, 0x000d5c70, 0x000d6070, 0x000d6470,
		       0x000d6870, 0x000d6c70, 0x000d7070, 0x000d7470,
		       0x000d7870, 0x000d7c70, 0x000d8070, 0x000d8470,
		       0x000d8870, 0x000d8c70, 0x000d9070, 0x000d9470,
		       0x000d9870, 0x000d9c70, 0x000da070, 0x000da470,
		       0x000da870, 0x000dac70, 0x000db070, 0x000db470,
		       0x000db870, 0x000dbc70, 0x000dc070, 0x000dc470,
		       0x000dc870, 0x000dcc70, 0x000dd070, 0x000dd470,
		       0x000dd870, 0x000ddc70, 0x000de070, 0x000de470,
		       0x000de870, 0x000dec70, 0x000df070, 0x000df470,
		       0x000df870, 0x000dfc70, 0x000e0070, 0x000e0470,
		       0x000e0870, 0x000e0c70, 0x000e1070, 0x000e1470,
		       0x000e1870, 0x000e1c70, 0x000e2070, 0x000e2470,
		       0x000e2870, 0x000e2c70, 0x000e3070, 0x000e3470,
		       0x000e3870, 0x000e3c70, 0x000e4070, 0x000e4470,
		       0x000e4870, 0x000e4c70, 0x000e5070, 0x000e5470,
		       0x000e5870, 0x000e5c70, 0x000e6070, 0x000e6470,
		       0x000e6870, 0x000e6c70, 0x000e7070, 0x000e7470,
		       0x000e7870, 0x000e7c70, 0x000e8070, 0x000e8470,
		       0x000e8870, 0x000e8c70, 0x000e9070, 0x000e9470,
		       0x000e9870, 0x000e9c70, 0x000ea070, 0x000ea470,
		       0x000ea870, 0x000eac70, 0x000eb070, 0x000eb470,
		       0x000eb870, 0x000ebc70, 0x000ec070, 0x000ec470,
		       0x000ec870, 0x000ecc70, 0x000ed070, 0x000ed470,
		       0x000ed870, 0x000edc70, 0x000ee070, 0x000ee470,
		       0x000ee870, 0x000eec70, 0x000ef070, 0x000ef470,
		       0x000ef870, 0x000efc70, 0x000f0070, 0x000f0470,
		       0x000f0870, 0x000f0c70, 0x000f1070, 0x000f1470,
		       0x000f1870, 0x000f1c70, 0x000f2070, 0x000f2470,
		       0x000f2870, 0x000f2c70, 0x000f3070, 0x000f3470,
		       0x000f3870, 0x000f3c70, 0x000f4070, 0x000f4470,
		       0x000f4870, 0x000f4c70, 0x000f5070, 0x000f5470,
		       0x000f5870, 0x000f5c70, 0x000f6070, 0x000f6470,
		       0x000f6870, 0x000f6c70, 0x000f7070, 0x000f7470,
		       0x000f7870, 0x000f7c70, 0x000f8070, 0x000f8470,
		       0x000f8870, 0x000f8c70, 0x000f9070, 0x000f9470,
		       0x000f9870, 0x000f9c70, 0x000fa070, 0x000fa470,
		       0x000fa870, 0x000fac70, 0x000fb070, 0x000fb470,
		       0x000fb870, 0x000fbc70, 0x000fc070, 0x000fc470,
		       0x000fc870, 0x000fcc70, 0x000fd070, 0x000fd470,
		       0x000fd870, 0x000fdc70, 0x000fe070, 0x000fe470,
		       0x000fe870, 0x000fec70, 0x000ff070, 0x000ff470,
		       0x000ff870, 0x000ffc70, 0x00100070, 0x00100470,
		       0x00100870, 0x00100c70, 0x00101070, 0x00101470,
		       0x00101870, 0x00101c70, 0x00102070, 0x00102470,
		       0x00102870, 0x00102c70, 0x00103070, 0x00103470,
		       0x00103870, 0x00103c70, 0x00104070, 0x00104470,
		       0x00104870, 0x00104c70, 0x00105070, 0x00105470,
		       0x00105870, 0x00105c70, 0x00106070, 0x00106470,
		       0x00106870, 0x00106c70, 0x00107070, 0x00107470,
		       0x00107870, 0x00107c70, 0x00108070, 0x00108470,
		       0x00108870, 0x00108c70, 0x00109070, 0x00109470,
		       0x00109870, 0x00109c70, 0x0010a070, 0x0010a470,
		       0x0010a870, 0x0010ac70, 0x0010b070, 0x0010b470,
		       0x0010b870, 0x0010bc70, 0x0010c070, 0x0010c470,
		       0x0010c870, 0x0010cc70, 0x0010d070, 0x0010d470,
		       0x0010d870, 0x0010dc70, 0x0010e070, 0x0010e470,
		       0x0010e870, 0x0010ec70, 0x0010f070, 0x0010f470,
		       0x0010f870, 0x0010fc70, 0x00110070, 0x00110470,
		       0x00110870, 0x00110c70, 0x00111070, 0x00111470,
		       0x00111870, 0x00111c70, 0x00112070, 0x00112470,
		       0x00112870, 0x00112c70, 0x00113070, 0x00113470,
		       0x00113870, 0x00113c70, 0x00114070, 0x00114470,
		       0x00114870, 0x00114c70, 0x00115070, 0x00115470,
		       0x00115870, 0x00115c70, 0x00116070, 0x00116470,
		       0x00116870, 0x00116c70, 0x00117070, 0x00117470,
		       0x00117870, 0x00117c70, 0x00118070, 0x00118470,
		       0x00118870, 0x00118c70, 0x00119070, 0x00119470,
		       0x00119870, 0x00119c70, 0x0011a070, 0x0011a470,
		       0x0011a870, 0x0011ac70, 0x0011b070, 0x0011b470,
		       0x0011b870, 0x0011bc70, 0x0011c070, 0x0011c470,
		       0x0011c870, 0x0011cc70, 0x0011d070, 0x0011d470,
		       0x0011d870, 0x0011dc70, 0x0011e070, 0x0011e470,
		       0x0011e870, 0x0011ec70, 0x0011f070, 0x0011f470,
		       0x0011f870, 0x0011fc70, 0x00120070, 0x00120470,
		       0x00120870, 0x00120c70, 0x00121070, 0x00121470,
		       0x00121870, 0x00121c70, 0x00122070, 0x00122470,
		       0x00122870, 0x00122c70, 0x00123070, 0x00123470,
		       0x00123870, 0x00123c70, 0x00124070, 0x00124470,
		       0x00124870, 0x00124c70, 0x00125070, 0x00125470,
		       0x00125870, 0x00125c70, 0x00126070, 0x00126470,
		       0x00126870, 0x00126c70, 0x00127070, 0x00127470,
		       0x00127870, 0x00127c70, 0x00128070, 0x00128470,
		       0x00128870, 0x00128c70, 0x00129070, 0x00129470,
		       0x00129870, 0x00129c70, 0x0012a070, 0x0012a470,
		       0x0012a870, 0x0012ac70, 0x0012b070, 0x0012b470,
		       0x0012b870, 0x0012bc70, 0x0012c070, 0x0012c470,
		       0x0012c870, 0x0012cc70, 0x0012d070, 0x0012d470,
		       0x0012d870, 0x0012dc70, 0x0012e070, 0x0012e470,
		       0x0012e870, 0x0012ec70, 0x0012f070, 0x0012f470,
		       0x0012f870, 0x0012fc70, 0x00130070, 0x00130470,
		       0x00130870, 0x00130c70, 0x00131070, 0x00131470,
		       0x00131870, 0x00131c70, 0x00132070, 0x00132470,
		       0x00132870, 0x00132c70, 0x00133070, 0x00133470,
		       0x00133870, 0x00133c70, 0x00134070, 0x00134470,
		       0x00134870, 0x00134c70, 0x00135070, 0x00135470,
		       0x00135870, 0x00135c70, 0x00136070, 0x00136470,
		       0x00136870, 0x00136c70, 0x00137070, 0x00137470,
		       0x00137870, 0x00137c70, 0x00138070, 0x00138470,
		       0x00138870, 0x00138c70, 0x00139070, 0x00139470,
		       0x00139870, 0x00139c70, 0x0013a070, 0x0013a470,
		       0x0013a870, 0x0013ac70, 0x0013b070, 0x0013b470,
		       0x0013b870, 0x0013bc70, 0x0013c070, 0x0013c470,
		       0x0013c870, 0x0013cc70, 0x0013d070, 0x0013d470,
		       0x0013d870, 0x0013dc70, 0x0013e070, 0x0013e470,
		       0x0013e870, 0x0013ec70, 0x0013f070, 0x0013f470,
		       0x0013f870, 0x0013fc70, 0x00140070, 0x00140470,
		       0x00140870, 0x00140c70, 0x00141070, 0x00141470,
		       0x00141870, 0x00141c70, 0x00142070, 0x00142470,
		       0x00142870, 0x00142c70, 0x00143070, 0x00143470,
		       0x00143870, 0x00143c70, 0x00144070, 0x00144470,
		       0x00144870, 0x00144c70, 0x00145070, 0x00145470,
		       0x00145870, 0x00145c70, 0x00146070, 0x00146470,
		       0x00146870, 0x00146c70, 0x00147070, 0x00147470,
		       0x00147870, 0x00147c70, 0x00148070, 0x00148470,
		       0x00148870, 0x00148c70, 0x00149070, 0x00149470,
		       0x00149870, 0x00149c70, 0x0014a070, 0x0014a470,
		       0x0014a870, 0x0014ac70, 0x0014b070, 0x0014b470,
		       0x0014b870, 0x0014bc70, 0x0014c070, 0x0014c470,
		       0x0014c870, 0x0014cc70, 0x0014d070, 0x0014d470,
		       0x0014d870, 0x0014dc70, 0x0014e070, 0x0014e470,
		       0x0014e870, 0x0014ec70, 0x0014f070, 0x0014f470,
		       0x0014f870, 0x0014fc70, 0x00150070, 0x00150470,
		       0x00150870, 0x00150c70, 0x00151070, 0x00151470,
		       0x00151870, 0x00151c70, 0x00152070, 0x00152470,
		       0x00152870, 0x00152c70, 0x00153070, 0x00153470,
		       0x00153870, 0x00153c70, 0x00154070, 0x00154470,
		       0x00154870, 0x00154c70, 0x00155070, 0x00155470,
		       0x00155870, 0x00155c70, 0x00156070, 0x00156470,
		       0x00156870, 0x00156c70, 0x00157070, 0x00157470,
		       0x00157870, 0x00157c70, 0x00158070, 0x00158470,
		       0x00158870, 0x00158c70, 0x00159070, 0x00159470,
		       0x00159870, 0x00159c70, 0x0015a070, 0x0015a470,
		       0x0015a870, 0x0015ac70, 0x0015b070, 0x0015b470,
		       0x0015b870, 0x0015bc70, 0x0015c070, 0x0015c470,
		       0x0015c870, 0x0015cc70, 0x0015d070, 0x0015d470,
		       0x0015d870, 0x0015dc70, 0x0015e070, 0x0015e470,
		       0x0015e870, 0x0015ec70, 0x0015f070, 0x0015f470,
		       0x0015f870, 0x0015fc70, 0x00160070, 0x00160470,
		       0x00160870, 0x00160c70, 0x00161070, 0x00161470,
		       0x00161870, 0x00161c70, 0x00162070, 0x00162470,
		       0x00162870, 0x00162c70, 0x00163070, 0x00163470,
		       0x00163870, 0x00163c70, 0x00164070, 0x00164470,
		       0x00164870, 0x00164c70, 0x00165070, 0x00165470,
		       0x00165870, 0x00165c70, 0x00166070, 0x00166470,
		       0x00166870, 0x00166c70, 0x00167070, 0x00167470,
		       0x00167870, 0x00167c70, 0x00168070, 0x00168470,
		       0x00168870, 0x00168c70, 0x00169070, 0x00169470,
		       0x00169870, 0x00169c70, 0x0016a070, 0x0016a470,
		       0x0016a870, 0x0016ac70, 0x0016b070, 0x0016b470,
		       0x0016b870, 0x0016bc70, 0x0016c070, 0x0016c470,
		       0x0016c870, 0x0016cc70, 0x0016d070, 0x0016d470,
		       0x0016d870, 0x0016dc70, 0x0016e070, 0x0016e470,
		       0x0016e870, 0x0016ec70, 0x0016f070, 0x0016f470,
		       0x0016f870, 0x0016fc70, 0x00170070, 0x00170470,
		       0x00170870, 0x00170c70, 0x00171070, 0x00171470,
		       0x00171870, 0x00171c70, 0x00172070, 0x00172470,
		       0x00172870, 0x00172c70, 0x00173070, 0x00173470,
		       0x00173870, 0x00173c70, 0x00174070, 0x00174470,
		       0x00174870, 0x00174c70, 0x00175070, 0x00175470,
		       0x00175870, 0x00175c70, 0x00176070, 0x00176470,
		       0x00176870, 0x00176c70, 0x00177070, 0x00177470,
		       0x00177870, 0x00177c70, 0x00178070, 0x00178470,
		       0x00178870, 0x00178c70, 0x00179070, 0x00179470,
		       0x00179870, 0x00179c70, 0x0017a070, 0x0017a470,
		       0x0017a870, 0x0017ac70, 0x0017b070, 0x0017b470,
		       0x0017b870, 0x0017bc70, 0x0017c070, 0x0017c470,
		       0x0017c870, 0x0017cc70, 0x0017d070, 0x0017d470,
		       0x0017d870, 0x0017dc70, 0x0017e070, 0x0017e470,
		       0x0017e870, 0x0017ec70, 0x0017f070, 0x0017f470,
		       0x0017f870, 0x0017fc70, 0x00180070, 0x00180470,
		       0x00180870, 0x00180c70, 0x00181070, 0x00181470,
		       0x00181870, 0x00181c70, 0x00182070, 0x00182470,
		       0x00182870, 0x00182c70, 0x00183070, 0x00183470,
		       0x00183870, 0x00183c70, 0x00184070, 0x00184470,
		       0x00184870, 0x00184c70, 0x00185070, 0x00185470,
		       0x00185870, 0x00185c70, 0x00186070, 0x00186470,
		       0x00186870, 0x00186c70, 0x00187070, 0x00187470,
		       0x00187870, 0x00187c70, 0x00188070, 0x00188470,
		       0x00188870, 0x00188c70, 0x00189070, 0x00189470,
		       0x00189870, 0x00189c70, 0x0018a070, 0x0018a470,
		       0x0018a870, 0x0018ac70, 0x0018b070, 0x0018b470,
		       0x0018b870, 0x0018bc70, 0x0018c070, 0x0018c470,
		       0x0018c870, 0x0018cc70, 0x0018d070, 0x0018d470,
		       0x0018d870, 0x0018dc70, 0x0018e070, 0x0018e470,
		       0x0018e870, 0x0018ec70, 0x0018f070, 0x0018f470,
		       0x0018f870, 0x0018fc70, 0x00190070, 0x00190470,
		       0x00190870, 0x00190c70, 0x00191070, 0x00191470,
		       0x00191870, 0x00191c70, 0x00192070, 0x00192470,
		       0x00192870, 0x00192c70, 0x00193070, 0x00193470,
		       0x00193870, 0x00193c70, 0x00194070, 0x00194470,
		       0x00194870, 0x00194c70, 0x00195070, 0x00195470,
		       0x00195870, 0x00195c70, 0x00196070, 0x00196470,
		       0x00196870, 0x00196c70, 0x00197070, 0x00197470,
		       0x00197870, 0x00197c70, 0x00198070, 0x00198470,
		       0x00198870, 0x00198c70, 0x00199070, 0x00199470,
		       0x00199870, 0x00199c70, 0x0019a070, 0x0019a470,
		       0x0019a870, 0x0019ac70, 0x0019b070, 0x0019b470,
		       0x0019b870, 0x0019bc70, 0x0019c070, 0x0019c470,
		       0x0019c870, 0x0019cc70, 0x0019d070, 0x0019d470,
		       0x0019d870, 0x0019dc70, 0x0019e070, 0x0019e470,
		       0x0019e870, 0x0019ec70, 0x0019f070, 0x0019f470,
		       0x0019f870, 0x0019fc70, 0x001a0070, 0x001a0470,
		       0x001a0870, 0x001a0c70, 0x001a1070, 0x001a1470,
		       0x001a1870, 0x001a1c70, 0x001a2070, 0x001a2470,
		       0x001a2870, 0x001a2c70, 0x001a3070, 0x001a3470,
		       0x001a3870, 0x001a3c70, 0x001a4070, 0x001a4470,
		       0x001a4870, 0x001a4c70, 0x001a5070, 0x001a5470,
		       0x001a5870, 0x001a5c70, 0x001a6070, 0x001a6470,
		       0x001a6870, 0x001a6c70, 0x001a7070, 0x001a7470,
		       0x001a7870, 0x001a7c70, 0x001a8070, 0x001a8470,
		       0x001a8870, 0x001a8c70, 0x001a9070, 0x001a9470,
		       0x001a9870, 0x001a9c70, 0x001aa070, 0x001aa470,
		       0x001aa870, 0x001aac70, 0x001ab070, 0x001ab470,
		       0x001ab870, 0x001abc70, 0x001ac070, 0x001ac470,
		       0x001ac870, 0x001acc70, 0x001ad070, 0x001ad470,
		       0x001ad870, 0x001adc70, 0x001ae070, 0x001ae470,
		       0x001ae870, 0x001aec70, 0x001af070, 0x001af470,
		       0x001af870, 0x001afc70, 0x001b0070, 0x001b0470,
		       0x001b0870, 0x001b0c70, 0x001b1070, 0x001b1470,
		       0x001b1870, 0x001b1c70, 0x001b2070, 0x001b2470,
		       0x001b2870, 0x001b2c70, 0x001b3070, 0x001b3470,
		       0x001b3870, 0x001b3c70, 0x001b4070, 0x001b4470,
		       0x001b4870, 0x001b4c70, 0x001b5070, 0x001b5470,
		       0x001b5870, 0x001b5c70, 0x001b6070, 0x001b6470,
		       0x001b6870, 0x001b6c70, 0x001b7070, 0x001b7470,
		       0x001b7870, 0x001b7c70, 0x001b8070, 0x001b8470,
		       0x001b8870, 0x001b8c70, 0x001b9070, 0x001b9470,
		       0x001b9870, 0x001b9c70, 0x001ba070, 0x001ba470,
		       0x001ba870, 0x001bac70, 0x001bb070, 0x001bb470,
		       0x001bb870, 0x001bbc70, 0x001bc070, 0x001bc470,
		       0x001bc870, 0x001bcc70, 0x001bd070, 0x001bd470,
		       0x001bd870, 0x001bdc70, 0x001be070, 0x001be470,
		       0x001be870, 0x001bec70, 0x001bf070, 0x001bf470,
		       0x001bf870, 0x001bfc70, 0x001c0070, 0x001c0470,
		       0x001c0870, 0x001c0c70, 0x001c1070, 0x001c1470,
		       0x001c1870, 0x001c1c70, 0x001c2070, 0x001c2470,
		       0x001c2870, 0x001c2c70, 0x001c3070, 0x001c3470,
		       0x001c3870, 0x001c3c70, 0x001c4070, 0x001c4470,
		       0x001c4870, 0x001c4c70, 0x001c5070, 0x001c5470,
		       0x001c5870, 0x001c5c70, 0x001c6070, 0x001c6470,
		       0x001c6870, 0x001c6c70, 0x001c7070, 0x001c7470,
		       0x001c7870, 0x001c7c70, 0x001c8070, 0x001c8470,
		       0x001c8870, 0x001c8c70, 0x001c9070, 0x001c9470,
		       0x001c9870, 0x001c9c70, 0x001ca070, 0x001ca470,
		       0x001ca870, 0x001cac70, 0x001cb070, 0x001cb470,
		       0x001cb870, 0x001cbc70, 0x001cc070, 0x001cc470,
		       0x001cc870, 0x001ccc70, 0x001cd070, 0x001cd470,
		       0x001cd870, 0x001cdc70, 0x001ce070, 0x001ce470,
		       0x001ce870, 0x001cec70, 0x001cf070, 0x001cf470,
		       0x001cf870, 0x001cfc70, 0x001d0070, 0x001d0470,
		       0x001d0870, 0x001d0c70, 0x001d1070, 0x001d1470,
		       0x001d1870, 0x001d1c70, 0x001d2070, 0x001d2470,
		       0x001d2870, 0x001d2c70, 0x001d3070, 0x001d3470,
		       0x001d3870, 0x001d3c70, 0x001d4070, 0x001d4470,
		       0x001d4870, 0x001d4c70, 0x001d5070, 0x001d5470,
		       0x001d5870, 0x001d5c70, 0x001d6070, 0x001d6470,
		       0x001d6870, 0x001d6c70, 0x001d7070, 0x001d7470,
		       0x001d7870, 0x001d7c70, 0x001d8070, 0x001d8470,
		       0x001d8870, 0x001d8c70, 0x001d9070, 0x001d9470,
		       0x001d9870, 0x001d9c70, 0x001da070, 0x001da470,
		       0x001da870, 0x001dac70, 0x001db070, 0x001db470,
		       0x001db870, 0x001dbc70, 0x001dc070, 0x001dc470,
		       0x001dc870, 0x001dcc70, 0x001dd070, 0x001dd470,
		       0x001dd870, 0x001ddc70, 0x001de070, 0x001de470,
		       0x001de870, 0x001dec70, 0x001df070, 0x001df470,
		       0x001df870, 0x001dfc70, 0x001e0070, 0x001e0470,
		       0x001e0870, 0x001e0c70, 0x001e1070, 0x001e1470,
		       0x001e1870, 0x001e1c70, 0x001e2070, 0x001e2470,
		       0x001e2870, 0x001e2c70, 0x001e3070, 0x001e3470,
		       0x001e3870, 0x001e3c70, 0x001e4070, 0x001e4470,
		       0x001e4870, 0x001e4c70, 0x001e5070, 0x001e5470,
		       0x001e5870, 0x001e5c70, 0x001e6070, 0x001e6470,
		       0x001e6870, 0x001e6c70, 0x001e7070, 0x001e7470,
		       0x001e7870, 0x001e7c70, 0x001e8070, 0x001e8470,
		       0x001e8870, 0x001e8c70, 0x001e9070, 0x001e9470,
		       0x001e9870, 0x001e9c70, 0x001ea070, 0x001ea470,
		       0x001ea870, 0x001eac70, 0x001eb070, 0x001eb470,
		       0x001eb870, 0x001ebc70, 0x001ec070, 0x001ec470,
		       0x001ec870, 0x001ecc70, 0x001ed070, 0x001ed470,
		       0x001ed870, 0x001edc70, 0x001ee070, 0x001ee470,
		       0x001ee870, 0x001eec70, 0x001ef070, 0x001ef470,
		       0x001ef870, 0x001efc70, 0x001f0070, 0x001f0470,
		       0x001f0870, 0x001f0c70, 0x001f1070, 0x001f1470,
		       0x001f1870, 0x001f1c70, 0x001f2070, 0x001f2470,
		       0x001f2870, 0x001f2c70, 0x001f3070, 0x001f3470,
		       0x001f3870, 0x001f3c70, 0x001f4070, 0x001f4470,
		       0x001f4870, 0x001f4c70, 0x001f5070, 0x001f5470,
		       0x001f5870, 0x001f5c70, 0x001f6070, 0x001f6470,
		       0x001f6870, 0x001f6c70, 0x001f7070, 0x001f7470,
		       0x001f7870, 0x001f7c70, 0x001f8070, 0x001f8470,
		       0x001f8870, 0x001f8c70, 0x001f9070, 0x001f9470,
		       0x001f9870, 0x001f9c70, 0x001fa070, 0x001fa470,
		       0x001fa870, 0x001fac70, 0x001fb070, 0x001fb470,
		       0x001fb870, 0x001fbc70, 0x001fc070, 0x001fc470,
		       0x001fc870, 0x001fcc70, 0x001fd070, 0x001fd470,
		       0x001fd870, 0x001fdc70, 0x001fe070, 0x001fe470,
		       0x001fe870, 0x001fec70, 0x001ff070, 0x001ff470,
		       0x001ff870, 0x001ffc70, 0x00000270, 0x00000670,
		       0x00000a70, 0x00000e70, 0x00001270, 0x00001670,
		       0x00001a70, 0x00001e70, 0x00002270, 0x00002670,
		       0x00002a70, 0x00002e70, 0x00003270, 0x00003670,
		       0x00003a70, 0x00003e70, 0x00004270, 0x00004670,
		       0x00004a70, 0x00004e70, 0x00005270, 0x00005670,
		       0x00005a70, 0x00005e70, 0x00006270, 0x00006670,
		       0x00006a70, 0x00006e70, 0x00007270, 0x00007670,
		       0x00007a70, 0x00007e70, 0x00008270, 0x00008670,
		       0x00008a70, 0x00008e70, 0x00009270, 0x00009670,
		       0x00009a70, 0x00009e70, 0x0000a270, 0x0000a670,
		       0x0000aa70, 0x0000ae70, 0x0000b270, 0x0000b670,
		       0x0000ba70, 0x0000be70, 0x0000c270, 0x0000c670,
		       0x0000ca70, 0x0000ce70, 0x0000d270, 0x0000d670,
		       0x0000da70, 0x0000de70, 0x0000e270, 0x0000e670,
		       0x0000ea70, 0x0000ee70, 0x0000f270, 0x0000f670,
		       0x0000fa70, 0x0000fe70, 0x00010270, 0x00010670,
		       0x00010a70, 0x00010e70, 0x00011270, 0x00011670,
		       0x00011a70, 0x00011e70, 0x00012270, 0x00012670,
		       0x00012a70, 0x00012e70, 0x00013270, 0x00013670,
		       0x00013a70, 0x00013e70, 0x00014270, 0x00014670,
		       0x00014a70, 0x00014e70, 0x00015270, 0x00015670,
		       0x00015a70, 0x00015e70, 0x00016270, 0x00016670,
		       0x00016a70, 0x00016e70, 0x00017270, 0x00017670,
		       0x00017a70, 0x00017e70, 0x00018270, 0x00018670,
		       0x00018a70, 0x00018e70, 0x00019270, 0x00019670,
		       0x00019a70, 0x00019e70, 0x0001a270, 0x0001a670,
		       0x0001aa70, 0x0001ae70, 0x0001b270, 0x0001b670,
		       0x0001ba70, 0x0001be70, 0x0001c270, 0x0001c670,
		       0x0001ca70, 0x0001ce70, 0x0001d270, 0x0001d670,
		       0x0001da70, 0x0001de70, 0x0001e270, 0x0001e670,
		       0x0001ea70, 0x0001ee70, 0x0001f270, 0x0001f670,
		       0x0001fa70, 0x0001fe70, 0x00020270, 0x00020670,
		       0x00020a70, 0x00020e70, 0x00021270, 0x00021670,
		       0x00021a70, 0x00021e70, 0x00022270, 0x00022670,
		       0x00022a70, 0x00022e70, 0x00023270, 0x00023670,
		       0x00023a70, 0x00023e70, 0x00024270, 0x00024670,
		       0x00024a70, 0x00024e70, 0x00025270, 0x00025670,
		       0x00025a70, 0x00025e70, 0x00026270, 0x00026670,
		       0x00026a70, 0x00026e70, 0x00027270, 0x00027670,
		       0x00027a70, 0x00027e70, 0x00028270, 0x00028670,
		       0x00028a70, 0x00028e70, 0x00029270, 0x00029670,
		       0x00029a70, 0x00029e70, 0x0002a270, 0x0002a670,
		       0x0002aa70, 0x0002ae70, 0x0002b270, 0x0002b670,
		       0x0002ba70, 0x0002be70, 0x0002c270, 0x0002c670,
		       0x0002ca70, 0x0002ce70, 0x0002d270, 0x0002d670,
		       0x0002da70, 0x0002de70, 0x0002e270, 0x0002e670,
		       0x0002ea70, 0x0002ee70, 0x0002f270, 0x0002f670,
		       0x0002fa70, 0x0002fe70, 0x00030270, 0x00030670,
		       0x00030a70, 0x00030e70, 0x00031270, 0x00031670,
		       0x00031a70, 0x00031e70, 0x00032270, 0x00032670,
		       0x00032a70, 0x00032e70, 0x00033270, 0x00033670,
		       0x00033a70, 0x00033e70, 0x00034270, 0x00034670,
		       0x00034a70, 0x00034e70, 0x00035270, 0x00035670,
		       0x00035a70, 0x00035e70, 0x00036270, 0x00036670,
		       0x00036a70, 0x00036e70, 0x00037270, 0x00037670,
		       0x00037a70, 0x00037e70, 0x00038270, 0x00038670,
		       0x00038a70, 0x00038e70, 0x00039270, 0x00039670,
		       0x00039a70, 0x00039e70, 0x0003a270, 0x0003a670,
		       0x0003aa70, 0x0003ae70, 0x0003b270, 0x0003b670,
		       0x0003ba70, 0x0003be70, 0x0003c270, 0x0003c670,
		       0x0003ca70, 0x0003ce70, 0x0003d270, 0x0003d670,
		       0x0003da70, 0x0003de70, 0x0003e270, 0x0003e670,
		       0x0003ea70, 0x0003ee70, 0x0003f270, 0x0003f670,
		       0x0003fa70, 0x0003fe70, 0x00040270, 0x00040670,
		       0x00040a70, 0x00040e70, 0x00041270, 0x00041670,
		       0x00041a70, 0x00041e70, 0x00042270, 0x00042670,
		       0x00042a70, 0x00042e70, 0x00043270, 0x00043670,
		       0x00043a70, 0x00043e70, 0x00044270, 0x00044670,
		       0x00044a70, 0x00044e70, 0x00045270, 0x00045670,
		       0x00045a70, 0x00045e70, 0x00046270, 0x00046670,
		       0x00046a70, 0x00046e70, 0x00047270, 0x00047670,
		       0x00047a70, 0x00047e70, 0x00048270, 0x00048670,
		       0x00048a70, 0x00048e70, 0x00049270, 0x00049670,
		       0x00049a70, 0x00049e70, 0x0004a270, 0x0004a670,
		       0x0004aa70, 0x0004ae70, 0x0004b270, 0x0004b670,
		       0x0004ba70, 0x0004be70, 0x0004c270, 0x0004c670,
		       0x0004ca70, 0x0004ce70, 0x0004d270, 0x0004d670,
		       0x0004da70, 0x0004de70, 0x0004e270, 0x0004e670,
		       0x0004ea70, 0x0004ee70, 0x0004f270, 0x0004f670,
		       0x0004fa70, 0x0004fe70, 0x00050270, 0x00050670,
		       0x00050a70, 0x00050e70, 0x00051270, 0x00051670,
		       0x00051a70, 0x00051e70, 0x00052270, 0x00052670,
		       0x00052a70, 0x00052e70, 0x00053270, 0x00053670,
		       0x00053a70, 0x00053e70, 0x00054270, 0x00054670,
		       0x00054a70, 0x00054e70, 0x00055270, 0x00055670,
		       0x00055a70, 0x00055e70, 0x00056270, 0x00056670,
		       0x00056a70, 0x00056e70, 0x00057270, 0x00057670,
		       0x00057a70, 0x00057e70, 0x00058270, 0x00058670,
		       0x00058a70, 0x00058e70, 0x00059270, 0x00059670,
		       0x00059a70, 0x00059e70, 0x0005a270, 0x0005a670,
		       0x0005aa70, 0x0005ae70, 0x0005b270, 0x0005b670,
		       0x0005ba70, 0x0005be70, 0x0005c270, 0x0005c670,
		       0x0005ca70, 0x0005ce70, 0x0005d270, 0x0005d670,
		       0x0005da70, 0x0005de70, 0x0005e270, 0x0005e670,
		       0x0005ea70, 0x0005ee70, 0x0005f270, 0x0005f670,
		       0x0005fa70, 0x0005fe70, 0x00060270, 0x00060670,
		       0x00060a70, 0x00060e70, 0x00061270, 0x00061670,
		       0x00061a70, 0x00061e70, 0x00062270, 0x00062670,
		       0x00062a70, 0x00062e70, 0x00063270, 0x00063670,
		       0x00063a70, 0x00063e70, 0x00064270, 0x00064670,
		       0x00064a70, 0x00064e70, 0x00065270, 0x00065670,
		       0x00065a70, 0x00065e70, 0x00066270, 0x00066670,
		       0x00066a70, 0x00066e70, 0x00067270, 0x00067670,
		       0x00067a70, 0x00067e70, 0x00068270, 0x00068670,
		       0x00068a70, 0x00068e70, 0x00069270, 0x00069670,
		       0x00069a70, 0x00069e70, 0x0006a270, 0x0006a670,
		       0x0006aa70, 0x0006ae70, 0x0006b270, 0x0006b670,
		       0x0006ba70, 0x0006be70, 0x0006c270, 0x0006c670,
		       0x0006ca70, 0x0006ce70, 0x0006d270, 0x0006d670,
		       0x0006da70, 0x0006de70, 0x0006e270, 0x0006e670,
		       0x0006ea70, 0x0006ee70, 0x0006f270, 0x0006f670,
		       0x0006fa70, 0x0006fe70, 0x00070270, 0x00070670,
		       0x00070a70, 0x00070e70, 0x00071270, 0x00071670,
		       0x00071a70, 0x00071e70, 0x00072270, 0x00072670,
		       0x00072a70, 0x00072e70, 0x00073270, 0x00073670,
		       0x00073a70, 0x00073e70, 0x00074270, 0x00074670,
		       0x00074a70, 0x00074e70, 0x00075270, 0x00075670,
		       0x00075a70, 0x00075e70, 0x00076270, 0x00076670,
		       0x00076a70, 0x00076e70, 0x00077270, 0x00077670,
		       0x00077a70, 0x00077e70, 0x00078270, 0x00078670,
		       0x00078a70, 0x00078e70, 0x00079270, 0x00079670,
		       0x00079a70, 0x00079e70, 0x0007a270, 0x0007a670,
		       0x0007aa70, 0x0007ae70, 0x0007b270, 0x0007b670,
		       0x0007ba70, 0x0007be70, 0x0007c270, 0x0007c670,
		       0x0007ca70, 0x0007ce70, 0x0007d270, 0x0007d670,
		       0x0007da70, 0x0007de70, 0x0007e270, 0x0007e670,
		       0x0007ea70, 0x0007ee70, 0x0007f270, 0x0007f670,
		       0x0007fa70, 0x0007fe70, 0x00080270, 0x00080670,
		       0x00080a70, 0x00080e70, 0x00081270, 0x00081670,
		       0x00081a70, 0x00081e70, 0x00082270, 0x00082670,
		       0x00082a70, 0x00082e70, 0x00083270, 0x00083670,
		       0x00083a70, 0x00083e70, 0x00084270, 0x00084670,
		       0x00084a70, 0x00084e70, 0x00085270, 0x00085670,
		       0x00085a70, 0x00085e70, 0x00086270, 0x00086670,
		       0x00086a70, 0x00086e70, 0x00087270, 0x00087670,
		       0x00087a70, 0x00087e70, 0x00088270, 0x00088670,
		       0x00088a70, 0x00088e70, 0x00089270, 0x00089670,
		       0x00089a70, 0x00089e70, 0x0008a270, 0x0008a670,
		       0x0008aa70, 0x0008ae70, 0x0008b270, 0x0008b670,
		       0x0008ba70, 0x0008be70, 0x0008c270, 0x0008c670,
		       0x0008ca70, 0x0008ce70, 0x0008d270, 0x0008d670,
		       0x0008da70, 0x0008de70, 0x0008e270, 0x0008e670,
		       0x0008ea70, 0x0008ee70, 0x0008f270, 0x0008f670,
		       0x0008fa70, 0x0008fe70, 0x00090270, 0x00090670,
		       0x00090a70, 0x00090e70, 0x00091270, 0x00091670,
		       0x00091a70, 0x00091e70, 0x00092270, 0x00092670,
		       0x00092a70, 0x00092e70, 0x00093270, 0x00093670,
		       0x00093a70, 0x00093e70, 0x00094270, 0x00094670,
		       0x00094a70, 0x00094e70, 0x00095270, 0x00095670,
		       0x00095a70, 0x00095e70, 0x00096270, 0x00096670,
		       0x00096a70, 0x00096e70, 0x00097270, 0x00097670,
		       0x00097a70, 0x00097e70, 0x00098270, 0x00098670,
		       0x00098a70, 0x00098e70, 0x00099270, 0x00099670,
		       0x00099a70, 0x00099e70, 0x0009a270, 0x0009a670,
		       0x0009aa70, 0x0009ae70, 0x0009b270, 0x0009b670,
		       0x0009ba70, 0x0009be70, 0x0009c270, 0x0009c670,
		       0x0009ca70, 0x0009ce70, 0x0009d270, 0x0009d670,
		       0x0009da70, 0x0009de70, 0x0009e270, 0x0009e670,
		       0x0009ea70, 0x0009ee70, 0x0009f270, 0x0009f670,
		       0x0009fa70, 0x0009fe70, 0x000a0270, 0x000a0670,
		       0x000a0a70, 0x000a0e70, 0x000a1270, 0x000a1670,
		       0x000a1a70, 0x000a1e70, 0x000a2270, 0x000a2670,
		       0x000a2a70, 0x000a2e70, 0x000a3270, 0x000a3670,
		       0x000a3a70, 0x000a3e70, 0x000a4270, 0x000a4670,
		       0x000a4a70, 0x000a4e70, 0x000a5270, 0x000a5670,
		       0x000a5a70, 0x000a5e70, 0x000a6270, 0x000a6670,
		       0x000a6a70, 0x000a6e70, 0x000a7270, 0x000a7670,
		       0x000a7a70, 0x000a7e70, 0x000a8270, 0x000a8670,
		       0x000a8a70, 0x000a8e70, 0x000a9270, 0x000a9670,
		       0x000a9a70, 0x000a9e70, 0x000aa270, 0x000aa670,
		       0x000aaa70, 0x000aae70, 0x000ab270, 0x000ab670,
		       0x000aba70, 0x000abe70, 0x000ac270, 0x000ac670,
		       0x000aca70, 0x000ace70, 0x000ad270, 0x000ad670,
		       0x000ada70, 0x000ade70, 0x000ae270, 0x000ae670,
		       0x000aea70, 0x000aee70, 0x000af270, 0x000af670,
		       0x000afa70, 0x000afe70, 0x000b0270, 0x000b0670,
		       0x000b0a70, 0x000b0e70, 0x000b1270, 0x000b1670,
		       0x000b1a70, 0x000b1e70, 0x000b2270, 0x000b2670,
		       0x000b2a70, 0x000b2e70, 0x000b3270, 0x000b3670,
		       0x000b3a70, 0x000b3e70, 0x000b4270, 0x000b4670,
		       0x000b4a70, 0x000b4e70, 0x000b5270, 0x000b5670,
		       0x000b5a70, 0x000b5e70, 0x000b6270, 0x000b6670,
		       0x000b6a70, 0x000b6e70, 0x000b7270, 0x000b7670,
		       0x000b7a70, 0x000b7e70, 0x000b8270, 0x000b8670,
		       0x000b8a70, 0x000b8e70, 0x000b9270, 0x000b9670,
		       0x000b9a70, 0x000b9e70, 0x000ba270, 0x000ba670,
		       0x000baa70, 0x000bae70, 0x000bb270, 0x000bb670,
		       0x000bba70, 0x000bbe70, 0x000bc270, 0x000bc670,
		       0x000bca70, 0x000bce70, 0x000bd270, 0x000bd670,
		       0x000bda70, 0x000bde70, 0x000be270, 0x000be670,
		       0x000bea70, 0x000bee70, 0x000bf270, 0x000bf670,
		       0x000bfa70, 0x000bfe70, 0x000c0270, 0x000c0670,
		       0x000c0a70, 0x000c0e70, 0x000c1270, 0x000c1670,
		       0x000c1a70, 0x000c1e70, 0x000c2270, 0x000c2670,
		       0x000c2a70, 0x000c2e70, 0x000c3270, 0x000c3670,
		       0x000c3a70, 0x000c3e70, 0x000c4270, 0x000c4670,
		       0x000c4a70, 0x000c4e70, 0x000c5270, 0x000c5670,
		       0x000c5a70, 0x000c5e70, 0x000c6270, 0x000c6670,
		       0x000c6a70, 0x000c6e70, 0x000c7270, 0x000c7670,
		       0x000c7a70, 0x000c7e70, 0x000c8270, 0x000c8670,
		       0x000c8a70, 0x000c8e70, 0x000c9270, 0x000c9670,
		       0x000c9a70, 0x000c9e70, 0x000ca270, 0x000ca670,
		       0x000caa70, 0x000cae70, 0x000cb270, 0x000cb670,
		       0x000cba70, 0x000cbe70, 0x000cc270, 0x000cc670,
		       0x000cca70, 0x000cce70, 0x000cd270, 0x000cd670,
		       0x000cda70, 0x000cde70, 0x000ce270, 0x000ce670,
		       0x000cea70, 0x000cee70, 0x000cf270, 0x000cf670,
		       0x000cfa70, 0x000cfe70, 0x000d0270, 0x000d0670,
		       0x000d0a70, 0x000d0e70, 0x000d1270, 0x000d1670,
		       0x000d1a70, 0x000d1e70, 0x000d2270, 0x000d2670,
		       0x000d2a70, 0x000d2e70, 0x000d3270, 0x000d3670,
		       0x000d3a70, 0x000d3e70, 0x000d4270, 0x000d4670,
		       0x000d4a70, 0x000d4e70, 0x000d5270, 0x000d5670,
		       0x000d5a70, 0x000d5e70, 0x000d6270, 0x000d6670,
		       0x000d6a70, 0x000d6e70, 0x000d7270, 0x000d7670,
		       0x000d7a70, 0x000d7e70, 0x000d8270, 0x000d8670,
		       0x000d8a70, 0x000d8e70, 0x000d9270, 0x000d9670,
		       0x000d9a70, 0x000d9e70, 0x000da270, 0x000da670,
		       0x000daa70, 0x000dae70, 0x000db270, 0x000db670,
		       0x000dba70, 0x000dbe70, 0x000dc270, 0x000dc670,
		       0x000dca70, 0x000dce70, 0x000dd270, 0x000dd670,
		       0x000dda70, 0x000dde70, 0x000de270, 0x000de670,
		       0x000dea70, 0x000dee70, 0x000df270, 0x000df670,
		       0x000dfa70, 0x000dfe70, 0x000e0270, 0x000e0670,
		       0x000e0a70, 0x000e0e70, 0x000e1270, 0x000e1670,
		       0x000e1a70, 0x000e1e70, 0x000e2270, 0x000e2670,
		       0x000e2a70, 0x000e2e70, 0x000e3270, 0x000e3670,
		       0x000e3a70, 0x000e3e70, 0x000e4270, 0x000e4670,
		       0x000e4a70, 0x000e4e70, 0x000e5270, 0x000e5670,
		       0x000e5a70, 0x000e5e70, 0x000e6270, 0x000e6670,
		       0x000e6a70, 0x000e6e70, 0x000e7270, 0x000e7670,
		       0x000e7a70, 0x000e7e70, 0x000e8270, 0x000e8670,
		       0x000e8a70, 0x000e8e70, 0x000e9270, 0x000e9670,
		       0x000e9a70, 0x000e9e70, 0x000ea270, 0x000ea670,
		       0x000eaa70, 0x000eae70, 0x000eb270, 0x000eb670,
		       0x000eba70, 0x000ebe70, 0x000ec270, 0x000ec670,
		       0x000eca70, 0x000ece70, 0x000ed270, 0x000ed670,
		       0x000eda70, 0x000ede70, 0x000ee270, 0x000ee670,
		       0x000eea70, 0x000eee70, 0x000ef270, 0x000ef670,
		       0x000efa70, 0x000efe70, 0x000f0270, 0x000f0670,
		       0x000f0a70, 0x000f0e70, 0x000f1270, 0x000f1670,
		       0x000f1a70, 0x000f1e70, 0x000f2270, 0x000f2670,
		       0x000f2a70, 0x000f2e70, 0x000f3270, 0x000f3670,
		       0x000f3a70, 0x000f3e70, 0x000f4270, 0x000f4670,
		       0x000f4a70, 0x000f4e70, 0x000f5270, 0x000f5670,
		       0x000f5a70, 0x000f5e70, 0x000f6270, 0x000f6670,
		       0x000f6a70, 0x000f6e70, 0x000f7270, 0x000f7670,
		       0x000f7a70, 0x000f7e70, 0x000f8270, 0x000f8670,
		       0x000f8a70, 0x000f8e70, 0x000f9270, 0x000f9670,
		       0x000f9a70, 0x000f9e70, 0x000fa270, 0x000fa670,
		       0x000faa70, 0x000fae70, 0x000fb270, 0x000fb670,
		       0x000fba70, 0x000fbe70, 0x000fc270, 0x000fc670,
		       0x000fca70, 0x000fce70, 0x000fd270, 0x000fd670,
		       0x000fda70, 0x000fde70, 0x000fe270, 0x000fe670,
		       0x000fea70, 0x000fee70, 0x000ff270, 0x000ff670,
		       0x000ffa70, 0x000ffe70, 0x00100270, 0x00100670,
		       0x00100a70, 0x00100e70, 0x00101270, 0x00101670,
		       0x00101a70, 0x00101e70, 0x00102270, 0x00102670,
		       0x00102a70, 0x00102e70, 0x00103270, 0x00103670,
		       0x00103a70, 0x00103e70, 0x00104270, 0x00104670,
		       0x00104a70, 0x00104e70, 0x00105270, 0x00105670,
		       0x00105a70, 0x00105e70, 0x00106270, 0x00106670,
		       0x00106a70, 0x00106e70, 0x00107270, 0x00107670,
		       0x00107a70, 0x00107e70, 0x00108270, 0x00108670,
		       0x00108a70, 0x00108e70, 0x00109270, 0x00109670,
		       0x00109a70, 0x00109e70, 0x0010a270, 0x0010a670,
		       0x0010aa70, 0x0010ae70, 0x0010b270, 0x0010b670,
		       0x0010ba70, 0x0010be70, 0x0010c270, 0x0010c670,
		       0x0010ca70, 0x0010ce70, 0x0010d270, 0x0010d670,
		       0x0010da70, 0x0010de70, 0x0010e270, 0x0010e670,
		       0x0010ea70, 0x0010ee70, 0x0010f270, 0x0010f670,
		       0x0010fa70, 0x0010fe70, 0x00110270, 0x00110670,
		       0x00110a70, 0x00110e70, 0x00111270, 0x00111670,
		       0x00111a70, 0x00111e70, 0x00112270, 0x00112670,
		       0x00112a70, 0x00112e70, 0x00113270, 0x00113670,
		       0x00113a70, 0x00113e70, 0x00114270, 0x00114670,
		       0x00114a70, 0x00114e70, 0x00115270, 0x00115670,
		       0x00115a70, 0x00115e70, 0x00116270, 0x00116670,
		       0x00116a70, 0x00116e70, 0x00117270, 0x00117670,
		       0x00117a70, 0x00117e70, 0x00118270, 0x00118670,
		       0x00118a70, 0x00118e70, 0x00119270, 0x00119670,
		       0x00119a70, 0x00119e70, 0x0011a270, 0x0011a670,
		       0x0011aa70, 0x0011ae70, 0x0011b270, 0x0011b670,
		       0x0011ba70, 0x0011be70, 0x0011c270, 0x0011c670,
		       0x0011ca70, 0x0011ce70, 0x0011d270, 0x0011d670,
		       0x0011da70, 0x0011de70, 0x0011e270, 0x0011e670,
		       0x0011ea70, 0x0011ee70, 0x0011f270, 0x0011f670,
		       0x0011fa70, 0x0011fe70, 0x00120270, 0x00120670,
		       0x00120a70, 0x00120e70, 0x00121270, 0x00121670,
		       0x00121a70, 0x00121e70, 0x00122270, 0x00122670,
		       0x00122a70, 0x00122e70, 0x00123270, 0x00123670,
		       0x00123a70, 0x00123e70, 0x00124270, 0x00124670,
		       0x00124a70, 0x00124e70, 0x00125270, 0x00125670,
		       0x00125a70, 0x00125e70, 0x00126270, 0x00126670,
		       0x00126a70, 0x00126e70, 0x00127270, 0x00127670,
		       0x00127a70, 0x00127e70, 0x00128270, 0x00128670,
		       0x00128a70, 0x00128e70, 0x00129270, 0x00129670,
		       0x00129a70, 0x00129e70, 0x0012a270, 0x0012a670,
		       0x0012aa70, 0x0012ae70, 0x0012b270, 0x0012b670,
		       0x0012ba70, 0x0012be70, 0x0012c270, 0x0012c670,
		       0x0012ca70, 0x0012ce70, 0x0012d270, 0x0012d670,
		       0x0012da70, 0x0012de70, 0x0012e270, 0x0012e670,
		       0x0012ea70, 0x0012ee70, 0x0012f270, 0x0012f670,
		       0x0012fa70, 0x0012fe70, 0x00130270, 0x00130670,
		       0x00130a70, 0x00130e70, 0x00131270, 0x00131670,
		       0x00131a70, 0x00131e70, 0x00132270, 0x00132670,
		       0x00132a70, 0x00132e70, 0x00133270, 0x00133670,
		       0x00133a70, 0x00133e70, 0x00134270, 0x00134670,
		       0x00134a70, 0x00134e70, 0x00135270, 0x00135670,
		       0x00135a70, 0x00135e70, 0x00136270, 0x00136670,
		       0x00136a70, 0x00136e70, 0x00137270, 0x00137670,
		       0x00137a70, 0x00137e70, 0x00138270, 0x00138670,
		       0x00138a70, 0x00138e70, 0x00139270, 0x00139670,
		       0x00139a70, 0x00139e70, 0x0013a270, 0x0013a670,
		       0x0013aa70, 0x0013ae70, 0x0013b270, 0x0013b670,
		       0x0013ba70, 0x0013be70, 0x0013c270, 0x0013c670,
		       0x0013ca70, 0x0013ce70, 0x0013d270, 0x0013d670,
		       0x0013da70, 0x0013de70, 0x0013e270, 0x0013e670,
		       0x0013ea70, 0x0013ee70, 0x0013f270, 0x0013f670,
		       0x0013fa70, 0x0013fe70, 0x00140270, 0x00140670,
		       0x00140a70, 0x00140e70, 0x00141270, 0x00141670,
		       0x00141a70, 0x00141e70, 0x00142270, 0x00142670,
		       0x00142a70, 0x00142e70, 0x00143270, 0x00143670,
		       0x00143a70, 0x00143e70, 0x00144270, 0x00144670,
		       0x00144a70, 0x00144e70, 0x00145270, 0x00145670,
		       0x00145a70, 0x00145e70, 0x00146270, 0x00146670,
		       0x00146a70, 0x00146e70, 0x00147270, 0x00147670,
		       0x00147a70, 0x00147e70, 0x00148270, 0x00148670,
		       0x00148a70, 0x00148e70, 0x00149270, 0x00149670,
		       0x00149a70, 0x00149e70, 0x0014a270, 0x0014a670,
		       0x0014aa70, 0x0014ae70, 0x0014b270, 0x0014b670,
		       0x0014ba70, 0x0014be70, 0x0014c270, 0x0014c670,
		       0x0014ca70, 0x0014ce70, 0x0014d270, 0x0014d670,
		       0x0014da70, 0x0014de70, 0x0014e270, 0x0014e670,
		       0x0014ea70, 0x0014ee70, 0x0014f270, 0x0014f670,
		       0x0014fa70, 0x0014fe70, 0x00150270, 0x00150670,
		       0x00150a70, 0x00150e70, 0x00151270, 0x00151670,
		       0x00151a70, 0x00151e70, 0x00152270, 0x00152670,
		       0x00152a70, 0x00152e70, 0x00153270, 0x00153670,
		       0x00153a70, 0x00153e70, 0x00154270, 0x00154670,
		       0x00154a70, 0x00154e70, 0x00155270, 0x00155670,
		       0x00155a70, 0x00155e70, 0x00156270, 0x00156670,
		       0x00156a70, 0x00156e70, 0x00157270, 0x00157670,
		       0x00157a70, 0x00157e70, 0x00158270, 0x00158670,
		       0x00158a70, 0x00158e70, 0x00159270, 0x00159670,
		       0x00159a70, 0x00159e70, 0x0015a270, 0x0015a670,
		       0x0015aa70, 0x0015ae70, 0x0015b270, 0x0015b670,
		       0x0015ba70, 0x0015be70, 0x0015c270, 0x0015c670,
		       0x0015ca70, 0x0015ce70, 0x0015d270, 0x0015d670,
		       0x0015da70, 0x0015de70, 0x0015e270, 0x0015e670,
		       0x0015ea70, 0x0015ee70, 0x0015f270, 0x0015f670,
		       0x0015fa70, 0x0015fe70, 0x00160270, 0x00160670,
		       0x00160a70, 0x00160e70, 0x00161270, 0x00161670,
		       0x00161a70, 0x00161e70, 0x00162270, 0x00162670,
		       0x00162a70, 0x00162e70, 0x00163270, 0x00163670,
		       0x00163a70, 0x00163e70, 0x00164270, 0x00164670,
		       0x00164a70, 0x00164e70, 0x00165270, 0x00165670,
		       0x00165a70, 0x00165e70, 0x00166270, 0x00166670,
		       0x00166a70, 0x00166e70, 0x00167270, 0x00167670,
		       0x00167a70, 0x00167e70, 0x00168270, 0x00168670,
		       0x00168a70, 0x00168e70, 0x00169270, 0x00169670,
		       0x00169a70, 0x00169e70, 0x0016a270, 0x0016a670,
		       0x0016aa70, 0x0016ae70, 0x0016b270, 0x0016b670,
		       0x0016ba70, 0x0016be70, 0x0016c270, 0x0016c670,
		       0x0016ca70, 0x0016ce70, 0x0016d270, 0x0016d670,
		       0x0016da70, 0x0016de70, 0x0016e270, 0x0016e670,
		       0x0016ea70, 0x0016ee70, 0x0016f270, 0x0016f670,
		       0x0016fa70, 0x0016fe70, 0x00170270, 0x00170670,
		       0x00170a70, 0x00170e70, 0x00171270, 0x00171670,
		       0x00171a70, 0x00171e70, 0x00172270, 0x00172670,
		       0x00172a70, 0x00172e70, 0x00173270, 0x00173670,
		       0x00173a70, 0x00173e70, 0x00174270, 0x00174670,
		       0x00174a70, 0x00174e70, 0x00175270, 0x00175670,
		       0x00175a70, 0x00175e70, 0x00176270, 0x00176670,
		       0x00176a70, 0x00176e70, 0x00177270, 0x00177670,
		       0x00177a70, 0x00177e70, 0x00178270, 0x00178670,
		       0x00178a70, 0x00178e70, 0x00179270, 0x00179670,
		       0x00179a70, 0x00179e70, 0x0017a270, 0x0017a670,
		       0x0017aa70, 0x0017ae70, 0x0017b270, 0x0017b670,
		       0x0017ba70, 0x0017be70, 0x0017c270, 0x0017c670,
		       0x0017ca70, 0x0017ce70, 0x0017d270, 0x0017d670,
		       0x0017da70, 0x0017de70, 0x0017e270, 0x0017e670,
		       0x0017ea70, 0x0017ee70, 0x0017f270, 0x0017f670,
		       0x0017fa70, 0x0017fe70, 0x00180270, 0x00180670,
		       0x00180a70, 0x00180e70, 0x00181270, 0x00181670,
		       0x00181a70, 0x00181e70, 0x00182270, 0x00182670,
		       0x00182a70, 0x00182e70, 0x00183270, 0x00183670,
		       0x00183a70, 0x00183e70, 0x00184270, 0x00184670,
		       0x00184a70, 0x00184e70, 0x00185270, 0x00185670,
		       0x00185a70, 0x00185e70, 0x00186270, 0x00186670,
		       0x00186a70, 0x00186e70, 0x00187270, 0x00187670,
		       0x00187a70, 0x00187e70, 0x00188270, 0x00188670,
		       0x00188a70, 0x00188e70, 0x00189270, 0x00189670,
		       0x00189a70, 0x00189e70, 0x0018a270, 0x0018a670,
		       0x0018aa70, 0x0018ae70, 0x0018b270, 0x0018b670,
		       0x0018ba70, 0x0018be70, 0x0018c270, 0x0018c670,
		       0x0018ca70, 0x0018ce70, 0x0018d270, 0x0018d670,
		       0x0018da70, 0x0018de70, 0x0018e270, 0x0018e670,
		       0x0018ea70, 0x0018ee70, 0x0018f270, 0x0018f670,
		       0x0018fa70, 0x0018fe70, 0x00190270, 0x00190670,
		       0x00190a70, 0x00190e70, 0x00191270, 0x00191670,
		       0x00191a70, 0x00191e70, 0x00192270, 0x00192670,
		       0x00192a70, 0x00192e70, 0x00193270, 0x00193670,
		       0x00193a70, 0x00193e70, 0x00194270, 0x00194670,
		       0x00194a70, 0x00194e70, 0x00195270, 0x00195670,
		       0x00195a70, 0x00195e70, 0x00196270, 0x00196670,
		       0x00196a70, 0x00196e70, 0x00197270, 0x00197670,
		       0x00197a70, 0x00197e70, 0x00198270, 0x00198670,
		       0x00198a70, 0x00198e70, 0x00199270, 0x00199670,
		       0x00199a70, 0x00199e70, 0x0019a270, 0x0019a670,
		       0x0019aa70, 0x0019ae70, 0x0019b270, 0x0019b670,
		       0x0019ba70, 0x0019be70, 0x0019c270, 0x0019c670,
		       0x0019ca70, 0x0019ce70, 0x0019d270, 0x0019d670,
		       0x0019da70, 0x0019de70, 0x0019e270, 0x0019e670,
		       0x0019ea70, 0x0019ee70, 0x0019f270, 0x0019f670,
		       0x0019fa70, 0x0019fe70, 0x001a0270, 0x001a0670,
		       0x001a0a70, 0x001a0e70, 0x001a1270, 0x001a1670,
		       0x001a1a70, 0x001a1e70, 0x001a2270, 0x001a2670,
		       0x001a2a70, 0x001a2e70, 0x001a3270, 0x001a3670,
		       0x001a3a70, 0x001a3e70, 0x001a4270, 0x001a4670,
		       0x001a4a70, 0x001a4e70, 0x001a5270, 0x001a5670,
		       0x001a5a70, 0x001a5e70, 0x001a6270, 0x001a6670,
		       0x001a6a70, 0x001a6e70, 0x001a7270, 0x001a7670,
		       0x001a7a70, 0x001a7e70, 0x001a8270, 0x001a8670,
		       0x001a8a70, 0x001a8e70, 0x001a9270, 0x001a9670,
		       0x001a9a70, 0x001a9e70, 0x001aa270, 0x001aa670,
		       0x001aaa70, 0x001aae70, 0x001ab270, 0x001ab670,
		       0x001aba70, 0x001abe70, 0x001ac270, 0x001ac670,
		       0x001aca70, 0x001ace70, 0x001ad270, 0x001ad670,
		       0x001ada70, 0x001ade70, 0x001ae270, 0x001ae670,
		       0x001aea70, 0x001aee70, 0x001af270, 0x001af670,
		       0x001afa70, 0x001afe70, 0x001b0270, 0x001b0670,
		       0x001b0a70, 0x001b0e70, 0x001b1270, 0x001b1670,
		       0x001b1a70, 0x001b1e70, 0x001b2270, 0x001b2670,
		       0x001b2a70, 0x001b2e70, 0x001b3270, 0x001b3670,
		       0x001b3a70, 0x001b3e70, 0x001b4270, 0x001b4670,
		       0x001b4a70, 0x001b4e70, 0x001b5270, 0x001b5670,
		       0x001b5a70, 0x001b5e70, 0x001b6270, 0x001b6670,
		       0x001b6a70, 0x001b6e70, 0x001b7270, 0x001b7670,
		       0x001b7a70, 0x001b7e70, 0x001b8270, 0x001b8670,
		       0x001b8a70, 0x001b8e70, 0x001b9270, 0x001b9670,
		       0x001b9a70, 0x001b9e70, 0x001ba270, 0x001ba670,
		       0x001baa70, 0x001bae70, 0x001bb270, 0x001bb670,
		       0x001bba70, 0x001bbe70, 0x001bc270, 0x001bc670,
		       0x001bca70, 0x001bce70, 0x001bd270, 0x001bd670,
		       0x001bda70, 0x001bde70, 0x001be270, 0x001be670,
		       0x001bea70, 0x001bee70, 0x001bf270, 0x001bf670,
		       0x001bfa70, 0x001bfe70, 0x001c0270, 0x001c0670,
		       0x001c0a70, 0x001c0e70, 0x001c1270, 0x001c1670,
		       0x001c1a70, 0x001c1e70, 0x001c2270, 0x001c2670,
		       0x001c2a70, 0x001c2e70, 0x001c3270, 0x001c3670,
		       0x001c3a70, 0x001c3e70, 0x001c4270, 0x001c4670,
		       0x001c4a70, 0x001c4e70, 0x001c5270, 0x001c5670,
		       0x001c5a70, 0x001c5e70, 0x001c6270, 0x001c6670,
		       0x001c6a70, 0x001c6e70, 0x001c7270, 0x001c7670,
		       0x001c7a70, 0x001c7e70, 0x001c8270, 0x001c8670,
		       0x001c8a70, 0x001c8e70, 0x001c9270, 0x001c9670,
		       0x001c9a70, 0x001c9e70, 0x001ca270, 0x001ca670,
		       0x001caa70, 0x001cae70, 0x001cb270, 0x001cb670,
		       0x001cba70, 0x001cbe70, 0x001cc270, 0x001cc670,
		       0x001cca70, 0x001cce70, 0x001cd270, 0x001cd670,
		       0x001cda70, 0x001cde70, 0x001ce270, 0x001ce670,
		       0x001cea70, 0x001cee70, 0x001cf270, 0x001cf670,
		       0x001cfa70, 0x001cfe70, 0x001d0270, 0x001d0670,
		       0x001d0a70, 0x001d0e70, 0x001d1270, 0x001d1670,
		       0x001d1a70, 0x001d1e70, 0x001d2270, 0x001d2670,
		       0x001d2a70, 0x001d2e70, 0x001d3270, 0x001d3670,
		       0x001d3a70, 0x001d3e70, 0x001d4270, 0x001d4670,
		       0x001d4a70, 0x001d4e70, 0x001d5270, 0x001d5670,
		       0x001d5a70, 0x001d5e70, 0x001d6270, 0x001d6670,
		       0x001d6a70, 0x001d6e70, 0x001d7270, 0x001d7670,
		       0x001d7a70, 0x001d7e70, 0x001d8270, 0x001d8670,
		       0x001d8a70, 0x001d8e70, 0x001d9270, 0x001d9670,
		       0x001d9a70, 0x001d9e70, 0x001da270, 0x001da670,
		       0x001daa70, 0x001dae70, 0x001db270, 0x001db670,
		       0x001dba70, 0x001dbe70, 0x001dc270, 0x001dc670,
		       0x001dca70, 0x001dce70, 0x001dd270, 0x001dd670,
		       0x001dda70, 0x001dde70, 0x001de270, 0x001de670,
		       0x001dea70, 0x001dee70, 0x001df270, 0x001df670,
		       0x001dfa70, 0x001dfe70, 0x001e0270, 0x001e0670,
		       0x001e0a70, 0x001e0e70, 0x001e1270, 0x001e1670,
		       0x001e1a70, 0x001e1e70, 0x001e2270, 0x001e2670,
		       0x001e2a70, 0x001e2e70, 0x001e3270, 0x001e3670,
		       0x001e3a70, 0x001e3e70, 0x001e4270, 0x001e4670,
		       0x001e4a70, 0x001e4e70, 0x001e5270, 0x001e5670,
		       0x001e5a70, 0x001e5e70, 0x001e6270, 0x001e6670,
		       0x001e6a70, 0x001e6e70, 0x001e7270, 0x001e7670,
		       0x001e7a70, 0x001e7e70, 0x001e8270, 0x001e8670,
		       0x001e8a70, 0x001e8e70, 0x001e9270, 0x001e9670,
		       0x001e9a70, 0x001e9e70, 0x001ea270, 0x001ea670,
		       0x001eaa70, 0x001eae70, 0x001eb270, 0x001eb670,
		       0x001eba70, 0x001ebe70, 0x001ec270, 0x001ec670,
		       0x001eca70, 0x001ece70, 0x001ed270, 0x001ed670,
		       0x001eda70, 0x001ede70, 0x001ee270, 0x001ee670,
		       0x001eea70, 0x001eee70, 0x001ef270, 0x001ef670,
		       0x001efa70, 0x001efe70, 0x001f0270, 0x001f0670,
		       0x001f0a70, 0x001f0e70, 0x001f1270, 0x001f1670,
		       0x001f1a70, 0x001f1e70, 0x001f2270, 0x001f2670,
		       0x001f2a70, 0x001f2e70, 0x001f3270, 0x001f3670,
		       0x001f3a70, 0x001f3e70, 0x001f4270, 0x001f4670,
		       0x001f4a70, 0x001f4e70, 0x001f5270, 0x001f5670,
		       0x001f5a70, 0x001f5e70, 0x001f6270, 0x001f6670,
		       0x001f6a70, 0x001f6e70, 0x001f7270, 0x001f7670,
		       0x001f7a70, 0x001f7e70, 0x001f8270, 0x001f8670,
		       0x001f8a70, 0x001f8e70, 0x001f9270, 0x001f9670,
		       0x001f9a70, 0x001f9e70, 0x001fa270, 0x001fa670,
		       0x001faa70, 0x001fae70, 0x001fb270, 0x001fb670,
		       0x001fba70, 0x001fbe70, 0x001fc270, 0x001fc670,
		       0x001fca70, 0x001fce70, 0x001fd270, 0x001fd670,
		       0x001fda70, 0x001fde70, 0x001fe270, 0x001fe670,
		       0x001fea70, 0x001fee70, 0x001ff270, 0x001ff670,
		       0x001ffa70, 0x001ffe70
#endif /* LONGER_HUFFTABLE */
		       },

	.len_table = {
		      0x00000807, 0x00000407, 0x00000c07, 0x00000207,
		      0x00000a07, 0x00000607, 0x00000e07, 0x00000107,
		      0x00000908, 0x00001908, 0x00000508, 0x00001508,
		      0x00000d08, 0x00001d08, 0x00000308, 0x00001308,
		      0x00000b09, 0x00001b09, 0x00002b09, 0x00003b09,
		      0x00000709, 0x00001709, 0x00002709, 0x00003709,
		      0x00000f09, 0x00001f09, 0x00002f09, 0x00003f09,
		      0x00000089, 0x00001089, 0x00002089, 0x00003089,
		      0x0000088a, 0x0000188a, 0x0000288a, 0x0000388a,
		      0x0000488a, 0x0000588a, 0x0000688a, 0x0000788a,
		      0x0000048a, 0x0000148a, 0x0000248a, 0x0000348a,
		      0x0000448a, 0x0000548a, 0x0000648a, 0x0000748a,
		      0x00000c8a, 0x00001c8a, 0x00002c8a, 0x00003c8a,
		      0x00004c8a, 0x00005c8a, 0x00006c8a, 0x00007c8a,
		      0x0000028a, 0x0000128a, 0x0000228a, 0x0000328a,
		      0x0000428a, 0x0000528a, 0x0000628a, 0x0000728a,
		      0x00000a8b, 0x00001a8b, 0x00002a8b, 0x00003a8b,
		      0x00004a8b, 0x00005a8b, 0x00006a8b, 0x00007a8b,
		      0x00008a8b, 0x00009a8b, 0x0000aa8b, 0x0000ba8b,
		      0x0000ca8b, 0x0000da8b, 0x0000ea8b, 0x0000fa8b,
		      0x0000068b, 0x0000168b, 0x0000268b, 0x0000368b,
		      0x0000468b, 0x0000568b, 0x0000668b, 0x0000768b,
		      0x0000868b, 0x0000968b, 0x0000a68b, 0x0000b68b,
		      0x0000c68b, 0x0000d68b, 0x0000e68b, 0x0000f68b,
		      0x00000e8b, 0x00001e8b, 0x00002e8b, 0x00003e8b,
		      0x00004e8b, 0x00005e8b, 0x00006e8b, 0x00007e8b,
		      0x00008e8b, 0x00009e8b, 0x0000ae8b, 0x0000be8b,
		      0x0000ce8b, 0x0000de8b, 0x0000ee8b, 0x0000fe8b,
		      0x0000006c, 0x0000206c, 0x0000406c, 0x0000606c,
		      0x0000806c, 0x0000a06c, 0x0000c06c, 0x0000e06c,
		      0x0001006c, 0x0001206c, 0x0001406c, 0x0001606c,
		      0x0001806c, 0x0001a06c, 0x0001c06c, 0x0001e06c,
		      0x0000106d, 0x0000306d, 0x0000506d, 0x0000706d,
		      0x0000906d, 0x0000b06d, 0x0000d06d, 0x0000f06d,
		      0x0001106d, 0x0001306d, 0x0001506d, 0x0001706d,
		      0x0001906d, 0x0001b06d, 0x0001d06d, 0x0001f06d,
		      0x0002106d, 0x0002306d, 0x0002506d, 0x0002706d,
		      0x0002906d, 0x0002b06d, 0x0002d06d, 0x0002f06d,
		      0x0003106d, 0x0003306d, 0x0003506d, 0x0003706d,
		      0x0003906d, 0x0003b06d, 0x0003d06d, 0x0003f06d,
		      0x0000086d, 0x0000286d, 0x0000486d, 0x0000686d,
		      0x0000886d, 0x0000a86d, 0x0000c86d, 0x0000e86d,
		      0x0001086d, 0x0001286d, 0x0001486d, 0x0001686d,
		      0x0001886d, 0x0001a86d, 0x0001c86d, 0x0001e86d,
		      0x0002086d, 0x0002286d, 0x0002486d, 0x0002686d,
		      0x0002886d, 0x0002a86d, 0x0002c86d, 0x0002e86d,
		      0x0003086d, 0x0003286d, 0x0003486d, 0x0003686d,
		      0x0003886d, 0x0003a86d, 0x0003c86d, 0x0003e86d,
		      0x0000186d, 0x0000386d, 0x0000586d, 0x0000786d,
		      0x0000986d, 0x0000b86d, 0x0000d86d, 0x0000f86d,
		      0x0001186d, 0x0001386d, 0x0001586d, 0x0001786d,
		      0x0001986d, 0x0001b86d, 0x0001d86d, 0x0001f86d,
		      0x0002186d, 0x0002386d, 0x0002586d, 0x0002786d,
		      0x0002986d, 0x0002b86d, 0x0002d86d, 0x0002f86d,
		      0x0003186d, 0x0003386d, 0x0003586d, 0x0003786d,
		      0x0003986d, 0x0003b86d, 0x0003d86d, 0x0003f86d,
		      0x0000046d, 0x0000246d, 0x0000446d, 0x0000646d,
		      0x0000846d, 0x0000a46d, 0x0000c46d, 0x0000e46d,
		      0x0001046d, 0x0001246d, 0x0001446d, 0x0001646d,
		      0x0001846d, 0x0001a46d, 0x0001c46d, 0x0001e46d,
		      0x0002046d, 0x0002246d, 0x0002446d, 0x0002646d,
		      0x0002846d, 0x0002a46d, 0x0002c46d, 0x0002e46d,
		      0x0003046d, 0x0003246d, 0x0003446d, 0x0003646d,
		      0x0003846d, 0x0003a46d, 0x0003c46d, 0x00001468},

	.lit_table = {
		      0x000c, 0x008c, 0x004c, 0x00cc, 0x002c, 0x00ac, 0x006c, 0x00ec,
		      0x001c, 0x009c, 0x005c, 0x00dc, 0x003c, 0x00bc, 0x007c, 0x00fc,
		      0x0002, 0x0082, 0x0042, 0x00c2, 0x0022, 0x00a2, 0x0062, 0x00e2,
		      0x0012, 0x0092, 0x0052, 0x00d2, 0x0032, 0x00b2, 0x0072, 0x00f2,
		      0x000a, 0x008a, 0x004a, 0x00ca, 0x002a, 0x00aa, 0x006a, 0x00ea,
		      0x001a, 0x009a, 0x005a, 0x00da, 0x003a, 0x00ba, 0x007a, 0x00fa,
		      0x0006, 0x0086, 0x0046, 0x00c6, 0x0026, 0x00a6, 0x0066, 0x00e6,
		      0x0016, 0x0096, 0x0056, 0x00d6, 0x0036, 0x00b6, 0x0076, 0x00f6,
		      0x000e, 0x008e, 0x004e, 0x00ce, 0x002e, 0x00ae, 0x006e, 0x00ee,
		      0x001e, 0x009e, 0x005e, 0x00de, 0x003e, 0x00be, 0x007e, 0x00fe,
		      0x0001, 0x0081, 0x0041, 0x00c1, 0x0021, 0x00a1, 0x0061, 0x00e1,
		      0x0011, 0x0091, 0x0051, 0x00d1, 0x0031, 0x00b1, 0x0071, 0x00f1,
		      0x0009, 0x0089, 0x0049, 0x00c9, 0x0029, 0x00a9, 0x0069, 0x00e9,
		      0x0019, 0x0099, 0x0059, 0x00d9, 0x0039, 0x00b9, 0x0079, 0x00f9,
		      0x0005, 0x0085, 0x0045, 0x00c5, 0x0025, 0x00a5, 0x0065, 0x00e5,
		      0x0015, 0x0095, 0x0055, 0x00d5, 0x0035, 0x00b5, 0x0075, 0x00f5,
		      0x000d, 0x008d, 0x004d, 0x00cd, 0x002d, 0x00ad, 0x006d, 0x00ed,
		      0x001d, 0x009d, 0x005d, 0x00dd, 0x003d, 0x00bd, 0x007d, 0x00fd,
		      0x0013, 0x0113, 0x0093, 0x0193, 0x0053, 0x0153, 0x00d3, 0x01d3,
		      0x0033, 0x0133, 0x00b3, 0x01b3, 0x0073, 0x0173, 0x00f3, 0x01f3,
		      0x000b, 0x010b, 0x008b, 0x018b, 0x004b, 0x014b, 0x00cb, 0x01cb,
		      0x002b, 0x012b, 0x00ab, 0x01ab, 0x006b, 0x016b, 0x00eb, 0x01eb,
		      0x001b, 0x011b, 0x009b, 0x019b, 0x005b, 0x015b, 0x00db, 0x01db,
		      0x003b, 0x013b, 0x00bb, 0x01bb, 0x007b, 0x017b, 0x00fb, 0x01fb,
		      0x0007, 0x0107, 0x0087, 0x0187, 0x0047, 0x0147, 0x00c7, 0x01c7,
		      0x0027, 0x0127, 0x00a7, 0x01a7, 0x0067, 0x0167, 0x00e7, 0x01e7,
		      0x0017, 0x0117, 0x0097, 0x0197, 0x0057, 0x0157, 0x00d7, 0x01d7,
		      0x0037, 0x0137, 0x00b7, 0x01b7, 0x0077, 0x0177, 0x00f7, 0x01f7,
		      0x000f, 0x010f, 0x008f, 0x018f, 0x004f, 0x014f, 0x00cf, 0x01cf,
		      0x002f, 0x012f, 0x00af, 0x01af, 0x006f, 0x016f, 0x00ef, 0x01ef,
		      0x001f, 0x011f, 0x009f, 0x019f, 0x005f, 0x015f, 0x00df, 0x01df,
		      0x003f, 0x013f, 0x00bf, 0x01bf, 0x007f, 0x017f, 0x00ff, 0x01ff,
		      0x0000},

	.lit_table_sizes = {
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
			    0x07},

#ifndef LONGER_HUFFTABLE
	.dcodes = {
		   0x0000, 0x0010, 0x0008, 0x0018, 0x0004, 0x0014, 0x000c, 0x001c,
		   0x0002, 0x0012, 0x000a, 0x001a, 0x0006, 0x0016, 0x000e, 0x001e,
		   0x0001, 0x0011, 0x0009, 0x0019, 0x0005, 0x0015, 0x000d, 0x001d,
		   0x0003, 0x0013, 0x000b, 0x001b, 0x0007, 0x0017},

	.dcodes_sizes = {
			 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
			 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
			 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
			 0x05, 0x05, 0x05, 0x05, 0x05, 0x05}
#else
	.dcodes = {
		   0x000b, 0x001b, 0x0007, 0x0017},

	.dcodes_sizes = {
			 0x05, 0x05, 0x05, 0x05}
#endif
};
