/** @file goid-tool-cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef GOID_TOOL_CMDLINE_H
#define GOID_TOOL_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "goid-tool"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "goid-tool"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * reader_arg;	/**< @brief Number of the reader to use. By default, the first reader with a present card is used. If the argument is an ATR, the reader with a matching card will be chosen..  */
  char * reader_orig;	/**< @brief Number of the reader to use. By default, the first reader with a present card is used. If the argument is an ATR, the reader with a matching card will be chosen. original value given at command line.  */
  const char *reader_help; /**< @brief Number of the reader to use. By default, the first reader with a present card is used. If the argument is an ATR, the reader with a matching card will be chosen. help description.  */
  unsigned int verbose_min; /**< @brief Use (several times) to be more verbose's minimum occurreces */
  unsigned int verbose_max; /**< @brief Use (several times) to be more verbose's maximum occurreces */
  const char *verbose_help; /**< @brief Use (several times) to be more verbose help description.  */
  const char *verify_pin_help; /**< @brief Verify PIN help description.  */
  const char *verify_bio_help; /**< @brief Verify finger print help description.  */
  const char *verify_pin_or_bio_help; /**< @brief Verify PIN or finger print (user's choice) help description.  */
  const char *new_pin_help; /**< @brief Change PIN help description.  */
  unsigned int new_bio_min; /**< @brief Use (several times) to change one or more biometric templates's minimum occurreces */
  unsigned int new_bio_max; /**< @brief Use (several times) to change one or more biometric templates's maximum occurreces */
  const char *new_bio_help; /**< @brief Use (several times) to change one or more biometric templates help description.  */
  const char *info_help; /**< @brief Dump Information about the SoCManager's configuration help description.  */
  char ** certificate_arg;	/**< @brief Use (several times) to pass CV certificates.  */
  char ** certificate_orig;	/**< @brief Use (several times) to pass CV certificates original value given at command line.  */
  unsigned int certificate_min; /**< @brief Use (several times) to pass CV certificates's minimum occurreces */
  unsigned int certificate_max; /**< @brief Use (several times) to pass CV certificates's maximum occurreces */
  const char *certificate_help; /**< @brief Use (several times) to pass CV certificates help description.  */
  char * key_arg;	/**< @brief Private key for the CV certificate.  */
  char * key_orig;	/**< @brief Private key for the CV certificate original value given at command line.  */
  const char *key_help; /**< @brief Private key for the CV certificate help description.  */
  const char *print_cardid_help; /**< @brief Print the card ID help description.  */
  char * write_cardid_arg;	/**< @brief Write the specified card ID.  */
  char * write_cardid_orig;	/**< @brief Write the specified card ID original value given at command line.  */
  const char *write_cardid_help; /**< @brief Write the specified card ID help description.  */
  const char *print_paccessid_help; /**< @brief Print the PAccess ID help description.  */
  char * write_paccessid_arg;	/**< @brief Write the specified PAccess ID.  */
  char * write_paccessid_orig;	/**< @brief Write the specified PAccess ID original value given at command line.  */
  const char *write_paccessid_help; /**< @brief Write the specified PAccess ID help description.  */
  int* read_dg_arg;	/**< @brief Read the specified data group; use several times to read out multiple files.  */
  char ** read_dg_orig;	/**< @brief Read the specified data group; use several times to read out multiple files original value given at command line.  */
  unsigned int read_dg_min; /**< @brief Read the specified data group; use several times to read out multiple files's minimum occurreces */
  unsigned int read_dg_max; /**< @brief Read the specified data group; use several times to read out multiple files's maximum occurreces */
  const char *read_dg_help; /**< @brief Read the specified data group; use several times to read out multiple files help description.  */
  char ** out_file_arg;	/**< @brief Write output to a file instead of printing it; use once for each use of `--read-dg'.  */
  char ** out_file_orig;	/**< @brief Write output to a file instead of printing it; use once for each use of `--read-dg' original value given at command line.  */
  unsigned int out_file_min; /**< @brief Write output to a file instead of printing it; use once for each use of `--read-dg''s minimum occurreces */
  unsigned int out_file_max; /**< @brief Write output to a file instead of printing it; use once for each use of `--read-dg''s maximum occurreces */
  const char *out_file_help; /**< @brief Write output to a file instead of printing it; use once for each use of `--read-dg' help description.  */
  int* write_dg_arg;	/**< @brief Write the specified data group; use several times to write multiple files.  */
  char ** write_dg_orig;	/**< @brief Write the specified data group; use several times to write multiple files original value given at command line.  */
  unsigned int write_dg_min; /**< @brief Write the specified data group; use several times to write multiple files's minimum occurreces */
  unsigned int write_dg_max; /**< @brief Write the specified data group; use several times to write multiple files's maximum occurreces */
  const char *write_dg_help; /**< @brief Write the specified data group; use several times to write multiple files help description.  */
  char ** in_file_arg;	/**< @brief Read input from a file; use once for each use of `--write-dg'.  */
  char ** in_file_orig;	/**< @brief Read input from a file; use once for each use of `--write-dg' original value given at command line.  */
  unsigned int in_file_min; /**< @brief Read input from a file; use once for each use of `--write-dg''s minimum occurreces */
  unsigned int in_file_max; /**< @brief Read input from a file; use once for each use of `--write-dg''s maximum occurreces */
  const char *in_file_help; /**< @brief Read input from a file; use once for each use of `--write-dg' help description.  */
  int* delete_dg_arg;	/**< @brief Delete the specified data group; use several times to delete multiple files.  */
  char ** delete_dg_orig;	/**< @brief Delete the specified data group; use several times to delete multiple files original value given at command line.  */
  unsigned int delete_dg_min; /**< @brief Delete the specified data group; use several times to delete multiple files's minimum occurreces */
  unsigned int delete_dg_max; /**< @brief Delete the specified data group; use several times to delete multiple files's maximum occurreces */
  const char *delete_dg_help; /**< @brief Delete the specified data group; use several times to delete multiple files help description.  */
  int* create_dg_arg;	/**< @brief Create the specified data group; use several times to create multiple files.  */
  char ** create_dg_orig;	/**< @brief Create the specified data group; use several times to create multiple files original value given at command line.  */
  unsigned int create_dg_min; /**< @brief Create the specified data group; use several times to create multiple files's minimum occurreces */
  unsigned int create_dg_max; /**< @brief Create the specified data group; use several times to create multiple files's maximum occurreces */
  const char *create_dg_help; /**< @brief Create the specified data group; use several times to create multiple files help description.  */
  int new_size_arg;	/**< @brief File size of newly created DGs (default='256').  */
  char * new_size_orig;	/**< @brief File size of newly created DGs original value given at command line.  */
  const char *new_size_help; /**< @brief File size of newly created DGs help description.  */
  char * new_read_ac_arg;	/**< @brief Access condition for reading newly created DGs (default='sm').  */
  char * new_read_ac_orig;	/**< @brief Access condition for reading newly created DGs original value given at command line.  */
  const char *new_read_ac_help; /**< @brief Access condition for reading newly created DGs help description.  */
  int* new_read_ac_chatbit_arg;	/**< @brief Required access bits in certificate's CHAT for reading newly created DGs.  */
  char ** new_read_ac_chatbit_orig;	/**< @brief Required access bits in certificate's CHAT for reading newly created DGs original value given at command line.  */
  unsigned int new_read_ac_chatbit_min; /**< @brief Required access bits in certificate's CHAT for reading newly created DGs's minimum occurreces */
  unsigned int new_read_ac_chatbit_max; /**< @brief Required access bits in certificate's CHAT for reading newly created DGs's maximum occurreces */
  const char *new_read_ac_chatbit_help; /**< @brief Required access bits in certificate's CHAT for reading newly created DGs help description.  */
  char * new_write_ac_arg;	/**< @brief Access condition for writing newly created DGs (default='sm').  */
  char * new_write_ac_orig;	/**< @brief Access condition for writing newly created DGs original value given at command line.  */
  const char *new_write_ac_help; /**< @brief Access condition for writing newly created DGs help description.  */
  int* new_write_ac_chatbit_arg;	/**< @brief Required access bits in certificate's CHAT for reading newly created DGs.  */
  char ** new_write_ac_chatbit_orig;	/**< @brief Required access bits in certificate's CHAT for reading newly created DGs original value given at command line.  */
  unsigned int new_write_ac_chatbit_min; /**< @brief Required access bits in certificate's CHAT for reading newly created DGs's minimum occurreces */
  unsigned int new_write_ac_chatbit_max; /**< @brief Required access bits in certificate's CHAT for reading newly created DGs's maximum occurreces */
  const char *new_write_ac_chatbit_help; /**< @brief Required access bits in certificate's CHAT for reading newly created DGs help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int reader_given ;	/**< @brief Whether reader was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int verify_pin_given ;	/**< @brief Whether verify-pin was given.  */
  unsigned int verify_bio_given ;	/**< @brief Whether verify-bio was given.  */
  unsigned int verify_pin_or_bio_given ;	/**< @brief Whether verify-pin-or-bio was given.  */
  unsigned int new_pin_given ;	/**< @brief Whether new-pin was given.  */
  unsigned int new_bio_given ;	/**< @brief Whether new-bio was given.  */
  unsigned int info_given ;	/**< @brief Whether info was given.  */
  unsigned int certificate_given ;	/**< @brief Whether certificate was given.  */
  unsigned int key_given ;	/**< @brief Whether key was given.  */
  unsigned int print_cardid_given ;	/**< @brief Whether print-cardid was given.  */
  unsigned int write_cardid_given ;	/**< @brief Whether write-cardid was given.  */
  unsigned int print_paccessid_given ;	/**< @brief Whether print-paccessid was given.  */
  unsigned int write_paccessid_given ;	/**< @brief Whether write-paccessid was given.  */
  unsigned int read_dg_given ;	/**< @brief Whether read-dg was given.  */
  unsigned int out_file_given ;	/**< @brief Whether out-file was given.  */
  unsigned int write_dg_given ;	/**< @brief Whether write-dg was given.  */
  unsigned int in_file_given ;	/**< @brief Whether in-file was given.  */
  unsigned int delete_dg_given ;	/**< @brief Whether delete-dg was given.  */
  unsigned int create_dg_given ;	/**< @brief Whether create-dg was given.  */
  unsigned int new_size_given ;	/**< @brief Whether new-size was given.  */
  unsigned int new_read_ac_given ;	/**< @brief Whether new-read-ac was given.  */
  unsigned int new_read_ac_chatbit_given ;	/**< @brief Whether new-read-ac-chatbit was given.  */
  unsigned int new_write_ac_given ;	/**< @brief Whether new-write-ac was given.  */
  unsigned int new_write_ac_chatbit_given ;	/**< @brief Whether new-write-ac-chatbit was given.  */

  int pxs_mode_counter; /**< @brief Counter for mode pxs */
  int soc_mode_counter; /**< @brief Counter for mode soc */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_new_read_ac_values[];  /**< @brief Possible values for new-read-ac. */
extern const char *cmdline_parser_new_write_ac_values[];  /**< @brief Possible values for new-write-ac. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* GOID_TOOL_CMDLINE_H */
