/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __input
#define __input

#include <string.h>
#include "chrono.h"

struct key_stamp {
  double dt;
  double t;
  key_stamp () {
    t = 0;
    dt = 0;
  }
};

struct key_state {
  static const int NUM_BYTES = 32;
  char now [NUM_BYTES];
  char last [NUM_BYTES];
  static const int MAX_KEYS = 256;
  key_stamp stamp [MAX_KEYS];

  key_state () {
    memset (now, 0, NUM_BYTES);
    memset (last, 0, NUM_BYTES);
  }
};

extern key_state keys;

inline int keydown (int k) {
  int quo = k >> 3;
  unsigned int rem = k - (quo << 3);
  return ((keys.now[quo] >> rem) & 0x01);
}

inline int waskeydown (int k) {
  int quo = k >> 3;
  unsigned int rem = k - (quo << 3);
  return ( (keys.last[quo] >> rem) & 0x01);
}

inline int keypressed (int k) {
  return (!waskeydown(k) && keydown(k));
}

extern nano_chrono ui_clk;

inline int keypressedd (int k, double firstt = 1./3, double constt = 1./20) {

  /* keypressed with key repeat */

  if (keydown(k)) {
    if (!waskeydown(k)) {
      keys.stamp[k].dt = firstt;
      keys.stamp[k].t = ui_clk.secs;
      return 1;
    } else {
      double dt = ui_clk.secs - keys.stamp[k].t;
      if (dt > keys.stamp[k].dt) {
        keys.stamp[k].dt = constt;
        keys.stamp[k].t = ui_clk.secs;
        return 1;
      }
    }
  }
  return 0;
}

#endif
