/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.AAFrequency;
import jalview.analysis.Conservation;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

public class SequenceGroup {
    String groupName;
    String description;
    Conservation conserve;
    Vector aaFrequency;
    boolean displayBoxes = true;
    boolean displayText = true;
    boolean colourText = false;
    private Vector sequences = new Vector();
    int width = -1;
    public ColourSchemeI cs;
    int startRes = 0;
    int endRes = 0;
    public Color outlineColour = Color.black;
    public Color idColour = null;
    public int thresholdTextColour = 0;
    public Color textColour = Color.black;
    public Color textColour2 = Color.white;

    public SequenceGroup() {
        this.groupName = "JGroup:" + this.hashCode();
    }

    public SequenceGroup(Vector sequences, String groupName, ColourSchemeI scheme, boolean displayBoxes, boolean displayText, boolean colourText, int start, int end) {
        this.sequences = sequences;
        this.groupName = groupName;
        this.displayBoxes = displayBoxes;
        this.displayText = displayText;
        this.colourText = colourText;
        this.cs = scheme;
        this.startRes = start;
        this.endRes = end;
        this.recalcConservation();
    }

    public SequenceI[] getSelectionAsNewSequences(AlignmentI align) {
        int iSize = this.sequences.size();
        SequenceI[] seqs = new SequenceI[iSize];
        SequenceI[] inorder = this.getSequencesInOrder(align);
        int ipos = 0;
        for (int i = 0; i < inorder.length; ++i) {
            SequenceI seq = inorder[i];
            seqs[ipos] = seq.getSubSequence(this.startRes, this.endRes + 1);
            if (seqs[ipos] != null) {
                seqs[ipos].setDescription(seq.getDescription());
                seqs[ipos].setDBRef(seq.getDBRef());
                seqs[ipos].setSequenceFeatures(seq.getSequenceFeatures());
                if (seq.getDatasetSequence() != null) {
                    seqs[ipos].setDatasetSequence(seq.getDatasetSequence());
                }
                if (seq.getAnnotation() != null) {
                    AlignmentAnnotation[] alann = align.getAlignmentAnnotation();
                    for (int a = 0; a < seq.getAnnotation().length; ++a) {
                        AlignmentAnnotation tocopy = seq.getAnnotation()[a];
                        if (alann != null) {
                            boolean found = false;
                            for (int pos = 0; pos < alann.length; ++pos) {
                                if (alann[pos] != tocopy) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                        AlignmentAnnotation newannot = new AlignmentAnnotation(seq.getAnnotation()[a]);
                        newannot.restrict(this.startRes, this.endRes);
                        newannot.setSequenceRef(seqs[ipos]);
                        newannot.adjustForAlignment();
                        seqs[ipos].addAlignmentAnnotation(newannot);
                    }
                }
                ++ipos;
                continue;
            }
            --iSize;
        }
        if (iSize != inorder.length) {
            SequenceI[] nseqs = new SequenceI[iSize];
            System.arraycopy(seqs, 0, nseqs, 0, iSize);
            seqs = nseqs;
        }
        return seqs;
    }

    public int findEndRes(SequenceI seq) {
        int eres = 0;
        for (int j = 0; j < this.endRes + 1 && j < seq.getLength(); ++j) {
            char ch = seq.getCharAt(j);
            if (Comparison.isGap(ch)) continue;
            ++eres;
        }
        if (eres > 0) {
            eres += seq.getStart() - 1;
        }
        return eres;
    }

    public Vector getSequences(Hashtable hiddenReps) {
        if (hiddenReps == null) {
            return this.sequences;
        }
        Vector<SequenceI> allSequences = new Vector<SequenceI>();
        for (int i = 0; i < this.sequences.size(); ++i) {
            SequenceI seq = (SequenceI)this.sequences.elementAt(i);
            allSequences.addElement(seq);
            if (!hiddenReps.containsKey(seq)) continue;
            SequenceGroup hsg = (SequenceGroup)hiddenReps.get(seq);
            for (int h = 0; h < hsg.getSize(); ++h) {
                SequenceI seq2 = hsg.getSequenceAt(h);
                if (seq2 == seq || allSequences.contains(seq2)) continue;
                allSequences.addElement(seq2);
            }
        }
        return allSequences;
    }

    public SequenceI[] getSequencesAsArray(Hashtable hiddenReps) {
        Vector tmp = this.getSequences(hiddenReps);
        if (tmp == null) {
            return null;
        }
        SequenceI[] result = new SequenceI[tmp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (SequenceI)tmp.elementAt(i);
        }
        return result;
    }

    public boolean adjustForRemoveLeft(int col) {
        if (this.startRes >= col) {
            this.startRes -= col;
        }
        if (this.endRes >= col) {
            this.endRes -= col;
            if (this.startRes > this.endRes) {
                this.startRes = 0;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean adjustForRemoveRight(int col) {
        if (this.startRes > col) {
            return false;
        }
        if (this.endRes >= col) {
            this.endRes = col;
        }
        return true;
    }

    public String getName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.groupName = name;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public Conservation getConservation() {
        return this.conserve;
    }

    public void setConservation(Conservation c) {
        this.conserve = c;
    }

    public void addSequence(SequenceI s, boolean recalc) {
        if (s != null && !this.sequences.contains(s)) {
            this.sequences.addElement(s);
        }
        if (recalc) {
            this.recalcConservation();
        }
    }

    public void recalcConservation() {
        if (this.cs == null) {
            return;
        }
        try {
            this.cs.setConsensus(AAFrequency.calculate(this.sequences, this.startRes, this.endRes + 1));
            if (this.cs instanceof ClustalxColourScheme) {
                ((ClustalxColourScheme)this.cs).resetClustalX(this.sequences, this.getWidth());
            }
            if (this.cs.conservationApplied()) {
                Conservation c = new Conservation(this.groupName, ResidueProperties.propHash, 3, this.sequences, this.startRes, this.endRes + 1);
                c.calculate();
                c.verdict(false, 25.0f);
                this.cs.setConservation(c);
                if (this.cs instanceof ClustalxColourScheme) {
                    ((ClustalxColourScheme)this.cs).resetClustalX(this.sequences, this.getWidth());
                }
            }
        }
        catch (OutOfMemoryError err) {
            System.out.println("Out of memory loading groups: " + err);
        }
    }

    public void addOrRemove(SequenceI s, boolean recalc) {
        if (this.sequences.contains(s)) {
            this.deleteSequence(s, recalc);
        } else {
            this.addSequence(s, recalc);
        }
    }

    public void deleteSequence(SequenceI s, boolean recalc) {
        this.sequences.removeElement(s);
        if (recalc) {
            this.recalcConservation();
        }
    }

    public int getStartRes() {
        return this.startRes;
    }

    public int getEndRes() {
        return this.endRes;
    }

    public void setStartRes(int i) {
        this.startRes = i;
    }

    public void setEndRes(int i) {
        this.endRes = i;
    }

    public int getSize() {
        return this.sequences.size();
    }

    public SequenceI getSequenceAt(int i) {
        return (SequenceI)this.sequences.elementAt(i);
    }

    public void setColourText(boolean state) {
        this.colourText = state;
    }

    public boolean getColourText() {
        return this.colourText;
    }

    public void setDisplayText(boolean state) {
        this.displayText = state;
    }

    public boolean getDisplayText() {
        return this.displayText;
    }

    public void setDisplayBoxes(boolean state) {
        this.displayBoxes = state;
    }

    public boolean getDisplayBoxes() {
        return this.displayBoxes;
    }

    public int getWidth() {
        if (this.sequences.size() > 0) {
            this.width = ((SequenceI)this.sequences.elementAt(0)).getLength();
        }
        for (int i = 1; i < this.sequences.size(); ++i) {
            SequenceI seq = (SequenceI)this.sequences.elementAt(i);
            if (seq.getLength() <= this.width) continue;
            this.width = seq.getLength();
        }
        return this.width;
    }

    public void setOutlineColour(Color c) {
        this.outlineColour = c;
    }

    public Color getOutlineColour() {
        return this.outlineColour;
    }

    public SequenceI[] getSequencesInOrder(AlignmentI al) {
        int sSize = this.sequences.size();
        int alHeight = al.getHeight();
        SequenceI[] seqs = new SequenceI[sSize];
        int index = 0;
        for (int i = 0; i < alHeight && index < sSize; ++i) {
            if (!this.sequences.contains(al.getSequenceAt(i))) continue;
            seqs[index++] = al.getSequenceAt(i);
        }
        return seqs;
    }

    public Color getIdColour() {
        return this.idColour;
    }

    public void setIdColour(Color idColour) {
        this.idColour = idColour;
    }
}

