# frozen_string_literal: true

class RemoveBackfillVulnerabilityOccurrencePipelinesProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.6'
  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION = "BackfillVulnerabilityOccurrencePipelinesProjectId"

  def up
    # rubocop:disable Migration/BatchMigrationsPostOnly -- Must be run before BBM code is deleted.
    # Estimated runtime on .com is only 5 seconds.
    delete_batched_background_migration(
      MIGRATION,
      :vulnerability_occurrence_pipelines,
      :id,
      [
        :project_id,
        :vulnerability_occurrences,
        :project_id,
        :occurrence_id
      ]
    )
    # rubocop:enable Migration/BatchMigrationsPostOnly
  end

  def down
    # no-op
  end
end
