/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.RefAddr;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1673475790065791735L;
    protected String className;
    protected Vector<RefAddr> addrs;
    protected String classFactory;
    protected String classFactoryLocation;

    public Reference(String className) {
        this(className, null, null);
    }

    public Reference(String className, RefAddr addr) {
        this(className, addr, null, null);
    }

    public Reference(String className, String classFactory, String classFactoryLocation) {
        this.className = className;
        this.classFactory = classFactory;
        this.classFactoryLocation = classFactoryLocation;
        this.addrs = new Vector();
    }

    public Reference(String className, RefAddr addr, String classFactory, String classFactoryLocation) {
        this(className, classFactory, classFactoryLocation);
        this.addrs.add(addr);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassName() {
        return this.classFactory;
    }

    public String getFactoryClassLocation() {
        return this.classFactoryLocation;
    }

    public Enumeration<RefAddr> getAll() {
        return this.addrs.elements();
    }

    public RefAddr get(String type) {
        Enumeration<RefAddr> elements = this.addrs.elements();
        RefAddr refAddr = null;
        while (elements.hasMoreElements()) {
            refAddr = elements.nextElement();
            if (!type.equals(refAddr.getType())) continue;
            return refAddr;
        }
        return null;
    }

    public RefAddr get(int index) {
        return this.addrs.get(index);
    }

    public void add(RefAddr addr) {
        this.addrs.add(addr);
    }

    public void add(int index, RefAddr addr) {
        this.addrs.add(index, addr);
    }

    public Object remove(int index) {
        return this.addrs.remove(index);
    }

    public int size() {
        return this.addrs.size();
    }

    public void clear() {
        this.addrs.clear();
    }

    public Object clone() {
        try {
            Reference r = (Reference)super.clone();
            r.addrs = (Vector)this.addrs.clone();
            return r;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)Messages.getString("jndi.03"));
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Reference) {
            Reference r = (Reference)o;
            return r.className.equals(this.className) && r.addrs.equals(this.addrs);
        }
        return false;
    }

    public int hashCode() {
        int i = this.className.hashCode();
        Enumeration<RefAddr> e = this.addrs.elements();
        while (e.hasMoreElements()) {
            i += e.nextElement().hashCode();
        }
        return i;
    }

    public String toString() {
        String s = "Reference class name: " + this.className;
        Enumeration<RefAddr> e = this.addrs.elements();
        s = String.valueOf(s) + "\nReference addresses:";
        while (e.hasMoreElements()) {
            s = String.valueOf(s) + "\n\t" + e.nextElement();
        }
        return String.valueOf(s) + "\n";
    }
}

