//
// File: test_cborsage.cpp
// Created by: Olivier Langella
// Created on: 17/7/2025
//
/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

// ./tests/pappsotree/catch2-only-pappsotree [cborsage] -s

#include <catch2/catch_test_macros.hpp>
#include <pappsomspp/core/processing/cbor/psm/sage/sagefilereader.h>
#include <pappsomspp/core/processing/cbor/psm/psmfilereaderbase.h>
#include <pappsomspp/core/processing/uimonitor/uimonitorvoid.h>
#include <odsstream/odsdocwriter.h>
#include <QDebug>

class CborTest : public pappso::cbor::psm::PsmFileReaderBase
{
  public:
  CborTest(CalcWriterInterface &output) : m_output(output)
  {
    m_output.writeSheet("psm list");
    m_output.writeCell("index");
    m_output.writeCell("sample");
    m_output.writeCell("Proforma");
    m_output.writeLine();
  };

  void
  psmReady(pappso::UiMonitorInterface &monitor [[maybe_unused]]) override
  {

    // qDebug() << "coucou";
    m_output.writeCell((std::size_t)m_cborScanId.value("index").toInteger());
    m_output.writeCell(m_currentSampleName);
    m_output.writeCell(m_currentPsmProforma);
    m_output.writeLine();
  };

  private:
  CalcWriterInterface &m_output;
};

TEST_CASE("cbor psm map test suite.", "[cborsage]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));
  
  
  SECTION("..:: PSM cbor features::..", "[cborfeatures]")
  {
    pappso::UiMonitorVoid monitor;

    QFile cbor_file(
      "/gorgone/pappso/data_extraction_pappso/sage_output/sage_output.cbor");
    cbor_file.open(QIODevice::ReadOnly);


    QFile fileods("test.ods");
    OdsDocWriter writer(&fileods);


    CborTest cbor_pappso(writer);
    cbor_pappso.readCbor(&cbor_file, monitor);
    // xic_writer.write(xic);
    writer.close();
    fileods.close();
  }

  SECTION("..:: PSM cbor features::..", "[cborfeatures]")
  {
    pappso::UiMonitorVoid monitor;

    QFileInfo sage_json_file(
      "/gorgone/pappso/moulon/users/Olivier/20250402_RD_mais_deepprot/sage/self/B73/results.json");

    QFile sage_cbor_file("sage.cbor");
    sage_cbor_file.open(QIODevice::WriteOnly);
    pappso::cbor::CborStreamWriter writer(&sage_cbor_file);


    pappso::cbor::psm::SageFileReader sage_file_reader(&monitor, &writer, sage_json_file);
    sage_cbor_file.close();
  }
}
