"""
Python Markdown

A Python implementation of John Gruber's Markdown.

Documentation: https://python-markdown.github.io/
GitHub: https://github.com/Python-Markdown/markdown/
PyPI: https://pypi.org/project/Markdown/

Started by Manfred Stienstra (http://www.dwerg.net/).
Maintained for a few years by Yuri Takhteyev (http://www.freewisdom.org).
Currently maintained by Waylan Limberg (https://github.com/waylan),
Dmitry Shachnev (https://github.com/mitya57) and Isaac Muse (https://github.com/facelessuser).

Copyright 2007-2019 The Python Markdown Project (v. 1.7 and later)
Copyright 2004, 2005, 2006 Yuri Takhteyev (v. 0.2-1.6b)
Copyright 2004 Manfred Stienstra (the original version)

License: BSD (see LICENSE.md for details).
"""

from markdown.test_tools import TestCase


class TestCode(TestCase):

    def test_code_comments(self):
        self.assertMarkdownRenders(
            self.dedent(
                """
                Some code `<!--` that is not HTML `-->` in a paragraph.

                Some code `<!--`
                that is not HTML `-->`
                in a paragraph.
                """
            ),
            self.dedent(
                """
                <p>Some code <code>&lt;!--</code> that is not HTML <code>--&gt;</code> in a paragraph.</p>
                <p>Some code <code>&lt;!--</code>
                that is not HTML <code>--&gt;</code>
                in a paragraph.</p>
                """
            )
        )

    def test_code_html(self):
        self.assertMarkdownRenders(
            self.dedent(
                """
                <p>html</p>

                Paragraph with code: `<p>test</p>`.
                """
            ),
            self.dedent(
                """
                <p>html</p>

                <p>Paragraph with code: <code>&lt;p&gt;test&lt;/p&gt;</code>.</p>
                """
            )
        )

    def test_noname_tag(self):
        # Browsers ignore `</>`, but a Markdown parser should not, and should treat it as data
        # but not a tag.

        self.assertMarkdownRenders(
            self.dedent(
                """
                `</>`
                """
            ),
            self.dedent(
                """
                <p><code>&lt;/&gt;</code></p>
                """
            )
        )
