/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include <QtGlobal>

namespace Autotest {
namespace Constants {

const char ACTION_SCAN_ID[]             = "AutoTest.ScanAction";
const char ACTION_RUN_ALL_ID[]          = "AutoTest.RunAll";
const char ACTION_RUN_SELECTED_ID[]     = "AutoTest.RunSelected";
const char ACTION_RUN_FAILED_ID[]       = "AutoTest.RunFailed";
const char ACTION_RUN_FILE_ID[]         = "AutoTest.RunFile";
const char ACTION_RUN_UCURSOR[]         = "AutoTest.RunUnderCursor";
const char ACTION_RUN_DBG_UCURSOR[]     = "AutoTest.RunDebugUnderCursor";
const char MENU_ID[]                    = "AutoTest.Menu";
const char AUTOTEST_ID[]                = "AutoTest.ATP";
const char AUTOTEST_CONTEXT[]           = "Auto Tests";
const char TASK_INDEX[]                 = "AutoTest.Task.Index";
const char TASK_PARSE[]                 = "AutoTest.Task.Parse";
const char AUTOTEST_SETTINGS_CATEGORY[] = "ZY.Tests";
const char AUTOTEST_SETTINGS_TR[]       = QT_TRANSLATE_NOOP("AutoTest", "Testing");
const char FRAMEWORK_PREFIX[]           = "AutoTest.Framework.";
const char SETTINGSPAGE_PREFIX[]        = "A.AutoTest.";
const char SETTINGSGROUP[]              = "Autotest";
const char TASK_MARK_ID[]               = "Autotest.TaskMark";
const char SK_USE_GLOBAL[]              = "AutoTest.UseGlobal";
} // namespace Constants

enum class TestRunMode
{
    None,
    Run,
    RunWithoutDeploy,
    Debug,
    DebugWithoutDeploy,
    RunAfterBuild
};

enum class OutputChannel { StdOut, StdErr };

} // namespace Autotest
