% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclocomp.R
\docType{package}
\name{cyclocomp}
\alias{cyclocomp}
\alias{cyclocomp-package}
\alias{cyclocomp_q}
\title{Cyclomatic Complexity of R Code}
\usage{
cyclocomp(expr)

cyclocomp_q(expr)
}
\arguments{
\item{expr}{An R function or expression.}
}
\value{
Integer scalar, the cyclomatic complexity of the
  expression.
}
\description{
Cyclomatic complexity is a software metric (measurement), used to indicate
the complexity of a program. It is a quantitative measure of the number of
linearly independent paths through a program's source code. It was developed
by Thomas J. McCabe, Sr. in 1976.

Calculate the cyclomatic complexity of an R function or expression.
}
\examples{
## Supply a function
cyclocomp(
  function(arg) { calulate(this); and(that) }
)
cyclocomp(ls)
cyclocomp(cyclocomp)

## Or a quoted expression
cyclocomp(quote( if (condition) "foo" else "bar" ))

## cyclocomp_q quotes the expression for you
cyclocomp_q(while (condition) { loop })

## Complexity of individual control flow constructs
cyclocomp(quote({
  if (condition) this
}))

cyclocomp(quote({
  if (condition) this else that
}))

cyclocomp(quote({
  for (var in seq) expr
}))

cyclocomp(quote({
  while (cond) expr
}))

cyclocomp(quote({
  repeat expr
}))

cyclocomp(quote({
  for (var in seq) {
    this
    break
    that
  }
}))

cyclocomp(quote({
  for (var in seq) {
    this
    next
    that
  }
}))
}
\seealso{
Other cyclomatic complexity: \code{\link{cyclocomp_package_dir}},
  \code{\link{cyclocomp_package}}
}

