/*
 * NetHSM
 *
 * All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.
 *
 * The version of the OpenAPI document: v1
 * Contact: Nitrokey <info@nitrokey.com>
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
#[non_exhaustive]
pub enum SignMode {
    #[serde(rename = "PKCS1")]
    Pkcs1,
    #[serde(rename = "PSS_MD5")]
    PssMd5,
    #[serde(rename = "PSS_SHA1")]
    PssSha1,
    #[serde(rename = "PSS_SHA224")]
    PssSha224,
    #[serde(rename = "PSS_SHA256")]
    PssSha256,
    #[serde(rename = "PSS_SHA384")]
    PssSha384,
    #[serde(rename = "PSS_SHA512")]
    PssSha512,
    #[serde(rename = "EdDSA")]
    EdDsa,
    #[serde(rename = "ECDSA")]
    Ecdsa,
    #[serde(rename = "BIP340")]
    Bip340,
}

impl std::fmt::Display for SignMode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "{}",
            match self {
                Self::Pkcs1 => "PKCS1",
                Self::PssMd5 => "PSS_MD5",
                Self::PssSha1 => "PSS_SHA1",
                Self::PssSha224 => "PSS_SHA224",
                Self::PssSha256 => "PSS_SHA256",
                Self::PssSha384 => "PSS_SHA384",
                Self::PssSha512 => "PSS_SHA512",
                Self::EdDsa => "EdDSA",
                Self::Ecdsa => "ECDSA",
                Self::Bip340 => "BIP340",
            }
        )
    }
}

impl Default for SignMode {
    fn default() -> SignMode {
        Self::Pkcs1
    }
}
