#include <genvector/vts0.h>
#include <libcschem/abstract.h>

/* NULL terminated list of strings; enum values for the --model param of the
   exporter */
extern const char *attbl_models[];
typedef enum attbl_model_s {
	ATTBLM_CONCRETE,
	ATTBLM_CONCRETE_SYMBOLS,
	ATTBLM_CONCRETE_WIRENETS,
	ATTBLM_ABSTRACT,
	ATTBLM_ABSTRACT_COMPONENTS,
	ATTBLM_ABSTRACT_NETS
} attbl_model_t;

#define ATTBL_MODEL_IS_ABST(model) (((model) == ATTBLM_ABSTRACT) || ((model) == ATTBLM_ABSTRACT_COMPONENTS) || ((model) == ATTBLM_ABSTRACT_NETS))


/* called once per table to print header */
typedef void csch_attbl_head_cb(void *uctx, const char *type, const char **hdr);

/* called once per entry within the table */
typedef void csch_attbl_row_cb(void *uctx, const char *type, const char *uuid, const char **cols, const char **hdr);

/* called once per table to print footer */
typedef void csch_attbl_foot_cb(void *uctx, const char *type, const char **hdr);



/* Build tables and call head/row/foot (the ones that are not NULL) for each
   table built. If is_prj is 1, build tables from all the project, not just
   the current sheet. If is_prj==1 and is_abst!=NULL, build tables for the
   abstract model */
int csch_attbl_export(
	rnd_design_t *design, int is_prj, attbl_model_t model, csch_abstract_t *abst,
	csch_attbl_head_cb *head, csch_attbl_row_cb *row, csch_attbl_foot_cb *foot,
	void *uctx);


/*** Output file management for callbacks ***/

typedef struct {
	FILE *f;
	gds_t fn;
	int fn_restore;
	const char *suffix;     /* including a leading dot */
	unsigned multi_file:1;  /* write multiple files, one per table type */

	rnd_design_t *design;   /* used for GUI and debug */
} attbl_file_ctx_t;


/* Call these before and after doing csch_attbl_export() */
int attbl_file_init(attbl_file_ctx_t *fctx, rnd_design_t *design, const char *fn_template, int multi);
void attbl_file_uninit(attbl_file_ctx_t *fctx);

/* Open output file in head_cb */
int attbl_file_open(attbl_file_ctx_t *fctx, const char *type);

/* do_export helper */
int attbl_do_export_begin(rnd_design_t *design, const char *sview, attbl_model_t model, csch_abstract_t *abst);
void attbl_do_export_end(csch_abstract_t *abst, attbl_model_t model);


/*** Import helpers ***/
typedef struct attbl_import_s {
	rnd_design_t *design;
	vts0_t hdr;
	vts0_t col;
	char type;
	long uuid_col;
	csch_abstract_t *abst;
	struct sch_rnd_backann_s *bactx;
	unsigned got_hdr:1;    /* set to 1 after the end-of-line of the first line */
	unsigned is_abst:1;    /* indicates whether an import affects the abstract model */
	unsigned is_cnc:1;     /* indicates whether an import affects the concrete model */
	unsigned cnc_frozen:1; /* indicates whether undo is already frozen for all sheets in the project */
} attbl_import_t;

void attbl_import_begin(attbl_import_t *ictx, rnd_design_t *design);
int attbl_import_cell(attbl_import_t *ictx, const char *text);
void attbl_import_endline(attbl_import_t *ictx);
void attbl_import_uninit(attbl_import_t *ictx);

/*** external editor ***/

/* VBOX insert in the export dialog to build the external editor box */
void attbl_extedit_dad(rnd_hid_export_opt_func_action_t act, void *call_ctx, const rnd_export_opt_t *opt, rnd_hid_attr_val_t *val);
