#!/bin/bash
CUR_PATH=$(dirname  $(realpath $0))

if [ $# -gt 0 ]; then
    # if the script is invoked from make test, the binary is already compiled in CMAKE_BINARY_DI
    export BUILD_DIR="$1"
fi

source "$CUR_PATH/../test_utils/test_utils.sh"

check_dependencies "$OTF2_PRINT_PATH" || exit 1
check_module "python" || exit 1

# Building tests
# Python programs don't need to compile
#if [ -z "$BUILD_DIR" ]; then
#    check_compilation || exit 1
#fi

nfailed=0
# Running test scripts
for test in $CUR_PATH/test_*.sh; do
    run_test "$test" || ((nfailed++))
done

exit $nfailed
