// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file stringsTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "stringsTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "strings.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StringStruct_type_identifier(
        TypeIdentifierPair& type_ids_StringStruct)
{

    ReturnCode_t return_code_StringStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StringStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StringStruct", type_ids_StringStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StringStruct)
    {
        StructTypeFlag struct_flags_StringStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StringStruct = "StringStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StringStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StringStruct;
        CompleteTypeDetail detail_StringStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StringStruct, ann_custom_StringStruct, type_name_StringStruct.to_string());
        CompleteStructHeader header_StringStruct;
        header_StringStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StringStruct);
        CompleteStructMemberSeq member_seq_StringStruct;
        {
            TypeIdentifierPair type_ids_var_string8;
            ReturnCode_t return_code_var_string8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_string8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_string8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_string8)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_string8))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_string8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_string8 = 0x00000000;
            bool common_var_string8_ec {false};
            CommonStructMember common_var_string8 {TypeObjectUtils::build_common_struct_member(member_id_var_string8, member_flags_var_string8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_string8, common_var_string8_ec))};
            if (!common_var_string8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_string8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_string8 = "var_string8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_string8;
            ann_custom_StringStruct.reset();
            CompleteMemberDetail detail_var_string8 = TypeObjectUtils::build_complete_member_detail(name_var_string8, member_ann_builtin_var_string8, ann_custom_StringStruct);
            CompleteStructMember member_var_string8 = TypeObjectUtils::build_complete_struct_member(common_var_string8, detail_var_string8);
            TypeObjectUtils::add_complete_struct_member(member_seq_StringStruct, member_var_string8);
        }
        CompleteStructType struct_type_StringStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_StringStruct, header_StringStruct, member_seq_StringStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StringStruct, type_name_StringStruct.to_string(), type_ids_StringStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StringStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_WStringStruct_type_identifier(
        TypeIdentifierPair& type_ids_WStringStruct)
{

    ReturnCode_t return_code_WStringStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_WStringStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "WStringStruct", type_ids_WStringStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_WStringStruct)
    {
        StructTypeFlag struct_flags_WStringStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_WStringStruct = "WStringStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_WStringStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_WStringStruct;
        CompleteTypeDetail detail_WStringStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_WStringStruct, ann_custom_WStringStruct, type_name_WStringStruct.to_string());
        CompleteStructHeader header_WStringStruct;
        header_WStringStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_WStringStruct);
        CompleteStructMemberSeq member_seq_WStringStruct;
        {
            TypeIdentifierPair type_ids_var_string16;
            ReturnCode_t return_code_var_string16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_string16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_unbounded", type_ids_var_string16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_string16)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_wstring_unbounded", type_ids_var_string16, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_string16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_string16 = 0x00000000;
            bool common_var_string16_ec {false};
            CommonStructMember common_var_string16 {TypeObjectUtils::build_common_struct_member(member_id_var_string16, member_flags_var_string16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_string16, common_var_string16_ec))};
            if (!common_var_string16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_string16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_string16 = "var_string16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_string16;
            ann_custom_WStringStruct.reset();
            CompleteMemberDetail detail_var_string16 = TypeObjectUtils::build_complete_member_detail(name_var_string16, member_ann_builtin_var_string16, ann_custom_WStringStruct);
            CompleteStructMember member_var_string16 = TypeObjectUtils::build_complete_struct_member(common_var_string16, detail_var_string16);
            TypeObjectUtils::add_complete_struct_member(member_seq_WStringStruct, member_var_string16);
        }
        CompleteStructType struct_type_WStringStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_WStringStruct, header_WStringStruct, member_seq_WStringStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_WStringStruct, type_name_WStringStruct.to_string(), type_ids_WStringStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "WStringStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SmallStringStruct_type_identifier(
        TypeIdentifierPair& type_ids_SmallStringStruct)
{

    ReturnCode_t return_code_SmallStringStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SmallStringStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SmallStringStruct", type_ids_SmallStringStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SmallStringStruct)
    {
        StructTypeFlag struct_flags_SmallStringStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SmallStringStruct = "SmallStringStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SmallStringStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SmallStringStruct;
        CompleteTypeDetail detail_SmallStringStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SmallStringStruct, ann_custom_SmallStringStruct, type_name_SmallStringStruct.to_string());
        CompleteStructHeader header_SmallStringStruct;
        header_SmallStringStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SmallStringStruct);
        CompleteStructMemberSeq member_seq_SmallStringStruct;
        {
            TypeIdentifierPair type_ids_var_small_string;
            ReturnCode_t return_code_var_small_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_small_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_1", type_ids_var_small_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_small_string)
            {
                {
                    SBound bound = static_cast<SBound>(1);
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_1", type_ids_var_small_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_1 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_small_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_small_string = 0x00000000;
            bool common_var_small_string_ec {false};
            CommonStructMember common_var_small_string {TypeObjectUtils::build_common_struct_member(member_id_var_small_string, member_flags_var_small_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_small_string, common_var_small_string_ec))};
            if (!common_var_small_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_small_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_small_string = "var_small_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_small_string;
            ann_custom_SmallStringStruct.reset();
            CompleteMemberDetail detail_var_small_string = TypeObjectUtils::build_complete_member_detail(name_var_small_string, member_ann_builtin_var_small_string, ann_custom_SmallStringStruct);
            CompleteStructMember member_var_small_string = TypeObjectUtils::build_complete_struct_member(common_var_small_string, detail_var_small_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_SmallStringStruct, member_var_small_string);
        }
        CompleteStructType struct_type_SmallStringStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_SmallStringStruct, header_SmallStringStruct, member_seq_SmallStringStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SmallStringStruct, type_name_SmallStringStruct.to_string(), type_ids_SmallStringStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SmallStringStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_SmallWStringStruct_type_identifier(
        TypeIdentifierPair& type_ids_SmallWStringStruct)
{

    ReturnCode_t return_code_SmallWStringStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_SmallWStringStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "SmallWStringStruct", type_ids_SmallWStringStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_SmallWStringStruct)
    {
        StructTypeFlag struct_flags_SmallWStringStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_SmallWStringStruct = "SmallWStringStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_SmallWStringStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_SmallWStringStruct;
        CompleteTypeDetail detail_SmallWStringStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_SmallWStringStruct, ann_custom_SmallWStringStruct, type_name_SmallWStringStruct.to_string());
        CompleteStructHeader header_SmallWStringStruct;
        header_SmallWStringStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_SmallWStringStruct);
        CompleteStructMemberSeq member_seq_SmallWStringStruct;
        {
            TypeIdentifierPair type_ids_var_small_wstring;
            ReturnCode_t return_code_var_small_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_small_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_1", type_ids_var_small_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_small_wstring)
            {
                {
                    SBound bound = static_cast<SBound>(1);
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_wstring_1", type_ids_var_small_wstring, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_1 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_small_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_small_wstring = 0x00000000;
            bool common_var_small_wstring_ec {false};
            CommonStructMember common_var_small_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_small_wstring, member_flags_var_small_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_small_wstring, common_var_small_wstring_ec))};
            if (!common_var_small_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_small_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_small_wstring = "var_small_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_small_wstring;
            ann_custom_SmallWStringStruct.reset();
            CompleteMemberDetail detail_var_small_wstring = TypeObjectUtils::build_complete_member_detail(name_var_small_wstring, member_ann_builtin_var_small_wstring, ann_custom_SmallWStringStruct);
            CompleteStructMember member_var_small_wstring = TypeObjectUtils::build_complete_struct_member(common_var_small_wstring, detail_var_small_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_SmallWStringStruct, member_var_small_wstring);
        }
        CompleteStructType struct_type_SmallWStringStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_SmallWStringStruct, header_SmallWStringStruct, member_seq_SmallWStringStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_SmallWStringStruct, type_name_SmallWStringStruct.to_string(), type_ids_SmallWStringStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "SmallWStringStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_LargeStringStruct_type_identifier(
        TypeIdentifierPair& type_ids_LargeStringStruct)
{

    ReturnCode_t return_code_LargeStringStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_LargeStringStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "LargeStringStruct", type_ids_LargeStringStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_LargeStringStruct)
    {
        StructTypeFlag struct_flags_LargeStringStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_LargeStringStruct = "LargeStringStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_LargeStringStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_LargeStringStruct;
        CompleteTypeDetail detail_LargeStringStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_LargeStringStruct, ann_custom_LargeStringStruct, type_name_LargeStringStruct.to_string());
        CompleteStructHeader header_LargeStringStruct;
        header_LargeStringStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_LargeStringStruct);
        CompleteStructMemberSeq member_seq_LargeStringStruct;
        {
            TypeIdentifierPair type_ids_var_large_string;
            ReturnCode_t return_code_var_large_string {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_large_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_41925", type_ids_var_large_string);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_large_string)
            {
                {
                    LBound bound = 41925;
                    StringLTypeDefn string_ldefn = TypeObjectUtils::build_string_l_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_string_type_identifier(string_ldefn,
                            "anonymous_string_41925", type_ids_var_large_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_41925 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_large_string = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_large_string = 0x00000000;
            bool common_var_large_string_ec {false};
            CommonStructMember common_var_large_string {TypeObjectUtils::build_common_struct_member(member_id_var_large_string, member_flags_var_large_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_large_string, common_var_large_string_ec))};
            if (!common_var_large_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_large_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_large_string = "var_large_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_large_string;
            ann_custom_LargeStringStruct.reset();
            CompleteMemberDetail detail_var_large_string = TypeObjectUtils::build_complete_member_detail(name_var_large_string, member_ann_builtin_var_large_string, ann_custom_LargeStringStruct);
            CompleteStructMember member_var_large_string = TypeObjectUtils::build_complete_struct_member(common_var_large_string, detail_var_large_string);
            TypeObjectUtils::add_complete_struct_member(member_seq_LargeStringStruct, member_var_large_string);
        }
        CompleteStructType struct_type_LargeStringStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_LargeStringStruct, header_LargeStringStruct, member_seq_LargeStringStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_LargeStringStruct, type_name_LargeStringStruct.to_string(), type_ids_LargeStringStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "LargeStringStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_LargeWStringStruct_type_identifier(
        TypeIdentifierPair& type_ids_LargeWStringStruct)
{

    ReturnCode_t return_code_LargeWStringStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_LargeWStringStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "LargeWStringStruct", type_ids_LargeWStringStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_LargeWStringStruct)
    {
        StructTypeFlag struct_flags_LargeWStringStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_LargeWStringStruct = "LargeWStringStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_LargeWStringStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_LargeWStringStruct;
        CompleteTypeDetail detail_LargeWStringStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_LargeWStringStruct, ann_custom_LargeWStringStruct, type_name_LargeWStringStruct.to_string());
        CompleteStructHeader header_LargeWStringStruct;
        header_LargeWStringStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_LargeWStringStruct);
        CompleteStructMemberSeq member_seq_LargeWStringStruct;
        {
            TypeIdentifierPair type_ids_var_large_wstring;
            ReturnCode_t return_code_var_large_wstring {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_large_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_41925", type_ids_var_large_wstring);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_large_wstring)
            {
                {
                    LBound bound = 41925;
                    StringLTypeDefn string_ldefn = TypeObjectUtils::build_string_l_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_l_string_type_identifier(string_ldefn,
                            "anonymous_wstring_41925", type_ids_var_large_wstring, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_41925 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_large_wstring = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_large_wstring = 0x00000000;
            bool common_var_large_wstring_ec {false};
            CommonStructMember common_var_large_wstring {TypeObjectUtils::build_common_struct_member(member_id_var_large_wstring, member_flags_var_large_wstring, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_large_wstring, common_var_large_wstring_ec))};
            if (!common_var_large_wstring_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_large_wstring member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_large_wstring = "var_large_wstring";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_large_wstring;
            ann_custom_LargeWStringStruct.reset();
            CompleteMemberDetail detail_var_large_wstring = TypeObjectUtils::build_complete_member_detail(name_var_large_wstring, member_ann_builtin_var_large_wstring, ann_custom_LargeWStringStruct);
            CompleteStructMember member_var_large_wstring = TypeObjectUtils::build_complete_struct_member(common_var_large_wstring, detail_var_large_wstring);
            TypeObjectUtils::add_complete_struct_member(member_seq_LargeWStringStruct, member_var_large_wstring);
        }
        CompleteStructType struct_type_LargeWStringStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_LargeWStringStruct, header_LargeWStringStruct, member_seq_LargeWStringStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_LargeWStringStruct, type_name_LargeWStringStruct.to_string(), type_ids_LargeWStringStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "LargeWStringStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
