#!/usr/bin/perl
############################################################################
#     menusconfig2pot.pl - create a pot file from menus.config
#                            -------------------
#   begin                : Sat Dec 20 2014
#   copyright            : (C) 2014 by Thomas Eschenbacher
#   email                : Thomas.Eschenbacher@gmx.de
############################################################################
#
############################################################################
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
############################################################################

open (IN,  "<$ARGV[0]") or die("open input file failed");
open (OUT, ">$ARGV[1]") or die("open output file failed");

print OUT "# Kwave menu translation template\n";
print OUT "# this file was automatically generated by 'menusconfig2cpp.pl'\n";
print OUT "# at " . localtime() . " -> DO NOT EDIT !\n";
print OUT "#\n";
print OUT "msgid \"\"\n";
print OUT "msgstr \"\"\n";
print OUT "\n";

my @all_tokens;
my $line_nr = 0;

LINE: while (<IN>) {
    my $line = $_;
    $line_nr += 1;

    $line =~ s/\s+$//;
    $line =~ s/^\s+|\s+$//g;

    next LINE if /^$/ or /^\#/;

    $line =~ /^menu\s*\((.*)\)/;
    my $params = $1;
    next LINE if /^$/;

    # separate into parameters, we need only the second one (path)
    # NOTE: escaping is not handled here (not needed yet)
    my $nesting = 0;
    my $param = "";
    my $param_nr = 0;
    my $path = "";
    for (my $i = 0; $i < length($params); $i += 1) {
        my $c = substr($params, $i, 1);
        $nesting += 1 if ($c eq "(");
        $nesting -= 1 if ($c eq ")");
        if (($c eq ",") and ($nesting == 0)) {
            $param_nr += 1;
            $path = $param if ($param_nr == 2);
            $param = "";
        }
        else
        {
            $param = $param . $c;
        }
    }
    $param_nr += 1;
    $path = $param if ($param_nr == 2);
    next LINE if ($path eq "");

    # split the path into a list of tokens
    my $context = "";
    my @tokens = split(/\//, $path);
    TOKEN: foreach $token (@tokens) {
        $token =~ s/\s+$//;
        $token =~ s/^\s+|\s+$//g;
        next TOKEN if (length($token) <= 1);
        last       if ($token =~ /^\#/);
        $token =~ s/\"/\\\"/g;

        $context = $context . "/" . $token;
        if (not grep {$_->{"context"} eq $context} @all_tokens) {
            push @all_tokens, {
                "token"   => $token,
                "context" => $context,
                "line"    => $line_nr
            };
        }
    }
}

# produce the output, sorted by token
my @sorted = sort { $a->{"token"} cmp $b->{"token"} } @all_tokens;
foreach $token (@sorted) {
    print OUT "#: kwave/menus.config:" . $token->{"line"} . "\n";
    print OUT "msgctxt \"menu: " . $token->{"context"} . "\"\n";
    print OUT "msgid \"" . $token->{"token"} . "\"\n";
    print OUT "msgstr \"\"\n";
    print OUT "\n";
}

print OUT "### end of file ###\n";

close OUT;
close IN;

### EOF ###
