//------------------------------------------------------------------------------
// This file is part of the OpenStructure project <www.openstructure.org>
//
// Copyright (C) 2008-2020 by the OpenStructure authors
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License as published by the Free
// Software Foundation; either version 3.0 of the License, or (at your option)
// any later version.
// This library is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
// details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
//------------------------------------------------------------------------------

// automatically generated by generate_map_iso_spec.py
// do not edit directly

#include "map_iso_gen.hh"

namespace ost { namespace gfx { namespace map_iso {

template<int N>
void AddLinesAndFaces(IndexedVertexArray& va, // vertex array
		      unsigned int vertex_id[12] // this list of vertex ids
		      );

template<> 
void AddLinesAndFaces<0>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
}

template<> 
void AddLinesAndFaces<1>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 1 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 1 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 1 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<2>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddTriN(vertex_id[5],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 2 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 2 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 2 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<3>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 3 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 3 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 3 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 3 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 3 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 3 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<4>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 4 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 4 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 4 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<5>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 5 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 5 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 5 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 5 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 5 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 5 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 5 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 5 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 5 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 5 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 5 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 5 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<6>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 6 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 6 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 6 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 6 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 6 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 6 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<7>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 7 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 7 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 7 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 7 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 7 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 7 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 7 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 7 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 7 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<8>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 8 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 8 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 8 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<9>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 9 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 9 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 9 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 9 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 9 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 9 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<10>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 10 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 10 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 10 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 10 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 10 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 10 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 10 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 10 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 10 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 10 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 10 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 10 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<11>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 11 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 11 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 11 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 11 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 11 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 11 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 11 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 11 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 11 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<12>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 12 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 12 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 12 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 12 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 12 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 12 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<13>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 13 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 13 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 13 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 13 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 13 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 13 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[6],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 13 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 13 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 13 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<14>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 14 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 14 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 14 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 14 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 14 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 14 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 14 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 14 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 14 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<15>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[5],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 15 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 15 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 15 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[6],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 15 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 15 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 15 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<16>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[11],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 16 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 16 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 16 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<17>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 17 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 17 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 17 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 17 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 17 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 17 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<18>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[5],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 18 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 18 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 18 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 18 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 18 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 18 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 18 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 18 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 18 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 18 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 18 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 18 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 18 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 18 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 18 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<19>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 19 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 19 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 19 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 19 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 19 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 19 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 19 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 19 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 19 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<20>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 20 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 20 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 20 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 20 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 20 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 20 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<21>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 21 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 21 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 21 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 21 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 21 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 21 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 21 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 21 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 21 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 21 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 21 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 21 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 21 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 21 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 21 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<22>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 22 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 22 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 22 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 22 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 22 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 22 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 22 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 22 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 22 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 22 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 22 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 22 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<23>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 23 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 23 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 23 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 23 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 23 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 23 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 23 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 23 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 23 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 23 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 23 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 23 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<24>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 24 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 24 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 24 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 24 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 24 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 24 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 24 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 24 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 24 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 24 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 24 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 24 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<25>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 25 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 25 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 25 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 25 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 25 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 25 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 25 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 25 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 25 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<26>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 26 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 26 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 26 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 26 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 26 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 26 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 26 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 26 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 26 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 26 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 26 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 26 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 26 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 26 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 26 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 26 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 26 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<27>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 27 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 27 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 27 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 27 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 27 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 27 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 27 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 27 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 27 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 27 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 27 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 27 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<28>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 28 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 28 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 28 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 28 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 28 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 28 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 28 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 28 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 28 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 28 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 28 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 28 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 28 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 28 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 28 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<29>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 29 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 29 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 29 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 29 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 29 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 29 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 29 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 29 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 29 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[6],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 29 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 29 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 29 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<30>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 30 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 30 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 30 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 30 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 30 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 30 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 30 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 30 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 30 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 30 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[3],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 30 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 30 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[7],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 30 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 30 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 30 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 30 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 30 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 30 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 30 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 30 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 30 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 30 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<31>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 31 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 31 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 31 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 31 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 31 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 31 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 31 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 31 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 31 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<32>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 32 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 32 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 32 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<33>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 33 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 33 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 33 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 33 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 33 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 33 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 33 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 33 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 33 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 33 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 33 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 33 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<34>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[9],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 34 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 34 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 34 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 34 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 34 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 34 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<35>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 35 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 35 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 35 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 35 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 35 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 35 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 35 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 35 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 35 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<36>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 36 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 36 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 36 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 36 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 36 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 36 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 36 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 36 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 36 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 36 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 36 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 36 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 36 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 36 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 36 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<37>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 37 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 37 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 37 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 37 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 37 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 37 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 37 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 37 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 37 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 37 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 37 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 37 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 37 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 37 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 37 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 37 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 37 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 37 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 37 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<38>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 38 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 38 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 38 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 38 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 38 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 38 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 38 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 38 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 38 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<39>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 39 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 39 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 39 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 39 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 39 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 39 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 39 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 39 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 39 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 39 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 39 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 39 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<40>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 40 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 40 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 40 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 40 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 40 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 40 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<41>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 41 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 41 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 41 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 41 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 41 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 41 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 41 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 41 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 41 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 41 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 41 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 41 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 41 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 41 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 41 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 41 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 41 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 41 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 41 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 41 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 41 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<42>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 42 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 42 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 42 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 42 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 42 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 42 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 42 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 42 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 42 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 42 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 42 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 42 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 42 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 42 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 42 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<43>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 43 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 43 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 43 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 43 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 43 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 43 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 43 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 43 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 43 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 43 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 43 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 43 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<44>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 44 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 44 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 44 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 44 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 44 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 44 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 44 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 44 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 44 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 44 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 44 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 44 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<45>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 45 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 45 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 45 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 45 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 45 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 45 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[6],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 45 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 45 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 45 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 45 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 45 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 45 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 45 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 45 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 45 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<46>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 46 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 46 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 46 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 46 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 46 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 46 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 46 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 46 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 46 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 46 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 46 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 46 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<47>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 47 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 47 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 47 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 47 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 47 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 47 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 47 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 47 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 47 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<48>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[9],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 48 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 48 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 48 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 48 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 48 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 48 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<49>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 49 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 49 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 49 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 49 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 49 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 49 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 49 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 49 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 49 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<50>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[9],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 50 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 50 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 50 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 50 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 50 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 50 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 50 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 50 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 50 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<51>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 51 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 51 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 51 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 51 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 51 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 51 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<52>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 52 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 52 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 52 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 52 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 52 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 52 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 52 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 52 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 52 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 52 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 52 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 52 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 52 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 52 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 52 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 52 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 52 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 52 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 52 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 52 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 52 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<53>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 53 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 53 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 53 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 53 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 53 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 53 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 53 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 53 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 53 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 53 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 53 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 53 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 53 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 53 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<54>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 54 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 54 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 54 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 54 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 54 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 54 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 54 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 54 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 54 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 54 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 54 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 54 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<55>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 55 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 55 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 55 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 55 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 55 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 55 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 55 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 55 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 55 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<56>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 56 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 56 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 56 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 56 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 56 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 56 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 56 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 56 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 56 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 56 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 56 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 56 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 56 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 56 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 56 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<57>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 57 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 57 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 57 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 57 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 57 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 57 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 57 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 57 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 57 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 57 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 57 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 57 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<58>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 58 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 58 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 58 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 58 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 58 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 58 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 58 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 58 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 58 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 58 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 58 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 58 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 58 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 58 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 58 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 58 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 58 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 58 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<59>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 59 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 59 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 59 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 59 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 59 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 59 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 59 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 59 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 59 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<60>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[4],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 60 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 60 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 60 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 60 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 60 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 60 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 60 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 60 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 60 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 60 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 60 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 60 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 60 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 60 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 60 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 60 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 60 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 60 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 60 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 60 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 60 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 60 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 60 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 60 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<61>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 61 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 61 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 61 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 61 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 61 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 61 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 61 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 61 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 61 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 61 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 61 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 61 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 61 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 61 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 61 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<62>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 62 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 62 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 62 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 62 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 62 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 62 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 62 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 62 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 62 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 62 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 62 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 62 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 62 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 62 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 62 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<63>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 63 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 63 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 63 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 63 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 63 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 63 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<64>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[9],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 64 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 64 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 64 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<65>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 65 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 65 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 65 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 65 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 65 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 65 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<66>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[5],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 66 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 66 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 66 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 66 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 66 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 66 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 66 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 66 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 66 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 66 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 66 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 66 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<67>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 67 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 67 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 67 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 67 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 67 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 67 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 67 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 67 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 67 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 67 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 67 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 67 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 67 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 67 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 67 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<68>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[10],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 68 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 68 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 68 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 68 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 68 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 68 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<69>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 69 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 69 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 69 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 69 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 69 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 69 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 69 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 69 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 69 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 69 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 69 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 69 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 69 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 69 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 69 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<70>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[10],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 70 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 70 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 70 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 70 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 70 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 70 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 70 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 70 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 70 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<71>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 71 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 71 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 71 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 71 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 71 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 71 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 71 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 71 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 71 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 71 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 71 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 71 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<72>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 72 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 72 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 72 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 72 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 72 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 72 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 72 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 72 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 72 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 72 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 72 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 72 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 72 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 72 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 72 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<73>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 73 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 73 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 73 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 73 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 73 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 73 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 73 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 73 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 73 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 73 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 73 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 73 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 73 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 73 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 73 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<74>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 74 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 74 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 74 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 74 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 74 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 74 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 74 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 74 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 74 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 74 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 74 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 74 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 74 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 74 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 74 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 74 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 74 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 74 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 74 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 74 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<75>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 75 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 75 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 75 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 75 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 75 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 75 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 75 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 75 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 75 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 75 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 75 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 75 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 75 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 75 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 75 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 75 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 75 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 75 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 75 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 75 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 75 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 75 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 75 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 75 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<76>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 76 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 76 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 76 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 76 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 76 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 76 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 76 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 76 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 76 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<77>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 77 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 77 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 77 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 77 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 77 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 77 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 77 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 77 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 77 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 77 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 77 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 77 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<78>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 78 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 78 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 78 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 78 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 78 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 78 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 78 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 78 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 78 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 78 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 78 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 78 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<79>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[5],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 79 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 79 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 79 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 79 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 79 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 79 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 79 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 79 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 79 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<80>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 80 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 80 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 80 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 80 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 80 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 80 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 80 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 80 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 80 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 80 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 80 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 80 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<81>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 81 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 81 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 81 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 81 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 81 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 81 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 81 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 81 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 81 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 81 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 81 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 81 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 81 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 81 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 81 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 81 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 81 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 81 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 81 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 81 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 81 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<82>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[5],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 82 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 82 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 82 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 82 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 82 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 82 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 82 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 82 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 82 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 82 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 82 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 82 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 82 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 82 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 82 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 82 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 82 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 82 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 82 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<83>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 83 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 83 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 83 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 83 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 83 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 83 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 83 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 83 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 83 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 83 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 83 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 83 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 83 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 83 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 83 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 83 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<84>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 84 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 84 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 84 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 84 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 84 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 84 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 84 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 84 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 84 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 84 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 84 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 84 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 84 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 84 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 84 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 84 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 84 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 84 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 84 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 84 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 84 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<85>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 85 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 85 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 85 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 85 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 85 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 85 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 85 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 85 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 85 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 85 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 85 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 85 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 85 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 85 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 85 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 85 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 85 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 85 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 85 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 85 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 85 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 85 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 85 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 85 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<86>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[10],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 86 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 86 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 86 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 86 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 86 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 86 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 86 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 86 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 86 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 86 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 86 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 86 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 86 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 86 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 86 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<87>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 87 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 87 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 87 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 87 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 87 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 87 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 87 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 87 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 87 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 87 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 87 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 87 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 87 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 87 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 87 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 87 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 87 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 87 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 87 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 87 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 87 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<88>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[4],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 88 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 88 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 88 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 88 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 88 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[6],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 88 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 88 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 88 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 88 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 88 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 88 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 88 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 88 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 88 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 88 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 88 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 88 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 88 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 88 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 88 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<89>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 89 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 89 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 89 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 89 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 89 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 89 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 89 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 89 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 89 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 89 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 89 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 89 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 89 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 89 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 89 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 89 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 89 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 89 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 89 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 89 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 89 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 89 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 89 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 89 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<90>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 90 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 90 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 90 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 90 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 90 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 90 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 90 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 90 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 90 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 90 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 90 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 90 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 90 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 90 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 90 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 90 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 90 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 90 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 90 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 90 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 90 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 90 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 90 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 90 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 90 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 90 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 90 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 90 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 90 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 90 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 90 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 90 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<91>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 91 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 91 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 91 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 91 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 91 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 91 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 91 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 91 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 91 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 91 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 91 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 91 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 91 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 91 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 91 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 91 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 91 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 91 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 91 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 91 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<92>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[4],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 92 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 92 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 92 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 92 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 92 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 92 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 92 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 92 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 92 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 92 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 92 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 92 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 92 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 92 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 92 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 92 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 92 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 92 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 92 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 92 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 92 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 92 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 92 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 92 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<93>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 93 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 93 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 93 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 93 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 93 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 93 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 93 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 93 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 93 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 93 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 93 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 93 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 93 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 93 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 93 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<94>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 94 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 94 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 94 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 94 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 94 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 94 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 94 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 94 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 94 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 94 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 94 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 94 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 94 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 94 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 94 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 94 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 94 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 94 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 94 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 94 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<95>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 95 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 95 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 95 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[7],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 95 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 95 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 95 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 95 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 95 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 95 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 95 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 95 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 95 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<96>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[10],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 96 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 96 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 96 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 96 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 96 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 96 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<97>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 97 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 97 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 97 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 97 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 97 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 97 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 97 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 97 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 97 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 97 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 97 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 97 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 97 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 97 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 97 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<98>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 98 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 98 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 98 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 98 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 98 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 98 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 98 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 98 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 98 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<99>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 99 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 99 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 99 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 99 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 99 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 99 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 99 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 99 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 99 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 99 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 99 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 99 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<100>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[10],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 100 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 100 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 100 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 100 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 100 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 100 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 100 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 100 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 100 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<101>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 101 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 101 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 101 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 101 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 101 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 101 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 101 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 101 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 101 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 101 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 101 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 101 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 101 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 101 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<102>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[10],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 102 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 102 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 102 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 102 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 102 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 102 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<103>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 103 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 103 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 103 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 103 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 103 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 103 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 103 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 103 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 103 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<104>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 104 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 104 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 104 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 104 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 104 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 104 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 104 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 104 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 104 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 104 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 104 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 104 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 104 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 104 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 104 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 104 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 104 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 104 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 104 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 104 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 104 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<105>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 105 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 105 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 105 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 105 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 105 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 105 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 105 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 105 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 105 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 105 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 105 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 105 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 105 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 105 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 105 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 105 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 105 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 105 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 105 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 105 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 105 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 105 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<106>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 106 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 106 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 106 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 106 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 106 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 106 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 106 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 106 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 106 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 106 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 106 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 106 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 106 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 106 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 106 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 106 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 106 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 106 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 106 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 106 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 106 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 106 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 106 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 106 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<107>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 107 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 107 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 107 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 107 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 107 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 107 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 107 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 107 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 107 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 107 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 107 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 107 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 107 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 107 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 107 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<108>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 108 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 108 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 108 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 108 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 108 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 108 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 108 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 108 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 108 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 108 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 108 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 108 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<109>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 109 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 109 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 109 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 109 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 109 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 109 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 109 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 109 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 109 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 109 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 109 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 109 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<110>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 110 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 110 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 110 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 110 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 110 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 110 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 110 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 110 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 110 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<111>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[10],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 111 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 111 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 111 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 111 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 111 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 111 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<112>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 112 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 112 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 112 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 112 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 112 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 112 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 112 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 112 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 112 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<113>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 113 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 113 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 113 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 113 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 113 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 113 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 113 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 113 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 113 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 113 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 113 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 113 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<114>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 114 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 114 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 114 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 114 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 114 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 114 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 114 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 114 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 114 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 114 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 114 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 114 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<115>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 115 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 115 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 115 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 115 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 115 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 115 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 115 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 115 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 115 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<116>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[10],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 116 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 116 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 116 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 116 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 116 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 116 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 116 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 116 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 116 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 116 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 116 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 116 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<117>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 117 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 117 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 117 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 117 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 117 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 117 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 117 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 117 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 117 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 117 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 117 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 117 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 117 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 117 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 117 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<118>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[10],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 118 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 118 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 118 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 118 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 118 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 118 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 118 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 118 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 118 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<119>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 119 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 119 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 119 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 119 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 119 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 119 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<120>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[4],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 120 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 120 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 120 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 120 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 120 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 120 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 120 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 120 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 120 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 120 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 120 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 120 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 120 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 120 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 120 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 120 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 120 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 120 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 120 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 120 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 120 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 120 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 120 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 120 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<121>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 121 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 121 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 121 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 121 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 121 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 121 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 121 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 121 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 121 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 121 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 121 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 121 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 121 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 121 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 121 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<122>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 122 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 122 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 122 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 122 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 122 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 122 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 122 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 122 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 122 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 122 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 122 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 122 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 122 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 122 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 122 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 122 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 122 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 122 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 122 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 122 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<123>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 123 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 123 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 123 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 123 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 123 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 123 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 123 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 123 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 123 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 123 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 123 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 123 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<124>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[4],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 124 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 124 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 124 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 124 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 124 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 124 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 124 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 124 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 124 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 124 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 124 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 124 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 124 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 124 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 124 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<125>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 125 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 125 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 125 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 125 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 125 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 125 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<126>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 126 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 126 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 126 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 126 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 126 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 126 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 126 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 126 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 126 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 126 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 126 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 126 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<127>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 127 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 127 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 127 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<128>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 128 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 128 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 128 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<129>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 129 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 129 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 129 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 129 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 129 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 129 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 129 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 129 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 129 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 129 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 129 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 129 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<130>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[5],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 130 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 130 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 130 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 130 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 130 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 130 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<131>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 131 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 131 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 131 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 131 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 131 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 131 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 131 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 131 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 131 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 131 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 131 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 131 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 131 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 131 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 131 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<132>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 132 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 132 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 132 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 132 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 132 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 132 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 132 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 132 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 132 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 132 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 132 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 132 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<133>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 133 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 133 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 133 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 133 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 133 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 133 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 133 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 133 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 133 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 133 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 133 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 133 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 133 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 133 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 133 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 133 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 133 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 133 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 133 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 133 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<134>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 134 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 134 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 134 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 134 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 134 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 134 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 134 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 134 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 134 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 134 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 134 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 134 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 134 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 134 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 134 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<135>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 135 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 135 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 135 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 135 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 135 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 135 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 135 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 135 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 135 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 135 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 135 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 135 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 135 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 135 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 135 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 135 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 135 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 135 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 135 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 135 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 135 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 135 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 135 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 135 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<136>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 136 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 136 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 136 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 136 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 136 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 136 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<137>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 137 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 137 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 137 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 137 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 137 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 137 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 137 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 137 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 137 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<138>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 138 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 138 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 138 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 138 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 138 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 138 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 138 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 138 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 138 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 138 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 138 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 138 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 138 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 138 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 138 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<139>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 139 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 139 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 139 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 139 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 139 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 139 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 139 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 139 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 139 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 139 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 139 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 139 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<140>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 140 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 140 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 140 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 140 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 140 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 140 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 140 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 140 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 140 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<141>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 141 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 141 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 141 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 141 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 141 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 141 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[10],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 141 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 141 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 141 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 141 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 141 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 141 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<142>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 142 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 142 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 142 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 142 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 142 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 142 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 142 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 142 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 142 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 142 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 142 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 142 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<143>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[5],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 143 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 143 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 143 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[10],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 143 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 143 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 143 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 143 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 143 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 143 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<144>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 144 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 144 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 144 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 144 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 144 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 144 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<145>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 145 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 145 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 145 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 145 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 145 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 145 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 145 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 145 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 145 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<146>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[5],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 146 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 146 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 146 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 146 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 146 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 146 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 146 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 146 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 146 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 146 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 146 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<147>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 147 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 147 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 147 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 147 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 147 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 147 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 147 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 147 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 147 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 147 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 147 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 147 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<148>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 148 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 148 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 148 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 148 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 148 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 148 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 148 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 148 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 148 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 148 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 148 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 148 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 148 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 148 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 148 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<149>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 149 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 149 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 149 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 149 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 149 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 149 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 149 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 149 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 149 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 149 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 149 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 149 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 149 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 149 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 149 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 149 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 149 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 149 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 149 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 149 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 149 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 149 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 149 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 149 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<150>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 150 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 150 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 150 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 150 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 150 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 150 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 150 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 150 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 150 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 150 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 150 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 150 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 150 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 150 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 150 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 150 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 150 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 150 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 150 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 150 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 150 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 150 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<151>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 151 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 151 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 151 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 151 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 151 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 151 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 151 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 151 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 151 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 151 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 151 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 151 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 151 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 151 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 151 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 151 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 151 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 151 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 151 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 151 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 151 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<152>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[4],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 152 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 152 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 152 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 152 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 152 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 152 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 152 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 152 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 152 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<153>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 153 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 153 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 153 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 153 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 153 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 153 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<154>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 154 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 154 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 154 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 154 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 154 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 154 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 154 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 154 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 154 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 154 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 154 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 154 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 154 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 154 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<155>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 155 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 155 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 155 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 155 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 155 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 155 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 155 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 155 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 155 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<156>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[4],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 156 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 156 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 156 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 156 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 156 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 156 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 156 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 156 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 156 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 156 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 156 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 156 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<157>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 157 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 157 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 157 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 157 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 157 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 157 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 157 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 157 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 157 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<158>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 158 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 158 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 158 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 158 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 158 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 158 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 158 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 158 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 158 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 158 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 158 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 158 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 158 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 158 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 158 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<159>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 159 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 159 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 159 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 159 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 159 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 159 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<160>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 160 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 160 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 160 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 160 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 160 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 160 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 160 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 160 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 160 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 160 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 160 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 160 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<161>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 161 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 161 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 161 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 161 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 161 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 161 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 161 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 161 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 161 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 161 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 161 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 161 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 161 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 161 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 161 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 161 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 161 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 161 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 161 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 161 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<162>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[9],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 162 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 162 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 162 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 162 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 162 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 162 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 162 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 162 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 162 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 162 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 162 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 162 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 162 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 162 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 162 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<163>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 163 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 163 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 163 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 163 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 163 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 163 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 163 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 163 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 163 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 163 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 163 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 163 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 163 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 163 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 163 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 163 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 163 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 163 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 163 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 163 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 163 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 163 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 163 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 163 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<164>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 164 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 164 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 164 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 164 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 164 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 164 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 164 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 164 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 164 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 164 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 164 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 164 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 164 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 164 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 164 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 164 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 164 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 164 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 164 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<165>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 165 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 165 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 165 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 165 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 165 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 165 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 165 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 165 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 165 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 165 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 165 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 165 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 165 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 165 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 165 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 165 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 165 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 165 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 165 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 165 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 165 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 165 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 165 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 165 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 165 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 165 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 165 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 165 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 165 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 165 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 165 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 165 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<166>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 166 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 166 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 166 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 166 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 166 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 166 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 166 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 166 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 166 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 166 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 166 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 166 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 166 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 166 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 166 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 166 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 166 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 166 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 166 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 166 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 166 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 166 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 166 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 166 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<167>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 167 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 167 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 167 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 167 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 167 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 167 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 167 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 167 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 167 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 167 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 167 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 167 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 167 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 167 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 167 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 167 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 167 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 167 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 167 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 167 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<168>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 168 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 168 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 168 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 168 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 168 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 168 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 168 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 168 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 168 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 168 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 168 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 168 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 168 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 168 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 168 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 168 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 168 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 168 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 168 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 168 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 168 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<169>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 169 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 169 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 169 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 169 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 169 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 169 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 169 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 169 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 169 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 169 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 169 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 169 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 169 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 169 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 169 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 169 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<170>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 170 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 170 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 170 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 170 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 170 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 170 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 170 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 170 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 170 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 170 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 170 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 170 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 170 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 170 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 170 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 170 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 170 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 170 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 170 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 170 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 170 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 170 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 170 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 170 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<171>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 171 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 171 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 171 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 171 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 171 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 171 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 171 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 171 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 171 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 171 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 171 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 171 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 171 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 171 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 171 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 171 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 171 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 171 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 171 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 171 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 171 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<172>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 172 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 172 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 172 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 172 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 172 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 172 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 172 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 172 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 172 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 172 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 172 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 172 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 172 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 172 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 172 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<173>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 173 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 173 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 173 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 173 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 173 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 173 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 173 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 173 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 173 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 173 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 173 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 173 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 173 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 173 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 173 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 173 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 173 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 173 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 173 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 173 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<174>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[11],vertex_id[10],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 174 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 174 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 174 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 174 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 174 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 174 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 174 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 174 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 174 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 174 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 174 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 174 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 174 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 174 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 174 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 174 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 174 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 174 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 174 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 174 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 174 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<175>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[8]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddLine(vertex_id[11],vertex_id[10]);
  va.AddTriN(vertex_id[8],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 175 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 175 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 175 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 175 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 175 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 175 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 175 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 175 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 175 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 175 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 175 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 175 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<176>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[9],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 176 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 176 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 176 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 176 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 176 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 176 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 176 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 176 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 176 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<177>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 177 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 177 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 177 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 177 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 177 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 177 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 177 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 177 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 177 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 177 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 177 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 177 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<178>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[9],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 178 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 178 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 178 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 178 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 178 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 178 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 178 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 178 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 178 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 178 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 178 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 178 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<179>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 179 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 179 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 179 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 179 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 179 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 179 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 179 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 179 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 179 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<180>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 180 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 180 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 180 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 180 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 180 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 180 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 180 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 180 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 180 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 180 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 180 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 180 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 180 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 180 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 180 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 180 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 180 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 180 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 180 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 180 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 180 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 180 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 180 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 180 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<181>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 181 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 181 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 181 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 181 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 181 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 181 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 181 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 181 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 181 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 181 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 181 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 181 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 181 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 181 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 181 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 181 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 181 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 181 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 181 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<182>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 182 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 182 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 182 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 182 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 182 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 182 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 182 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 182 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 182 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 182 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 182 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 182 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 182 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 182 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 182 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<183>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[7]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 183 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 183 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 183 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 183 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[2],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 183 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 183 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 183 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 183 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 183 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 183 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 183 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 183 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 183 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 183 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 183 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 183 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 183 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<184>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[4],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 184 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 184 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 184 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 184 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 184 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 184 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[2],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 184 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 184 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 184 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 184 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 184 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 184 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<185>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 185 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 185 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 185 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 185 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 185 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 185 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 185 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 185 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 185 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<186>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 186 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 186 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 186 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 186 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 186 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 186 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[10]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 186 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 186 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 186 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 186 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 186 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 186 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 186 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 186 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 186 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<187>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[10],vertex_id[2]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 187 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 187 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 187 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[10],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 187 << std::endl;
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 187 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 187 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<188>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[4],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 188 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 188 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 188 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 188 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 188 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 188 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 188 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 188 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 188 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 188 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 188 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 188 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 188 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 188 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 188 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<189>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 189 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 189 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 189 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 189 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 189 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 189 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 189 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 189 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 189 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 189 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 189 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 189 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<190>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 190 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 190 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 190 << std::endl;
#endif
  va.AddTriN(vertex_id[10],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 190 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 190 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 190 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<191>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[6]);
  va.AddLine(vertex_id[10],vertex_id[9]);
  va.AddTriN(vertex_id[10],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[10]==0) std::cerr << "ISO_DEBUG: " << 10 << " " << 191 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 191 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 191 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<192>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 192 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 192 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 192 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 192 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 192 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 192 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<193>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 193 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 193 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 193 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 193 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 193 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 193 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 193 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 193 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 193 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 193 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 193 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 193 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 193 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 193 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 193 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<194>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[5],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 194 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 194 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 194 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 194 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 194 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 194 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 194 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 194 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 194 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 194 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 194 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 194 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 194 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 194 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 194 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<195>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 195 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 195 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 195 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 195 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 195 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 195 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 195 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 195 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 195 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 195 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 195 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 195 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 195 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 195 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 195 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 195 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 195 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 195 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 195 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 195 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 195 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 195 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 195 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 195 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<196>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 196 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 196 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 196 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 196 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 196 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 196 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 196 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 196 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 196 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<197>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 197 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 197 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 197 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 197 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 197 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 197 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 197 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 197 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 197 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 197 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 197 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 197 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 197 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 197 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 197 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 197 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 197 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 197 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<198>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 198 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 198 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 198 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 198 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 198 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 198 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 198 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 198 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 198 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 198 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 198 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 198 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<199>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 199 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 199 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 199 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 199 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 199 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 199 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 199 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 199 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 199 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 199 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 199 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 199 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[9],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 199 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 199 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 199 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<200>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 200 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 200 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 200 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 200 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 200 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 200 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 200 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 200 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 200 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<201>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 201 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 201 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 201 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 201 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 201 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 201 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 201 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 201 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 201 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 201 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 201 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 201 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<202>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 202 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 202 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 202 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 202 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 202 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 202 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 202 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 202 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 202 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 202 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 202 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 202 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 202 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 202 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 202 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 202 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 202 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 202 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 202 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 202 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 202 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 202 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<203>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 203 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 203 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 203 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 203 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 203 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 203 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 203 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 203 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 203 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 203 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 203 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 203 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 203 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 203 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 203 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 203 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 203 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 203 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 203 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 203 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 203 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<204>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 204 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 204 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 204 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 204 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 204 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 204 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<205>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 205 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 205 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 205 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 205 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 205 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 205 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[9],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 205 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 205 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 205 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<206>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 206 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 206 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 206 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 206 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 206 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 206 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 206 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 206 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 206 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<207>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[9]);
  va.AddTriN(vertex_id[5],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 207 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 207 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 207 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[9],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 207 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 207 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 207 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<208>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 208 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 208 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 208 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 208 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 208 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 208 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 208 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 208 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 208 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<209>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 209 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 209 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 209 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 209 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 209 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 209 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 209 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 209 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 209 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 209 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 209 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 209 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<210>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 210 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 210 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 210 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 210 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 210 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 210 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 210 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 210 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 210 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 210 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 210 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 210 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 210 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 210 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 210 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<211>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 211 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 211 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 211 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 211 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 211 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 211 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 211 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 211 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 211 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 211 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 211 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 211 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<212>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 212 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 212 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 212 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 212 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 212 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 212 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 212 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 212 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 212 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 212 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 212 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 212 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<213>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 213 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 213 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 213 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 213 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 213 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 213 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 213 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 213 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 213 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 213 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 213 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 213 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 213 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 213 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 213 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<214>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 214 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 214 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 214 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 214 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 214 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 214 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 214 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 214 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 214 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 214 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 214 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 214 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 214 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 214 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 214 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 214 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 214 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 214 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 214 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 214 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 214 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<215>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 215 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 215 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 215 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 215 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 215 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 215 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<216>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[4],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 216 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 216 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 216 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 216 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 216 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 216 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 216 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 216 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 216 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 216 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 216 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 216 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<217>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 217 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 217 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 217 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 217 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 217 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 217 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 217 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 217 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 217 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<218>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 218 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 218 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 218 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 218 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 218 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 218 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 218 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 218 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 218 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 218 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 218 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 218 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 218 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 218 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 218 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 218 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 218 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 218 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 218 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<219>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[6]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 219 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 219 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 219 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 219 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 219 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 219 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 219 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 219 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 219 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 219 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 219 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 219 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 219 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 219 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 219 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 219 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 219 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<220>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[4],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 220 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 220 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 220 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[1],vertex_id[9]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 220 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 220 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 220 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 220 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 220 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 220 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<221>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[9],vertex_id[1]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 221 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 221 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 221 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[9],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 221 << std::endl;
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 221 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 221 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<222>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 222 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 222 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 222 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 222 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 222 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 222 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 222 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 222 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 222 << std::endl;
#endif
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 222 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 222 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 222 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<223>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[5]);
  va.AddLine(vertex_id[9],vertex_id[8]);
  va.AddTriN(vertex_id[9],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[9]==0) std::cerr << "ISO_DEBUG: " << 9 << " " << 223 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 223 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 223 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<224>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 224 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 224 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 224 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 224 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 224 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 224 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 224 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 224 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 224 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<225>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 225 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 225 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 225 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 225 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[5],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 225 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 225 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[4],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 225 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[7],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[3],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 225 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 225 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 225 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 225 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 225 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 225 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 225 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 225 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<226>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[6],vertex_id[11],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 226 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 226 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 226 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 226 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 226 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 226 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 226 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 226 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 226 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 226 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 226 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 226 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<227>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 227 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 227 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 227 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 227 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 227 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 227 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 227 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 227 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 227 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 227 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 227 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 227 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 227 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 227 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 227 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<228>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 228 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 228 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 228 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 228 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 228 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 228 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 228 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 228 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 228 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 228 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 228 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 228 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<229>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 229 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 229 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 229 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 229 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 229 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 229 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 229 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 229 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[8],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 229 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 229 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 229 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 229 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 229 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 229 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 229 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 229 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<230>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 230 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 230 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 230 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 230 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 230 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 230 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 230 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 230 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 230 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<231>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[7]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 231 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 231 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 231 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[11],vertex_id[3]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 231 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 231 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 231 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[8],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 231 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 231 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 231 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[11],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 231 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 231 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 231 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<232>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 232 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 232 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 232 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 232 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 232 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 232 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 232 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 232 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 232 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 232 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 232 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 232 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<233>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 233 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 233 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 233 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 233 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 233 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 233 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 233 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 233 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 233 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 233 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 233 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 233 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<234>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 234 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 234 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 234 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 234 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 234 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 234 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 234 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 234 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 234 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 234 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 234 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 234 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 234 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 234 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 234 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<235>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 235 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 235 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 235 << std::endl;
#endif
  va.AddTriN(vertex_id[8],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 235 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 235 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 235 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<236>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[11],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 236 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 236 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 236 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 236 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 236 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 236 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 236 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 236 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 236 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<237>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[8],vertex_id[5]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 237 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 237 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 237 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 237 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[0],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 237 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 237 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 237 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 237 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[4],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 237 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 237 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 237 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 237 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[8],vertex_id[11]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 237 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 237 << std::endl;
#endif
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 237 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 237 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 237 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<238>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[8],vertex_id[0]);
  va.AddLine(vertex_id[11],vertex_id[3]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[11],vertex_id[0],vertex_id[8]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 238 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 238 << std::endl;
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 238 << std::endl;
#endif
  va.AddTriN(vertex_id[11],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 238 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 238 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 238 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<239>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[8],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[4]);
  va.AddLine(vertex_id[11],vertex_id[8]);
  va.AddTriN(vertex_id[8],vertex_id[11],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[8]==0) std::cerr << "ISO_DEBUG: " << 8 << " " << 239 << std::endl;
  if(vertex_id[11]==0) std::cerr << "ISO_DEBUG: " << 11 << " " << 239 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 239 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<240>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 240 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 240 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 240 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 240 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 240 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 240 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<241>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 241 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 241 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 241 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 241 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 241 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 241 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 241 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 241 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 241 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<242>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[6],vertex_id[4],vertex_id[7]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 242 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 242 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 242 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 242 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 242 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 242 << std::endl;
#endif
  va.AddTriN(vertex_id[6],vertex_id[1],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 242 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 242 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 242 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<243>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddLine(vertex_id[7],vertex_id[6]);
  va.AddTriN(vertex_id[3],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 243 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 243 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 243 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 243 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 243 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 243 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<244>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddTriN(vertex_id[7],vertex_id[5],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 244 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 244 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 244 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 244 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 244 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 244 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 244 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 244 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 244 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<245>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 245 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 245 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 245 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 245 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 245 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 245 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 245 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 245 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 245 << std::endl;
#endif
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 245 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 245 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 245 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<246>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[4]);
  va.AddTriN(vertex_id[7],vertex_id[0],vertex_id[4]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 246 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 246 << std::endl;
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 246 << std::endl;
#endif
  va.AddTriN(vertex_id[7],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 246 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 246 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 246 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<247>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[2]);
  va.AddLine(vertex_id[7],vertex_id[3]);
  va.AddTriN(vertex_id[3],vertex_id[7],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 247 << std::endl;
  if(vertex_id[7]==0) std::cerr << "ISO_DEBUG: " << 7 << " " << 247 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 247 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<248>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddTriN(vertex_id[4],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 248 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 248 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 248 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[2],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 248 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 248 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 248 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[2]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 248 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 248 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 248 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<249>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddLine(vertex_id[6],vertex_id[5]);
  va.AddTriN(vertex_id[2],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 249 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 249 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 249 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 249 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 249 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 249 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<250>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[0]);
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[3],vertex_id[2]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddTriN(vertex_id[1],vertex_id[2],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 250 << std::endl;
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 250 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 250 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 250 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 250 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 250 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[1],vertex_id[6]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 250 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 250 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 250 << std::endl;
#endif
  va.AddTriN(vertex_id[2],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 250 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 250 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 250 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<251>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[2],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[1]);
  va.AddLine(vertex_id[6],vertex_id[2]);
  va.AddTriN(vertex_id[2],vertex_id[6],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[2]==0) std::cerr << "ISO_DEBUG: " << 2 << " " << 251 << std::endl;
  if(vertex_id[6]==0) std::cerr << "ISO_DEBUG: " << 6 << " " << 251 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 251 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<252>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[1]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddLine(vertex_id[5],vertex_id[4]);
  va.AddTriN(vertex_id[4],vertex_id[1],vertex_id[5]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 252 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 252 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 252 << std::endl;
#endif
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[1]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 252 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 252 << std::endl;
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 252 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<253>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[1],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[0]);
  va.AddLine(vertex_id[5],vertex_id[1]);
  va.AddTriN(vertex_id[1],vertex_id[5],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[1]==0) std::cerr << "ISO_DEBUG: " << 1 << " " << 253 << std::endl;
  if(vertex_id[5]==0) std::cerr << "ISO_DEBUG: " << 5 << " " << 253 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 253 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<254>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
  va.AddLine(vertex_id[3],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[0]);
  va.AddLine(vertex_id[4],vertex_id[3]);
  va.AddTriN(vertex_id[4],vertex_id[3],vertex_id[0]);

#ifdef MAP_ISO_DEBUG
  if(vertex_id[4]==0) std::cerr << "ISO_DEBUG: " << 4 << " " << 254 << std::endl;
  if(vertex_id[3]==0) std::cerr << "ISO_DEBUG: " << 3 << " " << 254 << std::endl;
  if(vertex_id[0]==0) std::cerr << "ISO_DEBUG: " << 0 << " " << 254 << std::endl;
#endif
}

template<> 
void AddLinesAndFaces<255>(IndexedVertexArray& va,unsigned int vertex_id[12] )
{
}

void GenerateLFList(AddLFList& lfl)
{
  lfl.clear();
  lfl.push_back(AddLinesAndFaces<0>);
  lfl.push_back(AddLinesAndFaces<1>);
  lfl.push_back(AddLinesAndFaces<2>);
  lfl.push_back(AddLinesAndFaces<3>);
  lfl.push_back(AddLinesAndFaces<4>);
  lfl.push_back(AddLinesAndFaces<5>);
  lfl.push_back(AddLinesAndFaces<6>);
  lfl.push_back(AddLinesAndFaces<7>);
  lfl.push_back(AddLinesAndFaces<8>);
  lfl.push_back(AddLinesAndFaces<9>);
  lfl.push_back(AddLinesAndFaces<10>);
  lfl.push_back(AddLinesAndFaces<11>);
  lfl.push_back(AddLinesAndFaces<12>);
  lfl.push_back(AddLinesAndFaces<13>);
  lfl.push_back(AddLinesAndFaces<14>);
  lfl.push_back(AddLinesAndFaces<15>);
  lfl.push_back(AddLinesAndFaces<16>);
  lfl.push_back(AddLinesAndFaces<17>);
  lfl.push_back(AddLinesAndFaces<18>);
  lfl.push_back(AddLinesAndFaces<19>);
  lfl.push_back(AddLinesAndFaces<20>);
  lfl.push_back(AddLinesAndFaces<21>);
  lfl.push_back(AddLinesAndFaces<22>);
  lfl.push_back(AddLinesAndFaces<23>);
  lfl.push_back(AddLinesAndFaces<24>);
  lfl.push_back(AddLinesAndFaces<25>);
  lfl.push_back(AddLinesAndFaces<26>);
  lfl.push_back(AddLinesAndFaces<27>);
  lfl.push_back(AddLinesAndFaces<28>);
  lfl.push_back(AddLinesAndFaces<29>);
  lfl.push_back(AddLinesAndFaces<30>);
  lfl.push_back(AddLinesAndFaces<31>);
  lfl.push_back(AddLinesAndFaces<32>);
  lfl.push_back(AddLinesAndFaces<33>);
  lfl.push_back(AddLinesAndFaces<34>);
  lfl.push_back(AddLinesAndFaces<35>);
  lfl.push_back(AddLinesAndFaces<36>);
  lfl.push_back(AddLinesAndFaces<37>);
  lfl.push_back(AddLinesAndFaces<38>);
  lfl.push_back(AddLinesAndFaces<39>);
  lfl.push_back(AddLinesAndFaces<40>);
  lfl.push_back(AddLinesAndFaces<41>);
  lfl.push_back(AddLinesAndFaces<42>);
  lfl.push_back(AddLinesAndFaces<43>);
  lfl.push_back(AddLinesAndFaces<44>);
  lfl.push_back(AddLinesAndFaces<45>);
  lfl.push_back(AddLinesAndFaces<46>);
  lfl.push_back(AddLinesAndFaces<47>);
  lfl.push_back(AddLinesAndFaces<48>);
  lfl.push_back(AddLinesAndFaces<49>);
  lfl.push_back(AddLinesAndFaces<50>);
  lfl.push_back(AddLinesAndFaces<51>);
  lfl.push_back(AddLinesAndFaces<52>);
  lfl.push_back(AddLinesAndFaces<53>);
  lfl.push_back(AddLinesAndFaces<54>);
  lfl.push_back(AddLinesAndFaces<55>);
  lfl.push_back(AddLinesAndFaces<56>);
  lfl.push_back(AddLinesAndFaces<57>);
  lfl.push_back(AddLinesAndFaces<58>);
  lfl.push_back(AddLinesAndFaces<59>);
  lfl.push_back(AddLinesAndFaces<60>);
  lfl.push_back(AddLinesAndFaces<61>);
  lfl.push_back(AddLinesAndFaces<62>);
  lfl.push_back(AddLinesAndFaces<63>);
  lfl.push_back(AddLinesAndFaces<64>);
  lfl.push_back(AddLinesAndFaces<65>);
  lfl.push_back(AddLinesAndFaces<66>);
  lfl.push_back(AddLinesAndFaces<67>);
  lfl.push_back(AddLinesAndFaces<68>);
  lfl.push_back(AddLinesAndFaces<69>);
  lfl.push_back(AddLinesAndFaces<70>);
  lfl.push_back(AddLinesAndFaces<71>);
  lfl.push_back(AddLinesAndFaces<72>);
  lfl.push_back(AddLinesAndFaces<73>);
  lfl.push_back(AddLinesAndFaces<74>);
  lfl.push_back(AddLinesAndFaces<75>);
  lfl.push_back(AddLinesAndFaces<76>);
  lfl.push_back(AddLinesAndFaces<77>);
  lfl.push_back(AddLinesAndFaces<78>);
  lfl.push_back(AddLinesAndFaces<79>);
  lfl.push_back(AddLinesAndFaces<80>);
  lfl.push_back(AddLinesAndFaces<81>);
  lfl.push_back(AddLinesAndFaces<82>);
  lfl.push_back(AddLinesAndFaces<83>);
  lfl.push_back(AddLinesAndFaces<84>);
  lfl.push_back(AddLinesAndFaces<85>);
  lfl.push_back(AddLinesAndFaces<86>);
  lfl.push_back(AddLinesAndFaces<87>);
  lfl.push_back(AddLinesAndFaces<88>);
  lfl.push_back(AddLinesAndFaces<89>);
  lfl.push_back(AddLinesAndFaces<90>);
  lfl.push_back(AddLinesAndFaces<91>);
  lfl.push_back(AddLinesAndFaces<92>);
  lfl.push_back(AddLinesAndFaces<93>);
  lfl.push_back(AddLinesAndFaces<94>);
  lfl.push_back(AddLinesAndFaces<95>);
  lfl.push_back(AddLinesAndFaces<96>);
  lfl.push_back(AddLinesAndFaces<97>);
  lfl.push_back(AddLinesAndFaces<98>);
  lfl.push_back(AddLinesAndFaces<99>);
  lfl.push_back(AddLinesAndFaces<100>);
  lfl.push_back(AddLinesAndFaces<101>);
  lfl.push_back(AddLinesAndFaces<102>);
  lfl.push_back(AddLinesAndFaces<103>);
  lfl.push_back(AddLinesAndFaces<104>);
  lfl.push_back(AddLinesAndFaces<105>);
  lfl.push_back(AddLinesAndFaces<106>);
  lfl.push_back(AddLinesAndFaces<107>);
  lfl.push_back(AddLinesAndFaces<108>);
  lfl.push_back(AddLinesAndFaces<109>);
  lfl.push_back(AddLinesAndFaces<110>);
  lfl.push_back(AddLinesAndFaces<111>);
  lfl.push_back(AddLinesAndFaces<112>);
  lfl.push_back(AddLinesAndFaces<113>);
  lfl.push_back(AddLinesAndFaces<114>);
  lfl.push_back(AddLinesAndFaces<115>);
  lfl.push_back(AddLinesAndFaces<116>);
  lfl.push_back(AddLinesAndFaces<117>);
  lfl.push_back(AddLinesAndFaces<118>);
  lfl.push_back(AddLinesAndFaces<119>);
  lfl.push_back(AddLinesAndFaces<120>);
  lfl.push_back(AddLinesAndFaces<121>);
  lfl.push_back(AddLinesAndFaces<122>);
  lfl.push_back(AddLinesAndFaces<123>);
  lfl.push_back(AddLinesAndFaces<124>);
  lfl.push_back(AddLinesAndFaces<125>);
  lfl.push_back(AddLinesAndFaces<126>);
  lfl.push_back(AddLinesAndFaces<127>);
  lfl.push_back(AddLinesAndFaces<128>);
  lfl.push_back(AddLinesAndFaces<129>);
  lfl.push_back(AddLinesAndFaces<130>);
  lfl.push_back(AddLinesAndFaces<131>);
  lfl.push_back(AddLinesAndFaces<132>);
  lfl.push_back(AddLinesAndFaces<133>);
  lfl.push_back(AddLinesAndFaces<134>);
  lfl.push_back(AddLinesAndFaces<135>);
  lfl.push_back(AddLinesAndFaces<136>);
  lfl.push_back(AddLinesAndFaces<137>);
  lfl.push_back(AddLinesAndFaces<138>);
  lfl.push_back(AddLinesAndFaces<139>);
  lfl.push_back(AddLinesAndFaces<140>);
  lfl.push_back(AddLinesAndFaces<141>);
  lfl.push_back(AddLinesAndFaces<142>);
  lfl.push_back(AddLinesAndFaces<143>);
  lfl.push_back(AddLinesAndFaces<144>);
  lfl.push_back(AddLinesAndFaces<145>);
  lfl.push_back(AddLinesAndFaces<146>);
  lfl.push_back(AddLinesAndFaces<147>);
  lfl.push_back(AddLinesAndFaces<148>);
  lfl.push_back(AddLinesAndFaces<149>);
  lfl.push_back(AddLinesAndFaces<150>);
  lfl.push_back(AddLinesAndFaces<151>);
  lfl.push_back(AddLinesAndFaces<152>);
  lfl.push_back(AddLinesAndFaces<153>);
  lfl.push_back(AddLinesAndFaces<154>);
  lfl.push_back(AddLinesAndFaces<155>);
  lfl.push_back(AddLinesAndFaces<156>);
  lfl.push_back(AddLinesAndFaces<157>);
  lfl.push_back(AddLinesAndFaces<158>);
  lfl.push_back(AddLinesAndFaces<159>);
  lfl.push_back(AddLinesAndFaces<160>);
  lfl.push_back(AddLinesAndFaces<161>);
  lfl.push_back(AddLinesAndFaces<162>);
  lfl.push_back(AddLinesAndFaces<163>);
  lfl.push_back(AddLinesAndFaces<164>);
  lfl.push_back(AddLinesAndFaces<165>);
  lfl.push_back(AddLinesAndFaces<166>);
  lfl.push_back(AddLinesAndFaces<167>);
  lfl.push_back(AddLinesAndFaces<168>);
  lfl.push_back(AddLinesAndFaces<169>);
  lfl.push_back(AddLinesAndFaces<170>);
  lfl.push_back(AddLinesAndFaces<171>);
  lfl.push_back(AddLinesAndFaces<172>);
  lfl.push_back(AddLinesAndFaces<173>);
  lfl.push_back(AddLinesAndFaces<174>);
  lfl.push_back(AddLinesAndFaces<175>);
  lfl.push_back(AddLinesAndFaces<176>);
  lfl.push_back(AddLinesAndFaces<177>);
  lfl.push_back(AddLinesAndFaces<178>);
  lfl.push_back(AddLinesAndFaces<179>);
  lfl.push_back(AddLinesAndFaces<180>);
  lfl.push_back(AddLinesAndFaces<181>);
  lfl.push_back(AddLinesAndFaces<182>);
  lfl.push_back(AddLinesAndFaces<183>);
  lfl.push_back(AddLinesAndFaces<184>);
  lfl.push_back(AddLinesAndFaces<185>);
  lfl.push_back(AddLinesAndFaces<186>);
  lfl.push_back(AddLinesAndFaces<187>);
  lfl.push_back(AddLinesAndFaces<188>);
  lfl.push_back(AddLinesAndFaces<189>);
  lfl.push_back(AddLinesAndFaces<190>);
  lfl.push_back(AddLinesAndFaces<191>);
  lfl.push_back(AddLinesAndFaces<192>);
  lfl.push_back(AddLinesAndFaces<193>);
  lfl.push_back(AddLinesAndFaces<194>);
  lfl.push_back(AddLinesAndFaces<195>);
  lfl.push_back(AddLinesAndFaces<196>);
  lfl.push_back(AddLinesAndFaces<197>);
  lfl.push_back(AddLinesAndFaces<198>);
  lfl.push_back(AddLinesAndFaces<199>);
  lfl.push_back(AddLinesAndFaces<200>);
  lfl.push_back(AddLinesAndFaces<201>);
  lfl.push_back(AddLinesAndFaces<202>);
  lfl.push_back(AddLinesAndFaces<203>);
  lfl.push_back(AddLinesAndFaces<204>);
  lfl.push_back(AddLinesAndFaces<205>);
  lfl.push_back(AddLinesAndFaces<206>);
  lfl.push_back(AddLinesAndFaces<207>);
  lfl.push_back(AddLinesAndFaces<208>);
  lfl.push_back(AddLinesAndFaces<209>);
  lfl.push_back(AddLinesAndFaces<210>);
  lfl.push_back(AddLinesAndFaces<211>);
  lfl.push_back(AddLinesAndFaces<212>);
  lfl.push_back(AddLinesAndFaces<213>);
  lfl.push_back(AddLinesAndFaces<214>);
  lfl.push_back(AddLinesAndFaces<215>);
  lfl.push_back(AddLinesAndFaces<216>);
  lfl.push_back(AddLinesAndFaces<217>);
  lfl.push_back(AddLinesAndFaces<218>);
  lfl.push_back(AddLinesAndFaces<219>);
  lfl.push_back(AddLinesAndFaces<220>);
  lfl.push_back(AddLinesAndFaces<221>);
  lfl.push_back(AddLinesAndFaces<222>);
  lfl.push_back(AddLinesAndFaces<223>);
  lfl.push_back(AddLinesAndFaces<224>);
  lfl.push_back(AddLinesAndFaces<225>);
  lfl.push_back(AddLinesAndFaces<226>);
  lfl.push_back(AddLinesAndFaces<227>);
  lfl.push_back(AddLinesAndFaces<228>);
  lfl.push_back(AddLinesAndFaces<229>);
  lfl.push_back(AddLinesAndFaces<230>);
  lfl.push_back(AddLinesAndFaces<231>);
  lfl.push_back(AddLinesAndFaces<232>);
  lfl.push_back(AddLinesAndFaces<233>);
  lfl.push_back(AddLinesAndFaces<234>);
  lfl.push_back(AddLinesAndFaces<235>);
  lfl.push_back(AddLinesAndFaces<236>);
  lfl.push_back(AddLinesAndFaces<237>);
  lfl.push_back(AddLinesAndFaces<238>);
  lfl.push_back(AddLinesAndFaces<239>);
  lfl.push_back(AddLinesAndFaces<240>);
  lfl.push_back(AddLinesAndFaces<241>);
  lfl.push_back(AddLinesAndFaces<242>);
  lfl.push_back(AddLinesAndFaces<243>);
  lfl.push_back(AddLinesAndFaces<244>);
  lfl.push_back(AddLinesAndFaces<245>);
  lfl.push_back(AddLinesAndFaces<246>);
  lfl.push_back(AddLinesAndFaces<247>);
  lfl.push_back(AddLinesAndFaces<248>);
  lfl.push_back(AddLinesAndFaces<249>);
  lfl.push_back(AddLinesAndFaces<250>);
  lfl.push_back(AddLinesAndFaces<251>);
  lfl.push_back(AddLinesAndFaces<252>);
  lfl.push_back(AddLinesAndFaces<253>);
  lfl.push_back(AddLinesAndFaces<254>);
  lfl.push_back(AddLinesAndFaces<255>);

}

}}} // ns
