# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, Optional, TypeVar

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._query_operations import build_query_twins_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class QueryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.digitaltwins.core.aio.AzureDigitalTwinsAPI`'s
        :attr:`query` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        args = list(args)
        self._client = args.pop(0) if args else kwargs.pop("client")
        self._config = args.pop(0) if args else kwargs.pop("config")
        self._serialize = args.pop(0) if args else kwargs.pop("serializer")
        self._deserialize = args.pop(0) if args else kwargs.pop("deserializer")


    @distributed_trace_async
    async def query_twins(
        self,
        query_specification: "_models.QuerySpecification",
        query_twins_options: Optional["_models.QueryTwinsOptions"] = None,
        **kwargs: Any
    ) -> "_models.QueryResult":
        """Executes a query that allows traversing relationships and filtering by property values.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * BadRequest - The continuation token is invalid.
          * SqlQueryError - The query contains some errors.
          * TimeoutError - The query execution timed out after 60 seconds. Try simplifying the query or
        adding conditions to reduce the result size.
          * 429 Too Many Requests
          * QuotaReachedError - The maximum query rate limit has been reached.

        :param query_specification: The query specification to execute.
        :type query_specification: ~azure.digitaltwins.core.models.QuerySpecification
        :param query_twins_options: Parameter group. Default value is None.
        :type query_twins_options: ~azure.digitaltwins.core.models.QueryTwinsOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: QueryResult, or the result of cls(response)
        :rtype: ~azure.digitaltwins.core.models.QueryResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.QueryResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-05-31")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _traceparent = None
        _tracestate = None
        _max_items_per_page = None
        if query_twins_options is not None:
            _traceparent = query_twins_options.traceparent
            _tracestate = query_twins_options.tracestate
            _max_items_per_page = query_twins_options.max_items_per_page
        _json = self._serialize.body(query_specification, 'QuerySpecification')

        request = build_query_twins_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            traceparent=_traceparent,
            tracestate=_tracestate,
            max_items_per_page=_max_items_per_page,
            template_url=self.query_twins.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['query-charge']=self._deserialize('float', response.headers.get('query-charge'))

        deserialized = self._deserialize('QueryResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    query_twins.metadata = {'url': "/query"}  # type: ignore

