
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IFSelect_EditForm.hxx>
#include <Interface_InterfaceModel.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_StepModel.hxx>
#include <Interface_Protocol.hxx>

// module includes
#include <APIHeaderSection_EditHeader.hxx>
#include <APIHeaderSection_MakeHeader.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <HeaderSection_FileName.hxx>
        #include <HeaderSection_FileSchema.hxx>
        #include <HeaderSection_FileDescription.hxx>

// Module definiiton
void register_APIHeaderSection(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("APIHeaderSection"));
py::object klass;

//Python trampoline classes

// classes

    // Class APIHeaderSection_EditHeader from ./opencascade/APIHeaderSection_EditHeader.hxx
    klass = m.attr("APIHeaderSection_EditHeader");


    // nested enums

    static_cast<py::class_<APIHeaderSection_EditHeader ,opencascade::handle<APIHeaderSection_EditHeader>  , IFSelect_Editor >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Label",
             (TCollection_AsciiString (APIHeaderSection_EditHeader::*)() const) static_cast<TCollection_AsciiString (APIHeaderSection_EditHeader::*)() const>(&APIHeaderSection_EditHeader::Label),
             R"#(None)#" 
          )
        .def("Recognize",
             (Standard_Boolean (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> &  ) const) static_cast<Standard_Boolean (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> &  ) const>(&APIHeaderSection_EditHeader::Recognize),
             R"#(None)#"  , py::arg("form")
          )
        .def("StringValue",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> & ,  const Standard_Integer  ) const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> & ,  const Standard_Integer  ) const>(&APIHeaderSection_EditHeader::StringValue),
             R"#(None)#"  , py::arg("form"),  py::arg("num")
          )
        .def("Apply",
             (Standard_Boolean (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> & ,  const opencascade::handle<Standard_Transient> & ,  const opencascade::handle<Interface_InterfaceModel> &  ) const) static_cast<Standard_Boolean (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> & ,  const opencascade::handle<Standard_Transient> & ,  const opencascade::handle<Interface_InterfaceModel> &  ) const>(&APIHeaderSection_EditHeader::Apply),
             R"#(None)#"  , py::arg("form"),  py::arg("ent"),  py::arg("model")
          )
        .def("Load",
             (Standard_Boolean (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> & ,  const opencascade::handle<Standard_Transient> & ,  const opencascade::handle<Interface_InterfaceModel> &  ) const) static_cast<Standard_Boolean (APIHeaderSection_EditHeader::*)( const opencascade::handle<IFSelect_EditForm> & ,  const opencascade::handle<Standard_Transient> & ,  const opencascade::handle<Interface_InterfaceModel> &  ) const>(&APIHeaderSection_EditHeader::Load),
             R"#(None)#"  , py::arg("form"),  py::arg("ent"),  py::arg("model")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&APIHeaderSection_EditHeader::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&APIHeaderSection_EditHeader::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (APIHeaderSection_EditHeader::*)() const) static_cast<const opencascade::handle<Standard_Type> & (APIHeaderSection_EditHeader::*)() const>(&APIHeaderSection_EditHeader::DynamicType),
             R"#(None)#"
             
         )
;

    // Class APIHeaderSection_MakeHeader from ./opencascade/APIHeaderSection_MakeHeader.hxx
    klass = m.attr("APIHeaderSection_MakeHeader");


    // nested enums

    static_cast<py::class_<APIHeaderSection_MakeHeader , shared_ptr<APIHeaderSection_MakeHeader>  >>(klass)
    // constructors
        .def(py::init< const Standard_Integer >()  , py::arg("shapetype")=static_cast<const Standard_Integer>(0) )
        .def(py::init< const opencascade::handle<StepData_StepModel> & >()  , py::arg("model") )
    // custom constructors
    // methods
        .def("Init",
             (void (APIHeaderSection_MakeHeader::*)( const Standard_CString  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const Standard_CString  ) >(&APIHeaderSection_MakeHeader::Init),
             R"#(Cancels the former definition and gives a FileName To be used when a Model has no well defined Header)#"  , py::arg("nameval")
          )
        .def("IsDone",
             (Standard_Boolean (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Boolean (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::IsDone),
             R"#(Returns True if all data have been defined (see also HasFn, HasFs, HasFd))#" 
          )
        .def("Apply",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<StepData_StepModel> &  ) const) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<StepData_StepModel> &  ) const>(&APIHeaderSection_MakeHeader::Apply),
             R"#(Creates an empty header for a new STEP model and allows the header fields to be completed.)#"  , py::arg("model")
          )
        .def("NewModel",
             (opencascade::handle<StepData_StepModel> (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_Protocol> &  ) const) static_cast<opencascade::handle<StepData_StepModel> (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_Protocol> &  ) const>(&APIHeaderSection_MakeHeader::NewModel),
             R"#(Builds a Header, creates a new StepModel, then applies the Header to the StepModel The Schema Name is taken from the Protocol (if it inherits from StepData, else it is left in blanks))#"  , py::arg("protocol")
          )
        .def("HasFn",
             (Standard_Boolean (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Boolean (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::HasFn),
             R"#(Checks whether there is a file_name entity. Returns True if there is one.)#" 
          )
        .def("FnValue",
             (opencascade::handle<HeaderSection_FileName> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<HeaderSection_FileName> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::FnValue),
             R"#(Returns the file_name entity. Returns an empty entity if the file_name entity is not initialized.)#" 
          )
        .def("SetName",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetName),
             R"#(None)#"  , py::arg("aName")
          )
        .def("Name",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::Name),
             R"#(Returns the name attribute for the file_name entity.)#" 
          )
        .def("SetTimeStamp",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetTimeStamp),
             R"#(None)#"  , py::arg("aTimeStamp")
          )
        .def("TimeStamp",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::TimeStamp),
             R"#(Returns the value of the time_stamp attribute for the file_name entity.)#" 
          )
        .def("SetAuthor",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetAuthor),
             R"#(None)#"  , py::arg("aAuthor")
          )
        .def("SetAuthorValue",
             (void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetAuthorValue),
             R"#(None)#"  , py::arg("num"),  py::arg("aAuthor")
          )
        .def("Author",
             (opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::Author),
             R"#(None)#" 
          )
        .def("AuthorValue",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const>(&APIHeaderSection_MakeHeader::AuthorValue),
             R"#(Returns the value of the name attribute for the file_name entity.)#"  , py::arg("num")
          )
        .def("NbAuthor",
             (Standard_Integer (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Integer (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::NbAuthor),
             R"#(Returns the number of values for the author attribute in the file_name entity.)#" 
          )
        .def("SetOrganization",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetOrganization),
             R"#(None)#"  , py::arg("aOrganization")
          )
        .def("SetOrganizationValue",
             (void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetOrganizationValue),
             R"#(None)#"  , py::arg("num"),  py::arg("aOrganization")
          )
        .def("Organization",
             (opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::Organization),
             R"#(None)#" 
          )
        .def("OrganizationValue",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const>(&APIHeaderSection_MakeHeader::OrganizationValue),
             R"#(Returns the value of attribute organization for the file_name entity.)#"  , py::arg("num")
          )
        .def("NbOrganization",
             (Standard_Integer (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Integer (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::NbOrganization),
             R"#(Returns the number of values for the organization attribute in the file_name entity.)#" 
          )
        .def("SetPreprocessorVersion",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetPreprocessorVersion),
             R"#(None)#"  , py::arg("aPreprocessorVersion")
          )
        .def("PreprocessorVersion",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::PreprocessorVersion),
             R"#(Returns the name of the preprocessor_version for the file_name entity.)#" 
          )
        .def("SetOriginatingSystem",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetOriginatingSystem),
             R"#(None)#"  , py::arg("aOriginatingSystem")
          )
        .def("OriginatingSystem",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::OriginatingSystem),
             R"#(None)#" 
          )
        .def("SetAuthorisation",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetAuthorisation),
             R"#(None)#"  , py::arg("aAuthorisation")
          )
        .def("Authorisation",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::Authorisation),
             R"#(Returns the value of the authorization attribute for the file_name entity.)#" 
          )
        .def("HasFs",
             (Standard_Boolean (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Boolean (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::HasFs),
             R"#(Checks whether there is a file_schema entity. Returns True if there is one.)#" 
          )
        .def("FsValue",
             (opencascade::handle<HeaderSection_FileSchema> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<HeaderSection_FileSchema> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::FsValue),
             R"#(Returns the file_schema entity. Returns an empty entity if the file_schema entity is not initialized.)#" 
          )
        .def("SetSchemaIdentifiers",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetSchemaIdentifiers),
             R"#(None)#"  , py::arg("aSchemaIdentifiers")
          )
        .def("SetSchemaIdentifiersValue",
             (void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetSchemaIdentifiersValue),
             R"#(None)#"  , py::arg("num"),  py::arg("aSchemaIdentifier")
          )
        .def("SchemaIdentifiers",
             (opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::SchemaIdentifiers),
             R"#(None)#" 
          )
        .def("SchemaIdentifiersValue",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const>(&APIHeaderSection_MakeHeader::SchemaIdentifiersValue),
             R"#(Returns the value of the schema_identifier attribute for the file_schema entity.)#"  , py::arg("num")
          )
        .def("NbSchemaIdentifiers",
             (Standard_Integer (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Integer (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::NbSchemaIdentifiers),
             R"#(Returns the number of values for the schema_identifier attribute in the file_schema entity.)#" 
          )
        .def("AddSchemaIdentifier",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::AddSchemaIdentifier),
             R"#(Add a subname of schema (if not yet in the list))#"  , py::arg("aSchemaIdentifier")
          )
        .def("HasFd",
             (Standard_Boolean (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Boolean (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::HasFd),
             R"#(Checks whether there is a file_description entity. Returns True if there is one.)#" 
          )
        .def("FdValue",
             (opencascade::handle<HeaderSection_FileDescription> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<HeaderSection_FileDescription> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::FdValue),
             R"#(Returns the file_description entity. Returns an empty entity if the file_description entity is not initialized.)#" 
          )
        .def("SetDescription",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<Interface_HArray1OfHAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetDescription),
             R"#(None)#"  , py::arg("aDescription")
          )
        .def("SetDescriptionValue",
             (void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const Standard_Integer ,  const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetDescriptionValue),
             R"#(None)#"  , py::arg("num"),  py::arg("aDescription")
          )
        .def("Description",
             (opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<Interface_HArray1OfHAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::Description),
             R"#(None)#" 
          )
        .def("DescriptionValue",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)( const Standard_Integer  ) const>(&APIHeaderSection_MakeHeader::DescriptionValue),
             R"#(Returns the value of the description attribute for the file_description entity.)#"  , py::arg("num")
          )
        .def("NbDescription",
             (Standard_Integer (APIHeaderSection_MakeHeader::*)() const) static_cast<Standard_Integer (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::NbDescription),
             R"#(Returns the number of values for the file_description entity in the STEP file header.)#" 
          )
        .def("SetImplementationLevel",
             (void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<void (APIHeaderSection_MakeHeader::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&APIHeaderSection_MakeHeader::SetImplementationLevel),
             R"#(None)#"  , py::arg("aImplementationLevel")
          )
        .def("ImplementationLevel",
             (opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const) static_cast<opencascade::handle<TCollection_HAsciiString> (APIHeaderSection_MakeHeader::*)() const>(&APIHeaderSection_MakeHeader::ImplementationLevel),
             R"#(Returns the value of the implementation_level attribute for the file_description entity.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/APIHeaderSection_EditHeader.hxx
// ./opencascade/APIHeaderSection_MakeHeader.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
