# SPDX-License-Identifier: GPL-2.0-only
# This file is part of Scapy RPC
# See https://scapy.net/ for more information
# Copyright (C) Gabriel Potter

# ms-srvs.idl compiled on 06/07/2025
# This file is a stripped version ! Use scapy-rpc for the full.
"""
RPC definitions for the following interfaces:
- srvsvc (v3.0): 4B324FC8-1670-01D3-1278-5A47BF6EE188
This file is auto-generated by midl-to-scapy, do not modify.
"""

import uuid

from scapy.fields import StrFixedLenField
from scapy.layers.dcerpc import (
    NDRPacket,
    DceRpcOp,
    NDRConfPacketListField,
    NDRConfStrLenField,
    NDRConfVarStrNullField,
    NDRConfVarStrNullFieldUtf16,
    NDRFullEmbPointerField,
    NDRFullPointerField,
    NDRIntField,
    NDRPacketField,
    NDRSignedIntField,
    NDRUnionField,
    register_dcerpc_interface,
)


class LPSHARE_INFO_0(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi0_netname", ""))
    ]


class SHARE_INFO_0_CONTAINER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntriesRead", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Buffer",
                [LPSHARE_INFO_0()],
                LPSHARE_INFO_0,
                size_is=lambda pkt: pkt.EntriesRead,
            )
        ),
    ]


class LPSHARE_INFO_1(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi1_netname", "")),
        NDRIntField("shi1_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi1_remark", "")),
    ]


class SHARE_INFO_1_CONTAINER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntriesRead", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Buffer",
                [LPSHARE_INFO_1()],
                LPSHARE_INFO_1,
                size_is=lambda pkt: pkt.EntriesRead,
            )
        ),
    ]


class LPSHARE_INFO_2(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi2_netname", "")),
        NDRIntField("shi2_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi2_remark", "")),
        NDRIntField("shi2_permissions", 0),
        NDRIntField("shi2_max_uses", 0),
        NDRIntField("shi2_current_uses", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi2_path", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi2_passwd", "")),
    ]


class SHARE_INFO_2_CONTAINER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntriesRead", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Buffer",
                [LPSHARE_INFO_2()],
                LPSHARE_INFO_2,
                size_is=lambda pkt: pkt.EntriesRead,
            )
        ),
    ]


class LPSHARE_INFO_501(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi501_netname", "")),
        NDRIntField("shi501_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi501_remark", "")),
        NDRIntField("shi501_flags", 0),
    ]


class SHARE_INFO_501_CONTAINER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntriesRead", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Buffer",
                [LPSHARE_INFO_501()],
                LPSHARE_INFO_501,
                size_is=lambda pkt: pkt.EntriesRead,
            )
        ),
    ]


class LPSHARE_INFO_502_I(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi502_netname", "")),
        NDRIntField("shi502_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi502_remark", "")),
        NDRIntField("shi502_permissions", 0),
        NDRIntField("shi502_max_uses", 0),
        NDRIntField("shi502_current_uses", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi502_path", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi502_passwd", "")),
        NDRIntField("shi502_reserved", None, size_of="shi502_security_descriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "shi502_security_descriptor",
                "",
                size_is=lambda pkt: pkt.shi502_reserved,
            )
        ),
    ]


class SHARE_INFO_502_CONTAINER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntriesRead", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Buffer",
                [LPSHARE_INFO_502_I()],
                LPSHARE_INFO_502_I,
                size_is=lambda pkt: pkt.EntriesRead,
            )
        ),
    ]


class LPSHARE_INFO_503_I(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi503_netname", "")),
        NDRIntField("shi503_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi503_remark", "")),
        NDRIntField("shi503_permissions", 0),
        NDRIntField("shi503_max_uses", 0),
        NDRIntField("shi503_current_uses", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi503_path", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi503_passwd", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi503_servername", "")),
        NDRIntField("shi503_reserved", None, size_of="shi503_security_descriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "shi503_security_descriptor",
                "",
                size_is=lambda pkt: pkt.shi503_reserved,
            )
        ),
    ]


class SHARE_INFO_503_CONTAINER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntriesRead", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Buffer",
                [LPSHARE_INFO_503_I()],
                LPSHARE_INFO_503_I,
                size_is=lambda pkt: pkt.EntriesRead,
            )
        ),
    ]


class LPSHARE_ENUM_STRUCT(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("Level", 0),
        NDRUnionField(
            [
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "ShareInfo",
                            SHARE_INFO_0_CONTAINER(),
                            SHARE_INFO_0_CONTAINER,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 0),
                        (lambda _, val: val.tag == 0),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "ShareInfo",
                            SHARE_INFO_1_CONTAINER(),
                            SHARE_INFO_1_CONTAINER,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "ShareInfo",
                            SHARE_INFO_2_CONTAINER(),
                            SHARE_INFO_2_CONTAINER,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "ShareInfo",
                            SHARE_INFO_501_CONTAINER(),
                            SHARE_INFO_501_CONTAINER,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 501),
                        (lambda _, val: val.tag == 501),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "ShareInfo",
                            SHARE_INFO_502_CONTAINER(),
                            SHARE_INFO_502_CONTAINER,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 502),
                        (lambda _, val: val.tag == 502),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "ShareInfo",
                            SHARE_INFO_503_CONTAINER(),
                            SHARE_INFO_503_CONTAINER,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 503),
                        (lambda _, val: val.tag == 503),
                    ),
                ),
            ],
            StrFixedLenField("ShareInfo", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
    ]


class NetrShareEnum_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRPacketField("InfoStruct", LPSHARE_ENUM_STRUCT(), LPSHARE_ENUM_STRUCT),
        NDRIntField("PreferedMaximumLength", 0),
        NDRFullPointerField(NDRIntField("ResumeHandle", 0)),
    ]


class NetrShareEnum_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("InfoStruct", LPSHARE_ENUM_STRUCT(), LPSHARE_ENUM_STRUCT),
        NDRIntField("TotalEntries", 0),
        NDRFullPointerField(NDRIntField("ResumeHandle", 0)),
        NDRIntField("status", 0),
    ]


class LPSHARE_INFO_1004(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("shi1004_remark", ""))
    ]


class LPSHARE_INFO_1006(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("shi1006_max_uses", 0)]


class LPSHARE_INFO_1501_I(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("shi1501_reserved", None, size_of="shi1501_security_descriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "shi1501_security_descriptor",
                "",
                size_is=lambda pkt: pkt.shi1501_reserved,
            )
        ),
    ]


class LPSHARE_INFO_1005(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("shi1005_flags", 0)]


class NetrShareGetInfo_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRConfVarStrNullFieldUtf16("NetName", ""),
        NDRIntField("Level", 0),
    ]


class NetrShareGetInfo_Response(NDRPacket):
    fields_desc = [
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField("InfoStruct", LPSHARE_INFO_0(), LPSHARE_INFO_0)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 0),
                        (lambda _, val: val.tag == 0),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("InfoStruct", LPSHARE_INFO_1(), LPSHARE_INFO_1)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("InfoStruct", LPSHARE_INFO_2(), LPSHARE_INFO_2)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSHARE_INFO_502_I(), LPSHARE_INFO_502_I
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 502),
                        (lambda _, val: val.tag == 502),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSHARE_INFO_1004(), LPSHARE_INFO_1004
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1004),
                        (lambda _, val: val.tag == 1004),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSHARE_INFO_1006(), LPSHARE_INFO_1006
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1006),
                        (lambda _, val: val.tag == 1006),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSHARE_INFO_1501_I(), LPSHARE_INFO_1501_I
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1501),
                        (lambda _, val: val.tag == 1501),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSHARE_INFO_1005(), LPSHARE_INFO_1005
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1005),
                        (lambda _, val: val.tag == 1005),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSHARE_INFO_501(), LPSHARE_INFO_501
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 501),
                        (lambda _, val: val.tag == 501),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSHARE_INFO_503_I(), LPSHARE_INFO_503_I
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 503),
                        (lambda _, val: val.tag == 503),
                    ),
                ),
            ],
            StrFixedLenField("InfoStruct", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class LPSERVER_INFO_100(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("sv100_platform_id", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv100_name", "")),
    ]


class LPSERVER_INFO_101(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("sv101_platform_id", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv101_name", "")),
        NDRIntField("sv101_version_major", 0),
        NDRIntField("sv101_version_minor", 0),
        NDRIntField("sv101_version_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv101_comment", "")),
    ]


class LPSERVER_INFO_102(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("sv102_platform_id", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv102_name", "")),
        NDRIntField("sv102_version_major", 0),
        NDRIntField("sv102_version_minor", 0),
        NDRIntField("sv102_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv102_comment", "")),
        NDRIntField("sv102_users", 0),
        NDRSignedIntField("sv102_disc", 0),
        NDRSignedIntField("sv102_hidden", 0),
        NDRIntField("sv102_announce", 0),
        NDRIntField("sv102_anndelta", 0),
        NDRIntField("sv102_licenses", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv102_userpath", "")),
    ]


class LPSERVER_INFO_103(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("sv103_platform_id", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv103_name", "")),
        NDRIntField("sv103_version_major", 0),
        NDRIntField("sv103_version_minor", 0),
        NDRIntField("sv103_type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv103_comment", "")),
        NDRIntField("sv103_users", 0),
        NDRSignedIntField("sv103_disc", 0),
        NDRSignedIntField("sv103_hidden", 0),
        NDRIntField("sv103_announce", 0),
        NDRIntField("sv103_anndelta", 0),
        NDRIntField("sv103_licenses", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv103_userpath", "")),
        NDRIntField("sv103_capabilities", 0),
    ]


class LPSERVER_INFO_502(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("sv502_sessopens", 0),
        NDRIntField("sv502_sessvcs", 0),
        NDRIntField("sv502_opensearch", 0),
        NDRIntField("sv502_sizreqbuf", 0),
        NDRIntField("sv502_initworkitems", 0),
        NDRIntField("sv502_maxworkitems", 0),
        NDRIntField("sv502_rawworkitems", 0),
        NDRIntField("sv502_irpstacksize", 0),
        NDRIntField("sv502_maxrawbuflen", 0),
        NDRIntField("sv502_sessusers", 0),
        NDRIntField("sv502_sessconns", 0),
        NDRIntField("sv502_maxpagedmemoryusage", 0),
        NDRIntField("sv502_maxnonpagedmemoryusage", 0),
        NDRSignedIntField("sv502_enablesoftcompat", 0),
        NDRSignedIntField("sv502_enableforcedlogoff", 0),
        NDRSignedIntField("sv502_timesource", 0),
        NDRSignedIntField("sv502_acceptdownlevelapis", 0),
        NDRSignedIntField("sv502_lmannounce", 0),
    ]


class LPSERVER_INFO_503(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("sv503_sessopens", 0),
        NDRIntField("sv503_sessvcs", 0),
        NDRIntField("sv503_opensearch", 0),
        NDRIntField("sv503_sizreqbuf", 0),
        NDRIntField("sv503_initworkitems", 0),
        NDRIntField("sv503_maxworkitems", 0),
        NDRIntField("sv503_rawworkitems", 0),
        NDRIntField("sv503_irpstacksize", 0),
        NDRIntField("sv503_maxrawbuflen", 0),
        NDRIntField("sv503_sessusers", 0),
        NDRIntField("sv503_sessconns", 0),
        NDRIntField("sv503_maxpagedmemoryusage", 0),
        NDRIntField("sv503_maxnonpagedmemoryusage", 0),
        NDRSignedIntField("sv503_enablesoftcompat", 0),
        NDRSignedIntField("sv503_enableforcedlogoff", 0),
        NDRSignedIntField("sv503_timesource", 0),
        NDRSignedIntField("sv503_acceptdownlevelapis", 0),
        NDRSignedIntField("sv503_lmannounce", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv503_domain", "")),
        NDRIntField("sv503_maxcopyreadlen", 0),
        NDRIntField("sv503_maxcopywritelen", 0),
        NDRIntField("sv503_minkeepsearch", 0),
        NDRIntField("sv503_maxkeepsearch", 0),
        NDRIntField("sv503_minkeepcomplsearch", 0),
        NDRIntField("sv503_maxkeepcomplsearch", 0),
        NDRIntField("sv503_threadcountadd", 0),
        NDRIntField("sv503_numblockthreads", 0),
        NDRIntField("sv503_scavtimeout", 0),
        NDRIntField("sv503_minrcvqueue", 0),
        NDRIntField("sv503_minfreeworkitems", 0),
        NDRIntField("sv503_xactmemsize", 0),
        NDRIntField("sv503_threadpriority", 0),
        NDRIntField("sv503_maxmpxct", 0),
        NDRIntField("sv503_oplockbreakwait", 0),
        NDRIntField("sv503_oplockbreakresponsewait", 0),
        NDRSignedIntField("sv503_enableoplocks", 0),
        NDRSignedIntField("sv503_enableoplockforceclose", 0),
        NDRSignedIntField("sv503_enablefcbopens", 0),
        NDRSignedIntField("sv503_enableraw", 0),
        NDRSignedIntField("sv503_enablesharednetdrives", 0),
        NDRIntField("sv503_minfreeconnections", 0),
        NDRIntField("sv503_maxfreeconnections", 0),
    ]


class LPSERVER_INFO_599(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("sv599_sessopens", 0),
        NDRIntField("sv599_sessvcs", 0),
        NDRIntField("sv599_opensearch", 0),
        NDRIntField("sv599_sizreqbuf", 0),
        NDRIntField("sv599_initworkitems", 0),
        NDRIntField("sv599_maxworkitems", 0),
        NDRIntField("sv599_rawworkitems", 0),
        NDRIntField("sv599_irpstacksize", 0),
        NDRIntField("sv599_maxrawbuflen", 0),
        NDRIntField("sv599_sessusers", 0),
        NDRIntField("sv599_sessconns", 0),
        NDRIntField("sv599_maxpagedmemoryusage", 0),
        NDRIntField("sv599_maxnonpagedmemoryusage", 0),
        NDRSignedIntField("sv599_enablesoftcompat", 0),
        NDRSignedIntField("sv599_enableforcedlogoff", 0),
        NDRSignedIntField("sv599_timesource", 0),
        NDRSignedIntField("sv599_acceptdownlevelapis", 0),
        NDRSignedIntField("sv599_lmannounce", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv599_domain", "")),
        NDRIntField("sv599_maxcopyreadlen", 0),
        NDRIntField("sv599_maxcopywritelen", 0),
        NDRIntField("sv599_minkeepsearch", 0),
        NDRIntField("sv599_maxkeepsearch", 0),
        NDRIntField("sv599_minkeepcomplsearch", 0),
        NDRIntField("sv599_maxkeepcomplsearch", 0),
        NDRIntField("sv599_threadcountadd", 0),
        NDRIntField("sv599_numblockthreads", 0),
        NDRIntField("sv599_scavtimeout", 0),
        NDRIntField("sv599_minrcvqueue", 0),
        NDRIntField("sv599_minfreeworkitems", 0),
        NDRIntField("sv599_xactmemsize", 0),
        NDRIntField("sv599_threadpriority", 0),
        NDRIntField("sv599_maxmpxct", 0),
        NDRIntField("sv599_oplockbreakwait", 0),
        NDRIntField("sv599_oplockbreakresponsewait", 0),
        NDRSignedIntField("sv599_enableoplocks", 0),
        NDRSignedIntField("sv599_enableoplockforceclose", 0),
        NDRSignedIntField("sv599_enablefcbopens", 0),
        NDRSignedIntField("sv599_enableraw", 0),
        NDRSignedIntField("sv599_enablesharednetdrives", 0),
        NDRIntField("sv599_minfreeconnections", 0),
        NDRIntField("sv599_maxfreeconnections", 0),
        NDRIntField("sv599_initsesstable", 0),
        NDRIntField("sv599_initconntable", 0),
        NDRIntField("sv599_initfiletable", 0),
        NDRIntField("sv599_initsearchtable", 0),
        NDRIntField("sv599_alertschedule", 0),
        NDRIntField("sv599_errorthreshold", 0),
        NDRIntField("sv599_networkerrorthreshold", 0),
        NDRIntField("sv599_diskspacethreshold", 0),
        NDRIntField("sv599_reserved", 0),
        NDRIntField("sv599_maxlinkdelay", 0),
        NDRIntField("sv599_minlinkthroughput", 0),
        NDRIntField("sv599_linkinfovalidtime", 0),
        NDRIntField("sv599_scavqosinfoupdatetime", 0),
        NDRIntField("sv599_maxworkitemidletime", 0),
    ]


class LPSERVER_INFO_1005(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("sv1005_comment", ""))
    ]


class LPSERVER_INFO_1107(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1107_users", 0)]


class LPSERVER_INFO_1010(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1010_disc", 0)]


class LPSERVER_INFO_1016(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1016_hidden", 0)]


class LPSERVER_INFO_1017(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1017_announce", 0)]


class LPSERVER_INFO_1018(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1018_anndelta", 0)]


class LPSERVER_INFO_1501(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1501_sessopens", 0)]


class LPSERVER_INFO_1502(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1502_sessvcs", 0)]


class LPSERVER_INFO_1503(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1503_opensearch", 0)]


class LPSERVER_INFO_1506(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1506_maxworkitems", 0)]


class LPSERVER_INFO_1510(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1510_sessusers", 0)]


class LPSERVER_INFO_1511(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1511_sessconns", 0)]


class LPSERVER_INFO_1512(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1512_maxnonpagedmemoryusage", 0)]


class LPSERVER_INFO_1513(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1513_maxpagedmemoryusage", 0)]


class LPSERVER_INFO_1514(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1514_enablesoftcompat", 0)]


class LPSERVER_INFO_1515(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1515_enableforcedlogoff", 0)]


class LPSERVER_INFO_1516(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1516_timesource", 0)]


class LPSERVER_INFO_1518(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1518_lmannounce", 0)]


class LPSERVER_INFO_1523(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1523_maxkeepsearch", 0)]


class LPSERVER_INFO_1528(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1528_scavtimeout", 0)]


class LPSERVER_INFO_1529(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1529_minrcvqueue", 0)]


class LPSERVER_INFO_1530(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1530_minfreeworkitems", 0)]


class LPSERVER_INFO_1533(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1533_maxmpxct", 0)]


class LPSERVER_INFO_1534(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1534_oplockbreakwait", 0)]


class LPSERVER_INFO_1535(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1535_oplockbreakresponsewait", 0)]


class LPSERVER_INFO_1536(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1536_enableoplocks", 0)]


class LPSERVER_INFO_1538(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1538_enablefcbopens", 0)]


class LPSERVER_INFO_1539(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1539_enableraw", 0)]


class LPSERVER_INFO_1540(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1540_enablesharednetdrives", 0)]


class LPSERVER_INFO_1541(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1541_minfreeconnections", 0)]


class LPSERVER_INFO_1542(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRSignedIntField("sv1542_maxfreeconnections", 0)]


class LPSERVER_INFO_1543(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1543_initsesstable", 0)]


class LPSERVER_INFO_1544(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1544_initconntable", 0)]


class LPSERVER_INFO_1545(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1545_initfiletable", 0)]


class LPSERVER_INFO_1546(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1546_initsearchtable", 0)]


class LPSERVER_INFO_1547(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1547_alertschedule", 0)]


class LPSERVER_INFO_1548(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1548_errorthreshold", 0)]


class LPSERVER_INFO_1549(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1549_networkerrorthreshold", 0)]


class LPSERVER_INFO_1550(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1550_diskspacethreshold", 0)]


class LPSERVER_INFO_1552(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1552_maxlinkdelay", 0)]


class LPSERVER_INFO_1553(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1553_minlinkthroughput", 0)]


class LPSERVER_INFO_1554(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1554_linkinfovalidtime", 0)]


class LPSERVER_INFO_1555(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1555_scavqosinfoupdatetime", 0)]


class LPSERVER_INFO_1556(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("sv1556_maxworkitemidletime", 0)]


class NetrServerGetInfo_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("Level", 0),
    ]


class NetrServerGetInfo_Response(NDRPacket):
    fields_desc = [
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_100(), LPSERVER_INFO_100
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 100),
                        (lambda _, val: val.tag == 100),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_101(), LPSERVER_INFO_101
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 101),
                        (lambda _, val: val.tag == 101),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_102(), LPSERVER_INFO_102
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 102),
                        (lambda _, val: val.tag == 102),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_103(), LPSERVER_INFO_103
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 103),
                        (lambda _, val: val.tag == 103),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_502(), LPSERVER_INFO_502
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 502),
                        (lambda _, val: val.tag == 502),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_503(), LPSERVER_INFO_503
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 503),
                        (lambda _, val: val.tag == 503),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_599(), LPSERVER_INFO_599
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 599),
                        (lambda _, val: val.tag == 599),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1005(), LPSERVER_INFO_1005
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1005),
                        (lambda _, val: val.tag == 1005),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1107(), LPSERVER_INFO_1107
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1107),
                        (lambda _, val: val.tag == 1107),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1010(), LPSERVER_INFO_1010
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1010),
                        (lambda _, val: val.tag == 1010),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1016(), LPSERVER_INFO_1016
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1016),
                        (lambda _, val: val.tag == 1016),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1017(), LPSERVER_INFO_1017
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1017),
                        (lambda _, val: val.tag == 1017),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1018(), LPSERVER_INFO_1018
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1018),
                        (lambda _, val: val.tag == 1018),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1501(), LPSERVER_INFO_1501
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1501),
                        (lambda _, val: val.tag == 1501),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1502(), LPSERVER_INFO_1502
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1502),
                        (lambda _, val: val.tag == 1502),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1503(), LPSERVER_INFO_1503
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1503),
                        (lambda _, val: val.tag == 1503),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1506(), LPSERVER_INFO_1506
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1506),
                        (lambda _, val: val.tag == 1506),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1510(), LPSERVER_INFO_1510
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1510),
                        (lambda _, val: val.tag == 1510),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1511(), LPSERVER_INFO_1511
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1511),
                        (lambda _, val: val.tag == 1511),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1512(), LPSERVER_INFO_1512
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1512),
                        (lambda _, val: val.tag == 1512),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1513(), LPSERVER_INFO_1513
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1513),
                        (lambda _, val: val.tag == 1513),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1514(), LPSERVER_INFO_1514
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1514),
                        (lambda _, val: val.tag == 1514),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1515(), LPSERVER_INFO_1515
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1515),
                        (lambda _, val: val.tag == 1515),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1516(), LPSERVER_INFO_1516
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1516),
                        (lambda _, val: val.tag == 1516),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1518(), LPSERVER_INFO_1518
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1518),
                        (lambda _, val: val.tag == 1518),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1523(), LPSERVER_INFO_1523
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1523),
                        (lambda _, val: val.tag == 1523),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1528(), LPSERVER_INFO_1528
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1528),
                        (lambda _, val: val.tag == 1528),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1529(), LPSERVER_INFO_1529
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1529),
                        (lambda _, val: val.tag == 1529),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1530(), LPSERVER_INFO_1530
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1530),
                        (lambda _, val: val.tag == 1530),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1533(), LPSERVER_INFO_1533
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1533),
                        (lambda _, val: val.tag == 1533),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1534(), LPSERVER_INFO_1534
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1534),
                        (lambda _, val: val.tag == 1534),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1535(), LPSERVER_INFO_1535
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1535),
                        (lambda _, val: val.tag == 1535),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1536(), LPSERVER_INFO_1536
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1536),
                        (lambda _, val: val.tag == 1536),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1538(), LPSERVER_INFO_1538
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1538),
                        (lambda _, val: val.tag == 1538),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1539(), LPSERVER_INFO_1539
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1539),
                        (lambda _, val: val.tag == 1539),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1540(), LPSERVER_INFO_1540
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1540),
                        (lambda _, val: val.tag == 1540),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1541(), LPSERVER_INFO_1541
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1541),
                        (lambda _, val: val.tag == 1541),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1542(), LPSERVER_INFO_1542
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1542),
                        (lambda _, val: val.tag == 1542),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1543(), LPSERVER_INFO_1543
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1543),
                        (lambda _, val: val.tag == 1543),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1544(), LPSERVER_INFO_1544
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1544),
                        (lambda _, val: val.tag == 1544),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1545(), LPSERVER_INFO_1545
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1545),
                        (lambda _, val: val.tag == 1545),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1546(), LPSERVER_INFO_1546
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1546),
                        (lambda _, val: val.tag == 1546),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1547(), LPSERVER_INFO_1547
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1547),
                        (lambda _, val: val.tag == 1547),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1548(), LPSERVER_INFO_1548
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1548),
                        (lambda _, val: val.tag == 1548),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1549(), LPSERVER_INFO_1549
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1549),
                        (lambda _, val: val.tag == 1549),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1550(), LPSERVER_INFO_1550
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1550),
                        (lambda _, val: val.tag == 1550),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1552(), LPSERVER_INFO_1552
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1552),
                        (lambda _, val: val.tag == 1552),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1553(), LPSERVER_INFO_1553
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1553),
                        (lambda _, val: val.tag == 1553),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1554(), LPSERVER_INFO_1554
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1554),
                        (lambda _, val: val.tag == 1554),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1555(), LPSERVER_INFO_1555
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1555),
                        (lambda _, val: val.tag == 1555),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "InfoStruct", LPSERVER_INFO_1556(), LPSERVER_INFO_1556
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1556),
                        (lambda _, val: val.tag == 1556),
                    ),
                ),
            ],
            StrFixedLenField("InfoStruct", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


SRVSVC_OPNUMS = {  # 0: Opnum0NotUsedOnWire,
    # 1: Opnum1NotUsedOnWire,
    # 2: Opnum2NotUsedOnWire,
    # 3: Opnum3NotUsedOnWire,
    # 4: Opnum4NotUsedOnWire,
    # 5: Opnum5NotUsedOnWire,
    # 6: Opnum6NotUsedOnWire,
    # 7: Opnum7NotUsedOnWire,
    15: DceRpcOp(NetrShareEnum_Request, NetrShareEnum_Response),
    16: DceRpcOp(NetrShareGetInfo_Request, NetrShareGetInfo_Response),
    21: DceRpcOp(NetrServerGetInfo_Request, NetrServerGetInfo_Response),
    # 29: Opnum29NotUsedOnWire,
    # 42: Opnum42NotUsedOnWire,
    # 47: Opnum47NotUsedOnWire
}
register_dcerpc_interface(
    name="srvsvc",
    uuid=uuid.UUID("4B324FC8-1670-01D3-1278-5A47BF6EE188"),
    version="3.0",
    opnums=SRVSVC_OPNUMS,
)
