## TFSA-2022-160: `CHECK` fail via inputs in `SparseFillEmptyRowsGrad`

### CVE Number
CVE-2022-41898

### Impact
If [`SparseFillEmptyRowsGrad`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/sparse_fill_empty_rows_op_gpu.cu.cc) is given empty inputs, TensorFlow will crash.

```python
import tensorflow as tf
tf.raw_ops.SparseFillEmptyRowsGrad(
    reverse_index_map=[], grad_values=[], name=None
)
```

### Patches
We have patched the issue in GitHub commit [af4a6a3c8b95022c351edae94560acc61253a1b8](https://github.com/tensorflow/tensorflow/commit/af4a6a3c8b95022c351edae94560acc61253a1b8).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Jiawei Liu, PhD student at University of Illinois, Urbana-Champaign.
